<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CeuCredit StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CeuCredit extends AbstractStructBase
{
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $externalId = null;
    /**
     * The creditStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $creditStatus = null;
    /**
     * The creditType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $creditType = null;
    /**
     * The productStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $productStatus = null;
    /**
     * The productScore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float|null
     */
    protected ?float $productScore = null;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string|null
     */
    protected ?string $productId;
    /**
     * The grantDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $grantDate;
    /**
     * The creditValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float|null
     */
    protected ?float $creditValue;
    /**
     * The productCompletionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $productCompletionDate;
    /**
     * Constructor method for CeuCredit
     * @uses CeuCredit::setExternalId()
     * @uses CeuCredit::setCreditStatus()
     * @uses CeuCredit::setCreditType()
     * @uses CeuCredit::setProductStatus()
     * @uses CeuCredit::setProductScore()
     * @uses CeuCredit::setProductId()
     * @uses CeuCredit::setGrantDate()
     * @uses CeuCredit::setCreditValue()
     * @uses CeuCredit::setProductCompletionDate()
     * @param string $externalId
     * @param string $creditStatus
     * @param string $creditType
     * @param string $productStatus
     * @param float $productScore
     * @param string $productId
     * @param string $grantDate
     * @param float $creditValue
     * @param string $productCompletionDate
     */
    public function __construct(?string $externalId = null, ?string $creditStatus = null, ?string $creditType = null, ?string $productStatus = null, ?float $productScore = null, ?string $productId, ?string $grantDate, ?float $creditValue, ?string $productCompletionDate)
    {
        $this
            ->setExternalId($externalId)
            ->setCreditStatus($creditStatus)
            ->setCreditType($creditType)
            ->setProductStatus($productStatus)
            ->setProductScore($productScore)
            ->setProductId($productId)
            ->setGrantDate($grantDate)
            ->setCreditValue($creditValue)
            ->setProductCompletionDate($productCompletionDate);
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId(): ?string
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit
     */
    public function setExternalId(?string $externalId = null): self
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        
        return $this;
    }
    /**
     * Get creditStatus value
     * @return string|null
     */
    public function getCreditStatus(): ?string
    {
        return $this->creditStatus;
    }
    /**
     * Set creditStatus value
     * @param string $creditStatus
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit
     */
    public function setCreditStatus(?string $creditStatus = null): self
    {
        // validation for constraint: string
        if (!is_null($creditStatus) && !is_string($creditStatus)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditStatus, true), gettype($creditStatus)), __LINE__);
        }
        $this->creditStatus = $creditStatus;
        
        return $this;
    }
    /**
     * Get creditType value
     * @return string|null
     */
    public function getCreditType(): ?string
    {
        return $this->creditType;
    }
    /**
     * Set creditType value
     * @param string $creditType
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit
     */
    public function setCreditType(?string $creditType = null): self
    {
        // validation for constraint: string
        if (!is_null($creditType) && !is_string($creditType)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditType, true), gettype($creditType)), __LINE__);
        }
        $this->creditType = $creditType;
        
        return $this;
    }
    /**
     * Get productStatus value
     * @return string|null
     */
    public function getProductStatus(): ?string
    {
        return $this->productStatus;
    }
    /**
     * Set productStatus value
     * @param string $productStatus
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit
     */
    public function setProductStatus(?string $productStatus = null): self
    {
        // validation for constraint: string
        if (!is_null($productStatus) && !is_string($productStatus)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productStatus, true), gettype($productStatus)), __LINE__);
        }
        $this->productStatus = $productStatus;
        
        return $this;
    }
    /**
     * Get productScore value
     * @return float|null
     */
    public function getProductScore(): ?float
    {
        return $this->productScore;
    }
    /**
     * Set productScore value
     * @param float $productScore
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit
     */
    public function setProductScore(?float $productScore = null): self
    {
        // validation for constraint: float
        if (!is_null($productScore) && !(is_float($productScore) || is_numeric($productScore))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($productScore, true), gettype($productScore)), __LINE__);
        }
        $this->productScore = $productScore;
        
        return $this;
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId(): ?string
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit
     */
    public function setProductId(?string $productId): self
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $productId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($productId, true)), __LINE__);
        }
        $this->productId = $productId;
        
        return $this;
    }
    /**
     * Get grantDate value
     * @return string|null
     */
    public function getGrantDate(): ?string
    {
        return $this->grantDate;
    }
    /**
     * Set grantDate value
     * @param string $grantDate
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit
     */
    public function setGrantDate(?string $grantDate): self
    {
        // validation for constraint: string
        if (!is_null($grantDate) && !is_string($grantDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grantDate, true), gettype($grantDate)), __LINE__);
        }
        $this->grantDate = $grantDate;
        
        return $this;
    }
    /**
     * Get creditValue value
     * @return float|null
     */
    public function getCreditValue(): ?float
    {
        return $this->creditValue;
    }
    /**
     * Set creditValue value
     * @param float $creditValue
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit
     */
    public function setCreditValue(?float $creditValue): self
    {
        // validation for constraint: float
        if (!is_null($creditValue) && !(is_float($creditValue) || is_numeric($creditValue))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditValue, true), gettype($creditValue)), __LINE__);
        }
        $this->creditValue = $creditValue;
        
        return $this;
    }
    /**
     * Get productCompletionDate value
     * @return string|null
     */
    public function getProductCompletionDate(): ?string
    {
        return $this->productCompletionDate;
    }
    /**
     * Set productCompletionDate value
     * @param string $productCompletionDate
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit
     */
    public function setProductCompletionDate(?string $productCompletionDate): self
    {
        // validation for constraint: string
        if (!is_null($productCompletionDate) && !is_string($productCompletionDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCompletionDate, true), gettype($productCompletionDate)), __LINE__);
        }
        $this->productCompletionDate = $productCompletionDate;
        
        return $this;
    }
}
