<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChapterType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ChapterType extends AbstractStructBase
{
    /**
     * The Chapter
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Chapter_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Chapter_DataObjectType $Chapter = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Customer_DataObjectType $Customer = null;
    /**
     * The Association
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Association_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Association_DataObjectType $Association = null;
    /**
     * The Email
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Email_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Email_DataObjectType $Email = null;
    /**
     * The Website
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Website_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Website_DataObjectType $Website = null;
    /**
     * The Messaging
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Messaging_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Messaging_DataObjectType $Messaging = null;
    /**
     * The Phone
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_DataObjectType $Phone = null;
    /**
     * The Phone_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_XRef_DataObjectType $Phone_XRef = null;
    /**
     * The Fax
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_DataObjectType $Fax = null;
    /**
     * The Fax_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType $Fax_XRef = null;
    /**
     * The Address_1
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_1_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_1_DataObjectType $Address_1 = null;
    /**
     * The Address_XRef_1
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_XRef_1_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_XRef_1_DataObjectType $Address_XRef_1 = null;
    /**
     * The Address_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Country_DataObjectType $Address_Country = null;
    /**
     * The Billing_Address_1
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_1_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_1_DataObjectType $Billing_Address_1 = null;
    /**
     * The Billing_Address_XRef_1
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_XRef_1_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_XRef_1_DataObjectType $Billing_Address_XRef_1 = null;
    /**
     * The Primary_Contact
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_DataObjectType $Primary_Contact = null;
    /**
     * The Primary_Contact_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType $Primary_Contact_XRef = null;
    /**
     * The Prim__Contact_Adr_Xref
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Adr_Xref_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Adr_Xref_DataObjectType $Prim__Contact_Adr_Xref = null;
    /**
     * The Prim__Contact_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType $Prim__Contact_Address = null;
    /**
     * The Address_Change_Log
     * @var \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Change_Log_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Change_Log_DataObjectType $Address_Change_Log = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Chapter Customer Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for ChapterType
     * @uses ChapterType::setChapter()
     * @uses ChapterType::setCustomer()
     * @uses ChapterType::setAssociation()
     * @uses ChapterType::setEmail()
     * @uses ChapterType::setWebsite()
     * @uses ChapterType::setMessaging()
     * @uses ChapterType::setPhone()
     * @uses ChapterType::setPhone_XRef()
     * @uses ChapterType::setFax()
     * @uses ChapterType::setFax_XRef()
     * @uses ChapterType::setAddress_1()
     * @uses ChapterType::setAddress_XRef_1()
     * @uses ChapterType::setAddress_Country()
     * @uses ChapterType::setBilling_Address_1()
     * @uses ChapterType::setBilling_Address_XRef_1()
     * @uses ChapterType::setPrimary_Contact()
     * @uses ChapterType::setPrimary_Contact_XRef()
     * @uses ChapterType::setPrim__Contact_Adr_Xref()
     * @uses ChapterType::setPrim__Contact_Address()
     * @uses ChapterType::setAddress_Change_Log()
     * @uses ChapterType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Chapter_DataObjectType $chapter
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Association_DataObjectType $association
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Email_DataObjectType $email
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Website_DataObjectType $website
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Messaging_DataObjectType $messaging
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_DataObjectType $phone
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_XRef_DataObjectType $phone_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_DataObjectType $fax
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType $fax_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_1_DataObjectType $address_1
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_XRef_1_DataObjectType $address_XRef_1
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Country_DataObjectType $address_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_1_DataObjectType $billing_Address_1
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_XRef_1_DataObjectType $billing_Address_XRef_1
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_DataObjectType $primary_Contact
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType $primary_Contact_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Adr_Xref_DataObjectType $prim__Contact_Adr_Xref
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType $prim__Contact_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Change_Log_DataObjectType $address_Change_Log
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Chapter_DataObjectType $chapter = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Association_DataObjectType $association = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Email_DataObjectType $email = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Website_DataObjectType $website = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Messaging_DataObjectType $messaging = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_DataObjectType $phone = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_XRef_DataObjectType $phone_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_DataObjectType $fax = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType $fax_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_1_DataObjectType $address_1 = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_XRef_1_DataObjectType $address_XRef_1 = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Country_DataObjectType $address_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_1_DataObjectType $billing_Address_1 = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_XRef_1_DataObjectType $billing_Address_XRef_1 = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_DataObjectType $primary_Contact = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType $primary_Contact_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Adr_Xref_DataObjectType $prim__Contact_Adr_Xref = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType $prim__Contact_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Change_Log_DataObjectType $address_Change_Log = null, ?string $currentKey = null)
    {
        $this
            ->setChapter($chapter)
            ->setCustomer($customer)
            ->setAssociation($association)
            ->setEmail($email)
            ->setWebsite($website)
            ->setMessaging($messaging)
            ->setPhone($phone)
            ->setPhone_XRef($phone_XRef)
            ->setFax($fax)
            ->setFax_XRef($fax_XRef)
            ->setAddress_1($address_1)
            ->setAddress_XRef_1($address_XRef_1)
            ->setAddress_Country($address_Country)
            ->setBilling_Address_1($billing_Address_1)
            ->setBilling_Address_XRef_1($billing_Address_XRef_1)
            ->setPrimary_Contact($primary_Contact)
            ->setPrimary_Contact_XRef($primary_Contact_XRef)
            ->setPrim__Contact_Adr_Xref($prim__Contact_Adr_Xref)
            ->setPrim__Contact_Address($prim__Contact_Address)
            ->setAddress_Change_Log($address_Change_Log)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Chapter value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Chapter_DataObjectType|null
     */
    public function getChapter(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Chapter_DataObjectType
    {
        return $this->Chapter;
    }
    /**
     * Set Chapter value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Chapter_DataObjectType $chapter
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setChapter(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Chapter_DataObjectType $chapter = null): self
    {
        $this->Chapter = $chapter;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Association value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Association_DataObjectType|null
     */
    public function getAssociation(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Association_DataObjectType
    {
        return $this->Association;
    }
    /**
     * Set Association value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Association_DataObjectType $association
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setAssociation(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Association_DataObjectType $association = null): self
    {
        $this->Association = $association;
        
        return $this;
    }
    /**
     * Get Email value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Email_DataObjectType|null
     */
    public function getEmail(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Email_DataObjectType
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Email_DataObjectType $email
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setEmail(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Email_DataObjectType $email = null): self
    {
        $this->Email = $email;
        
        return $this;
    }
    /**
     * Get Website value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Website_DataObjectType|null
     */
    public function getWebsite(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Website_DataObjectType
    {
        return $this->Website;
    }
    /**
     * Set Website value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Website_DataObjectType $website
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setWebsite(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Website_DataObjectType $website = null): self
    {
        $this->Website = $website;
        
        return $this;
    }
    /**
     * Get Messaging value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Messaging_DataObjectType|null
     */
    public function getMessaging(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Messaging_DataObjectType
    {
        return $this->Messaging;
    }
    /**
     * Set Messaging value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Messaging_DataObjectType $messaging
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setMessaging(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Messaging_DataObjectType $messaging = null): self
    {
        $this->Messaging = $messaging;
        
        return $this;
    }
    /**
     * Get Phone value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_DataObjectType|null
     */
    public function getPhone(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_DataObjectType
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_DataObjectType $phone
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setPhone(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_DataObjectType $phone = null): self
    {
        $this->Phone = $phone;
        
        return $this;
    }
    /**
     * Get Phone_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_XRef_DataObjectType|null
     */
    public function getPhone_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_XRef_DataObjectType
    {
        return $this->Phone_XRef;
    }
    /**
     * Set Phone_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_XRef_DataObjectType $phone_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setPhone_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Phone_XRef_DataObjectType $phone_XRef = null): self
    {
        $this->Phone_XRef = $phone_XRef;
        
        return $this;
    }
    /**
     * Get Fax value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_DataObjectType|null
     */
    public function getFax(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_DataObjectType
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_DataObjectType $fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setFax(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_DataObjectType $fax = null): self
    {
        $this->Fax = $fax;
        
        return $this;
    }
    /**
     * Get Fax_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType|null
     */
    public function getFax_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
    {
        return $this->Fax_XRef;
    }
    /**
     * Set Fax_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType $fax_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setFax_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType $fax_XRef = null): self
    {
        $this->Fax_XRef = $fax_XRef;
        
        return $this;
    }
    /**
     * Get address value
     * @return address
     */
    public function getAddress_1(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_1_DataObjectType
    {
        return $this->Address_1;
    }
    /**
     * Set address value
     * @param address $address
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setAddress_1(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_1_DataObjectType $address_1 = null): self
    {
        $this->Address_1 = $address_1;
        
        return $this;
    }
    /**
     * Get address_XRef value
     * @return address_XRef
     */
    public function getAddress_XRef_1(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_XRef_1_DataObjectType
    {
        return $this->Address_XRef_1;
    }
    /**
     * Set address_XRef value
     * @param address_XRef $address_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setAddress_XRef_1(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_XRef_1_DataObjectType $address_XRef_1 = null): self
    {
        $this->Address_XRef_1 = $address_XRef_1;
        
        return $this;
    }
    /**
     * Get Address_Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Country_DataObjectType|null
     */
    public function getAddress_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Country_DataObjectType
    {
        return $this->Address_Country;
    }
    /**
     * Set Address_Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Country_DataObjectType $address_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setAddress_Country(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Country_DataObjectType $address_Country = null): self
    {
        $this->Address_Country = $address_Country;
        
        return $this;
    }
    /**
     * Get billing_Address value
     * @return billing_Address
     */
    public function getBilling_Address_1(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_1_DataObjectType
    {
        return $this->Billing_Address_1;
    }
    /**
     * Set billing_Address value
     * @param billing_Address $billing_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setBilling_Address_1(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_1_DataObjectType $billing_Address_1 = null): self
    {
        $this->Billing_Address_1 = $billing_Address_1;
        
        return $this;
    }
    /**
     * Get billing_Address_XRef value
     * @return billing_Address_XRef
     */
    public function getBilling_Address_XRef_1(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_XRef_1_DataObjectType
    {
        return $this->Billing_Address_XRef_1;
    }
    /**
     * Set billing_Address_XRef value
     * @param billing_Address_XRef $billing_Address_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setBilling_Address_XRef_1(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Billing_Address_XRef_1_DataObjectType $billing_Address_XRef_1 = null): self
    {
        $this->Billing_Address_XRef_1 = $billing_Address_XRef_1;
        
        return $this;
    }
    /**
     * Get Primary_Contact value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_DataObjectType|null
     */
    public function getPrimary_Contact(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_DataObjectType
    {
        return $this->Primary_Contact;
    }
    /**
     * Set Primary_Contact value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_DataObjectType $primary_Contact
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setPrimary_Contact(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_DataObjectType $primary_Contact = null): self
    {
        $this->Primary_Contact = $primary_Contact;
        
        return $this;
    }
    /**
     * Get Primary_Contact_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType|null
     */
    public function getPrimary_Contact_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
    {
        return $this->Primary_Contact_XRef;
    }
    /**
     * Set Primary_Contact_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType $primary_Contact_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setPrimary_Contact_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType $primary_Contact_XRef = null): self
    {
        $this->Primary_Contact_XRef = $primary_Contact_XRef;
        
        return $this;
    }
    /**
     * Get Prim__Contact_Adr_Xref value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Adr_Xref_DataObjectType|null
     */
    public function getPrim__Contact_Adr_Xref(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Adr_Xref_DataObjectType
    {
        return $this->{'Prim._Contact_Adr_Xref'};
    }
    /**
     * Set Prim__Contact_Adr_Xref value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Adr_Xref_DataObjectType $prim__Contact_Adr_Xref
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setPrim__Contact_Adr_Xref(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Adr_Xref_DataObjectType $prim__Contact_Adr_Xref = null): self
    {
        $this->Prim__Contact_Adr_Xref = $this->{'Prim._Contact_Adr_Xref'} = $prim__Contact_Adr_Xref;
        
        return $this;
    }
    /**
     * Get Prim__Contact_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType|null
     */
    public function getPrim__Contact_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
    {
        return $this->{'Prim._Contact_Address'};
    }
    /**
     * Set Prim__Contact_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType $prim__Contact_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setPrim__Contact_Address(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType $prim__Contact_Address = null): self
    {
        $this->Prim__Contact_Address = $this->{'Prim._Contact_Address'} = $prim__Contact_Address;
        
        return $this;
    }
    /**
     * Get Address_Change_Log value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Change_Log_DataObjectType|null
     */
    public function getAddress_Change_Log(): ?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Change_Log_DataObjectType
    {
        return $this->Address_Change_Log;
    }
    /**
     * Set Address_Change_Log value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Change_Log_DataObjectType $address_Change_Log
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setAddress_Change_Log(?\Drupal\netforum\xWeb\Generated\StructType\Chapter_Address_Change_Log_DataObjectType $address_Change_Log = null): self
    {
        $this->Address_Change_Log = $address_Change_Log;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\ChapterType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
