<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitteeNominationsType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CommitteeNominationsType extends AbstractStructBase
{
    /**
     * The Nominations
     * @var \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType $Nominations = null;
    /**
     * The Nominee
     * @var \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominee_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominee_DataObjectType $Nominee = null;
    /**
     * The Nominated_By
     * @var \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominated_By_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominated_By_DataObjectType $Nominated_By = null;
    /**
     * The Committee
     * @var \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType $Committee = null;
    /**
     * The Committee_Nomination_Status
     * @var \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType $Committee_Nomination_Status = null;
    /**
     * The Committee_Position
     * @var \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType $Committee_Position = null;
    /**
     * The Committee_Position_Codes
     * @var \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType $Committee_Position_Codes = null;
    /**
     * The Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Address_DataObjectType $Address = null;
    /**
     * The Individual
     * @var \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Individual_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Individual_DataObjectType $Individual = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Unique Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for CommitteeNominationsType
     * @uses CommitteeNominationsType::setNominations()
     * @uses CommitteeNominationsType::setNominee()
     * @uses CommitteeNominationsType::setNominated_By()
     * @uses CommitteeNominationsType::setCommittee()
     * @uses CommitteeNominationsType::setCommittee_Nomination_Status()
     * @uses CommitteeNominationsType::setCommittee_Position()
     * @uses CommitteeNominationsType::setCommittee_Position_Codes()
     * @uses CommitteeNominationsType::setAddress()
     * @uses CommitteeNominationsType::setIndividual()
     * @uses CommitteeNominationsType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType $nominations
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominee_DataObjectType $nominee
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominated_By_DataObjectType $nominated_By
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType $committee
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType $committee_Nomination_Status
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType $committee_Position
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType $committee_Position_Codes
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Address_DataObjectType $address
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Individual_DataObjectType $individual
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType $nominations = null, ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominee_DataObjectType $nominee = null, ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominated_By_DataObjectType $nominated_By = null, ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType $committee = null, ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType $committee_Nomination_Status = null, ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType $committee_Position = null, ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType $committee_Position_Codes = null, ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Address_DataObjectType $address = null, ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Individual_DataObjectType $individual = null, ?string $currentKey = null)
    {
        $this
            ->setNominations($nominations)
            ->setNominee($nominee)
            ->setNominated_By($nominated_By)
            ->setCommittee($committee)
            ->setCommittee_Nomination_Status($committee_Nomination_Status)
            ->setCommittee_Position($committee_Position)
            ->setCommittee_Position_Codes($committee_Position_Codes)
            ->setAddress($address)
            ->setIndividual($individual)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Nominations value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType|null
     */
    public function getNominations(): ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
    {
        return $this->Nominations;
    }
    /**
     * Set Nominations value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType $nominations
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setNominations(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType $nominations = null): self
    {
        $this->Nominations = $nominations;
        
        return $this;
    }
    /**
     * Get Nominee value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominee_DataObjectType|null
     */
    public function getNominee(): ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominee_DataObjectType
    {
        return $this->Nominee;
    }
    /**
     * Set Nominee value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominee_DataObjectType $nominee
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setNominee(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominee_DataObjectType $nominee = null): self
    {
        $this->Nominee = $nominee;
        
        return $this;
    }
    /**
     * Get Nominated_By value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominated_By_DataObjectType|null
     */
    public function getNominated_By(): ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominated_By_DataObjectType
    {
        return $this->Nominated_By;
    }
    /**
     * Set Nominated_By value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominated_By_DataObjectType $nominated_By
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setNominated_By(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominated_By_DataObjectType $nominated_By = null): self
    {
        $this->Nominated_By = $nominated_By;
        
        return $this;
    }
    /**
     * Get Committee value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType|null
     */
    public function getCommittee(): ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
    {
        return $this->Committee;
    }
    /**
     * Set Committee value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType $committee
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setCommittee(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType $committee = null): self
    {
        $this->Committee = $committee;
        
        return $this;
    }
    /**
     * Get Committee_Nomination_Status value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType|null
     */
    public function getCommittee_Nomination_Status(): ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
    {
        return $this->Committee_Nomination_Status;
    }
    /**
     * Set Committee_Nomination_Status value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType $committee_Nomination_Status
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setCommittee_Nomination_Status(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType $committee_Nomination_Status = null): self
    {
        $this->Committee_Nomination_Status = $committee_Nomination_Status;
        
        return $this;
    }
    /**
     * Get Committee_Position value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType|null
     */
    public function getCommittee_Position(): ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
    {
        return $this->Committee_Position;
    }
    /**
     * Set Committee_Position value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType $committee_Position
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setCommittee_Position(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType $committee_Position = null): self
    {
        $this->Committee_Position = $committee_Position;
        
        return $this;
    }
    /**
     * Get Committee_Position_Codes value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType|null
     */
    public function getCommittee_Position_Codes(): ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
    {
        return $this->Committee_Position_Codes;
    }
    /**
     * Set Committee_Position_Codes value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType $committee_Position_Codes
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setCommittee_Position_Codes(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType $committee_Position_Codes = null): self
    {
        $this->Committee_Position_Codes = $committee_Position_Codes;
        
        return $this;
    }
    /**
     * Get Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Address_DataObjectType|null
     */
    public function getAddress(): ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Address_DataObjectType
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Address_DataObjectType $address
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setAddress(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Address_DataObjectType $address = null): self
    {
        $this->Address = $address;
        
        return $this;
    }
    /**
     * Get Individual value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Individual_DataObjectType|null
     */
    public function getIndividual(): ?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Individual_DataObjectType
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Individual_DataObjectType $individual
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setIndividual(?\Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Individual_DataObjectType $individual = null): self
    {
        $this->Individual = $individual;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominationsType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
