<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * CommitteeNominations_Committee_Nomination_Status_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CommitteeNominations_Committee_Nomination_Status_DataObjectType extends AbstractStructBase
{
    /**
     * The nms_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nms_key = null;
    /**
     * The nms_code
     * Meta information extracted from the WSDL
     * - documentation: Nomination Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nms_code = null;
    /**
     * The nms_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nms_add_user = null;
    /**
     * The nms_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nms_add_date = null;
    /**
     * The nms_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nms_change_user = null;
    /**
     * The nms_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nms_change_date = null;
    /**
     * The nms_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nms_delete_flag = null;
    /**
     * The nms_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nms_key_ext = null;
    /**
     * The nms_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nms_entity_key = null;
    /**
     * Constructor method for
     * CommitteeNominations_Committee_Nomination_Status_DataObjectType
     * @uses CommitteeNominations_Committee_Nomination_Status_DataObjectType::setNms_key()
     * @uses CommitteeNominations_Committee_Nomination_Status_DataObjectType::setNms_code()
     * @uses CommitteeNominations_Committee_Nomination_Status_DataObjectType::setNms_add_user()
     * @uses CommitteeNominations_Committee_Nomination_Status_DataObjectType::setNms_add_date()
     * @uses CommitteeNominations_Committee_Nomination_Status_DataObjectType::setNms_change_user()
     * @uses CommitteeNominations_Committee_Nomination_Status_DataObjectType::setNms_change_date()
     * @uses CommitteeNominations_Committee_Nomination_Status_DataObjectType::setNms_delete_flag()
     * @uses CommitteeNominations_Committee_Nomination_Status_DataObjectType::setNms_key_ext()
     * @uses CommitteeNominations_Committee_Nomination_Status_DataObjectType::setNms_entity_key()
     * @param string $nms_key
     * @param string $nms_code
     * @param string $nms_add_user
     * @param string $nms_add_date
     * @param string $nms_change_user
     * @param string $nms_change_date
     * @param string $nms_delete_flag
     * @param string $nms_key_ext
     * @param string $nms_entity_key
     */
    public function __construct(?string $nms_key = null, ?string $nms_code = null, ?string $nms_add_user = null, ?string $nms_add_date = null, ?string $nms_change_user = null, ?string $nms_change_date = null, ?string $nms_delete_flag = null, ?string $nms_key_ext = null, ?string $nms_entity_key = null)
    {
        $this
            ->setNms_key($nms_key)
            ->setNms_code($nms_code)
            ->setNms_add_user($nms_add_user)
            ->setNms_add_date($nms_add_date)
            ->setNms_change_user($nms_change_user)
            ->setNms_change_date($nms_change_date)
            ->setNms_delete_flag($nms_delete_flag)
            ->setNms_key_ext($nms_key_ext)
            ->setNms_entity_key($nms_entity_key);
    }
    /**
     * Get nms_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNms_key(): ?string
    {
        return $this->nms_key ?? null;
    }
    /**
     * Set nms_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nms_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
     */
    public function setNms_key(?string $nms_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nms_key) && !is_string($nms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nms_key, true), gettype($nms_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nms_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nms_key, true)), __LINE__);
        }
        if (is_null($nms_key) || (is_array($nms_key) && empty($nms_key))) {
            unset($this->nms_key);
        } else {
            $this->nms_key = $nms_key;
        }
        
        return $this;
    }
    /**
     * Get nms_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNms_code(): ?string
    {
        return $this->nms_code ?? null;
    }
    /**
     * Set nms_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nms_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
     */
    public function setNms_code(?string $nms_code = null): self
    {
        // validation for constraint: string
        if (!is_null($nms_code) && !is_string($nms_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nms_code, true), gettype($nms_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($nms_code) && mb_strlen((string) $nms_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $nms_code)), __LINE__);
        }
        if (is_null($nms_code) || (is_array($nms_code) && empty($nms_code))) {
            unset($this->nms_code);
        } else {
            $this->nms_code = $nms_code;
        }
        
        return $this;
    }
    /**
     * Get nms_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNms_add_user(): ?string
    {
        return $this->nms_add_user ?? null;
    }
    /**
     * Set nms_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nms_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
     */
    public function setNms_add_user(?string $nms_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($nms_add_user) && !is_string($nms_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nms_add_user, true), gettype($nms_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($nms_add_user) && mb_strlen((string) $nms_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $nms_add_user)), __LINE__);
        }
        if (is_null($nms_add_user) || (is_array($nms_add_user) && empty($nms_add_user))) {
            unset($this->nms_add_user);
        } else {
            $this->nms_add_user = $nms_add_user;
        }
        
        return $this;
    }
    /**
     * Get nms_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNms_add_date(): ?string
    {
        return $this->nms_add_date ?? null;
    }
    /**
     * Set nms_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nms_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
     */
    public function setNms_add_date(?string $nms_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nms_add_date) && !is_string($nms_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nms_add_date, true), gettype($nms_add_date)), __LINE__);
        }
        if (is_null($nms_add_date) || (is_array($nms_add_date) && empty($nms_add_date))) {
            unset($this->nms_add_date);
        } else {
            $this->nms_add_date = $nms_add_date;
        }
        
        return $this;
    }
    /**
     * Get nms_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNms_change_user(): ?string
    {
        return $this->nms_change_user ?? null;
    }
    /**
     * Set nms_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nms_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
     */
    public function setNms_change_user(?string $nms_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($nms_change_user) && !is_string($nms_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nms_change_user, true), gettype($nms_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($nms_change_user) && mb_strlen((string) $nms_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $nms_change_user)), __LINE__);
        }
        if (is_null($nms_change_user) || (is_array($nms_change_user) && empty($nms_change_user))) {
            unset($this->nms_change_user);
        } else {
            $this->nms_change_user = $nms_change_user;
        }
        
        return $this;
    }
    /**
     * Get nms_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNms_change_date(): ?string
    {
        return $this->nms_change_date ?? null;
    }
    /**
     * Set nms_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nms_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
     */
    public function setNms_change_date(?string $nms_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nms_change_date) && !is_string($nms_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nms_change_date, true), gettype($nms_change_date)), __LINE__);
        }
        if (is_null($nms_change_date) || (is_array($nms_change_date) && empty($nms_change_date))) {
            unset($this->nms_change_date);
        } else {
            $this->nms_change_date = $nms_change_date;
        }
        
        return $this;
    }
    /**
     * Get nms_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNms_delete_flag(): ?string
    {
        return $this->nms_delete_flag ?? null;
    }
    /**
     * Set nms_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nms_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
     */
    public function setNms_delete_flag(?string $nms_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($nms_delete_flag) && !is_string($nms_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nms_delete_flag, true), gettype($nms_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nms_delete_flag) && $nms_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nms_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nms_delete_flag) && $nms_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nms_delete_flag, true)), __LINE__);
        }
        if (is_null($nms_delete_flag) || (is_array($nms_delete_flag) && empty($nms_delete_flag))) {
            unset($this->nms_delete_flag);
        } else {
            $this->nms_delete_flag = $nms_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get nms_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNms_key_ext(): ?string
    {
        return $this->nms_key_ext ?? null;
    }
    /**
     * Set nms_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nms_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
     */
    public function setNms_key_ext(?string $nms_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($nms_key_ext) && !is_string($nms_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nms_key_ext, true), gettype($nms_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nms_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nms_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nms_key_ext, true)), __LINE__);
        }
        if (is_null($nms_key_ext) || (is_array($nms_key_ext) && empty($nms_key_ext))) {
            unset($this->nms_key_ext);
        } else {
            $this->nms_key_ext = $nms_key_ext;
        }
        
        return $this;
    }
    /**
     * Get nms_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNms_entity_key(): ?string
    {
        return $this->nms_entity_key ?? null;
    }
    /**
     * Set nms_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nms_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Nomination_Status_DataObjectType
     */
    public function setNms_entity_key(?string $nms_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nms_entity_key) && !is_string($nms_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nms_entity_key, true), gettype($nms_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nms_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nms_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nms_entity_key, true)), __LINE__);
        }
        if (is_null($nms_entity_key) || (is_array($nms_entity_key) && empty($nms_entity_key))) {
            unset($this->nms_entity_key);
        } else {
            $this->nms_entity_key = $nms_entity_key;
        }
        
        return $this;
    }
}
