<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitteeNominations_Committee_Position_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CommitteeNominations_Committee_Position_DataObjectType extends AbstractStructBase
{
    /**
     * The cop_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cop_key = null;
    /**
     * The cop_cmt_key
     * Meta information extracted from the WSDL
     * - documentation: Committee. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cop_cmt_key = null;
    /**
     * The cop_cpo_key
     * Meta information extracted from the WSDL
     * - documentation: Position. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cop_cpo_key = null;
    /**
     * The cop_order
     * Meta information extracted from the WSDL
     * - documentation: Order. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cop_order = null;
    /**
     * The cop_term
     * Meta information extracted from the WSDL
     * - documentation: Term. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_term = null;
    /**
     * The cop_funded_flag
     * Meta information extracted from the WSDL
     * - documentation: Funded?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_funded_flag = null;
    /**
     * The cop_renewable_flag
     * Meta information extracted from the WSDL
     * - documentation: Renewable?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_renewable_flag = null;
    /**
     * The cop_voting_flag
     * Meta information extracted from the WSDL
     * - documentation: Voting?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_voting_flag = null;
    /**
     * The cop_admin_flag
     * Meta information extracted from the WSDL
     * - documentation: Admin?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_admin_flag = null;
    /**
     * The cop_chapter_flag
     * Meta information extracted from the WSDL
     * - documentation: Chapter?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_chapter_flag = null;
    /**
     * The cop_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_add_user = null;
    /**
     * The cop_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_add_date = null;
    /**
     * The cop_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_change_user = null;
    /**
     * The cop_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_change_date = null;
    /**
     * The cop_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cop_delete_flag = null;
    /**
     * The cop_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cop_entity_key = null;
    /**
     * The cop_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cop_key_ext = null;
    /**
     * Constructor method for CommitteeNominations_Committee_Position_DataObjectType
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_key()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_cmt_key()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_cpo_key()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_order()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_term()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_funded_flag()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_renewable_flag()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_voting_flag()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_admin_flag()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_chapter_flag()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_add_user()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_add_date()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_change_user()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_change_date()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_delete_flag()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_entity_key()
     * @uses CommitteeNominations_Committee_Position_DataObjectType::setCop_key_ext()
     * @param string $cop_key
     * @param string $cop_cmt_key
     * @param string $cop_cpo_key
     * @param int $cop_order
     * @param string $cop_term
     * @param string $cop_funded_flag
     * @param string $cop_renewable_flag
     * @param string $cop_voting_flag
     * @param string $cop_admin_flag
     * @param string $cop_chapter_flag
     * @param string $cop_add_user
     * @param string $cop_add_date
     * @param string $cop_change_user
     * @param string $cop_change_date
     * @param string $cop_delete_flag
     * @param string $cop_entity_key
     * @param string $cop_key_ext
     */
    public function __construct(?string $cop_key = null, ?string $cop_cmt_key = null, ?string $cop_cpo_key = null, ?int $cop_order = null, ?string $cop_term = null, ?string $cop_funded_flag = null, ?string $cop_renewable_flag = null, ?string $cop_voting_flag = null, ?string $cop_admin_flag = null, ?string $cop_chapter_flag = null, ?string $cop_add_user = null, ?string $cop_add_date = null, ?string $cop_change_user = null, ?string $cop_change_date = null, ?string $cop_delete_flag = null, ?string $cop_entity_key = null, ?string $cop_key_ext = null)
    {
        $this
            ->setCop_key($cop_key)
            ->setCop_cmt_key($cop_cmt_key)
            ->setCop_cpo_key($cop_cpo_key)
            ->setCop_order($cop_order)
            ->setCop_term($cop_term)
            ->setCop_funded_flag($cop_funded_flag)
            ->setCop_renewable_flag($cop_renewable_flag)
            ->setCop_voting_flag($cop_voting_flag)
            ->setCop_admin_flag($cop_admin_flag)
            ->setCop_chapter_flag($cop_chapter_flag)
            ->setCop_add_user($cop_add_user)
            ->setCop_add_date($cop_add_date)
            ->setCop_change_user($cop_change_user)
            ->setCop_change_date($cop_change_date)
            ->setCop_delete_flag($cop_delete_flag)
            ->setCop_entity_key($cop_entity_key)
            ->setCop_key_ext($cop_key_ext);
    }
    /**
     * Get cop_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_key(): ?string
    {
        return $this->cop_key ?? null;
    }
    /**
     * Set cop_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_key(?string $cop_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_key) && !is_string($cop_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_key, true), gettype($cop_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cop_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cop_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cop_key, true)), __LINE__);
        }
        if (is_null($cop_key) || (is_array($cop_key) && empty($cop_key))) {
            unset($this->cop_key);
        } else {
            $this->cop_key = $cop_key;
        }
        
        return $this;
    }
    /**
     * Get cop_cmt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_cmt_key(): ?string
    {
        return $this->cop_cmt_key ?? null;
    }
    /**
     * Set cop_cmt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_cmt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_cmt_key(?string $cop_cmt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_cmt_key) && !is_string($cop_cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_cmt_key, true), gettype($cop_cmt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cop_cmt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cop_cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cop_cmt_key, true)), __LINE__);
        }
        if (is_null($cop_cmt_key) || (is_array($cop_cmt_key) && empty($cop_cmt_key))) {
            unset($this->cop_cmt_key);
        } else {
            $this->cop_cmt_key = $cop_cmt_key;
        }
        
        return $this;
    }
    /**
     * Get cop_cpo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_cpo_key(): ?string
    {
        return $this->cop_cpo_key ?? null;
    }
    /**
     * Set cop_cpo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_cpo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_cpo_key(?string $cop_cpo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_cpo_key) && !is_string($cop_cpo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_cpo_key, true), gettype($cop_cpo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cop_cpo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cop_cpo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cop_cpo_key, true)), __LINE__);
        }
        if (is_null($cop_cpo_key) || (is_array($cop_cpo_key) && empty($cop_cpo_key))) {
            unset($this->cop_cpo_key);
        } else {
            $this->cop_cpo_key = $cop_cpo_key;
        }
        
        return $this;
    }
    /**
     * Get cop_order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCop_order(): ?int
    {
        return $this->cop_order ?? null;
    }
    /**
     * Set cop_order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cop_order
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_order(?int $cop_order = null): self
    {
        // validation for constraint: int
        if (!is_null($cop_order) && !(is_int($cop_order) || ctype_digit($cop_order))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cop_order, true), gettype($cop_order)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cop_order) && $cop_order > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cop_order, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cop_order) && $cop_order < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cop_order, true)), __LINE__);
        }
        if (is_null($cop_order) || (is_array($cop_order) && empty($cop_order))) {
            unset($this->cop_order);
        } else {
            $this->cop_order = $cop_order;
        }
        
        return $this;
    }
    /**
     * Get cop_term value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_term(): ?string
    {
        return $this->cop_term ?? null;
    }
    /**
     * Set cop_term value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_term
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_term(?string $cop_term = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_term) && !is_string($cop_term)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_term, true), gettype($cop_term)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cop_term) && mb_strlen((string) $cop_term) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cop_term)), __LINE__);
        }
        if (is_null($cop_term) || (is_array($cop_term) && empty($cop_term))) {
            unset($this->cop_term);
        } else {
            $this->cop_term = $cop_term;
        }
        
        return $this;
    }
    /**
     * Get cop_funded_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_funded_flag(): ?string
    {
        return $this->cop_funded_flag ?? null;
    }
    /**
     * Set cop_funded_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_funded_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_funded_flag(?string $cop_funded_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_funded_flag) && !is_string($cop_funded_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_funded_flag, true), gettype($cop_funded_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cop_funded_flag) && $cop_funded_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cop_funded_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cop_funded_flag) && $cop_funded_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cop_funded_flag, true)), __LINE__);
        }
        if (is_null($cop_funded_flag) || (is_array($cop_funded_flag) && empty($cop_funded_flag))) {
            unset($this->cop_funded_flag);
        } else {
            $this->cop_funded_flag = $cop_funded_flag;
        }
        
        return $this;
    }
    /**
     * Get cop_renewable_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_renewable_flag(): ?string
    {
        return $this->cop_renewable_flag ?? null;
    }
    /**
     * Set cop_renewable_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_renewable_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_renewable_flag(?string $cop_renewable_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_renewable_flag) && !is_string($cop_renewable_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_renewable_flag, true), gettype($cop_renewable_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cop_renewable_flag) && $cop_renewable_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cop_renewable_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cop_renewable_flag) && $cop_renewable_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cop_renewable_flag, true)), __LINE__);
        }
        if (is_null($cop_renewable_flag) || (is_array($cop_renewable_flag) && empty($cop_renewable_flag))) {
            unset($this->cop_renewable_flag);
        } else {
            $this->cop_renewable_flag = $cop_renewable_flag;
        }
        
        return $this;
    }
    /**
     * Get cop_voting_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_voting_flag(): ?string
    {
        return $this->cop_voting_flag ?? null;
    }
    /**
     * Set cop_voting_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_voting_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_voting_flag(?string $cop_voting_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_voting_flag) && !is_string($cop_voting_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_voting_flag, true), gettype($cop_voting_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cop_voting_flag) && $cop_voting_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cop_voting_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cop_voting_flag) && $cop_voting_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cop_voting_flag, true)), __LINE__);
        }
        if (is_null($cop_voting_flag) || (is_array($cop_voting_flag) && empty($cop_voting_flag))) {
            unset($this->cop_voting_flag);
        } else {
            $this->cop_voting_flag = $cop_voting_flag;
        }
        
        return $this;
    }
    /**
     * Get cop_admin_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_admin_flag(): ?string
    {
        return $this->cop_admin_flag ?? null;
    }
    /**
     * Set cop_admin_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_admin_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_admin_flag(?string $cop_admin_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_admin_flag) && !is_string($cop_admin_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_admin_flag, true), gettype($cop_admin_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cop_admin_flag) && $cop_admin_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cop_admin_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cop_admin_flag) && $cop_admin_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cop_admin_flag, true)), __LINE__);
        }
        if (is_null($cop_admin_flag) || (is_array($cop_admin_flag) && empty($cop_admin_flag))) {
            unset($this->cop_admin_flag);
        } else {
            $this->cop_admin_flag = $cop_admin_flag;
        }
        
        return $this;
    }
    /**
     * Get cop_chapter_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_chapter_flag(): ?string
    {
        return $this->cop_chapter_flag ?? null;
    }
    /**
     * Set cop_chapter_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_chapter_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_chapter_flag(?string $cop_chapter_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_chapter_flag) && !is_string($cop_chapter_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_chapter_flag, true), gettype($cop_chapter_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cop_chapter_flag) && $cop_chapter_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cop_chapter_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cop_chapter_flag) && $cop_chapter_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cop_chapter_flag, true)), __LINE__);
        }
        if (is_null($cop_chapter_flag) || (is_array($cop_chapter_flag) && empty($cop_chapter_flag))) {
            unset($this->cop_chapter_flag);
        } else {
            $this->cop_chapter_flag = $cop_chapter_flag;
        }
        
        return $this;
    }
    /**
     * Get cop_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_add_user(): ?string
    {
        return $this->cop_add_user ?? null;
    }
    /**
     * Set cop_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_add_user(?string $cop_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_add_user) && !is_string($cop_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_add_user, true), gettype($cop_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cop_add_user) && mb_strlen((string) $cop_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cop_add_user)), __LINE__);
        }
        if (is_null($cop_add_user) || (is_array($cop_add_user) && empty($cop_add_user))) {
            unset($this->cop_add_user);
        } else {
            $this->cop_add_user = $cop_add_user;
        }
        
        return $this;
    }
    /**
     * Get cop_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_add_date(): ?string
    {
        return $this->cop_add_date ?? null;
    }
    /**
     * Set cop_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_add_date(?string $cop_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_add_date) && !is_string($cop_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_add_date, true), gettype($cop_add_date)), __LINE__);
        }
        if (is_null($cop_add_date) || (is_array($cop_add_date) && empty($cop_add_date))) {
            unset($this->cop_add_date);
        } else {
            $this->cop_add_date = $cop_add_date;
        }
        
        return $this;
    }
    /**
     * Get cop_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_change_user(): ?string
    {
        return $this->cop_change_user ?? null;
    }
    /**
     * Set cop_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_change_user(?string $cop_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_change_user) && !is_string($cop_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_change_user, true), gettype($cop_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cop_change_user) && mb_strlen((string) $cop_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cop_change_user)), __LINE__);
        }
        if (is_null($cop_change_user) || (is_array($cop_change_user) && empty($cop_change_user))) {
            unset($this->cop_change_user);
        } else {
            $this->cop_change_user = $cop_change_user;
        }
        
        return $this;
    }
    /**
     * Get cop_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_change_date(): ?string
    {
        return $this->cop_change_date ?? null;
    }
    /**
     * Set cop_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_change_date(?string $cop_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_change_date) && !is_string($cop_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_change_date, true), gettype($cop_change_date)), __LINE__);
        }
        if (is_null($cop_change_date) || (is_array($cop_change_date) && empty($cop_change_date))) {
            unset($this->cop_change_date);
        } else {
            $this->cop_change_date = $cop_change_date;
        }
        
        return $this;
    }
    /**
     * Get cop_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_delete_flag(): ?string
    {
        return $this->cop_delete_flag ?? null;
    }
    /**
     * Set cop_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_delete_flag(?string $cop_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_delete_flag) && !is_string($cop_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_delete_flag, true), gettype($cop_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cop_delete_flag) && $cop_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cop_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cop_delete_flag) && $cop_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cop_delete_flag, true)), __LINE__);
        }
        if (is_null($cop_delete_flag) || (is_array($cop_delete_flag) && empty($cop_delete_flag))) {
            unset($this->cop_delete_flag);
        } else {
            $this->cop_delete_flag = $cop_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cop_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_entity_key(): ?string
    {
        return $this->cop_entity_key ?? null;
    }
    /**
     * Set cop_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_entity_key(?string $cop_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_entity_key) && !is_string($cop_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_entity_key, true), gettype($cop_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cop_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cop_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cop_entity_key, true)), __LINE__);
        }
        if (is_null($cop_entity_key) || (is_array($cop_entity_key) && empty($cop_entity_key))) {
            unset($this->cop_entity_key);
        } else {
            $this->cop_entity_key = $cop_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cop_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCop_key_ext(): ?string
    {
        return $this->cop_key_ext ?? null;
    }
    /**
     * Set cop_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cop_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_DataObjectType
     */
    public function setCop_key_ext(?string $cop_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cop_key_ext) && !is_string($cop_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cop_key_ext, true), gettype($cop_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cop_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cop_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cop_key_ext, true)), __LINE__);
        }
        if (is_null($cop_key_ext) || (is_array($cop_key_ext) && empty($cop_key_ext))) {
            unset($this->cop_key_ext);
        } else {
            $this->cop_key_ext = $cop_key_ext;
        }
        
        return $this;
    }
}
