<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitteeType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CommitteeType extends AbstractStructBase
{
    /**
     * The Committee
     * @var \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_DataObjectType $Committee = null;
    /**
     * The Parent_Committee
     * @var \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType $Parent_Committee = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Committee_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Customer_DataObjectType $Customer = null;
    /**
     * The Committee_Participant
     * @var \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType $Committee_Participant = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Unique Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for CommitteeType
     * @uses CommitteeType::setCommittee()
     * @uses CommitteeType::setParent_Committee()
     * @uses CommitteeType::setCustomer()
     * @uses CommitteeType::setCommittee_Participant()
     * @uses CommitteeType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_DataObjectType $committee
     * @param \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType $parent_Committee
     * @param \Drupal\netforum\xWeb\Generated\StructType\Committee_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType $committee_Participant
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_DataObjectType $committee = null, ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType $parent_Committee = null, ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType $committee_Participant = null, ?string $currentKey = null)
    {
        $this
            ->setCommittee($committee)
            ->setParent_Committee($parent_Committee)
            ->setCustomer($customer)
            ->setCommittee_Participant($committee_Participant)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Committee value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_DataObjectType|null
     */
    public function getCommittee(): ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_DataObjectType
    {
        return $this->Committee;
    }
    /**
     * Set Committee value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_DataObjectType $committee
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeType
     */
    public function setCommittee(?\Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_DataObjectType $committee = null): self
    {
        $this->Committee = $committee;
        
        return $this;
    }
    /**
     * Get Parent_Committee value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType|null
     */
    public function getParent_Committee(): ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
    {
        return $this->Parent_Committee;
    }
    /**
     * Set Parent_Committee value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType $parent_Committee
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeType
     */
    public function setParent_Committee(?\Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType $parent_Committee = null): self
    {
        $this->Parent_Committee = $parent_Committee;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Committee_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\Committee_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Committee_Participant value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType|null
     */
    public function getCommittee_Participant(): ?\Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
    {
        return $this->Committee_Participant;
    }
    /**
     * Set Committee_Participant value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType $committee_Participant
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeType
     */
    public function setCommittee_Participant(?\Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType $committee_Participant = null): self
    {
        $this->Committee_Participant = $committee_Participant;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
