<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRequest_Assignment_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ContactRequest_Assignment_DataObjectType extends AbstractStructBase
{
    /**
     * The coa_key
     * Meta information extracted from the WSDL
     * - documentation: Assignment. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $coa_key = null;
    /**
     * The coa_cor_key
     * Meta information extracted from the WSDL
     * - documentation: Contact Request. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $coa_cor_key = null;
    /**
     * The coa_usr_code
     * Meta information extracted from the WSDL
     * - documentation: Assignee. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_usr_code = null;
    /**
     * The coa_rat_code
     * Meta information extracted from the WSDL
     * - documentation: Activity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_rat_code = null;
    /**
     * The coa_car_code
     * Meta information extracted from the WSDL
     * - documentation: Role. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_car_code = null;
    /**
     * The coa_summary
     * Meta information extracted from the WSDL
     * - documentation: Assignment Summary. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_summary = null;
    /**
     * The coa_detail
     * Meta information extracted from the WSDL
     * - documentation: Assignment Detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_detail = null;
    /**
     * The coa_auto_notify_flag
     * Meta information extracted from the WSDL
     * - documentation: Send Email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_auto_notify_flag = null;
    /**
     * The coa_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_add_date = null;
    /**
     * The coa_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_add_user = null;
    /**
     * The coa_synced_flag
     * Meta information extracted from the WSDL
     * - documentation: Tracks if the assignment has been downloaded to outlook..This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [0-1]
     * @var bool|null
     */
    protected ?bool $coa_synced_flag = null;
    /**
     * The coa_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_change_date = null;
    /**
     * The coa_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_change_user = null;
    /**
     * The coa_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_delete_flag = null;
    /**
     * The coa_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $coa_key_ext = null;
    /**
     * The coa_crs_code
     * Meta information extracted from the WSDL
     * - documentation: Status.This element has a default value of 'Open'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_crs_code = null;
    /**
     * The coa_crp_code
     * Meta information extracted from the WSDL
     * - documentation: Priority.This element has a default value of 'high'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_crp_code = null;
    /**
     * The coa_due_date
     * Meta information extracted from the WSDL
     * - documentation: Due Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_due_date = null;
    /**
     * The coa_source_code
     * Meta information extracted from the WSDL
     * - documentation: Assignment Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_source_code = null;
    /**
     * The coa_remind_date
     * Meta information extracted from the WSDL
     * - documentation: Remind Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_remind_date = null;
    /**
     * The coa_cct_key
     * Meta information extracted from the WSDL
     * - documentation: assignment/correspondence key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $coa_cct_key = null;
    /**
     * The coa_send_notify_date
     * Meta information extracted from the WSDL
     * - documentation: Date Notification Sent. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_send_notify_date = null;
    /**
     * The coa_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $coa_entity_key = null;
    /**
     * The coa_wfl_key
     * Meta information extracted from the WSDL
     * - documentation: Workflow Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $coa_wfl_key = null;
    /**
     * The coa_csu_code
     * Meta information extracted from the WSDL
     * - documentation: Subject. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $coa_csu_code = null;
    /**
     * The coa_sfo_key
     * Meta information extracted from the WSDL
     * - documentation: Opportunity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $coa_sfo_key = null;
    /**
     * The coa_osh_key
     * Meta information extracted from the WSDL
     * - documentation: Moves History key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $coa_osh_key = null;
    /**
     * The coa_wkt_key
     * Meta information extracted from the WSDL
     * - documentation: Workflow Task Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $coa_wkt_key = null;
    /**
     * Constructor method for ContactRequest_Assignment_DataObjectType
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_key()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_cor_key()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_usr_code()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_rat_code()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_car_code()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_summary()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_detail()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_auto_notify_flag()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_add_date()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_add_user()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_synced_flag()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_change_date()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_change_user()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_delete_flag()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_key_ext()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_crs_code()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_crp_code()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_due_date()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_source_code()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_remind_date()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_cct_key()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_send_notify_date()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_entity_key()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_wfl_key()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_csu_code()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_sfo_key()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_osh_key()
     * @uses ContactRequest_Assignment_DataObjectType::setCoa_wkt_key()
     * @param string $coa_key
     * @param string $coa_cor_key
     * @param string $coa_usr_code
     * @param string $coa_rat_code
     * @param string $coa_car_code
     * @param string $coa_summary
     * @param string $coa_detail
     * @param string $coa_auto_notify_flag
     * @param string $coa_add_date
     * @param string $coa_add_user
     * @param bool $coa_synced_flag
     * @param string $coa_change_date
     * @param string $coa_change_user
     * @param string $coa_delete_flag
     * @param string $coa_key_ext
     * @param string $coa_crs_code
     * @param string $coa_crp_code
     * @param string $coa_due_date
     * @param string $coa_source_code
     * @param string $coa_remind_date
     * @param string $coa_cct_key
     * @param string $coa_send_notify_date
     * @param string $coa_entity_key
     * @param string $coa_wfl_key
     * @param string $coa_csu_code
     * @param string $coa_sfo_key
     * @param string $coa_osh_key
     * @param string $coa_wkt_key
     */
    public function __construct(?string $coa_key = null, ?string $coa_cor_key = null, ?string $coa_usr_code = null, ?string $coa_rat_code = null, ?string $coa_car_code = null, ?string $coa_summary = null, ?string $coa_detail = null, ?string $coa_auto_notify_flag = null, ?string $coa_add_date = null, ?string $coa_add_user = null, ?bool $coa_synced_flag = null, ?string $coa_change_date = null, ?string $coa_change_user = null, ?string $coa_delete_flag = null, ?string $coa_key_ext = null, ?string $coa_crs_code = null, ?string $coa_crp_code = null, ?string $coa_due_date = null, ?string $coa_source_code = null, ?string $coa_remind_date = null, ?string $coa_cct_key = null, ?string $coa_send_notify_date = null, ?string $coa_entity_key = null, ?string $coa_wfl_key = null, ?string $coa_csu_code = null, ?string $coa_sfo_key = null, ?string $coa_osh_key = null, ?string $coa_wkt_key = null)
    {
        $this
            ->setCoa_key($coa_key)
            ->setCoa_cor_key($coa_cor_key)
            ->setCoa_usr_code($coa_usr_code)
            ->setCoa_rat_code($coa_rat_code)
            ->setCoa_car_code($coa_car_code)
            ->setCoa_summary($coa_summary)
            ->setCoa_detail($coa_detail)
            ->setCoa_auto_notify_flag($coa_auto_notify_flag)
            ->setCoa_add_date($coa_add_date)
            ->setCoa_add_user($coa_add_user)
            ->setCoa_synced_flag($coa_synced_flag)
            ->setCoa_change_date($coa_change_date)
            ->setCoa_change_user($coa_change_user)
            ->setCoa_delete_flag($coa_delete_flag)
            ->setCoa_key_ext($coa_key_ext)
            ->setCoa_crs_code($coa_crs_code)
            ->setCoa_crp_code($coa_crp_code)
            ->setCoa_due_date($coa_due_date)
            ->setCoa_source_code($coa_source_code)
            ->setCoa_remind_date($coa_remind_date)
            ->setCoa_cct_key($coa_cct_key)
            ->setCoa_send_notify_date($coa_send_notify_date)
            ->setCoa_entity_key($coa_entity_key)
            ->setCoa_wfl_key($coa_wfl_key)
            ->setCoa_csu_code($coa_csu_code)
            ->setCoa_sfo_key($coa_sfo_key)
            ->setCoa_osh_key($coa_osh_key)
            ->setCoa_wkt_key($coa_wkt_key);
    }
    /**
     * Get coa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_key(): ?string
    {
        return $this->coa_key ?? null;
    }
    /**
     * Set coa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_key(?string $coa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_key) && !is_string($coa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_key, true), gettype($coa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($coa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $coa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($coa_key, true)), __LINE__);
        }
        if (is_null($coa_key) || (is_array($coa_key) && empty($coa_key))) {
            unset($this->coa_key);
        } else {
            $this->coa_key = $coa_key;
        }
        
        return $this;
    }
    /**
     * Get coa_cor_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_cor_key(): ?string
    {
        return $this->coa_cor_key ?? null;
    }
    /**
     * Set coa_cor_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_cor_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_cor_key(?string $coa_cor_key = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_cor_key) && !is_string($coa_cor_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_cor_key, true), gettype($coa_cor_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($coa_cor_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $coa_cor_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($coa_cor_key, true)), __LINE__);
        }
        if (is_null($coa_cor_key) || (is_array($coa_cor_key) && empty($coa_cor_key))) {
            unset($this->coa_cor_key);
        } else {
            $this->coa_cor_key = $coa_cor_key;
        }
        
        return $this;
    }
    /**
     * Get coa_usr_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_usr_code(): ?string
    {
        return $this->coa_usr_code ?? null;
    }
    /**
     * Set coa_usr_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_usr_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_usr_code(?string $coa_usr_code = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_usr_code) && !is_string($coa_usr_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_usr_code, true), gettype($coa_usr_code)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($coa_usr_code) && mb_strlen((string) $coa_usr_code) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $coa_usr_code)), __LINE__);
        }
        if (is_null($coa_usr_code) || (is_array($coa_usr_code) && empty($coa_usr_code))) {
            unset($this->coa_usr_code);
        } else {
            $this->coa_usr_code = $coa_usr_code;
        }
        
        return $this;
    }
    /**
     * Get coa_rat_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_rat_code(): ?string
    {
        return $this->coa_rat_code ?? null;
    }
    /**
     * Set coa_rat_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_rat_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_rat_code(?string $coa_rat_code = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_rat_code) && !is_string($coa_rat_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_rat_code, true), gettype($coa_rat_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($coa_rat_code) && mb_strlen((string) $coa_rat_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $coa_rat_code)), __LINE__);
        }
        if (is_null($coa_rat_code) || (is_array($coa_rat_code) && empty($coa_rat_code))) {
            unset($this->coa_rat_code);
        } else {
            $this->coa_rat_code = $coa_rat_code;
        }
        
        return $this;
    }
    /**
     * Get coa_car_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_car_code(): ?string
    {
        return $this->coa_car_code ?? null;
    }
    /**
     * Set coa_car_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_car_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_car_code(?string $coa_car_code = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_car_code) && !is_string($coa_car_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_car_code, true), gettype($coa_car_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($coa_car_code) && mb_strlen((string) $coa_car_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $coa_car_code)), __LINE__);
        }
        if (is_null($coa_car_code) || (is_array($coa_car_code) && empty($coa_car_code))) {
            unset($this->coa_car_code);
        } else {
            $this->coa_car_code = $coa_car_code;
        }
        
        return $this;
    }
    /**
     * Get coa_summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_summary(): ?string
    {
        return $this->coa_summary ?? null;
    }
    /**
     * Set coa_summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_summary
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_summary(?string $coa_summary = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_summary) && !is_string($coa_summary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_summary, true), gettype($coa_summary)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($coa_summary) && mb_strlen((string) $coa_summary) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $coa_summary)), __LINE__);
        }
        if (is_null($coa_summary) || (is_array($coa_summary) && empty($coa_summary))) {
            unset($this->coa_summary);
        } else {
            $this->coa_summary = $coa_summary;
        }
        
        return $this;
    }
    /**
     * Get coa_detail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_detail(): ?string
    {
        return $this->coa_detail ?? null;
    }
    /**
     * Set coa_detail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_detail
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_detail(?string $coa_detail = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_detail) && !is_string($coa_detail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_detail, true), gettype($coa_detail)), __LINE__);
        }
        if (is_null($coa_detail) || (is_array($coa_detail) && empty($coa_detail))) {
            unset($this->coa_detail);
        } else {
            $this->coa_detail = $coa_detail;
        }
        
        return $this;
    }
    /**
     * Get coa_auto_notify_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_auto_notify_flag(): ?string
    {
        return $this->coa_auto_notify_flag ?? null;
    }
    /**
     * Set coa_auto_notify_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_auto_notify_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_auto_notify_flag(?string $coa_auto_notify_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_auto_notify_flag) && !is_string($coa_auto_notify_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_auto_notify_flag, true), gettype($coa_auto_notify_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($coa_auto_notify_flag) && $coa_auto_notify_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($coa_auto_notify_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($coa_auto_notify_flag) && $coa_auto_notify_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($coa_auto_notify_flag, true)), __LINE__);
        }
        if (is_null($coa_auto_notify_flag) || (is_array($coa_auto_notify_flag) && empty($coa_auto_notify_flag))) {
            unset($this->coa_auto_notify_flag);
        } else {
            $this->coa_auto_notify_flag = $coa_auto_notify_flag;
        }
        
        return $this;
    }
    /**
     * Get coa_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_add_date(): ?string
    {
        return $this->coa_add_date ?? null;
    }
    /**
     * Set coa_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_add_date(?string $coa_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_add_date) && !is_string($coa_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_add_date, true), gettype($coa_add_date)), __LINE__);
        }
        if (is_null($coa_add_date) || (is_array($coa_add_date) && empty($coa_add_date))) {
            unset($this->coa_add_date);
        } else {
            $this->coa_add_date = $coa_add_date;
        }
        
        return $this;
    }
    /**
     * Get coa_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_add_user(): ?string
    {
        return $this->coa_add_user ?? null;
    }
    /**
     * Set coa_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_add_user(?string $coa_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_add_user) && !is_string($coa_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_add_user, true), gettype($coa_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($coa_add_user) && mb_strlen((string) $coa_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $coa_add_user)), __LINE__);
        }
        if (is_null($coa_add_user) || (is_array($coa_add_user) && empty($coa_add_user))) {
            unset($this->coa_add_user);
        } else {
            $this->coa_add_user = $coa_add_user;
        }
        
        return $this;
    }
    /**
     * Get coa_synced_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCoa_synced_flag(): ?bool
    {
        return $this->coa_synced_flag ?? null;
    }
    /**
     * Set coa_synced_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $coa_synced_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_synced_flag(?bool $coa_synced_flag = null): self
    {
        // validation for constraint: boolean
        if (!is_null($coa_synced_flag) && !is_bool($coa_synced_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($coa_synced_flag, true), gettype($coa_synced_flag)), __LINE__);
        }
        // validation for constraint: pattern([0-1])
        if (!is_null($coa_synced_flag) && !preg_match('/[0-1]/', (string) $coa_synced_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-1]/', var_export($coa_synced_flag, true)), __LINE__);
        }
        if (is_null($coa_synced_flag) || (is_array($coa_synced_flag) && empty($coa_synced_flag))) {
            unset($this->coa_synced_flag);
        } else {
            $this->coa_synced_flag = $coa_synced_flag;
        }
        
        return $this;
    }
    /**
     * Get coa_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_change_date(): ?string
    {
        return $this->coa_change_date ?? null;
    }
    /**
     * Set coa_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_change_date(?string $coa_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_change_date) && !is_string($coa_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_change_date, true), gettype($coa_change_date)), __LINE__);
        }
        if (is_null($coa_change_date) || (is_array($coa_change_date) && empty($coa_change_date))) {
            unset($this->coa_change_date);
        } else {
            $this->coa_change_date = $coa_change_date;
        }
        
        return $this;
    }
    /**
     * Get coa_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_change_user(): ?string
    {
        return $this->coa_change_user ?? null;
    }
    /**
     * Set coa_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_change_user(?string $coa_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_change_user) && !is_string($coa_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_change_user, true), gettype($coa_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($coa_change_user) && mb_strlen((string) $coa_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $coa_change_user)), __LINE__);
        }
        if (is_null($coa_change_user) || (is_array($coa_change_user) && empty($coa_change_user))) {
            unset($this->coa_change_user);
        } else {
            $this->coa_change_user = $coa_change_user;
        }
        
        return $this;
    }
    /**
     * Get coa_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_delete_flag(): ?string
    {
        return $this->coa_delete_flag ?? null;
    }
    /**
     * Set coa_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_delete_flag(?string $coa_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_delete_flag) && !is_string($coa_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_delete_flag, true), gettype($coa_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($coa_delete_flag) && $coa_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($coa_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($coa_delete_flag) && $coa_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($coa_delete_flag, true)), __LINE__);
        }
        if (is_null($coa_delete_flag) || (is_array($coa_delete_flag) && empty($coa_delete_flag))) {
            unset($this->coa_delete_flag);
        } else {
            $this->coa_delete_flag = $coa_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get coa_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_key_ext(): ?string
    {
        return $this->coa_key_ext ?? null;
    }
    /**
     * Set coa_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_key_ext(?string $coa_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_key_ext) && !is_string($coa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_key_ext, true), gettype($coa_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($coa_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $coa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($coa_key_ext, true)), __LINE__);
        }
        if (is_null($coa_key_ext) || (is_array($coa_key_ext) && empty($coa_key_ext))) {
            unset($this->coa_key_ext);
        } else {
            $this->coa_key_ext = $coa_key_ext;
        }
        
        return $this;
    }
    /**
     * Get coa_crs_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_crs_code(): ?string
    {
        return $this->coa_crs_code ?? null;
    }
    /**
     * Set coa_crs_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_crs_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_crs_code(?string $coa_crs_code = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_crs_code) && !is_string($coa_crs_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_crs_code, true), gettype($coa_crs_code)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($coa_crs_code) && mb_strlen((string) $coa_crs_code) > 12) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen((string) $coa_crs_code)), __LINE__);
        }
        if (is_null($coa_crs_code) || (is_array($coa_crs_code) && empty($coa_crs_code))) {
            unset($this->coa_crs_code);
        } else {
            $this->coa_crs_code = $coa_crs_code;
        }
        
        return $this;
    }
    /**
     * Get coa_crp_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_crp_code(): ?string
    {
        return $this->coa_crp_code ?? null;
    }
    /**
     * Set coa_crp_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_crp_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_crp_code(?string $coa_crp_code = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_crp_code) && !is_string($coa_crp_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_crp_code, true), gettype($coa_crp_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($coa_crp_code) && mb_strlen((string) $coa_crp_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $coa_crp_code)), __LINE__);
        }
        if (is_null($coa_crp_code) || (is_array($coa_crp_code) && empty($coa_crp_code))) {
            unset($this->coa_crp_code);
        } else {
            $this->coa_crp_code = $coa_crp_code;
        }
        
        return $this;
    }
    /**
     * Get coa_due_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_due_date(): ?string
    {
        return $this->coa_due_date ?? null;
    }
    /**
     * Set coa_due_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_due_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_due_date(?string $coa_due_date = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_due_date) && !is_string($coa_due_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_due_date, true), gettype($coa_due_date)), __LINE__);
        }
        if (is_null($coa_due_date) || (is_array($coa_due_date) && empty($coa_due_date))) {
            unset($this->coa_due_date);
        } else {
            $this->coa_due_date = $coa_due_date;
        }
        
        return $this;
    }
    /**
     * Get coa_source_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_source_code(): ?string
    {
        return $this->coa_source_code ?? null;
    }
    /**
     * Set coa_source_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_source_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_source_code(?string $coa_source_code = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_source_code) && !is_string($coa_source_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_source_code, true), gettype($coa_source_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($coa_source_code) && mb_strlen((string) $coa_source_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $coa_source_code)), __LINE__);
        }
        if (is_null($coa_source_code) || (is_array($coa_source_code) && empty($coa_source_code))) {
            unset($this->coa_source_code);
        } else {
            $this->coa_source_code = $coa_source_code;
        }
        
        return $this;
    }
    /**
     * Get coa_remind_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_remind_date(): ?string
    {
        return $this->coa_remind_date ?? null;
    }
    /**
     * Set coa_remind_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_remind_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_remind_date(?string $coa_remind_date = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_remind_date) && !is_string($coa_remind_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_remind_date, true), gettype($coa_remind_date)), __LINE__);
        }
        if (is_null($coa_remind_date) || (is_array($coa_remind_date) && empty($coa_remind_date))) {
            unset($this->coa_remind_date);
        } else {
            $this->coa_remind_date = $coa_remind_date;
        }
        
        return $this;
    }
    /**
     * Get coa_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_cct_key(): ?string
    {
        return $this->coa_cct_key ?? null;
    }
    /**
     * Set coa_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_cct_key(?string $coa_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_cct_key) && !is_string($coa_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_cct_key, true), gettype($coa_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($coa_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $coa_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($coa_cct_key, true)), __LINE__);
        }
        if (is_null($coa_cct_key) || (is_array($coa_cct_key) && empty($coa_cct_key))) {
            unset($this->coa_cct_key);
        } else {
            $this->coa_cct_key = $coa_cct_key;
        }
        
        return $this;
    }
    /**
     * Get coa_send_notify_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_send_notify_date(): ?string
    {
        return $this->coa_send_notify_date ?? null;
    }
    /**
     * Set coa_send_notify_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_send_notify_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_send_notify_date(?string $coa_send_notify_date = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_send_notify_date) && !is_string($coa_send_notify_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_send_notify_date, true), gettype($coa_send_notify_date)), __LINE__);
        }
        if (is_null($coa_send_notify_date) || (is_array($coa_send_notify_date) && empty($coa_send_notify_date))) {
            unset($this->coa_send_notify_date);
        } else {
            $this->coa_send_notify_date = $coa_send_notify_date;
        }
        
        return $this;
    }
    /**
     * Get coa_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_entity_key(): ?string
    {
        return $this->coa_entity_key ?? null;
    }
    /**
     * Set coa_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_entity_key(?string $coa_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_entity_key) && !is_string($coa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_entity_key, true), gettype($coa_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($coa_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $coa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($coa_entity_key, true)), __LINE__);
        }
        if (is_null($coa_entity_key) || (is_array($coa_entity_key) && empty($coa_entity_key))) {
            unset($this->coa_entity_key);
        } else {
            $this->coa_entity_key = $coa_entity_key;
        }
        
        return $this;
    }
    /**
     * Get coa_wfl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_wfl_key(): ?string
    {
        return $this->coa_wfl_key ?? null;
    }
    /**
     * Set coa_wfl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_wfl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_wfl_key(?string $coa_wfl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_wfl_key) && !is_string($coa_wfl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_wfl_key, true), gettype($coa_wfl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($coa_wfl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $coa_wfl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($coa_wfl_key, true)), __LINE__);
        }
        if (is_null($coa_wfl_key) || (is_array($coa_wfl_key) && empty($coa_wfl_key))) {
            unset($this->coa_wfl_key);
        } else {
            $this->coa_wfl_key = $coa_wfl_key;
        }
        
        return $this;
    }
    /**
     * Get coa_csu_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_csu_code(): ?string
    {
        return $this->coa_csu_code ?? null;
    }
    /**
     * Set coa_csu_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_csu_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_csu_code(?string $coa_csu_code = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_csu_code) && !is_string($coa_csu_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_csu_code, true), gettype($coa_csu_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($coa_csu_code) && mb_strlen((string) $coa_csu_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $coa_csu_code)), __LINE__);
        }
        if (is_null($coa_csu_code) || (is_array($coa_csu_code) && empty($coa_csu_code))) {
            unset($this->coa_csu_code);
        } else {
            $this->coa_csu_code = $coa_csu_code;
        }
        
        return $this;
    }
    /**
     * Get coa_sfo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_sfo_key(): ?string
    {
        return $this->coa_sfo_key ?? null;
    }
    /**
     * Set coa_sfo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_sfo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_sfo_key(?string $coa_sfo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_sfo_key) && !is_string($coa_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_sfo_key, true), gettype($coa_sfo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($coa_sfo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $coa_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($coa_sfo_key, true)), __LINE__);
        }
        if (is_null($coa_sfo_key) || (is_array($coa_sfo_key) && empty($coa_sfo_key))) {
            unset($this->coa_sfo_key);
        } else {
            $this->coa_sfo_key = $coa_sfo_key;
        }
        
        return $this;
    }
    /**
     * Get coa_osh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_osh_key(): ?string
    {
        return $this->coa_osh_key ?? null;
    }
    /**
     * Set coa_osh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_osh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_osh_key(?string $coa_osh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_osh_key) && !is_string($coa_osh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_osh_key, true), gettype($coa_osh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($coa_osh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $coa_osh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($coa_osh_key, true)), __LINE__);
        }
        if (is_null($coa_osh_key) || (is_array($coa_osh_key) && empty($coa_osh_key))) {
            unset($this->coa_osh_key);
        } else {
            $this->coa_osh_key = $coa_osh_key;
        }
        
        return $this;
    }
    /**
     * Get coa_wkt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoa_wkt_key(): ?string
    {
        return $this->coa_wkt_key ?? null;
    }
    /**
     * Set coa_wkt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coa_wkt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
     */
    public function setCoa_wkt_key(?string $coa_wkt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($coa_wkt_key) && !is_string($coa_wkt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coa_wkt_key, true), gettype($coa_wkt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($coa_wkt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $coa_wkt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($coa_wkt_key, true)), __LINE__);
        }
        if (is_null($coa_wkt_key) || (is_array($coa_wkt_key) && empty($coa_wkt_key))) {
            unset($this->coa_wkt_key);
        } else {
            $this->coa_wkt_key = $coa_wkt_key;
        }
        
        return $this;
    }
}
