<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRequest_Comments_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ContactRequest_Comments_DataObjectType extends AbstractStructBase
{
    /**
     * The crc_key
     * Meta information extracted from the WSDL
     * - documentation: crc_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $crc_key = null;
    /**
     * The crc_cor_key
     * Meta information extracted from the WSDL
     * - documentation: Contact Request. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $crc_cor_key = null;
    /**
     * The crc_comment
     * Meta information extracted from the WSDL
     * - documentation: Comment. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $crc_comment = null;
    /**
     * The crc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $crc_add_date = null;
    /**
     * The crc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $crc_add_user = null;
    /**
     * The crc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $crc_change_date = null;
    /**
     * The crc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $crc_change_user = null;
    /**
     * The crc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $crc_delete_flag = null;
    /**
     * The crc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $crc_key_ext = null;
    /**
     * The crc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $crc_entity_key = null;
    /**
     * Constructor method for ContactRequest_Comments_DataObjectType
     * @uses ContactRequest_Comments_DataObjectType::setCrc_key()
     * @uses ContactRequest_Comments_DataObjectType::setCrc_cor_key()
     * @uses ContactRequest_Comments_DataObjectType::setCrc_comment()
     * @uses ContactRequest_Comments_DataObjectType::setCrc_add_date()
     * @uses ContactRequest_Comments_DataObjectType::setCrc_add_user()
     * @uses ContactRequest_Comments_DataObjectType::setCrc_change_date()
     * @uses ContactRequest_Comments_DataObjectType::setCrc_change_user()
     * @uses ContactRequest_Comments_DataObjectType::setCrc_delete_flag()
     * @uses ContactRequest_Comments_DataObjectType::setCrc_key_ext()
     * @uses ContactRequest_Comments_DataObjectType::setCrc_entity_key()
     * @param string $crc_key
     * @param string $crc_cor_key
     * @param string $crc_comment
     * @param string $crc_add_date
     * @param string $crc_add_user
     * @param string $crc_change_date
     * @param string $crc_change_user
     * @param string $crc_delete_flag
     * @param string $crc_key_ext
     * @param string $crc_entity_key
     */
    public function __construct(?string $crc_key = null, ?string $crc_cor_key = null, ?string $crc_comment = null, ?string $crc_add_date = null, ?string $crc_add_user = null, ?string $crc_change_date = null, ?string $crc_change_user = null, ?string $crc_delete_flag = null, ?string $crc_key_ext = null, ?string $crc_entity_key = null)
    {
        $this
            ->setCrc_key($crc_key)
            ->setCrc_cor_key($crc_cor_key)
            ->setCrc_comment($crc_comment)
            ->setCrc_add_date($crc_add_date)
            ->setCrc_add_user($crc_add_user)
            ->setCrc_change_date($crc_change_date)
            ->setCrc_change_user($crc_change_user)
            ->setCrc_delete_flag($crc_delete_flag)
            ->setCrc_key_ext($crc_key_ext)
            ->setCrc_entity_key($crc_entity_key);
    }
    /**
     * Get crc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_key(): ?string
    {
        return $this->crc_key ?? null;
    }
    /**
     * Set crc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_key(?string $crc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_key) && !is_string($crc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_key, true), gettype($crc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($crc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $crc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($crc_key, true)), __LINE__);
        }
        if (is_null($crc_key) || (is_array($crc_key) && empty($crc_key))) {
            unset($this->crc_key);
        } else {
            $this->crc_key = $crc_key;
        }
        
        return $this;
    }
    /**
     * Get crc_cor_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_cor_key(): ?string
    {
        return $this->crc_cor_key ?? null;
    }
    /**
     * Set crc_cor_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_cor_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_cor_key(?string $crc_cor_key = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_cor_key) && !is_string($crc_cor_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_cor_key, true), gettype($crc_cor_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($crc_cor_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $crc_cor_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($crc_cor_key, true)), __LINE__);
        }
        if (is_null($crc_cor_key) || (is_array($crc_cor_key) && empty($crc_cor_key))) {
            unset($this->crc_cor_key);
        } else {
            $this->crc_cor_key = $crc_cor_key;
        }
        
        return $this;
    }
    /**
     * Get crc_comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_comment(): ?string
    {
        return $this->crc_comment ?? null;
    }
    /**
     * Set crc_comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_comment
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_comment(?string $crc_comment = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_comment) && !is_string($crc_comment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_comment, true), gettype($crc_comment)), __LINE__);
        }
        if (is_null($crc_comment) || (is_array($crc_comment) && empty($crc_comment))) {
            unset($this->crc_comment);
        } else {
            $this->crc_comment = $crc_comment;
        }
        
        return $this;
    }
    /**
     * Get crc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_add_date(): ?string
    {
        return $this->crc_add_date ?? null;
    }
    /**
     * Set crc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_add_date(?string $crc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_add_date) && !is_string($crc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_add_date, true), gettype($crc_add_date)), __LINE__);
        }
        if (is_null($crc_add_date) || (is_array($crc_add_date) && empty($crc_add_date))) {
            unset($this->crc_add_date);
        } else {
            $this->crc_add_date = $crc_add_date;
        }
        
        return $this;
    }
    /**
     * Get crc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_add_user(): ?string
    {
        return $this->crc_add_user ?? null;
    }
    /**
     * Set crc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_add_user(?string $crc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_add_user) && !is_string($crc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_add_user, true), gettype($crc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($crc_add_user) && mb_strlen((string) $crc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $crc_add_user)), __LINE__);
        }
        if (is_null($crc_add_user) || (is_array($crc_add_user) && empty($crc_add_user))) {
            unset($this->crc_add_user);
        } else {
            $this->crc_add_user = $crc_add_user;
        }
        
        return $this;
    }
    /**
     * Get crc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_change_date(): ?string
    {
        return $this->crc_change_date ?? null;
    }
    /**
     * Set crc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_change_date(?string $crc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_change_date) && !is_string($crc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_change_date, true), gettype($crc_change_date)), __LINE__);
        }
        if (is_null($crc_change_date) || (is_array($crc_change_date) && empty($crc_change_date))) {
            unset($this->crc_change_date);
        } else {
            $this->crc_change_date = $crc_change_date;
        }
        
        return $this;
    }
    /**
     * Get crc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_change_user(): ?string
    {
        return $this->crc_change_user ?? null;
    }
    /**
     * Set crc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_change_user(?string $crc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_change_user) && !is_string($crc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_change_user, true), gettype($crc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($crc_change_user) && mb_strlen((string) $crc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $crc_change_user)), __LINE__);
        }
        if (is_null($crc_change_user) || (is_array($crc_change_user) && empty($crc_change_user))) {
            unset($this->crc_change_user);
        } else {
            $this->crc_change_user = $crc_change_user;
        }
        
        return $this;
    }
    /**
     * Get crc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_delete_flag(): ?string
    {
        return $this->crc_delete_flag ?? null;
    }
    /**
     * Set crc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_delete_flag(?string $crc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_delete_flag) && !is_string($crc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_delete_flag, true), gettype($crc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($crc_delete_flag) && $crc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($crc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($crc_delete_flag) && $crc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($crc_delete_flag, true)), __LINE__);
        }
        if (is_null($crc_delete_flag) || (is_array($crc_delete_flag) && empty($crc_delete_flag))) {
            unset($this->crc_delete_flag);
        } else {
            $this->crc_delete_flag = $crc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get crc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_key_ext(): ?string
    {
        return $this->crc_key_ext ?? null;
    }
    /**
     * Set crc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_key_ext(?string $crc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_key_ext) && !is_string($crc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_key_ext, true), gettype($crc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($crc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $crc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($crc_key_ext, true)), __LINE__);
        }
        if (is_null($crc_key_ext) || (is_array($crc_key_ext) && empty($crc_key_ext))) {
            unset($this->crc_key_ext);
        } else {
            $this->crc_key_ext = $crc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get crc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrc_entity_key(): ?string
    {
        return $this->crc_entity_key ?? null;
    }
    /**
     * Set crc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
     */
    public function setCrc_entity_key(?string $crc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($crc_entity_key) && !is_string($crc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crc_entity_key, true), gettype($crc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($crc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $crc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($crc_entity_key, true)), __LINE__);
        }
        if (is_null($crc_entity_key) || (is_array($crc_entity_key) && empty($crc_entity_key))) {
            unset($this->crc_entity_key);
        } else {
            $this->crc_entity_key = $crc_entity_key;
        }
        
        return $this;
    }
}
