<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRequest_Contact_Request_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ContactRequest_Contact_Request_DataObjectType extends AbstractStructBase
{
    /**
     * The cor_key
     * Meta information extracted from the WSDL
     * - documentation: Contact Request. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cor_key = null;
    /**
     * The cor_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer/Contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cor_cst_key = null;
    /**
     * The cor_cro_code
     * Meta information extracted from the WSDL
     * - documentation: Origin. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_cro_code = null;
    /**
     * The cor_rat_code
     * Meta information extracted from the WSDL
     * - documentation: Activity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_rat_code = null;
    /**
     * The cor_crr_code
     * Meta information extracted from the WSDL
     * - documentation: Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_crr_code = null;
    /**
     * The cor_crp_code
     * Meta information extracted from the WSDL
     * - documentation: Priority.This element has a default value of 'Normal'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_crp_code = null;
    /**
     * The cor_crs_code
     * Meta information extracted from the WSDL
     * - documentation: Status.This element has a default value of 'open'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_crs_code = null;
    /**
     * The cor_summary
     * Meta information extracted from the WSDL
     * - documentation: Summary. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_summary = null;
    /**
     * The cor_detail
     * Meta information extracted from the WSDL
     * - documentation: Detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_detail = null;
    /**
     * The cor_email_notif_flag
     * Meta information extracted from the WSDL
     * - documentation: E-mail Notification Flag.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_email_notif_flag = null;
    /**
     * The cor_fax_notif_flag
     * Meta information extracted from the WSDL
     * - documentation: Fax Notification Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_fax_notif_flag = null;
    /**
     * The cor_date_completed
     * Meta information extracted from the WSDL
     * - documentation: Date Completed. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_date_completed = null;
    /**
     * The cor_notif_sent_date
     * Meta information extracted from the WSDL
     * - documentation: Notification Sent Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_notif_sent_date = null;
    /**
     * The cor_auto_assign_flag
     * Meta information extracted from the WSDL
     * - documentation: Automatically Assign.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_auto_assign_flag = null;
    /**
     * The cor_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_add_date = null;
    /**
     * The cor_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_add_user = null;
    /**
     * The cor_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_change_date = null;
    /**
     * The cor_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_change_user = null;
    /**
     * The cor_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_delete_flag = null;
    /**
     * The cor_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cor_entity_key = null;
    /**
     * The cor_ixo_org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: request on behalf of:. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cor_ixo_org_cst_key = null;
    /**
     * The cor_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cor_key_ext = null;
    /**
     * The cor_recno
     * Meta information extracted from the WSDL
     * - documentation: Record Number. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 9223372036854775807
     * - maxOccurs: 1
     * - minInclusive: -9223372036854775808
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cor_recno = null;
    /**
     * The cor_sfo_key
     * Meta information extracted from the WSDL
     * - documentation: Sales Opportunity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cor_sfo_key = null;
    /**
     * The cor_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cor_cct_key = null;
    /**
     * The cor_number
     * Meta information extracted from the WSDL
     * - documentation: Request #. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 94
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_number = null;
    /**
     * The cor_table_name
     * Meta information extracted from the WSDL
     * - documentation: Table Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_table_name = null;
    /**
     * The cor_record_key
     * Meta information extracted from the WSDL
     * - documentation: Record Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cor_record_key = null;
    /**
     * The cor_interaction_date
     * Meta information extracted from the WSDL
     * - documentation: Date.This element has a default value of '7/1/2025'. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cor_interaction_date = null;
    /**
     * Constructor method for ContactRequest_Contact_Request_DataObjectType
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_key()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_cst_key()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_cro_code()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_rat_code()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_crr_code()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_crp_code()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_crs_code()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_summary()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_detail()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_email_notif_flag()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_fax_notif_flag()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_date_completed()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_notif_sent_date()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_auto_assign_flag()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_add_date()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_add_user()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_change_date()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_change_user()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_delete_flag()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_entity_key()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_ixo_org_cst_key()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_key_ext()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_recno()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_sfo_key()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_cct_key()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_number()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_table_name()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_record_key()
     * @uses ContactRequest_Contact_Request_DataObjectType::setCor_interaction_date()
     * @param string $cor_key
     * @param string $cor_cst_key
     * @param string $cor_cro_code
     * @param string $cor_rat_code
     * @param string $cor_crr_code
     * @param string $cor_crp_code
     * @param string $cor_crs_code
     * @param string $cor_summary
     * @param string $cor_detail
     * @param string $cor_email_notif_flag
     * @param string $cor_fax_notif_flag
     * @param string $cor_date_completed
     * @param string $cor_notif_sent_date
     * @param string $cor_auto_assign_flag
     * @param string $cor_add_date
     * @param string $cor_add_user
     * @param string $cor_change_date
     * @param string $cor_change_user
     * @param string $cor_delete_flag
     * @param string $cor_entity_key
     * @param string $cor_ixo_org_cst_key
     * @param string $cor_key_ext
     * @param int $cor_recno
     * @param string $cor_sfo_key
     * @param string $cor_cct_key
     * @param string $cor_number
     * @param string $cor_table_name
     * @param string $cor_record_key
     * @param string $cor_interaction_date
     */
    public function __construct(?string $cor_key = null, ?string $cor_cst_key = null, ?string $cor_cro_code = null, ?string $cor_rat_code = null, ?string $cor_crr_code = null, ?string $cor_crp_code = null, ?string $cor_crs_code = null, ?string $cor_summary = null, ?string $cor_detail = null, ?string $cor_email_notif_flag = null, ?string $cor_fax_notif_flag = null, ?string $cor_date_completed = null, ?string $cor_notif_sent_date = null, ?string $cor_auto_assign_flag = null, ?string $cor_add_date = null, ?string $cor_add_user = null, ?string $cor_change_date = null, ?string $cor_change_user = null, ?string $cor_delete_flag = null, ?string $cor_entity_key = null, ?string $cor_ixo_org_cst_key = null, ?string $cor_key_ext = null, ?int $cor_recno = null, ?string $cor_sfo_key = null, ?string $cor_cct_key = null, ?string $cor_number = null, ?string $cor_table_name = null, ?string $cor_record_key = null, ?string $cor_interaction_date = null)
    {
        $this
            ->setCor_key($cor_key)
            ->setCor_cst_key($cor_cst_key)
            ->setCor_cro_code($cor_cro_code)
            ->setCor_rat_code($cor_rat_code)
            ->setCor_crr_code($cor_crr_code)
            ->setCor_crp_code($cor_crp_code)
            ->setCor_crs_code($cor_crs_code)
            ->setCor_summary($cor_summary)
            ->setCor_detail($cor_detail)
            ->setCor_email_notif_flag($cor_email_notif_flag)
            ->setCor_fax_notif_flag($cor_fax_notif_flag)
            ->setCor_date_completed($cor_date_completed)
            ->setCor_notif_sent_date($cor_notif_sent_date)
            ->setCor_auto_assign_flag($cor_auto_assign_flag)
            ->setCor_add_date($cor_add_date)
            ->setCor_add_user($cor_add_user)
            ->setCor_change_date($cor_change_date)
            ->setCor_change_user($cor_change_user)
            ->setCor_delete_flag($cor_delete_flag)
            ->setCor_entity_key($cor_entity_key)
            ->setCor_ixo_org_cst_key($cor_ixo_org_cst_key)
            ->setCor_key_ext($cor_key_ext)
            ->setCor_recno($cor_recno)
            ->setCor_sfo_key($cor_sfo_key)
            ->setCor_cct_key($cor_cct_key)
            ->setCor_number($cor_number)
            ->setCor_table_name($cor_table_name)
            ->setCor_record_key($cor_record_key)
            ->setCor_interaction_date($cor_interaction_date);
    }
    /**
     * Get cor_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_key(): ?string
    {
        return $this->cor_key ?? null;
    }
    /**
     * Set cor_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_key(?string $cor_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_key) && !is_string($cor_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_key, true), gettype($cor_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cor_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cor_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cor_key, true)), __LINE__);
        }
        if (is_null($cor_key) || (is_array($cor_key) && empty($cor_key))) {
            unset($this->cor_key);
        } else {
            $this->cor_key = $cor_key;
        }
        
        return $this;
    }
    /**
     * Get cor_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_cst_key(): ?string
    {
        return $this->cor_cst_key ?? null;
    }
    /**
     * Set cor_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_cst_key(?string $cor_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_cst_key) && !is_string($cor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_cst_key, true), gettype($cor_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cor_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cor_cst_key, true)), __LINE__);
        }
        if (is_null($cor_cst_key) || (is_array($cor_cst_key) && empty($cor_cst_key))) {
            unset($this->cor_cst_key);
        } else {
            $this->cor_cst_key = $cor_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cor_cro_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_cro_code(): ?string
    {
        return $this->cor_cro_code ?? null;
    }
    /**
     * Set cor_cro_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_cro_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_cro_code(?string $cor_cro_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_cro_code) && !is_string($cor_cro_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_cro_code, true), gettype($cor_cro_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cor_cro_code) && mb_strlen((string) $cor_cro_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cor_cro_code)), __LINE__);
        }
        if (is_null($cor_cro_code) || (is_array($cor_cro_code) && empty($cor_cro_code))) {
            unset($this->cor_cro_code);
        } else {
            $this->cor_cro_code = $cor_cro_code;
        }
        
        return $this;
    }
    /**
     * Get cor_rat_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_rat_code(): ?string
    {
        return $this->cor_rat_code ?? null;
    }
    /**
     * Set cor_rat_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_rat_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_rat_code(?string $cor_rat_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_rat_code) && !is_string($cor_rat_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_rat_code, true), gettype($cor_rat_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cor_rat_code) && mb_strlen((string) $cor_rat_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cor_rat_code)), __LINE__);
        }
        if (is_null($cor_rat_code) || (is_array($cor_rat_code) && empty($cor_rat_code))) {
            unset($this->cor_rat_code);
        } else {
            $this->cor_rat_code = $cor_rat_code;
        }
        
        return $this;
    }
    /**
     * Get cor_crr_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_crr_code(): ?string
    {
        return $this->cor_crr_code ?? null;
    }
    /**
     * Set cor_crr_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_crr_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_crr_code(?string $cor_crr_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_crr_code) && !is_string($cor_crr_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_crr_code, true), gettype($cor_crr_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cor_crr_code) && mb_strlen((string) $cor_crr_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cor_crr_code)), __LINE__);
        }
        if (is_null($cor_crr_code) || (is_array($cor_crr_code) && empty($cor_crr_code))) {
            unset($this->cor_crr_code);
        } else {
            $this->cor_crr_code = $cor_crr_code;
        }
        
        return $this;
    }
    /**
     * Get cor_crp_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_crp_code(): ?string
    {
        return $this->cor_crp_code ?? null;
    }
    /**
     * Set cor_crp_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_crp_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_crp_code(?string $cor_crp_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_crp_code) && !is_string($cor_crp_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_crp_code, true), gettype($cor_crp_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cor_crp_code) && mb_strlen((string) $cor_crp_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cor_crp_code)), __LINE__);
        }
        if (is_null($cor_crp_code) || (is_array($cor_crp_code) && empty($cor_crp_code))) {
            unset($this->cor_crp_code);
        } else {
            $this->cor_crp_code = $cor_crp_code;
        }
        
        return $this;
    }
    /**
     * Get cor_crs_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_crs_code(): ?string
    {
        return $this->cor_crs_code ?? null;
    }
    /**
     * Set cor_crs_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_crs_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_crs_code(?string $cor_crs_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_crs_code) && !is_string($cor_crs_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_crs_code, true), gettype($cor_crs_code)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($cor_crs_code) && mb_strlen((string) $cor_crs_code) > 12) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen((string) $cor_crs_code)), __LINE__);
        }
        if (is_null($cor_crs_code) || (is_array($cor_crs_code) && empty($cor_crs_code))) {
            unset($this->cor_crs_code);
        } else {
            $this->cor_crs_code = $cor_crs_code;
        }
        
        return $this;
    }
    /**
     * Get cor_summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_summary(): ?string
    {
        return $this->cor_summary ?? null;
    }
    /**
     * Set cor_summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_summary
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_summary(?string $cor_summary = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_summary) && !is_string($cor_summary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_summary, true), gettype($cor_summary)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cor_summary) && mb_strlen((string) $cor_summary) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cor_summary)), __LINE__);
        }
        if (is_null($cor_summary) || (is_array($cor_summary) && empty($cor_summary))) {
            unset($this->cor_summary);
        } else {
            $this->cor_summary = $cor_summary;
        }
        
        return $this;
    }
    /**
     * Get cor_detail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_detail(): ?string
    {
        return $this->cor_detail ?? null;
    }
    /**
     * Set cor_detail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_detail
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_detail(?string $cor_detail = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_detail) && !is_string($cor_detail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_detail, true), gettype($cor_detail)), __LINE__);
        }
        if (is_null($cor_detail) || (is_array($cor_detail) && empty($cor_detail))) {
            unset($this->cor_detail);
        } else {
            $this->cor_detail = $cor_detail;
        }
        
        return $this;
    }
    /**
     * Get cor_email_notif_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_email_notif_flag(): ?string
    {
        return $this->cor_email_notif_flag ?? null;
    }
    /**
     * Set cor_email_notif_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_email_notif_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_email_notif_flag(?string $cor_email_notif_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_email_notif_flag) && !is_string($cor_email_notif_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_email_notif_flag, true), gettype($cor_email_notif_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cor_email_notif_flag) && $cor_email_notif_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cor_email_notif_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cor_email_notif_flag) && $cor_email_notif_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cor_email_notif_flag, true)), __LINE__);
        }
        if (is_null($cor_email_notif_flag) || (is_array($cor_email_notif_flag) && empty($cor_email_notif_flag))) {
            unset($this->cor_email_notif_flag);
        } else {
            $this->cor_email_notif_flag = $cor_email_notif_flag;
        }
        
        return $this;
    }
    /**
     * Get cor_fax_notif_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_fax_notif_flag(): ?string
    {
        return $this->cor_fax_notif_flag ?? null;
    }
    /**
     * Set cor_fax_notif_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_fax_notif_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_fax_notif_flag(?string $cor_fax_notif_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_fax_notif_flag) && !is_string($cor_fax_notif_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_fax_notif_flag, true), gettype($cor_fax_notif_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cor_fax_notif_flag) && $cor_fax_notif_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cor_fax_notif_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cor_fax_notif_flag) && $cor_fax_notif_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cor_fax_notif_flag, true)), __LINE__);
        }
        if (is_null($cor_fax_notif_flag) || (is_array($cor_fax_notif_flag) && empty($cor_fax_notif_flag))) {
            unset($this->cor_fax_notif_flag);
        } else {
            $this->cor_fax_notif_flag = $cor_fax_notif_flag;
        }
        
        return $this;
    }
    /**
     * Get cor_date_completed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_date_completed(): ?string
    {
        return $this->cor_date_completed ?? null;
    }
    /**
     * Set cor_date_completed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_date_completed
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_date_completed(?string $cor_date_completed = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_date_completed) && !is_string($cor_date_completed)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_date_completed, true), gettype($cor_date_completed)), __LINE__);
        }
        if (is_null($cor_date_completed) || (is_array($cor_date_completed) && empty($cor_date_completed))) {
            unset($this->cor_date_completed);
        } else {
            $this->cor_date_completed = $cor_date_completed;
        }
        
        return $this;
    }
    /**
     * Get cor_notif_sent_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_notif_sent_date(): ?string
    {
        return $this->cor_notif_sent_date ?? null;
    }
    /**
     * Set cor_notif_sent_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_notif_sent_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_notif_sent_date(?string $cor_notif_sent_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_notif_sent_date) && !is_string($cor_notif_sent_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_notif_sent_date, true), gettype($cor_notif_sent_date)), __LINE__);
        }
        if (is_null($cor_notif_sent_date) || (is_array($cor_notif_sent_date) && empty($cor_notif_sent_date))) {
            unset($this->cor_notif_sent_date);
        } else {
            $this->cor_notif_sent_date = $cor_notif_sent_date;
        }
        
        return $this;
    }
    /**
     * Get cor_auto_assign_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_auto_assign_flag(): ?string
    {
        return $this->cor_auto_assign_flag ?? null;
    }
    /**
     * Set cor_auto_assign_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_auto_assign_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_auto_assign_flag(?string $cor_auto_assign_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_auto_assign_flag) && !is_string($cor_auto_assign_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_auto_assign_flag, true), gettype($cor_auto_assign_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cor_auto_assign_flag) && $cor_auto_assign_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cor_auto_assign_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cor_auto_assign_flag) && $cor_auto_assign_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cor_auto_assign_flag, true)), __LINE__);
        }
        if (is_null($cor_auto_assign_flag) || (is_array($cor_auto_assign_flag) && empty($cor_auto_assign_flag))) {
            unset($this->cor_auto_assign_flag);
        } else {
            $this->cor_auto_assign_flag = $cor_auto_assign_flag;
        }
        
        return $this;
    }
    /**
     * Get cor_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_add_date(): ?string
    {
        return $this->cor_add_date ?? null;
    }
    /**
     * Set cor_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_add_date(?string $cor_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_add_date) && !is_string($cor_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_add_date, true), gettype($cor_add_date)), __LINE__);
        }
        if (is_null($cor_add_date) || (is_array($cor_add_date) && empty($cor_add_date))) {
            unset($this->cor_add_date);
        } else {
            $this->cor_add_date = $cor_add_date;
        }
        
        return $this;
    }
    /**
     * Get cor_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_add_user(): ?string
    {
        return $this->cor_add_user ?? null;
    }
    /**
     * Set cor_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_add_user(?string $cor_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_add_user) && !is_string($cor_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_add_user, true), gettype($cor_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cor_add_user) && mb_strlen((string) $cor_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cor_add_user)), __LINE__);
        }
        if (is_null($cor_add_user) || (is_array($cor_add_user) && empty($cor_add_user))) {
            unset($this->cor_add_user);
        } else {
            $this->cor_add_user = $cor_add_user;
        }
        
        return $this;
    }
    /**
     * Get cor_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_change_date(): ?string
    {
        return $this->cor_change_date ?? null;
    }
    /**
     * Set cor_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_change_date(?string $cor_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_change_date) && !is_string($cor_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_change_date, true), gettype($cor_change_date)), __LINE__);
        }
        if (is_null($cor_change_date) || (is_array($cor_change_date) && empty($cor_change_date))) {
            unset($this->cor_change_date);
        } else {
            $this->cor_change_date = $cor_change_date;
        }
        
        return $this;
    }
    /**
     * Get cor_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_change_user(): ?string
    {
        return $this->cor_change_user ?? null;
    }
    /**
     * Set cor_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_change_user(?string $cor_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_change_user) && !is_string($cor_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_change_user, true), gettype($cor_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cor_change_user) && mb_strlen((string) $cor_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cor_change_user)), __LINE__);
        }
        if (is_null($cor_change_user) || (is_array($cor_change_user) && empty($cor_change_user))) {
            unset($this->cor_change_user);
        } else {
            $this->cor_change_user = $cor_change_user;
        }
        
        return $this;
    }
    /**
     * Get cor_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_delete_flag(): ?string
    {
        return $this->cor_delete_flag ?? null;
    }
    /**
     * Set cor_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_delete_flag(?string $cor_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_delete_flag) && !is_string($cor_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_delete_flag, true), gettype($cor_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cor_delete_flag) && $cor_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cor_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cor_delete_flag) && $cor_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cor_delete_flag, true)), __LINE__);
        }
        if (is_null($cor_delete_flag) || (is_array($cor_delete_flag) && empty($cor_delete_flag))) {
            unset($this->cor_delete_flag);
        } else {
            $this->cor_delete_flag = $cor_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cor_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_entity_key(): ?string
    {
        return $this->cor_entity_key ?? null;
    }
    /**
     * Set cor_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_entity_key(?string $cor_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_entity_key) && !is_string($cor_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_entity_key, true), gettype($cor_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cor_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cor_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cor_entity_key, true)), __LINE__);
        }
        if (is_null($cor_entity_key) || (is_array($cor_entity_key) && empty($cor_entity_key))) {
            unset($this->cor_entity_key);
        } else {
            $this->cor_entity_key = $cor_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cor_ixo_org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_ixo_org_cst_key(): ?string
    {
        return $this->cor_ixo_org_cst_key ?? null;
    }
    /**
     * Set cor_ixo_org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_ixo_org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_ixo_org_cst_key(?string $cor_ixo_org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_ixo_org_cst_key) && !is_string($cor_ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_ixo_org_cst_key, true), gettype($cor_ixo_org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cor_ixo_org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cor_ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cor_ixo_org_cst_key, true)), __LINE__);
        }
        if (is_null($cor_ixo_org_cst_key) || (is_array($cor_ixo_org_cst_key) && empty($cor_ixo_org_cst_key))) {
            unset($this->cor_ixo_org_cst_key);
        } else {
            $this->cor_ixo_org_cst_key = $cor_ixo_org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cor_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_key_ext(): ?string
    {
        return $this->cor_key_ext ?? null;
    }
    /**
     * Set cor_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_key_ext(?string $cor_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_key_ext) && !is_string($cor_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_key_ext, true), gettype($cor_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cor_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cor_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cor_key_ext, true)), __LINE__);
        }
        if (is_null($cor_key_ext) || (is_array($cor_key_ext) && empty($cor_key_ext))) {
            unset($this->cor_key_ext);
        } else {
            $this->cor_key_ext = $cor_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cor_recno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCor_recno(): ?int
    {
        return $this->cor_recno ?? null;
    }
    /**
     * Set cor_recno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cor_recno
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_recno(?int $cor_recno = null): self
    {
        // validation for constraint: int
        if (!is_null($cor_recno) && !(is_int($cor_recno) || ctype_digit($cor_recno))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cor_recno, true), gettype($cor_recno)), __LINE__);
        }
        // validation for constraint: maxInclusive(9223372036854775807)
        if (!is_null($cor_recno) && $cor_recno > 9223372036854775807) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9223372036854775807', var_export($cor_recno, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9223372036854775808)
        if (!is_null($cor_recno) && $cor_recno < -9223372036854775808) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9223372036854775808', var_export($cor_recno, true)), __LINE__);
        }
        if (is_null($cor_recno) || (is_array($cor_recno) && empty($cor_recno))) {
            unset($this->cor_recno);
        } else {
            $this->cor_recno = $cor_recno;
        }
        
        return $this;
    }
    /**
     * Get cor_sfo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_sfo_key(): ?string
    {
        return $this->cor_sfo_key ?? null;
    }
    /**
     * Set cor_sfo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_sfo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_sfo_key(?string $cor_sfo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_sfo_key) && !is_string($cor_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_sfo_key, true), gettype($cor_sfo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cor_sfo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cor_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cor_sfo_key, true)), __LINE__);
        }
        if (is_null($cor_sfo_key) || (is_array($cor_sfo_key) && empty($cor_sfo_key))) {
            unset($this->cor_sfo_key);
        } else {
            $this->cor_sfo_key = $cor_sfo_key;
        }
        
        return $this;
    }
    /**
     * Get cor_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_cct_key(): ?string
    {
        return $this->cor_cct_key ?? null;
    }
    /**
     * Set cor_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_cct_key(?string $cor_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_cct_key) && !is_string($cor_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_cct_key, true), gettype($cor_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cor_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cor_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cor_cct_key, true)), __LINE__);
        }
        if (is_null($cor_cct_key) || (is_array($cor_cct_key) && empty($cor_cct_key))) {
            unset($this->cor_cct_key);
        } else {
            $this->cor_cct_key = $cor_cct_key;
        }
        
        return $this;
    }
    /**
     * Get cor_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_number(): ?string
    {
        return $this->cor_number ?? null;
    }
    /**
     * Set cor_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_number(?string $cor_number = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_number) && !is_string($cor_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_number, true), gettype($cor_number)), __LINE__);
        }
        // validation for constraint: maxLength(94)
        if (!is_null($cor_number) && mb_strlen((string) $cor_number) > 94) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 94', mb_strlen((string) $cor_number)), __LINE__);
        }
        if (is_null($cor_number) || (is_array($cor_number) && empty($cor_number))) {
            unset($this->cor_number);
        } else {
            $this->cor_number = $cor_number;
        }
        
        return $this;
    }
    /**
     * Get cor_table_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_table_name(): ?string
    {
        return $this->cor_table_name ?? null;
    }
    /**
     * Set cor_table_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_table_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_table_name(?string $cor_table_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_table_name) && !is_string($cor_table_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_table_name, true), gettype($cor_table_name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($cor_table_name) && mb_strlen((string) $cor_table_name) > 128) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen((string) $cor_table_name)), __LINE__);
        }
        if (is_null($cor_table_name) || (is_array($cor_table_name) && empty($cor_table_name))) {
            unset($this->cor_table_name);
        } else {
            $this->cor_table_name = $cor_table_name;
        }
        
        return $this;
    }
    /**
     * Get cor_record_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_record_key(): ?string
    {
        return $this->cor_record_key ?? null;
    }
    /**
     * Set cor_record_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_record_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_record_key(?string $cor_record_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_record_key) && !is_string($cor_record_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_record_key, true), gettype($cor_record_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cor_record_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cor_record_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cor_record_key, true)), __LINE__);
        }
        if (is_null($cor_record_key) || (is_array($cor_record_key) && empty($cor_record_key))) {
            unset($this->cor_record_key);
        } else {
            $this->cor_record_key = $cor_record_key;
        }
        
        return $this;
    }
    /**
     * Get cor_interaction_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCor_interaction_date(): ?string
    {
        return $this->cor_interaction_date ?? null;
    }
    /**
     * Set cor_interaction_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cor_interaction_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
     */
    public function setCor_interaction_date(?string $cor_interaction_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cor_interaction_date) && !is_string($cor_interaction_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cor_interaction_date, true), gettype($cor_interaction_date)), __LINE__);
        }
        if (is_null($cor_interaction_date) || (is_array($cor_interaction_date) && empty($cor_interaction_date))) {
            unset($this->cor_interaction_date);
        } else {
            $this->cor_interaction_date = $cor_interaction_date;
        }
        
        return $this;
    }
}
