<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRequest_Customer_Alias_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ContactRequest_Customer_Alias_DataObjectType extends AbstractStructBase
{
    /**
     * The cal_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cal_key = null;
    /**
     * The cal_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cal_cst_key = null;
    /**
     * The cal_alias
     * Meta information extracted from the WSDL
     * - documentation: Name Alias. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cal_alias = null;
    /**
     * The cal_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cal_add_user = null;
    /**
     * The cal_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cal_add_date = null;
    /**
     * The cal_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cal_change_user = null;
    /**
     * The cal_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cal_change_date = null;
    /**
     * The cal_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cal_delete_flag = null;
    /**
     * The cal_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cal_entity_key = null;
    /**
     * The cal_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cal_key_ext = null;
    /**
     * Constructor method for ContactRequest_Customer_Alias_DataObjectType
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_key()
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_cst_key()
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_alias()
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_add_user()
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_add_date()
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_change_user()
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_change_date()
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_delete_flag()
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_entity_key()
     * @uses ContactRequest_Customer_Alias_DataObjectType::setCal_key_ext()
     * @param string $cal_key
     * @param string $cal_cst_key
     * @param string $cal_alias
     * @param string $cal_add_user
     * @param string $cal_add_date
     * @param string $cal_change_user
     * @param string $cal_change_date
     * @param string $cal_delete_flag
     * @param string $cal_entity_key
     * @param string $cal_key_ext
     */
    public function __construct(?string $cal_key = null, ?string $cal_cst_key = null, ?string $cal_alias = null, ?string $cal_add_user = null, ?string $cal_add_date = null, ?string $cal_change_user = null, ?string $cal_change_date = null, ?string $cal_delete_flag = null, ?string $cal_entity_key = null, ?string $cal_key_ext = null)
    {
        $this
            ->setCal_key($cal_key)
            ->setCal_cst_key($cal_cst_key)
            ->setCal_alias($cal_alias)
            ->setCal_add_user($cal_add_user)
            ->setCal_add_date($cal_add_date)
            ->setCal_change_user($cal_change_user)
            ->setCal_change_date($cal_change_date)
            ->setCal_delete_flag($cal_delete_flag)
            ->setCal_entity_key($cal_entity_key)
            ->setCal_key_ext($cal_key_ext);
    }
    /**
     * Get cal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_key(): ?string
    {
        return $this->cal_key ?? null;
    }
    /**
     * Set cal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_key(?string $cal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_key) && !is_string($cal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_key, true), gettype($cal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cal_key, true)), __LINE__);
        }
        if (is_null($cal_key) || (is_array($cal_key) && empty($cal_key))) {
            unset($this->cal_key);
        } else {
            $this->cal_key = $cal_key;
        }
        
        return $this;
    }
    /**
     * Get cal_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_cst_key(): ?string
    {
        return $this->cal_cst_key ?? null;
    }
    /**
     * Set cal_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_cst_key(?string $cal_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_cst_key) && !is_string($cal_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_cst_key, true), gettype($cal_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cal_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cal_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cal_cst_key, true)), __LINE__);
        }
        if (is_null($cal_cst_key) || (is_array($cal_cst_key) && empty($cal_cst_key))) {
            unset($this->cal_cst_key);
        } else {
            $this->cal_cst_key = $cal_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cal_alias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_alias(): ?string
    {
        return $this->cal_alias ?? null;
    }
    /**
     * Set cal_alias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_alias
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_alias(?string $cal_alias = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_alias) && !is_string($cal_alias)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_alias, true), gettype($cal_alias)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cal_alias) && mb_strlen((string) $cal_alias) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cal_alias)), __LINE__);
        }
        if (is_null($cal_alias) || (is_array($cal_alias) && empty($cal_alias))) {
            unset($this->cal_alias);
        } else {
            $this->cal_alias = $cal_alias;
        }
        
        return $this;
    }
    /**
     * Get cal_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_add_user(): ?string
    {
        return $this->cal_add_user ?? null;
    }
    /**
     * Set cal_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_add_user(?string $cal_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_add_user) && !is_string($cal_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_add_user, true), gettype($cal_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cal_add_user) && mb_strlen((string) $cal_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cal_add_user)), __LINE__);
        }
        if (is_null($cal_add_user) || (is_array($cal_add_user) && empty($cal_add_user))) {
            unset($this->cal_add_user);
        } else {
            $this->cal_add_user = $cal_add_user;
        }
        
        return $this;
    }
    /**
     * Get cal_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_add_date(): ?string
    {
        return $this->cal_add_date ?? null;
    }
    /**
     * Set cal_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_add_date(?string $cal_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_add_date) && !is_string($cal_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_add_date, true), gettype($cal_add_date)), __LINE__);
        }
        if (is_null($cal_add_date) || (is_array($cal_add_date) && empty($cal_add_date))) {
            unset($this->cal_add_date);
        } else {
            $this->cal_add_date = $cal_add_date;
        }
        
        return $this;
    }
    /**
     * Get cal_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_change_user(): ?string
    {
        return $this->cal_change_user ?? null;
    }
    /**
     * Set cal_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_change_user(?string $cal_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_change_user) && !is_string($cal_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_change_user, true), gettype($cal_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cal_change_user) && mb_strlen((string) $cal_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cal_change_user)), __LINE__);
        }
        if (is_null($cal_change_user) || (is_array($cal_change_user) && empty($cal_change_user))) {
            unset($this->cal_change_user);
        } else {
            $this->cal_change_user = $cal_change_user;
        }
        
        return $this;
    }
    /**
     * Get cal_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_change_date(): ?string
    {
        return $this->cal_change_date ?? null;
    }
    /**
     * Set cal_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_change_date(?string $cal_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_change_date) && !is_string($cal_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_change_date, true), gettype($cal_change_date)), __LINE__);
        }
        if (is_null($cal_change_date) || (is_array($cal_change_date) && empty($cal_change_date))) {
            unset($this->cal_change_date);
        } else {
            $this->cal_change_date = $cal_change_date;
        }
        
        return $this;
    }
    /**
     * Get cal_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_delete_flag(): ?string
    {
        return $this->cal_delete_flag ?? null;
    }
    /**
     * Set cal_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_delete_flag(?string $cal_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_delete_flag) && !is_string($cal_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_delete_flag, true), gettype($cal_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cal_delete_flag) && $cal_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cal_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cal_delete_flag) && $cal_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cal_delete_flag, true)), __LINE__);
        }
        if (is_null($cal_delete_flag) || (is_array($cal_delete_flag) && empty($cal_delete_flag))) {
            unset($this->cal_delete_flag);
        } else {
            $this->cal_delete_flag = $cal_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cal_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_entity_key(): ?string
    {
        return $this->cal_entity_key ?? null;
    }
    /**
     * Set cal_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_entity_key(?string $cal_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_entity_key) && !is_string($cal_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_entity_key, true), gettype($cal_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cal_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cal_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cal_entity_key, true)), __LINE__);
        }
        if (is_null($cal_entity_key) || (is_array($cal_entity_key) && empty($cal_entity_key))) {
            unset($this->cal_entity_key);
        } else {
            $this->cal_entity_key = $cal_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cal_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCal_key_ext(): ?string
    {
        return $this->cal_key_ext ?? null;
    }
    /**
     * Set cal_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cal_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
     */
    public function setCal_key_ext(?string $cal_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cal_key_ext) && !is_string($cal_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cal_key_ext, true), gettype($cal_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cal_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cal_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cal_key_ext, true)), __LINE__);
        }
        if (is_null($cal_key_ext) || (is_array($cal_key_ext) && empty($cal_key_ext))) {
            unset($this->cal_key_ext);
        } else {
            $this->cal_key_ext = $cal_key_ext;
        }
        
        return $this;
    }
}
