<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerAddressType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CustomerAddressType extends AbstractStructBase
{
    /**
     * The Address_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_XRef_DataObjectType $Address_XRef = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Customer_DataObjectType $Customer = null;
    /**
     * The Individual
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Individual_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Individual_DataObjectType $Individual = null;
    /**
     * The Organization
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Organization_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Organization_DataObjectType $Organization = null;
    /**
     * The Chapter
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType $Chapter = null;
    /**
     * The Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_DataObjectType $Address = null;
    /**
     * The Address_Change_Log
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_Change_Log_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_Change_Log_DataObjectType $Address_Change_Log = null;
    /**
     * The Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Country_DataObjectType $Country = null;
    /**
     * The Primary_Affiliation
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType $Primary_Affiliation = null;
    /**
     * The StateTerritory
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_StateTerritory_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_StateTerritory_DataObjectType $StateTerritory = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Unique Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for CustomerAddressType
     * @uses CustomerAddressType::setAddress_XRef()
     * @uses CustomerAddressType::setCustomer()
     * @uses CustomerAddressType::setIndividual()
     * @uses CustomerAddressType::setOrganization()
     * @uses CustomerAddressType::setChapter()
     * @uses CustomerAddressType::setAddress()
     * @uses CustomerAddressType::setAddress_Change_Log()
     * @uses CustomerAddressType::setCountry()
     * @uses CustomerAddressType::setPrimary_Affiliation()
     * @uses CustomerAddressType::setStateTerritory()
     * @uses CustomerAddressType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_XRef_DataObjectType $address_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Individual_DataObjectType $individual
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Organization_DataObjectType $organization
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType $chapter
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_DataObjectType $address
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_Change_Log_DataObjectType $address_Change_Log
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Country_DataObjectType $country
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType $primary_Affiliation
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_StateTerritory_DataObjectType $stateTerritory
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_XRef_DataObjectType $address_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Individual_DataObjectType $individual = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Organization_DataObjectType $organization = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType $chapter = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_DataObjectType $address = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_Change_Log_DataObjectType $address_Change_Log = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Country_DataObjectType $country = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType $primary_Affiliation = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_StateTerritory_DataObjectType $stateTerritory = null, ?string $currentKey = null)
    {
        $this
            ->setAddress_XRef($address_XRef)
            ->setCustomer($customer)
            ->setIndividual($individual)
            ->setOrganization($organization)
            ->setChapter($chapter)
            ->setAddress($address)
            ->setAddress_Change_Log($address_Change_Log)
            ->setCountry($country)
            ->setPrimary_Affiliation($primary_Affiliation)
            ->setStateTerritory($stateTerritory)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Address_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_XRef_DataObjectType|null
     */
    public function getAddress_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_XRef_DataObjectType
    {
        return $this->Address_XRef;
    }
    /**
     * Set Address_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_XRef_DataObjectType $address_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setAddress_XRef(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_XRef_DataObjectType $address_XRef = null): self
    {
        $this->Address_XRef = $address_XRef;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Individual value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Individual_DataObjectType|null
     */
    public function getIndividual(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Individual_DataObjectType
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Individual_DataObjectType $individual
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setIndividual(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Individual_DataObjectType $individual = null): self
    {
        $this->Individual = $individual;
        
        return $this;
    }
    /**
     * Get Organization value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Organization_DataObjectType|null
     */
    public function getOrganization(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Organization_DataObjectType
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Organization_DataObjectType $organization
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setOrganization(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Organization_DataObjectType $organization = null): self
    {
        $this->Organization = $organization;
        
        return $this;
    }
    /**
     * Get Chapter value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType|null
     */
    public function getChapter(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
    {
        return $this->Chapter;
    }
    /**
     * Set Chapter value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType $chapter
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setChapter(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType $chapter = null): self
    {
        $this->Chapter = $chapter;
        
        return $this;
    }
    /**
     * Get Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_DataObjectType|null
     */
    public function getAddress(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_DataObjectType
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_DataObjectType $address
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setAddress(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_DataObjectType $address = null): self
    {
        $this->Address = $address;
        
        return $this;
    }
    /**
     * Get Address_Change_Log value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_Change_Log_DataObjectType|null
     */
    public function getAddress_Change_Log(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_Change_Log_DataObjectType
    {
        return $this->Address_Change_Log;
    }
    /**
     * Set Address_Change_Log value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_Change_Log_DataObjectType $address_Change_Log
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setAddress_Change_Log(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Address_Change_Log_DataObjectType $address_Change_Log = null): self
    {
        $this->Address_Change_Log = $address_Change_Log;
        
        return $this;
    }
    /**
     * Get Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Country_DataObjectType|null
     */
    public function getCountry(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Country_DataObjectType
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Country_DataObjectType $country
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setCountry(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Country_DataObjectType $country = null): self
    {
        $this->Country = $country;
        
        return $this;
    }
    /**
     * Get Primary_Affiliation value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType|null
     */
    public function getPrimary_Affiliation(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType
    {
        return $this->Primary_Affiliation;
    }
    /**
     * Set Primary_Affiliation value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType $primary_Affiliation
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setPrimary_Affiliation(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Primary_Affiliation_DataObjectType $primary_Affiliation = null): self
    {
        $this->Primary_Affiliation = $primary_Affiliation;
        
        return $this;
    }
    /**
     * Get StateTerritory value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_StateTerritory_DataObjectType|null
     */
    public function getStateTerritory(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_StateTerritory_DataObjectType
    {
        return $this->StateTerritory;
    }
    /**
     * Set StateTerritory value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_StateTerritory_DataObjectType $stateTerritory
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setStateTerritory(?\Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_StateTerritory_DataObjectType $stateTerritory = null): self
    {
        $this->StateTerritory = $stateTerritory;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerAddressType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
