<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerEmailType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CustomerEmailType extends AbstractStructBase
{
    /**
     * The Email
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Email_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Email_DataObjectType $Email = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Customer_DataObjectType $Customer = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Email Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for CustomerEmailType
     * @uses CustomerEmailType::setEmail()
     * @uses CustomerEmailType::setCustomer()
     * @uses CustomerEmailType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Email_DataObjectType $email
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Customer_DataObjectType $customer
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Email_DataObjectType $email = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Customer_DataObjectType $customer = null, ?string $currentKey = null)
    {
        $this
            ->setEmail($email)
            ->setCustomer($customer)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Email value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Email_DataObjectType|null
     */
    public function getEmail(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Email_DataObjectType
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Email_DataObjectType $email
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerEmailType
     */
    public function setEmail(?\Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Email_DataObjectType $email = null): self
    {
        $this->Email = $email;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerEmailType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\IndividualEmail_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerEmailType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
