<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerFaxType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CustomerFaxType extends AbstractStructBase
{
    /**
     * The Fax_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_XRef_DataObjectType $Fax_XRef = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Customer_DataObjectType $Customer = null;
    /**
     * The Fax
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_DataObjectType $Fax = null;
    /**
     * The Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Country_DataObjectType $Country = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Unique Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for CustomerFaxType
     * @uses CustomerFaxType::setFax_XRef()
     * @uses CustomerFaxType::setCustomer()
     * @uses CustomerFaxType::setFax()
     * @uses CustomerFaxType::setCountry()
     * @uses CustomerFaxType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_XRef_DataObjectType $fax_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_DataObjectType $fax
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Country_DataObjectType $country
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_XRef_DataObjectType $fax_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_DataObjectType $fax = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Country_DataObjectType $country = null, ?string $currentKey = null)
    {
        $this
            ->setFax_XRef($fax_XRef)
            ->setCustomer($customer)
            ->setFax($fax)
            ->setCountry($country)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Fax_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_XRef_DataObjectType|null
     */
    public function getFax_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_XRef_DataObjectType
    {
        return $this->Fax_XRef;
    }
    /**
     * Set Fax_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_XRef_DataObjectType $fax_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerFaxType
     */
    public function setFax_XRef(?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_XRef_DataObjectType $fax_XRef = null): self
    {
        $this->Fax_XRef = $fax_XRef;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerFaxType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Fax value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_DataObjectType|null
     */
    public function getFax(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_DataObjectType
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_DataObjectType $fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerFaxType
     */
    public function setFax(?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Fax_DataObjectType $fax = null): self
    {
        $this->Fax = $fax;
        
        return $this;
    }
    /**
     * Get Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Country_DataObjectType|null
     */
    public function getCountry(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Country_DataObjectType
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Country_DataObjectType $country
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerFaxType
     */
    public function setCountry(?\Drupal\netforum\xWeb\Generated\StructType\IndividualFax_Country_DataObjectType $country = null): self
    {
        $this->Country = $country;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerFaxType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
