<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPhoneType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CustomerPhoneType extends AbstractStructBase
{
    /**
     * The Phone_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_XRef_DataObjectType $Phone_XRef = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType $Customer = null;
    /**
     * The Phone
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_DataObjectType $Phone = null;
    /**
     * The Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Country_DataObjectType $Country = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Unique Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for CustomerPhoneType
     * @uses CustomerPhoneType::setPhone_XRef()
     * @uses CustomerPhoneType::setCustomer()
     * @uses CustomerPhoneType::setPhone()
     * @uses CustomerPhoneType::setCountry()
     * @uses CustomerPhoneType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_XRef_DataObjectType $phone_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_DataObjectType $phone
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Country_DataObjectType $country
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_XRef_DataObjectType $phone_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_DataObjectType $phone = null, ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Country_DataObjectType $country = null, ?string $currentKey = null)
    {
        $this
            ->setPhone_XRef($phone_XRef)
            ->setCustomer($customer)
            ->setPhone($phone)
            ->setCountry($country)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Phone_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_XRef_DataObjectType|null
     */
    public function getPhone_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_XRef_DataObjectType
    {
        return $this->Phone_XRef;
    }
    /**
     * Set Phone_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_XRef_DataObjectType $phone_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerPhoneType
     */
    public function setPhone_XRef(?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_XRef_DataObjectType $phone_XRef = null): self
    {
        $this->Phone_XRef = $phone_XRef;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerPhoneType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Phone value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_DataObjectType|null
     */
    public function getPhone(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_DataObjectType
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_DataObjectType $phone
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerPhoneType
     */
    public function setPhone(?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Phone_DataObjectType $phone = null): self
    {
        $this->Phone = $phone;
        
        return $this;
    }
    /**
     * Get Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Country_DataObjectType|null
     */
    public function getCountry(): ?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Country_DataObjectType
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Country_DataObjectType $country
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerPhoneType
     */
    public function setCountry(?\Drupal\netforum\xWeb\Generated\StructType\IndividualPhone_Country_DataObjectType $country = null): self
    {
        $this->Country = $country;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\CustomerPhoneType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
