<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType extends AbstractStructBase
{
    /**
     * The ert_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ert_key = null;
    /**
     * The ert_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ert_add_user = null;
    /**
     * The ert_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ert_add_date = null;
    /**
     * The ert_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ert_change_user = null;
    /**
     * The ert_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ert_change_date = null;
    /**
     * The ert_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ert_delete_flag = null;
    /**
     * The ert_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ert_key_ext = null;
    /**
     * The ert_evl_key
     * Meta information extracted from the WSDL
     * - documentation: Event Location. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ert_evl_key = null;
    /**
     * The ert_rate
     * Meta information extracted from the WSDL
     * - documentation: Rate. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ert_rate = null;
    /**
     * The ert_deposit
     * Meta information extracted from the WSDL
     * - documentation: Deposit. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ert_deposit = null;
    /**
     * The ert_rmt_key
     * Meta information extracted from the WSDL
     * - documentation: Room Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ert_rmt_key = null;
    /**
     * The ert_qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ert_qty = null;
    /**
     * The ert_non_smoking_flag
     * Meta information extracted from the WSDL
     * - documentation: Non Smoking Room. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ert_non_smoking_flag = null;
    /**
     * The ert_from_date
     * Meta information extracted from the WSDL
     * - documentation: Available From. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ert_from_date = null;
    /**
     * The ert_through_date
     * Meta information extracted from the WSDL
     * - documentation: Available Through. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ert_through_date = null;
    /**
     * The ert_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ert_entity_key = null;
    /**
     * Constructor method for
     * EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_key()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_add_user()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_add_date()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_change_user()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_change_date()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_delete_flag()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_key_ext()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_evl_key()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_rate()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_deposit()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_rmt_key()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_qty()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_non_smoking_flag()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_from_date()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_through_date()
     * @uses EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType::setErt_entity_key()
     * @param string $ert_key
     * @param string $ert_add_user
     * @param string $ert_add_date
     * @param string $ert_change_user
     * @param string $ert_change_date
     * @param string $ert_delete_flag
     * @param string $ert_key_ext
     * @param string $ert_evl_key
     * @param float $ert_rate
     * @param float $ert_deposit
     * @param string $ert_rmt_key
     * @param int $ert_qty
     * @param string $ert_non_smoking_flag
     * @param string $ert_from_date
     * @param string $ert_through_date
     * @param string $ert_entity_key
     */
    public function __construct(?string $ert_key = null, ?string $ert_add_user = null, ?string $ert_add_date = null, ?string $ert_change_user = null, ?string $ert_change_date = null, ?string $ert_delete_flag = null, ?string $ert_key_ext = null, ?string $ert_evl_key = null, ?float $ert_rate = null, ?float $ert_deposit = null, ?string $ert_rmt_key = null, ?int $ert_qty = null, ?string $ert_non_smoking_flag = null, ?string $ert_from_date = null, ?string $ert_through_date = null, ?string $ert_entity_key = null)
    {
        $this
            ->setErt_key($ert_key)
            ->setErt_add_user($ert_add_user)
            ->setErt_add_date($ert_add_date)
            ->setErt_change_user($ert_change_user)
            ->setErt_change_date($ert_change_date)
            ->setErt_delete_flag($ert_delete_flag)
            ->setErt_key_ext($ert_key_ext)
            ->setErt_evl_key($ert_evl_key)
            ->setErt_rate($ert_rate)
            ->setErt_deposit($ert_deposit)
            ->setErt_rmt_key($ert_rmt_key)
            ->setErt_qty($ert_qty)
            ->setErt_non_smoking_flag($ert_non_smoking_flag)
            ->setErt_from_date($ert_from_date)
            ->setErt_through_date($ert_through_date)
            ->setErt_entity_key($ert_entity_key);
    }
    /**
     * Get ert_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_key(): ?string
    {
        return $this->ert_key ?? null;
    }
    /**
     * Set ert_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_key(?string $ert_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_key) && !is_string($ert_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_key, true), gettype($ert_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ert_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ert_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ert_key, true)), __LINE__);
        }
        if (is_null($ert_key) || (is_array($ert_key) && empty($ert_key))) {
            unset($this->ert_key);
        } else {
            $this->ert_key = $ert_key;
        }
        
        return $this;
    }
    /**
     * Get ert_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_add_user(): ?string
    {
        return $this->ert_add_user ?? null;
    }
    /**
     * Set ert_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_add_user(?string $ert_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_add_user) && !is_string($ert_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_add_user, true), gettype($ert_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ert_add_user) && mb_strlen((string) $ert_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ert_add_user)), __LINE__);
        }
        if (is_null($ert_add_user) || (is_array($ert_add_user) && empty($ert_add_user))) {
            unset($this->ert_add_user);
        } else {
            $this->ert_add_user = $ert_add_user;
        }
        
        return $this;
    }
    /**
     * Get ert_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_add_date(): ?string
    {
        return $this->ert_add_date ?? null;
    }
    /**
     * Set ert_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_add_date(?string $ert_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_add_date) && !is_string($ert_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_add_date, true), gettype($ert_add_date)), __LINE__);
        }
        if (is_null($ert_add_date) || (is_array($ert_add_date) && empty($ert_add_date))) {
            unset($this->ert_add_date);
        } else {
            $this->ert_add_date = $ert_add_date;
        }
        
        return $this;
    }
    /**
     * Get ert_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_change_user(): ?string
    {
        return $this->ert_change_user ?? null;
    }
    /**
     * Set ert_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_change_user(?string $ert_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_change_user) && !is_string($ert_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_change_user, true), gettype($ert_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ert_change_user) && mb_strlen((string) $ert_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ert_change_user)), __LINE__);
        }
        if (is_null($ert_change_user) || (is_array($ert_change_user) && empty($ert_change_user))) {
            unset($this->ert_change_user);
        } else {
            $this->ert_change_user = $ert_change_user;
        }
        
        return $this;
    }
    /**
     * Get ert_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_change_date(): ?string
    {
        return $this->ert_change_date ?? null;
    }
    /**
     * Set ert_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_change_date(?string $ert_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_change_date) && !is_string($ert_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_change_date, true), gettype($ert_change_date)), __LINE__);
        }
        if (is_null($ert_change_date) || (is_array($ert_change_date) && empty($ert_change_date))) {
            unset($this->ert_change_date);
        } else {
            $this->ert_change_date = $ert_change_date;
        }
        
        return $this;
    }
    /**
     * Get ert_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_delete_flag(): ?string
    {
        return $this->ert_delete_flag ?? null;
    }
    /**
     * Set ert_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_delete_flag(?string $ert_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_delete_flag) && !is_string($ert_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_delete_flag, true), gettype($ert_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ert_delete_flag) && $ert_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ert_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ert_delete_flag) && $ert_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ert_delete_flag, true)), __LINE__);
        }
        if (is_null($ert_delete_flag) || (is_array($ert_delete_flag) && empty($ert_delete_flag))) {
            unset($this->ert_delete_flag);
        } else {
            $this->ert_delete_flag = $ert_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ert_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_key_ext(): ?string
    {
        return $this->ert_key_ext ?? null;
    }
    /**
     * Set ert_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_key_ext(?string $ert_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_key_ext) && !is_string($ert_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_key_ext, true), gettype($ert_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ert_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ert_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ert_key_ext, true)), __LINE__);
        }
        if (is_null($ert_key_ext) || (is_array($ert_key_ext) && empty($ert_key_ext))) {
            unset($this->ert_key_ext);
        } else {
            $this->ert_key_ext = $ert_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ert_evl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_evl_key(): ?string
    {
        return $this->ert_evl_key ?? null;
    }
    /**
     * Set ert_evl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_evl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_evl_key(?string $ert_evl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_evl_key) && !is_string($ert_evl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_evl_key, true), gettype($ert_evl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ert_evl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ert_evl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ert_evl_key, true)), __LINE__);
        }
        if (is_null($ert_evl_key) || (is_array($ert_evl_key) && empty($ert_evl_key))) {
            unset($this->ert_evl_key);
        } else {
            $this->ert_evl_key = $ert_evl_key;
        }
        
        return $this;
    }
    /**
     * Get ert_rate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getErt_rate(): ?float
    {
        return $this->ert_rate ?? null;
    }
    /**
     * Set ert_rate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ert_rate
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_rate(?float $ert_rate = null): self
    {
        // validation for constraint: float
        if (!is_null($ert_rate) && !(is_float($ert_rate) || is_numeric($ert_rate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ert_rate, true), gettype($ert_rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ert_rate) && mb_strlen(mb_substr((string) $ert_rate, false !== mb_strpos((string) $ert_rate, '.') ? mb_strpos((string) $ert_rate, '.') + 1 : mb_strlen((string) $ert_rate))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ert_rate, true), mb_strlen(mb_substr((string) $ert_rate, mb_strpos((string) $ert_rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ert_rate) && mb_strlen(preg_replace('/(\D)/', '', (string) $ert_rate)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ert_rate, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ert_rate))), __LINE__);
        }
        if (is_null($ert_rate) || (is_array($ert_rate) && empty($ert_rate))) {
            unset($this->ert_rate);
        } else {
            $this->ert_rate = $ert_rate;
        }
        
        return $this;
    }
    /**
     * Get ert_deposit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getErt_deposit(): ?float
    {
        return $this->ert_deposit ?? null;
    }
    /**
     * Set ert_deposit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ert_deposit
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_deposit(?float $ert_deposit = null): self
    {
        // validation for constraint: float
        if (!is_null($ert_deposit) && !(is_float($ert_deposit) || is_numeric($ert_deposit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ert_deposit, true), gettype($ert_deposit)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ert_deposit) && mb_strlen(mb_substr((string) $ert_deposit, false !== mb_strpos((string) $ert_deposit, '.') ? mb_strpos((string) $ert_deposit, '.') + 1 : mb_strlen((string) $ert_deposit))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ert_deposit, true), mb_strlen(mb_substr((string) $ert_deposit, mb_strpos((string) $ert_deposit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ert_deposit) && mb_strlen(preg_replace('/(\D)/', '', (string) $ert_deposit)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ert_deposit, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ert_deposit))), __LINE__);
        }
        if (is_null($ert_deposit) || (is_array($ert_deposit) && empty($ert_deposit))) {
            unset($this->ert_deposit);
        } else {
            $this->ert_deposit = $ert_deposit;
        }
        
        return $this;
    }
    /**
     * Get ert_rmt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_rmt_key(): ?string
    {
        return $this->ert_rmt_key ?? null;
    }
    /**
     * Set ert_rmt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_rmt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_rmt_key(?string $ert_rmt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_rmt_key) && !is_string($ert_rmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_rmt_key, true), gettype($ert_rmt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ert_rmt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ert_rmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ert_rmt_key, true)), __LINE__);
        }
        if (is_null($ert_rmt_key) || (is_array($ert_rmt_key) && empty($ert_rmt_key))) {
            unset($this->ert_rmt_key);
        } else {
            $this->ert_rmt_key = $ert_rmt_key;
        }
        
        return $this;
    }
    /**
     * Get ert_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getErt_qty(): ?int
    {
        return $this->ert_qty ?? null;
    }
    /**
     * Set ert_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ert_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_qty(?int $ert_qty = null): self
    {
        // validation for constraint: int
        if (!is_null($ert_qty) && !(is_int($ert_qty) || ctype_digit($ert_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ert_qty, true), gettype($ert_qty)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ert_qty) && $ert_qty > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ert_qty, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ert_qty) && $ert_qty < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ert_qty, true)), __LINE__);
        }
        if (is_null($ert_qty) || (is_array($ert_qty) && empty($ert_qty))) {
            unset($this->ert_qty);
        } else {
            $this->ert_qty = $ert_qty;
        }
        
        return $this;
    }
    /**
     * Get ert_non_smoking_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_non_smoking_flag(): ?string
    {
        return $this->ert_non_smoking_flag ?? null;
    }
    /**
     * Set ert_non_smoking_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_non_smoking_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_non_smoking_flag(?string $ert_non_smoking_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_non_smoking_flag) && !is_string($ert_non_smoking_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_non_smoking_flag, true), gettype($ert_non_smoking_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ert_non_smoking_flag) && $ert_non_smoking_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ert_non_smoking_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ert_non_smoking_flag) && $ert_non_smoking_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ert_non_smoking_flag, true)), __LINE__);
        }
        if (is_null($ert_non_smoking_flag) || (is_array($ert_non_smoking_flag) && empty($ert_non_smoking_flag))) {
            unset($this->ert_non_smoking_flag);
        } else {
            $this->ert_non_smoking_flag = $ert_non_smoking_flag;
        }
        
        return $this;
    }
    /**
     * Get ert_from_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_from_date(): ?string
    {
        return $this->ert_from_date ?? null;
    }
    /**
     * Set ert_from_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_from_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_from_date(?string $ert_from_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_from_date) && !is_string($ert_from_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_from_date, true), gettype($ert_from_date)), __LINE__);
        }
        if (is_null($ert_from_date) || (is_array($ert_from_date) && empty($ert_from_date))) {
            unset($this->ert_from_date);
        } else {
            $this->ert_from_date = $ert_from_date;
        }
        
        return $this;
    }
    /**
     * Get ert_through_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_through_date(): ?string
    {
        return $this->ert_through_date ?? null;
    }
    /**
     * Set ert_through_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_through_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_through_date(?string $ert_through_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_through_date) && !is_string($ert_through_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_through_date, true), gettype($ert_through_date)), __LINE__);
        }
        if (is_null($ert_through_date) || (is_array($ert_through_date) && empty($ert_through_date))) {
            unset($this->ert_through_date);
        } else {
            $this->ert_through_date = $ert_through_date;
        }
        
        return $this;
    }
    /**
     * Get ert_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErt_entity_key(): ?string
    {
        return $this->ert_entity_key ?? null;
    }
    /**
     * Set ert_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ert_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Event_Location_Room_Type_DataObjectType
     */
    public function setErt_entity_key(?string $ert_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ert_entity_key) && !is_string($ert_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ert_entity_key, true), gettype($ert_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ert_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ert_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ert_entity_key, true)), __LINE__);
        }
        if (is_null($ert_entity_key) || (is_array($ert_entity_key) && empty($ert_entity_key))) {
            unset($this->ert_entity_key);
        } else {
            $this->ert_entity_key = $ert_entity_key;
        }
        
        return $this;
    }
}
