<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrantGroup_Group_Registration_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrantGroup_Group_Registration_DataObjectType extends AbstractStructBase
{
    /**
     * The egp_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_key = null;
    /**
     * The egp_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: individual customer key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_ind_cst_key = null;
    /**
     * The egp_org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: organization customer key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_org_cst_key = null;
    /**
     * The egp_cmt_key
     * Meta information extracted from the WSDL
     * - documentation: Committee Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_cmt_key = null;
    /**
     * The egp_evt_key
     * Meta information extracted from the WSDL
     * - documentation: event key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_evt_key = null;
    /**
     * The egp_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_add_user = null;
    /**
     * The egp_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_add_date = null;
    /**
     * The egp_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_change_user = null;
    /**
     * The egp_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_change_date = null;
    /**
     * The egp_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_delete_flag = null;
    /**
     * The egp_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_key_ext = null;
    /**
     * The egp_inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_inv_code = null;
    /**
     * The egp_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_src_key = null;
    /**
     * The egp_registration_date
     * Meta information extracted from the WSDL
     * - documentation: Registration Date.This element has a default value of '7/1/2025'. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_registration_date = null;
    /**
     * The egp_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_cxa_key = null;
    /**
     * The egp_cph_key
     * Meta information extracted from the WSDL
     * - documentation: Phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_cph_key = null;
    /**
     * The egp_eml_key
     * Meta information extracted from the WSDL
     * - documentation: Email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_eml_key = null;
    /**
     * The egp_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_cfx_key = null;
    /**
     * The egp_url_key
     * Meta information extracted from the WSDL
     * - documentation: Website. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_url_key = null;
    /**
     * The egp_rgt_key
     * Meta information extracted from the WSDL
     * - documentation: Registrant Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_rgt_key = null;
    /**
     * The egp_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Preferred Communication Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_pref_comm_meth = null;
    /**
     * The egp_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_entity_key = null;
    /**
     * The egp_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: Cancellation Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_cancel_date = null;
    /**
     * The egp_cancel_reason
     * Meta information extracted from the WSDL
     * - documentation: Cancellation Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $egp_cancel_reason = null;
    /**
     * The egp_number_of_registrants
     * Meta information extracted from the WSDL
     * - documentation: Number Of Registrants.This element has a default value of '1'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $egp_number_of_registrants = null;
    /**
     * The egp_bup_prd_key
     * Meta information extracted from the WSDL
     * - documentation: bundle component product key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $egp_bup_prd_key = null;
    /**
     * Constructor method for EventsRegistrantGroup_Group_Registration_DataObjectType
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_ind_cst_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_org_cst_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_cmt_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_evt_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_add_user()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_add_date()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_change_user()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_change_date()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_delete_flag()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_key_ext()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_inv_code()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_src_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_registration_date()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_cxa_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_cph_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_eml_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_cfx_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_url_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_rgt_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_pref_comm_meth()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_entity_key()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_cancel_date()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_cancel_reason()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_number_of_registrants()
     * @uses EventsRegistrantGroup_Group_Registration_DataObjectType::setEgp_bup_prd_key()
     * @param string $egp_key
     * @param string $egp_ind_cst_key
     * @param string $egp_org_cst_key
     * @param string $egp_cmt_key
     * @param string $egp_evt_key
     * @param string $egp_add_user
     * @param string $egp_add_date
     * @param string $egp_change_user
     * @param string $egp_change_date
     * @param string $egp_delete_flag
     * @param string $egp_key_ext
     * @param string $egp_inv_code
     * @param string $egp_src_key
     * @param string $egp_registration_date
     * @param string $egp_cxa_key
     * @param string $egp_cph_key
     * @param string $egp_eml_key
     * @param string $egp_cfx_key
     * @param string $egp_url_key
     * @param string $egp_rgt_key
     * @param string $egp_pref_comm_meth
     * @param string $egp_entity_key
     * @param string $egp_cancel_date
     * @param string $egp_cancel_reason
     * @param int $egp_number_of_registrants
     * @param string $egp_bup_prd_key
     */
    public function __construct(?string $egp_key = null, ?string $egp_ind_cst_key = null, ?string $egp_org_cst_key = null, ?string $egp_cmt_key = null, ?string $egp_evt_key = null, ?string $egp_add_user = null, ?string $egp_add_date = null, ?string $egp_change_user = null, ?string $egp_change_date = null, ?string $egp_delete_flag = null, ?string $egp_key_ext = null, ?string $egp_inv_code = null, ?string $egp_src_key = null, ?string $egp_registration_date = null, ?string $egp_cxa_key = null, ?string $egp_cph_key = null, ?string $egp_eml_key = null, ?string $egp_cfx_key = null, ?string $egp_url_key = null, ?string $egp_rgt_key = null, ?string $egp_pref_comm_meth = null, ?string $egp_entity_key = null, ?string $egp_cancel_date = null, ?string $egp_cancel_reason = null, ?int $egp_number_of_registrants = null, ?string $egp_bup_prd_key = null)
    {
        $this
            ->setEgp_key($egp_key)
            ->setEgp_ind_cst_key($egp_ind_cst_key)
            ->setEgp_org_cst_key($egp_org_cst_key)
            ->setEgp_cmt_key($egp_cmt_key)
            ->setEgp_evt_key($egp_evt_key)
            ->setEgp_add_user($egp_add_user)
            ->setEgp_add_date($egp_add_date)
            ->setEgp_change_user($egp_change_user)
            ->setEgp_change_date($egp_change_date)
            ->setEgp_delete_flag($egp_delete_flag)
            ->setEgp_key_ext($egp_key_ext)
            ->setEgp_inv_code($egp_inv_code)
            ->setEgp_src_key($egp_src_key)
            ->setEgp_registration_date($egp_registration_date)
            ->setEgp_cxa_key($egp_cxa_key)
            ->setEgp_cph_key($egp_cph_key)
            ->setEgp_eml_key($egp_eml_key)
            ->setEgp_cfx_key($egp_cfx_key)
            ->setEgp_url_key($egp_url_key)
            ->setEgp_rgt_key($egp_rgt_key)
            ->setEgp_pref_comm_meth($egp_pref_comm_meth)
            ->setEgp_entity_key($egp_entity_key)
            ->setEgp_cancel_date($egp_cancel_date)
            ->setEgp_cancel_reason($egp_cancel_reason)
            ->setEgp_number_of_registrants($egp_number_of_registrants)
            ->setEgp_bup_prd_key($egp_bup_prd_key);
    }
    /**
     * Get egp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_key(): ?string
    {
        return $this->egp_key ?? null;
    }
    /**
     * Set egp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_key(?string $egp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_key) && !is_string($egp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_key, true), gettype($egp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_key, true)), __LINE__);
        }
        if (is_null($egp_key) || (is_array($egp_key) && empty($egp_key))) {
            unset($this->egp_key);
        } else {
            $this->egp_key = $egp_key;
        }
        
        return $this;
    }
    /**
     * Get egp_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_ind_cst_key(): ?string
    {
        return $this->egp_ind_cst_key ?? null;
    }
    /**
     * Set egp_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_ind_cst_key(?string $egp_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_ind_cst_key) && !is_string($egp_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_ind_cst_key, true), gettype($egp_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_ind_cst_key, true)), __LINE__);
        }
        if (is_null($egp_ind_cst_key) || (is_array($egp_ind_cst_key) && empty($egp_ind_cst_key))) {
            unset($this->egp_ind_cst_key);
        } else {
            $this->egp_ind_cst_key = $egp_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get egp_org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_org_cst_key(): ?string
    {
        return $this->egp_org_cst_key ?? null;
    }
    /**
     * Set egp_org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_org_cst_key(?string $egp_org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_org_cst_key) && !is_string($egp_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_org_cst_key, true), gettype($egp_org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_org_cst_key, true)), __LINE__);
        }
        if (is_null($egp_org_cst_key) || (is_array($egp_org_cst_key) && empty($egp_org_cst_key))) {
            unset($this->egp_org_cst_key);
        } else {
            $this->egp_org_cst_key = $egp_org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get egp_cmt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_cmt_key(): ?string
    {
        return $this->egp_cmt_key ?? null;
    }
    /**
     * Set egp_cmt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_cmt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_cmt_key(?string $egp_cmt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_cmt_key) && !is_string($egp_cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_cmt_key, true), gettype($egp_cmt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_cmt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_cmt_key, true)), __LINE__);
        }
        if (is_null($egp_cmt_key) || (is_array($egp_cmt_key) && empty($egp_cmt_key))) {
            unset($this->egp_cmt_key);
        } else {
            $this->egp_cmt_key = $egp_cmt_key;
        }
        
        return $this;
    }
    /**
     * Get egp_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_evt_key(): ?string
    {
        return $this->egp_evt_key ?? null;
    }
    /**
     * Set egp_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_evt_key(?string $egp_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_evt_key) && !is_string($egp_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_evt_key, true), gettype($egp_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_evt_key, true)), __LINE__);
        }
        if (is_null($egp_evt_key) || (is_array($egp_evt_key) && empty($egp_evt_key))) {
            unset($this->egp_evt_key);
        } else {
            $this->egp_evt_key = $egp_evt_key;
        }
        
        return $this;
    }
    /**
     * Get egp_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_add_user(): ?string
    {
        return $this->egp_add_user ?? null;
    }
    /**
     * Set egp_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_add_user(?string $egp_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_add_user) && !is_string($egp_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_add_user, true), gettype($egp_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($egp_add_user) && mb_strlen((string) $egp_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $egp_add_user)), __LINE__);
        }
        if (is_null($egp_add_user) || (is_array($egp_add_user) && empty($egp_add_user))) {
            unset($this->egp_add_user);
        } else {
            $this->egp_add_user = $egp_add_user;
        }
        
        return $this;
    }
    /**
     * Get egp_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_add_date(): ?string
    {
        return $this->egp_add_date ?? null;
    }
    /**
     * Set egp_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_add_date(?string $egp_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_add_date) && !is_string($egp_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_add_date, true), gettype($egp_add_date)), __LINE__);
        }
        if (is_null($egp_add_date) || (is_array($egp_add_date) && empty($egp_add_date))) {
            unset($this->egp_add_date);
        } else {
            $this->egp_add_date = $egp_add_date;
        }
        
        return $this;
    }
    /**
     * Get egp_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_change_user(): ?string
    {
        return $this->egp_change_user ?? null;
    }
    /**
     * Set egp_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_change_user(?string $egp_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_change_user) && !is_string($egp_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_change_user, true), gettype($egp_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($egp_change_user) && mb_strlen((string) $egp_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $egp_change_user)), __LINE__);
        }
        if (is_null($egp_change_user) || (is_array($egp_change_user) && empty($egp_change_user))) {
            unset($this->egp_change_user);
        } else {
            $this->egp_change_user = $egp_change_user;
        }
        
        return $this;
    }
    /**
     * Get egp_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_change_date(): ?string
    {
        return $this->egp_change_date ?? null;
    }
    /**
     * Set egp_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_change_date(?string $egp_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_change_date) && !is_string($egp_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_change_date, true), gettype($egp_change_date)), __LINE__);
        }
        if (is_null($egp_change_date) || (is_array($egp_change_date) && empty($egp_change_date))) {
            unset($this->egp_change_date);
        } else {
            $this->egp_change_date = $egp_change_date;
        }
        
        return $this;
    }
    /**
     * Get egp_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_delete_flag(): ?string
    {
        return $this->egp_delete_flag ?? null;
    }
    /**
     * Set egp_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_delete_flag(?string $egp_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_delete_flag) && !is_string($egp_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_delete_flag, true), gettype($egp_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($egp_delete_flag) && $egp_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($egp_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($egp_delete_flag) && $egp_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($egp_delete_flag, true)), __LINE__);
        }
        if (is_null($egp_delete_flag) || (is_array($egp_delete_flag) && empty($egp_delete_flag))) {
            unset($this->egp_delete_flag);
        } else {
            $this->egp_delete_flag = $egp_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get egp_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_key_ext(): ?string
    {
        return $this->egp_key_ext ?? null;
    }
    /**
     * Set egp_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_key_ext(?string $egp_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_key_ext) && !is_string($egp_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_key_ext, true), gettype($egp_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_key_ext, true)), __LINE__);
        }
        if (is_null($egp_key_ext) || (is_array($egp_key_ext) && empty($egp_key_ext))) {
            unset($this->egp_key_ext);
        } else {
            $this->egp_key_ext = $egp_key_ext;
        }
        
        return $this;
    }
    /**
     * Get egp_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_inv_code(): ?string
    {
        return $this->egp_inv_code ?? null;
    }
    /**
     * Set egp_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_inv_code(?string $egp_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_inv_code) && !is_string($egp_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_inv_code, true), gettype($egp_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($egp_inv_code) && mb_strlen((string) $egp_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $egp_inv_code)), __LINE__);
        }
        if (is_null($egp_inv_code) || (is_array($egp_inv_code) && empty($egp_inv_code))) {
            unset($this->egp_inv_code);
        } else {
            $this->egp_inv_code = $egp_inv_code;
        }
        
        return $this;
    }
    /**
     * Get egp_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_src_key(): ?string
    {
        return $this->egp_src_key ?? null;
    }
    /**
     * Set egp_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_src_key(?string $egp_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_src_key) && !is_string($egp_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_src_key, true), gettype($egp_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_src_key, true)), __LINE__);
        }
        if (is_null($egp_src_key) || (is_array($egp_src_key) && empty($egp_src_key))) {
            unset($this->egp_src_key);
        } else {
            $this->egp_src_key = $egp_src_key;
        }
        
        return $this;
    }
    /**
     * Get egp_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_registration_date(): ?string
    {
        return $this->egp_registration_date ?? null;
    }
    /**
     * Set egp_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_registration_date(?string $egp_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_registration_date) && !is_string($egp_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_registration_date, true), gettype($egp_registration_date)), __LINE__);
        }
        if (is_null($egp_registration_date) || (is_array($egp_registration_date) && empty($egp_registration_date))) {
            unset($this->egp_registration_date);
        } else {
            $this->egp_registration_date = $egp_registration_date;
        }
        
        return $this;
    }
    /**
     * Get egp_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_cxa_key(): ?string
    {
        return $this->egp_cxa_key ?? null;
    }
    /**
     * Set egp_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_cxa_key(?string $egp_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_cxa_key) && !is_string($egp_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_cxa_key, true), gettype($egp_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_cxa_key, true)), __LINE__);
        }
        if (is_null($egp_cxa_key) || (is_array($egp_cxa_key) && empty($egp_cxa_key))) {
            unset($this->egp_cxa_key);
        } else {
            $this->egp_cxa_key = $egp_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get egp_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_cph_key(): ?string
    {
        return $this->egp_cph_key ?? null;
    }
    /**
     * Set egp_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_cph_key(?string $egp_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_cph_key) && !is_string($egp_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_cph_key, true), gettype($egp_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_cph_key, true)), __LINE__);
        }
        if (is_null($egp_cph_key) || (is_array($egp_cph_key) && empty($egp_cph_key))) {
            unset($this->egp_cph_key);
        } else {
            $this->egp_cph_key = $egp_cph_key;
        }
        
        return $this;
    }
    /**
     * Get egp_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_eml_key(): ?string
    {
        return $this->egp_eml_key ?? null;
    }
    /**
     * Set egp_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_eml_key(?string $egp_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_eml_key) && !is_string($egp_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_eml_key, true), gettype($egp_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_eml_key, true)), __LINE__);
        }
        if (is_null($egp_eml_key) || (is_array($egp_eml_key) && empty($egp_eml_key))) {
            unset($this->egp_eml_key);
        } else {
            $this->egp_eml_key = $egp_eml_key;
        }
        
        return $this;
    }
    /**
     * Get egp_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_cfx_key(): ?string
    {
        return $this->egp_cfx_key ?? null;
    }
    /**
     * Set egp_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_cfx_key(?string $egp_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_cfx_key) && !is_string($egp_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_cfx_key, true), gettype($egp_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_cfx_key, true)), __LINE__);
        }
        if (is_null($egp_cfx_key) || (is_array($egp_cfx_key) && empty($egp_cfx_key))) {
            unset($this->egp_cfx_key);
        } else {
            $this->egp_cfx_key = $egp_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get egp_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_url_key(): ?string
    {
        return $this->egp_url_key ?? null;
    }
    /**
     * Set egp_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_url_key(?string $egp_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_url_key) && !is_string($egp_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_url_key, true), gettype($egp_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_url_key, true)), __LINE__);
        }
        if (is_null($egp_url_key) || (is_array($egp_url_key) && empty($egp_url_key))) {
            unset($this->egp_url_key);
        } else {
            $this->egp_url_key = $egp_url_key;
        }
        
        return $this;
    }
    /**
     * Get egp_rgt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_rgt_key(): ?string
    {
        return $this->egp_rgt_key ?? null;
    }
    /**
     * Set egp_rgt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_rgt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_rgt_key(?string $egp_rgt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_rgt_key) && !is_string($egp_rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_rgt_key, true), gettype($egp_rgt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_rgt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_rgt_key, true)), __LINE__);
        }
        if (is_null($egp_rgt_key) || (is_array($egp_rgt_key) && empty($egp_rgt_key))) {
            unset($this->egp_rgt_key);
        } else {
            $this->egp_rgt_key = $egp_rgt_key;
        }
        
        return $this;
    }
    /**
     * Get egp_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_pref_comm_meth(): ?string
    {
        return $this->egp_pref_comm_meth ?? null;
    }
    /**
     * Set egp_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_pref_comm_meth(?string $egp_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_pref_comm_meth) && !is_string($egp_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_pref_comm_meth, true), gettype($egp_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($egp_pref_comm_meth) && mb_strlen((string) $egp_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $egp_pref_comm_meth)), __LINE__);
        }
        if (is_null($egp_pref_comm_meth) || (is_array($egp_pref_comm_meth) && empty($egp_pref_comm_meth))) {
            unset($this->egp_pref_comm_meth);
        } else {
            $this->egp_pref_comm_meth = $egp_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get egp_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_entity_key(): ?string
    {
        return $this->egp_entity_key ?? null;
    }
    /**
     * Set egp_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_entity_key(?string $egp_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_entity_key) && !is_string($egp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_entity_key, true), gettype($egp_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_entity_key, true)), __LINE__);
        }
        if (is_null($egp_entity_key) || (is_array($egp_entity_key) && empty($egp_entity_key))) {
            unset($this->egp_entity_key);
        } else {
            $this->egp_entity_key = $egp_entity_key;
        }
        
        return $this;
    }
    /**
     * Get egp_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_cancel_date(): ?string
    {
        return $this->egp_cancel_date ?? null;
    }
    /**
     * Set egp_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_cancel_date(?string $egp_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_cancel_date) && !is_string($egp_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_cancel_date, true), gettype($egp_cancel_date)), __LINE__);
        }
        if (is_null($egp_cancel_date) || (is_array($egp_cancel_date) && empty($egp_cancel_date))) {
            unset($this->egp_cancel_date);
        } else {
            $this->egp_cancel_date = $egp_cancel_date;
        }
        
        return $this;
    }
    /**
     * Get egp_cancel_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_cancel_reason(): ?string
    {
        return $this->egp_cancel_reason ?? null;
    }
    /**
     * Set egp_cancel_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_cancel_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_cancel_reason(?string $egp_cancel_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_cancel_reason) && !is_string($egp_cancel_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_cancel_reason, true), gettype($egp_cancel_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($egp_cancel_reason) && mb_strlen((string) $egp_cancel_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $egp_cancel_reason)), __LINE__);
        }
        if (is_null($egp_cancel_reason) || (is_array($egp_cancel_reason) && empty($egp_cancel_reason))) {
            unset($this->egp_cancel_reason);
        } else {
            $this->egp_cancel_reason = $egp_cancel_reason;
        }
        
        return $this;
    }
    /**
     * Get egp_number_of_registrants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEgp_number_of_registrants(): ?int
    {
        return $this->egp_number_of_registrants ?? null;
    }
    /**
     * Set egp_number_of_registrants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $egp_number_of_registrants
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_number_of_registrants(?int $egp_number_of_registrants = null): self
    {
        // validation for constraint: int
        if (!is_null($egp_number_of_registrants) && !(is_int($egp_number_of_registrants) || ctype_digit($egp_number_of_registrants))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($egp_number_of_registrants, true), gettype($egp_number_of_registrants)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($egp_number_of_registrants) && $egp_number_of_registrants > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($egp_number_of_registrants, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($egp_number_of_registrants) && $egp_number_of_registrants < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($egp_number_of_registrants, true)), __LINE__);
        }
        if (is_null($egp_number_of_registrants) || (is_array($egp_number_of_registrants) && empty($egp_number_of_registrants))) {
            unset($this->egp_number_of_registrants);
        } else {
            $this->egp_number_of_registrants = $egp_number_of_registrants;
        }
        
        return $this;
    }
    /**
     * Get egp_bup_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEgp_bup_prd_key(): ?string
    {
        return $this->egp_bup_prd_key ?? null;
    }
    /**
     * Set egp_bup_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $egp_bup_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Group_Registration_DataObjectType
     */
    public function setEgp_bup_prd_key(?string $egp_bup_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($egp_bup_prd_key) && !is_string($egp_bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($egp_bup_prd_key, true), gettype($egp_bup_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($egp_bup_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $egp_bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($egp_bup_prd_key, true)), __LINE__);
        }
        if (is_null($egp_bup_prd_key) || (is_array($egp_bup_prd_key) && empty($egp_bup_prd_key))) {
            unset($this->egp_bup_prd_key);
        } else {
            $this->egp_bup_prd_key = $egp_bup_prd_key;
        }
        
        return $this;
    }
}
