<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrantSession_ev_event_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrantSession_ev_event_DataObjectType extends AbstractStructBase
{
    /**
     * The evt_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_key = null;
    /**
     * The evt_code
     * Meta information extracted from the WSDL
     * - documentation: Event Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_code = null;
    /**
     * The evt_etp_key
     * Meta information extracted from the WSDL
     * - documentation: Event Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_etp_key = null;
    /**
     * The evt_title
     * Meta information extracted from the WSDL
     * - documentation: Event Title. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_title = null;
    /**
     * The evt_capacity
     * Meta information extracted from the WSDL
     * - documentation: Capacity. This field has this Input Mask: 99999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $evt_capacity = null;
    /**
     * The evt_registrant_goal
     * Meta information extracted from the WSDL
     * - documentation: registration goal. This field has this Input Mask: 99999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $evt_registrant_goal = null;
    /**
     * The evt_revenue_goal
     * Meta information extracted from the WSDL
     * - documentation: revenue goal. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $evt_revenue_goal = null;
    /**
     * The evt_display_order
     * Meta information extracted from the WSDL
     * - documentation: display order. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $evt_display_order = null;
    /**
     * The evt_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: allow wait list. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_wait_list_flag = null;
    /**
     * The evt_auto_register_wait_list
     * Meta information extracted from the WSDL
     * - documentation: auto register from wait list. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_auto_register_wait_list = null;
    /**
     * The evt_check_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: no reg if wait list. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_check_wait_list_flag = null;
    /**
     * The evt_registration_required
     * Meta information extracted from the WSDL
     * - documentation: registration required. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_registration_required = null;
    /**
     * The evt_group_reg_based_on_ind
     * Meta information extracted from the WSDL
     * - documentation: Group Registration Pricing Bas. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_group_reg_based_on_ind = null;
    /**
     * The evt_estimated_attendance
     * Meta information extracted from the WSDL
     * - documentation: estimated attendance. This field has this Input Mask: 99999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $evt_estimated_attendance = null;
    /**
     * The evt_guaranteed_attendance
     * Meta information extracted from the WSDL
     * - documentation: guaranteed attendance. This field has this Input Mask: 99999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $evt_guaranteed_attendance = null;
    /**
     * The evt_restricted
     * Meta information extracted from the WSDL
     * - documentation: Restricted?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_restricted = null;
    /**
     * The evt_short_description
     * Meta information extracted from the WSDL
     * - documentation: Short Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 400
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_short_description = null;
    /**
     * The evt_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_description = null;
    /**
     * The evt_description_html
     * Meta information extracted from the WSDL
     * - documentation: Description (HTML). | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_description_html = null;
    /**
     * The evt_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_start_date = null;
    /**
     * The evt_start_time
     * Meta information extracted from the WSDL
     * - documentation: Start Time. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_start_time = null;
    /**
     * The evt_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_end_date = null;
    /**
     * The evt_end_time
     * Meta information extracted from the WSDL
     * - documentation: End Time. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_end_time = null;
    /**
     * The evt_early_registration_date
     * Meta information extracted from the WSDL
     * - documentation: early registration cutoff. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_early_registration_date = null;
    /**
     * The evt_late_registration_date
     * Meta information extracted from the WSDL
     * - documentation: late registration cutoff. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_late_registration_date = null;
    /**
     * The evt_time_format
     * Meta information extracted from the WSDL
     * - documentation: time format. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_time_format = null;
    /**
     * The evt_date_format
     * Meta information extracted from the WSDL
     * - documentation: date format. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_date_format = null;
    /**
     * The evt_cutoff_date
     * Meta information extracted from the WSDL
     * - documentation: Cut-Off Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_cutoff_date = null;
    /**
     * The evt_post_to_web_date
     * Meta information extracted from the WSDL
     * - documentation: post to web date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_post_to_web_date = null;
    /**
     * The evt_remove_from_web_date
     * Meta information extracted from the WSDL
     * - documentation: remove from web date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_remove_from_web_date = null;
    /**
     * The evt_event_url
     * Meta information extracted from the WSDL
     * - documentation: Event URL. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_event_url = null;
    /**
     * The evt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_add_user = null;
    /**
     * The evt_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_add_date = null;
    /**
     * The evt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_change_user = null;
    /**
     * The evt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_change_date = null;
    /**
     * The evt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_delete_flag = null;
    /**
     * The evt_asn_code
     * Meta information extracted from the WSDL
     * - documentation: Association Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_asn_code = null;
    /**
     * The evt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_key_ext = null;
    /**
     * The evt_sponsor_limit
     * Meta information extracted from the WSDL
     * - documentation: Max Sponsors Allowed. This field has this Input Mask: 99999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $evt_sponsor_limit = null;
    /**
     * The evt_pre_registration_date
     * Meta information extracted from the WSDL
     * - documentation: pre registration cutoff. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_pre_registration_date = null;
    /**
     * The evt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_entity_key = null;
    /**
     * The evt_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Confirmation Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_cct_key = null;
    /**
     * The evt_evt_key
     * Meta information extracted from the WSDL
     * - documentation: Parent Event. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_evt_key = null;
    /**
     * The evt_tzn_key
     * Meta information extracted from the WSDL
     * - documentation: time zone.This element has a default value of '059930c3-7d4e-46d9-8a59-e3c95a2a19cd'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_tzn_key = null;
    /**
     * The evt_etc_key
     * Meta information extracted from the WSDL
     * - documentation: Event Category. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_etc_key = null;
    /**
     * The evt_abstract_flag
     * Meta information extracted from the WSDL
     * - documentation: Abstract. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_abstract_flag = null;
    /**
     * The evt_abstract_member_option
     * Meta information extracted from the WSDL
     * - documentation: abstract member option. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_abstract_member_option = null;
    /**
     * The evt_abstract_deadline
     * Meta information extracted from the WSDL
     * - documentation: Abstract Deadline. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_abstract_deadline = null;
    /**
     * The evt_closed_flag
     * Meta information extracted from the WSDL
     * - documentation: Closed?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_closed_flag = null;
    /**
     * The evt_free_event_flag
     * Meta information extracted from the WSDL
     * - documentation: Free Event. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_free_event_flag = null;
    /**
     * The evt_regid_counter
     * Meta information extracted from the WSDL
     * - documentation: reg ID counter. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 9223372036854775807
     * - maxOccurs: 1
     * - minInclusive: -9223372036854775808
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $evt_regid_counter = null;
    /**
     * The evt_guest_limit
     * Meta information extracted from the WSDL
     * - documentation: Max Guests allowed. This field has this Input Mask: 99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $evt_guest_limit = null;
    /**
     * The evt_free_guest_flag
     * Meta information extracted from the WSDL
     * - documentation: free guest. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_free_guest_flag = null;
    /**
     * The evt_fpc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: fundraising product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_fpc_prd_key = null;
    /**
     * The evt_wait_list_limit
     * Meta information extracted from the WSDL
     * - documentation: wait list limit. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $evt_wait_list_limit = null;
    /**
     * The evt_charity_event_flag
     * Meta information extracted from the WSDL
     * - documentation: charity event.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_charity_event_flag = null;
    /**
     * The evt_expense_generated_date
     * Meta information extracted from the WSDL
     * - documentation: Expense Generated Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_expense_generated_date = null;
    /**
     * The evt_narrative_template
     * Meta information extracted from the WSDL
     * - documentation: Narrative template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_narrative_template = null;
    /**
     * The evt_video_url
     * Meta information extracted from the WSDL
     * - documentation: Video URL. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_video_url = null;
    /**
     * The evt_cancellation_cutoff_date
     * Meta information extracted from the WSDL
     * - documentation: Event Cancellation Cutoff Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_cancellation_cutoff_date = null;
    /**
     * The evt_cct_cancellation_key
     * Meta information extracted from the WSDL
     * - documentation: Cancellation Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evt_cct_cancellation_key = null;
    /**
     * The evt_ceu_earn_date_field
     * Meta information extracted from the WSDL
     * - documentation: CEU Earn Date Field. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_ceu_earn_date_field = null;
    /**
     * The evt_waiver_flag
     * Meta information extracted from the WSDL
     * - documentation: Waiver?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_waiver_flag = null;
    /**
     * The evt_waiver_text
     * Meta information extracted from the WSDL
     * - documentation: Waiver. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evt_waiver_text = null;
    /**
     * Constructor method for EventsRegistrantSession_ev_event_DataObjectType
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_key()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_code()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_etp_key()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_title()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_capacity()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_registrant_goal()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_revenue_goal()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_display_order()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_wait_list_flag()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_auto_register_wait_list()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_check_wait_list_flag()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_registration_required()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_group_reg_based_on_ind()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_estimated_attendance()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_guaranteed_attendance()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_restricted()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_short_description()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_description()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_description_html()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_start_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_start_time()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_end_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_end_time()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_early_registration_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_late_registration_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_time_format()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_date_format()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_cutoff_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_post_to_web_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_remove_from_web_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_event_url()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_add_user()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_add_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_change_user()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_change_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_delete_flag()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_asn_code()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_key_ext()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_sponsor_limit()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_pre_registration_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_entity_key()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_cct_key()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_evt_key()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_tzn_key()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_etc_key()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_abstract_flag()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_abstract_member_option()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_abstract_deadline()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_closed_flag()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_free_event_flag()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_regid_counter()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_guest_limit()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_free_guest_flag()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_fpc_prd_key()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_wait_list_limit()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_charity_event_flag()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_expense_generated_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_narrative_template()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_video_url()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_cancellation_cutoff_date()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_cct_cancellation_key()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_ceu_earn_date_field()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_waiver_flag()
     * @uses EventsRegistrantSession_ev_event_DataObjectType::setEvt_waiver_text()
     * @param string $evt_key
     * @param string $evt_code
     * @param string $evt_etp_key
     * @param string $evt_title
     * @param int $evt_capacity
     * @param int $evt_registrant_goal
     * @param float $evt_revenue_goal
     * @param int $evt_display_order
     * @param string $evt_wait_list_flag
     * @param string $evt_auto_register_wait_list
     * @param string $evt_check_wait_list_flag
     * @param string $evt_registration_required
     * @param string $evt_group_reg_based_on_ind
     * @param int $evt_estimated_attendance
     * @param int $evt_guaranteed_attendance
     * @param string $evt_restricted
     * @param string $evt_short_description
     * @param string $evt_description
     * @param string $evt_description_html
     * @param string $evt_start_date
     * @param string $evt_start_time
     * @param string $evt_end_date
     * @param string $evt_end_time
     * @param string $evt_early_registration_date
     * @param string $evt_late_registration_date
     * @param string $evt_time_format
     * @param string $evt_date_format
     * @param string $evt_cutoff_date
     * @param string $evt_post_to_web_date
     * @param string $evt_remove_from_web_date
     * @param string $evt_event_url
     * @param string $evt_add_user
     * @param string $evt_add_date
     * @param string $evt_change_user
     * @param string $evt_change_date
     * @param string $evt_delete_flag
     * @param string $evt_asn_code
     * @param string $evt_key_ext
     * @param int $evt_sponsor_limit
     * @param string $evt_pre_registration_date
     * @param string $evt_entity_key
     * @param string $evt_cct_key
     * @param string $evt_evt_key
     * @param string $evt_tzn_key
     * @param string $evt_etc_key
     * @param string $evt_abstract_flag
     * @param string $evt_abstract_member_option
     * @param string $evt_abstract_deadline
     * @param string $evt_closed_flag
     * @param string $evt_free_event_flag
     * @param int $evt_regid_counter
     * @param int $evt_guest_limit
     * @param string $evt_free_guest_flag
     * @param string $evt_fpc_prd_key
     * @param int $evt_wait_list_limit
     * @param string $evt_charity_event_flag
     * @param string $evt_expense_generated_date
     * @param string $evt_narrative_template
     * @param string $evt_video_url
     * @param string $evt_cancellation_cutoff_date
     * @param string $evt_cct_cancellation_key
     * @param string $evt_ceu_earn_date_field
     * @param string $evt_waiver_flag
     * @param string $evt_waiver_text
     */
    public function __construct(?string $evt_key = null, ?string $evt_code = null, ?string $evt_etp_key = null, ?string $evt_title = null, ?int $evt_capacity = null, ?int $evt_registrant_goal = null, ?float $evt_revenue_goal = null, ?int $evt_display_order = null, ?string $evt_wait_list_flag = null, ?string $evt_auto_register_wait_list = null, ?string $evt_check_wait_list_flag = null, ?string $evt_registration_required = null, ?string $evt_group_reg_based_on_ind = null, ?int $evt_estimated_attendance = null, ?int $evt_guaranteed_attendance = null, ?string $evt_restricted = null, ?string $evt_short_description = null, ?string $evt_description = null, ?string $evt_description_html = null, ?string $evt_start_date = null, ?string $evt_start_time = null, ?string $evt_end_date = null, ?string $evt_end_time = null, ?string $evt_early_registration_date = null, ?string $evt_late_registration_date = null, ?string $evt_time_format = null, ?string $evt_date_format = null, ?string $evt_cutoff_date = null, ?string $evt_post_to_web_date = null, ?string $evt_remove_from_web_date = null, ?string $evt_event_url = null, ?string $evt_add_user = null, ?string $evt_add_date = null, ?string $evt_change_user = null, ?string $evt_change_date = null, ?string $evt_delete_flag = null, ?string $evt_asn_code = null, ?string $evt_key_ext = null, ?int $evt_sponsor_limit = null, ?string $evt_pre_registration_date = null, ?string $evt_entity_key = null, ?string $evt_cct_key = null, ?string $evt_evt_key = null, ?string $evt_tzn_key = null, ?string $evt_etc_key = null, ?string $evt_abstract_flag = null, ?string $evt_abstract_member_option = null, ?string $evt_abstract_deadline = null, ?string $evt_closed_flag = null, ?string $evt_free_event_flag = null, ?int $evt_regid_counter = null, ?int $evt_guest_limit = null, ?string $evt_free_guest_flag = null, ?string $evt_fpc_prd_key = null, ?int $evt_wait_list_limit = null, ?string $evt_charity_event_flag = null, ?string $evt_expense_generated_date = null, ?string $evt_narrative_template = null, ?string $evt_video_url = null, ?string $evt_cancellation_cutoff_date = null, ?string $evt_cct_cancellation_key = null, ?string $evt_ceu_earn_date_field = null, ?string $evt_waiver_flag = null, ?string $evt_waiver_text = null)
    {
        $this
            ->setEvt_key($evt_key)
            ->setEvt_code($evt_code)
            ->setEvt_etp_key($evt_etp_key)
            ->setEvt_title($evt_title)
            ->setEvt_capacity($evt_capacity)
            ->setEvt_registrant_goal($evt_registrant_goal)
            ->setEvt_revenue_goal($evt_revenue_goal)
            ->setEvt_display_order($evt_display_order)
            ->setEvt_wait_list_flag($evt_wait_list_flag)
            ->setEvt_auto_register_wait_list($evt_auto_register_wait_list)
            ->setEvt_check_wait_list_flag($evt_check_wait_list_flag)
            ->setEvt_registration_required($evt_registration_required)
            ->setEvt_group_reg_based_on_ind($evt_group_reg_based_on_ind)
            ->setEvt_estimated_attendance($evt_estimated_attendance)
            ->setEvt_guaranteed_attendance($evt_guaranteed_attendance)
            ->setEvt_restricted($evt_restricted)
            ->setEvt_short_description($evt_short_description)
            ->setEvt_description($evt_description)
            ->setEvt_description_html($evt_description_html)
            ->setEvt_start_date($evt_start_date)
            ->setEvt_start_time($evt_start_time)
            ->setEvt_end_date($evt_end_date)
            ->setEvt_end_time($evt_end_time)
            ->setEvt_early_registration_date($evt_early_registration_date)
            ->setEvt_late_registration_date($evt_late_registration_date)
            ->setEvt_time_format($evt_time_format)
            ->setEvt_date_format($evt_date_format)
            ->setEvt_cutoff_date($evt_cutoff_date)
            ->setEvt_post_to_web_date($evt_post_to_web_date)
            ->setEvt_remove_from_web_date($evt_remove_from_web_date)
            ->setEvt_event_url($evt_event_url)
            ->setEvt_add_user($evt_add_user)
            ->setEvt_add_date($evt_add_date)
            ->setEvt_change_user($evt_change_user)
            ->setEvt_change_date($evt_change_date)
            ->setEvt_delete_flag($evt_delete_flag)
            ->setEvt_asn_code($evt_asn_code)
            ->setEvt_key_ext($evt_key_ext)
            ->setEvt_sponsor_limit($evt_sponsor_limit)
            ->setEvt_pre_registration_date($evt_pre_registration_date)
            ->setEvt_entity_key($evt_entity_key)
            ->setEvt_cct_key($evt_cct_key)
            ->setEvt_evt_key($evt_evt_key)
            ->setEvt_tzn_key($evt_tzn_key)
            ->setEvt_etc_key($evt_etc_key)
            ->setEvt_abstract_flag($evt_abstract_flag)
            ->setEvt_abstract_member_option($evt_abstract_member_option)
            ->setEvt_abstract_deadline($evt_abstract_deadline)
            ->setEvt_closed_flag($evt_closed_flag)
            ->setEvt_free_event_flag($evt_free_event_flag)
            ->setEvt_regid_counter($evt_regid_counter)
            ->setEvt_guest_limit($evt_guest_limit)
            ->setEvt_free_guest_flag($evt_free_guest_flag)
            ->setEvt_fpc_prd_key($evt_fpc_prd_key)
            ->setEvt_wait_list_limit($evt_wait_list_limit)
            ->setEvt_charity_event_flag($evt_charity_event_flag)
            ->setEvt_expense_generated_date($evt_expense_generated_date)
            ->setEvt_narrative_template($evt_narrative_template)
            ->setEvt_video_url($evt_video_url)
            ->setEvt_cancellation_cutoff_date($evt_cancellation_cutoff_date)
            ->setEvt_cct_cancellation_key($evt_cct_cancellation_key)
            ->setEvt_ceu_earn_date_field($evt_ceu_earn_date_field)
            ->setEvt_waiver_flag($evt_waiver_flag)
            ->setEvt_waiver_text($evt_waiver_text);
    }
    /**
     * Get evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_key(): ?string
    {
        return $this->evt_key ?? null;
    }
    /**
     * Set evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_key(?string $evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_key) && !is_string($evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_key, true), gettype($evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_key, true)), __LINE__);
        }
        if (is_null($evt_key) || (is_array($evt_key) && empty($evt_key))) {
            unset($this->evt_key);
        } else {
            $this->evt_key = $evt_key;
        }
        
        return $this;
    }
    /**
     * Get evt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_code(): ?string
    {
        return $this->evt_code ?? null;
    }
    /**
     * Set evt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_code(?string $evt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_code) && !is_string($evt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_code, true), gettype($evt_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($evt_code) && mb_strlen((string) $evt_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $evt_code)), __LINE__);
        }
        if (is_null($evt_code) || (is_array($evt_code) && empty($evt_code))) {
            unset($this->evt_code);
        } else {
            $this->evt_code = $evt_code;
        }
        
        return $this;
    }
    /**
     * Get evt_etp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_etp_key(): ?string
    {
        return $this->evt_etp_key ?? null;
    }
    /**
     * Set evt_etp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_etp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_etp_key(?string $evt_etp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_etp_key) && !is_string($evt_etp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_etp_key, true), gettype($evt_etp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_etp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_etp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_etp_key, true)), __LINE__);
        }
        if (is_null($evt_etp_key) || (is_array($evt_etp_key) && empty($evt_etp_key))) {
            unset($this->evt_etp_key);
        } else {
            $this->evt_etp_key = $evt_etp_key;
        }
        
        return $this;
    }
    /**
     * Get evt_title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_title(): ?string
    {
        return $this->evt_title ?? null;
    }
    /**
     * Set evt_title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_title
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_title(?string $evt_title = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_title) && !is_string($evt_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_title, true), gettype($evt_title)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($evt_title) && mb_strlen((string) $evt_title) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $evt_title)), __LINE__);
        }
        if (is_null($evt_title) || (is_array($evt_title) && empty($evt_title))) {
            unset($this->evt_title);
        } else {
            $this->evt_title = $evt_title;
        }
        
        return $this;
    }
    /**
     * Get evt_capacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEvt_capacity(): ?int
    {
        return $this->evt_capacity ?? null;
    }
    /**
     * Set evt_capacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $evt_capacity
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_capacity(?int $evt_capacity = null): self
    {
        // validation for constraint: int
        if (!is_null($evt_capacity) && !(is_int($evt_capacity) || ctype_digit($evt_capacity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evt_capacity, true), gettype($evt_capacity)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($evt_capacity) && $evt_capacity > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($evt_capacity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($evt_capacity) && $evt_capacity < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($evt_capacity, true)), __LINE__);
        }
        if (is_null($evt_capacity) || (is_array($evt_capacity) && empty($evt_capacity))) {
            unset($this->evt_capacity);
        } else {
            $this->evt_capacity = $evt_capacity;
        }
        
        return $this;
    }
    /**
     * Get evt_registrant_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEvt_registrant_goal(): ?int
    {
        return $this->evt_registrant_goal ?? null;
    }
    /**
     * Set evt_registrant_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $evt_registrant_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_registrant_goal(?int $evt_registrant_goal = null): self
    {
        // validation for constraint: int
        if (!is_null($evt_registrant_goal) && !(is_int($evt_registrant_goal) || ctype_digit($evt_registrant_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evt_registrant_goal, true), gettype($evt_registrant_goal)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($evt_registrant_goal) && $evt_registrant_goal > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($evt_registrant_goal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($evt_registrant_goal) && $evt_registrant_goal < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($evt_registrant_goal, true)), __LINE__);
        }
        if (is_null($evt_registrant_goal) || (is_array($evt_registrant_goal) && empty($evt_registrant_goal))) {
            unset($this->evt_registrant_goal);
        } else {
            $this->evt_registrant_goal = $evt_registrant_goal;
        }
        
        return $this;
    }
    /**
     * Get evt_revenue_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEvt_revenue_goal(): ?float
    {
        return $this->evt_revenue_goal ?? null;
    }
    /**
     * Set evt_revenue_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $evt_revenue_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_revenue_goal(?float $evt_revenue_goal = null): self
    {
        // validation for constraint: float
        if (!is_null($evt_revenue_goal) && !(is_float($evt_revenue_goal) || is_numeric($evt_revenue_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($evt_revenue_goal, true), gettype($evt_revenue_goal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($evt_revenue_goal) && mb_strlen(mb_substr((string) $evt_revenue_goal, false !== mb_strpos((string) $evt_revenue_goal, '.') ? mb_strpos((string) $evt_revenue_goal, '.') + 1 : mb_strlen((string) $evt_revenue_goal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($evt_revenue_goal, true), mb_strlen(mb_substr((string) $evt_revenue_goal, mb_strpos((string) $evt_revenue_goal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($evt_revenue_goal) && mb_strlen(preg_replace('/(\D)/', '', (string) $evt_revenue_goal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($evt_revenue_goal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $evt_revenue_goal))), __LINE__);
        }
        if (is_null($evt_revenue_goal) || (is_array($evt_revenue_goal) && empty($evt_revenue_goal))) {
            unset($this->evt_revenue_goal);
        } else {
            $this->evt_revenue_goal = $evt_revenue_goal;
        }
        
        return $this;
    }
    /**
     * Get evt_display_order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEvt_display_order(): ?int
    {
        return $this->evt_display_order ?? null;
    }
    /**
     * Set evt_display_order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $evt_display_order
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_display_order(?int $evt_display_order = null): self
    {
        // validation for constraint: int
        if (!is_null($evt_display_order) && !(is_int($evt_display_order) || ctype_digit($evt_display_order))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evt_display_order, true), gettype($evt_display_order)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($evt_display_order) && $evt_display_order > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($evt_display_order, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($evt_display_order) && $evt_display_order < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($evt_display_order, true)), __LINE__);
        }
        if (is_null($evt_display_order) || (is_array($evt_display_order) && empty($evt_display_order))) {
            unset($this->evt_display_order);
        } else {
            $this->evt_display_order = $evt_display_order;
        }
        
        return $this;
    }
    /**
     * Get evt_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_wait_list_flag(): ?string
    {
        return $this->evt_wait_list_flag ?? null;
    }
    /**
     * Set evt_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_wait_list_flag(?string $evt_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_wait_list_flag) && !is_string($evt_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_wait_list_flag, true), gettype($evt_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_wait_list_flag) && $evt_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_wait_list_flag) && $evt_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_wait_list_flag, true)), __LINE__);
        }
        if (is_null($evt_wait_list_flag) || (is_array($evt_wait_list_flag) && empty($evt_wait_list_flag))) {
            unset($this->evt_wait_list_flag);
        } else {
            $this->evt_wait_list_flag = $evt_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get evt_auto_register_wait_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_auto_register_wait_list(): ?string
    {
        return $this->evt_auto_register_wait_list ?? null;
    }
    /**
     * Set evt_auto_register_wait_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_auto_register_wait_list
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_auto_register_wait_list(?string $evt_auto_register_wait_list = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_auto_register_wait_list) && !is_string($evt_auto_register_wait_list)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_auto_register_wait_list, true), gettype($evt_auto_register_wait_list)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_auto_register_wait_list) && $evt_auto_register_wait_list > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_auto_register_wait_list, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_auto_register_wait_list) && $evt_auto_register_wait_list < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_auto_register_wait_list, true)), __LINE__);
        }
        if (is_null($evt_auto_register_wait_list) || (is_array($evt_auto_register_wait_list) && empty($evt_auto_register_wait_list))) {
            unset($this->evt_auto_register_wait_list);
        } else {
            $this->evt_auto_register_wait_list = $evt_auto_register_wait_list;
        }
        
        return $this;
    }
    /**
     * Get evt_check_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_check_wait_list_flag(): ?string
    {
        return $this->evt_check_wait_list_flag ?? null;
    }
    /**
     * Set evt_check_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_check_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_check_wait_list_flag(?string $evt_check_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_check_wait_list_flag) && !is_string($evt_check_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_check_wait_list_flag, true), gettype($evt_check_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_check_wait_list_flag) && $evt_check_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_check_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_check_wait_list_flag) && $evt_check_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_check_wait_list_flag, true)), __LINE__);
        }
        if (is_null($evt_check_wait_list_flag) || (is_array($evt_check_wait_list_flag) && empty($evt_check_wait_list_flag))) {
            unset($this->evt_check_wait_list_flag);
        } else {
            $this->evt_check_wait_list_flag = $evt_check_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get evt_registration_required value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_registration_required(): ?string
    {
        return $this->evt_registration_required ?? null;
    }
    /**
     * Set evt_registration_required value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_registration_required
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_registration_required(?string $evt_registration_required = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_registration_required) && !is_string($evt_registration_required)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_registration_required, true), gettype($evt_registration_required)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_registration_required) && $evt_registration_required > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_registration_required, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_registration_required) && $evt_registration_required < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_registration_required, true)), __LINE__);
        }
        if (is_null($evt_registration_required) || (is_array($evt_registration_required) && empty($evt_registration_required))) {
            unset($this->evt_registration_required);
        } else {
            $this->evt_registration_required = $evt_registration_required;
        }
        
        return $this;
    }
    /**
     * Get evt_group_reg_based_on_ind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_group_reg_based_on_ind(): ?string
    {
        return $this->evt_group_reg_based_on_ind ?? null;
    }
    /**
     * Set evt_group_reg_based_on_ind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_group_reg_based_on_ind
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_group_reg_based_on_ind(?string $evt_group_reg_based_on_ind = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_group_reg_based_on_ind) && !is_string($evt_group_reg_based_on_ind)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_group_reg_based_on_ind, true), gettype($evt_group_reg_based_on_ind)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_group_reg_based_on_ind) && $evt_group_reg_based_on_ind > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_group_reg_based_on_ind, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_group_reg_based_on_ind) && $evt_group_reg_based_on_ind < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_group_reg_based_on_ind, true)), __LINE__);
        }
        if (is_null($evt_group_reg_based_on_ind) || (is_array($evt_group_reg_based_on_ind) && empty($evt_group_reg_based_on_ind))) {
            unset($this->evt_group_reg_based_on_ind);
        } else {
            $this->evt_group_reg_based_on_ind = $evt_group_reg_based_on_ind;
        }
        
        return $this;
    }
    /**
     * Get evt_estimated_attendance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEvt_estimated_attendance(): ?int
    {
        return $this->evt_estimated_attendance ?? null;
    }
    /**
     * Set evt_estimated_attendance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $evt_estimated_attendance
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_estimated_attendance(?int $evt_estimated_attendance = null): self
    {
        // validation for constraint: int
        if (!is_null($evt_estimated_attendance) && !(is_int($evt_estimated_attendance) || ctype_digit($evt_estimated_attendance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evt_estimated_attendance, true), gettype($evt_estimated_attendance)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($evt_estimated_attendance) && $evt_estimated_attendance > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($evt_estimated_attendance, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($evt_estimated_attendance) && $evt_estimated_attendance < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($evt_estimated_attendance, true)), __LINE__);
        }
        if (is_null($evt_estimated_attendance) || (is_array($evt_estimated_attendance) && empty($evt_estimated_attendance))) {
            unset($this->evt_estimated_attendance);
        } else {
            $this->evt_estimated_attendance = $evt_estimated_attendance;
        }
        
        return $this;
    }
    /**
     * Get evt_guaranteed_attendance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEvt_guaranteed_attendance(): ?int
    {
        return $this->evt_guaranteed_attendance ?? null;
    }
    /**
     * Set evt_guaranteed_attendance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $evt_guaranteed_attendance
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_guaranteed_attendance(?int $evt_guaranteed_attendance = null): self
    {
        // validation for constraint: int
        if (!is_null($evt_guaranteed_attendance) && !(is_int($evt_guaranteed_attendance) || ctype_digit($evt_guaranteed_attendance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evt_guaranteed_attendance, true), gettype($evt_guaranteed_attendance)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($evt_guaranteed_attendance) && $evt_guaranteed_attendance > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($evt_guaranteed_attendance, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($evt_guaranteed_attendance) && $evt_guaranteed_attendance < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($evt_guaranteed_attendance, true)), __LINE__);
        }
        if (is_null($evt_guaranteed_attendance) || (is_array($evt_guaranteed_attendance) && empty($evt_guaranteed_attendance))) {
            unset($this->evt_guaranteed_attendance);
        } else {
            $this->evt_guaranteed_attendance = $evt_guaranteed_attendance;
        }
        
        return $this;
    }
    /**
     * Get evt_restricted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_restricted(): ?string
    {
        return $this->evt_restricted ?? null;
    }
    /**
     * Set evt_restricted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_restricted
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_restricted(?string $evt_restricted = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_restricted) && !is_string($evt_restricted)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_restricted, true), gettype($evt_restricted)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_restricted) && $evt_restricted > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_restricted, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_restricted) && $evt_restricted < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_restricted, true)), __LINE__);
        }
        if (is_null($evt_restricted) || (is_array($evt_restricted) && empty($evt_restricted))) {
            unset($this->evt_restricted);
        } else {
            $this->evt_restricted = $evt_restricted;
        }
        
        return $this;
    }
    /**
     * Get evt_short_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_short_description(): ?string
    {
        return $this->evt_short_description ?? null;
    }
    /**
     * Set evt_short_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_short_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_short_description(?string $evt_short_description = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_short_description) && !is_string($evt_short_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_short_description, true), gettype($evt_short_description)), __LINE__);
        }
        // validation for constraint: maxLength(400)
        if (!is_null($evt_short_description) && mb_strlen((string) $evt_short_description) > 400) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 400', mb_strlen((string) $evt_short_description)), __LINE__);
        }
        if (is_null($evt_short_description) || (is_array($evt_short_description) && empty($evt_short_description))) {
            unset($this->evt_short_description);
        } else {
            $this->evt_short_description = $evt_short_description;
        }
        
        return $this;
    }
    /**
     * Get evt_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_description(): ?string
    {
        return $this->evt_description ?? null;
    }
    /**
     * Set evt_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_description(?string $evt_description = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_description) && !is_string($evt_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_description, true), gettype($evt_description)), __LINE__);
        }
        if (is_null($evt_description) || (is_array($evt_description) && empty($evt_description))) {
            unset($this->evt_description);
        } else {
            $this->evt_description = $evt_description;
        }
        
        return $this;
    }
    /**
     * Get evt_description_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_description_html(): ?string
    {
        return $this->evt_description_html ?? null;
    }
    /**
     * Set evt_description_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_description_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_description_html(?string $evt_description_html = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_description_html) && !is_string($evt_description_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_description_html, true), gettype($evt_description_html)), __LINE__);
        }
        if (is_null($evt_description_html) || (is_array($evt_description_html) && empty($evt_description_html))) {
            unset($this->evt_description_html);
        } else {
            $this->evt_description_html = $evt_description_html;
        }
        
        return $this;
    }
    /**
     * Get evt_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_start_date(): ?string
    {
        return $this->evt_start_date ?? null;
    }
    /**
     * Set evt_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_start_date(?string $evt_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_start_date) && !is_string($evt_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_start_date, true), gettype($evt_start_date)), __LINE__);
        }
        if (is_null($evt_start_date) || (is_array($evt_start_date) && empty($evt_start_date))) {
            unset($this->evt_start_date);
        } else {
            $this->evt_start_date = $evt_start_date;
        }
        
        return $this;
    }
    /**
     * Get evt_start_time value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_start_time(): ?string
    {
        return $this->evt_start_time ?? null;
    }
    /**
     * Set evt_start_time value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_start_time
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_start_time(?string $evt_start_time = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_start_time) && !is_string($evt_start_time)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_start_time, true), gettype($evt_start_time)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($evt_start_time) && mb_strlen((string) $evt_start_time) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $evt_start_time)), __LINE__);
        }
        if (is_null($evt_start_time) || (is_array($evt_start_time) && empty($evt_start_time))) {
            unset($this->evt_start_time);
        } else {
            $this->evt_start_time = $evt_start_time;
        }
        
        return $this;
    }
    /**
     * Get evt_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_end_date(): ?string
    {
        return $this->evt_end_date ?? null;
    }
    /**
     * Set evt_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_end_date(?string $evt_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_end_date) && !is_string($evt_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_end_date, true), gettype($evt_end_date)), __LINE__);
        }
        if (is_null($evt_end_date) || (is_array($evt_end_date) && empty($evt_end_date))) {
            unset($this->evt_end_date);
        } else {
            $this->evt_end_date = $evt_end_date;
        }
        
        return $this;
    }
    /**
     * Get evt_end_time value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_end_time(): ?string
    {
        return $this->evt_end_time ?? null;
    }
    /**
     * Set evt_end_time value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_end_time
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_end_time(?string $evt_end_time = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_end_time) && !is_string($evt_end_time)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_end_time, true), gettype($evt_end_time)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($evt_end_time) && mb_strlen((string) $evt_end_time) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $evt_end_time)), __LINE__);
        }
        if (is_null($evt_end_time) || (is_array($evt_end_time) && empty($evt_end_time))) {
            unset($this->evt_end_time);
        } else {
            $this->evt_end_time = $evt_end_time;
        }
        
        return $this;
    }
    /**
     * Get evt_early_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_early_registration_date(): ?string
    {
        return $this->evt_early_registration_date ?? null;
    }
    /**
     * Set evt_early_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_early_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_early_registration_date(?string $evt_early_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_early_registration_date) && !is_string($evt_early_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_early_registration_date, true), gettype($evt_early_registration_date)), __LINE__);
        }
        if (is_null($evt_early_registration_date) || (is_array($evt_early_registration_date) && empty($evt_early_registration_date))) {
            unset($this->evt_early_registration_date);
        } else {
            $this->evt_early_registration_date = $evt_early_registration_date;
        }
        
        return $this;
    }
    /**
     * Get evt_late_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_late_registration_date(): ?string
    {
        return $this->evt_late_registration_date ?? null;
    }
    /**
     * Set evt_late_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_late_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_late_registration_date(?string $evt_late_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_late_registration_date) && !is_string($evt_late_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_late_registration_date, true), gettype($evt_late_registration_date)), __LINE__);
        }
        if (is_null($evt_late_registration_date) || (is_array($evt_late_registration_date) && empty($evt_late_registration_date))) {
            unset($this->evt_late_registration_date);
        } else {
            $this->evt_late_registration_date = $evt_late_registration_date;
        }
        
        return $this;
    }
    /**
     * Get evt_time_format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_time_format(): ?string
    {
        return $this->evt_time_format ?? null;
    }
    /**
     * Set evt_time_format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_time_format
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_time_format(?string $evt_time_format = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_time_format) && !is_string($evt_time_format)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_time_format, true), gettype($evt_time_format)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($evt_time_format) && mb_strlen((string) $evt_time_format) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $evt_time_format)), __LINE__);
        }
        if (is_null($evt_time_format) || (is_array($evt_time_format) && empty($evt_time_format))) {
            unset($this->evt_time_format);
        } else {
            $this->evt_time_format = $evt_time_format;
        }
        
        return $this;
    }
    /**
     * Get evt_date_format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_date_format(): ?string
    {
        return $this->evt_date_format ?? null;
    }
    /**
     * Set evt_date_format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_date_format
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_date_format(?string $evt_date_format = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_date_format) && !is_string($evt_date_format)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_date_format, true), gettype($evt_date_format)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($evt_date_format) && mb_strlen((string) $evt_date_format) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $evt_date_format)), __LINE__);
        }
        if (is_null($evt_date_format) || (is_array($evt_date_format) && empty($evt_date_format))) {
            unset($this->evt_date_format);
        } else {
            $this->evt_date_format = $evt_date_format;
        }
        
        return $this;
    }
    /**
     * Get evt_cutoff_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_cutoff_date(): ?string
    {
        return $this->evt_cutoff_date ?? null;
    }
    /**
     * Set evt_cutoff_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_cutoff_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_cutoff_date(?string $evt_cutoff_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_cutoff_date) && !is_string($evt_cutoff_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_cutoff_date, true), gettype($evt_cutoff_date)), __LINE__);
        }
        if (is_null($evt_cutoff_date) || (is_array($evt_cutoff_date) && empty($evt_cutoff_date))) {
            unset($this->evt_cutoff_date);
        } else {
            $this->evt_cutoff_date = $evt_cutoff_date;
        }
        
        return $this;
    }
    /**
     * Get evt_post_to_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_post_to_web_date(): ?string
    {
        return $this->evt_post_to_web_date ?? null;
    }
    /**
     * Set evt_post_to_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_post_to_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_post_to_web_date(?string $evt_post_to_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_post_to_web_date) && !is_string($evt_post_to_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_post_to_web_date, true), gettype($evt_post_to_web_date)), __LINE__);
        }
        if (is_null($evt_post_to_web_date) || (is_array($evt_post_to_web_date) && empty($evt_post_to_web_date))) {
            unset($this->evt_post_to_web_date);
        } else {
            $this->evt_post_to_web_date = $evt_post_to_web_date;
        }
        
        return $this;
    }
    /**
     * Get evt_remove_from_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_remove_from_web_date(): ?string
    {
        return $this->evt_remove_from_web_date ?? null;
    }
    /**
     * Set evt_remove_from_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_remove_from_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_remove_from_web_date(?string $evt_remove_from_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_remove_from_web_date) && !is_string($evt_remove_from_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_remove_from_web_date, true), gettype($evt_remove_from_web_date)), __LINE__);
        }
        if (is_null($evt_remove_from_web_date) || (is_array($evt_remove_from_web_date) && empty($evt_remove_from_web_date))) {
            unset($this->evt_remove_from_web_date);
        } else {
            $this->evt_remove_from_web_date = $evt_remove_from_web_date;
        }
        
        return $this;
    }
    /**
     * Get evt_event_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_event_url(): ?string
    {
        return $this->evt_event_url ?? null;
    }
    /**
     * Set evt_event_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_event_url
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_event_url(?string $evt_event_url = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_event_url) && !is_string($evt_event_url)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_event_url, true), gettype($evt_event_url)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($evt_event_url) && mb_strlen((string) $evt_event_url) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $evt_event_url)), __LINE__);
        }
        if (is_null($evt_event_url) || (is_array($evt_event_url) && empty($evt_event_url))) {
            unset($this->evt_event_url);
        } else {
            $this->evt_event_url = $evt_event_url;
        }
        
        return $this;
    }
    /**
     * Get evt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_add_user(): ?string
    {
        return $this->evt_add_user ?? null;
    }
    /**
     * Set evt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_add_user(?string $evt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_add_user) && !is_string($evt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_add_user, true), gettype($evt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($evt_add_user) && mb_strlen((string) $evt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $evt_add_user)), __LINE__);
        }
        if (is_null($evt_add_user) || (is_array($evt_add_user) && empty($evt_add_user))) {
            unset($this->evt_add_user);
        } else {
            $this->evt_add_user = $evt_add_user;
        }
        
        return $this;
    }
    /**
     * Get evt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_add_date(): ?string
    {
        return $this->evt_add_date ?? null;
    }
    /**
     * Set evt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_add_date(?string $evt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_add_date) && !is_string($evt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_add_date, true), gettype($evt_add_date)), __LINE__);
        }
        if (is_null($evt_add_date) || (is_array($evt_add_date) && empty($evt_add_date))) {
            unset($this->evt_add_date);
        } else {
            $this->evt_add_date = $evt_add_date;
        }
        
        return $this;
    }
    /**
     * Get evt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_change_user(): ?string
    {
        return $this->evt_change_user ?? null;
    }
    /**
     * Set evt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_change_user(?string $evt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_change_user) && !is_string($evt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_change_user, true), gettype($evt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($evt_change_user) && mb_strlen((string) $evt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $evt_change_user)), __LINE__);
        }
        if (is_null($evt_change_user) || (is_array($evt_change_user) && empty($evt_change_user))) {
            unset($this->evt_change_user);
        } else {
            $this->evt_change_user = $evt_change_user;
        }
        
        return $this;
    }
    /**
     * Get evt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_change_date(): ?string
    {
        return $this->evt_change_date ?? null;
    }
    /**
     * Set evt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_change_date(?string $evt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_change_date) && !is_string($evt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_change_date, true), gettype($evt_change_date)), __LINE__);
        }
        if (is_null($evt_change_date) || (is_array($evt_change_date) && empty($evt_change_date))) {
            unset($this->evt_change_date);
        } else {
            $this->evt_change_date = $evt_change_date;
        }
        
        return $this;
    }
    /**
     * Get evt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_delete_flag(): ?string
    {
        return $this->evt_delete_flag ?? null;
    }
    /**
     * Set evt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_delete_flag(?string $evt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_delete_flag) && !is_string($evt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_delete_flag, true), gettype($evt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_delete_flag) && $evt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_delete_flag) && $evt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_delete_flag, true)), __LINE__);
        }
        if (is_null($evt_delete_flag) || (is_array($evt_delete_flag) && empty($evt_delete_flag))) {
            unset($this->evt_delete_flag);
        } else {
            $this->evt_delete_flag = $evt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get evt_asn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_asn_code(): ?string
    {
        return $this->evt_asn_code ?? null;
    }
    /**
     * Set evt_asn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_asn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_asn_code(?string $evt_asn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_asn_code) && !is_string($evt_asn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_asn_code, true), gettype($evt_asn_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($evt_asn_code) && mb_strlen((string) $evt_asn_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $evt_asn_code)), __LINE__);
        }
        if (is_null($evt_asn_code) || (is_array($evt_asn_code) && empty($evt_asn_code))) {
            unset($this->evt_asn_code);
        } else {
            $this->evt_asn_code = $evt_asn_code;
        }
        
        return $this;
    }
    /**
     * Get evt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_key_ext(): ?string
    {
        return $this->evt_key_ext ?? null;
    }
    /**
     * Set evt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_key_ext(?string $evt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_key_ext) && !is_string($evt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_key_ext, true), gettype($evt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_key_ext, true)), __LINE__);
        }
        if (is_null($evt_key_ext) || (is_array($evt_key_ext) && empty($evt_key_ext))) {
            unset($this->evt_key_ext);
        } else {
            $this->evt_key_ext = $evt_key_ext;
        }
        
        return $this;
    }
    /**
     * Get evt_sponsor_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEvt_sponsor_limit(): ?int
    {
        return $this->evt_sponsor_limit ?? null;
    }
    /**
     * Set evt_sponsor_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $evt_sponsor_limit
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_sponsor_limit(?int $evt_sponsor_limit = null): self
    {
        // validation for constraint: int
        if (!is_null($evt_sponsor_limit) && !(is_int($evt_sponsor_limit) || ctype_digit($evt_sponsor_limit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evt_sponsor_limit, true), gettype($evt_sponsor_limit)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($evt_sponsor_limit) && $evt_sponsor_limit > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($evt_sponsor_limit, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($evt_sponsor_limit) && $evt_sponsor_limit < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($evt_sponsor_limit, true)), __LINE__);
        }
        if (is_null($evt_sponsor_limit) || (is_array($evt_sponsor_limit) && empty($evt_sponsor_limit))) {
            unset($this->evt_sponsor_limit);
        } else {
            $this->evt_sponsor_limit = $evt_sponsor_limit;
        }
        
        return $this;
    }
    /**
     * Get evt_pre_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_pre_registration_date(): ?string
    {
        return $this->evt_pre_registration_date ?? null;
    }
    /**
     * Set evt_pre_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_pre_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_pre_registration_date(?string $evt_pre_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_pre_registration_date) && !is_string($evt_pre_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_pre_registration_date, true), gettype($evt_pre_registration_date)), __LINE__);
        }
        if (is_null($evt_pre_registration_date) || (is_array($evt_pre_registration_date) && empty($evt_pre_registration_date))) {
            unset($this->evt_pre_registration_date);
        } else {
            $this->evt_pre_registration_date = $evt_pre_registration_date;
        }
        
        return $this;
    }
    /**
     * Get evt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_entity_key(): ?string
    {
        return $this->evt_entity_key ?? null;
    }
    /**
     * Set evt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_entity_key(?string $evt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_entity_key) && !is_string($evt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_entity_key, true), gettype($evt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_entity_key, true)), __LINE__);
        }
        if (is_null($evt_entity_key) || (is_array($evt_entity_key) && empty($evt_entity_key))) {
            unset($this->evt_entity_key);
        } else {
            $this->evt_entity_key = $evt_entity_key;
        }
        
        return $this;
    }
    /**
     * Get evt_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_cct_key(): ?string
    {
        return $this->evt_cct_key ?? null;
    }
    /**
     * Set evt_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_cct_key(?string $evt_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_cct_key) && !is_string($evt_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_cct_key, true), gettype($evt_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_cct_key, true)), __LINE__);
        }
        if (is_null($evt_cct_key) || (is_array($evt_cct_key) && empty($evt_cct_key))) {
            unset($this->evt_cct_key);
        } else {
            $this->evt_cct_key = $evt_cct_key;
        }
        
        return $this;
    }
    /**
     * Get evt_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_evt_key(): ?string
    {
        return $this->evt_evt_key ?? null;
    }
    /**
     * Set evt_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_evt_key(?string $evt_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_evt_key) && !is_string($evt_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_evt_key, true), gettype($evt_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_evt_key, true)), __LINE__);
        }
        if (is_null($evt_evt_key) || (is_array($evt_evt_key) && empty($evt_evt_key))) {
            unset($this->evt_evt_key);
        } else {
            $this->evt_evt_key = $evt_evt_key;
        }
        
        return $this;
    }
    /**
     * Get evt_tzn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_tzn_key(): ?string
    {
        return $this->evt_tzn_key ?? null;
    }
    /**
     * Set evt_tzn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_tzn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_tzn_key(?string $evt_tzn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_tzn_key) && !is_string($evt_tzn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_tzn_key, true), gettype($evt_tzn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_tzn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_tzn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_tzn_key, true)), __LINE__);
        }
        if (is_null($evt_tzn_key) || (is_array($evt_tzn_key) && empty($evt_tzn_key))) {
            unset($this->evt_tzn_key);
        } else {
            $this->evt_tzn_key = $evt_tzn_key;
        }
        
        return $this;
    }
    /**
     * Get evt_etc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_etc_key(): ?string
    {
        return $this->evt_etc_key ?? null;
    }
    /**
     * Set evt_etc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_etc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_etc_key(?string $evt_etc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_etc_key) && !is_string($evt_etc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_etc_key, true), gettype($evt_etc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_etc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_etc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_etc_key, true)), __LINE__);
        }
        if (is_null($evt_etc_key) || (is_array($evt_etc_key) && empty($evt_etc_key))) {
            unset($this->evt_etc_key);
        } else {
            $this->evt_etc_key = $evt_etc_key;
        }
        
        return $this;
    }
    /**
     * Get evt_abstract_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_abstract_flag(): ?string
    {
        return $this->evt_abstract_flag ?? null;
    }
    /**
     * Set evt_abstract_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_abstract_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_abstract_flag(?string $evt_abstract_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_abstract_flag) && !is_string($evt_abstract_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_abstract_flag, true), gettype($evt_abstract_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_abstract_flag) && $evt_abstract_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_abstract_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_abstract_flag) && $evt_abstract_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_abstract_flag, true)), __LINE__);
        }
        if (is_null($evt_abstract_flag) || (is_array($evt_abstract_flag) && empty($evt_abstract_flag))) {
            unset($this->evt_abstract_flag);
        } else {
            $this->evt_abstract_flag = $evt_abstract_flag;
        }
        
        return $this;
    }
    /**
     * Get evt_abstract_member_option value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_abstract_member_option(): ?string
    {
        return $this->evt_abstract_member_option ?? null;
    }
    /**
     * Set evt_abstract_member_option value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_abstract_member_option
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_abstract_member_option(?string $evt_abstract_member_option = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_abstract_member_option) && !is_string($evt_abstract_member_option)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_abstract_member_option, true), gettype($evt_abstract_member_option)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($evt_abstract_member_option) && mb_strlen((string) $evt_abstract_member_option) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $evt_abstract_member_option)), __LINE__);
        }
        if (is_null($evt_abstract_member_option) || (is_array($evt_abstract_member_option) && empty($evt_abstract_member_option))) {
            unset($this->evt_abstract_member_option);
        } else {
            $this->evt_abstract_member_option = $evt_abstract_member_option;
        }
        
        return $this;
    }
    /**
     * Get evt_abstract_deadline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_abstract_deadline(): ?string
    {
        return $this->evt_abstract_deadline ?? null;
    }
    /**
     * Set evt_abstract_deadline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_abstract_deadline
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_abstract_deadline(?string $evt_abstract_deadline = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_abstract_deadline) && !is_string($evt_abstract_deadline)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_abstract_deadline, true), gettype($evt_abstract_deadline)), __LINE__);
        }
        if (is_null($evt_abstract_deadline) || (is_array($evt_abstract_deadline) && empty($evt_abstract_deadline))) {
            unset($this->evt_abstract_deadline);
        } else {
            $this->evt_abstract_deadline = $evt_abstract_deadline;
        }
        
        return $this;
    }
    /**
     * Get evt_closed_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_closed_flag(): ?string
    {
        return $this->evt_closed_flag ?? null;
    }
    /**
     * Set evt_closed_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_closed_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_closed_flag(?string $evt_closed_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_closed_flag) && !is_string($evt_closed_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_closed_flag, true), gettype($evt_closed_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_closed_flag) && $evt_closed_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_closed_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_closed_flag) && $evt_closed_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_closed_flag, true)), __LINE__);
        }
        if (is_null($evt_closed_flag) || (is_array($evt_closed_flag) && empty($evt_closed_flag))) {
            unset($this->evt_closed_flag);
        } else {
            $this->evt_closed_flag = $evt_closed_flag;
        }
        
        return $this;
    }
    /**
     * Get evt_free_event_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_free_event_flag(): ?string
    {
        return $this->evt_free_event_flag ?? null;
    }
    /**
     * Set evt_free_event_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_free_event_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_free_event_flag(?string $evt_free_event_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_free_event_flag) && !is_string($evt_free_event_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_free_event_flag, true), gettype($evt_free_event_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_free_event_flag) && $evt_free_event_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_free_event_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_free_event_flag) && $evt_free_event_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_free_event_flag, true)), __LINE__);
        }
        if (is_null($evt_free_event_flag) || (is_array($evt_free_event_flag) && empty($evt_free_event_flag))) {
            unset($this->evt_free_event_flag);
        } else {
            $this->evt_free_event_flag = $evt_free_event_flag;
        }
        
        return $this;
    }
    /**
     * Get evt_regid_counter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEvt_regid_counter(): ?int
    {
        return $this->evt_regid_counter ?? null;
    }
    /**
     * Set evt_regid_counter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $evt_regid_counter
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_regid_counter(?int $evt_regid_counter = null): self
    {
        // validation for constraint: int
        if (!is_null($evt_regid_counter) && !(is_int($evt_regid_counter) || ctype_digit($evt_regid_counter))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evt_regid_counter, true), gettype($evt_regid_counter)), __LINE__);
        }
        // validation for constraint: maxInclusive(9223372036854775807)
        if (!is_null($evt_regid_counter) && $evt_regid_counter > 9223372036854775807) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9223372036854775807', var_export($evt_regid_counter, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9223372036854775808)
        if (!is_null($evt_regid_counter) && $evt_regid_counter < -9223372036854775808) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9223372036854775808', var_export($evt_regid_counter, true)), __LINE__);
        }
        if (is_null($evt_regid_counter) || (is_array($evt_regid_counter) && empty($evt_regid_counter))) {
            unset($this->evt_regid_counter);
        } else {
            $this->evt_regid_counter = $evt_regid_counter;
        }
        
        return $this;
    }
    /**
     * Get evt_guest_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEvt_guest_limit(): ?int
    {
        return $this->evt_guest_limit ?? null;
    }
    /**
     * Set evt_guest_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $evt_guest_limit
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_guest_limit(?int $evt_guest_limit = null): self
    {
        // validation for constraint: int
        if (!is_null($evt_guest_limit) && !(is_int($evt_guest_limit) || ctype_digit($evt_guest_limit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evt_guest_limit, true), gettype($evt_guest_limit)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($evt_guest_limit) && $evt_guest_limit > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($evt_guest_limit, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($evt_guest_limit) && $evt_guest_limit < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($evt_guest_limit, true)), __LINE__);
        }
        if (is_null($evt_guest_limit) || (is_array($evt_guest_limit) && empty($evt_guest_limit))) {
            unset($this->evt_guest_limit);
        } else {
            $this->evt_guest_limit = $evt_guest_limit;
        }
        
        return $this;
    }
    /**
     * Get evt_free_guest_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_free_guest_flag(): ?string
    {
        return $this->evt_free_guest_flag ?? null;
    }
    /**
     * Set evt_free_guest_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_free_guest_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_free_guest_flag(?string $evt_free_guest_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_free_guest_flag) && !is_string($evt_free_guest_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_free_guest_flag, true), gettype($evt_free_guest_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_free_guest_flag) && $evt_free_guest_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_free_guest_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_free_guest_flag) && $evt_free_guest_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_free_guest_flag, true)), __LINE__);
        }
        if (is_null($evt_free_guest_flag) || (is_array($evt_free_guest_flag) && empty($evt_free_guest_flag))) {
            unset($this->evt_free_guest_flag);
        } else {
            $this->evt_free_guest_flag = $evt_free_guest_flag;
        }
        
        return $this;
    }
    /**
     * Get evt_fpc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_fpc_prd_key(): ?string
    {
        return $this->evt_fpc_prd_key ?? null;
    }
    /**
     * Set evt_fpc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_fpc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_fpc_prd_key(?string $evt_fpc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_fpc_prd_key) && !is_string($evt_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_fpc_prd_key, true), gettype($evt_fpc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_fpc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_fpc_prd_key, true)), __LINE__);
        }
        if (is_null($evt_fpc_prd_key) || (is_array($evt_fpc_prd_key) && empty($evt_fpc_prd_key))) {
            unset($this->evt_fpc_prd_key);
        } else {
            $this->evt_fpc_prd_key = $evt_fpc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get evt_wait_list_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEvt_wait_list_limit(): ?int
    {
        return $this->evt_wait_list_limit ?? null;
    }
    /**
     * Set evt_wait_list_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $evt_wait_list_limit
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_wait_list_limit(?int $evt_wait_list_limit = null): self
    {
        // validation for constraint: int
        if (!is_null($evt_wait_list_limit) && !(is_int($evt_wait_list_limit) || ctype_digit($evt_wait_list_limit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evt_wait_list_limit, true), gettype($evt_wait_list_limit)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($evt_wait_list_limit) && $evt_wait_list_limit > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($evt_wait_list_limit, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($evt_wait_list_limit) && $evt_wait_list_limit < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($evt_wait_list_limit, true)), __LINE__);
        }
        if (is_null($evt_wait_list_limit) || (is_array($evt_wait_list_limit) && empty($evt_wait_list_limit))) {
            unset($this->evt_wait_list_limit);
        } else {
            $this->evt_wait_list_limit = $evt_wait_list_limit;
        }
        
        return $this;
    }
    /**
     * Get evt_charity_event_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_charity_event_flag(): ?string
    {
        return $this->evt_charity_event_flag ?? null;
    }
    /**
     * Set evt_charity_event_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_charity_event_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_charity_event_flag(?string $evt_charity_event_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_charity_event_flag) && !is_string($evt_charity_event_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_charity_event_flag, true), gettype($evt_charity_event_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_charity_event_flag) && $evt_charity_event_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_charity_event_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_charity_event_flag) && $evt_charity_event_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_charity_event_flag, true)), __LINE__);
        }
        if (is_null($evt_charity_event_flag) || (is_array($evt_charity_event_flag) && empty($evt_charity_event_flag))) {
            unset($this->evt_charity_event_flag);
        } else {
            $this->evt_charity_event_flag = $evt_charity_event_flag;
        }
        
        return $this;
    }
    /**
     * Get evt_expense_generated_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_expense_generated_date(): ?string
    {
        return $this->evt_expense_generated_date ?? null;
    }
    /**
     * Set evt_expense_generated_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_expense_generated_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_expense_generated_date(?string $evt_expense_generated_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_expense_generated_date) && !is_string($evt_expense_generated_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_expense_generated_date, true), gettype($evt_expense_generated_date)), __LINE__);
        }
        if (is_null($evt_expense_generated_date) || (is_array($evt_expense_generated_date) && empty($evt_expense_generated_date))) {
            unset($this->evt_expense_generated_date);
        } else {
            $this->evt_expense_generated_date = $evt_expense_generated_date;
        }
        
        return $this;
    }
    /**
     * Get evt_narrative_template value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_narrative_template(): ?string
    {
        return $this->evt_narrative_template ?? null;
    }
    /**
     * Set evt_narrative_template value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_narrative_template
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_narrative_template(?string $evt_narrative_template = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_narrative_template) && !is_string($evt_narrative_template)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_narrative_template, true), gettype($evt_narrative_template)), __LINE__);
        }
        if (is_null($evt_narrative_template) || (is_array($evt_narrative_template) && empty($evt_narrative_template))) {
            unset($this->evt_narrative_template);
        } else {
            $this->evt_narrative_template = $evt_narrative_template;
        }
        
        return $this;
    }
    /**
     * Get evt_video_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_video_url(): ?string
    {
        return $this->evt_video_url ?? null;
    }
    /**
     * Set evt_video_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_video_url
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_video_url(?string $evt_video_url = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_video_url) && !is_string($evt_video_url)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_video_url, true), gettype($evt_video_url)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($evt_video_url) && mb_strlen((string) $evt_video_url) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $evt_video_url)), __LINE__);
        }
        if (is_null($evt_video_url) || (is_array($evt_video_url) && empty($evt_video_url))) {
            unset($this->evt_video_url);
        } else {
            $this->evt_video_url = $evt_video_url;
        }
        
        return $this;
    }
    /**
     * Get evt_cancellation_cutoff_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_cancellation_cutoff_date(): ?string
    {
        return $this->evt_cancellation_cutoff_date ?? null;
    }
    /**
     * Set evt_cancellation_cutoff_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_cancellation_cutoff_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_cancellation_cutoff_date(?string $evt_cancellation_cutoff_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_cancellation_cutoff_date) && !is_string($evt_cancellation_cutoff_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_cancellation_cutoff_date, true), gettype($evt_cancellation_cutoff_date)), __LINE__);
        }
        if (is_null($evt_cancellation_cutoff_date) || (is_array($evt_cancellation_cutoff_date) && empty($evt_cancellation_cutoff_date))) {
            unset($this->evt_cancellation_cutoff_date);
        } else {
            $this->evt_cancellation_cutoff_date = $evt_cancellation_cutoff_date;
        }
        
        return $this;
    }
    /**
     * Get evt_cct_cancellation_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_cct_cancellation_key(): ?string
    {
        return $this->evt_cct_cancellation_key ?? null;
    }
    /**
     * Set evt_cct_cancellation_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_cct_cancellation_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_cct_cancellation_key(?string $evt_cct_cancellation_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_cct_cancellation_key) && !is_string($evt_cct_cancellation_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_cct_cancellation_key, true), gettype($evt_cct_cancellation_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evt_cct_cancellation_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evt_cct_cancellation_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evt_cct_cancellation_key, true)), __LINE__);
        }
        if (is_null($evt_cct_cancellation_key) || (is_array($evt_cct_cancellation_key) && empty($evt_cct_cancellation_key))) {
            unset($this->evt_cct_cancellation_key);
        } else {
            $this->evt_cct_cancellation_key = $evt_cct_cancellation_key;
        }
        
        return $this;
    }
    /**
     * Get evt_ceu_earn_date_field value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_ceu_earn_date_field(): ?string
    {
        return $this->evt_ceu_earn_date_field ?? null;
    }
    /**
     * Set evt_ceu_earn_date_field value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_ceu_earn_date_field
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_ceu_earn_date_field(?string $evt_ceu_earn_date_field = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_ceu_earn_date_field) && !is_string($evt_ceu_earn_date_field)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_ceu_earn_date_field, true), gettype($evt_ceu_earn_date_field)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($evt_ceu_earn_date_field) && mb_strlen((string) $evt_ceu_earn_date_field) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen((string) $evt_ceu_earn_date_field)), __LINE__);
        }
        if (is_null($evt_ceu_earn_date_field) || (is_array($evt_ceu_earn_date_field) && empty($evt_ceu_earn_date_field))) {
            unset($this->evt_ceu_earn_date_field);
        } else {
            $this->evt_ceu_earn_date_field = $evt_ceu_earn_date_field;
        }
        
        return $this;
    }
    /**
     * Get evt_waiver_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_waiver_flag(): ?string
    {
        return $this->evt_waiver_flag ?? null;
    }
    /**
     * Set evt_waiver_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_waiver_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_waiver_flag(?string $evt_waiver_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_waiver_flag) && !is_string($evt_waiver_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_waiver_flag, true), gettype($evt_waiver_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evt_waiver_flag) && $evt_waiver_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evt_waiver_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evt_waiver_flag) && $evt_waiver_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evt_waiver_flag, true)), __LINE__);
        }
        if (is_null($evt_waiver_flag) || (is_array($evt_waiver_flag) && empty($evt_waiver_flag))) {
            unset($this->evt_waiver_flag);
        } else {
            $this->evt_waiver_flag = $evt_waiver_flag;
        }
        
        return $this;
    }
    /**
     * Get evt_waiver_text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvt_waiver_text(): ?string
    {
        return $this->evt_waiver_text ?? null;
    }
    /**
     * Set evt_waiver_text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evt_waiver_text
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_event_DataObjectType
     */
    public function setEvt_waiver_text(?string $evt_waiver_text = null): self
    {
        // validation for constraint: string
        if (!is_null($evt_waiver_text) && !is_string($evt_waiver_text)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evt_waiver_text, true), gettype($evt_waiver_text)), __LINE__);
        }
        if (is_null($evt_waiver_text) || (is_array($evt_waiver_text) && empty($evt_waiver_text))) {
            unset($this->evt_waiver_text);
        } else {
            $this->evt_waiver_text = $evt_waiver_text;
        }
        
        return $this;
    }
}
