<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * EventsRegistrantSession_ev_registration_session_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrantSession_ev_registration_session_DataObjectType extends AbstractStructBase
{
    /**
     * The rgs_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_key = null;
    /**
     * The rgs_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Event Registration Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_reg_key = null;
    /**
     * The rgs_ses_key
     * Meta information extracted from the WSDL
     * - documentation: Session Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_ses_key = null;
    /**
     * The rgs_trk_key
     * Meta information extracted from the WSDL
     * - documentation: Track Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_trk_key = null;
    /**
     * The rgs_on_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: On Waiting List?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_on_wait_list_flag = null;
    /**
     * The rgs_confirm_date
     * Meta information extracted from the WSDL
     * - documentation: Confirmation Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_confirm_date = null;
    /**
     * The rgs_attendance_flag
     * Meta information extracted from the WSDL
     * - documentation: Attended?.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_attendance_flag = null;
    /**
     * The rgs_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_add_user = null;
    /**
     * The rgs_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_add_date = null;
    /**
     * The rgs_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_change_user = null;
    /**
     * The rgs_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_change_date = null;
    /**
     * The rgs_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_delete_flag = null;
    /**
     * The rgs_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_key_ext = null;
    /**
     * The rgs_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoce Detail Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_ivd_key = null;
    /**
     * The rgs_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: Cancel Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_cancel_date = null;
    /**
     * The rgs_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_entity_key = null;
    /**
     * The rgs_cancel_reason
     * Meta information extracted from the WSDL
     * - documentation: Cancellation Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_cancel_reason = null;
    /**
     * The rgs_score
     * Meta information extracted from the WSDL
     * - documentation: Score. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_score = null;
    /**
     * The rgs_grade
     * Meta information extracted from the WSDL
     * - documentation: Grade. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_grade = null;
    /**
     * The rgs_rgs_key
     * Meta information extracted from the WSDL
     * - documentation: Track Registration Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_rgs_key = null;
    /**
     * The rgs_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_odd_key = null;
    /**
     * The rgs_qty
     * Meta information extracted from the WSDL
     * - documentation: quantity. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $rgs_qty = null;
    /**
     * The rgs_cancel_qty
     * Meta information extracted from the WSDL
     * - documentation: cancelled.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $rgs_cancel_qty = null;
    /**
     * The rgs_balance_qty_cp
     * Meta information extracted from the WSDL
     * - documentation: registered. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $rgs_balance_qty_cp = null;
    /**
     * The rgs_gft_key
     * Meta information extracted from the WSDL
     * - documentation: gift. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_gft_key = null;
    /**
     * The rgs_time_in
     * Meta information extracted from the WSDL
     * - documentation: Time In. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_time_in = null;
    /**
     * The rgs_time_out
     * Meta information extracted from the WSDL
     * - documentation: Time Out. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_time_out = null;
    /**
     * The rgs_prc_key
     * Meta information extracted from the WSDL
     * - documentation: price key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_prc_key = null;
    /**
     * The rgs_tickets
     * Meta information extracted from the WSDL
     * - documentation: Number of Tickets.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgs_tickets = null;
    /**
     * The rgs_reduce_qty
     * Meta information extracted from the WSDL
     * - documentation: Reduce Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $rgs_reduce_qty = null;
    /**
     * The rgs_NewBatch_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Batch.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgs_NewBatch_key = null;
    /**
     * Constructor method for
     * EventsRegistrantSession_ev_registration_session_DataObjectType
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_reg_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_ses_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_trk_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_on_wait_list_flag()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_confirm_date()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_attendance_flag()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_add_user()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_add_date()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_change_user()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_change_date()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_delete_flag()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_key_ext()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_ivd_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_cancel_date()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_entity_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_cancel_reason()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_score()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_grade()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_rgs_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_odd_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_qty()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_cancel_qty()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_balance_qty_cp()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_gft_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_time_in()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_time_out()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_prc_key()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_tickets()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_reduce_qty()
     * @uses EventsRegistrantSession_ev_registration_session_DataObjectType::setRgs_NewBatch_key()
     * @param string $rgs_key
     * @param string $rgs_reg_key
     * @param string $rgs_ses_key
     * @param string $rgs_trk_key
     * @param string $rgs_on_wait_list_flag
     * @param string $rgs_confirm_date
     * @param string $rgs_attendance_flag
     * @param string $rgs_add_user
     * @param string $rgs_add_date
     * @param string $rgs_change_user
     * @param string $rgs_change_date
     * @param string $rgs_delete_flag
     * @param string $rgs_key_ext
     * @param string $rgs_ivd_key
     * @param string $rgs_cancel_date
     * @param string $rgs_entity_key
     * @param string $rgs_cancel_reason
     * @param string $rgs_score
     * @param string $rgs_grade
     * @param string $rgs_rgs_key
     * @param string $rgs_odd_key
     * @param int $rgs_qty
     * @param int $rgs_cancel_qty
     * @param int $rgs_balance_qty_cp
     * @param string $rgs_gft_key
     * @param string $rgs_time_in
     * @param string $rgs_time_out
     * @param string $rgs_prc_key
     * @param string $rgs_tickets
     * @param int $rgs_reduce_qty
     * @param string $rgs_NewBatch_key
     */
    public function __construct(?string $rgs_key = null, ?string $rgs_reg_key = null, ?string $rgs_ses_key = null, ?string $rgs_trk_key = null, ?string $rgs_on_wait_list_flag = null, ?string $rgs_confirm_date = null, ?string $rgs_attendance_flag = null, ?string $rgs_add_user = null, ?string $rgs_add_date = null, ?string $rgs_change_user = null, ?string $rgs_change_date = null, ?string $rgs_delete_flag = null, ?string $rgs_key_ext = null, ?string $rgs_ivd_key = null, ?string $rgs_cancel_date = null, ?string $rgs_entity_key = null, ?string $rgs_cancel_reason = null, ?string $rgs_score = null, ?string $rgs_grade = null, ?string $rgs_rgs_key = null, ?string $rgs_odd_key = null, ?int $rgs_qty = null, ?int $rgs_cancel_qty = null, ?int $rgs_balance_qty_cp = null, ?string $rgs_gft_key = null, ?string $rgs_time_in = null, ?string $rgs_time_out = null, ?string $rgs_prc_key = null, ?string $rgs_tickets = null, ?int $rgs_reduce_qty = null, ?string $rgs_NewBatch_key = null)
    {
        $this
            ->setRgs_key($rgs_key)
            ->setRgs_reg_key($rgs_reg_key)
            ->setRgs_ses_key($rgs_ses_key)
            ->setRgs_trk_key($rgs_trk_key)
            ->setRgs_on_wait_list_flag($rgs_on_wait_list_flag)
            ->setRgs_confirm_date($rgs_confirm_date)
            ->setRgs_attendance_flag($rgs_attendance_flag)
            ->setRgs_add_user($rgs_add_user)
            ->setRgs_add_date($rgs_add_date)
            ->setRgs_change_user($rgs_change_user)
            ->setRgs_change_date($rgs_change_date)
            ->setRgs_delete_flag($rgs_delete_flag)
            ->setRgs_key_ext($rgs_key_ext)
            ->setRgs_ivd_key($rgs_ivd_key)
            ->setRgs_cancel_date($rgs_cancel_date)
            ->setRgs_entity_key($rgs_entity_key)
            ->setRgs_cancel_reason($rgs_cancel_reason)
            ->setRgs_score($rgs_score)
            ->setRgs_grade($rgs_grade)
            ->setRgs_rgs_key($rgs_rgs_key)
            ->setRgs_odd_key($rgs_odd_key)
            ->setRgs_qty($rgs_qty)
            ->setRgs_cancel_qty($rgs_cancel_qty)
            ->setRgs_balance_qty_cp($rgs_balance_qty_cp)
            ->setRgs_gft_key($rgs_gft_key)
            ->setRgs_time_in($rgs_time_in)
            ->setRgs_time_out($rgs_time_out)
            ->setRgs_prc_key($rgs_prc_key)
            ->setRgs_tickets($rgs_tickets)
            ->setRgs_reduce_qty($rgs_reduce_qty)
            ->setRgs_NewBatch_key($rgs_NewBatch_key);
    }
    /**
     * Get rgs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_key(): ?string
    {
        return $this->rgs_key ?? null;
    }
    /**
     * Set rgs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_key(?string $rgs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_key) && !is_string($rgs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_key, true), gettype($rgs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_key, true)), __LINE__);
        }
        if (is_null($rgs_key) || (is_array($rgs_key) && empty($rgs_key))) {
            unset($this->rgs_key);
        } else {
            $this->rgs_key = $rgs_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_reg_key(): ?string
    {
        return $this->rgs_reg_key ?? null;
    }
    /**
     * Set rgs_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_reg_key(?string $rgs_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_reg_key) && !is_string($rgs_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_reg_key, true), gettype($rgs_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_reg_key, true)), __LINE__);
        }
        if (is_null($rgs_reg_key) || (is_array($rgs_reg_key) && empty($rgs_reg_key))) {
            unset($this->rgs_reg_key);
        } else {
            $this->rgs_reg_key = $rgs_reg_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_ses_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_ses_key(): ?string
    {
        return $this->rgs_ses_key ?? null;
    }
    /**
     * Set rgs_ses_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_ses_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_ses_key(?string $rgs_ses_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_ses_key) && !is_string($rgs_ses_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_ses_key, true), gettype($rgs_ses_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_ses_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_ses_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_ses_key, true)), __LINE__);
        }
        if (is_null($rgs_ses_key) || (is_array($rgs_ses_key) && empty($rgs_ses_key))) {
            unset($this->rgs_ses_key);
        } else {
            $this->rgs_ses_key = $rgs_ses_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_trk_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_trk_key(): ?string
    {
        return $this->rgs_trk_key ?? null;
    }
    /**
     * Set rgs_trk_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_trk_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_trk_key(?string $rgs_trk_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_trk_key) && !is_string($rgs_trk_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_trk_key, true), gettype($rgs_trk_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_trk_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_trk_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_trk_key, true)), __LINE__);
        }
        if (is_null($rgs_trk_key) || (is_array($rgs_trk_key) && empty($rgs_trk_key))) {
            unset($this->rgs_trk_key);
        } else {
            $this->rgs_trk_key = $rgs_trk_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_on_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_on_wait_list_flag(): ?string
    {
        return $this->rgs_on_wait_list_flag ?? null;
    }
    /**
     * Set rgs_on_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_on_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_on_wait_list_flag(?string $rgs_on_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_on_wait_list_flag) && !is_string($rgs_on_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_on_wait_list_flag, true), gettype($rgs_on_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rgs_on_wait_list_flag) && $rgs_on_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rgs_on_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rgs_on_wait_list_flag) && $rgs_on_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rgs_on_wait_list_flag, true)), __LINE__);
        }
        if (is_null($rgs_on_wait_list_flag) || (is_array($rgs_on_wait_list_flag) && empty($rgs_on_wait_list_flag))) {
            unset($this->rgs_on_wait_list_flag);
        } else {
            $this->rgs_on_wait_list_flag = $rgs_on_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get rgs_confirm_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_confirm_date(): ?string
    {
        return $this->rgs_confirm_date ?? null;
    }
    /**
     * Set rgs_confirm_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_confirm_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_confirm_date(?string $rgs_confirm_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_confirm_date) && !is_string($rgs_confirm_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_confirm_date, true), gettype($rgs_confirm_date)), __LINE__);
        }
        if (is_null($rgs_confirm_date) || (is_array($rgs_confirm_date) && empty($rgs_confirm_date))) {
            unset($this->rgs_confirm_date);
        } else {
            $this->rgs_confirm_date = $rgs_confirm_date;
        }
        
        return $this;
    }
    /**
     * Get rgs_attendance_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_attendance_flag(): ?string
    {
        return $this->rgs_attendance_flag ?? null;
    }
    /**
     * Set rgs_attendance_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_attendance_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_attendance_flag(?string $rgs_attendance_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_attendance_flag) && !is_string($rgs_attendance_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_attendance_flag, true), gettype($rgs_attendance_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rgs_attendance_flag) && $rgs_attendance_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rgs_attendance_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rgs_attendance_flag) && $rgs_attendance_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rgs_attendance_flag, true)), __LINE__);
        }
        if (is_null($rgs_attendance_flag) || (is_array($rgs_attendance_flag) && empty($rgs_attendance_flag))) {
            unset($this->rgs_attendance_flag);
        } else {
            $this->rgs_attendance_flag = $rgs_attendance_flag;
        }
        
        return $this;
    }
    /**
     * Get rgs_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_add_user(): ?string
    {
        return $this->rgs_add_user ?? null;
    }
    /**
     * Set rgs_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_add_user(?string $rgs_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_add_user) && !is_string($rgs_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_add_user, true), gettype($rgs_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rgs_add_user) && mb_strlen((string) $rgs_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $rgs_add_user)), __LINE__);
        }
        if (is_null($rgs_add_user) || (is_array($rgs_add_user) && empty($rgs_add_user))) {
            unset($this->rgs_add_user);
        } else {
            $this->rgs_add_user = $rgs_add_user;
        }
        
        return $this;
    }
    /**
     * Get rgs_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_add_date(): ?string
    {
        return $this->rgs_add_date ?? null;
    }
    /**
     * Set rgs_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_add_date(?string $rgs_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_add_date) && !is_string($rgs_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_add_date, true), gettype($rgs_add_date)), __LINE__);
        }
        if (is_null($rgs_add_date) || (is_array($rgs_add_date) && empty($rgs_add_date))) {
            unset($this->rgs_add_date);
        } else {
            $this->rgs_add_date = $rgs_add_date;
        }
        
        return $this;
    }
    /**
     * Get rgs_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_change_user(): ?string
    {
        return $this->rgs_change_user ?? null;
    }
    /**
     * Set rgs_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_change_user(?string $rgs_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_change_user) && !is_string($rgs_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_change_user, true), gettype($rgs_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rgs_change_user) && mb_strlen((string) $rgs_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $rgs_change_user)), __LINE__);
        }
        if (is_null($rgs_change_user) || (is_array($rgs_change_user) && empty($rgs_change_user))) {
            unset($this->rgs_change_user);
        } else {
            $this->rgs_change_user = $rgs_change_user;
        }
        
        return $this;
    }
    /**
     * Get rgs_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_change_date(): ?string
    {
        return $this->rgs_change_date ?? null;
    }
    /**
     * Set rgs_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_change_date(?string $rgs_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_change_date) && !is_string($rgs_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_change_date, true), gettype($rgs_change_date)), __LINE__);
        }
        if (is_null($rgs_change_date) || (is_array($rgs_change_date) && empty($rgs_change_date))) {
            unset($this->rgs_change_date);
        } else {
            $this->rgs_change_date = $rgs_change_date;
        }
        
        return $this;
    }
    /**
     * Get rgs_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_delete_flag(): ?string
    {
        return $this->rgs_delete_flag ?? null;
    }
    /**
     * Set rgs_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_delete_flag(?string $rgs_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_delete_flag) && !is_string($rgs_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_delete_flag, true), gettype($rgs_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rgs_delete_flag) && $rgs_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rgs_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rgs_delete_flag) && $rgs_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rgs_delete_flag, true)), __LINE__);
        }
        if (is_null($rgs_delete_flag) || (is_array($rgs_delete_flag) && empty($rgs_delete_flag))) {
            unset($this->rgs_delete_flag);
        } else {
            $this->rgs_delete_flag = $rgs_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get rgs_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_key_ext(): ?string
    {
        return $this->rgs_key_ext ?? null;
    }
    /**
     * Set rgs_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_key_ext(?string $rgs_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_key_ext) && !is_string($rgs_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_key_ext, true), gettype($rgs_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_key_ext, true)), __LINE__);
        }
        if (is_null($rgs_key_ext) || (is_array($rgs_key_ext) && empty($rgs_key_ext))) {
            unset($this->rgs_key_ext);
        } else {
            $this->rgs_key_ext = $rgs_key_ext;
        }
        
        return $this;
    }
    /**
     * Get rgs_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_ivd_key(): ?string
    {
        return $this->rgs_ivd_key ?? null;
    }
    /**
     * Set rgs_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_ivd_key(?string $rgs_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_ivd_key) && !is_string($rgs_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_ivd_key, true), gettype($rgs_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_ivd_key, true)), __LINE__);
        }
        if (is_null($rgs_ivd_key) || (is_array($rgs_ivd_key) && empty($rgs_ivd_key))) {
            unset($this->rgs_ivd_key);
        } else {
            $this->rgs_ivd_key = $rgs_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_cancel_date(): ?string
    {
        return $this->rgs_cancel_date ?? null;
    }
    /**
     * Set rgs_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_cancel_date(?string $rgs_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_cancel_date) && !is_string($rgs_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_cancel_date, true), gettype($rgs_cancel_date)), __LINE__);
        }
        if (is_null($rgs_cancel_date) || (is_array($rgs_cancel_date) && empty($rgs_cancel_date))) {
            unset($this->rgs_cancel_date);
        } else {
            $this->rgs_cancel_date = $rgs_cancel_date;
        }
        
        return $this;
    }
    /**
     * Get rgs_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_entity_key(): ?string
    {
        return $this->rgs_entity_key ?? null;
    }
    /**
     * Set rgs_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_entity_key(?string $rgs_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_entity_key) && !is_string($rgs_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_entity_key, true), gettype($rgs_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_entity_key, true)), __LINE__);
        }
        if (is_null($rgs_entity_key) || (is_array($rgs_entity_key) && empty($rgs_entity_key))) {
            unset($this->rgs_entity_key);
        } else {
            $this->rgs_entity_key = $rgs_entity_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_cancel_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_cancel_reason(): ?string
    {
        return $this->rgs_cancel_reason ?? null;
    }
    /**
     * Set rgs_cancel_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_cancel_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_cancel_reason(?string $rgs_cancel_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_cancel_reason) && !is_string($rgs_cancel_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_cancel_reason, true), gettype($rgs_cancel_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($rgs_cancel_reason) && mb_strlen((string) $rgs_cancel_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $rgs_cancel_reason)), __LINE__);
        }
        if (is_null($rgs_cancel_reason) || (is_array($rgs_cancel_reason) && empty($rgs_cancel_reason))) {
            unset($this->rgs_cancel_reason);
        } else {
            $this->rgs_cancel_reason = $rgs_cancel_reason;
        }
        
        return $this;
    }
    /**
     * Get rgs_score value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_score(): ?string
    {
        return $this->rgs_score ?? null;
    }
    /**
     * Set rgs_score value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_score
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_score(?string $rgs_score = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_score) && !is_string($rgs_score)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_score, true), gettype($rgs_score)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($rgs_score) && mb_strlen((string) $rgs_score) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $rgs_score)), __LINE__);
        }
        if (is_null($rgs_score) || (is_array($rgs_score) && empty($rgs_score))) {
            unset($this->rgs_score);
        } else {
            $this->rgs_score = $rgs_score;
        }
        
        return $this;
    }
    /**
     * Get rgs_grade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_grade(): ?string
    {
        return $this->rgs_grade ?? null;
    }
    /**
     * Set rgs_grade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_grade
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_grade(?string $rgs_grade = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_grade) && !is_string($rgs_grade)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_grade, true), gettype($rgs_grade)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($rgs_grade) && mb_strlen((string) $rgs_grade) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $rgs_grade)), __LINE__);
        }
        if (is_null($rgs_grade) || (is_array($rgs_grade) && empty($rgs_grade))) {
            unset($this->rgs_grade);
        } else {
            $this->rgs_grade = $rgs_grade;
        }
        
        return $this;
    }
    /**
     * Get rgs_rgs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_rgs_key(): ?string
    {
        return $this->rgs_rgs_key ?? null;
    }
    /**
     * Set rgs_rgs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_rgs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_rgs_key(?string $rgs_rgs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_rgs_key) && !is_string($rgs_rgs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_rgs_key, true), gettype($rgs_rgs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_rgs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_rgs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_rgs_key, true)), __LINE__);
        }
        if (is_null($rgs_rgs_key) || (is_array($rgs_rgs_key) && empty($rgs_rgs_key))) {
            unset($this->rgs_rgs_key);
        } else {
            $this->rgs_rgs_key = $rgs_rgs_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_odd_key(): ?string
    {
        return $this->rgs_odd_key ?? null;
    }
    /**
     * Set rgs_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_odd_key(?string $rgs_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_odd_key) && !is_string($rgs_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_odd_key, true), gettype($rgs_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_odd_key, true)), __LINE__);
        }
        if (is_null($rgs_odd_key) || (is_array($rgs_odd_key) && empty($rgs_odd_key))) {
            unset($this->rgs_odd_key);
        } else {
            $this->rgs_odd_key = $rgs_odd_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRgs_qty(): ?int
    {
        return $this->rgs_qty ?? null;
    }
    /**
     * Set rgs_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rgs_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_qty(?int $rgs_qty = null): self
    {
        // validation for constraint: int
        if (!is_null($rgs_qty) && !(is_int($rgs_qty) || ctype_digit($rgs_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rgs_qty, true), gettype($rgs_qty)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($rgs_qty) && $rgs_qty > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($rgs_qty, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($rgs_qty) && $rgs_qty < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($rgs_qty, true)), __LINE__);
        }
        if (is_null($rgs_qty) || (is_array($rgs_qty) && empty($rgs_qty))) {
            unset($this->rgs_qty);
        } else {
            $this->rgs_qty = $rgs_qty;
        }
        
        return $this;
    }
    /**
     * Get rgs_cancel_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRgs_cancel_qty(): ?int
    {
        return $this->rgs_cancel_qty ?? null;
    }
    /**
     * Set rgs_cancel_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rgs_cancel_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_cancel_qty(?int $rgs_cancel_qty = null): self
    {
        // validation for constraint: int
        if (!is_null($rgs_cancel_qty) && !(is_int($rgs_cancel_qty) || ctype_digit($rgs_cancel_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rgs_cancel_qty, true), gettype($rgs_cancel_qty)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($rgs_cancel_qty) && $rgs_cancel_qty > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($rgs_cancel_qty, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($rgs_cancel_qty) && $rgs_cancel_qty < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($rgs_cancel_qty, true)), __LINE__);
        }
        if (is_null($rgs_cancel_qty) || (is_array($rgs_cancel_qty) && empty($rgs_cancel_qty))) {
            unset($this->rgs_cancel_qty);
        } else {
            $this->rgs_cancel_qty = $rgs_cancel_qty;
        }
        
        return $this;
    }
    /**
     * Get rgs_balance_qty_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRgs_balance_qty_cp(): ?int
    {
        return $this->rgs_balance_qty_cp ?? null;
    }
    /**
     * Set rgs_balance_qty_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rgs_balance_qty_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_balance_qty_cp(?int $rgs_balance_qty_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($rgs_balance_qty_cp) && !(is_int($rgs_balance_qty_cp) || ctype_digit($rgs_balance_qty_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rgs_balance_qty_cp, true), gettype($rgs_balance_qty_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($rgs_balance_qty_cp) && $rgs_balance_qty_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($rgs_balance_qty_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($rgs_balance_qty_cp) && $rgs_balance_qty_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($rgs_balance_qty_cp, true)), __LINE__);
        }
        if (is_null($rgs_balance_qty_cp) || (is_array($rgs_balance_qty_cp) && empty($rgs_balance_qty_cp))) {
            unset($this->rgs_balance_qty_cp);
        } else {
            $this->rgs_balance_qty_cp = $rgs_balance_qty_cp;
        }
        
        return $this;
    }
    /**
     * Get rgs_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_gft_key(): ?string
    {
        return $this->rgs_gft_key ?? null;
    }
    /**
     * Set rgs_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_gft_key(?string $rgs_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_gft_key) && !is_string($rgs_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_gft_key, true), gettype($rgs_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_gft_key, true)), __LINE__);
        }
        if (is_null($rgs_gft_key) || (is_array($rgs_gft_key) && empty($rgs_gft_key))) {
            unset($this->rgs_gft_key);
        } else {
            $this->rgs_gft_key = $rgs_gft_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_time_in value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_time_in(): ?string
    {
        return $this->rgs_time_in ?? null;
    }
    /**
     * Set rgs_time_in value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_time_in
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_time_in(?string $rgs_time_in = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_time_in) && !is_string($rgs_time_in)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_time_in, true), gettype($rgs_time_in)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($rgs_time_in) && mb_strlen((string) $rgs_time_in) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $rgs_time_in)), __LINE__);
        }
        if (is_null($rgs_time_in) || (is_array($rgs_time_in) && empty($rgs_time_in))) {
            unset($this->rgs_time_in);
        } else {
            $this->rgs_time_in = $rgs_time_in;
        }
        
        return $this;
    }
    /**
     * Get rgs_time_out value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_time_out(): ?string
    {
        return $this->rgs_time_out ?? null;
    }
    /**
     * Set rgs_time_out value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_time_out
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_time_out(?string $rgs_time_out = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_time_out) && !is_string($rgs_time_out)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_time_out, true), gettype($rgs_time_out)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($rgs_time_out) && mb_strlen((string) $rgs_time_out) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $rgs_time_out)), __LINE__);
        }
        if (is_null($rgs_time_out) || (is_array($rgs_time_out) && empty($rgs_time_out))) {
            unset($this->rgs_time_out);
        } else {
            $this->rgs_time_out = $rgs_time_out;
        }
        
        return $this;
    }
    /**
     * Get rgs_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_prc_key(): ?string
    {
        return $this->rgs_prc_key ?? null;
    }
    /**
     * Set rgs_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_prc_key(?string $rgs_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_prc_key) && !is_string($rgs_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_prc_key, true), gettype($rgs_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_prc_key, true)), __LINE__);
        }
        if (is_null($rgs_prc_key) || (is_array($rgs_prc_key) && empty($rgs_prc_key))) {
            unset($this->rgs_prc_key);
        } else {
            $this->rgs_prc_key = $rgs_prc_key;
        }
        
        return $this;
    }
    /**
     * Get rgs_tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_tickets(): ?string
    {
        return $this->rgs_tickets ?? null;
    }
    /**
     * Set rgs_tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_tickets
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_tickets(?string $rgs_tickets = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_tickets) && !is_string($rgs_tickets)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_tickets, true), gettype($rgs_tickets)), __LINE__);
        }
        if (is_null($rgs_tickets) || (is_array($rgs_tickets) && empty($rgs_tickets))) {
            unset($this->rgs_tickets);
        } else {
            $this->rgs_tickets = $rgs_tickets;
        }
        
        return $this;
    }
    /**
     * Get rgs_reduce_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRgs_reduce_qty(): ?int
    {
        return $this->rgs_reduce_qty ?? null;
    }
    /**
     * Set rgs_reduce_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rgs_reduce_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_reduce_qty(?int $rgs_reduce_qty = null): self
    {
        // validation for constraint: int
        if (!is_null($rgs_reduce_qty) && !(is_int($rgs_reduce_qty) || ctype_digit($rgs_reduce_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rgs_reduce_qty, true), gettype($rgs_reduce_qty)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($rgs_reduce_qty) && $rgs_reduce_qty > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($rgs_reduce_qty, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($rgs_reduce_qty) && $rgs_reduce_qty < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($rgs_reduce_qty, true)), __LINE__);
        }
        if (is_null($rgs_reduce_qty) || (is_array($rgs_reduce_qty) && empty($rgs_reduce_qty))) {
            unset($this->rgs_reduce_qty);
        } else {
            $this->rgs_reduce_qty = $rgs_reduce_qty;
        }
        
        return $this;
    }
    /**
     * Get rgs_NewBatch_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgs_NewBatch_key(): ?string
    {
        return $this->rgs_NewBatch_key ?? null;
    }
    /**
     * Set rgs_NewBatch_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgs_NewBatch_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_session_DataObjectType
     */
    public function setRgs_NewBatch_key(?string $rgs_NewBatch_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgs_NewBatch_key) && !is_string($rgs_NewBatch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgs_NewBatch_key, true), gettype($rgs_NewBatch_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgs_NewBatch_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgs_NewBatch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgs_NewBatch_key, true)), __LINE__);
        }
        if (is_null($rgs_NewBatch_key) || (is_array($rgs_NewBatch_key) && empty($rgs_NewBatch_key))) {
            unset($this->rgs_NewBatch_key);
        } else {
            $this->rgs_NewBatch_key = $rgs_NewBatch_key;
        }
        
        return $this;
    }
}
