<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrantSession_ev_track_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrantSession_ev_track_DataObjectType extends AbstractStructBase
{
    /**
     * The trk_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trk_key = null;
    /**
     * The trk_set_key
     * Meta information extracted from the WSDL
     * - documentation: track type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trk_set_key = null;
    /**
     * The trk_name
     * Meta information extracted from the WSDL
     * - documentation: Track Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trk_name = null;
    /**
     * The trk_use_track_fees
     * Meta information extracted from the WSDL
     * - documentation: Use Tack Fees?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trk_use_track_fees = null;
    /**
     * The trk_evt_key
     * Meta information extracted from the WSDL
     * - documentation: event. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trk_evt_key = null;
    /**
     * The trk_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trk_add_user = null;
    /**
     * The trk_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trk_add_date = null;
    /**
     * The trk_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trk_change_user = null;
    /**
     * The trk_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trk_change_date = null;
    /**
     * The trk_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trk_delete_flag = null;
    /**
     * The trk_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trk_key_ext = null;
    /**
     * The trk_short_description
     * Meta information extracted from the WSDL
     * - documentation: short description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trk_short_description = null;
    /**
     * The trk_description
     * Meta information extracted from the WSDL
     * - documentation: description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trk_description = null;
    /**
     * The trk_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trk_entity_key = null;
    /**
     * Constructor method for EventsRegistrantSession_ev_track_DataObjectType
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_key()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_set_key()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_name()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_use_track_fees()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_evt_key()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_add_user()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_add_date()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_change_user()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_change_date()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_delete_flag()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_key_ext()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_short_description()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_description()
     * @uses EventsRegistrantSession_ev_track_DataObjectType::setTrk_entity_key()
     * @param string $trk_key
     * @param string $trk_set_key
     * @param string $trk_name
     * @param string $trk_use_track_fees
     * @param string $trk_evt_key
     * @param string $trk_add_user
     * @param string $trk_add_date
     * @param string $trk_change_user
     * @param string $trk_change_date
     * @param string $trk_delete_flag
     * @param string $trk_key_ext
     * @param string $trk_short_description
     * @param string $trk_description
     * @param string $trk_entity_key
     */
    public function __construct(?string $trk_key = null, ?string $trk_set_key = null, ?string $trk_name = null, ?string $trk_use_track_fees = null, ?string $trk_evt_key = null, ?string $trk_add_user = null, ?string $trk_add_date = null, ?string $trk_change_user = null, ?string $trk_change_date = null, ?string $trk_delete_flag = null, ?string $trk_key_ext = null, ?string $trk_short_description = null, ?string $trk_description = null, ?string $trk_entity_key = null)
    {
        $this
            ->setTrk_key($trk_key)
            ->setTrk_set_key($trk_set_key)
            ->setTrk_name($trk_name)
            ->setTrk_use_track_fees($trk_use_track_fees)
            ->setTrk_evt_key($trk_evt_key)
            ->setTrk_add_user($trk_add_user)
            ->setTrk_add_date($trk_add_date)
            ->setTrk_change_user($trk_change_user)
            ->setTrk_change_date($trk_change_date)
            ->setTrk_delete_flag($trk_delete_flag)
            ->setTrk_key_ext($trk_key_ext)
            ->setTrk_short_description($trk_short_description)
            ->setTrk_description($trk_description)
            ->setTrk_entity_key($trk_entity_key);
    }
    /**
     * Get trk_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_key(): ?string
    {
        return $this->trk_key ?? null;
    }
    /**
     * Set trk_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_key(?string $trk_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_key) && !is_string($trk_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_key, true), gettype($trk_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trk_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trk_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trk_key, true)), __LINE__);
        }
        if (is_null($trk_key) || (is_array($trk_key) && empty($trk_key))) {
            unset($this->trk_key);
        } else {
            $this->trk_key = $trk_key;
        }
        
        return $this;
    }
    /**
     * Get trk_set_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_set_key(): ?string
    {
        return $this->trk_set_key ?? null;
    }
    /**
     * Set trk_set_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_set_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_set_key(?string $trk_set_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_set_key) && !is_string($trk_set_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_set_key, true), gettype($trk_set_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trk_set_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trk_set_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trk_set_key, true)), __LINE__);
        }
        if (is_null($trk_set_key) || (is_array($trk_set_key) && empty($trk_set_key))) {
            unset($this->trk_set_key);
        } else {
            $this->trk_set_key = $trk_set_key;
        }
        
        return $this;
    }
    /**
     * Get trk_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_name(): ?string
    {
        return $this->trk_name ?? null;
    }
    /**
     * Set trk_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_name(?string $trk_name = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_name) && !is_string($trk_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_name, true), gettype($trk_name)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($trk_name) && mb_strlen((string) $trk_name) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $trk_name)), __LINE__);
        }
        if (is_null($trk_name) || (is_array($trk_name) && empty($trk_name))) {
            unset($this->trk_name);
        } else {
            $this->trk_name = $trk_name;
        }
        
        return $this;
    }
    /**
     * Get trk_use_track_fees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_use_track_fees(): ?string
    {
        return $this->trk_use_track_fees ?? null;
    }
    /**
     * Set trk_use_track_fees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_use_track_fees
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_use_track_fees(?string $trk_use_track_fees = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_use_track_fees) && !is_string($trk_use_track_fees)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_use_track_fees, true), gettype($trk_use_track_fees)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trk_use_track_fees) && $trk_use_track_fees > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trk_use_track_fees, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trk_use_track_fees) && $trk_use_track_fees < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trk_use_track_fees, true)), __LINE__);
        }
        if (is_null($trk_use_track_fees) || (is_array($trk_use_track_fees) && empty($trk_use_track_fees))) {
            unset($this->trk_use_track_fees);
        } else {
            $this->trk_use_track_fees = $trk_use_track_fees;
        }
        
        return $this;
    }
    /**
     * Get trk_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_evt_key(): ?string
    {
        return $this->trk_evt_key ?? null;
    }
    /**
     * Set trk_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_evt_key(?string $trk_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_evt_key) && !is_string($trk_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_evt_key, true), gettype($trk_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trk_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trk_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trk_evt_key, true)), __LINE__);
        }
        if (is_null($trk_evt_key) || (is_array($trk_evt_key) && empty($trk_evt_key))) {
            unset($this->trk_evt_key);
        } else {
            $this->trk_evt_key = $trk_evt_key;
        }
        
        return $this;
    }
    /**
     * Get trk_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_add_user(): ?string
    {
        return $this->trk_add_user ?? null;
    }
    /**
     * Set trk_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_add_user(?string $trk_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_add_user) && !is_string($trk_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_add_user, true), gettype($trk_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($trk_add_user) && mb_strlen((string) $trk_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $trk_add_user)), __LINE__);
        }
        if (is_null($trk_add_user) || (is_array($trk_add_user) && empty($trk_add_user))) {
            unset($this->trk_add_user);
        } else {
            $this->trk_add_user = $trk_add_user;
        }
        
        return $this;
    }
    /**
     * Get trk_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_add_date(): ?string
    {
        return $this->trk_add_date ?? null;
    }
    /**
     * Set trk_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_add_date(?string $trk_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_add_date) && !is_string($trk_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_add_date, true), gettype($trk_add_date)), __LINE__);
        }
        if (is_null($trk_add_date) || (is_array($trk_add_date) && empty($trk_add_date))) {
            unset($this->trk_add_date);
        } else {
            $this->trk_add_date = $trk_add_date;
        }
        
        return $this;
    }
    /**
     * Get trk_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_change_user(): ?string
    {
        return $this->trk_change_user ?? null;
    }
    /**
     * Set trk_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_change_user(?string $trk_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_change_user) && !is_string($trk_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_change_user, true), gettype($trk_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($trk_change_user) && mb_strlen((string) $trk_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $trk_change_user)), __LINE__);
        }
        if (is_null($trk_change_user) || (is_array($trk_change_user) && empty($trk_change_user))) {
            unset($this->trk_change_user);
        } else {
            $this->trk_change_user = $trk_change_user;
        }
        
        return $this;
    }
    /**
     * Get trk_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_change_date(): ?string
    {
        return $this->trk_change_date ?? null;
    }
    /**
     * Set trk_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_change_date(?string $trk_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_change_date) && !is_string($trk_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_change_date, true), gettype($trk_change_date)), __LINE__);
        }
        if (is_null($trk_change_date) || (is_array($trk_change_date) && empty($trk_change_date))) {
            unset($this->trk_change_date);
        } else {
            $this->trk_change_date = $trk_change_date;
        }
        
        return $this;
    }
    /**
     * Get trk_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_delete_flag(): ?string
    {
        return $this->trk_delete_flag ?? null;
    }
    /**
     * Set trk_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_delete_flag(?string $trk_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_delete_flag) && !is_string($trk_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_delete_flag, true), gettype($trk_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trk_delete_flag) && $trk_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trk_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trk_delete_flag) && $trk_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trk_delete_flag, true)), __LINE__);
        }
        if (is_null($trk_delete_flag) || (is_array($trk_delete_flag) && empty($trk_delete_flag))) {
            unset($this->trk_delete_flag);
        } else {
            $this->trk_delete_flag = $trk_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get trk_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_key_ext(): ?string
    {
        return $this->trk_key_ext ?? null;
    }
    /**
     * Set trk_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_key_ext(?string $trk_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_key_ext) && !is_string($trk_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_key_ext, true), gettype($trk_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trk_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trk_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trk_key_ext, true)), __LINE__);
        }
        if (is_null($trk_key_ext) || (is_array($trk_key_ext) && empty($trk_key_ext))) {
            unset($this->trk_key_ext);
        } else {
            $this->trk_key_ext = $trk_key_ext;
        }
        
        return $this;
    }
    /**
     * Get trk_short_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_short_description(): ?string
    {
        return $this->trk_short_description ?? null;
    }
    /**
     * Set trk_short_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_short_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_short_description(?string $trk_short_description = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_short_description) && !is_string($trk_short_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_short_description, true), gettype($trk_short_description)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($trk_short_description) && mb_strlen((string) $trk_short_description) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $trk_short_description)), __LINE__);
        }
        if (is_null($trk_short_description) || (is_array($trk_short_description) && empty($trk_short_description))) {
            unset($this->trk_short_description);
        } else {
            $this->trk_short_description = $trk_short_description;
        }
        
        return $this;
    }
    /**
     * Get trk_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_description(): ?string
    {
        return $this->trk_description ?? null;
    }
    /**
     * Set trk_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_description(?string $trk_description = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_description) && !is_string($trk_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_description, true), gettype($trk_description)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($trk_description) && mb_strlen((string) $trk_description) > 500) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen((string) $trk_description)), __LINE__);
        }
        if (is_null($trk_description) || (is_array($trk_description) && empty($trk_description))) {
            unset($this->trk_description);
        } else {
            $this->trk_description = $trk_description;
        }
        
        return $this;
    }
    /**
     * Get trk_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrk_entity_key(): ?string
    {
        return $this->trk_entity_key ?? null;
    }
    /**
     * Set trk_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trk_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_track_DataObjectType
     */
    public function setTrk_entity_key(?string $trk_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trk_entity_key) && !is_string($trk_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trk_entity_key, true), gettype($trk_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trk_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trk_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trk_entity_key, true)), __LINE__);
        }
        if (is_null($trk_entity_key) || (is_array($trk_entity_key) && empty($trk_entity_key))) {
            unset($this->trk_entity_key);
        } else {
            $this->trk_entity_key = $trk_entity_key;
        }
        
        return $this;
    }
}
