<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrantType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrantType extends AbstractStructBase
{
    /**
     * The Registrant
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_DataObjectType $Registrant = null;
    /**
     * The Individual
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_DataObjectType $Individual = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Customer_DataObjectType $Customer = null;
    /**
     * The Individual_X_Organization
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_X_Organization_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_X_Organization_DataObjectType $Individual_X_Organization = null;
    /**
     * The Organization
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Organization_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Organization_DataObjectType $Organization = null;
    /**
     * The Address_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_XRef_DataObjectType $Address_XRef = null;
    /**
     * The Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_DataObjectType $Address = null;
    /**
     * The Email
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Email_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Email_DataObjectType $Email = null;
    /**
     * The Website
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Website_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Website_DataObjectType $Website = null;
    /**
     * The Messaging
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Messaging_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Messaging_DataObjectType $Messaging = null;
    /**
     * The Phone_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_XRef_DataObjectType $Phone_XRef = null;
    /**
     * The Phone
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_DataObjectType $Phone = null;
    /**
     * The Fax_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_XRef_DataObjectType $Fax_XRef = null;
    /**
     * The Fax
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType $Fax = null;
    /**
     * The Event
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_DataObjectType $Event = null;
    /**
     * The Event_Location
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType $Event_Location = null;
    /**
     * The Location
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType $Location = null;
    /**
     * The Location_Customer_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType $Location_Customer_Address = null;
    /**
     * The Location_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Address_DataObjectType $Location_Address = null;
    /**
     * The Location_Phone_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType $Location_Phone_XRef = null;
    /**
     * The Location_Website
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType $Location_Website = null;
    /**
     * The Event_Location_Room_Type
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_Room_Type_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_Room_Type_DataObjectType $Event_Location_Room_Type = null;
    /**
     * The Room_Request
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType $Room_Request = null;
    /**
     * The Registrant_Housing
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType $Registrant_Housing = null;
    /**
     * The RegistrantGuest
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType $RegistrantGuest = null;
    /**
     * The Invoice
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Invoice_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Invoice_DataObjectType $Invoice = null;
    /**
     * The Payment
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_DataObjectType $Payment = null;
    /**
     * The Payment_Info
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Info_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Info_DataObjectType $Payment_Info = null;
    /**
     * The Payment_Method
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Method_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Method_DataObjectType $Payment_Method = null;
    /**
     * The Product
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Product_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Product_DataObjectType $Product = null;
    /**
     * The Price
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Price_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Price_DataObjectType $Price = null;
    /**
     * The Registrant_Type
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType $Registrant_Type = null;
    /**
     * The Registrant_Custom_Demographics
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Custom_Demographics_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Custom_Demographics_DataObjectType $Registrant_Custom_Demographics = null;
    /**
     * The Gift
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType $Gift = null;
    /**
     * The source_code
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_source_code_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_source_code_DataObjectType $source_code = null;
    /**
     * The Registrant_Session
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Session_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Session_DataObjectType $Registrant_Session = null;
    /**
     * The Registrant_SessionCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Registrant_SessionCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Registrant_SessionCollectionType $Registrant_SessionCollection = null;
    /**
     * The Invoice_DetailCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $Invoice_DetailCollection = null;
    /**
     * The Additional_Invoice_DetailCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $Additional_Invoice_DetailCollection = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Primary Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for EventsRegistrantType
     * @uses EventsRegistrantType::setRegistrant()
     * @uses EventsRegistrantType::setIndividual()
     * @uses EventsRegistrantType::setCustomer()
     * @uses EventsRegistrantType::setIndividual_X_Organization()
     * @uses EventsRegistrantType::setOrganization()
     * @uses EventsRegistrantType::setAddress_XRef()
     * @uses EventsRegistrantType::setAddress()
     * @uses EventsRegistrantType::setEmail()
     * @uses EventsRegistrantType::setWebsite()
     * @uses EventsRegistrantType::setMessaging()
     * @uses EventsRegistrantType::setPhone_XRef()
     * @uses EventsRegistrantType::setPhone()
     * @uses EventsRegistrantType::setFax_XRef()
     * @uses EventsRegistrantType::setFax()
     * @uses EventsRegistrantType::setEvent()
     * @uses EventsRegistrantType::setEvent_Location()
     * @uses EventsRegistrantType::setLocation()
     * @uses EventsRegistrantType::setLocation_Customer_Address()
     * @uses EventsRegistrantType::setLocation_Address()
     * @uses EventsRegistrantType::setLocation_Phone_XRef()
     * @uses EventsRegistrantType::setLocation_Website()
     * @uses EventsRegistrantType::setEvent_Location_Room_Type()
     * @uses EventsRegistrantType::setRoom_Request()
     * @uses EventsRegistrantType::setRegistrant_Housing()
     * @uses EventsRegistrantType::setRegistrantGuest()
     * @uses EventsRegistrantType::setInvoice()
     * @uses EventsRegistrantType::setPayment()
     * @uses EventsRegistrantType::setPayment_Info()
     * @uses EventsRegistrantType::setPayment_Method()
     * @uses EventsRegistrantType::setProduct()
     * @uses EventsRegistrantType::setPrice()
     * @uses EventsRegistrantType::setRegistrant_Type()
     * @uses EventsRegistrantType::setRegistrant_Custom_Demographics()
     * @uses EventsRegistrantType::setGift()
     * @uses EventsRegistrantType::setSource_code()
     * @uses EventsRegistrantType::setRegistrant_Session()
     * @uses EventsRegistrantType::setRegistrant_SessionCollection()
     * @uses EventsRegistrantType::setInvoice_DetailCollection()
     * @uses EventsRegistrantType::setAdditional_Invoice_DetailCollection()
     * @uses EventsRegistrantType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_DataObjectType $registrant
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_DataObjectType $individual
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_X_Organization_DataObjectType $individual_X_Organization
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Organization_DataObjectType $organization
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_XRef_DataObjectType $address_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_DataObjectType $address
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Email_DataObjectType $email
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Website_DataObjectType $website
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Messaging_DataObjectType $messaging
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_XRef_DataObjectType $phone_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_DataObjectType $phone
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_XRef_DataObjectType $fax_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType $fax
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_DataObjectType $event
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType $event_Location
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType $location
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType $location_Customer_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Address_DataObjectType $location_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType $location_Phone_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType $location_Website
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_Room_Type_DataObjectType $event_Location_Room_Type
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType $room_Request
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType $registrant_Housing
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType $registrantGuest
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Invoice_DataObjectType $invoice
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_DataObjectType $payment
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Info_DataObjectType $payment_Info
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Method_DataObjectType $payment_Method
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Product_DataObjectType $product
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Price_DataObjectType $price
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType $registrant_Type
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Custom_Demographics_DataObjectType $registrant_Custom_Demographics
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType $gift
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_source_code_DataObjectType $source_code
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Session_DataObjectType $registrant_Session
     * @param \Drupal\netforum\xWeb\Generated\StructType\Registrant_SessionCollectionType $registrant_SessionCollection
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @param \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_DataObjectType $registrant = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_DataObjectType $individual = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_X_Organization_DataObjectType $individual_X_Organization = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Organization_DataObjectType $organization = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_XRef_DataObjectType $address_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_DataObjectType $address = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Email_DataObjectType $email = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Website_DataObjectType $website = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Messaging_DataObjectType $messaging = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_XRef_DataObjectType $phone_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_DataObjectType $phone = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_XRef_DataObjectType $fax_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType $fax = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_DataObjectType $event = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType $event_Location = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType $location = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType $location_Customer_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Address_DataObjectType $location_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType $location_Phone_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType $location_Website = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_Room_Type_DataObjectType $event_Location_Room_Type = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType $room_Request = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType $registrant_Housing = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType $registrantGuest = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Invoice_DataObjectType $invoice = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_DataObjectType $payment = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Info_DataObjectType $payment_Info = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Method_DataObjectType $payment_Method = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Product_DataObjectType $product = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Price_DataObjectType $price = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType $registrant_Type = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Custom_Demographics_DataObjectType $registrant_Custom_Demographics = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType $gift = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_source_code_DataObjectType $source_code = null, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Session_DataObjectType $registrant_Session = null, ?\Drupal\netforum\xWeb\Generated\StructType\Registrant_SessionCollectionType $registrant_SessionCollection = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null, ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection = null, ?string $currentKey = null)
    {
        $this
            ->setRegistrant($registrant)
            ->setIndividual($individual)
            ->setCustomer($customer)
            ->setIndividual_X_Organization($individual_X_Organization)
            ->setOrganization($organization)
            ->setAddress_XRef($address_XRef)
            ->setAddress($address)
            ->setEmail($email)
            ->setWebsite($website)
            ->setMessaging($messaging)
            ->setPhone_XRef($phone_XRef)
            ->setPhone($phone)
            ->setFax_XRef($fax_XRef)
            ->setFax($fax)
            ->setEvent($event)
            ->setEvent_Location($event_Location)
            ->setLocation($location)
            ->setLocation_Customer_Address($location_Customer_Address)
            ->setLocation_Address($location_Address)
            ->setLocation_Phone_XRef($location_Phone_XRef)
            ->setLocation_Website($location_Website)
            ->setEvent_Location_Room_Type($event_Location_Room_Type)
            ->setRoom_Request($room_Request)
            ->setRegistrant_Housing($registrant_Housing)
            ->setRegistrantGuest($registrantGuest)
            ->setInvoice($invoice)
            ->setPayment($payment)
            ->setPayment_Info($payment_Info)
            ->setPayment_Method($payment_Method)
            ->setProduct($product)
            ->setPrice($price)
            ->setRegistrant_Type($registrant_Type)
            ->setRegistrant_Custom_Demographics($registrant_Custom_Demographics)
            ->setGift($gift)
            ->setSource_code($source_code)
            ->setRegistrant_Session($registrant_Session)
            ->setRegistrant_SessionCollection($registrant_SessionCollection)
            ->setInvoice_DetailCollection($invoice_DetailCollection)
            ->setAdditional_Invoice_DetailCollection($additional_Invoice_DetailCollection)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Registrant value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_DataObjectType|null
     */
    public function getRegistrant(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_DataObjectType
    {
        return $this->Registrant;
    }
    /**
     * Set Registrant value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_DataObjectType $registrant
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setRegistrant(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_DataObjectType $registrant = null): self
    {
        $this->Registrant = $registrant;
        
        return $this;
    }
    /**
     * Get Individual value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_DataObjectType|null
     */
    public function getIndividual(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_DataObjectType
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_DataObjectType $individual
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setIndividual(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_DataObjectType $individual = null): self
    {
        $this->Individual = $individual;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Individual_X_Organization value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_X_Organization_DataObjectType|null
     */
    public function getIndividual_X_Organization(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_X_Organization_DataObjectType
    {
        return $this->Individual_X_Organization;
    }
    /**
     * Set Individual_X_Organization value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_X_Organization_DataObjectType $individual_X_Organization
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setIndividual_X_Organization(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Individual_X_Organization_DataObjectType $individual_X_Organization = null): self
    {
        $this->Individual_X_Organization = $individual_X_Organization;
        
        return $this;
    }
    /**
     * Get Organization value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Organization_DataObjectType|null
     */
    public function getOrganization(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Organization_DataObjectType
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Organization_DataObjectType $organization
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setOrganization(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Organization_DataObjectType $organization = null): self
    {
        $this->Organization = $organization;
        
        return $this;
    }
    /**
     * Get Address_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_XRef_DataObjectType|null
     */
    public function getAddress_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_XRef_DataObjectType
    {
        return $this->Address_XRef;
    }
    /**
     * Set Address_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_XRef_DataObjectType $address_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setAddress_XRef(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_XRef_DataObjectType $address_XRef = null): self
    {
        $this->Address_XRef = $address_XRef;
        
        return $this;
    }
    /**
     * Get Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_DataObjectType|null
     */
    public function getAddress(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_DataObjectType
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_DataObjectType $address
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setAddress(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Address_DataObjectType $address = null): self
    {
        $this->Address = $address;
        
        return $this;
    }
    /**
     * Get Email value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Email_DataObjectType|null
     */
    public function getEmail(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Email_DataObjectType
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Email_DataObjectType $email
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setEmail(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Email_DataObjectType $email = null): self
    {
        $this->Email = $email;
        
        return $this;
    }
    /**
     * Get Website value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Website_DataObjectType|null
     */
    public function getWebsite(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Website_DataObjectType
    {
        return $this->Website;
    }
    /**
     * Set Website value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Website_DataObjectType $website
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setWebsite(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Website_DataObjectType $website = null): self
    {
        $this->Website = $website;
        
        return $this;
    }
    /**
     * Get Messaging value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Messaging_DataObjectType|null
     */
    public function getMessaging(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Messaging_DataObjectType
    {
        return $this->Messaging;
    }
    /**
     * Set Messaging value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Messaging_DataObjectType $messaging
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setMessaging(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Messaging_DataObjectType $messaging = null): self
    {
        $this->Messaging = $messaging;
        
        return $this;
    }
    /**
     * Get Phone_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_XRef_DataObjectType|null
     */
    public function getPhone_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_XRef_DataObjectType
    {
        return $this->Phone_XRef;
    }
    /**
     * Set Phone_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_XRef_DataObjectType $phone_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setPhone_XRef(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_XRef_DataObjectType $phone_XRef = null): self
    {
        $this->Phone_XRef = $phone_XRef;
        
        return $this;
    }
    /**
     * Get Phone value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_DataObjectType|null
     */
    public function getPhone(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_DataObjectType
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_DataObjectType $phone
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setPhone(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Phone_DataObjectType $phone = null): self
    {
        $this->Phone = $phone;
        
        return $this;
    }
    /**
     * Get Fax_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_XRef_DataObjectType|null
     */
    public function getFax_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_XRef_DataObjectType
    {
        return $this->Fax_XRef;
    }
    /**
     * Set Fax_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_XRef_DataObjectType $fax_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setFax_XRef(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_XRef_DataObjectType $fax_XRef = null): self
    {
        $this->Fax_XRef = $fax_XRef;
        
        return $this;
    }
    /**
     * Get Fax value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType|null
     */
    public function getFax(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType $fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setFax(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType $fax = null): self
    {
        $this->Fax = $fax;
        
        return $this;
    }
    /**
     * Get Event value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_DataObjectType|null
     */
    public function getEvent(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_DataObjectType
    {
        return $this->Event;
    }
    /**
     * Set Event value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_DataObjectType $event
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setEvent(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_DataObjectType $event = null): self
    {
        $this->Event = $event;
        
        return $this;
    }
    /**
     * Get Event_Location value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType|null
     */
    public function getEvent_Location(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
    {
        return $this->Event_Location;
    }
    /**
     * Set Event_Location value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType $event_Location
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setEvent_Location(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType $event_Location = null): self
    {
        $this->Event_Location = $event_Location;
        
        return $this;
    }
    /**
     * Get Location value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType|null
     */
    public function getLocation(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType $location
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setLocation(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType $location = null): self
    {
        $this->Location = $location;
        
        return $this;
    }
    /**
     * Get Location_Customer_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType|null
     */
    public function getLocation_Customer_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
    {
        return $this->Location_Customer_Address;
    }
    /**
     * Set Location_Customer_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType $location_Customer_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setLocation_Customer_Address(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType $location_Customer_Address = null): self
    {
        $this->Location_Customer_Address = $location_Customer_Address;
        
        return $this;
    }
    /**
     * Get Location_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Address_DataObjectType|null
     */
    public function getLocation_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Address_DataObjectType
    {
        return $this->Location_Address;
    }
    /**
     * Set Location_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Address_DataObjectType $location_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setLocation_Address(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Address_DataObjectType $location_Address = null): self
    {
        $this->Location_Address = $location_Address;
        
        return $this;
    }
    /**
     * Get Location_Phone_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType|null
     */
    public function getLocation_Phone_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
    {
        return $this->Location_Phone_XRef;
    }
    /**
     * Set Location_Phone_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType $location_Phone_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setLocation_Phone_XRef(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType $location_Phone_XRef = null): self
    {
        $this->Location_Phone_XRef = $location_Phone_XRef;
        
        return $this;
    }
    /**
     * Get Location_Website value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType|null
     */
    public function getLocation_Website(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
    {
        return $this->Location_Website;
    }
    /**
     * Set Location_Website value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType $location_Website
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setLocation_Website(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType $location_Website = null): self
    {
        $this->Location_Website = $location_Website;
        
        return $this;
    }
    /**
     * Get Event_Location_Room_Type value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_Room_Type_DataObjectType|null
     */
    public function getEvent_Location_Room_Type(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_Room_Type_DataObjectType
    {
        return $this->Event_Location_Room_Type;
    }
    /**
     * Set Event_Location_Room_Type value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_Room_Type_DataObjectType $event_Location_Room_Type
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setEvent_Location_Room_Type(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_Room_Type_DataObjectType $event_Location_Room_Type = null): self
    {
        $this->Event_Location_Room_Type = $event_Location_Room_Type;
        
        return $this;
    }
    /**
     * Get Room_Request value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType|null
     */
    public function getRoom_Request(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
    {
        return $this->Room_Request;
    }
    /**
     * Set Room_Request value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType $room_Request
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setRoom_Request(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType $room_Request = null): self
    {
        $this->Room_Request = $room_Request;
        
        return $this;
    }
    /**
     * Get Registrant_Housing value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType|null
     */
    public function getRegistrant_Housing(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
    {
        return $this->Registrant_Housing;
    }
    /**
     * Set Registrant_Housing value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType $registrant_Housing
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setRegistrant_Housing(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType $registrant_Housing = null): self
    {
        $this->Registrant_Housing = $registrant_Housing;
        
        return $this;
    }
    /**
     * Get RegistrantGuest value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType|null
     */
    public function getRegistrantGuest(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
    {
        return $this->RegistrantGuest;
    }
    /**
     * Set RegistrantGuest value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType $registrantGuest
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setRegistrantGuest(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType $registrantGuest = null): self
    {
        $this->RegistrantGuest = $registrantGuest;
        
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Invoice_DataObjectType|null
     */
    public function getInvoice(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Invoice_DataObjectType
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Invoice_DataObjectType $invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setInvoice(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Invoice_DataObjectType $invoice = null): self
    {
        $this->Invoice = $invoice;
        
        return $this;
    }
    /**
     * Get Payment value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_DataObjectType|null
     */
    public function getPayment(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_DataObjectType
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_DataObjectType $payment
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setPayment(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_DataObjectType $payment = null): self
    {
        $this->Payment = $payment;
        
        return $this;
    }
    /**
     * Get Payment_Info value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Info_DataObjectType|null
     */
    public function getPayment_Info(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Info_DataObjectType
    {
        return $this->Payment_Info;
    }
    /**
     * Set Payment_Info value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Info_DataObjectType $payment_Info
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setPayment_Info(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Info_DataObjectType $payment_Info = null): self
    {
        $this->Payment_Info = $payment_Info;
        
        return $this;
    }
    /**
     * Get Payment_Method value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Method_DataObjectType|null
     */
    public function getPayment_Method(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Method_DataObjectType
    {
        return $this->Payment_Method;
    }
    /**
     * Set Payment_Method value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Method_DataObjectType $payment_Method
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setPayment_Method(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Payment_Method_DataObjectType $payment_Method = null): self
    {
        $this->Payment_Method = $payment_Method;
        
        return $this;
    }
    /**
     * Get Product value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Product_DataObjectType|null
     */
    public function getProduct(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Product_DataObjectType
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Product_DataObjectType $product
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setProduct(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Product_DataObjectType $product = null): self
    {
        $this->Product = $product;
        
        return $this;
    }
    /**
     * Get Price value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Price_DataObjectType|null
     */
    public function getPrice(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Price_DataObjectType
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Price_DataObjectType $price
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setPrice(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Price_DataObjectType $price = null): self
    {
        $this->Price = $price;
        
        return $this;
    }
    /**
     * Get Registrant_Type value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType|null
     */
    public function getRegistrant_Type(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
    {
        return $this->Registrant_Type;
    }
    /**
     * Set Registrant_Type value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType $registrant_Type
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setRegistrant_Type(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType $registrant_Type = null): self
    {
        $this->Registrant_Type = $registrant_Type;
        
        return $this;
    }
    /**
     * Get Registrant_Custom_Demographics value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Custom_Demographics_DataObjectType|null
     */
    public function getRegistrant_Custom_Demographics(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Custom_Demographics_DataObjectType
    {
        return $this->Registrant_Custom_Demographics;
    }
    /**
     * Set Registrant_Custom_Demographics value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Custom_Demographics_DataObjectType $registrant_Custom_Demographics
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setRegistrant_Custom_Demographics(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Custom_Demographics_DataObjectType $registrant_Custom_Demographics = null): self
    {
        $this->Registrant_Custom_Demographics = $registrant_Custom_Demographics;
        
        return $this;
    }
    /**
     * Get Gift value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType|null
     */
    public function getGift(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
    {
        return $this->Gift;
    }
    /**
     * Set Gift value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType $gift
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setGift(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType $gift = null): self
    {
        $this->Gift = $gift;
        
        return $this;
    }
    /**
     * Get source_code value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_source_code_DataObjectType|null
     */
    public function getSource_code(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_source_code_DataObjectType
    {
        return $this->source_code;
    }
    /**
     * Set source_code value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_source_code_DataObjectType $source_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setSource_code(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_source_code_DataObjectType $source_code = null): self
    {
        $this->source_code = $source_code;
        
        return $this;
    }
    /**
     * Get Registrant_Session value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Session_DataObjectType|null
     */
    public function getRegistrant_Session(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Session_DataObjectType
    {
        return $this->Registrant_Session;
    }
    /**
     * Set Registrant_Session value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Session_DataObjectType $registrant_Session
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setRegistrant_Session(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Session_DataObjectType $registrant_Session = null): self
    {
        $this->Registrant_Session = $registrant_Session;
        
        return $this;
    }
    /**
     * Get Registrant_SessionCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Registrant_SessionCollectionType|null
     */
    public function getRegistrant_SessionCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Registrant_SessionCollectionType
    {
        return $this->Registrant_SessionCollection;
    }
    /**
     * Set Registrant_SessionCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Registrant_SessionCollectionType $registrant_SessionCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setRegistrant_SessionCollection(?\Drupal\netforum\xWeb\Generated\StructType\Registrant_SessionCollectionType $registrant_SessionCollection = null): self
    {
        $this->Registrant_SessionCollection = $registrant_SessionCollection;
        
        return $this;
    }
    /**
     * Get Invoice_DetailCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    public function getInvoice_DetailCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType
    {
        return $this->Invoice_DetailCollection;
    }
    /**
     * Set Invoice_DetailCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setInvoice_DetailCollection(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null): self
    {
        $this->Invoice_DetailCollection = $invoice_DetailCollection;
        
        return $this;
    }
    /**
     * Get Additional_Invoice_DetailCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType|null
     */
    public function getAdditional_Invoice_DetailCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType
    {
        return $this->Additional_Invoice_DetailCollection;
    }
    /**
     * Set Additional_Invoice_DetailCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setAdditional_Invoice_DetailCollection(?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection = null): self
    {
        $this->Additional_Invoice_DetailCollection = $additional_Invoice_DetailCollection;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
