<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Event_Location_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Event_Location_DataObjectType extends AbstractStructBase
{
    /**
     * The evl_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evl_key = null;
    /**
     * The evl_evt_key
     * Meta information extracted from the WSDL
     * - documentation: event name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evl_evt_key = null;
    /**
     * The evl_ses_key
     * Meta information extracted from the WSDL
     * - documentation: session. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evl_ses_key = null;
    /**
     * The evl_loc_key
     * Meta information extracted from the WSDL
     * - documentation: location. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evl_loc_key = null;
    /**
     * The evl_location_name
     * Meta information extracted from the WSDL
     * - documentation: Location Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evl_location_name = null;
    /**
     * The evl_contact_fax
     * Meta information extracted from the WSDL
     * - documentation: fax number. This field has this Input Mask: (999)999-9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 13
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evl_contact_fax = null;
    /**
     * The evl_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evl_add_date = null;
    /**
     * The evl_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evl_add_user = null;
    /**
     * The evl_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evl_change_date = null;
    /**
     * The evl_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evl_change_user = null;
    /**
     * The evl_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evl_delete_flag = null;
    /**
     * The evl_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evl_key_ext = null;
    /**
     * The evl_primary
     * Meta information extracted from the WSDL
     * - documentation: Primary. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evl_primary = null;
    /**
     * The evl_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evl_entity_key = null;
    /**
     * Constructor method for EventsRegistrant_Event_Location_DataObjectType
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_key()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_evt_key()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_ses_key()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_loc_key()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_location_name()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_contact_fax()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_add_date()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_add_user()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_change_date()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_change_user()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_delete_flag()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_key_ext()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_primary()
     * @uses EventsRegistrant_Event_Location_DataObjectType::setEvl_entity_key()
     * @param string $evl_key
     * @param string $evl_evt_key
     * @param string $evl_ses_key
     * @param string $evl_loc_key
     * @param string $evl_location_name
     * @param string $evl_contact_fax
     * @param string $evl_add_date
     * @param string $evl_add_user
     * @param string $evl_change_date
     * @param string $evl_change_user
     * @param string $evl_delete_flag
     * @param string $evl_key_ext
     * @param string $evl_primary
     * @param string $evl_entity_key
     */
    public function __construct(?string $evl_key = null, ?string $evl_evt_key = null, ?string $evl_ses_key = null, ?string $evl_loc_key = null, ?string $evl_location_name = null, ?string $evl_contact_fax = null, ?string $evl_add_date = null, ?string $evl_add_user = null, ?string $evl_change_date = null, ?string $evl_change_user = null, ?string $evl_delete_flag = null, ?string $evl_key_ext = null, ?string $evl_primary = null, ?string $evl_entity_key = null)
    {
        $this
            ->setEvl_key($evl_key)
            ->setEvl_evt_key($evl_evt_key)
            ->setEvl_ses_key($evl_ses_key)
            ->setEvl_loc_key($evl_loc_key)
            ->setEvl_location_name($evl_location_name)
            ->setEvl_contact_fax($evl_contact_fax)
            ->setEvl_add_date($evl_add_date)
            ->setEvl_add_user($evl_add_user)
            ->setEvl_change_date($evl_change_date)
            ->setEvl_change_user($evl_change_user)
            ->setEvl_delete_flag($evl_delete_flag)
            ->setEvl_key_ext($evl_key_ext)
            ->setEvl_primary($evl_primary)
            ->setEvl_entity_key($evl_entity_key);
    }
    /**
     * Get evl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_key(): ?string
    {
        return $this->evl_key ?? null;
    }
    /**
     * Set evl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_key(?string $evl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_key) && !is_string($evl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_key, true), gettype($evl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evl_key, true)), __LINE__);
        }
        if (is_null($evl_key) || (is_array($evl_key) && empty($evl_key))) {
            unset($this->evl_key);
        } else {
            $this->evl_key = $evl_key;
        }
        
        return $this;
    }
    /**
     * Get evl_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_evt_key(): ?string
    {
        return $this->evl_evt_key ?? null;
    }
    /**
     * Set evl_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_evt_key(?string $evl_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_evt_key) && !is_string($evl_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_evt_key, true), gettype($evl_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evl_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evl_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evl_evt_key, true)), __LINE__);
        }
        if (is_null($evl_evt_key) || (is_array($evl_evt_key) && empty($evl_evt_key))) {
            unset($this->evl_evt_key);
        } else {
            $this->evl_evt_key = $evl_evt_key;
        }
        
        return $this;
    }
    /**
     * Get evl_ses_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_ses_key(): ?string
    {
        return $this->evl_ses_key ?? null;
    }
    /**
     * Set evl_ses_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_ses_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_ses_key(?string $evl_ses_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_ses_key) && !is_string($evl_ses_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_ses_key, true), gettype($evl_ses_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evl_ses_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evl_ses_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evl_ses_key, true)), __LINE__);
        }
        if (is_null($evl_ses_key) || (is_array($evl_ses_key) && empty($evl_ses_key))) {
            unset($this->evl_ses_key);
        } else {
            $this->evl_ses_key = $evl_ses_key;
        }
        
        return $this;
    }
    /**
     * Get evl_loc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_loc_key(): ?string
    {
        return $this->evl_loc_key ?? null;
    }
    /**
     * Set evl_loc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_loc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_loc_key(?string $evl_loc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_loc_key) && !is_string($evl_loc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_loc_key, true), gettype($evl_loc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evl_loc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evl_loc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evl_loc_key, true)), __LINE__);
        }
        if (is_null($evl_loc_key) || (is_array($evl_loc_key) && empty($evl_loc_key))) {
            unset($this->evl_loc_key);
        } else {
            $this->evl_loc_key = $evl_loc_key;
        }
        
        return $this;
    }
    /**
     * Get evl_location_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_location_name(): ?string
    {
        return $this->evl_location_name ?? null;
    }
    /**
     * Set evl_location_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_location_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_location_name(?string $evl_location_name = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_location_name) && !is_string($evl_location_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_location_name, true), gettype($evl_location_name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($evl_location_name) && mb_strlen((string) $evl_location_name) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $evl_location_name)), __LINE__);
        }
        if (is_null($evl_location_name) || (is_array($evl_location_name) && empty($evl_location_name))) {
            unset($this->evl_location_name);
        } else {
            $this->evl_location_name = $evl_location_name;
        }
        
        return $this;
    }
    /**
     * Get evl_contact_fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_contact_fax(): ?string
    {
        return $this->evl_contact_fax ?? null;
    }
    /**
     * Set evl_contact_fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_contact_fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_contact_fax(?string $evl_contact_fax = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_contact_fax) && !is_string($evl_contact_fax)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_contact_fax, true), gettype($evl_contact_fax)), __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($evl_contact_fax) && mb_strlen((string) $evl_contact_fax) > 13) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen((string) $evl_contact_fax)), __LINE__);
        }
        if (is_null($evl_contact_fax) || (is_array($evl_contact_fax) && empty($evl_contact_fax))) {
            unset($this->evl_contact_fax);
        } else {
            $this->evl_contact_fax = $evl_contact_fax;
        }
        
        return $this;
    }
    /**
     * Get evl_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_add_date(): ?string
    {
        return $this->evl_add_date ?? null;
    }
    /**
     * Set evl_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_add_date(?string $evl_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_add_date) && !is_string($evl_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_add_date, true), gettype($evl_add_date)), __LINE__);
        }
        if (is_null($evl_add_date) || (is_array($evl_add_date) && empty($evl_add_date))) {
            unset($this->evl_add_date);
        } else {
            $this->evl_add_date = $evl_add_date;
        }
        
        return $this;
    }
    /**
     * Get evl_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_add_user(): ?string
    {
        return $this->evl_add_user ?? null;
    }
    /**
     * Set evl_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_add_user(?string $evl_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_add_user) && !is_string($evl_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_add_user, true), gettype($evl_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($evl_add_user) && mb_strlen((string) $evl_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $evl_add_user)), __LINE__);
        }
        if (is_null($evl_add_user) || (is_array($evl_add_user) && empty($evl_add_user))) {
            unset($this->evl_add_user);
        } else {
            $this->evl_add_user = $evl_add_user;
        }
        
        return $this;
    }
    /**
     * Get evl_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_change_date(): ?string
    {
        return $this->evl_change_date ?? null;
    }
    /**
     * Set evl_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_change_date(?string $evl_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_change_date) && !is_string($evl_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_change_date, true), gettype($evl_change_date)), __LINE__);
        }
        if (is_null($evl_change_date) || (is_array($evl_change_date) && empty($evl_change_date))) {
            unset($this->evl_change_date);
        } else {
            $this->evl_change_date = $evl_change_date;
        }
        
        return $this;
    }
    /**
     * Get evl_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_change_user(): ?string
    {
        return $this->evl_change_user ?? null;
    }
    /**
     * Set evl_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_change_user(?string $evl_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_change_user) && !is_string($evl_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_change_user, true), gettype($evl_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($evl_change_user) && mb_strlen((string) $evl_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $evl_change_user)), __LINE__);
        }
        if (is_null($evl_change_user) || (is_array($evl_change_user) && empty($evl_change_user))) {
            unset($this->evl_change_user);
        } else {
            $this->evl_change_user = $evl_change_user;
        }
        
        return $this;
    }
    /**
     * Get evl_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_delete_flag(): ?string
    {
        return $this->evl_delete_flag ?? null;
    }
    /**
     * Set evl_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_delete_flag(?string $evl_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_delete_flag) && !is_string($evl_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_delete_flag, true), gettype($evl_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evl_delete_flag) && $evl_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evl_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evl_delete_flag) && $evl_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evl_delete_flag, true)), __LINE__);
        }
        if (is_null($evl_delete_flag) || (is_array($evl_delete_flag) && empty($evl_delete_flag))) {
            unset($this->evl_delete_flag);
        } else {
            $this->evl_delete_flag = $evl_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get evl_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_key_ext(): ?string
    {
        return $this->evl_key_ext ?? null;
    }
    /**
     * Set evl_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_key_ext(?string $evl_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_key_ext) && !is_string($evl_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_key_ext, true), gettype($evl_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evl_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evl_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evl_key_ext, true)), __LINE__);
        }
        if (is_null($evl_key_ext) || (is_array($evl_key_ext) && empty($evl_key_ext))) {
            unset($this->evl_key_ext);
        } else {
            $this->evl_key_ext = $evl_key_ext;
        }
        
        return $this;
    }
    /**
     * Get evl_primary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_primary(): ?string
    {
        return $this->evl_primary ?? null;
    }
    /**
     * Set evl_primary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_primary
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_primary(?string $evl_primary = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_primary) && !is_string($evl_primary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_primary, true), gettype($evl_primary)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evl_primary) && $evl_primary > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evl_primary, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evl_primary) && $evl_primary < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evl_primary, true)), __LINE__);
        }
        if (is_null($evl_primary) || (is_array($evl_primary) && empty($evl_primary))) {
            unset($this->evl_primary);
        } else {
            $this->evl_primary = $evl_primary;
        }
        
        return $this;
    }
    /**
     * Get evl_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvl_entity_key(): ?string
    {
        return $this->evl_entity_key ?? null;
    }
    /**
     * Set evl_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evl_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Event_Location_DataObjectType
     */
    public function setEvl_entity_key(?string $evl_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evl_entity_key) && !is_string($evl_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evl_entity_key, true), gettype($evl_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evl_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evl_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evl_entity_key, true)), __LINE__);
        }
        if (is_null($evl_entity_key) || (is_array($evl_entity_key) && empty($evl_entity_key))) {
            unset($this->evl_entity_key);
        } else {
            $this->evl_entity_key = $evl_entity_key;
        }
        
        return $this;
    }
}
