<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Gift_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Gift_DataObjectType extends AbstractStructBase
{
    /**
     * The gft_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_key = null;
    /**
     * The gft_apl_key
     * Meta information extracted from the WSDL
     * - documentation: Appeal Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_apl_key = null;
    /**
     * The gft_fun_key
     * Meta information extracted from the WSDL
     * - documentation: Purpose. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_fun_key = null;
    /**
     * The gft_cmp_key
     * Meta information extracted from the WSDL
     * - documentation: Campaign Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_cmp_key = null;
    /**
     * The gft_gty_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_gty_key = null;
    /**
     * The gft_date
     * Meta information extracted from the WSDL
     * - documentation: Gift Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_date = null;
    /**
     * The gft_deductable_amt
     * Meta information extracted from the WSDL
     * - documentation: Tax Deductable Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gft_deductable_amt = null;
    /**
     * The gft_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_add_user = null;
    /**
     * The gft_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_add_date = null;
    /**
     * The gft_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_change_user = null;
    /**
     * The gft_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_change_date = null;
    /**
     * The gft_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_delete_flag = null;
    /**
     * The gft_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_entity_key = null;
    /**
     * The gft_frt_key
     * Meta information extracted from the WSDL
     * - documentation: Recognition Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_frt_key = null;
    /**
     * The gft_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_cst_key = null;
    /**
     * The gft_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_key_ext = null;
    /**
     * The gft_fpc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Fund. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_fpc_prd_key = null;
    /**
     * The gft_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_ivd_key = null;
    /**
     * The gft_stock_name
     * Meta information extracted from the WSDL
     * - documentation: Stock Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_stock_name = null;
    /**
     * The gft_acknowledgment_note1
     * Meta information extracted from the WSDL
     * - documentation: acknowledgment note 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_acknowledgment_note1 = null;
    /**
     * The gft_acknowledgment_note2
     * Meta information extracted from the WSDL
     * - documentation: acknowledgment note 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_acknowledgment_note2 = null;
    /**
     * The gft_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_cct_key = null;
    /**
     * The gft_notes
     * Meta information extracted from the WSDL
     * - documentation: notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_notes = null;
    /**
     * The gft_number_of_shares
     * Meta information extracted from the WSDL
     * - documentation: Number of Shares. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $gft_number_of_shares = null;
    /**
     * The gft_pck_key
     * Meta information extracted from the WSDL
     * - documentation: Package Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_pck_key = null;
    /**
     * The gft_gft_key
     * Meta information extracted from the WSDL
     * - documentation: Parent Gift Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_gft_key = null;
    /**
     * The gft_prm_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Premium Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_prm_prc_key = null;
    /**
     * The gft_share_price
     * Meta information extracted from the WSDL
     * - documentation: Share Price. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gft_share_price = null;
    /**
     * The gft_anonymous_flag
     * Meta information extracted from the WSDL
     * - documentation: Anonymous. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_anonymous_flag = null;
    /**
     * The gft_inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_inv_code = null;
    /**
     * The gft_recognition_customer_adr_line1
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr line1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_recognition_customer_adr_line1 = null;
    /**
     * The gft_recognition_customer_adr_line2
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr line2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_recognition_customer_adr_line2 = null;
    /**
     * The gft_soft_money
     * Meta information extracted from the WSDL
     * - documentation: Soft Money. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gft_soft_money = null;
    /**
     * The gft_recognition_customer
     * Meta information extracted from the WSDL
     * - documentation: Recognition Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_recognition_customer = null;
    /**
     * The gft_recognition_customer_adr_line3
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr line3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_recognition_customer_adr_line3 = null;
    /**
     * The gft_recognition_customer_adr_city
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr city. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_recognition_customer_adr_city = null;
    /**
     * The gft_recognition_customer_adr_state
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr state. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_recognition_customer_adr_state = null;
    /**
     * The gft_recognition_customer_adr_post_code
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr post code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_recognition_customer_adr_post_code = null;
    /**
     * The gft_recognition_customer_adr_country
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr country.This element has a default value of 'UNITED STATES'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_recognition_customer_adr_country = null;
    /**
     * The gft_plg_key
     * Meta information extracted from the WSDL
     * - documentation: Pledge Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_plg_key = null;
    /**
     * The gft_transfer_from_gft_key
     * Meta information extracted from the WSDL
     * - documentation: Transferred from. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_transfer_from_gft_key = null;
    /**
     * The gft_sct_key
     * Meta information extracted from the WSDL
     * - documentation: soft credit type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_sct_key = null;
    /**
     * The gft_liquidation_amount
     * Meta information extracted from the WSDL
     * - documentation: liquidation amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gft_liquidation_amount = null;
    /**
     * The gft_clg_key
     * Meta information extracted from the WSDL
     * - documentation: match program. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_clg_key = null;
    /**
     * The gft_other_match_program
     * Meta information extracted from the WSDL
     * - documentation: other. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_other_match_program = null;
    /**
     * The gft_form_complete_flag
     * Meta information extracted from the WSDL
     * - documentation: form complete. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_form_complete_flag = null;
    /**
     * The gft_date_sent
     * Meta information extracted from the WSDL
     * - documentation: date sent. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_date_sent = null;
    /**
     * The gft_date_received
     * Meta information extracted from the WSDL
     * - documentation: date received. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_date_received = null;
    /**
     * The gft_solicitor_cst_key
     * Meta information extracted from the WSDL
     * - documentation: solicitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_solicitor_cst_key = null;
    /**
     * The gft_ticker
     * Meta information extracted from the WSDL
     * - documentation: ticker. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_ticker = null;
    /**
     * The gft_acknowledgment_date
     * Meta information extracted from the WSDL
     * - documentation: Acknowledgment Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_acknowledgment_date = null;
    /**
     * The gft_batch_code
     * Meta information extracted from the WSDL
     * - documentation: Gift Batch. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_batch_code = null;
    /**
     * The gft_mail_flag
     * Meta information extracted from the WSDL
     * - documentation: Mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_mail_flag = null;
    /**
     * The gft_recognize_as
     * Meta information extracted from the WSDL
     * - documentation: recognize as. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_recognize_as = null;
    /**
     * The gft_liquidation_date
     * Meta information extracted from the WSDL
     * - documentation: liquidation date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_liquidation_date = null;
    /**
     * The gft_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source Code Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_src_key = null;
    /**
     * The gft_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Registrant Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_reg_key = null;
    /**
     * The gft_tax_receipt_sent_date
     * Meta information extracted from the WSDL
     * - documentation: Tax Receipt Sent Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_tax_receipt_sent_date = null;
    /**
     * The gft_tbt_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Tribute. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_tbt_key = null;
    /**
     * The gft_personal_message
     * Meta information extracted from the WSDL
     * - documentation: Message. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_personal_message = null;
    /**
     * The gft_dnr_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Donor Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_dnr_cst_key = null;
    /**
     * The gft_property_name
     * Meta information extracted from the WSDL
     * - documentation: property name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_property_name = null;
    /**
     * The gft_related_gift_key
     * Meta information extracted from the WSDL
     * - documentation: Related gift key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gft_related_gift_key = null;
    /**
     * The gft_update_funds_raised_pending_flag
     * Meta information extracted from the WSDL
     * - documentation: gft_update_funds_raised_pending_flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_update_funds_raised_pending_flag = null;
    /**
     * The gft_receipt_status
     * Meta information extracted from the WSDL
     * - documentation: Receipt Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gft_receipt_status = null;
    /**
     * The gft_stock_high
     * Meta information extracted from the WSDL
     * - documentation: stock price high.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gft_stock_high = null;
    /**
     * The gft_stock_low
     * Meta information extracted from the WSDL
     * - documentation: stock price low.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gft_stock_low = null;
    /**
     * Constructor method for EventsRegistrant_Gift_DataObjectType
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_apl_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_fun_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_cmp_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_gty_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_date()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_deductable_amt()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_add_user()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_add_date()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_change_user()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_change_date()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_delete_flag()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_entity_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_frt_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_cst_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_key_ext()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_fpc_prd_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_ivd_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_stock_name()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_acknowledgment_note1()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_acknowledgment_note2()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_cct_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_notes()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_number_of_shares()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_pck_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_gft_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_prm_prc_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_share_price()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_anonymous_flag()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_inv_code()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_recognition_customer_adr_line1()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_recognition_customer_adr_line2()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_soft_money()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_recognition_customer()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_recognition_customer_adr_line3()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_recognition_customer_adr_city()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_recognition_customer_adr_state()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_recognition_customer_adr_post_code()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_recognition_customer_adr_country()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_plg_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_transfer_from_gft_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_sct_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_liquidation_amount()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_clg_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_other_match_program()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_form_complete_flag()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_date_sent()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_date_received()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_solicitor_cst_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_ticker()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_acknowledgment_date()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_batch_code()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_mail_flag()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_recognize_as()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_liquidation_date()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_src_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_reg_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_tax_receipt_sent_date()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_tbt_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_personal_message()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_dnr_cst_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_property_name()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_related_gift_key()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_update_funds_raised_pending_flag()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_receipt_status()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_stock_high()
     * @uses EventsRegistrant_Gift_DataObjectType::setGft_stock_low()
     * @param string $gft_key
     * @param string $gft_apl_key
     * @param string $gft_fun_key
     * @param string $gft_cmp_key
     * @param string $gft_gty_key
     * @param string $gft_date
     * @param float $gft_deductable_amt
     * @param string $gft_add_user
     * @param string $gft_add_date
     * @param string $gft_change_user
     * @param string $gft_change_date
     * @param string $gft_delete_flag
     * @param string $gft_entity_key
     * @param string $gft_frt_key
     * @param string $gft_cst_key
     * @param string $gft_key_ext
     * @param string $gft_fpc_prd_key
     * @param string $gft_ivd_key
     * @param string $gft_stock_name
     * @param string $gft_acknowledgment_note1
     * @param string $gft_acknowledgment_note2
     * @param string $gft_cct_key
     * @param string $gft_notes
     * @param float $gft_number_of_shares
     * @param string $gft_pck_key
     * @param string $gft_gft_key
     * @param string $gft_prm_prc_key
     * @param float $gft_share_price
     * @param string $gft_anonymous_flag
     * @param string $gft_inv_code
     * @param string $gft_recognition_customer_adr_line1
     * @param string $gft_recognition_customer_adr_line2
     * @param float $gft_soft_money
     * @param string $gft_recognition_customer
     * @param string $gft_recognition_customer_adr_line3
     * @param string $gft_recognition_customer_adr_city
     * @param string $gft_recognition_customer_adr_state
     * @param string $gft_recognition_customer_adr_post_code
     * @param string $gft_recognition_customer_adr_country
     * @param string $gft_plg_key
     * @param string $gft_transfer_from_gft_key
     * @param string $gft_sct_key
     * @param float $gft_liquidation_amount
     * @param string $gft_clg_key
     * @param string $gft_other_match_program
     * @param string $gft_form_complete_flag
     * @param string $gft_date_sent
     * @param string $gft_date_received
     * @param string $gft_solicitor_cst_key
     * @param string $gft_ticker
     * @param string $gft_acknowledgment_date
     * @param string $gft_batch_code
     * @param string $gft_mail_flag
     * @param string $gft_recognize_as
     * @param string $gft_liquidation_date
     * @param string $gft_src_key
     * @param string $gft_reg_key
     * @param string $gft_tax_receipt_sent_date
     * @param string $gft_tbt_key
     * @param string $gft_personal_message
     * @param string $gft_dnr_cst_key
     * @param string $gft_property_name
     * @param string $gft_related_gift_key
     * @param string $gft_update_funds_raised_pending_flag
     * @param string $gft_receipt_status
     * @param float $gft_stock_high
     * @param float $gft_stock_low
     */
    public function __construct(?string $gft_key = null, ?string $gft_apl_key = null, ?string $gft_fun_key = null, ?string $gft_cmp_key = null, ?string $gft_gty_key = null, ?string $gft_date = null, ?float $gft_deductable_amt = null, ?string $gft_add_user = null, ?string $gft_add_date = null, ?string $gft_change_user = null, ?string $gft_change_date = null, ?string $gft_delete_flag = null, ?string $gft_entity_key = null, ?string $gft_frt_key = null, ?string $gft_cst_key = null, ?string $gft_key_ext = null, ?string $gft_fpc_prd_key = null, ?string $gft_ivd_key = null, ?string $gft_stock_name = null, ?string $gft_acknowledgment_note1 = null, ?string $gft_acknowledgment_note2 = null, ?string $gft_cct_key = null, ?string $gft_notes = null, ?float $gft_number_of_shares = null, ?string $gft_pck_key = null, ?string $gft_gft_key = null, ?string $gft_prm_prc_key = null, ?float $gft_share_price = null, ?string $gft_anonymous_flag = null, ?string $gft_inv_code = null, ?string $gft_recognition_customer_adr_line1 = null, ?string $gft_recognition_customer_adr_line2 = null, ?float $gft_soft_money = null, ?string $gft_recognition_customer = null, ?string $gft_recognition_customer_adr_line3 = null, ?string $gft_recognition_customer_adr_city = null, ?string $gft_recognition_customer_adr_state = null, ?string $gft_recognition_customer_adr_post_code = null, ?string $gft_recognition_customer_adr_country = null, ?string $gft_plg_key = null, ?string $gft_transfer_from_gft_key = null, ?string $gft_sct_key = null, ?float $gft_liquidation_amount = null, ?string $gft_clg_key = null, ?string $gft_other_match_program = null, ?string $gft_form_complete_flag = null, ?string $gft_date_sent = null, ?string $gft_date_received = null, ?string $gft_solicitor_cst_key = null, ?string $gft_ticker = null, ?string $gft_acknowledgment_date = null, ?string $gft_batch_code = null, ?string $gft_mail_flag = null, ?string $gft_recognize_as = null, ?string $gft_liquidation_date = null, ?string $gft_src_key = null, ?string $gft_reg_key = null, ?string $gft_tax_receipt_sent_date = null, ?string $gft_tbt_key = null, ?string $gft_personal_message = null, ?string $gft_dnr_cst_key = null, ?string $gft_property_name = null, ?string $gft_related_gift_key = null, ?string $gft_update_funds_raised_pending_flag = null, ?string $gft_receipt_status = null, ?float $gft_stock_high = null, ?float $gft_stock_low = null)
    {
        $this
            ->setGft_key($gft_key)
            ->setGft_apl_key($gft_apl_key)
            ->setGft_fun_key($gft_fun_key)
            ->setGft_cmp_key($gft_cmp_key)
            ->setGft_gty_key($gft_gty_key)
            ->setGft_date($gft_date)
            ->setGft_deductable_amt($gft_deductable_amt)
            ->setGft_add_user($gft_add_user)
            ->setGft_add_date($gft_add_date)
            ->setGft_change_user($gft_change_user)
            ->setGft_change_date($gft_change_date)
            ->setGft_delete_flag($gft_delete_flag)
            ->setGft_entity_key($gft_entity_key)
            ->setGft_frt_key($gft_frt_key)
            ->setGft_cst_key($gft_cst_key)
            ->setGft_key_ext($gft_key_ext)
            ->setGft_fpc_prd_key($gft_fpc_prd_key)
            ->setGft_ivd_key($gft_ivd_key)
            ->setGft_stock_name($gft_stock_name)
            ->setGft_acknowledgment_note1($gft_acknowledgment_note1)
            ->setGft_acknowledgment_note2($gft_acknowledgment_note2)
            ->setGft_cct_key($gft_cct_key)
            ->setGft_notes($gft_notes)
            ->setGft_number_of_shares($gft_number_of_shares)
            ->setGft_pck_key($gft_pck_key)
            ->setGft_gft_key($gft_gft_key)
            ->setGft_prm_prc_key($gft_prm_prc_key)
            ->setGft_share_price($gft_share_price)
            ->setGft_anonymous_flag($gft_anonymous_flag)
            ->setGft_inv_code($gft_inv_code)
            ->setGft_recognition_customer_adr_line1($gft_recognition_customer_adr_line1)
            ->setGft_recognition_customer_adr_line2($gft_recognition_customer_adr_line2)
            ->setGft_soft_money($gft_soft_money)
            ->setGft_recognition_customer($gft_recognition_customer)
            ->setGft_recognition_customer_adr_line3($gft_recognition_customer_adr_line3)
            ->setGft_recognition_customer_adr_city($gft_recognition_customer_adr_city)
            ->setGft_recognition_customer_adr_state($gft_recognition_customer_adr_state)
            ->setGft_recognition_customer_adr_post_code($gft_recognition_customer_adr_post_code)
            ->setGft_recognition_customer_adr_country($gft_recognition_customer_adr_country)
            ->setGft_plg_key($gft_plg_key)
            ->setGft_transfer_from_gft_key($gft_transfer_from_gft_key)
            ->setGft_sct_key($gft_sct_key)
            ->setGft_liquidation_amount($gft_liquidation_amount)
            ->setGft_clg_key($gft_clg_key)
            ->setGft_other_match_program($gft_other_match_program)
            ->setGft_form_complete_flag($gft_form_complete_flag)
            ->setGft_date_sent($gft_date_sent)
            ->setGft_date_received($gft_date_received)
            ->setGft_solicitor_cst_key($gft_solicitor_cst_key)
            ->setGft_ticker($gft_ticker)
            ->setGft_acknowledgment_date($gft_acknowledgment_date)
            ->setGft_batch_code($gft_batch_code)
            ->setGft_mail_flag($gft_mail_flag)
            ->setGft_recognize_as($gft_recognize_as)
            ->setGft_liquidation_date($gft_liquidation_date)
            ->setGft_src_key($gft_src_key)
            ->setGft_reg_key($gft_reg_key)
            ->setGft_tax_receipt_sent_date($gft_tax_receipt_sent_date)
            ->setGft_tbt_key($gft_tbt_key)
            ->setGft_personal_message($gft_personal_message)
            ->setGft_dnr_cst_key($gft_dnr_cst_key)
            ->setGft_property_name($gft_property_name)
            ->setGft_related_gift_key($gft_related_gift_key)
            ->setGft_update_funds_raised_pending_flag($gft_update_funds_raised_pending_flag)
            ->setGft_receipt_status($gft_receipt_status)
            ->setGft_stock_high($gft_stock_high)
            ->setGft_stock_low($gft_stock_low);
    }
    /**
     * Get gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_key(): ?string
    {
        return $this->gft_key ?? null;
    }
    /**
     * Set gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_key(?string $gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_key) && !is_string($gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_key, true), gettype($gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_key, true)), __LINE__);
        }
        if (is_null($gft_key) || (is_array($gft_key) && empty($gft_key))) {
            unset($this->gft_key);
        } else {
            $this->gft_key = $gft_key;
        }
        
        return $this;
    }
    /**
     * Get gft_apl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_apl_key(): ?string
    {
        return $this->gft_apl_key ?? null;
    }
    /**
     * Set gft_apl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_apl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_apl_key(?string $gft_apl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_apl_key) && !is_string($gft_apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_apl_key, true), gettype($gft_apl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_apl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_apl_key, true)), __LINE__);
        }
        if (is_null($gft_apl_key) || (is_array($gft_apl_key) && empty($gft_apl_key))) {
            unset($this->gft_apl_key);
        } else {
            $this->gft_apl_key = $gft_apl_key;
        }
        
        return $this;
    }
    /**
     * Get gft_fun_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_fun_key(): ?string
    {
        return $this->gft_fun_key ?? null;
    }
    /**
     * Set gft_fun_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_fun_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_fun_key(?string $gft_fun_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_fun_key) && !is_string($gft_fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_fun_key, true), gettype($gft_fun_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_fun_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_fun_key, true)), __LINE__);
        }
        if (is_null($gft_fun_key) || (is_array($gft_fun_key) && empty($gft_fun_key))) {
            unset($this->gft_fun_key);
        } else {
            $this->gft_fun_key = $gft_fun_key;
        }
        
        return $this;
    }
    /**
     * Get gft_cmp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_cmp_key(): ?string
    {
        return $this->gft_cmp_key ?? null;
    }
    /**
     * Set gft_cmp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_cmp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_cmp_key(?string $gft_cmp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_cmp_key) && !is_string($gft_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_cmp_key, true), gettype($gft_cmp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_cmp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_cmp_key, true)), __LINE__);
        }
        if (is_null($gft_cmp_key) || (is_array($gft_cmp_key) && empty($gft_cmp_key))) {
            unset($this->gft_cmp_key);
        } else {
            $this->gft_cmp_key = $gft_cmp_key;
        }
        
        return $this;
    }
    /**
     * Get gft_gty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_gty_key(): ?string
    {
        return $this->gft_gty_key ?? null;
    }
    /**
     * Set gft_gty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_gty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_gty_key(?string $gft_gty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_gty_key) && !is_string($gft_gty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_gty_key, true), gettype($gft_gty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_gty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_gty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_gty_key, true)), __LINE__);
        }
        if (is_null($gft_gty_key) || (is_array($gft_gty_key) && empty($gft_gty_key))) {
            unset($this->gft_gty_key);
        } else {
            $this->gft_gty_key = $gft_gty_key;
        }
        
        return $this;
    }
    /**
     * Get gft_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_date(): ?string
    {
        return $this->gft_date ?? null;
    }
    /**
     * Set gft_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_date(?string $gft_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_date) && !is_string($gft_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_date, true), gettype($gft_date)), __LINE__);
        }
        if (is_null($gft_date) || (is_array($gft_date) && empty($gft_date))) {
            unset($this->gft_date);
        } else {
            $this->gft_date = $gft_date;
        }
        
        return $this;
    }
    /**
     * Get gft_deductable_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGft_deductable_amt(): ?float
    {
        return $this->gft_deductable_amt ?? null;
    }
    /**
     * Set gft_deductable_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gft_deductable_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_deductable_amt(?float $gft_deductable_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($gft_deductable_amt) && !(is_float($gft_deductable_amt) || is_numeric($gft_deductable_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gft_deductable_amt, true), gettype($gft_deductable_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gft_deductable_amt) && mb_strlen(mb_substr((string) $gft_deductable_amt, false !== mb_strpos((string) $gft_deductable_amt, '.') ? mb_strpos((string) $gft_deductable_amt, '.') + 1 : mb_strlen((string) $gft_deductable_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gft_deductable_amt, true), mb_strlen(mb_substr((string) $gft_deductable_amt, mb_strpos((string) $gft_deductable_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gft_deductable_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $gft_deductable_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gft_deductable_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gft_deductable_amt))), __LINE__);
        }
        if (is_null($gft_deductable_amt) || (is_array($gft_deductable_amt) && empty($gft_deductable_amt))) {
            unset($this->gft_deductable_amt);
        } else {
            $this->gft_deductable_amt = $gft_deductable_amt;
        }
        
        return $this;
    }
    /**
     * Get gft_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_add_user(): ?string
    {
        return $this->gft_add_user ?? null;
    }
    /**
     * Set gft_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_add_user(?string $gft_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_add_user) && !is_string($gft_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_add_user, true), gettype($gft_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($gft_add_user) && mb_strlen((string) $gft_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $gft_add_user)), __LINE__);
        }
        if (is_null($gft_add_user) || (is_array($gft_add_user) && empty($gft_add_user))) {
            unset($this->gft_add_user);
        } else {
            $this->gft_add_user = $gft_add_user;
        }
        
        return $this;
    }
    /**
     * Get gft_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_add_date(): ?string
    {
        return $this->gft_add_date ?? null;
    }
    /**
     * Set gft_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_add_date(?string $gft_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_add_date) && !is_string($gft_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_add_date, true), gettype($gft_add_date)), __LINE__);
        }
        if (is_null($gft_add_date) || (is_array($gft_add_date) && empty($gft_add_date))) {
            unset($this->gft_add_date);
        } else {
            $this->gft_add_date = $gft_add_date;
        }
        
        return $this;
    }
    /**
     * Get gft_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_change_user(): ?string
    {
        return $this->gft_change_user ?? null;
    }
    /**
     * Set gft_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_change_user(?string $gft_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_change_user) && !is_string($gft_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_change_user, true), gettype($gft_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($gft_change_user) && mb_strlen((string) $gft_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $gft_change_user)), __LINE__);
        }
        if (is_null($gft_change_user) || (is_array($gft_change_user) && empty($gft_change_user))) {
            unset($this->gft_change_user);
        } else {
            $this->gft_change_user = $gft_change_user;
        }
        
        return $this;
    }
    /**
     * Get gft_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_change_date(): ?string
    {
        return $this->gft_change_date ?? null;
    }
    /**
     * Set gft_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_change_date(?string $gft_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_change_date) && !is_string($gft_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_change_date, true), gettype($gft_change_date)), __LINE__);
        }
        if (is_null($gft_change_date) || (is_array($gft_change_date) && empty($gft_change_date))) {
            unset($this->gft_change_date);
        } else {
            $this->gft_change_date = $gft_change_date;
        }
        
        return $this;
    }
    /**
     * Get gft_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_delete_flag(): ?string
    {
        return $this->gft_delete_flag ?? null;
    }
    /**
     * Set gft_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_delete_flag(?string $gft_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_delete_flag) && !is_string($gft_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_delete_flag, true), gettype($gft_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gft_delete_flag) && $gft_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gft_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gft_delete_flag) && $gft_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gft_delete_flag, true)), __LINE__);
        }
        if (is_null($gft_delete_flag) || (is_array($gft_delete_flag) && empty($gft_delete_flag))) {
            unset($this->gft_delete_flag);
        } else {
            $this->gft_delete_flag = $gft_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get gft_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_entity_key(): ?string
    {
        return $this->gft_entity_key ?? null;
    }
    /**
     * Set gft_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_entity_key(?string $gft_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_entity_key) && !is_string($gft_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_entity_key, true), gettype($gft_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_entity_key, true)), __LINE__);
        }
        if (is_null($gft_entity_key) || (is_array($gft_entity_key) && empty($gft_entity_key))) {
            unset($this->gft_entity_key);
        } else {
            $this->gft_entity_key = $gft_entity_key;
        }
        
        return $this;
    }
    /**
     * Get gft_frt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_frt_key(): ?string
    {
        return $this->gft_frt_key ?? null;
    }
    /**
     * Set gft_frt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_frt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_frt_key(?string $gft_frt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_frt_key) && !is_string($gft_frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_frt_key, true), gettype($gft_frt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_frt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_frt_key, true)), __LINE__);
        }
        if (is_null($gft_frt_key) || (is_array($gft_frt_key) && empty($gft_frt_key))) {
            unset($this->gft_frt_key);
        } else {
            $this->gft_frt_key = $gft_frt_key;
        }
        
        return $this;
    }
    /**
     * Get gft_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_cst_key(): ?string
    {
        return $this->gft_cst_key ?? null;
    }
    /**
     * Set gft_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_cst_key(?string $gft_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_cst_key) && !is_string($gft_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_cst_key, true), gettype($gft_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_cst_key, true)), __LINE__);
        }
        if (is_null($gft_cst_key) || (is_array($gft_cst_key) && empty($gft_cst_key))) {
            unset($this->gft_cst_key);
        } else {
            $this->gft_cst_key = $gft_cst_key;
        }
        
        return $this;
    }
    /**
     * Get gft_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_key_ext(): ?string
    {
        return $this->gft_key_ext ?? null;
    }
    /**
     * Set gft_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_key_ext(?string $gft_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_key_ext) && !is_string($gft_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_key_ext, true), gettype($gft_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_key_ext, true)), __LINE__);
        }
        if (is_null($gft_key_ext) || (is_array($gft_key_ext) && empty($gft_key_ext))) {
            unset($this->gft_key_ext);
        } else {
            $this->gft_key_ext = $gft_key_ext;
        }
        
        return $this;
    }
    /**
     * Get gft_fpc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_fpc_prd_key(): ?string
    {
        return $this->gft_fpc_prd_key ?? null;
    }
    /**
     * Set gft_fpc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_fpc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_fpc_prd_key(?string $gft_fpc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_fpc_prd_key) && !is_string($gft_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_fpc_prd_key, true), gettype($gft_fpc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_fpc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_fpc_prd_key, true)), __LINE__);
        }
        if (is_null($gft_fpc_prd_key) || (is_array($gft_fpc_prd_key) && empty($gft_fpc_prd_key))) {
            unset($this->gft_fpc_prd_key);
        } else {
            $this->gft_fpc_prd_key = $gft_fpc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get gft_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_ivd_key(): ?string
    {
        return $this->gft_ivd_key ?? null;
    }
    /**
     * Set gft_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_ivd_key(?string $gft_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_ivd_key) && !is_string($gft_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_ivd_key, true), gettype($gft_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_ivd_key, true)), __LINE__);
        }
        if (is_null($gft_ivd_key) || (is_array($gft_ivd_key) && empty($gft_ivd_key))) {
            unset($this->gft_ivd_key);
        } else {
            $this->gft_ivd_key = $gft_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get gft_stock_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_stock_name(): ?string
    {
        return $this->gft_stock_name ?? null;
    }
    /**
     * Set gft_stock_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_stock_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_stock_name(?string $gft_stock_name = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_stock_name) && !is_string($gft_stock_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_stock_name, true), gettype($gft_stock_name)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($gft_stock_name) && mb_strlen((string) $gft_stock_name) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $gft_stock_name)), __LINE__);
        }
        if (is_null($gft_stock_name) || (is_array($gft_stock_name) && empty($gft_stock_name))) {
            unset($this->gft_stock_name);
        } else {
            $this->gft_stock_name = $gft_stock_name;
        }
        
        return $this;
    }
    /**
     * Get gft_acknowledgment_note1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_acknowledgment_note1(): ?string
    {
        return $this->gft_acknowledgment_note1 ?? null;
    }
    /**
     * Set gft_acknowledgment_note1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_acknowledgment_note1
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_acknowledgment_note1(?string $gft_acknowledgment_note1 = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_acknowledgment_note1) && !is_string($gft_acknowledgment_note1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_acknowledgment_note1, true), gettype($gft_acknowledgment_note1)), __LINE__);
        }
        if (is_null($gft_acknowledgment_note1) || (is_array($gft_acknowledgment_note1) && empty($gft_acknowledgment_note1))) {
            unset($this->gft_acknowledgment_note1);
        } else {
            $this->gft_acknowledgment_note1 = $gft_acknowledgment_note1;
        }
        
        return $this;
    }
    /**
     * Get gft_acknowledgment_note2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_acknowledgment_note2(): ?string
    {
        return $this->gft_acknowledgment_note2 ?? null;
    }
    /**
     * Set gft_acknowledgment_note2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_acknowledgment_note2
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_acknowledgment_note2(?string $gft_acknowledgment_note2 = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_acknowledgment_note2) && !is_string($gft_acknowledgment_note2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_acknowledgment_note2, true), gettype($gft_acknowledgment_note2)), __LINE__);
        }
        if (is_null($gft_acknowledgment_note2) || (is_array($gft_acknowledgment_note2) && empty($gft_acknowledgment_note2))) {
            unset($this->gft_acknowledgment_note2);
        } else {
            $this->gft_acknowledgment_note2 = $gft_acknowledgment_note2;
        }
        
        return $this;
    }
    /**
     * Get gft_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_cct_key(): ?string
    {
        return $this->gft_cct_key ?? null;
    }
    /**
     * Set gft_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_cct_key(?string $gft_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_cct_key) && !is_string($gft_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_cct_key, true), gettype($gft_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_cct_key, true)), __LINE__);
        }
        if (is_null($gft_cct_key) || (is_array($gft_cct_key) && empty($gft_cct_key))) {
            unset($this->gft_cct_key);
        } else {
            $this->gft_cct_key = $gft_cct_key;
        }
        
        return $this;
    }
    /**
     * Get gft_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_notes(): ?string
    {
        return $this->gft_notes ?? null;
    }
    /**
     * Set gft_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_notes(?string $gft_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_notes) && !is_string($gft_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_notes, true), gettype($gft_notes)), __LINE__);
        }
        if (is_null($gft_notes) || (is_array($gft_notes) && empty($gft_notes))) {
            unset($this->gft_notes);
        } else {
            $this->gft_notes = $gft_notes;
        }
        
        return $this;
    }
    /**
     * Get gft_number_of_shares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGft_number_of_shares(): ?float
    {
        return $this->gft_number_of_shares ?? null;
    }
    /**
     * Set gft_number_of_shares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gft_number_of_shares
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_number_of_shares(?float $gft_number_of_shares = null): self
    {
        // validation for constraint: float
        if (!is_null($gft_number_of_shares) && !(is_float($gft_number_of_shares) || is_numeric($gft_number_of_shares))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gft_number_of_shares, true), gettype($gft_number_of_shares)), __LINE__);
        }
        if (is_null($gft_number_of_shares) || (is_array($gft_number_of_shares) && empty($gft_number_of_shares))) {
            unset($this->gft_number_of_shares);
        } else {
            $this->gft_number_of_shares = $gft_number_of_shares;
        }
        
        return $this;
    }
    /**
     * Get gft_pck_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_pck_key(): ?string
    {
        return $this->gft_pck_key ?? null;
    }
    /**
     * Set gft_pck_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_pck_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_pck_key(?string $gft_pck_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_pck_key) && !is_string($gft_pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_pck_key, true), gettype($gft_pck_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_pck_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_pck_key, true)), __LINE__);
        }
        if (is_null($gft_pck_key) || (is_array($gft_pck_key) && empty($gft_pck_key))) {
            unset($this->gft_pck_key);
        } else {
            $this->gft_pck_key = $gft_pck_key;
        }
        
        return $this;
    }
    /**
     * Get gft_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_gft_key(): ?string
    {
        return $this->gft_gft_key ?? null;
    }
    /**
     * Set gft_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_gft_key(?string $gft_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_gft_key) && !is_string($gft_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_gft_key, true), gettype($gft_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_gft_key, true)), __LINE__);
        }
        if (is_null($gft_gft_key) || (is_array($gft_gft_key) && empty($gft_gft_key))) {
            unset($this->gft_gft_key);
        } else {
            $this->gft_gft_key = $gft_gft_key;
        }
        
        return $this;
    }
    /**
     * Get gft_prm_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_prm_prc_key(): ?string
    {
        return $this->gft_prm_prc_key ?? null;
    }
    /**
     * Set gft_prm_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_prm_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_prm_prc_key(?string $gft_prm_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_prm_prc_key) && !is_string($gft_prm_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_prm_prc_key, true), gettype($gft_prm_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_prm_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_prm_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_prm_prc_key, true)), __LINE__);
        }
        if (is_null($gft_prm_prc_key) || (is_array($gft_prm_prc_key) && empty($gft_prm_prc_key))) {
            unset($this->gft_prm_prc_key);
        } else {
            $this->gft_prm_prc_key = $gft_prm_prc_key;
        }
        
        return $this;
    }
    /**
     * Get gft_share_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGft_share_price(): ?float
    {
        return $this->gft_share_price ?? null;
    }
    /**
     * Set gft_share_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gft_share_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_share_price(?float $gft_share_price = null): self
    {
        // validation for constraint: float
        if (!is_null($gft_share_price) && !(is_float($gft_share_price) || is_numeric($gft_share_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gft_share_price, true), gettype($gft_share_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gft_share_price) && mb_strlen(mb_substr((string) $gft_share_price, false !== mb_strpos((string) $gft_share_price, '.') ? mb_strpos((string) $gft_share_price, '.') + 1 : mb_strlen((string) $gft_share_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gft_share_price, true), mb_strlen(mb_substr((string) $gft_share_price, mb_strpos((string) $gft_share_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gft_share_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $gft_share_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gft_share_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gft_share_price))), __LINE__);
        }
        if (is_null($gft_share_price) || (is_array($gft_share_price) && empty($gft_share_price))) {
            unset($this->gft_share_price);
        } else {
            $this->gft_share_price = $gft_share_price;
        }
        
        return $this;
    }
    /**
     * Get gft_anonymous_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_anonymous_flag(): ?string
    {
        return $this->gft_anonymous_flag ?? null;
    }
    /**
     * Set gft_anonymous_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_anonymous_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_anonymous_flag(?string $gft_anonymous_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_anonymous_flag) && !is_string($gft_anonymous_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_anonymous_flag, true), gettype($gft_anonymous_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gft_anonymous_flag) && $gft_anonymous_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gft_anonymous_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gft_anonymous_flag) && $gft_anonymous_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gft_anonymous_flag, true)), __LINE__);
        }
        if (is_null($gft_anonymous_flag) || (is_array($gft_anonymous_flag) && empty($gft_anonymous_flag))) {
            unset($this->gft_anonymous_flag);
        } else {
            $this->gft_anonymous_flag = $gft_anonymous_flag;
        }
        
        return $this;
    }
    /**
     * Get gft_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_inv_code(): ?string
    {
        return $this->gft_inv_code ?? null;
    }
    /**
     * Set gft_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_inv_code(?string $gft_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_inv_code) && !is_string($gft_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_inv_code, true), gettype($gft_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($gft_inv_code) && mb_strlen((string) $gft_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $gft_inv_code)), __LINE__);
        }
        if (is_null($gft_inv_code) || (is_array($gft_inv_code) && empty($gft_inv_code))) {
            unset($this->gft_inv_code);
        } else {
            $this->gft_inv_code = $gft_inv_code;
        }
        
        return $this;
    }
    /**
     * Get gft_recognition_customer_adr_line1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_recognition_customer_adr_line1(): ?string
    {
        return $this->gft_recognition_customer_adr_line1 ?? null;
    }
    /**
     * Set gft_recognition_customer_adr_line1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_recognition_customer_adr_line1
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_recognition_customer_adr_line1(?string $gft_recognition_customer_adr_line1 = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_recognition_customer_adr_line1) && !is_string($gft_recognition_customer_adr_line1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_recognition_customer_adr_line1, true), gettype($gft_recognition_customer_adr_line1)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($gft_recognition_customer_adr_line1) && mb_strlen((string) $gft_recognition_customer_adr_line1) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $gft_recognition_customer_adr_line1)), __LINE__);
        }
        if (is_null($gft_recognition_customer_adr_line1) || (is_array($gft_recognition_customer_adr_line1) && empty($gft_recognition_customer_adr_line1))) {
            unset($this->gft_recognition_customer_adr_line1);
        } else {
            $this->gft_recognition_customer_adr_line1 = $gft_recognition_customer_adr_line1;
        }
        
        return $this;
    }
    /**
     * Get gft_recognition_customer_adr_line2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_recognition_customer_adr_line2(): ?string
    {
        return $this->gft_recognition_customer_adr_line2 ?? null;
    }
    /**
     * Set gft_recognition_customer_adr_line2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_recognition_customer_adr_line2
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_recognition_customer_adr_line2(?string $gft_recognition_customer_adr_line2 = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_recognition_customer_adr_line2) && !is_string($gft_recognition_customer_adr_line2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_recognition_customer_adr_line2, true), gettype($gft_recognition_customer_adr_line2)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($gft_recognition_customer_adr_line2) && mb_strlen((string) $gft_recognition_customer_adr_line2) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $gft_recognition_customer_adr_line2)), __LINE__);
        }
        if (is_null($gft_recognition_customer_adr_line2) || (is_array($gft_recognition_customer_adr_line2) && empty($gft_recognition_customer_adr_line2))) {
            unset($this->gft_recognition_customer_adr_line2);
        } else {
            $this->gft_recognition_customer_adr_line2 = $gft_recognition_customer_adr_line2;
        }
        
        return $this;
    }
    /**
     * Get gft_soft_money value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGft_soft_money(): ?float
    {
        return $this->gft_soft_money ?? null;
    }
    /**
     * Set gft_soft_money value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gft_soft_money
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_soft_money(?float $gft_soft_money = null): self
    {
        // validation for constraint: float
        if (!is_null($gft_soft_money) && !(is_float($gft_soft_money) || is_numeric($gft_soft_money))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gft_soft_money, true), gettype($gft_soft_money)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gft_soft_money) && mb_strlen(mb_substr((string) $gft_soft_money, false !== mb_strpos((string) $gft_soft_money, '.') ? mb_strpos((string) $gft_soft_money, '.') + 1 : mb_strlen((string) $gft_soft_money))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gft_soft_money, true), mb_strlen(mb_substr((string) $gft_soft_money, mb_strpos((string) $gft_soft_money, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gft_soft_money) && mb_strlen(preg_replace('/(\D)/', '', (string) $gft_soft_money)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gft_soft_money, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gft_soft_money))), __LINE__);
        }
        if (is_null($gft_soft_money) || (is_array($gft_soft_money) && empty($gft_soft_money))) {
            unset($this->gft_soft_money);
        } else {
            $this->gft_soft_money = $gft_soft_money;
        }
        
        return $this;
    }
    /**
     * Get gft_recognition_customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_recognition_customer(): ?string
    {
        return $this->gft_recognition_customer ?? null;
    }
    /**
     * Set gft_recognition_customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_recognition_customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_recognition_customer(?string $gft_recognition_customer = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_recognition_customer) && !is_string($gft_recognition_customer)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_recognition_customer, true), gettype($gft_recognition_customer)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($gft_recognition_customer) && mb_strlen((string) $gft_recognition_customer) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $gft_recognition_customer)), __LINE__);
        }
        if (is_null($gft_recognition_customer) || (is_array($gft_recognition_customer) && empty($gft_recognition_customer))) {
            unset($this->gft_recognition_customer);
        } else {
            $this->gft_recognition_customer = $gft_recognition_customer;
        }
        
        return $this;
    }
    /**
     * Get gft_recognition_customer_adr_line3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_recognition_customer_adr_line3(): ?string
    {
        return $this->gft_recognition_customer_adr_line3 ?? null;
    }
    /**
     * Set gft_recognition_customer_adr_line3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_recognition_customer_adr_line3
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_recognition_customer_adr_line3(?string $gft_recognition_customer_adr_line3 = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_recognition_customer_adr_line3) && !is_string($gft_recognition_customer_adr_line3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_recognition_customer_adr_line3, true), gettype($gft_recognition_customer_adr_line3)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($gft_recognition_customer_adr_line3) && mb_strlen((string) $gft_recognition_customer_adr_line3) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $gft_recognition_customer_adr_line3)), __LINE__);
        }
        if (is_null($gft_recognition_customer_adr_line3) || (is_array($gft_recognition_customer_adr_line3) && empty($gft_recognition_customer_adr_line3))) {
            unset($this->gft_recognition_customer_adr_line3);
        } else {
            $this->gft_recognition_customer_adr_line3 = $gft_recognition_customer_adr_line3;
        }
        
        return $this;
    }
    /**
     * Get gft_recognition_customer_adr_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_recognition_customer_adr_city(): ?string
    {
        return $this->gft_recognition_customer_adr_city ?? null;
    }
    /**
     * Set gft_recognition_customer_adr_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_recognition_customer_adr_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_recognition_customer_adr_city(?string $gft_recognition_customer_adr_city = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_recognition_customer_adr_city) && !is_string($gft_recognition_customer_adr_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_recognition_customer_adr_city, true), gettype($gft_recognition_customer_adr_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($gft_recognition_customer_adr_city) && mb_strlen((string) $gft_recognition_customer_adr_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $gft_recognition_customer_adr_city)), __LINE__);
        }
        if (is_null($gft_recognition_customer_adr_city) || (is_array($gft_recognition_customer_adr_city) && empty($gft_recognition_customer_adr_city))) {
            unset($this->gft_recognition_customer_adr_city);
        } else {
            $this->gft_recognition_customer_adr_city = $gft_recognition_customer_adr_city;
        }
        
        return $this;
    }
    /**
     * Get gft_recognition_customer_adr_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_recognition_customer_adr_state(): ?string
    {
        return $this->gft_recognition_customer_adr_state ?? null;
    }
    /**
     * Set gft_recognition_customer_adr_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_recognition_customer_adr_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_recognition_customer_adr_state(?string $gft_recognition_customer_adr_state = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_recognition_customer_adr_state) && !is_string($gft_recognition_customer_adr_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_recognition_customer_adr_state, true), gettype($gft_recognition_customer_adr_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($gft_recognition_customer_adr_state) && mb_strlen((string) $gft_recognition_customer_adr_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $gft_recognition_customer_adr_state)), __LINE__);
        }
        if (is_null($gft_recognition_customer_adr_state) || (is_array($gft_recognition_customer_adr_state) && empty($gft_recognition_customer_adr_state))) {
            unset($this->gft_recognition_customer_adr_state);
        } else {
            $this->gft_recognition_customer_adr_state = $gft_recognition_customer_adr_state;
        }
        
        return $this;
    }
    /**
     * Get gft_recognition_customer_adr_post_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_recognition_customer_adr_post_code(): ?string
    {
        return $this->gft_recognition_customer_adr_post_code ?? null;
    }
    /**
     * Set gft_recognition_customer_adr_post_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_recognition_customer_adr_post_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_recognition_customer_adr_post_code(?string $gft_recognition_customer_adr_post_code = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_recognition_customer_adr_post_code) && !is_string($gft_recognition_customer_adr_post_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_recognition_customer_adr_post_code, true), gettype($gft_recognition_customer_adr_post_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($gft_recognition_customer_adr_post_code) && mb_strlen((string) $gft_recognition_customer_adr_post_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $gft_recognition_customer_adr_post_code)), __LINE__);
        }
        if (is_null($gft_recognition_customer_adr_post_code) || (is_array($gft_recognition_customer_adr_post_code) && empty($gft_recognition_customer_adr_post_code))) {
            unset($this->gft_recognition_customer_adr_post_code);
        } else {
            $this->gft_recognition_customer_adr_post_code = $gft_recognition_customer_adr_post_code;
        }
        
        return $this;
    }
    /**
     * Get gft_recognition_customer_adr_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_recognition_customer_adr_country(): ?string
    {
        return $this->gft_recognition_customer_adr_country ?? null;
    }
    /**
     * Set gft_recognition_customer_adr_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_recognition_customer_adr_country
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_recognition_customer_adr_country(?string $gft_recognition_customer_adr_country = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_recognition_customer_adr_country) && !is_string($gft_recognition_customer_adr_country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_recognition_customer_adr_country, true), gettype($gft_recognition_customer_adr_country)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($gft_recognition_customer_adr_country) && mb_strlen((string) $gft_recognition_customer_adr_country) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $gft_recognition_customer_adr_country)), __LINE__);
        }
        if (is_null($gft_recognition_customer_adr_country) || (is_array($gft_recognition_customer_adr_country) && empty($gft_recognition_customer_adr_country))) {
            unset($this->gft_recognition_customer_adr_country);
        } else {
            $this->gft_recognition_customer_adr_country = $gft_recognition_customer_adr_country;
        }
        
        return $this;
    }
    /**
     * Get gft_plg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_plg_key(): ?string
    {
        return $this->gft_plg_key ?? null;
    }
    /**
     * Set gft_plg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_plg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_plg_key(?string $gft_plg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_plg_key) && !is_string($gft_plg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_plg_key, true), gettype($gft_plg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_plg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_plg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_plg_key, true)), __LINE__);
        }
        if (is_null($gft_plg_key) || (is_array($gft_plg_key) && empty($gft_plg_key))) {
            unset($this->gft_plg_key);
        } else {
            $this->gft_plg_key = $gft_plg_key;
        }
        
        return $this;
    }
    /**
     * Get gft_transfer_from_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_transfer_from_gft_key(): ?string
    {
        return $this->gft_transfer_from_gft_key ?? null;
    }
    /**
     * Set gft_transfer_from_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_transfer_from_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_transfer_from_gft_key(?string $gft_transfer_from_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_transfer_from_gft_key) && !is_string($gft_transfer_from_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_transfer_from_gft_key, true), gettype($gft_transfer_from_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_transfer_from_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_transfer_from_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_transfer_from_gft_key, true)), __LINE__);
        }
        if (is_null($gft_transfer_from_gft_key) || (is_array($gft_transfer_from_gft_key) && empty($gft_transfer_from_gft_key))) {
            unset($this->gft_transfer_from_gft_key);
        } else {
            $this->gft_transfer_from_gft_key = $gft_transfer_from_gft_key;
        }
        
        return $this;
    }
    /**
     * Get gft_sct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_sct_key(): ?string
    {
        return $this->gft_sct_key ?? null;
    }
    /**
     * Set gft_sct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_sct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_sct_key(?string $gft_sct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_sct_key) && !is_string($gft_sct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_sct_key, true), gettype($gft_sct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_sct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_sct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_sct_key, true)), __LINE__);
        }
        if (is_null($gft_sct_key) || (is_array($gft_sct_key) && empty($gft_sct_key))) {
            unset($this->gft_sct_key);
        } else {
            $this->gft_sct_key = $gft_sct_key;
        }
        
        return $this;
    }
    /**
     * Get gft_liquidation_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGft_liquidation_amount(): ?float
    {
        return $this->gft_liquidation_amount ?? null;
    }
    /**
     * Set gft_liquidation_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gft_liquidation_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_liquidation_amount(?float $gft_liquidation_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($gft_liquidation_amount) && !(is_float($gft_liquidation_amount) || is_numeric($gft_liquidation_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gft_liquidation_amount, true), gettype($gft_liquidation_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gft_liquidation_amount) && mb_strlen(mb_substr((string) $gft_liquidation_amount, false !== mb_strpos((string) $gft_liquidation_amount, '.') ? mb_strpos((string) $gft_liquidation_amount, '.') + 1 : mb_strlen((string) $gft_liquidation_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gft_liquidation_amount, true), mb_strlen(mb_substr((string) $gft_liquidation_amount, mb_strpos((string) $gft_liquidation_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gft_liquidation_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $gft_liquidation_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gft_liquidation_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gft_liquidation_amount))), __LINE__);
        }
        if (is_null($gft_liquidation_amount) || (is_array($gft_liquidation_amount) && empty($gft_liquidation_amount))) {
            unset($this->gft_liquidation_amount);
        } else {
            $this->gft_liquidation_amount = $gft_liquidation_amount;
        }
        
        return $this;
    }
    /**
     * Get gft_clg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_clg_key(): ?string
    {
        return $this->gft_clg_key ?? null;
    }
    /**
     * Set gft_clg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_clg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_clg_key(?string $gft_clg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_clg_key) && !is_string($gft_clg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_clg_key, true), gettype($gft_clg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_clg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_clg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_clg_key, true)), __LINE__);
        }
        if (is_null($gft_clg_key) || (is_array($gft_clg_key) && empty($gft_clg_key))) {
            unset($this->gft_clg_key);
        } else {
            $this->gft_clg_key = $gft_clg_key;
        }
        
        return $this;
    }
    /**
     * Get gft_other_match_program value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_other_match_program(): ?string
    {
        return $this->gft_other_match_program ?? null;
    }
    /**
     * Set gft_other_match_program value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_other_match_program
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_other_match_program(?string $gft_other_match_program = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_other_match_program) && !is_string($gft_other_match_program)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_other_match_program, true), gettype($gft_other_match_program)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($gft_other_match_program) && mb_strlen((string) $gft_other_match_program) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $gft_other_match_program)), __LINE__);
        }
        if (is_null($gft_other_match_program) || (is_array($gft_other_match_program) && empty($gft_other_match_program))) {
            unset($this->gft_other_match_program);
        } else {
            $this->gft_other_match_program = $gft_other_match_program;
        }
        
        return $this;
    }
    /**
     * Get gft_form_complete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_form_complete_flag(): ?string
    {
        return $this->gft_form_complete_flag ?? null;
    }
    /**
     * Set gft_form_complete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_form_complete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_form_complete_flag(?string $gft_form_complete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_form_complete_flag) && !is_string($gft_form_complete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_form_complete_flag, true), gettype($gft_form_complete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gft_form_complete_flag) && $gft_form_complete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gft_form_complete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gft_form_complete_flag) && $gft_form_complete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gft_form_complete_flag, true)), __LINE__);
        }
        if (is_null($gft_form_complete_flag) || (is_array($gft_form_complete_flag) && empty($gft_form_complete_flag))) {
            unset($this->gft_form_complete_flag);
        } else {
            $this->gft_form_complete_flag = $gft_form_complete_flag;
        }
        
        return $this;
    }
    /**
     * Get gft_date_sent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_date_sent(): ?string
    {
        return $this->gft_date_sent ?? null;
    }
    /**
     * Set gft_date_sent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_date_sent
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_date_sent(?string $gft_date_sent = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_date_sent) && !is_string($gft_date_sent)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_date_sent, true), gettype($gft_date_sent)), __LINE__);
        }
        if (is_null($gft_date_sent) || (is_array($gft_date_sent) && empty($gft_date_sent))) {
            unset($this->gft_date_sent);
        } else {
            $this->gft_date_sent = $gft_date_sent;
        }
        
        return $this;
    }
    /**
     * Get gft_date_received value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_date_received(): ?string
    {
        return $this->gft_date_received ?? null;
    }
    /**
     * Set gft_date_received value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_date_received
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_date_received(?string $gft_date_received = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_date_received) && !is_string($gft_date_received)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_date_received, true), gettype($gft_date_received)), __LINE__);
        }
        if (is_null($gft_date_received) || (is_array($gft_date_received) && empty($gft_date_received))) {
            unset($this->gft_date_received);
        } else {
            $this->gft_date_received = $gft_date_received;
        }
        
        return $this;
    }
    /**
     * Get gft_solicitor_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_solicitor_cst_key(): ?string
    {
        return $this->gft_solicitor_cst_key ?? null;
    }
    /**
     * Set gft_solicitor_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_solicitor_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_solicitor_cst_key(?string $gft_solicitor_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_solicitor_cst_key) && !is_string($gft_solicitor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_solicitor_cst_key, true), gettype($gft_solicitor_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_solicitor_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_solicitor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_solicitor_cst_key, true)), __LINE__);
        }
        if (is_null($gft_solicitor_cst_key) || (is_array($gft_solicitor_cst_key) && empty($gft_solicitor_cst_key))) {
            unset($this->gft_solicitor_cst_key);
        } else {
            $this->gft_solicitor_cst_key = $gft_solicitor_cst_key;
        }
        
        return $this;
    }
    /**
     * Get gft_ticker value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_ticker(): ?string
    {
        return $this->gft_ticker ?? null;
    }
    /**
     * Set gft_ticker value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_ticker
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_ticker(?string $gft_ticker = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_ticker) && !is_string($gft_ticker)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_ticker, true), gettype($gft_ticker)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($gft_ticker) && mb_strlen((string) $gft_ticker) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $gft_ticker)), __LINE__);
        }
        if (is_null($gft_ticker) || (is_array($gft_ticker) && empty($gft_ticker))) {
            unset($this->gft_ticker);
        } else {
            $this->gft_ticker = $gft_ticker;
        }
        
        return $this;
    }
    /**
     * Get gft_acknowledgment_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_acknowledgment_date(): ?string
    {
        return $this->gft_acknowledgment_date ?? null;
    }
    /**
     * Set gft_acknowledgment_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_acknowledgment_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_acknowledgment_date(?string $gft_acknowledgment_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_acknowledgment_date) && !is_string($gft_acknowledgment_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_acknowledgment_date, true), gettype($gft_acknowledgment_date)), __LINE__);
        }
        if (is_null($gft_acknowledgment_date) || (is_array($gft_acknowledgment_date) && empty($gft_acknowledgment_date))) {
            unset($this->gft_acknowledgment_date);
        } else {
            $this->gft_acknowledgment_date = $gft_acknowledgment_date;
        }
        
        return $this;
    }
    /**
     * Get gft_batch_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_batch_code(): ?string
    {
        return $this->gft_batch_code ?? null;
    }
    /**
     * Set gft_batch_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_batch_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_batch_code(?string $gft_batch_code = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_batch_code) && !is_string($gft_batch_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_batch_code, true), gettype($gft_batch_code)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($gft_batch_code) && mb_strlen((string) $gft_batch_code) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $gft_batch_code)), __LINE__);
        }
        if (is_null($gft_batch_code) || (is_array($gft_batch_code) && empty($gft_batch_code))) {
            unset($this->gft_batch_code);
        } else {
            $this->gft_batch_code = $gft_batch_code;
        }
        
        return $this;
    }
    /**
     * Get gft_mail_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_mail_flag(): ?string
    {
        return $this->gft_mail_flag ?? null;
    }
    /**
     * Set gft_mail_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_mail_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_mail_flag(?string $gft_mail_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_mail_flag) && !is_string($gft_mail_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_mail_flag, true), gettype($gft_mail_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gft_mail_flag) && $gft_mail_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gft_mail_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gft_mail_flag) && $gft_mail_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gft_mail_flag, true)), __LINE__);
        }
        if (is_null($gft_mail_flag) || (is_array($gft_mail_flag) && empty($gft_mail_flag))) {
            unset($this->gft_mail_flag);
        } else {
            $this->gft_mail_flag = $gft_mail_flag;
        }
        
        return $this;
    }
    /**
     * Get gft_recognize_as value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_recognize_as(): ?string
    {
        return $this->gft_recognize_as ?? null;
    }
    /**
     * Set gft_recognize_as value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_recognize_as
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_recognize_as(?string $gft_recognize_as = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_recognize_as) && !is_string($gft_recognize_as)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_recognize_as, true), gettype($gft_recognize_as)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($gft_recognize_as) && mb_strlen((string) $gft_recognize_as) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $gft_recognize_as)), __LINE__);
        }
        if (is_null($gft_recognize_as) || (is_array($gft_recognize_as) && empty($gft_recognize_as))) {
            unset($this->gft_recognize_as);
        } else {
            $this->gft_recognize_as = $gft_recognize_as;
        }
        
        return $this;
    }
    /**
     * Get gft_liquidation_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_liquidation_date(): ?string
    {
        return $this->gft_liquidation_date ?? null;
    }
    /**
     * Set gft_liquidation_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_liquidation_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_liquidation_date(?string $gft_liquidation_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_liquidation_date) && !is_string($gft_liquidation_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_liquidation_date, true), gettype($gft_liquidation_date)), __LINE__);
        }
        if (is_null($gft_liquidation_date) || (is_array($gft_liquidation_date) && empty($gft_liquidation_date))) {
            unset($this->gft_liquidation_date);
        } else {
            $this->gft_liquidation_date = $gft_liquidation_date;
        }
        
        return $this;
    }
    /**
     * Get gft_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_src_key(): ?string
    {
        return $this->gft_src_key ?? null;
    }
    /**
     * Set gft_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_src_key(?string $gft_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_src_key) && !is_string($gft_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_src_key, true), gettype($gft_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_src_key, true)), __LINE__);
        }
        if (is_null($gft_src_key) || (is_array($gft_src_key) && empty($gft_src_key))) {
            unset($this->gft_src_key);
        } else {
            $this->gft_src_key = $gft_src_key;
        }
        
        return $this;
    }
    /**
     * Get gft_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_reg_key(): ?string
    {
        return $this->gft_reg_key ?? null;
    }
    /**
     * Set gft_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_reg_key(?string $gft_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_reg_key) && !is_string($gft_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_reg_key, true), gettype($gft_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_reg_key, true)), __LINE__);
        }
        if (is_null($gft_reg_key) || (is_array($gft_reg_key) && empty($gft_reg_key))) {
            unset($this->gft_reg_key);
        } else {
            $this->gft_reg_key = $gft_reg_key;
        }
        
        return $this;
    }
    /**
     * Get gft_tax_receipt_sent_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_tax_receipt_sent_date(): ?string
    {
        return $this->gft_tax_receipt_sent_date ?? null;
    }
    /**
     * Set gft_tax_receipt_sent_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_tax_receipt_sent_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_tax_receipt_sent_date(?string $gft_tax_receipt_sent_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_tax_receipt_sent_date) && !is_string($gft_tax_receipt_sent_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_tax_receipt_sent_date, true), gettype($gft_tax_receipt_sent_date)), __LINE__);
        }
        if (is_null($gft_tax_receipt_sent_date) || (is_array($gft_tax_receipt_sent_date) && empty($gft_tax_receipt_sent_date))) {
            unset($this->gft_tax_receipt_sent_date);
        } else {
            $this->gft_tax_receipt_sent_date = $gft_tax_receipt_sent_date;
        }
        
        return $this;
    }
    /**
     * Get gft_tbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_tbt_key(): ?string
    {
        return $this->gft_tbt_key ?? null;
    }
    /**
     * Set gft_tbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_tbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_tbt_key(?string $gft_tbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_tbt_key) && !is_string($gft_tbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_tbt_key, true), gettype($gft_tbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_tbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_tbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_tbt_key, true)), __LINE__);
        }
        if (is_null($gft_tbt_key) || (is_array($gft_tbt_key) && empty($gft_tbt_key))) {
            unset($this->gft_tbt_key);
        } else {
            $this->gft_tbt_key = $gft_tbt_key;
        }
        
        return $this;
    }
    /**
     * Get gft_personal_message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_personal_message(): ?string
    {
        return $this->gft_personal_message ?? null;
    }
    /**
     * Set gft_personal_message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_personal_message
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_personal_message(?string $gft_personal_message = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_personal_message) && !is_string($gft_personal_message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_personal_message, true), gettype($gft_personal_message)), __LINE__);
        }
        if (is_null($gft_personal_message) || (is_array($gft_personal_message) && empty($gft_personal_message))) {
            unset($this->gft_personal_message);
        } else {
            $this->gft_personal_message = $gft_personal_message;
        }
        
        return $this;
    }
    /**
     * Get gft_dnr_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_dnr_cst_key(): ?string
    {
        return $this->gft_dnr_cst_key ?? null;
    }
    /**
     * Set gft_dnr_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_dnr_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_dnr_cst_key(?string $gft_dnr_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_dnr_cst_key) && !is_string($gft_dnr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_dnr_cst_key, true), gettype($gft_dnr_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_dnr_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_dnr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_dnr_cst_key, true)), __LINE__);
        }
        if (is_null($gft_dnr_cst_key) || (is_array($gft_dnr_cst_key) && empty($gft_dnr_cst_key))) {
            unset($this->gft_dnr_cst_key);
        } else {
            $this->gft_dnr_cst_key = $gft_dnr_cst_key;
        }
        
        return $this;
    }
    /**
     * Get gft_property_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_property_name(): ?string
    {
        return $this->gft_property_name ?? null;
    }
    /**
     * Set gft_property_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_property_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_property_name(?string $gft_property_name = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_property_name) && !is_string($gft_property_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_property_name, true), gettype($gft_property_name)), __LINE__);
        }
        if (is_null($gft_property_name) || (is_array($gft_property_name) && empty($gft_property_name))) {
            unset($this->gft_property_name);
        } else {
            $this->gft_property_name = $gft_property_name;
        }
        
        return $this;
    }
    /**
     * Get gft_related_gift_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_related_gift_key(): ?string
    {
        return $this->gft_related_gift_key ?? null;
    }
    /**
     * Set gft_related_gift_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_related_gift_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_related_gift_key(?string $gft_related_gift_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_related_gift_key) && !is_string($gft_related_gift_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_related_gift_key, true), gettype($gft_related_gift_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gft_related_gift_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gft_related_gift_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gft_related_gift_key, true)), __LINE__);
        }
        if (is_null($gft_related_gift_key) || (is_array($gft_related_gift_key) && empty($gft_related_gift_key))) {
            unset($this->gft_related_gift_key);
        } else {
            $this->gft_related_gift_key = $gft_related_gift_key;
        }
        
        return $this;
    }
    /**
     * Get gft_update_funds_raised_pending_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_update_funds_raised_pending_flag(): ?string
    {
        return $this->gft_update_funds_raised_pending_flag ?? null;
    }
    /**
     * Set gft_update_funds_raised_pending_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_update_funds_raised_pending_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_update_funds_raised_pending_flag(?string $gft_update_funds_raised_pending_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_update_funds_raised_pending_flag) && !is_string($gft_update_funds_raised_pending_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_update_funds_raised_pending_flag, true), gettype($gft_update_funds_raised_pending_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gft_update_funds_raised_pending_flag) && $gft_update_funds_raised_pending_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gft_update_funds_raised_pending_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gft_update_funds_raised_pending_flag) && $gft_update_funds_raised_pending_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gft_update_funds_raised_pending_flag, true)), __LINE__);
        }
        if (is_null($gft_update_funds_raised_pending_flag) || (is_array($gft_update_funds_raised_pending_flag) && empty($gft_update_funds_raised_pending_flag))) {
            unset($this->gft_update_funds_raised_pending_flag);
        } else {
            $this->gft_update_funds_raised_pending_flag = $gft_update_funds_raised_pending_flag;
        }
        
        return $this;
    }
    /**
     * Get gft_receipt_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGft_receipt_status(): ?string
    {
        return $this->gft_receipt_status ?? null;
    }
    /**
     * Set gft_receipt_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gft_receipt_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_receipt_status(?string $gft_receipt_status = null): self
    {
        // validation for constraint: string
        if (!is_null($gft_receipt_status) && !is_string($gft_receipt_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gft_receipt_status, true), gettype($gft_receipt_status)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($gft_receipt_status) && mb_strlen((string) $gft_receipt_status) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $gft_receipt_status)), __LINE__);
        }
        if (is_null($gft_receipt_status) || (is_array($gft_receipt_status) && empty($gft_receipt_status))) {
            unset($this->gft_receipt_status);
        } else {
            $this->gft_receipt_status = $gft_receipt_status;
        }
        
        return $this;
    }
    /**
     * Get gft_stock_high value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGft_stock_high(): ?float
    {
        return $this->gft_stock_high ?? null;
    }
    /**
     * Set gft_stock_high value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gft_stock_high
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_stock_high(?float $gft_stock_high = null): self
    {
        // validation for constraint: float
        if (!is_null($gft_stock_high) && !(is_float($gft_stock_high) || is_numeric($gft_stock_high))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gft_stock_high, true), gettype($gft_stock_high)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gft_stock_high) && mb_strlen(mb_substr((string) $gft_stock_high, false !== mb_strpos((string) $gft_stock_high, '.') ? mb_strpos((string) $gft_stock_high, '.') + 1 : mb_strlen((string) $gft_stock_high))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gft_stock_high, true), mb_strlen(mb_substr((string) $gft_stock_high, mb_strpos((string) $gft_stock_high, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gft_stock_high) && mb_strlen(preg_replace('/(\D)/', '', (string) $gft_stock_high)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gft_stock_high, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gft_stock_high))), __LINE__);
        }
        if (is_null($gft_stock_high) || (is_array($gft_stock_high) && empty($gft_stock_high))) {
            unset($this->gft_stock_high);
        } else {
            $this->gft_stock_high = $gft_stock_high;
        }
        
        return $this;
    }
    /**
     * Get gft_stock_low value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGft_stock_low(): ?float
    {
        return $this->gft_stock_low ?? null;
    }
    /**
     * Set gft_stock_low value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gft_stock_low
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Gift_DataObjectType
     */
    public function setGft_stock_low(?float $gft_stock_low = null): self
    {
        // validation for constraint: float
        if (!is_null($gft_stock_low) && !(is_float($gft_stock_low) || is_numeric($gft_stock_low))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gft_stock_low, true), gettype($gft_stock_low)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gft_stock_low) && mb_strlen(mb_substr((string) $gft_stock_low, false !== mb_strpos((string) $gft_stock_low, '.') ? mb_strpos((string) $gft_stock_low, '.') + 1 : mb_strlen((string) $gft_stock_low))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gft_stock_low, true), mb_strlen(mb_substr((string) $gft_stock_low, mb_strpos((string) $gft_stock_low, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gft_stock_low) && mb_strlen(preg_replace('/(\D)/', '', (string) $gft_stock_low)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gft_stock_low, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gft_stock_low))), __LINE__);
        }
        if (is_null($gft_stock_low) || (is_array($gft_stock_low) && empty($gft_stock_low))) {
            unset($this->gft_stock_low);
        } else {
            $this->gft_stock_low = $gft_stock_low;
        }
        
        return $this;
    }
}
