<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Location_Customer_Address_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Location_Customer_Address_DataObjectType extends AbstractStructBase
{
    /**
     * The cx2__cxa_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx2__cxa_cst_key = null;
    /**
     * The cx2__cxa_adr_key
     * Meta information extracted from the WSDL
     * - documentation: Address Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx2__cxa_adr_key = null;
    /**
     * The cx2__cxa_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_add_date = null;
    /**
     * The cx2__cxa_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_add_user = null;
    /**
     * The cx2__cxa_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_change_date = null;
    /**
     * The cx2__cxa_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_change_user = null;
    /**
     * The cx2__cxa_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_delete_flag = null;
    /**
     * The cx2__cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx2__cxa_key = null;
    /**
     * The cx2__cxa_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx2__cxa_key_ext = null;
    /**
     * The cx2__cxa_on_hold_flag
     * Meta information extracted from the WSDL
     * - documentation: Address On Hold Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_on_hold_flag = null;
    /**
     * The cx2__cxa_adh_key
     * Meta information extracted from the WSDL
     * - documentation: On Hold Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx2__cxa_adh_key = null;
    /**
     * The cx2__cxa_adt_key
     * Meta information extracted from the WSDL
     * - documentation: Address Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx2__cxa_adt_key = null;
    /**
     * The cx2__cxa_seasonal_from_date
     * Meta information extracted from the WSDL
     * - documentation: Seasonal From Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_seasonal_from_date = null;
    /**
     * The cx2__cxa_mailing_label
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_mailing_label = null;
    /**
     * The cx2__cxa_seasonal_through_date
     * Meta information extracted from the WSDL
     * - documentation: Seasonal Through Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_seasonal_through_date = null;
    /**
     * The cx2__cxa_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx2__cxa_entity_key = null;
    /**
     * The cx2__cxa_mail_stop
     * Meta information extracted from the WSDL
     * - documentation: Mailstop. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_mail_stop = null;
    /**
     * The cx2__cxa_mailing_label_html
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label HTML. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_mailing_label_html = null;
    /**
     * The cx2__cxa_on_hold_from
     * Meta information extracted from the WSDL
     * - documentation: Hold From. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_on_hold_from = null;
    /**
     * The cx2__cxa_on_hold_through
     * Meta information extracted from the WSDL
     * - documentation: On Hold Until Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx2__cxa_on_hold_through = null;
    /**
     * Constructor method for EventsRegistrant_Location_Customer_Address_DataObjectType
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_cst_key()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_adr_key()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_add_date()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_add_user()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_change_date()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_change_user()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_delete_flag()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_key()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_key_ext()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_on_hold_flag()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_adh_key()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_adt_key()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_seasonal_from_date()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_mailing_label()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_seasonal_through_date()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_entity_key()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_mail_stop()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_mailing_label_html()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_on_hold_from()
     * @uses EventsRegistrant_Location_Customer_Address_DataObjectType::setCx2__cxa_on_hold_through()
     * @param string $cx2__cxa_cst_key
     * @param string $cx2__cxa_adr_key
     * @param string $cx2__cxa_add_date
     * @param string $cx2__cxa_add_user
     * @param string $cx2__cxa_change_date
     * @param string $cx2__cxa_change_user
     * @param string $cx2__cxa_delete_flag
     * @param string $cx2__cxa_key
     * @param string $cx2__cxa_key_ext
     * @param string $cx2__cxa_on_hold_flag
     * @param string $cx2__cxa_adh_key
     * @param string $cx2__cxa_adt_key
     * @param string $cx2__cxa_seasonal_from_date
     * @param string $cx2__cxa_mailing_label
     * @param string $cx2__cxa_seasonal_through_date
     * @param string $cx2__cxa_entity_key
     * @param string $cx2__cxa_mail_stop
     * @param string $cx2__cxa_mailing_label_html
     * @param string $cx2__cxa_on_hold_from
     * @param string $cx2__cxa_on_hold_through
     */
    public function __construct(?string $cx2__cxa_cst_key = null, ?string $cx2__cxa_adr_key = null, ?string $cx2__cxa_add_date = null, ?string $cx2__cxa_add_user = null, ?string $cx2__cxa_change_date = null, ?string $cx2__cxa_change_user = null, ?string $cx2__cxa_delete_flag = null, ?string $cx2__cxa_key = null, ?string $cx2__cxa_key_ext = null, ?string $cx2__cxa_on_hold_flag = null, ?string $cx2__cxa_adh_key = null, ?string $cx2__cxa_adt_key = null, ?string $cx2__cxa_seasonal_from_date = null, ?string $cx2__cxa_mailing_label = null, ?string $cx2__cxa_seasonal_through_date = null, ?string $cx2__cxa_entity_key = null, ?string $cx2__cxa_mail_stop = null, ?string $cx2__cxa_mailing_label_html = null, ?string $cx2__cxa_on_hold_from = null, ?string $cx2__cxa_on_hold_through = null)
    {
        $this
            ->setCx2__cxa_cst_key($cx2__cxa_cst_key)
            ->setCx2__cxa_adr_key($cx2__cxa_adr_key)
            ->setCx2__cxa_add_date($cx2__cxa_add_date)
            ->setCx2__cxa_add_user($cx2__cxa_add_user)
            ->setCx2__cxa_change_date($cx2__cxa_change_date)
            ->setCx2__cxa_change_user($cx2__cxa_change_user)
            ->setCx2__cxa_delete_flag($cx2__cxa_delete_flag)
            ->setCx2__cxa_key($cx2__cxa_key)
            ->setCx2__cxa_key_ext($cx2__cxa_key_ext)
            ->setCx2__cxa_on_hold_flag($cx2__cxa_on_hold_flag)
            ->setCx2__cxa_adh_key($cx2__cxa_adh_key)
            ->setCx2__cxa_adt_key($cx2__cxa_adt_key)
            ->setCx2__cxa_seasonal_from_date($cx2__cxa_seasonal_from_date)
            ->setCx2__cxa_mailing_label($cx2__cxa_mailing_label)
            ->setCx2__cxa_seasonal_through_date($cx2__cxa_seasonal_through_date)
            ->setCx2__cxa_entity_key($cx2__cxa_entity_key)
            ->setCx2__cxa_mail_stop($cx2__cxa_mail_stop)
            ->setCx2__cxa_mailing_label_html($cx2__cxa_mailing_label_html)
            ->setCx2__cxa_on_hold_from($cx2__cxa_on_hold_from)
            ->setCx2__cxa_on_hold_through($cx2__cxa_on_hold_through);
    }
    /**
     * Get cx2__cxa_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_cst_key(): ?string
    {
        return $this->cx2__cxa_cst_key ?? null;
    }
    /**
     * Set cx2__cxa_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_cst_key(?string $cx2__cxa_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_cst_key) && !is_string($cx2__cxa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_cst_key, true), gettype($cx2__cxa_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx2__cxa_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx2__cxa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx2__cxa_cst_key, true)), __LINE__);
        }
        if (is_null($cx2__cxa_cst_key) || (is_array($cx2__cxa_cst_key) && empty($cx2__cxa_cst_key))) {
            unset($this->cx2__cxa_cst_key);
        } else {
            $this->cx2__cxa_cst_key = $cx2__cxa_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_adr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_adr_key(): ?string
    {
        return $this->cx2__cxa_adr_key ?? null;
    }
    /**
     * Set cx2__cxa_adr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_adr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_adr_key(?string $cx2__cxa_adr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_adr_key) && !is_string($cx2__cxa_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_adr_key, true), gettype($cx2__cxa_adr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx2__cxa_adr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx2__cxa_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx2__cxa_adr_key, true)), __LINE__);
        }
        if (is_null($cx2__cxa_adr_key) || (is_array($cx2__cxa_adr_key) && empty($cx2__cxa_adr_key))) {
            unset($this->cx2__cxa_adr_key);
        } else {
            $this->cx2__cxa_adr_key = $cx2__cxa_adr_key;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_add_date(): ?string
    {
        return $this->cx2__cxa_add_date ?? null;
    }
    /**
     * Set cx2__cxa_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_add_date(?string $cx2__cxa_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_add_date) && !is_string($cx2__cxa_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_add_date, true), gettype($cx2__cxa_add_date)), __LINE__);
        }
        if (is_null($cx2__cxa_add_date) || (is_array($cx2__cxa_add_date) && empty($cx2__cxa_add_date))) {
            unset($this->cx2__cxa_add_date);
        } else {
            $this->cx2__cxa_add_date = $cx2__cxa_add_date;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_add_user(): ?string
    {
        return $this->cx2__cxa_add_user ?? null;
    }
    /**
     * Set cx2__cxa_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_add_user(?string $cx2__cxa_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_add_user) && !is_string($cx2__cxa_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_add_user, true), gettype($cx2__cxa_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cx2__cxa_add_user) && mb_strlen((string) $cx2__cxa_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cx2__cxa_add_user)), __LINE__);
        }
        if (is_null($cx2__cxa_add_user) || (is_array($cx2__cxa_add_user) && empty($cx2__cxa_add_user))) {
            unset($this->cx2__cxa_add_user);
        } else {
            $this->cx2__cxa_add_user = $cx2__cxa_add_user;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_change_date(): ?string
    {
        return $this->cx2__cxa_change_date ?? null;
    }
    /**
     * Set cx2__cxa_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_change_date(?string $cx2__cxa_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_change_date) && !is_string($cx2__cxa_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_change_date, true), gettype($cx2__cxa_change_date)), __LINE__);
        }
        if (is_null($cx2__cxa_change_date) || (is_array($cx2__cxa_change_date) && empty($cx2__cxa_change_date))) {
            unset($this->cx2__cxa_change_date);
        } else {
            $this->cx2__cxa_change_date = $cx2__cxa_change_date;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_change_user(): ?string
    {
        return $this->cx2__cxa_change_user ?? null;
    }
    /**
     * Set cx2__cxa_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_change_user(?string $cx2__cxa_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_change_user) && !is_string($cx2__cxa_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_change_user, true), gettype($cx2__cxa_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cx2__cxa_change_user) && mb_strlen((string) $cx2__cxa_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cx2__cxa_change_user)), __LINE__);
        }
        if (is_null($cx2__cxa_change_user) || (is_array($cx2__cxa_change_user) && empty($cx2__cxa_change_user))) {
            unset($this->cx2__cxa_change_user);
        } else {
            $this->cx2__cxa_change_user = $cx2__cxa_change_user;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_delete_flag(): ?string
    {
        return $this->cx2__cxa_delete_flag ?? null;
    }
    /**
     * Set cx2__cxa_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_delete_flag(?string $cx2__cxa_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_delete_flag) && !is_string($cx2__cxa_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_delete_flag, true), gettype($cx2__cxa_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cx2__cxa_delete_flag) && $cx2__cxa_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cx2__cxa_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cx2__cxa_delete_flag) && $cx2__cxa_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cx2__cxa_delete_flag, true)), __LINE__);
        }
        if (is_null($cx2__cxa_delete_flag) || (is_array($cx2__cxa_delete_flag) && empty($cx2__cxa_delete_flag))) {
            unset($this->cx2__cxa_delete_flag);
        } else {
            $this->cx2__cxa_delete_flag = $cx2__cxa_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_key(): ?string
    {
        return $this->cx2__cxa_key ?? null;
    }
    /**
     * Set cx2__cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_key(?string $cx2__cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_key) && !is_string($cx2__cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_key, true), gettype($cx2__cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx2__cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx2__cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx2__cxa_key, true)), __LINE__);
        }
        if (is_null($cx2__cxa_key) || (is_array($cx2__cxa_key) && empty($cx2__cxa_key))) {
            unset($this->cx2__cxa_key);
        } else {
            $this->cx2__cxa_key = $cx2__cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_key_ext(): ?string
    {
        return $this->cx2__cxa_key_ext ?? null;
    }
    /**
     * Set cx2__cxa_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_key_ext(?string $cx2__cxa_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_key_ext) && !is_string($cx2__cxa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_key_ext, true), gettype($cx2__cxa_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx2__cxa_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx2__cxa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx2__cxa_key_ext, true)), __LINE__);
        }
        if (is_null($cx2__cxa_key_ext) || (is_array($cx2__cxa_key_ext) && empty($cx2__cxa_key_ext))) {
            unset($this->cx2__cxa_key_ext);
        } else {
            $this->cx2__cxa_key_ext = $cx2__cxa_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_on_hold_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_on_hold_flag(): ?string
    {
        return $this->cx2__cxa_on_hold_flag ?? null;
    }
    /**
     * Set cx2__cxa_on_hold_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_on_hold_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_on_hold_flag(?string $cx2__cxa_on_hold_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_on_hold_flag) && !is_string($cx2__cxa_on_hold_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_on_hold_flag, true), gettype($cx2__cxa_on_hold_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cx2__cxa_on_hold_flag) && $cx2__cxa_on_hold_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cx2__cxa_on_hold_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cx2__cxa_on_hold_flag) && $cx2__cxa_on_hold_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cx2__cxa_on_hold_flag, true)), __LINE__);
        }
        if (is_null($cx2__cxa_on_hold_flag) || (is_array($cx2__cxa_on_hold_flag) && empty($cx2__cxa_on_hold_flag))) {
            unset($this->cx2__cxa_on_hold_flag);
        } else {
            $this->cx2__cxa_on_hold_flag = $cx2__cxa_on_hold_flag;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_adh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_adh_key(): ?string
    {
        return $this->cx2__cxa_adh_key ?? null;
    }
    /**
     * Set cx2__cxa_adh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_adh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_adh_key(?string $cx2__cxa_adh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_adh_key) && !is_string($cx2__cxa_adh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_adh_key, true), gettype($cx2__cxa_adh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx2__cxa_adh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx2__cxa_adh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx2__cxa_adh_key, true)), __LINE__);
        }
        if (is_null($cx2__cxa_adh_key) || (is_array($cx2__cxa_adh_key) && empty($cx2__cxa_adh_key))) {
            unset($this->cx2__cxa_adh_key);
        } else {
            $this->cx2__cxa_adh_key = $cx2__cxa_adh_key;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_adt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_adt_key(): ?string
    {
        return $this->cx2__cxa_adt_key ?? null;
    }
    /**
     * Set cx2__cxa_adt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_adt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_adt_key(?string $cx2__cxa_adt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_adt_key) && !is_string($cx2__cxa_adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_adt_key, true), gettype($cx2__cxa_adt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx2__cxa_adt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx2__cxa_adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx2__cxa_adt_key, true)), __LINE__);
        }
        if (is_null($cx2__cxa_adt_key) || (is_array($cx2__cxa_adt_key) && empty($cx2__cxa_adt_key))) {
            unset($this->cx2__cxa_adt_key);
        } else {
            $this->cx2__cxa_adt_key = $cx2__cxa_adt_key;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_seasonal_from_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_seasonal_from_date(): ?string
    {
        return $this->cx2__cxa_seasonal_from_date ?? null;
    }
    /**
     * Set cx2__cxa_seasonal_from_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_seasonal_from_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_seasonal_from_date(?string $cx2__cxa_seasonal_from_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_seasonal_from_date) && !is_string($cx2__cxa_seasonal_from_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_seasonal_from_date, true), gettype($cx2__cxa_seasonal_from_date)), __LINE__);
        }
        if (is_null($cx2__cxa_seasonal_from_date) || (is_array($cx2__cxa_seasonal_from_date) && empty($cx2__cxa_seasonal_from_date))) {
            unset($this->cx2__cxa_seasonal_from_date);
        } else {
            $this->cx2__cxa_seasonal_from_date = $cx2__cxa_seasonal_from_date;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_mailing_label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_mailing_label(): ?string
    {
        return $this->cx2__cxa_mailing_label ?? null;
    }
    /**
     * Set cx2__cxa_mailing_label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_mailing_label
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_mailing_label(?string $cx2__cxa_mailing_label = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_mailing_label) && !is_string($cx2__cxa_mailing_label)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_mailing_label, true), gettype($cx2__cxa_mailing_label)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($cx2__cxa_mailing_label) && mb_strlen((string) $cx2__cxa_mailing_label) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $cx2__cxa_mailing_label)), __LINE__);
        }
        if (is_null($cx2__cxa_mailing_label) || (is_array($cx2__cxa_mailing_label) && empty($cx2__cxa_mailing_label))) {
            unset($this->cx2__cxa_mailing_label);
        } else {
            $this->cx2__cxa_mailing_label = $cx2__cxa_mailing_label;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_seasonal_through_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_seasonal_through_date(): ?string
    {
        return $this->cx2__cxa_seasonal_through_date ?? null;
    }
    /**
     * Set cx2__cxa_seasonal_through_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_seasonal_through_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_seasonal_through_date(?string $cx2__cxa_seasonal_through_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_seasonal_through_date) && !is_string($cx2__cxa_seasonal_through_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_seasonal_through_date, true), gettype($cx2__cxa_seasonal_through_date)), __LINE__);
        }
        if (is_null($cx2__cxa_seasonal_through_date) || (is_array($cx2__cxa_seasonal_through_date) && empty($cx2__cxa_seasonal_through_date))) {
            unset($this->cx2__cxa_seasonal_through_date);
        } else {
            $this->cx2__cxa_seasonal_through_date = $cx2__cxa_seasonal_through_date;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_entity_key(): ?string
    {
        return $this->cx2__cxa_entity_key ?? null;
    }
    /**
     * Set cx2__cxa_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_entity_key(?string $cx2__cxa_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_entity_key) && !is_string($cx2__cxa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_entity_key, true), gettype($cx2__cxa_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx2__cxa_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx2__cxa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx2__cxa_entity_key, true)), __LINE__);
        }
        if (is_null($cx2__cxa_entity_key) || (is_array($cx2__cxa_entity_key) && empty($cx2__cxa_entity_key))) {
            unset($this->cx2__cxa_entity_key);
        } else {
            $this->cx2__cxa_entity_key = $cx2__cxa_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_mail_stop value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_mail_stop(): ?string
    {
        return $this->cx2__cxa_mail_stop ?? null;
    }
    /**
     * Set cx2__cxa_mail_stop value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_mail_stop
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_mail_stop(?string $cx2__cxa_mail_stop = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_mail_stop) && !is_string($cx2__cxa_mail_stop)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_mail_stop, true), gettype($cx2__cxa_mail_stop)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cx2__cxa_mail_stop) && mb_strlen((string) $cx2__cxa_mail_stop) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cx2__cxa_mail_stop)), __LINE__);
        }
        if (is_null($cx2__cxa_mail_stop) || (is_array($cx2__cxa_mail_stop) && empty($cx2__cxa_mail_stop))) {
            unset($this->cx2__cxa_mail_stop);
        } else {
            $this->cx2__cxa_mail_stop = $cx2__cxa_mail_stop;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_mailing_label_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_mailing_label_html(): ?string
    {
        return $this->cx2__cxa_mailing_label_html ?? null;
    }
    /**
     * Set cx2__cxa_mailing_label_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_mailing_label_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_mailing_label_html(?string $cx2__cxa_mailing_label_html = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_mailing_label_html) && !is_string($cx2__cxa_mailing_label_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_mailing_label_html, true), gettype($cx2__cxa_mailing_label_html)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($cx2__cxa_mailing_label_html) && mb_strlen((string) $cx2__cxa_mailing_label_html) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $cx2__cxa_mailing_label_html)), __LINE__);
        }
        if (is_null($cx2__cxa_mailing_label_html) || (is_array($cx2__cxa_mailing_label_html) && empty($cx2__cxa_mailing_label_html))) {
            unset($this->cx2__cxa_mailing_label_html);
        } else {
            $this->cx2__cxa_mailing_label_html = $cx2__cxa_mailing_label_html;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_on_hold_from value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_on_hold_from(): ?string
    {
        return $this->cx2__cxa_on_hold_from ?? null;
    }
    /**
     * Set cx2__cxa_on_hold_from value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_on_hold_from
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_on_hold_from(?string $cx2__cxa_on_hold_from = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_on_hold_from) && !is_string($cx2__cxa_on_hold_from)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_on_hold_from, true), gettype($cx2__cxa_on_hold_from)), __LINE__);
        }
        if (is_null($cx2__cxa_on_hold_from) || (is_array($cx2__cxa_on_hold_from) && empty($cx2__cxa_on_hold_from))) {
            unset($this->cx2__cxa_on_hold_from);
        } else {
            $this->cx2__cxa_on_hold_from = $cx2__cxa_on_hold_from;
        }
        
        return $this;
    }
    /**
     * Get cx2__cxa_on_hold_through value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx2__cxa_on_hold_through(): ?string
    {
        return $this->cx2__cxa_on_hold_through ?? null;
    }
    /**
     * Set cx2__cxa_on_hold_through value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx2__cxa_on_hold_through
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Customer_Address_DataObjectType
     */
    public function setCx2__cxa_on_hold_through(?string $cx2__cxa_on_hold_through = null): self
    {
        // validation for constraint: string
        if (!is_null($cx2__cxa_on_hold_through) && !is_string($cx2__cxa_on_hold_through)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx2__cxa_on_hold_through, true), gettype($cx2__cxa_on_hold_through)), __LINE__);
        }
        if (is_null($cx2__cxa_on_hold_through) || (is_array($cx2__cxa_on_hold_through) && empty($cx2__cxa_on_hold_through))) {
            unset($this->cx2__cxa_on_hold_through);
        } else {
            $this->cx2__cxa_on_hold_through = $cx2__cxa_on_hold_through;
        }
        
        return $this;
    }
}
