<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Location_Website_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Location_Website_DataObjectType extends AbstractStructBase
{
    /**
     * The ur2__url_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ur2__url_key = null;
    /**
     * The ur2__url_code
     * Meta information extracted from the WSDL
     * - documentation: Website Url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 400
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ur2__url_code = null;
    /**
     * The ur2__url_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ur2__url_cst_key = null;
    /**
     * The ur2__url_type
     * Meta information extracted from the WSDL
     * - documentation: Website Type.This element has a default value of 'internet'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ur2__url_type = null;
    /**
     * The ur2__url_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ur2__url_add_user = null;
    /**
     * The ur2__url_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ur2__url_add_date = null;
    /**
     * The ur2__url_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ur2__url_change_user = null;
    /**
     * The ur2__url_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ur2__url_change_date = null;
    /**
     * The ur2__url_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ur2__url_delete_flag = null;
    /**
     * The ur2__url_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ur2__url_key_ext = null;
    /**
     * The ur2__url_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ur2__url_entity_key = null;
    /**
     * Constructor method for EventsRegistrant_Location_Website_DataObjectType
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_key()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_code()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_cst_key()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_type()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_add_user()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_add_date()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_change_user()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_change_date()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_delete_flag()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_key_ext()
     * @uses EventsRegistrant_Location_Website_DataObjectType::setUr2__url_entity_key()
     * @param string $ur2__url_key
     * @param string $ur2__url_code
     * @param string $ur2__url_cst_key
     * @param string $ur2__url_type
     * @param string $ur2__url_add_user
     * @param string $ur2__url_add_date
     * @param string $ur2__url_change_user
     * @param string $ur2__url_change_date
     * @param string $ur2__url_delete_flag
     * @param string $ur2__url_key_ext
     * @param string $ur2__url_entity_key
     */
    public function __construct(?string $ur2__url_key = null, ?string $ur2__url_code = null, ?string $ur2__url_cst_key = null, ?string $ur2__url_type = null, ?string $ur2__url_add_user = null, ?string $ur2__url_add_date = null, ?string $ur2__url_change_user = null, ?string $ur2__url_change_date = null, ?string $ur2__url_delete_flag = null, ?string $ur2__url_key_ext = null, ?string $ur2__url_entity_key = null)
    {
        $this
            ->setUr2__url_key($ur2__url_key)
            ->setUr2__url_code($ur2__url_code)
            ->setUr2__url_cst_key($ur2__url_cst_key)
            ->setUr2__url_type($ur2__url_type)
            ->setUr2__url_add_user($ur2__url_add_user)
            ->setUr2__url_add_date($ur2__url_add_date)
            ->setUr2__url_change_user($ur2__url_change_user)
            ->setUr2__url_change_date($ur2__url_change_date)
            ->setUr2__url_delete_flag($ur2__url_delete_flag)
            ->setUr2__url_key_ext($ur2__url_key_ext)
            ->setUr2__url_entity_key($ur2__url_entity_key);
    }
    /**
     * Get ur2__url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_key(): ?string
    {
        return $this->ur2__url_key ?? null;
    }
    /**
     * Set ur2__url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_key(?string $ur2__url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_key) && !is_string($ur2__url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_key, true), gettype($ur2__url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ur2__url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ur2__url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ur2__url_key, true)), __LINE__);
        }
        if (is_null($ur2__url_key) || (is_array($ur2__url_key) && empty($ur2__url_key))) {
            unset($this->ur2__url_key);
        } else {
            $this->ur2__url_key = $ur2__url_key;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_code(): ?string
    {
        return $this->ur2__url_code ?? null;
    }
    /**
     * Set ur2__url_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_code(?string $ur2__url_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_code) && !is_string($ur2__url_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_code, true), gettype($ur2__url_code)), __LINE__);
        }
        // validation for constraint: maxLength(400)
        if (!is_null($ur2__url_code) && mb_strlen((string) $ur2__url_code) > 400) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 400', mb_strlen((string) $ur2__url_code)), __LINE__);
        }
        if (is_null($ur2__url_code) || (is_array($ur2__url_code) && empty($ur2__url_code))) {
            unset($this->ur2__url_code);
        } else {
            $this->ur2__url_code = $ur2__url_code;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_cst_key(): ?string
    {
        return $this->ur2__url_cst_key ?? null;
    }
    /**
     * Set ur2__url_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_cst_key(?string $ur2__url_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_cst_key) && !is_string($ur2__url_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_cst_key, true), gettype($ur2__url_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ur2__url_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ur2__url_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ur2__url_cst_key, true)), __LINE__);
        }
        if (is_null($ur2__url_cst_key) || (is_array($ur2__url_cst_key) && empty($ur2__url_cst_key))) {
            unset($this->ur2__url_cst_key);
        } else {
            $this->ur2__url_cst_key = $ur2__url_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_type(): ?string
    {
        return $this->ur2__url_type ?? null;
    }
    /**
     * Set ur2__url_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_type(?string $ur2__url_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_type) && !is_string($ur2__url_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_type, true), gettype($ur2__url_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ur2__url_type) && mb_strlen((string) $ur2__url_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ur2__url_type)), __LINE__);
        }
        if (is_null($ur2__url_type) || (is_array($ur2__url_type) && empty($ur2__url_type))) {
            unset($this->ur2__url_type);
        } else {
            $this->ur2__url_type = $ur2__url_type;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_add_user(): ?string
    {
        return $this->ur2__url_add_user ?? null;
    }
    /**
     * Set ur2__url_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_add_user(?string $ur2__url_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_add_user) && !is_string($ur2__url_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_add_user, true), gettype($ur2__url_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ur2__url_add_user) && mb_strlen((string) $ur2__url_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ur2__url_add_user)), __LINE__);
        }
        if (is_null($ur2__url_add_user) || (is_array($ur2__url_add_user) && empty($ur2__url_add_user))) {
            unset($this->ur2__url_add_user);
        } else {
            $this->ur2__url_add_user = $ur2__url_add_user;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_add_date(): ?string
    {
        return $this->ur2__url_add_date ?? null;
    }
    /**
     * Set ur2__url_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_add_date(?string $ur2__url_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_add_date) && !is_string($ur2__url_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_add_date, true), gettype($ur2__url_add_date)), __LINE__);
        }
        if (is_null($ur2__url_add_date) || (is_array($ur2__url_add_date) && empty($ur2__url_add_date))) {
            unset($this->ur2__url_add_date);
        } else {
            $this->ur2__url_add_date = $ur2__url_add_date;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_change_user(): ?string
    {
        return $this->ur2__url_change_user ?? null;
    }
    /**
     * Set ur2__url_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_change_user(?string $ur2__url_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_change_user) && !is_string($ur2__url_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_change_user, true), gettype($ur2__url_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ur2__url_change_user) && mb_strlen((string) $ur2__url_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ur2__url_change_user)), __LINE__);
        }
        if (is_null($ur2__url_change_user) || (is_array($ur2__url_change_user) && empty($ur2__url_change_user))) {
            unset($this->ur2__url_change_user);
        } else {
            $this->ur2__url_change_user = $ur2__url_change_user;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_change_date(): ?string
    {
        return $this->ur2__url_change_date ?? null;
    }
    /**
     * Set ur2__url_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_change_date(?string $ur2__url_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_change_date) && !is_string($ur2__url_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_change_date, true), gettype($ur2__url_change_date)), __LINE__);
        }
        if (is_null($ur2__url_change_date) || (is_array($ur2__url_change_date) && empty($ur2__url_change_date))) {
            unset($this->ur2__url_change_date);
        } else {
            $this->ur2__url_change_date = $ur2__url_change_date;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_delete_flag(): ?string
    {
        return $this->ur2__url_delete_flag ?? null;
    }
    /**
     * Set ur2__url_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_delete_flag(?string $ur2__url_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_delete_flag) && !is_string($ur2__url_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_delete_flag, true), gettype($ur2__url_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ur2__url_delete_flag) && $ur2__url_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ur2__url_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ur2__url_delete_flag) && $ur2__url_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ur2__url_delete_flag, true)), __LINE__);
        }
        if (is_null($ur2__url_delete_flag) || (is_array($ur2__url_delete_flag) && empty($ur2__url_delete_flag))) {
            unset($this->ur2__url_delete_flag);
        } else {
            $this->ur2__url_delete_flag = $ur2__url_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_key_ext(): ?string
    {
        return $this->ur2__url_key_ext ?? null;
    }
    /**
     * Set ur2__url_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_key_ext(?string $ur2__url_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_key_ext) && !is_string($ur2__url_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_key_ext, true), gettype($ur2__url_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ur2__url_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ur2__url_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ur2__url_key_ext, true)), __LINE__);
        }
        if (is_null($ur2__url_key_ext) || (is_array($ur2__url_key_ext) && empty($ur2__url_key_ext))) {
            unset($this->ur2__url_key_ext);
        } else {
            $this->ur2__url_key_ext = $ur2__url_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ur2__url_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUr2__url_entity_key(): ?string
    {
        return $this->ur2__url_entity_key ?? null;
    }
    /**
     * Set ur2__url_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ur2__url_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Website_DataObjectType
     */
    public function setUr2__url_entity_key(?string $ur2__url_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ur2__url_entity_key) && !is_string($ur2__url_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ur2__url_entity_key, true), gettype($ur2__url_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ur2__url_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ur2__url_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ur2__url_entity_key, true)), __LINE__);
        }
        if (is_null($ur2__url_entity_key) || (is_array($ur2__url_entity_key) && empty($ur2__url_entity_key))) {
            unset($this->ur2__url_entity_key);
        } else {
            $this->ur2__url_entity_key = $ur2__url_entity_key;
        }
        
        return $this;
    }
}
