<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteMethod StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExecuteMethod extends AbstractStructBase
{
    /**
     * The serviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $serviceName = null;
    /**
     * The methodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $methodName = null;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters = null;
    /**
     * Constructor method for ExecuteMethod
     * @uses ExecuteMethod::setServiceName()
     * @uses ExecuteMethod::setMethodName()
     * @uses ExecuteMethod::setParameters()
     * @param string $serviceName
     * @param string $methodName
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters
     */
    public function __construct(?string $serviceName = null, ?string $methodName = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setMethodName($methodName)
            ->setParameters($parameters);
    }
    /**
     * Get serviceName value
     * @return string|null
     */
    public function getServiceName(): ?string
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExecuteMethod
     */
    public function setServiceName(?string $serviceName = null): self
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        $this->serviceName = $serviceName;
        
        return $this;
    }
    /**
     * Get methodName value
     * @return string|null
     */
    public function getMethodName(): ?string
    {
        return $this->methodName;
    }
    /**
     * Set methodName value
     * @param string $methodName
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExecuteMethod
     */
    public function setMethodName(?string $methodName = null): self
    {
        // validation for constraint: string
        if (!is_null($methodName) && !is_string($methodName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodName, true), gettype($methodName)), __LINE__);
        }
        $this->methodName = $methodName;
        
        return $this;
    }
    /**
     * Get parameters value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter|null
     */
    public function getParameters(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExecuteMethod
     */
    public function setParameters(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters = null): self
    {
        $this->parameters = $parameters;
        
        return $this;
    }
}
