<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorBoothNew_Booth_Category_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorBoothNew_Booth_Category_DataObjectType extends AbstractStructBase
{
    /**
     * The bct_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bct_key = null;
    /**
     * The bct_code
     * Meta information extracted from the WSDL
     * - documentation: code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bct_code = null;
    /**
     * The bct_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bct_add_user = null;
    /**
     * The bct_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bct_add_date = null;
    /**
     * The bct_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bct_change_user = null;
    /**
     * The bct_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bct_change_date = null;
    /**
     * The bct_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bct_delete_flag = null;
    /**
     * The bct_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bct_key_ext = null;
    /**
     * The bct_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bct_entity_key = null;
    /**
     * Constructor method for ExhibitorBoothNew_Booth_Category_DataObjectType
     * @uses ExhibitorBoothNew_Booth_Category_DataObjectType::setBct_key()
     * @uses ExhibitorBoothNew_Booth_Category_DataObjectType::setBct_code()
     * @uses ExhibitorBoothNew_Booth_Category_DataObjectType::setBct_add_user()
     * @uses ExhibitorBoothNew_Booth_Category_DataObjectType::setBct_add_date()
     * @uses ExhibitorBoothNew_Booth_Category_DataObjectType::setBct_change_user()
     * @uses ExhibitorBoothNew_Booth_Category_DataObjectType::setBct_change_date()
     * @uses ExhibitorBoothNew_Booth_Category_DataObjectType::setBct_delete_flag()
     * @uses ExhibitorBoothNew_Booth_Category_DataObjectType::setBct_key_ext()
     * @uses ExhibitorBoothNew_Booth_Category_DataObjectType::setBct_entity_key()
     * @param string $bct_key
     * @param string $bct_code
     * @param string $bct_add_user
     * @param string $bct_add_date
     * @param string $bct_change_user
     * @param string $bct_change_date
     * @param string $bct_delete_flag
     * @param string $bct_key_ext
     * @param string $bct_entity_key
     */
    public function __construct(?string $bct_key = null, ?string $bct_code = null, ?string $bct_add_user = null, ?string $bct_add_date = null, ?string $bct_change_user = null, ?string $bct_change_date = null, ?string $bct_delete_flag = null, ?string $bct_key_ext = null, ?string $bct_entity_key = null)
    {
        $this
            ->setBct_key($bct_key)
            ->setBct_code($bct_code)
            ->setBct_add_user($bct_add_user)
            ->setBct_add_date($bct_add_date)
            ->setBct_change_user($bct_change_user)
            ->setBct_change_date($bct_change_date)
            ->setBct_delete_flag($bct_delete_flag)
            ->setBct_key_ext($bct_key_ext)
            ->setBct_entity_key($bct_entity_key);
    }
    /**
     * Get bct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBct_key(): ?string
    {
        return $this->bct_key ?? null;
    }
    /**
     * Set bct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Category_DataObjectType
     */
    public function setBct_key(?string $bct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bct_key) && !is_string($bct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bct_key, true), gettype($bct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bct_key, true)), __LINE__);
        }
        if (is_null($bct_key) || (is_array($bct_key) && empty($bct_key))) {
            unset($this->bct_key);
        } else {
            $this->bct_key = $bct_key;
        }
        
        return $this;
    }
    /**
     * Get bct_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBct_code(): ?string
    {
        return $this->bct_code ?? null;
    }
    /**
     * Set bct_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bct_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Category_DataObjectType
     */
    public function setBct_code(?string $bct_code = null): self
    {
        // validation for constraint: string
        if (!is_null($bct_code) && !is_string($bct_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bct_code, true), gettype($bct_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bct_code) && mb_strlen((string) $bct_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bct_code)), __LINE__);
        }
        if (is_null($bct_code) || (is_array($bct_code) && empty($bct_code))) {
            unset($this->bct_code);
        } else {
            $this->bct_code = $bct_code;
        }
        
        return $this;
    }
    /**
     * Get bct_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBct_add_user(): ?string
    {
        return $this->bct_add_user ?? null;
    }
    /**
     * Set bct_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bct_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Category_DataObjectType
     */
    public function setBct_add_user(?string $bct_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bct_add_user) && !is_string($bct_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bct_add_user, true), gettype($bct_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bct_add_user) && mb_strlen((string) $bct_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bct_add_user)), __LINE__);
        }
        if (is_null($bct_add_user) || (is_array($bct_add_user) && empty($bct_add_user))) {
            unset($this->bct_add_user);
        } else {
            $this->bct_add_user = $bct_add_user;
        }
        
        return $this;
    }
    /**
     * Get bct_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBct_add_date(): ?string
    {
        return $this->bct_add_date ?? null;
    }
    /**
     * Set bct_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bct_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Category_DataObjectType
     */
    public function setBct_add_date(?string $bct_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bct_add_date) && !is_string($bct_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bct_add_date, true), gettype($bct_add_date)), __LINE__);
        }
        if (is_null($bct_add_date) || (is_array($bct_add_date) && empty($bct_add_date))) {
            unset($this->bct_add_date);
        } else {
            $this->bct_add_date = $bct_add_date;
        }
        
        return $this;
    }
    /**
     * Get bct_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBct_change_user(): ?string
    {
        return $this->bct_change_user ?? null;
    }
    /**
     * Set bct_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bct_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Category_DataObjectType
     */
    public function setBct_change_user(?string $bct_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bct_change_user) && !is_string($bct_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bct_change_user, true), gettype($bct_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bct_change_user) && mb_strlen((string) $bct_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bct_change_user)), __LINE__);
        }
        if (is_null($bct_change_user) || (is_array($bct_change_user) && empty($bct_change_user))) {
            unset($this->bct_change_user);
        } else {
            $this->bct_change_user = $bct_change_user;
        }
        
        return $this;
    }
    /**
     * Get bct_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBct_change_date(): ?string
    {
        return $this->bct_change_date ?? null;
    }
    /**
     * Set bct_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bct_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Category_DataObjectType
     */
    public function setBct_change_date(?string $bct_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bct_change_date) && !is_string($bct_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bct_change_date, true), gettype($bct_change_date)), __LINE__);
        }
        if (is_null($bct_change_date) || (is_array($bct_change_date) && empty($bct_change_date))) {
            unset($this->bct_change_date);
        } else {
            $this->bct_change_date = $bct_change_date;
        }
        
        return $this;
    }
    /**
     * Get bct_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBct_delete_flag(): ?string
    {
        return $this->bct_delete_flag ?? null;
    }
    /**
     * Set bct_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bct_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Category_DataObjectType
     */
    public function setBct_delete_flag(?string $bct_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bct_delete_flag) && !is_string($bct_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bct_delete_flag, true), gettype($bct_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bct_delete_flag) && $bct_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bct_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bct_delete_flag) && $bct_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bct_delete_flag, true)), __LINE__);
        }
        if (is_null($bct_delete_flag) || (is_array($bct_delete_flag) && empty($bct_delete_flag))) {
            unset($this->bct_delete_flag);
        } else {
            $this->bct_delete_flag = $bct_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get bct_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBct_key_ext(): ?string
    {
        return $this->bct_key_ext ?? null;
    }
    /**
     * Set bct_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bct_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Category_DataObjectType
     */
    public function setBct_key_ext(?string $bct_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bct_key_ext) && !is_string($bct_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bct_key_ext, true), gettype($bct_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bct_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bct_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bct_key_ext, true)), __LINE__);
        }
        if (is_null($bct_key_ext) || (is_array($bct_key_ext) && empty($bct_key_ext))) {
            unset($this->bct_key_ext);
        } else {
            $this->bct_key_ext = $bct_key_ext;
        }
        
        return $this;
    }
    /**
     * Get bct_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBct_entity_key(): ?string
    {
        return $this->bct_entity_key ?? null;
    }
    /**
     * Set bct_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bct_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Category_DataObjectType
     */
    public function setBct_entity_key(?string $bct_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bct_entity_key) && !is_string($bct_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bct_entity_key, true), gettype($bct_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bct_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bct_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bct_entity_key, true)), __LINE__);
        }
        if (is_null($bct_entity_key) || (is_array($bct_entity_key) && empty($bct_entity_key))) {
            unset($this->bct_entity_key);
        } else {
            $this->bct_entity_key = $bct_entity_key;
        }
        
        return $this;
    }
}
