<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorBoothNew_Booth_Fee_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorBoothNew_Booth_Fee_DataObjectType extends AbstractStructBase
{
    /**
     * The bfe_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bfe_prd_key = null;
    /**
     * The bfe_square_footage_min
     * Meta information extracted from the WSDL
     * - documentation: min square footage. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $bfe_square_footage_min = null;
    /**
     * The bfe_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bfe_add_user = null;
    /**
     * The bfe_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bfe_add_date = null;
    /**
     * The bfe_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bfe_change_user = null;
    /**
     * The bfe_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bfe_change_date = null;
    /**
     * The bfe_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bfe_delete_flag = null;
    /**
     * The bfe_prd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bfe_prd_key_ext = null;
    /**
     * The bfe_bty_key
     * Meta information extracted from the WSDL
     * - documentation: Booth Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bfe_bty_key = null;
    /**
     * The bfe_square_footage_max
     * Meta information extracted from the WSDL
     * - documentation: max square footage. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $bfe_square_footage_max = null;
    /**
     * The bfe_bct_key
     * Meta information extracted from the WSDL
     * - documentation: booth category. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bfe_bct_key = null;
    /**
     * The bfe_exb_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibit Show. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bfe_exb_key = null;
    /**
     * The bfe_fee_class
     * Meta information extracted from the WSDL
     * - documentation: fee class. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bfe_fee_class = null;
    /**
     * The bfe_square_footage_flag
     * Meta information extracted from the WSDL
     * - documentation: square footage fee?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bfe_square_footage_flag = null;
    /**
     * The bfe_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bfe_entity_key = null;
    /**
     * The bfe_booth_personnel_qty
     * Meta information extracted from the WSDL
     * - documentation: booth personnel qty. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $bfe_booth_personnel_qty = null;
    /**
     * The bfe_quantity
     * Meta information extracted from the WSDL
     * - documentation: quantity. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $bfe_quantity = null;
    /**
     * The bfe_comp_registrations
     * Meta information extracted from the WSDL
     * - documentation: comp registrations. This field has this Input Mask: 99,999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $bfe_comp_registrations = null;
    /**
     * The bfe_priority_points
     * Meta information extracted from the WSDL
     * - documentation: priority points. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $bfe_priority_points = null;
    /**
     * The bfe_ebn_key
     * Meta information extracted from the WSDL
     * - documentation: booth number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bfe_ebn_key = null;
    /**
     * Constructor method for ExhibitorBoothNew_Booth_Fee_DataObjectType
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_prd_key()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_square_footage_min()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_add_user()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_add_date()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_change_user()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_change_date()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_delete_flag()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_prd_key_ext()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_bty_key()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_square_footage_max()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_bct_key()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_exb_key()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_fee_class()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_square_footage_flag()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_entity_key()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_booth_personnel_qty()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_quantity()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_comp_registrations()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_priority_points()
     * @uses ExhibitorBoothNew_Booth_Fee_DataObjectType::setBfe_ebn_key()
     * @param string $bfe_prd_key
     * @param float $bfe_square_footage_min
     * @param string $bfe_add_user
     * @param string $bfe_add_date
     * @param string $bfe_change_user
     * @param string $bfe_change_date
     * @param string $bfe_delete_flag
     * @param string $bfe_prd_key_ext
     * @param string $bfe_bty_key
     * @param float $bfe_square_footage_max
     * @param string $bfe_bct_key
     * @param string $bfe_exb_key
     * @param string $bfe_fee_class
     * @param string $bfe_square_footage_flag
     * @param string $bfe_entity_key
     * @param int $bfe_booth_personnel_qty
     * @param int $bfe_quantity
     * @param int $bfe_comp_registrations
     * @param int $bfe_priority_points
     * @param string $bfe_ebn_key
     */
    public function __construct(?string $bfe_prd_key = null, ?float $bfe_square_footage_min = null, ?string $bfe_add_user = null, ?string $bfe_add_date = null, ?string $bfe_change_user = null, ?string $bfe_change_date = null, ?string $bfe_delete_flag = null, ?string $bfe_prd_key_ext = null, ?string $bfe_bty_key = null, ?float $bfe_square_footage_max = null, ?string $bfe_bct_key = null, ?string $bfe_exb_key = null, ?string $bfe_fee_class = null, ?string $bfe_square_footage_flag = null, ?string $bfe_entity_key = null, ?int $bfe_booth_personnel_qty = null, ?int $bfe_quantity = null, ?int $bfe_comp_registrations = null, ?int $bfe_priority_points = null, ?string $bfe_ebn_key = null)
    {
        $this
            ->setBfe_prd_key($bfe_prd_key)
            ->setBfe_square_footage_min($bfe_square_footage_min)
            ->setBfe_add_user($bfe_add_user)
            ->setBfe_add_date($bfe_add_date)
            ->setBfe_change_user($bfe_change_user)
            ->setBfe_change_date($bfe_change_date)
            ->setBfe_delete_flag($bfe_delete_flag)
            ->setBfe_prd_key_ext($bfe_prd_key_ext)
            ->setBfe_bty_key($bfe_bty_key)
            ->setBfe_square_footage_max($bfe_square_footage_max)
            ->setBfe_bct_key($bfe_bct_key)
            ->setBfe_exb_key($bfe_exb_key)
            ->setBfe_fee_class($bfe_fee_class)
            ->setBfe_square_footage_flag($bfe_square_footage_flag)
            ->setBfe_entity_key($bfe_entity_key)
            ->setBfe_booth_personnel_qty($bfe_booth_personnel_qty)
            ->setBfe_quantity($bfe_quantity)
            ->setBfe_comp_registrations($bfe_comp_registrations)
            ->setBfe_priority_points($bfe_priority_points)
            ->setBfe_ebn_key($bfe_ebn_key);
    }
    /**
     * Get bfe_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_prd_key(): ?string
    {
        return $this->bfe_prd_key ?? null;
    }
    /**
     * Set bfe_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_prd_key(?string $bfe_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_prd_key) && !is_string($bfe_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_prd_key, true), gettype($bfe_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bfe_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bfe_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bfe_prd_key, true)), __LINE__);
        }
        if (is_null($bfe_prd_key) || (is_array($bfe_prd_key) && empty($bfe_prd_key))) {
            unset($this->bfe_prd_key);
        } else {
            $this->bfe_prd_key = $bfe_prd_key;
        }
        
        return $this;
    }
    /**
     * Get bfe_square_footage_min value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBfe_square_footage_min(): ?float
    {
        return $this->bfe_square_footage_min ?? null;
    }
    /**
     * Set bfe_square_footage_min value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bfe_square_footage_min
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_square_footage_min(?float $bfe_square_footage_min = null): self
    {
        // validation for constraint: float
        if (!is_null($bfe_square_footage_min) && !(is_float($bfe_square_footage_min) || is_numeric($bfe_square_footage_min))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bfe_square_footage_min, true), gettype($bfe_square_footage_min)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bfe_square_footage_min) && mb_strlen(mb_substr((string) $bfe_square_footage_min, false !== mb_strpos((string) $bfe_square_footage_min, '.') ? mb_strpos((string) $bfe_square_footage_min, '.') + 1 : mb_strlen((string) $bfe_square_footage_min))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bfe_square_footage_min, true), mb_strlen(mb_substr((string) $bfe_square_footage_min, mb_strpos((string) $bfe_square_footage_min, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($bfe_square_footage_min) && mb_strlen(preg_replace('/(\D)/', '', (string) $bfe_square_footage_min)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($bfe_square_footage_min, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bfe_square_footage_min))), __LINE__);
        }
        if (is_null($bfe_square_footage_min) || (is_array($bfe_square_footage_min) && empty($bfe_square_footage_min))) {
            unset($this->bfe_square_footage_min);
        } else {
            $this->bfe_square_footage_min = $bfe_square_footage_min;
        }
        
        return $this;
    }
    /**
     * Get bfe_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_add_user(): ?string
    {
        return $this->bfe_add_user ?? null;
    }
    /**
     * Set bfe_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_add_user(?string $bfe_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_add_user) && !is_string($bfe_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_add_user, true), gettype($bfe_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bfe_add_user) && mb_strlen((string) $bfe_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bfe_add_user)), __LINE__);
        }
        if (is_null($bfe_add_user) || (is_array($bfe_add_user) && empty($bfe_add_user))) {
            unset($this->bfe_add_user);
        } else {
            $this->bfe_add_user = $bfe_add_user;
        }
        
        return $this;
    }
    /**
     * Get bfe_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_add_date(): ?string
    {
        return $this->bfe_add_date ?? null;
    }
    /**
     * Set bfe_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_add_date(?string $bfe_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_add_date) && !is_string($bfe_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_add_date, true), gettype($bfe_add_date)), __LINE__);
        }
        if (is_null($bfe_add_date) || (is_array($bfe_add_date) && empty($bfe_add_date))) {
            unset($this->bfe_add_date);
        } else {
            $this->bfe_add_date = $bfe_add_date;
        }
        
        return $this;
    }
    /**
     * Get bfe_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_change_user(): ?string
    {
        return $this->bfe_change_user ?? null;
    }
    /**
     * Set bfe_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_change_user(?string $bfe_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_change_user) && !is_string($bfe_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_change_user, true), gettype($bfe_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bfe_change_user) && mb_strlen((string) $bfe_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bfe_change_user)), __LINE__);
        }
        if (is_null($bfe_change_user) || (is_array($bfe_change_user) && empty($bfe_change_user))) {
            unset($this->bfe_change_user);
        } else {
            $this->bfe_change_user = $bfe_change_user;
        }
        
        return $this;
    }
    /**
     * Get bfe_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_change_date(): ?string
    {
        return $this->bfe_change_date ?? null;
    }
    /**
     * Set bfe_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_change_date(?string $bfe_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_change_date) && !is_string($bfe_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_change_date, true), gettype($bfe_change_date)), __LINE__);
        }
        if (is_null($bfe_change_date) || (is_array($bfe_change_date) && empty($bfe_change_date))) {
            unset($this->bfe_change_date);
        } else {
            $this->bfe_change_date = $bfe_change_date;
        }
        
        return $this;
    }
    /**
     * Get bfe_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_delete_flag(): ?string
    {
        return $this->bfe_delete_flag ?? null;
    }
    /**
     * Set bfe_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_delete_flag(?string $bfe_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_delete_flag) && !is_string($bfe_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_delete_flag, true), gettype($bfe_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bfe_delete_flag) && $bfe_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bfe_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bfe_delete_flag) && $bfe_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bfe_delete_flag, true)), __LINE__);
        }
        if (is_null($bfe_delete_flag) || (is_array($bfe_delete_flag) && empty($bfe_delete_flag))) {
            unset($this->bfe_delete_flag);
        } else {
            $this->bfe_delete_flag = $bfe_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get bfe_prd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_prd_key_ext(): ?string
    {
        return $this->bfe_prd_key_ext ?? null;
    }
    /**
     * Set bfe_prd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_prd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_prd_key_ext(?string $bfe_prd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_prd_key_ext) && !is_string($bfe_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_prd_key_ext, true), gettype($bfe_prd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bfe_prd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bfe_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bfe_prd_key_ext, true)), __LINE__);
        }
        if (is_null($bfe_prd_key_ext) || (is_array($bfe_prd_key_ext) && empty($bfe_prd_key_ext))) {
            unset($this->bfe_prd_key_ext);
        } else {
            $this->bfe_prd_key_ext = $bfe_prd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get bfe_bty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_bty_key(): ?string
    {
        return $this->bfe_bty_key ?? null;
    }
    /**
     * Set bfe_bty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_bty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_bty_key(?string $bfe_bty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_bty_key) && !is_string($bfe_bty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_bty_key, true), gettype($bfe_bty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bfe_bty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bfe_bty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bfe_bty_key, true)), __LINE__);
        }
        if (is_null($bfe_bty_key) || (is_array($bfe_bty_key) && empty($bfe_bty_key))) {
            unset($this->bfe_bty_key);
        } else {
            $this->bfe_bty_key = $bfe_bty_key;
        }
        
        return $this;
    }
    /**
     * Get bfe_square_footage_max value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBfe_square_footage_max(): ?float
    {
        return $this->bfe_square_footage_max ?? null;
    }
    /**
     * Set bfe_square_footage_max value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bfe_square_footage_max
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_square_footage_max(?float $bfe_square_footage_max = null): self
    {
        // validation for constraint: float
        if (!is_null($bfe_square_footage_max) && !(is_float($bfe_square_footage_max) || is_numeric($bfe_square_footage_max))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bfe_square_footage_max, true), gettype($bfe_square_footage_max)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bfe_square_footage_max) && mb_strlen(mb_substr((string) $bfe_square_footage_max, false !== mb_strpos((string) $bfe_square_footage_max, '.') ? mb_strpos((string) $bfe_square_footage_max, '.') + 1 : mb_strlen((string) $bfe_square_footage_max))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bfe_square_footage_max, true), mb_strlen(mb_substr((string) $bfe_square_footage_max, mb_strpos((string) $bfe_square_footage_max, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($bfe_square_footage_max) && mb_strlen(preg_replace('/(\D)/', '', (string) $bfe_square_footage_max)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($bfe_square_footage_max, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bfe_square_footage_max))), __LINE__);
        }
        if (is_null($bfe_square_footage_max) || (is_array($bfe_square_footage_max) && empty($bfe_square_footage_max))) {
            unset($this->bfe_square_footage_max);
        } else {
            $this->bfe_square_footage_max = $bfe_square_footage_max;
        }
        
        return $this;
    }
    /**
     * Get bfe_bct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_bct_key(): ?string
    {
        return $this->bfe_bct_key ?? null;
    }
    /**
     * Set bfe_bct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_bct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_bct_key(?string $bfe_bct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_bct_key) && !is_string($bfe_bct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_bct_key, true), gettype($bfe_bct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bfe_bct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bfe_bct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bfe_bct_key, true)), __LINE__);
        }
        if (is_null($bfe_bct_key) || (is_array($bfe_bct_key) && empty($bfe_bct_key))) {
            unset($this->bfe_bct_key);
        } else {
            $this->bfe_bct_key = $bfe_bct_key;
        }
        
        return $this;
    }
    /**
     * Get bfe_exb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_exb_key(): ?string
    {
        return $this->bfe_exb_key ?? null;
    }
    /**
     * Set bfe_exb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_exb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_exb_key(?string $bfe_exb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_exb_key) && !is_string($bfe_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_exb_key, true), gettype($bfe_exb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bfe_exb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bfe_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bfe_exb_key, true)), __LINE__);
        }
        if (is_null($bfe_exb_key) || (is_array($bfe_exb_key) && empty($bfe_exb_key))) {
            unset($this->bfe_exb_key);
        } else {
            $this->bfe_exb_key = $bfe_exb_key;
        }
        
        return $this;
    }
    /**
     * Get bfe_fee_class value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_fee_class(): ?string
    {
        return $this->bfe_fee_class ?? null;
    }
    /**
     * Set bfe_fee_class value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_fee_class
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_fee_class(?string $bfe_fee_class = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_fee_class) && !is_string($bfe_fee_class)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_fee_class, true), gettype($bfe_fee_class)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bfe_fee_class) && mb_strlen((string) $bfe_fee_class) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bfe_fee_class)), __LINE__);
        }
        if (is_null($bfe_fee_class) || (is_array($bfe_fee_class) && empty($bfe_fee_class))) {
            unset($this->bfe_fee_class);
        } else {
            $this->bfe_fee_class = $bfe_fee_class;
        }
        
        return $this;
    }
    /**
     * Get bfe_square_footage_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_square_footage_flag(): ?string
    {
        return $this->bfe_square_footage_flag ?? null;
    }
    /**
     * Set bfe_square_footage_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_square_footage_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_square_footage_flag(?string $bfe_square_footage_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_square_footage_flag) && !is_string($bfe_square_footage_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_square_footage_flag, true), gettype($bfe_square_footage_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bfe_square_footage_flag) && $bfe_square_footage_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bfe_square_footage_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bfe_square_footage_flag) && $bfe_square_footage_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bfe_square_footage_flag, true)), __LINE__);
        }
        if (is_null($bfe_square_footage_flag) || (is_array($bfe_square_footage_flag) && empty($bfe_square_footage_flag))) {
            unset($this->bfe_square_footage_flag);
        } else {
            $this->bfe_square_footage_flag = $bfe_square_footage_flag;
        }
        
        return $this;
    }
    /**
     * Get bfe_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_entity_key(): ?string
    {
        return $this->bfe_entity_key ?? null;
    }
    /**
     * Set bfe_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_entity_key(?string $bfe_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_entity_key) && !is_string($bfe_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_entity_key, true), gettype($bfe_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bfe_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bfe_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bfe_entity_key, true)), __LINE__);
        }
        if (is_null($bfe_entity_key) || (is_array($bfe_entity_key) && empty($bfe_entity_key))) {
            unset($this->bfe_entity_key);
        } else {
            $this->bfe_entity_key = $bfe_entity_key;
        }
        
        return $this;
    }
    /**
     * Get bfe_booth_personnel_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBfe_booth_personnel_qty(): ?int
    {
        return $this->bfe_booth_personnel_qty ?? null;
    }
    /**
     * Set bfe_booth_personnel_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bfe_booth_personnel_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_booth_personnel_qty(?int $bfe_booth_personnel_qty = null): self
    {
        // validation for constraint: int
        if (!is_null($bfe_booth_personnel_qty) && !(is_int($bfe_booth_personnel_qty) || ctype_digit($bfe_booth_personnel_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bfe_booth_personnel_qty, true), gettype($bfe_booth_personnel_qty)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($bfe_booth_personnel_qty) && $bfe_booth_personnel_qty > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($bfe_booth_personnel_qty, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($bfe_booth_personnel_qty) && $bfe_booth_personnel_qty < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($bfe_booth_personnel_qty, true)), __LINE__);
        }
        if (is_null($bfe_booth_personnel_qty) || (is_array($bfe_booth_personnel_qty) && empty($bfe_booth_personnel_qty))) {
            unset($this->bfe_booth_personnel_qty);
        } else {
            $this->bfe_booth_personnel_qty = $bfe_booth_personnel_qty;
        }
        
        return $this;
    }
    /**
     * Get bfe_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBfe_quantity(): ?int
    {
        return $this->bfe_quantity ?? null;
    }
    /**
     * Set bfe_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bfe_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_quantity(?int $bfe_quantity = null): self
    {
        // validation for constraint: int
        if (!is_null($bfe_quantity) && !(is_int($bfe_quantity) || ctype_digit($bfe_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bfe_quantity, true), gettype($bfe_quantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($bfe_quantity) && $bfe_quantity > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($bfe_quantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($bfe_quantity) && $bfe_quantity < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($bfe_quantity, true)), __LINE__);
        }
        if (is_null($bfe_quantity) || (is_array($bfe_quantity) && empty($bfe_quantity))) {
            unset($this->bfe_quantity);
        } else {
            $this->bfe_quantity = $bfe_quantity;
        }
        
        return $this;
    }
    /**
     * Get bfe_comp_registrations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBfe_comp_registrations(): ?int
    {
        return $this->bfe_comp_registrations ?? null;
    }
    /**
     * Set bfe_comp_registrations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bfe_comp_registrations
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_comp_registrations(?int $bfe_comp_registrations = null): self
    {
        // validation for constraint: int
        if (!is_null($bfe_comp_registrations) && !(is_int($bfe_comp_registrations) || ctype_digit($bfe_comp_registrations))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bfe_comp_registrations, true), gettype($bfe_comp_registrations)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($bfe_comp_registrations) && $bfe_comp_registrations > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($bfe_comp_registrations, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($bfe_comp_registrations) && $bfe_comp_registrations < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($bfe_comp_registrations, true)), __LINE__);
        }
        if (is_null($bfe_comp_registrations) || (is_array($bfe_comp_registrations) && empty($bfe_comp_registrations))) {
            unset($this->bfe_comp_registrations);
        } else {
            $this->bfe_comp_registrations = $bfe_comp_registrations;
        }
        
        return $this;
    }
    /**
     * Get bfe_priority_points value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBfe_priority_points(): ?int
    {
        return $this->bfe_priority_points ?? null;
    }
    /**
     * Set bfe_priority_points value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bfe_priority_points
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_priority_points(?int $bfe_priority_points = null): self
    {
        // validation for constraint: int
        if (!is_null($bfe_priority_points) && !(is_int($bfe_priority_points) || ctype_digit($bfe_priority_points))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bfe_priority_points, true), gettype($bfe_priority_points)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($bfe_priority_points) && $bfe_priority_points > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($bfe_priority_points, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($bfe_priority_points) && $bfe_priority_points < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($bfe_priority_points, true)), __LINE__);
        }
        if (is_null($bfe_priority_points) || (is_array($bfe_priority_points) && empty($bfe_priority_points))) {
            unset($this->bfe_priority_points);
        } else {
            $this->bfe_priority_points = $bfe_priority_points;
        }
        
        return $this;
    }
    /**
     * Get bfe_ebn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBfe_ebn_key(): ?string
    {
        return $this->bfe_ebn_key ?? null;
    }
    /**
     * Set bfe_ebn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bfe_ebn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Fee_DataObjectType
     */
    public function setBfe_ebn_key(?string $bfe_ebn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bfe_ebn_key) && !is_string($bfe_ebn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bfe_ebn_key, true), gettype($bfe_ebn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bfe_ebn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bfe_ebn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bfe_ebn_key, true)), __LINE__);
        }
        if (is_null($bfe_ebn_key) || (is_array($bfe_ebn_key) && empty($bfe_ebn_key))) {
            unset($this->bfe_ebn_key);
        } else {
            $this->bfe_ebn_key = $bfe_ebn_key;
        }
        
        return $this;
    }
}
