<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorBoothNew_Booth_Number_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorBoothNew_Booth_Number_DataObjectType extends AbstractStructBase
{
    /**
     * The ebn_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebn_key = null;
    /**
     * The ebn_exb_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibit Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebn_exb_key = null;
    /**
     * The ebn_booth_number
     * Meta information extracted from the WSDL
     * - documentation: booth number. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ebn_booth_number = null;
    /**
     * The ebn_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebn_add_user = null;
    /**
     * The ebn_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebn_add_date = null;
    /**
     * The ebn_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebn_change_user = null;
    /**
     * The ebn_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebn_change_date = null;
    /**
     * The ebn_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebn_delete_flag = null;
    /**
     * The ebn_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebn_key_ext = null;
    /**
     * The ebn_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebn_entity_key = null;
    /**
     * The ebn_prefix
     * Meta information extracted from the WSDL
     * - documentation: prefix. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebn_prefix = null;
    /**
     * The ebn_suffix
     * Meta information extracted from the WSDL
     * - documentation: suffix. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebn_suffix = null;
    /**
     * The ebn_size
     * Meta information extracted from the WSDL
     * - documentation: size. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ebn_size = null;
    /**
     * The ebn_display_booth_number
     * Meta information extracted from the WSDL
     * - documentation: Booth Number (Display). This field has this Input Mask: regex:^\w{0,50}$. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebn_display_booth_number = null;
    /**
     * Constructor method for ExhibitorBoothNew_Booth_Number_DataObjectType
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_key()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_exb_key()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_booth_number()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_add_user()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_add_date()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_change_user()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_change_date()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_delete_flag()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_key_ext()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_entity_key()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_prefix()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_suffix()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_size()
     * @uses ExhibitorBoothNew_Booth_Number_DataObjectType::setEbn_display_booth_number()
     * @param string $ebn_key
     * @param string $ebn_exb_key
     * @param int $ebn_booth_number
     * @param string $ebn_add_user
     * @param string $ebn_add_date
     * @param string $ebn_change_user
     * @param string $ebn_change_date
     * @param string $ebn_delete_flag
     * @param string $ebn_key_ext
     * @param string $ebn_entity_key
     * @param string $ebn_prefix
     * @param string $ebn_suffix
     * @param int $ebn_size
     * @param string $ebn_display_booth_number
     */
    public function __construct(?string $ebn_key = null, ?string $ebn_exb_key = null, ?int $ebn_booth_number = null, ?string $ebn_add_user = null, ?string $ebn_add_date = null, ?string $ebn_change_user = null, ?string $ebn_change_date = null, ?string $ebn_delete_flag = null, ?string $ebn_key_ext = null, ?string $ebn_entity_key = null, ?string $ebn_prefix = null, ?string $ebn_suffix = null, ?int $ebn_size = null, ?string $ebn_display_booth_number = null)
    {
        $this
            ->setEbn_key($ebn_key)
            ->setEbn_exb_key($ebn_exb_key)
            ->setEbn_booth_number($ebn_booth_number)
            ->setEbn_add_user($ebn_add_user)
            ->setEbn_add_date($ebn_add_date)
            ->setEbn_change_user($ebn_change_user)
            ->setEbn_change_date($ebn_change_date)
            ->setEbn_delete_flag($ebn_delete_flag)
            ->setEbn_key_ext($ebn_key_ext)
            ->setEbn_entity_key($ebn_entity_key)
            ->setEbn_prefix($ebn_prefix)
            ->setEbn_suffix($ebn_suffix)
            ->setEbn_size($ebn_size)
            ->setEbn_display_booth_number($ebn_display_booth_number);
    }
    /**
     * Get ebn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_key(): ?string
    {
        return $this->ebn_key ?? null;
    }
    /**
     * Set ebn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_key(?string $ebn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_key) && !is_string($ebn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_key, true), gettype($ebn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebn_key, true)), __LINE__);
        }
        if (is_null($ebn_key) || (is_array($ebn_key) && empty($ebn_key))) {
            unset($this->ebn_key);
        } else {
            $this->ebn_key = $ebn_key;
        }
        
        return $this;
    }
    /**
     * Get ebn_exb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_exb_key(): ?string
    {
        return $this->ebn_exb_key ?? null;
    }
    /**
     * Set ebn_exb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_exb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_exb_key(?string $ebn_exb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_exb_key) && !is_string($ebn_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_exb_key, true), gettype($ebn_exb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebn_exb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebn_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebn_exb_key, true)), __LINE__);
        }
        if (is_null($ebn_exb_key) || (is_array($ebn_exb_key) && empty($ebn_exb_key))) {
            unset($this->ebn_exb_key);
        } else {
            $this->ebn_exb_key = $ebn_exb_key;
        }
        
        return $this;
    }
    /**
     * Get ebn_booth_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEbn_booth_number(): ?int
    {
        return $this->ebn_booth_number ?? null;
    }
    /**
     * Set ebn_booth_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ebn_booth_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_booth_number(?int $ebn_booth_number = null): self
    {
        // validation for constraint: int
        if (!is_null($ebn_booth_number) && !(is_int($ebn_booth_number) || ctype_digit($ebn_booth_number))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ebn_booth_number, true), gettype($ebn_booth_number)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ebn_booth_number) && $ebn_booth_number > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ebn_booth_number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ebn_booth_number) && $ebn_booth_number < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ebn_booth_number, true)), __LINE__);
        }
        if (is_null($ebn_booth_number) || (is_array($ebn_booth_number) && empty($ebn_booth_number))) {
            unset($this->ebn_booth_number);
        } else {
            $this->ebn_booth_number = $ebn_booth_number;
        }
        
        return $this;
    }
    /**
     * Get ebn_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_add_user(): ?string
    {
        return $this->ebn_add_user ?? null;
    }
    /**
     * Set ebn_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_add_user(?string $ebn_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_add_user) && !is_string($ebn_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_add_user, true), gettype($ebn_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ebn_add_user) && mb_strlen((string) $ebn_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ebn_add_user)), __LINE__);
        }
        if (is_null($ebn_add_user) || (is_array($ebn_add_user) && empty($ebn_add_user))) {
            unset($this->ebn_add_user);
        } else {
            $this->ebn_add_user = $ebn_add_user;
        }
        
        return $this;
    }
    /**
     * Get ebn_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_add_date(): ?string
    {
        return $this->ebn_add_date ?? null;
    }
    /**
     * Set ebn_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_add_date(?string $ebn_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_add_date) && !is_string($ebn_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_add_date, true), gettype($ebn_add_date)), __LINE__);
        }
        if (is_null($ebn_add_date) || (is_array($ebn_add_date) && empty($ebn_add_date))) {
            unset($this->ebn_add_date);
        } else {
            $this->ebn_add_date = $ebn_add_date;
        }
        
        return $this;
    }
    /**
     * Get ebn_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_change_user(): ?string
    {
        return $this->ebn_change_user ?? null;
    }
    /**
     * Set ebn_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_change_user(?string $ebn_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_change_user) && !is_string($ebn_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_change_user, true), gettype($ebn_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ebn_change_user) && mb_strlen((string) $ebn_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ebn_change_user)), __LINE__);
        }
        if (is_null($ebn_change_user) || (is_array($ebn_change_user) && empty($ebn_change_user))) {
            unset($this->ebn_change_user);
        } else {
            $this->ebn_change_user = $ebn_change_user;
        }
        
        return $this;
    }
    /**
     * Get ebn_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_change_date(): ?string
    {
        return $this->ebn_change_date ?? null;
    }
    /**
     * Set ebn_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_change_date(?string $ebn_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_change_date) && !is_string($ebn_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_change_date, true), gettype($ebn_change_date)), __LINE__);
        }
        if (is_null($ebn_change_date) || (is_array($ebn_change_date) && empty($ebn_change_date))) {
            unset($this->ebn_change_date);
        } else {
            $this->ebn_change_date = $ebn_change_date;
        }
        
        return $this;
    }
    /**
     * Get ebn_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_delete_flag(): ?string
    {
        return $this->ebn_delete_flag ?? null;
    }
    /**
     * Set ebn_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_delete_flag(?string $ebn_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_delete_flag) && !is_string($ebn_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_delete_flag, true), gettype($ebn_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ebn_delete_flag) && $ebn_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ebn_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ebn_delete_flag) && $ebn_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ebn_delete_flag, true)), __LINE__);
        }
        if (is_null($ebn_delete_flag) || (is_array($ebn_delete_flag) && empty($ebn_delete_flag))) {
            unset($this->ebn_delete_flag);
        } else {
            $this->ebn_delete_flag = $ebn_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ebn_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_key_ext(): ?string
    {
        return $this->ebn_key_ext ?? null;
    }
    /**
     * Set ebn_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_key_ext(?string $ebn_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_key_ext) && !is_string($ebn_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_key_ext, true), gettype($ebn_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebn_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebn_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebn_key_ext, true)), __LINE__);
        }
        if (is_null($ebn_key_ext) || (is_array($ebn_key_ext) && empty($ebn_key_ext))) {
            unset($this->ebn_key_ext);
        } else {
            $this->ebn_key_ext = $ebn_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ebn_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_entity_key(): ?string
    {
        return $this->ebn_entity_key ?? null;
    }
    /**
     * Set ebn_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_entity_key(?string $ebn_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_entity_key) && !is_string($ebn_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_entity_key, true), gettype($ebn_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebn_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebn_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebn_entity_key, true)), __LINE__);
        }
        if (is_null($ebn_entity_key) || (is_array($ebn_entity_key) && empty($ebn_entity_key))) {
            unset($this->ebn_entity_key);
        } else {
            $this->ebn_entity_key = $ebn_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ebn_prefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_prefix(): ?string
    {
        return $this->ebn_prefix ?? null;
    }
    /**
     * Set ebn_prefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_prefix
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_prefix(?string $ebn_prefix = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_prefix) && !is_string($ebn_prefix)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_prefix, true), gettype($ebn_prefix)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ebn_prefix) && mb_strlen((string) $ebn_prefix) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ebn_prefix)), __LINE__);
        }
        if (is_null($ebn_prefix) || (is_array($ebn_prefix) && empty($ebn_prefix))) {
            unset($this->ebn_prefix);
        } else {
            $this->ebn_prefix = $ebn_prefix;
        }
        
        return $this;
    }
    /**
     * Get ebn_suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_suffix(): ?string
    {
        return $this->ebn_suffix ?? null;
    }
    /**
     * Set ebn_suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_suffix
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_suffix(?string $ebn_suffix = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_suffix) && !is_string($ebn_suffix)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_suffix, true), gettype($ebn_suffix)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ebn_suffix) && mb_strlen((string) $ebn_suffix) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ebn_suffix)), __LINE__);
        }
        if (is_null($ebn_suffix) || (is_array($ebn_suffix) && empty($ebn_suffix))) {
            unset($this->ebn_suffix);
        } else {
            $this->ebn_suffix = $ebn_suffix;
        }
        
        return $this;
    }
    /**
     * Get ebn_size value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEbn_size(): ?int
    {
        return $this->ebn_size ?? null;
    }
    /**
     * Set ebn_size value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ebn_size
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_size(?int $ebn_size = null): self
    {
        // validation for constraint: int
        if (!is_null($ebn_size) && !(is_int($ebn_size) || ctype_digit($ebn_size))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ebn_size, true), gettype($ebn_size)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ebn_size) && $ebn_size > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ebn_size, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ebn_size) && $ebn_size < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ebn_size, true)), __LINE__);
        }
        if (is_null($ebn_size) || (is_array($ebn_size) && empty($ebn_size))) {
            unset($this->ebn_size);
        } else {
            $this->ebn_size = $ebn_size;
        }
        
        return $this;
    }
    /**
     * Get ebn_display_booth_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbn_display_booth_number(): ?string
    {
        return $this->ebn_display_booth_number ?? null;
    }
    /**
     * Set ebn_display_booth_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebn_display_booth_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Number_DataObjectType
     */
    public function setEbn_display_booth_number(?string $ebn_display_booth_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ebn_display_booth_number) && !is_string($ebn_display_booth_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebn_display_booth_number, true), gettype($ebn_display_booth_number)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ebn_display_booth_number) && mb_strlen((string) $ebn_display_booth_number) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ebn_display_booth_number)), __LINE__);
        }
        if (is_null($ebn_display_booth_number) || (is_array($ebn_display_booth_number) && empty($ebn_display_booth_number))) {
            unset($this->ebn_display_booth_number);
        } else {
            $this->ebn_display_booth_number = $ebn_display_booth_number;
        }
        
        return $this;
    }
}
