<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorBoothNew_Booth_Type_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorBoothNew_Booth_Type_DataObjectType extends AbstractStructBase
{
    /**
     * The bty_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bty_key = null;
    /**
     * The bty_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bty_add_user = null;
    /**
     * The bty_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bty_add_date = null;
    /**
     * The bty_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bty_change_user = null;
    /**
     * The bty_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bty_change_date = null;
    /**
     * The bty_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bty_delete_flag = null;
    /**
     * The bty_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bty_entity_key = null;
    /**
     * The bty_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bty_key_ext = null;
    /**
     * The bty_bct_key
     * Meta information extracted from the WSDL
     * - documentation: Booth category. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bty_bct_key = null;
    /**
     * The bty_code
     * Meta information extracted from the WSDL
     * - documentation: Booth Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bty_code = null;
    /**
     * The bty_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bty_description = null;
    /**
     * The bty_square_footage
     * Meta information extracted from the WSDL
     * - documentation: Square Footage. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $bty_square_footage = null;
    /**
     * Constructor method for ExhibitorBoothNew_Booth_Type_DataObjectType
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_key()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_add_user()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_add_date()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_change_user()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_change_date()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_delete_flag()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_entity_key()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_key_ext()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_bct_key()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_code()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_description()
     * @uses ExhibitorBoothNew_Booth_Type_DataObjectType::setBty_square_footage()
     * @param string $bty_key
     * @param string $bty_add_user
     * @param string $bty_add_date
     * @param string $bty_change_user
     * @param string $bty_change_date
     * @param string $bty_delete_flag
     * @param string $bty_entity_key
     * @param string $bty_key_ext
     * @param string $bty_bct_key
     * @param string $bty_code
     * @param string $bty_description
     * @param float $bty_square_footage
     */
    public function __construct(?string $bty_key = null, ?string $bty_add_user = null, ?string $bty_add_date = null, ?string $bty_change_user = null, ?string $bty_change_date = null, ?string $bty_delete_flag = null, ?string $bty_entity_key = null, ?string $bty_key_ext = null, ?string $bty_bct_key = null, ?string $bty_code = null, ?string $bty_description = null, ?float $bty_square_footage = null)
    {
        $this
            ->setBty_key($bty_key)
            ->setBty_add_user($bty_add_user)
            ->setBty_add_date($bty_add_date)
            ->setBty_change_user($bty_change_user)
            ->setBty_change_date($bty_change_date)
            ->setBty_delete_flag($bty_delete_flag)
            ->setBty_entity_key($bty_entity_key)
            ->setBty_key_ext($bty_key_ext)
            ->setBty_bct_key($bty_bct_key)
            ->setBty_code($bty_code)
            ->setBty_description($bty_description)
            ->setBty_square_footage($bty_square_footage);
    }
    /**
     * Get bty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_key(): ?string
    {
        return $this->bty_key ?? null;
    }
    /**
     * Set bty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_key(?string $bty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_key) && !is_string($bty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_key, true), gettype($bty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bty_key, true)), __LINE__);
        }
        if (is_null($bty_key) || (is_array($bty_key) && empty($bty_key))) {
            unset($this->bty_key);
        } else {
            $this->bty_key = $bty_key;
        }
        
        return $this;
    }
    /**
     * Get bty_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_add_user(): ?string
    {
        return $this->bty_add_user ?? null;
    }
    /**
     * Set bty_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_add_user(?string $bty_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_add_user) && !is_string($bty_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_add_user, true), gettype($bty_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bty_add_user) && mb_strlen((string) $bty_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bty_add_user)), __LINE__);
        }
        if (is_null($bty_add_user) || (is_array($bty_add_user) && empty($bty_add_user))) {
            unset($this->bty_add_user);
        } else {
            $this->bty_add_user = $bty_add_user;
        }
        
        return $this;
    }
    /**
     * Get bty_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_add_date(): ?string
    {
        return $this->bty_add_date ?? null;
    }
    /**
     * Set bty_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_add_date(?string $bty_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_add_date) && !is_string($bty_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_add_date, true), gettype($bty_add_date)), __LINE__);
        }
        if (is_null($bty_add_date) || (is_array($bty_add_date) && empty($bty_add_date))) {
            unset($this->bty_add_date);
        } else {
            $this->bty_add_date = $bty_add_date;
        }
        
        return $this;
    }
    /**
     * Get bty_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_change_user(): ?string
    {
        return $this->bty_change_user ?? null;
    }
    /**
     * Set bty_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_change_user(?string $bty_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_change_user) && !is_string($bty_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_change_user, true), gettype($bty_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bty_change_user) && mb_strlen((string) $bty_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bty_change_user)), __LINE__);
        }
        if (is_null($bty_change_user) || (is_array($bty_change_user) && empty($bty_change_user))) {
            unset($this->bty_change_user);
        } else {
            $this->bty_change_user = $bty_change_user;
        }
        
        return $this;
    }
    /**
     * Get bty_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_change_date(): ?string
    {
        return $this->bty_change_date ?? null;
    }
    /**
     * Set bty_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_change_date(?string $bty_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_change_date) && !is_string($bty_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_change_date, true), gettype($bty_change_date)), __LINE__);
        }
        if (is_null($bty_change_date) || (is_array($bty_change_date) && empty($bty_change_date))) {
            unset($this->bty_change_date);
        } else {
            $this->bty_change_date = $bty_change_date;
        }
        
        return $this;
    }
    /**
     * Get bty_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_delete_flag(): ?string
    {
        return $this->bty_delete_flag ?? null;
    }
    /**
     * Set bty_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_delete_flag(?string $bty_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_delete_flag) && !is_string($bty_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_delete_flag, true), gettype($bty_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bty_delete_flag) && $bty_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bty_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bty_delete_flag) && $bty_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bty_delete_flag, true)), __LINE__);
        }
        if (is_null($bty_delete_flag) || (is_array($bty_delete_flag) && empty($bty_delete_flag))) {
            unset($this->bty_delete_flag);
        } else {
            $this->bty_delete_flag = $bty_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get bty_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_entity_key(): ?string
    {
        return $this->bty_entity_key ?? null;
    }
    /**
     * Set bty_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_entity_key(?string $bty_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_entity_key) && !is_string($bty_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_entity_key, true), gettype($bty_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bty_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bty_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bty_entity_key, true)), __LINE__);
        }
        if (is_null($bty_entity_key) || (is_array($bty_entity_key) && empty($bty_entity_key))) {
            unset($this->bty_entity_key);
        } else {
            $this->bty_entity_key = $bty_entity_key;
        }
        
        return $this;
    }
    /**
     * Get bty_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_key_ext(): ?string
    {
        return $this->bty_key_ext ?? null;
    }
    /**
     * Set bty_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_key_ext(?string $bty_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_key_ext) && !is_string($bty_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_key_ext, true), gettype($bty_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bty_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bty_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bty_key_ext, true)), __LINE__);
        }
        if (is_null($bty_key_ext) || (is_array($bty_key_ext) && empty($bty_key_ext))) {
            unset($this->bty_key_ext);
        } else {
            $this->bty_key_ext = $bty_key_ext;
        }
        
        return $this;
    }
    /**
     * Get bty_bct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_bct_key(): ?string
    {
        return $this->bty_bct_key ?? null;
    }
    /**
     * Set bty_bct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_bct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_bct_key(?string $bty_bct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_bct_key) && !is_string($bty_bct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_bct_key, true), gettype($bty_bct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bty_bct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bty_bct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bty_bct_key, true)), __LINE__);
        }
        if (is_null($bty_bct_key) || (is_array($bty_bct_key) && empty($bty_bct_key))) {
            unset($this->bty_bct_key);
        } else {
            $this->bty_bct_key = $bty_bct_key;
        }
        
        return $this;
    }
    /**
     * Get bty_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_code(): ?string
    {
        return $this->bty_code ?? null;
    }
    /**
     * Set bty_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_code(?string $bty_code = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_code) && !is_string($bty_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_code, true), gettype($bty_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bty_code) && mb_strlen((string) $bty_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bty_code)), __LINE__);
        }
        if (is_null($bty_code) || (is_array($bty_code) && empty($bty_code))) {
            unset($this->bty_code);
        } else {
            $this->bty_code = $bty_code;
        }
        
        return $this;
    }
    /**
     * Get bty_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBty_description(): ?string
    {
        return $this->bty_description ?? null;
    }
    /**
     * Set bty_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bty_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_description(?string $bty_description = null): self
    {
        // validation for constraint: string
        if (!is_null($bty_description) && !is_string($bty_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bty_description, true), gettype($bty_description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bty_description) && mb_strlen((string) $bty_description) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bty_description)), __LINE__);
        }
        if (is_null($bty_description) || (is_array($bty_description) && empty($bty_description))) {
            unset($this->bty_description);
        } else {
            $this->bty_description = $bty_description;
        }
        
        return $this;
    }
    /**
     * Get bty_square_footage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBty_square_footage(): ?float
    {
        return $this->bty_square_footage ?? null;
    }
    /**
     * Set bty_square_footage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bty_square_footage
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Booth_Type_DataObjectType
     */
    public function setBty_square_footage(?float $bty_square_footage = null): self
    {
        // validation for constraint: float
        if (!is_null($bty_square_footage) && !(is_float($bty_square_footage) || is_numeric($bty_square_footage))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bty_square_footage, true), gettype($bty_square_footage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bty_square_footage) && mb_strlen(mb_substr((string) $bty_square_footage, false !== mb_strpos((string) $bty_square_footage, '.') ? mb_strpos((string) $bty_square_footage, '.') + 1 : mb_strlen((string) $bty_square_footage))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bty_square_footage, true), mb_strlen(mb_substr((string) $bty_square_footage, mb_strpos((string) $bty_square_footage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($bty_square_footage) && mb_strlen(preg_replace('/(\D)/', '', (string) $bty_square_footage)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($bty_square_footage, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bty_square_footage))), __LINE__);
        }
        if (is_null($bty_square_footage) || (is_array($bty_square_footage) && empty($bty_square_footage))) {
            unset($this->bty_square_footage);
        } else {
            $this->bty_square_footage = $bty_square_footage;
        }
        
        return $this;
    }
}
