<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorBoothNew_Exhibit_Booth_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorBoothNew_Exhibit_Booth_DataObjectType extends AbstractStructBase
{
    /**
     * The sbt_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sbt_key = null;
    /**
     * The sbt_exb_key
     * Meta information extracted from the WSDL
     * - documentation: exhibit show. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sbt_exb_key = null;
    /**
     * The sbt_bty_key
     * Meta information extracted from the WSDL
     * - documentation: booth type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sbt_bty_key = null;
    /**
     * The sbt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sbt_add_user = null;
    /**
     * The sbt_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sbt_add_date = null;
    /**
     * The sbt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sbt_change_user = null;
    /**
     * The sbt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sbt_change_date = null;
    /**
     * The sbt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sbt_delete_flag = null;
    /**
     * The sbt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sbt_entity_key = null;
    /**
     * The sbt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sbt_key_ext = null;
    /**
     * Constructor method for ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_key()
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_exb_key()
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_bty_key()
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_add_user()
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_add_date()
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_change_user()
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_change_date()
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_delete_flag()
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_entity_key()
     * @uses ExhibitorBoothNew_Exhibit_Booth_DataObjectType::setSbt_key_ext()
     * @param string $sbt_key
     * @param string $sbt_exb_key
     * @param string $sbt_bty_key
     * @param string $sbt_add_user
     * @param string $sbt_add_date
     * @param string $sbt_change_user
     * @param string $sbt_change_date
     * @param string $sbt_delete_flag
     * @param string $sbt_entity_key
     * @param string $sbt_key_ext
     */
    public function __construct(?string $sbt_key = null, ?string $sbt_exb_key = null, ?string $sbt_bty_key = null, ?string $sbt_add_user = null, ?string $sbt_add_date = null, ?string $sbt_change_user = null, ?string $sbt_change_date = null, ?string $sbt_delete_flag = null, ?string $sbt_entity_key = null, ?string $sbt_key_ext = null)
    {
        $this
            ->setSbt_key($sbt_key)
            ->setSbt_exb_key($sbt_exb_key)
            ->setSbt_bty_key($sbt_bty_key)
            ->setSbt_add_user($sbt_add_user)
            ->setSbt_add_date($sbt_add_date)
            ->setSbt_change_user($sbt_change_user)
            ->setSbt_change_date($sbt_change_date)
            ->setSbt_delete_flag($sbt_delete_flag)
            ->setSbt_entity_key($sbt_entity_key)
            ->setSbt_key_ext($sbt_key_ext);
    }
    /**
     * Get sbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_key(): ?string
    {
        return $this->sbt_key ?? null;
    }
    /**
     * Set sbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_key(?string $sbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_key) && !is_string($sbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_key, true), gettype($sbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sbt_key, true)), __LINE__);
        }
        if (is_null($sbt_key) || (is_array($sbt_key) && empty($sbt_key))) {
            unset($this->sbt_key);
        } else {
            $this->sbt_key = $sbt_key;
        }
        
        return $this;
    }
    /**
     * Get sbt_exb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_exb_key(): ?string
    {
        return $this->sbt_exb_key ?? null;
    }
    /**
     * Set sbt_exb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_exb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_exb_key(?string $sbt_exb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_exb_key) && !is_string($sbt_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_exb_key, true), gettype($sbt_exb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sbt_exb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sbt_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sbt_exb_key, true)), __LINE__);
        }
        if (is_null($sbt_exb_key) || (is_array($sbt_exb_key) && empty($sbt_exb_key))) {
            unset($this->sbt_exb_key);
        } else {
            $this->sbt_exb_key = $sbt_exb_key;
        }
        
        return $this;
    }
    /**
     * Get sbt_bty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_bty_key(): ?string
    {
        return $this->sbt_bty_key ?? null;
    }
    /**
     * Set sbt_bty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_bty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_bty_key(?string $sbt_bty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_bty_key) && !is_string($sbt_bty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_bty_key, true), gettype($sbt_bty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sbt_bty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sbt_bty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sbt_bty_key, true)), __LINE__);
        }
        if (is_null($sbt_bty_key) || (is_array($sbt_bty_key) && empty($sbt_bty_key))) {
            unset($this->sbt_bty_key);
        } else {
            $this->sbt_bty_key = $sbt_bty_key;
        }
        
        return $this;
    }
    /**
     * Get sbt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_add_user(): ?string
    {
        return $this->sbt_add_user ?? null;
    }
    /**
     * Set sbt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_add_user(?string $sbt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_add_user) && !is_string($sbt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_add_user, true), gettype($sbt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sbt_add_user) && mb_strlen((string) $sbt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $sbt_add_user)), __LINE__);
        }
        if (is_null($sbt_add_user) || (is_array($sbt_add_user) && empty($sbt_add_user))) {
            unset($this->sbt_add_user);
        } else {
            $this->sbt_add_user = $sbt_add_user;
        }
        
        return $this;
    }
    /**
     * Get sbt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_add_date(): ?string
    {
        return $this->sbt_add_date ?? null;
    }
    /**
     * Set sbt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_add_date(?string $sbt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_add_date) && !is_string($sbt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_add_date, true), gettype($sbt_add_date)), __LINE__);
        }
        if (is_null($sbt_add_date) || (is_array($sbt_add_date) && empty($sbt_add_date))) {
            unset($this->sbt_add_date);
        } else {
            $this->sbt_add_date = $sbt_add_date;
        }
        
        return $this;
    }
    /**
     * Get sbt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_change_user(): ?string
    {
        return $this->sbt_change_user ?? null;
    }
    /**
     * Set sbt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_change_user(?string $sbt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_change_user) && !is_string($sbt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_change_user, true), gettype($sbt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sbt_change_user) && mb_strlen((string) $sbt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $sbt_change_user)), __LINE__);
        }
        if (is_null($sbt_change_user) || (is_array($sbt_change_user) && empty($sbt_change_user))) {
            unset($this->sbt_change_user);
        } else {
            $this->sbt_change_user = $sbt_change_user;
        }
        
        return $this;
    }
    /**
     * Get sbt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_change_date(): ?string
    {
        return $this->sbt_change_date ?? null;
    }
    /**
     * Set sbt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_change_date(?string $sbt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_change_date) && !is_string($sbt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_change_date, true), gettype($sbt_change_date)), __LINE__);
        }
        if (is_null($sbt_change_date) || (is_array($sbt_change_date) && empty($sbt_change_date))) {
            unset($this->sbt_change_date);
        } else {
            $this->sbt_change_date = $sbt_change_date;
        }
        
        return $this;
    }
    /**
     * Get sbt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_delete_flag(): ?string
    {
        return $this->sbt_delete_flag ?? null;
    }
    /**
     * Set sbt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_delete_flag(?string $sbt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_delete_flag) && !is_string($sbt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_delete_flag, true), gettype($sbt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($sbt_delete_flag) && $sbt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($sbt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sbt_delete_flag) && $sbt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sbt_delete_flag, true)), __LINE__);
        }
        if (is_null($sbt_delete_flag) || (is_array($sbt_delete_flag) && empty($sbt_delete_flag))) {
            unset($this->sbt_delete_flag);
        } else {
            $this->sbt_delete_flag = $sbt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get sbt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_entity_key(): ?string
    {
        return $this->sbt_entity_key ?? null;
    }
    /**
     * Set sbt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_entity_key(?string $sbt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_entity_key) && !is_string($sbt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_entity_key, true), gettype($sbt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sbt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sbt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sbt_entity_key, true)), __LINE__);
        }
        if (is_null($sbt_entity_key) || (is_array($sbt_entity_key) && empty($sbt_entity_key))) {
            unset($this->sbt_entity_key);
        } else {
            $this->sbt_entity_key = $sbt_entity_key;
        }
        
        return $this;
    }
    /**
     * Get sbt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSbt_key_ext(): ?string
    {
        return $this->sbt_key_ext ?? null;
    }
    /**
     * Set sbt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sbt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Booth_DataObjectType
     */
    public function setSbt_key_ext(?string $sbt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($sbt_key_ext) && !is_string($sbt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sbt_key_ext, true), gettype($sbt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sbt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sbt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sbt_key_ext, true)), __LINE__);
        }
        if (is_null($sbt_key_ext) || (is_array($sbt_key_ext) && empty($sbt_key_ext))) {
            unset($this->sbt_key_ext);
        } else {
            $this->sbt_key_ext = $sbt_key_ext;
        }
        
        return $this;
    }
}
