<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorBoothNew_Payment_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorBoothNew_Payment_DataObjectType extends AbstractStructBase
{
    /**
     * The pay_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_key = null;
    /**
     * The pay_code
     * Meta information extracted from the WSDL
     * - documentation: Transaction Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_code = null;
    /**
     * The pay_trx_date
     * Meta information extracted from the WSDL
     * - documentation: Transaction Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_trx_date = null;
    /**
     * The pay_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_cst_key = null;
    /**
     * The pay_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_add_user = null;
    /**
     * The pay_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_add_date = null;
    /**
     * The pay_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_change_user = null;
    /**
     * The pay_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_change_date = null;
    /**
     * The pay_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_delete_flag = null;
    /**
     * The pay_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_src_key = null;
    /**
     * The pay_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_key_ext = null;
    /**
     * The pay_med_key
     * Meta information extracted from the WSDL
     * - documentation: Media Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_med_key = null;
    /**
     * The pay_post_flag
     * Meta information extracted from the WSDL
     * - documentation: Posted?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_post_flag = null;
    /**
     * The pay_bat_close_flag
     * Meta information extracted from the WSDL
     * - documentation: Batch Closed?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_bat_close_flag = null;
    /**
     * The pay_bat_key
     * Meta information extracted from the WSDL
     * - documentation: Batch. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_bat_key = null;
    /**
     * The pay_notes
     * Meta information extracted from the WSDL
     * - documentation: Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_notes = null;
    /**
     * The pay_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_entity_key = null;
    /**
     * The pay_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_cur_key = null;
    /**
     * The pay_pin_key
     * Meta information extracted from the WSDL
     * - documentation: Payment Information. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_pin_key = null;
    /**
     * The pay_charge_penalty_fee
     * Meta information extracted from the WSDL
     * - documentation: Charge Fee.This element has a default value of '0.00'. This field has this Input Mask: $$$,$$$,$$$.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $pay_charge_penalty_fee = null;
    /**
     * The pay_send_email_confirmation
     * Meta information extracted from the WSDL
     * - documentation: send email confirmation.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_send_email_confirmation = null;
    /**
     * The pay_transaction_description
     * Meta information extracted from the WSDL
     * - documentation: Transaction Description.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_transaction_description = null;
    /**
     * The pay_nsf_or_chargeback_fee_setup_exists_flag
     * Meta information extracted from the WSDL
     * - documentation: Is NSF or Chargeback product on the BU level?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_nsf_or_chargeback_fee_setup_exists_flag = null;
    /**
     * The pay_void_type
     * Meta information extracted from the WSDL
     * - documentation: Payment Void Type.This element has a default value of 'void'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_void_type = null;
    /**
     * The pay_fee_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Fee Price Key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_fee_prc_key = null;
    /**
     * The pay_new_batch_key
     * Meta information extracted from the WSDL
     * - documentation: Transaction Batch.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pay_new_batch_key = null;
    /**
     * The pay_allow_nsf_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow NSF?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_allow_nsf_flag = null;
    /**
     * The pay_allow_chargeback_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow chargeback?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_allow_chargeback_flag = null;
    /**
     * The pay_void_date
     * Meta information extracted from the WSDL
     * - documentation: Void date.This element has a default value of '07/01/2025'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pay_void_date = null;
    /**
     * Constructor method for ExhibitorBoothNew_Payment_DataObjectType
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_code()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_trx_date()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_cst_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_add_user()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_add_date()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_change_user()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_change_date()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_delete_flag()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_src_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_key_ext()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_med_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_post_flag()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_bat_close_flag()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_bat_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_notes()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_entity_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_cur_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_pin_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_charge_penalty_fee()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_send_email_confirmation()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_transaction_description()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_nsf_or_chargeback_fee_setup_exists_flag()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_void_type()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_fee_prc_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_new_batch_key()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_allow_nsf_flag()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_allow_chargeback_flag()
     * @uses ExhibitorBoothNew_Payment_DataObjectType::setPay_void_date()
     * @param string $pay_key
     * @param string $pay_code
     * @param string $pay_trx_date
     * @param string $pay_cst_key
     * @param string $pay_add_user
     * @param string $pay_add_date
     * @param string $pay_change_user
     * @param string $pay_change_date
     * @param string $pay_delete_flag
     * @param string $pay_src_key
     * @param string $pay_key_ext
     * @param string $pay_med_key
     * @param string $pay_post_flag
     * @param string $pay_bat_close_flag
     * @param string $pay_bat_key
     * @param string $pay_notes
     * @param string $pay_entity_key
     * @param string $pay_cur_key
     * @param string $pay_pin_key
     * @param float $pay_charge_penalty_fee
     * @param string $pay_send_email_confirmation
     * @param string $pay_transaction_description
     * @param string $pay_nsf_or_chargeback_fee_setup_exists_flag
     * @param string $pay_void_type
     * @param string $pay_fee_prc_key
     * @param string $pay_new_batch_key
     * @param string $pay_allow_nsf_flag
     * @param string $pay_allow_chargeback_flag
     * @param string $pay_void_date
     */
    public function __construct(?string $pay_key = null, ?string $pay_code = null, ?string $pay_trx_date = null, ?string $pay_cst_key = null, ?string $pay_add_user = null, ?string $pay_add_date = null, ?string $pay_change_user = null, ?string $pay_change_date = null, ?string $pay_delete_flag = null, ?string $pay_src_key = null, ?string $pay_key_ext = null, ?string $pay_med_key = null, ?string $pay_post_flag = null, ?string $pay_bat_close_flag = null, ?string $pay_bat_key = null, ?string $pay_notes = null, ?string $pay_entity_key = null, ?string $pay_cur_key = null, ?string $pay_pin_key = null, ?float $pay_charge_penalty_fee = null, ?string $pay_send_email_confirmation = null, ?string $pay_transaction_description = null, ?string $pay_nsf_or_chargeback_fee_setup_exists_flag = null, ?string $pay_void_type = null, ?string $pay_fee_prc_key = null, ?string $pay_new_batch_key = null, ?string $pay_allow_nsf_flag = null, ?string $pay_allow_chargeback_flag = null, ?string $pay_void_date = null)
    {
        $this
            ->setPay_key($pay_key)
            ->setPay_code($pay_code)
            ->setPay_trx_date($pay_trx_date)
            ->setPay_cst_key($pay_cst_key)
            ->setPay_add_user($pay_add_user)
            ->setPay_add_date($pay_add_date)
            ->setPay_change_user($pay_change_user)
            ->setPay_change_date($pay_change_date)
            ->setPay_delete_flag($pay_delete_flag)
            ->setPay_src_key($pay_src_key)
            ->setPay_key_ext($pay_key_ext)
            ->setPay_med_key($pay_med_key)
            ->setPay_post_flag($pay_post_flag)
            ->setPay_bat_close_flag($pay_bat_close_flag)
            ->setPay_bat_key($pay_bat_key)
            ->setPay_notes($pay_notes)
            ->setPay_entity_key($pay_entity_key)
            ->setPay_cur_key($pay_cur_key)
            ->setPay_pin_key($pay_pin_key)
            ->setPay_charge_penalty_fee($pay_charge_penalty_fee)
            ->setPay_send_email_confirmation($pay_send_email_confirmation)
            ->setPay_transaction_description($pay_transaction_description)
            ->setPay_nsf_or_chargeback_fee_setup_exists_flag($pay_nsf_or_chargeback_fee_setup_exists_flag)
            ->setPay_void_type($pay_void_type)
            ->setPay_fee_prc_key($pay_fee_prc_key)
            ->setPay_new_batch_key($pay_new_batch_key)
            ->setPay_allow_nsf_flag($pay_allow_nsf_flag)
            ->setPay_allow_chargeback_flag($pay_allow_chargeback_flag)
            ->setPay_void_date($pay_void_date);
    }
    /**
     * Get pay_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_key(): ?string
    {
        return $this->pay_key ?? null;
    }
    /**
     * Set pay_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_key(?string $pay_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_key) && !is_string($pay_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_key, true), gettype($pay_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_key, true)), __LINE__);
        }
        if (is_null($pay_key) || (is_array($pay_key) && empty($pay_key))) {
            unset($this->pay_key);
        } else {
            $this->pay_key = $pay_key;
        }
        
        return $this;
    }
    /**
     * Get pay_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_code(): ?string
    {
        return $this->pay_code ?? null;
    }
    /**
     * Set pay_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_code(?string $pay_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_code) && !is_string($pay_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_code, true), gettype($pay_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($pay_code) && mb_strlen((string) $pay_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $pay_code)), __LINE__);
        }
        if (is_null($pay_code) || (is_array($pay_code) && empty($pay_code))) {
            unset($this->pay_code);
        } else {
            $this->pay_code = $pay_code;
        }
        
        return $this;
    }
    /**
     * Get pay_trx_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_trx_date(): ?string
    {
        return $this->pay_trx_date ?? null;
    }
    /**
     * Set pay_trx_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_trx_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_trx_date(?string $pay_trx_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_trx_date) && !is_string($pay_trx_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_trx_date, true), gettype($pay_trx_date)), __LINE__);
        }
        if (is_null($pay_trx_date) || (is_array($pay_trx_date) && empty($pay_trx_date))) {
            unset($this->pay_trx_date);
        } else {
            $this->pay_trx_date = $pay_trx_date;
        }
        
        return $this;
    }
    /**
     * Get pay_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_cst_key(): ?string
    {
        return $this->pay_cst_key ?? null;
    }
    /**
     * Set pay_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_cst_key(?string $pay_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_cst_key) && !is_string($pay_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_cst_key, true), gettype($pay_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_cst_key, true)), __LINE__);
        }
        if (is_null($pay_cst_key) || (is_array($pay_cst_key) && empty($pay_cst_key))) {
            unset($this->pay_cst_key);
        } else {
            $this->pay_cst_key = $pay_cst_key;
        }
        
        return $this;
    }
    /**
     * Get pay_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_add_user(): ?string
    {
        return $this->pay_add_user ?? null;
    }
    /**
     * Set pay_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_add_user(?string $pay_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_add_user) && !is_string($pay_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_add_user, true), gettype($pay_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pay_add_user) && mb_strlen((string) $pay_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pay_add_user)), __LINE__);
        }
        if (is_null($pay_add_user) || (is_array($pay_add_user) && empty($pay_add_user))) {
            unset($this->pay_add_user);
        } else {
            $this->pay_add_user = $pay_add_user;
        }
        
        return $this;
    }
    /**
     * Get pay_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_add_date(): ?string
    {
        return $this->pay_add_date ?? null;
    }
    /**
     * Set pay_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_add_date(?string $pay_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_add_date) && !is_string($pay_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_add_date, true), gettype($pay_add_date)), __LINE__);
        }
        if (is_null($pay_add_date) || (is_array($pay_add_date) && empty($pay_add_date))) {
            unset($this->pay_add_date);
        } else {
            $this->pay_add_date = $pay_add_date;
        }
        
        return $this;
    }
    /**
     * Get pay_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_change_user(): ?string
    {
        return $this->pay_change_user ?? null;
    }
    /**
     * Set pay_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_change_user(?string $pay_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_change_user) && !is_string($pay_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_change_user, true), gettype($pay_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pay_change_user) && mb_strlen((string) $pay_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pay_change_user)), __LINE__);
        }
        if (is_null($pay_change_user) || (is_array($pay_change_user) && empty($pay_change_user))) {
            unset($this->pay_change_user);
        } else {
            $this->pay_change_user = $pay_change_user;
        }
        
        return $this;
    }
    /**
     * Get pay_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_change_date(): ?string
    {
        return $this->pay_change_date ?? null;
    }
    /**
     * Set pay_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_change_date(?string $pay_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_change_date) && !is_string($pay_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_change_date, true), gettype($pay_change_date)), __LINE__);
        }
        if (is_null($pay_change_date) || (is_array($pay_change_date) && empty($pay_change_date))) {
            unset($this->pay_change_date);
        } else {
            $this->pay_change_date = $pay_change_date;
        }
        
        return $this;
    }
    /**
     * Get pay_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_delete_flag(): ?string
    {
        return $this->pay_delete_flag ?? null;
    }
    /**
     * Set pay_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_delete_flag(?string $pay_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_delete_flag) && !is_string($pay_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_delete_flag, true), gettype($pay_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pay_delete_flag) && $pay_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pay_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pay_delete_flag) && $pay_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pay_delete_flag, true)), __LINE__);
        }
        if (is_null($pay_delete_flag) || (is_array($pay_delete_flag) && empty($pay_delete_flag))) {
            unset($this->pay_delete_flag);
        } else {
            $this->pay_delete_flag = $pay_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get pay_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_src_key(): ?string
    {
        return $this->pay_src_key ?? null;
    }
    /**
     * Set pay_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_src_key(?string $pay_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_src_key) && !is_string($pay_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_src_key, true), gettype($pay_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_src_key, true)), __LINE__);
        }
        if (is_null($pay_src_key) || (is_array($pay_src_key) && empty($pay_src_key))) {
            unset($this->pay_src_key);
        } else {
            $this->pay_src_key = $pay_src_key;
        }
        
        return $this;
    }
    /**
     * Get pay_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_key_ext(): ?string
    {
        return $this->pay_key_ext ?? null;
    }
    /**
     * Set pay_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_key_ext(?string $pay_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_key_ext) && !is_string($pay_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_key_ext, true), gettype($pay_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_key_ext, true)), __LINE__);
        }
        if (is_null($pay_key_ext) || (is_array($pay_key_ext) && empty($pay_key_ext))) {
            unset($this->pay_key_ext);
        } else {
            $this->pay_key_ext = $pay_key_ext;
        }
        
        return $this;
    }
    /**
     * Get pay_med_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_med_key(): ?string
    {
        return $this->pay_med_key ?? null;
    }
    /**
     * Set pay_med_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_med_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_med_key(?string $pay_med_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_med_key) && !is_string($pay_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_med_key, true), gettype($pay_med_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_med_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_med_key, true)), __LINE__);
        }
        if (is_null($pay_med_key) || (is_array($pay_med_key) && empty($pay_med_key))) {
            unset($this->pay_med_key);
        } else {
            $this->pay_med_key = $pay_med_key;
        }
        
        return $this;
    }
    /**
     * Get pay_post_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_post_flag(): ?string
    {
        return $this->pay_post_flag ?? null;
    }
    /**
     * Set pay_post_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_post_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_post_flag(?string $pay_post_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_post_flag) && !is_string($pay_post_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_post_flag, true), gettype($pay_post_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pay_post_flag) && $pay_post_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pay_post_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pay_post_flag) && $pay_post_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pay_post_flag, true)), __LINE__);
        }
        if (is_null($pay_post_flag) || (is_array($pay_post_flag) && empty($pay_post_flag))) {
            unset($this->pay_post_flag);
        } else {
            $this->pay_post_flag = $pay_post_flag;
        }
        
        return $this;
    }
    /**
     * Get pay_bat_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_bat_close_flag(): ?string
    {
        return $this->pay_bat_close_flag ?? null;
    }
    /**
     * Set pay_bat_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_bat_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_bat_close_flag(?string $pay_bat_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_bat_close_flag) && !is_string($pay_bat_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_bat_close_flag, true), gettype($pay_bat_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pay_bat_close_flag) && $pay_bat_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pay_bat_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pay_bat_close_flag) && $pay_bat_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pay_bat_close_flag, true)), __LINE__);
        }
        if (is_null($pay_bat_close_flag) || (is_array($pay_bat_close_flag) && empty($pay_bat_close_flag))) {
            unset($this->pay_bat_close_flag);
        } else {
            $this->pay_bat_close_flag = $pay_bat_close_flag;
        }
        
        return $this;
    }
    /**
     * Get pay_bat_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_bat_key(): ?string
    {
        return $this->pay_bat_key ?? null;
    }
    /**
     * Set pay_bat_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_bat_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_bat_key(?string $pay_bat_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_bat_key) && !is_string($pay_bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_bat_key, true), gettype($pay_bat_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_bat_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_bat_key, true)), __LINE__);
        }
        if (is_null($pay_bat_key) || (is_array($pay_bat_key) && empty($pay_bat_key))) {
            unset($this->pay_bat_key);
        } else {
            $this->pay_bat_key = $pay_bat_key;
        }
        
        return $this;
    }
    /**
     * Get pay_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_notes(): ?string
    {
        return $this->pay_notes ?? null;
    }
    /**
     * Set pay_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_notes(?string $pay_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_notes) && !is_string($pay_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_notes, true), gettype($pay_notes)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($pay_notes) && mb_strlen((string) $pay_notes) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $pay_notes)), __LINE__);
        }
        if (is_null($pay_notes) || (is_array($pay_notes) && empty($pay_notes))) {
            unset($this->pay_notes);
        } else {
            $this->pay_notes = $pay_notes;
        }
        
        return $this;
    }
    /**
     * Get pay_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_entity_key(): ?string
    {
        return $this->pay_entity_key ?? null;
    }
    /**
     * Set pay_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_entity_key(?string $pay_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_entity_key) && !is_string($pay_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_entity_key, true), gettype($pay_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_entity_key, true)), __LINE__);
        }
        if (is_null($pay_entity_key) || (is_array($pay_entity_key) && empty($pay_entity_key))) {
            unset($this->pay_entity_key);
        } else {
            $this->pay_entity_key = $pay_entity_key;
        }
        
        return $this;
    }
    /**
     * Get pay_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_cur_key(): ?string
    {
        return $this->pay_cur_key ?? null;
    }
    /**
     * Set pay_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_cur_key(?string $pay_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_cur_key) && !is_string($pay_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_cur_key, true), gettype($pay_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_cur_key, true)), __LINE__);
        }
        if (is_null($pay_cur_key) || (is_array($pay_cur_key) && empty($pay_cur_key))) {
            unset($this->pay_cur_key);
        } else {
            $this->pay_cur_key = $pay_cur_key;
        }
        
        return $this;
    }
    /**
     * Get pay_pin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_pin_key(): ?string
    {
        return $this->pay_pin_key ?? null;
    }
    /**
     * Set pay_pin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_pin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_pin_key(?string $pay_pin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_pin_key) && !is_string($pay_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_pin_key, true), gettype($pay_pin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_pin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_pin_key, true)), __LINE__);
        }
        if (is_null($pay_pin_key) || (is_array($pay_pin_key) && empty($pay_pin_key))) {
            unset($this->pay_pin_key);
        } else {
            $this->pay_pin_key = $pay_pin_key;
        }
        
        return $this;
    }
    /**
     * Get pay_charge_penalty_fee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPay_charge_penalty_fee(): ?float
    {
        return $this->pay_charge_penalty_fee ?? null;
    }
    /**
     * Set pay_charge_penalty_fee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pay_charge_penalty_fee
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_charge_penalty_fee(?float $pay_charge_penalty_fee = null): self
    {
        // validation for constraint: float
        if (!is_null($pay_charge_penalty_fee) && !(is_float($pay_charge_penalty_fee) || is_numeric($pay_charge_penalty_fee))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pay_charge_penalty_fee, true), gettype($pay_charge_penalty_fee)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pay_charge_penalty_fee) && mb_strlen(mb_substr((string) $pay_charge_penalty_fee, false !== mb_strpos((string) $pay_charge_penalty_fee, '.') ? mb_strpos((string) $pay_charge_penalty_fee, '.') + 1 : mb_strlen((string) $pay_charge_penalty_fee))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pay_charge_penalty_fee, true), mb_strlen(mb_substr((string) $pay_charge_penalty_fee, mb_strpos((string) $pay_charge_penalty_fee, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($pay_charge_penalty_fee) && mb_strlen(preg_replace('/(\D)/', '', (string) $pay_charge_penalty_fee)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($pay_charge_penalty_fee, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pay_charge_penalty_fee))), __LINE__);
        }
        if (is_null($pay_charge_penalty_fee) || (is_array($pay_charge_penalty_fee) && empty($pay_charge_penalty_fee))) {
            unset($this->pay_charge_penalty_fee);
        } else {
            $this->pay_charge_penalty_fee = $pay_charge_penalty_fee;
        }
        
        return $this;
    }
    /**
     * Get pay_send_email_confirmation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_send_email_confirmation(): ?string
    {
        return $this->pay_send_email_confirmation ?? null;
    }
    /**
     * Set pay_send_email_confirmation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_send_email_confirmation
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_send_email_confirmation(?string $pay_send_email_confirmation = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_send_email_confirmation) && !is_string($pay_send_email_confirmation)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_send_email_confirmation, true), gettype($pay_send_email_confirmation)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pay_send_email_confirmation) && $pay_send_email_confirmation > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pay_send_email_confirmation, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pay_send_email_confirmation) && $pay_send_email_confirmation < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pay_send_email_confirmation, true)), __LINE__);
        }
        if (is_null($pay_send_email_confirmation) || (is_array($pay_send_email_confirmation) && empty($pay_send_email_confirmation))) {
            unset($this->pay_send_email_confirmation);
        } else {
            $this->pay_send_email_confirmation = $pay_send_email_confirmation;
        }
        
        return $this;
    }
    /**
     * Get pay_transaction_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_transaction_description(): ?string
    {
        return $this->pay_transaction_description ?? null;
    }
    /**
     * Set pay_transaction_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_transaction_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_transaction_description(?string $pay_transaction_description = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_transaction_description) && !is_string($pay_transaction_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_transaction_description, true), gettype($pay_transaction_description)), __LINE__);
        }
        if (is_null($pay_transaction_description) || (is_array($pay_transaction_description) && empty($pay_transaction_description))) {
            unset($this->pay_transaction_description);
        } else {
            $this->pay_transaction_description = $pay_transaction_description;
        }
        
        return $this;
    }
    /**
     * Get pay_nsf_or_chargeback_fee_setup_exists_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_nsf_or_chargeback_fee_setup_exists_flag(): ?string
    {
        return $this->pay_nsf_or_chargeback_fee_setup_exists_flag ?? null;
    }
    /**
     * Set pay_nsf_or_chargeback_fee_setup_exists_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_nsf_or_chargeback_fee_setup_exists_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_nsf_or_chargeback_fee_setup_exists_flag(?string $pay_nsf_or_chargeback_fee_setup_exists_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_nsf_or_chargeback_fee_setup_exists_flag) && !is_string($pay_nsf_or_chargeback_fee_setup_exists_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_nsf_or_chargeback_fee_setup_exists_flag, true), gettype($pay_nsf_or_chargeback_fee_setup_exists_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pay_nsf_or_chargeback_fee_setup_exists_flag) && $pay_nsf_or_chargeback_fee_setup_exists_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pay_nsf_or_chargeback_fee_setup_exists_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pay_nsf_or_chargeback_fee_setup_exists_flag) && $pay_nsf_or_chargeback_fee_setup_exists_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pay_nsf_or_chargeback_fee_setup_exists_flag, true)), __LINE__);
        }
        if (is_null($pay_nsf_or_chargeback_fee_setup_exists_flag) || (is_array($pay_nsf_or_chargeback_fee_setup_exists_flag) && empty($pay_nsf_or_chargeback_fee_setup_exists_flag))) {
            unset($this->pay_nsf_or_chargeback_fee_setup_exists_flag);
        } else {
            $this->pay_nsf_or_chargeback_fee_setup_exists_flag = $pay_nsf_or_chargeback_fee_setup_exists_flag;
        }
        
        return $this;
    }
    /**
     * Get pay_void_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_void_type(): ?string
    {
        return $this->pay_void_type ?? null;
    }
    /**
     * Set pay_void_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_void_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_void_type(?string $pay_void_type = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_void_type) && !is_string($pay_void_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_void_type, true), gettype($pay_void_type)), __LINE__);
        }
        if (is_null($pay_void_type) || (is_array($pay_void_type) && empty($pay_void_type))) {
            unset($this->pay_void_type);
        } else {
            $this->pay_void_type = $pay_void_type;
        }
        
        return $this;
    }
    /**
     * Get pay_fee_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_fee_prc_key(): ?string
    {
        return $this->pay_fee_prc_key ?? null;
    }
    /**
     * Set pay_fee_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_fee_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_fee_prc_key(?string $pay_fee_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_fee_prc_key) && !is_string($pay_fee_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_fee_prc_key, true), gettype($pay_fee_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_fee_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_fee_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_fee_prc_key, true)), __LINE__);
        }
        if (is_null($pay_fee_prc_key) || (is_array($pay_fee_prc_key) && empty($pay_fee_prc_key))) {
            unset($this->pay_fee_prc_key);
        } else {
            $this->pay_fee_prc_key = $pay_fee_prc_key;
        }
        
        return $this;
    }
    /**
     * Get pay_new_batch_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_new_batch_key(): ?string
    {
        return $this->pay_new_batch_key ?? null;
    }
    /**
     * Set pay_new_batch_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_new_batch_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_new_batch_key(?string $pay_new_batch_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_new_batch_key) && !is_string($pay_new_batch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_new_batch_key, true), gettype($pay_new_batch_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pay_new_batch_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pay_new_batch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pay_new_batch_key, true)), __LINE__);
        }
        if (is_null($pay_new_batch_key) || (is_array($pay_new_batch_key) && empty($pay_new_batch_key))) {
            unset($this->pay_new_batch_key);
        } else {
            $this->pay_new_batch_key = $pay_new_batch_key;
        }
        
        return $this;
    }
    /**
     * Get pay_allow_nsf_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_allow_nsf_flag(): ?string
    {
        return $this->pay_allow_nsf_flag ?? null;
    }
    /**
     * Set pay_allow_nsf_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_allow_nsf_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_allow_nsf_flag(?string $pay_allow_nsf_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_allow_nsf_flag) && !is_string($pay_allow_nsf_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_allow_nsf_flag, true), gettype($pay_allow_nsf_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pay_allow_nsf_flag) && $pay_allow_nsf_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pay_allow_nsf_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pay_allow_nsf_flag) && $pay_allow_nsf_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pay_allow_nsf_flag, true)), __LINE__);
        }
        if (is_null($pay_allow_nsf_flag) || (is_array($pay_allow_nsf_flag) && empty($pay_allow_nsf_flag))) {
            unset($this->pay_allow_nsf_flag);
        } else {
            $this->pay_allow_nsf_flag = $pay_allow_nsf_flag;
        }
        
        return $this;
    }
    /**
     * Get pay_allow_chargeback_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_allow_chargeback_flag(): ?string
    {
        return $this->pay_allow_chargeback_flag ?? null;
    }
    /**
     * Set pay_allow_chargeback_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_allow_chargeback_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_allow_chargeback_flag(?string $pay_allow_chargeback_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_allow_chargeback_flag) && !is_string($pay_allow_chargeback_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_allow_chargeback_flag, true), gettype($pay_allow_chargeback_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pay_allow_chargeback_flag) && $pay_allow_chargeback_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pay_allow_chargeback_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pay_allow_chargeback_flag) && $pay_allow_chargeback_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pay_allow_chargeback_flag, true)), __LINE__);
        }
        if (is_null($pay_allow_chargeback_flag) || (is_array($pay_allow_chargeback_flag) && empty($pay_allow_chargeback_flag))) {
            unset($this->pay_allow_chargeback_flag);
        } else {
            $this->pay_allow_chargeback_flag = $pay_allow_chargeback_flag;
        }
        
        return $this;
    }
    /**
     * Get pay_void_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPay_void_date(): ?string
    {
        return $this->pay_void_date ?? null;
    }
    /**
     * Set pay_void_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pay_void_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Payment_DataObjectType
     */
    public function setPay_void_date(?string $pay_void_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pay_void_date) && !is_string($pay_void_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pay_void_date, true), gettype($pay_void_date)), __LINE__);
        }
        if (is_null($pay_void_date) || (is_array($pay_void_date) && empty($pay_void_date))) {
            unset($this->pay_void_date);
        } else {
            $this->pay_void_date = $pay_void_date;
        }
        
        return $this;
    }
}
