<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_Booth_Person_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_Booth_Person_DataObjectType extends AbstractStructBase
{
    /**
     * The bpr_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_key = null;
    /**
     * The bpr_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Booth Person. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_cst_key = null;
    /**
     * The bpr_exh_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_exh_key = null;
    /**
     * The bpr_evt_key
     * Meta information extracted from the WSDL
     * - documentation: Event. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_evt_key = null;
    /**
     * The bpr_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Registration key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_reg_key = null;
    /**
     * The bpr_badge_name
     * Meta information extracted from the WSDL
     * - documentation: Badge Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_badge_name = null;
    /**
     * The bpr_org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Organization. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_org_cst_key = null;
    /**
     * The bpr_pref_comm_method
     * Meta information extracted from the WSDL
     * - documentation: pref comm method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_pref_comm_method = null;
    /**
     * The bpr_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_cxa_key = null;
    /**
     * The bpr_cph_key
     * Meta information extracted from the WSDL
     * - documentation: phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_cph_key = null;
    /**
     * The bpr_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_cfx_key = null;
    /**
     * The bpr_url_key
     * Meta information extracted from the WSDL
     * - documentation: url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_url_key = null;
    /**
     * The bpr_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_add_user = null;
    /**
     * The bpr_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_add_date = null;
    /**
     * The bpr_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_change_user = null;
    /**
     * The bpr_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_change_date = null;
    /**
     * The bpr_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_delete_flag = null;
    /**
     * The bpr_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_key_ext = null;
    /**
     * The bpr_eml_key
     * Meta information extracted from the WSDL
     * - documentation: E-mail Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_eml_key = null;
    /**
     * The bpr_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_entity_key = null;
    /**
     * The bpr_hxb_key
     * Meta information extracted from the WSDL
     * - documentation: Booth. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_hxb_key = null;
    /**
     * The bpr_type
     * Meta information extracted from the WSDL
     * - documentation: Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_type = null;
    /**
     * The bpr_inv_code
     * Meta information extracted from the WSDL
     * - documentation: invoice code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_inv_code = null;
    /**
     * The bpr_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: invoice detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_ivd_key = null;
    /**
     * The bpr_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: cancel date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bpr_cancel_date = null;
    /**
     * The bpr_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bpr_odd_key = null;
    /**
     * Constructor method for ExhibitorNew_Booth_Person_DataObjectType
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_cst_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_exh_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_evt_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_reg_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_badge_name()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_org_cst_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_pref_comm_method()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_cxa_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_cph_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_cfx_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_url_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_add_user()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_add_date()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_change_user()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_change_date()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_delete_flag()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_key_ext()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_eml_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_entity_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_hxb_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_type()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_inv_code()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_ivd_key()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_cancel_date()
     * @uses ExhibitorNew_Booth_Person_DataObjectType::setBpr_odd_key()
     * @param string $bpr_key
     * @param string $bpr_cst_key
     * @param string $bpr_exh_key
     * @param string $bpr_evt_key
     * @param string $bpr_reg_key
     * @param string $bpr_badge_name
     * @param string $bpr_org_cst_key
     * @param string $bpr_pref_comm_method
     * @param string $bpr_cxa_key
     * @param string $bpr_cph_key
     * @param string $bpr_cfx_key
     * @param string $bpr_url_key
     * @param string $bpr_add_user
     * @param string $bpr_add_date
     * @param string $bpr_change_user
     * @param string $bpr_change_date
     * @param string $bpr_delete_flag
     * @param string $bpr_key_ext
     * @param string $bpr_eml_key
     * @param string $bpr_entity_key
     * @param string $bpr_hxb_key
     * @param string $bpr_type
     * @param string $bpr_inv_code
     * @param string $bpr_ivd_key
     * @param string $bpr_cancel_date
     * @param string $bpr_odd_key
     */
    public function __construct(?string $bpr_key = null, ?string $bpr_cst_key = null, ?string $bpr_exh_key = null, ?string $bpr_evt_key = null, ?string $bpr_reg_key = null, ?string $bpr_badge_name = null, ?string $bpr_org_cst_key = null, ?string $bpr_pref_comm_method = null, ?string $bpr_cxa_key = null, ?string $bpr_cph_key = null, ?string $bpr_cfx_key = null, ?string $bpr_url_key = null, ?string $bpr_add_user = null, ?string $bpr_add_date = null, ?string $bpr_change_user = null, ?string $bpr_change_date = null, ?string $bpr_delete_flag = null, ?string $bpr_key_ext = null, ?string $bpr_eml_key = null, ?string $bpr_entity_key = null, ?string $bpr_hxb_key = null, ?string $bpr_type = null, ?string $bpr_inv_code = null, ?string $bpr_ivd_key = null, ?string $bpr_cancel_date = null, ?string $bpr_odd_key = null)
    {
        $this
            ->setBpr_key($bpr_key)
            ->setBpr_cst_key($bpr_cst_key)
            ->setBpr_exh_key($bpr_exh_key)
            ->setBpr_evt_key($bpr_evt_key)
            ->setBpr_reg_key($bpr_reg_key)
            ->setBpr_badge_name($bpr_badge_name)
            ->setBpr_org_cst_key($bpr_org_cst_key)
            ->setBpr_pref_comm_method($bpr_pref_comm_method)
            ->setBpr_cxa_key($bpr_cxa_key)
            ->setBpr_cph_key($bpr_cph_key)
            ->setBpr_cfx_key($bpr_cfx_key)
            ->setBpr_url_key($bpr_url_key)
            ->setBpr_add_user($bpr_add_user)
            ->setBpr_add_date($bpr_add_date)
            ->setBpr_change_user($bpr_change_user)
            ->setBpr_change_date($bpr_change_date)
            ->setBpr_delete_flag($bpr_delete_flag)
            ->setBpr_key_ext($bpr_key_ext)
            ->setBpr_eml_key($bpr_eml_key)
            ->setBpr_entity_key($bpr_entity_key)
            ->setBpr_hxb_key($bpr_hxb_key)
            ->setBpr_type($bpr_type)
            ->setBpr_inv_code($bpr_inv_code)
            ->setBpr_ivd_key($bpr_ivd_key)
            ->setBpr_cancel_date($bpr_cancel_date)
            ->setBpr_odd_key($bpr_odd_key);
    }
    /**
     * Get bpr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_key(): ?string
    {
        return $this->bpr_key ?? null;
    }
    /**
     * Set bpr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_key(?string $bpr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_key) && !is_string($bpr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_key, true), gettype($bpr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_key, true)), __LINE__);
        }
        if (is_null($bpr_key) || (is_array($bpr_key) && empty($bpr_key))) {
            unset($this->bpr_key);
        } else {
            $this->bpr_key = $bpr_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_cst_key(): ?string
    {
        return $this->bpr_cst_key ?? null;
    }
    /**
     * Set bpr_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_cst_key(?string $bpr_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_cst_key) && !is_string($bpr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_cst_key, true), gettype($bpr_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_cst_key, true)), __LINE__);
        }
        if (is_null($bpr_cst_key) || (is_array($bpr_cst_key) && empty($bpr_cst_key))) {
            unset($this->bpr_cst_key);
        } else {
            $this->bpr_cst_key = $bpr_cst_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_exh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_exh_key(): ?string
    {
        return $this->bpr_exh_key ?? null;
    }
    /**
     * Set bpr_exh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_exh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_exh_key(?string $bpr_exh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_exh_key) && !is_string($bpr_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_exh_key, true), gettype($bpr_exh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_exh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_exh_key, true)), __LINE__);
        }
        if (is_null($bpr_exh_key) || (is_array($bpr_exh_key) && empty($bpr_exh_key))) {
            unset($this->bpr_exh_key);
        } else {
            $this->bpr_exh_key = $bpr_exh_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_evt_key(): ?string
    {
        return $this->bpr_evt_key ?? null;
    }
    /**
     * Set bpr_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_evt_key(?string $bpr_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_evt_key) && !is_string($bpr_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_evt_key, true), gettype($bpr_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_evt_key, true)), __LINE__);
        }
        if (is_null($bpr_evt_key) || (is_array($bpr_evt_key) && empty($bpr_evt_key))) {
            unset($this->bpr_evt_key);
        } else {
            $this->bpr_evt_key = $bpr_evt_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_reg_key(): ?string
    {
        return $this->bpr_reg_key ?? null;
    }
    /**
     * Set bpr_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_reg_key(?string $bpr_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_reg_key) && !is_string($bpr_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_reg_key, true), gettype($bpr_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_reg_key, true)), __LINE__);
        }
        if (is_null($bpr_reg_key) || (is_array($bpr_reg_key) && empty($bpr_reg_key))) {
            unset($this->bpr_reg_key);
        } else {
            $this->bpr_reg_key = $bpr_reg_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_badge_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_badge_name(): ?string
    {
        return $this->bpr_badge_name ?? null;
    }
    /**
     * Set bpr_badge_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_badge_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_badge_name(?string $bpr_badge_name = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_badge_name) && !is_string($bpr_badge_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_badge_name, true), gettype($bpr_badge_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bpr_badge_name) && mb_strlen((string) $bpr_badge_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $bpr_badge_name)), __LINE__);
        }
        if (is_null($bpr_badge_name) || (is_array($bpr_badge_name) && empty($bpr_badge_name))) {
            unset($this->bpr_badge_name);
        } else {
            $this->bpr_badge_name = $bpr_badge_name;
        }
        
        return $this;
    }
    /**
     * Get bpr_org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_org_cst_key(): ?string
    {
        return $this->bpr_org_cst_key ?? null;
    }
    /**
     * Set bpr_org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_org_cst_key(?string $bpr_org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_org_cst_key) && !is_string($bpr_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_org_cst_key, true), gettype($bpr_org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_org_cst_key, true)), __LINE__);
        }
        if (is_null($bpr_org_cst_key) || (is_array($bpr_org_cst_key) && empty($bpr_org_cst_key))) {
            unset($this->bpr_org_cst_key);
        } else {
            $this->bpr_org_cst_key = $bpr_org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_pref_comm_method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_pref_comm_method(): ?string
    {
        return $this->bpr_pref_comm_method ?? null;
    }
    /**
     * Set bpr_pref_comm_method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_pref_comm_method
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_pref_comm_method(?string $bpr_pref_comm_method = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_pref_comm_method) && !is_string($bpr_pref_comm_method)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_pref_comm_method, true), gettype($bpr_pref_comm_method)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($bpr_pref_comm_method) && mb_strlen((string) $bpr_pref_comm_method) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $bpr_pref_comm_method)), __LINE__);
        }
        if (is_null($bpr_pref_comm_method) || (is_array($bpr_pref_comm_method) && empty($bpr_pref_comm_method))) {
            unset($this->bpr_pref_comm_method);
        } else {
            $this->bpr_pref_comm_method = $bpr_pref_comm_method;
        }
        
        return $this;
    }
    /**
     * Get bpr_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_cxa_key(): ?string
    {
        return $this->bpr_cxa_key ?? null;
    }
    /**
     * Set bpr_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_cxa_key(?string $bpr_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_cxa_key) && !is_string($bpr_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_cxa_key, true), gettype($bpr_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_cxa_key, true)), __LINE__);
        }
        if (is_null($bpr_cxa_key) || (is_array($bpr_cxa_key) && empty($bpr_cxa_key))) {
            unset($this->bpr_cxa_key);
        } else {
            $this->bpr_cxa_key = $bpr_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_cph_key(): ?string
    {
        return $this->bpr_cph_key ?? null;
    }
    /**
     * Set bpr_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_cph_key(?string $bpr_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_cph_key) && !is_string($bpr_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_cph_key, true), gettype($bpr_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_cph_key, true)), __LINE__);
        }
        if (is_null($bpr_cph_key) || (is_array($bpr_cph_key) && empty($bpr_cph_key))) {
            unset($this->bpr_cph_key);
        } else {
            $this->bpr_cph_key = $bpr_cph_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_cfx_key(): ?string
    {
        return $this->bpr_cfx_key ?? null;
    }
    /**
     * Set bpr_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_cfx_key(?string $bpr_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_cfx_key) && !is_string($bpr_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_cfx_key, true), gettype($bpr_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_cfx_key, true)), __LINE__);
        }
        if (is_null($bpr_cfx_key) || (is_array($bpr_cfx_key) && empty($bpr_cfx_key))) {
            unset($this->bpr_cfx_key);
        } else {
            $this->bpr_cfx_key = $bpr_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_url_key(): ?string
    {
        return $this->bpr_url_key ?? null;
    }
    /**
     * Set bpr_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_url_key(?string $bpr_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_url_key) && !is_string($bpr_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_url_key, true), gettype($bpr_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_url_key, true)), __LINE__);
        }
        if (is_null($bpr_url_key) || (is_array($bpr_url_key) && empty($bpr_url_key))) {
            unset($this->bpr_url_key);
        } else {
            $this->bpr_url_key = $bpr_url_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_add_user(): ?string
    {
        return $this->bpr_add_user ?? null;
    }
    /**
     * Set bpr_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_add_user(?string $bpr_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_add_user) && !is_string($bpr_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_add_user, true), gettype($bpr_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bpr_add_user) && mb_strlen((string) $bpr_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bpr_add_user)), __LINE__);
        }
        if (is_null($bpr_add_user) || (is_array($bpr_add_user) && empty($bpr_add_user))) {
            unset($this->bpr_add_user);
        } else {
            $this->bpr_add_user = $bpr_add_user;
        }
        
        return $this;
    }
    /**
     * Get bpr_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_add_date(): ?string
    {
        return $this->bpr_add_date ?? null;
    }
    /**
     * Set bpr_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_add_date(?string $bpr_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_add_date) && !is_string($bpr_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_add_date, true), gettype($bpr_add_date)), __LINE__);
        }
        if (is_null($bpr_add_date) || (is_array($bpr_add_date) && empty($bpr_add_date))) {
            unset($this->bpr_add_date);
        } else {
            $this->bpr_add_date = $bpr_add_date;
        }
        
        return $this;
    }
    /**
     * Get bpr_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_change_user(): ?string
    {
        return $this->bpr_change_user ?? null;
    }
    /**
     * Set bpr_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_change_user(?string $bpr_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_change_user) && !is_string($bpr_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_change_user, true), gettype($bpr_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bpr_change_user) && mb_strlen((string) $bpr_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bpr_change_user)), __LINE__);
        }
        if (is_null($bpr_change_user) || (is_array($bpr_change_user) && empty($bpr_change_user))) {
            unset($this->bpr_change_user);
        } else {
            $this->bpr_change_user = $bpr_change_user;
        }
        
        return $this;
    }
    /**
     * Get bpr_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_change_date(): ?string
    {
        return $this->bpr_change_date ?? null;
    }
    /**
     * Set bpr_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_change_date(?string $bpr_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_change_date) && !is_string($bpr_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_change_date, true), gettype($bpr_change_date)), __LINE__);
        }
        if (is_null($bpr_change_date) || (is_array($bpr_change_date) && empty($bpr_change_date))) {
            unset($this->bpr_change_date);
        } else {
            $this->bpr_change_date = $bpr_change_date;
        }
        
        return $this;
    }
    /**
     * Get bpr_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_delete_flag(): ?string
    {
        return $this->bpr_delete_flag ?? null;
    }
    /**
     * Set bpr_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_delete_flag(?string $bpr_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_delete_flag) && !is_string($bpr_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_delete_flag, true), gettype($bpr_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bpr_delete_flag) && $bpr_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bpr_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bpr_delete_flag) && $bpr_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bpr_delete_flag, true)), __LINE__);
        }
        if (is_null($bpr_delete_flag) || (is_array($bpr_delete_flag) && empty($bpr_delete_flag))) {
            unset($this->bpr_delete_flag);
        } else {
            $this->bpr_delete_flag = $bpr_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get bpr_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_key_ext(): ?string
    {
        return $this->bpr_key_ext ?? null;
    }
    /**
     * Set bpr_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_key_ext(?string $bpr_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_key_ext) && !is_string($bpr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_key_ext, true), gettype($bpr_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_key_ext, true)), __LINE__);
        }
        if (is_null($bpr_key_ext) || (is_array($bpr_key_ext) && empty($bpr_key_ext))) {
            unset($this->bpr_key_ext);
        } else {
            $this->bpr_key_ext = $bpr_key_ext;
        }
        
        return $this;
    }
    /**
     * Get bpr_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_eml_key(): ?string
    {
        return $this->bpr_eml_key ?? null;
    }
    /**
     * Set bpr_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_eml_key(?string $bpr_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_eml_key) && !is_string($bpr_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_eml_key, true), gettype($bpr_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_eml_key, true)), __LINE__);
        }
        if (is_null($bpr_eml_key) || (is_array($bpr_eml_key) && empty($bpr_eml_key))) {
            unset($this->bpr_eml_key);
        } else {
            $this->bpr_eml_key = $bpr_eml_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_entity_key(): ?string
    {
        return $this->bpr_entity_key ?? null;
    }
    /**
     * Set bpr_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_entity_key(?string $bpr_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_entity_key) && !is_string($bpr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_entity_key, true), gettype($bpr_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_entity_key, true)), __LINE__);
        }
        if (is_null($bpr_entity_key) || (is_array($bpr_entity_key) && empty($bpr_entity_key))) {
            unset($this->bpr_entity_key);
        } else {
            $this->bpr_entity_key = $bpr_entity_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_hxb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_hxb_key(): ?string
    {
        return $this->bpr_hxb_key ?? null;
    }
    /**
     * Set bpr_hxb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_hxb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_hxb_key(?string $bpr_hxb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_hxb_key) && !is_string($bpr_hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_hxb_key, true), gettype($bpr_hxb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_hxb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_hxb_key, true)), __LINE__);
        }
        if (is_null($bpr_hxb_key) || (is_array($bpr_hxb_key) && empty($bpr_hxb_key))) {
            unset($this->bpr_hxb_key);
        } else {
            $this->bpr_hxb_key = $bpr_hxb_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_type(): ?string
    {
        return $this->bpr_type ?? null;
    }
    /**
     * Set bpr_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_type(?string $bpr_type = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_type) && !is_string($bpr_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_type, true), gettype($bpr_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bpr_type) && mb_strlen((string) $bpr_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bpr_type)), __LINE__);
        }
        if (is_null($bpr_type) || (is_array($bpr_type) && empty($bpr_type))) {
            unset($this->bpr_type);
        } else {
            $this->bpr_type = $bpr_type;
        }
        
        return $this;
    }
    /**
     * Get bpr_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_inv_code(): ?string
    {
        return $this->bpr_inv_code ?? null;
    }
    /**
     * Set bpr_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_inv_code(?string $bpr_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_inv_code) && !is_string($bpr_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_inv_code, true), gettype($bpr_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bpr_inv_code) && mb_strlen((string) $bpr_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bpr_inv_code)), __LINE__);
        }
        if (is_null($bpr_inv_code) || (is_array($bpr_inv_code) && empty($bpr_inv_code))) {
            unset($this->bpr_inv_code);
        } else {
            $this->bpr_inv_code = $bpr_inv_code;
        }
        
        return $this;
    }
    /**
     * Get bpr_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_ivd_key(): ?string
    {
        return $this->bpr_ivd_key ?? null;
    }
    /**
     * Set bpr_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_ivd_key(?string $bpr_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_ivd_key) && !is_string($bpr_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_ivd_key, true), gettype($bpr_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_ivd_key, true)), __LINE__);
        }
        if (is_null($bpr_ivd_key) || (is_array($bpr_ivd_key) && empty($bpr_ivd_key))) {
            unset($this->bpr_ivd_key);
        } else {
            $this->bpr_ivd_key = $bpr_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get bpr_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_cancel_date(): ?string
    {
        return $this->bpr_cancel_date ?? null;
    }
    /**
     * Set bpr_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_cancel_date(?string $bpr_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_cancel_date) && !is_string($bpr_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_cancel_date, true), gettype($bpr_cancel_date)), __LINE__);
        }
        if (is_null($bpr_cancel_date) || (is_array($bpr_cancel_date) && empty($bpr_cancel_date))) {
            unset($this->bpr_cancel_date);
        } else {
            $this->bpr_cancel_date = $bpr_cancel_date;
        }
        
        return $this;
    }
    /**
     * Get bpr_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBpr_odd_key(): ?string
    {
        return $this->bpr_odd_key ?? null;
    }
    /**
     * Set bpr_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bpr_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
     */
    public function setBpr_odd_key(?string $bpr_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bpr_odd_key) && !is_string($bpr_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bpr_odd_key, true), gettype($bpr_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bpr_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bpr_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bpr_odd_key, true)), __LINE__);
        }
        if (is_null($bpr_odd_key) || (is_array($bpr_odd_key) && empty($bpr_odd_key))) {
            unset($this->bpr_odd_key);
        } else {
            $this->bpr_odd_key = $bpr_odd_key;
        }
        
        return $this;
    }
}
