<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_Primary_Contact_Website_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_Primary_Contact_Website_DataObjectType extends AbstractStructBase
{
    /**
     * The url_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $url_key = null;
    /**
     * The url_code
     * Meta information extracted from the WSDL
     * - documentation: Website Url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 400
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $url_code = null;
    /**
     * The url_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $url_cst_key = null;
    /**
     * The url_type
     * Meta information extracted from the WSDL
     * - documentation: Website Type.This element has a default value of 'internet'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $url_type = null;
    /**
     * The url_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $url_add_user = null;
    /**
     * The url_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $url_add_date = null;
    /**
     * The url_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $url_change_user = null;
    /**
     * The url_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $url_change_date = null;
    /**
     * The url_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $url_delete_flag = null;
    /**
     * The url_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $url_key_ext = null;
    /**
     * The url_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $url_entity_key = null;
    /**
     * Constructor method for ExhibitorNew_Primary_Contact_Website_DataObjectType
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_key()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_code()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_cst_key()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_type()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_add_user()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_add_date()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_change_user()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_change_date()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_delete_flag()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_key_ext()
     * @uses ExhibitorNew_Primary_Contact_Website_DataObjectType::setUrl_entity_key()
     * @param string $url_key
     * @param string $url_code
     * @param string $url_cst_key
     * @param string $url_type
     * @param string $url_add_user
     * @param string $url_add_date
     * @param string $url_change_user
     * @param string $url_change_date
     * @param string $url_delete_flag
     * @param string $url_key_ext
     * @param string $url_entity_key
     */
    public function __construct(?string $url_key = null, ?string $url_code = null, ?string $url_cst_key = null, ?string $url_type = null, ?string $url_add_user = null, ?string $url_add_date = null, ?string $url_change_user = null, ?string $url_change_date = null, ?string $url_delete_flag = null, ?string $url_key_ext = null, ?string $url_entity_key = null)
    {
        $this
            ->setUrl_key($url_key)
            ->setUrl_code($url_code)
            ->setUrl_cst_key($url_cst_key)
            ->setUrl_type($url_type)
            ->setUrl_add_user($url_add_user)
            ->setUrl_add_date($url_add_date)
            ->setUrl_change_user($url_change_user)
            ->setUrl_change_date($url_change_date)
            ->setUrl_delete_flag($url_delete_flag)
            ->setUrl_key_ext($url_key_ext)
            ->setUrl_entity_key($url_entity_key);
    }
    /**
     * Get url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_key(): ?string
    {
        return $this->url_key ?? null;
    }
    /**
     * Set url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_key(?string $url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($url_key) && !is_string($url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_key, true), gettype($url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($url_key, true)), __LINE__);
        }
        if (is_null($url_key) || (is_array($url_key) && empty($url_key))) {
            unset($this->url_key);
        } else {
            $this->url_key = $url_key;
        }
        
        return $this;
    }
    /**
     * Get url_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_code(): ?string
    {
        return $this->url_code ?? null;
    }
    /**
     * Set url_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_code(?string $url_code = null): self
    {
        // validation for constraint: string
        if (!is_null($url_code) && !is_string($url_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_code, true), gettype($url_code)), __LINE__);
        }
        // validation for constraint: maxLength(400)
        if (!is_null($url_code) && mb_strlen((string) $url_code) > 400) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 400', mb_strlen((string) $url_code)), __LINE__);
        }
        if (is_null($url_code) || (is_array($url_code) && empty($url_code))) {
            unset($this->url_code);
        } else {
            $this->url_code = $url_code;
        }
        
        return $this;
    }
    /**
     * Get url_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_cst_key(): ?string
    {
        return $this->url_cst_key ?? null;
    }
    /**
     * Set url_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_cst_key(?string $url_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($url_cst_key) && !is_string($url_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_cst_key, true), gettype($url_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($url_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $url_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($url_cst_key, true)), __LINE__);
        }
        if (is_null($url_cst_key) || (is_array($url_cst_key) && empty($url_cst_key))) {
            unset($this->url_cst_key);
        } else {
            $this->url_cst_key = $url_cst_key;
        }
        
        return $this;
    }
    /**
     * Get url_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_type(): ?string
    {
        return $this->url_type ?? null;
    }
    /**
     * Set url_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_type(?string $url_type = null): self
    {
        // validation for constraint: string
        if (!is_null($url_type) && !is_string($url_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_type, true), gettype($url_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($url_type) && mb_strlen((string) $url_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $url_type)), __LINE__);
        }
        if (is_null($url_type) || (is_array($url_type) && empty($url_type))) {
            unset($this->url_type);
        } else {
            $this->url_type = $url_type;
        }
        
        return $this;
    }
    /**
     * Get url_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_add_user(): ?string
    {
        return $this->url_add_user ?? null;
    }
    /**
     * Set url_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_add_user(?string $url_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($url_add_user) && !is_string($url_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_add_user, true), gettype($url_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($url_add_user) && mb_strlen((string) $url_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $url_add_user)), __LINE__);
        }
        if (is_null($url_add_user) || (is_array($url_add_user) && empty($url_add_user))) {
            unset($this->url_add_user);
        } else {
            $this->url_add_user = $url_add_user;
        }
        
        return $this;
    }
    /**
     * Get url_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_add_date(): ?string
    {
        return $this->url_add_date ?? null;
    }
    /**
     * Set url_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_add_date(?string $url_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($url_add_date) && !is_string($url_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_add_date, true), gettype($url_add_date)), __LINE__);
        }
        if (is_null($url_add_date) || (is_array($url_add_date) && empty($url_add_date))) {
            unset($this->url_add_date);
        } else {
            $this->url_add_date = $url_add_date;
        }
        
        return $this;
    }
    /**
     * Get url_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_change_user(): ?string
    {
        return $this->url_change_user ?? null;
    }
    /**
     * Set url_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_change_user(?string $url_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($url_change_user) && !is_string($url_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_change_user, true), gettype($url_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($url_change_user) && mb_strlen((string) $url_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $url_change_user)), __LINE__);
        }
        if (is_null($url_change_user) || (is_array($url_change_user) && empty($url_change_user))) {
            unset($this->url_change_user);
        } else {
            $this->url_change_user = $url_change_user;
        }
        
        return $this;
    }
    /**
     * Get url_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_change_date(): ?string
    {
        return $this->url_change_date ?? null;
    }
    /**
     * Set url_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_change_date(?string $url_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($url_change_date) && !is_string($url_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_change_date, true), gettype($url_change_date)), __LINE__);
        }
        if (is_null($url_change_date) || (is_array($url_change_date) && empty($url_change_date))) {
            unset($this->url_change_date);
        } else {
            $this->url_change_date = $url_change_date;
        }
        
        return $this;
    }
    /**
     * Get url_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_delete_flag(): ?string
    {
        return $this->url_delete_flag ?? null;
    }
    /**
     * Set url_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_delete_flag(?string $url_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($url_delete_flag) && !is_string($url_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_delete_flag, true), gettype($url_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($url_delete_flag) && $url_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($url_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($url_delete_flag) && $url_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($url_delete_flag, true)), __LINE__);
        }
        if (is_null($url_delete_flag) || (is_array($url_delete_flag) && empty($url_delete_flag))) {
            unset($this->url_delete_flag);
        } else {
            $this->url_delete_flag = $url_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get url_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_key_ext(): ?string
    {
        return $this->url_key_ext ?? null;
    }
    /**
     * Set url_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_key_ext(?string $url_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($url_key_ext) && !is_string($url_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_key_ext, true), gettype($url_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($url_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $url_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($url_key_ext, true)), __LINE__);
        }
        if (is_null($url_key_ext) || (is_array($url_key_ext) && empty($url_key_ext))) {
            unset($this->url_key_ext);
        } else {
            $this->url_key_ext = $url_key_ext;
        }
        
        return $this;
    }
    /**
     * Get url_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl_entity_key(): ?string
    {
        return $this->url_entity_key ?? null;
    }
    /**
     * Set url_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
     */
    public function setUrl_entity_key(?string $url_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($url_entity_key) && !is_string($url_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url_entity_key, true), gettype($url_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($url_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $url_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($url_entity_key, true)), __LINE__);
        }
        if (is_null($url_entity_key) || (is_array($url_entity_key) && empty($url_entity_key))) {
            unset($this->url_entity_key);
        } else {
            $this->url_entity_key = $url_entity_key;
        }
        
        return $this;
    }
}
