<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_booth_complement_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_booth_complement_DataObjectType extends AbstractStructBase
{
    /**
     * The bxc_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bxc_key = null;
    /**
     * The bxc_hxb_key
     * Meta information extracted from the WSDL
     * - documentation: Booth. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bxc_hxb_key = null;
    /**
     * The bxc_ecf_prd_key
     * Meta information extracted from the WSDL
     * - documentation: complementary product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bxc_ecf_prd_key = null;
    /**
     * The bxc_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: invoice detail key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bxc_ivd_key = null;
    /**
     * The bxc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bxc_add_user = null;
    /**
     * The bxc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bxc_add_date = null;
    /**
     * The bxc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bxc_change_user = null;
    /**
     * The bxc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bxc_change_date = null;
    /**
     * The bxc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bxc_delete_flag = null;
    /**
     * The bxc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bxc_entity_key = null;
    /**
     * The bxc_inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bxc_inv_code = null;
    /**
     * The bxc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bxc_key_ext = null;
    /**
     * The bxc_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: cancel date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bxc_cancel_date = null;
    /**
     * The bxc_exb_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibit Show. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bxc_exb_key = null;
    /**
     * The bxc_odd_key
     * Meta information extracted from the WSDL
     * - documentation: order detail key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bxc_odd_key = null;
    /**
     * Constructor method for ExhibitorNew_booth_complement_DataObjectType
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_key()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_hxb_key()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_ecf_prd_key()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_ivd_key()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_add_user()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_add_date()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_change_user()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_change_date()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_delete_flag()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_entity_key()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_inv_code()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_key_ext()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_cancel_date()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_exb_key()
     * @uses ExhibitorNew_booth_complement_DataObjectType::setBxc_odd_key()
     * @param string $bxc_key
     * @param string $bxc_hxb_key
     * @param string $bxc_ecf_prd_key
     * @param string $bxc_ivd_key
     * @param string $bxc_add_user
     * @param string $bxc_add_date
     * @param string $bxc_change_user
     * @param string $bxc_change_date
     * @param string $bxc_delete_flag
     * @param string $bxc_entity_key
     * @param string $bxc_inv_code
     * @param string $bxc_key_ext
     * @param string $bxc_cancel_date
     * @param string $bxc_exb_key
     * @param string $bxc_odd_key
     */
    public function __construct(?string $bxc_key = null, ?string $bxc_hxb_key = null, ?string $bxc_ecf_prd_key = null, ?string $bxc_ivd_key = null, ?string $bxc_add_user = null, ?string $bxc_add_date = null, ?string $bxc_change_user = null, ?string $bxc_change_date = null, ?string $bxc_delete_flag = null, ?string $bxc_entity_key = null, ?string $bxc_inv_code = null, ?string $bxc_key_ext = null, ?string $bxc_cancel_date = null, ?string $bxc_exb_key = null, ?string $bxc_odd_key = null)
    {
        $this
            ->setBxc_key($bxc_key)
            ->setBxc_hxb_key($bxc_hxb_key)
            ->setBxc_ecf_prd_key($bxc_ecf_prd_key)
            ->setBxc_ivd_key($bxc_ivd_key)
            ->setBxc_add_user($bxc_add_user)
            ->setBxc_add_date($bxc_add_date)
            ->setBxc_change_user($bxc_change_user)
            ->setBxc_change_date($bxc_change_date)
            ->setBxc_delete_flag($bxc_delete_flag)
            ->setBxc_entity_key($bxc_entity_key)
            ->setBxc_inv_code($bxc_inv_code)
            ->setBxc_key_ext($bxc_key_ext)
            ->setBxc_cancel_date($bxc_cancel_date)
            ->setBxc_exb_key($bxc_exb_key)
            ->setBxc_odd_key($bxc_odd_key);
    }
    /**
     * Get bxc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_key(): ?string
    {
        return $this->bxc_key ?? null;
    }
    /**
     * Set bxc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_key(?string $bxc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_key) && !is_string($bxc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_key, true), gettype($bxc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bxc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bxc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bxc_key, true)), __LINE__);
        }
        if (is_null($bxc_key) || (is_array($bxc_key) && empty($bxc_key))) {
            unset($this->bxc_key);
        } else {
            $this->bxc_key = $bxc_key;
        }
        
        return $this;
    }
    /**
     * Get bxc_hxb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_hxb_key(): ?string
    {
        return $this->bxc_hxb_key ?? null;
    }
    /**
     * Set bxc_hxb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_hxb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_hxb_key(?string $bxc_hxb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_hxb_key) && !is_string($bxc_hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_hxb_key, true), gettype($bxc_hxb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bxc_hxb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bxc_hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bxc_hxb_key, true)), __LINE__);
        }
        if (is_null($bxc_hxb_key) || (is_array($bxc_hxb_key) && empty($bxc_hxb_key))) {
            unset($this->bxc_hxb_key);
        } else {
            $this->bxc_hxb_key = $bxc_hxb_key;
        }
        
        return $this;
    }
    /**
     * Get bxc_ecf_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_ecf_prd_key(): ?string
    {
        return $this->bxc_ecf_prd_key ?? null;
    }
    /**
     * Set bxc_ecf_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_ecf_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_ecf_prd_key(?string $bxc_ecf_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_ecf_prd_key) && !is_string($bxc_ecf_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_ecf_prd_key, true), gettype($bxc_ecf_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bxc_ecf_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bxc_ecf_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bxc_ecf_prd_key, true)), __LINE__);
        }
        if (is_null($bxc_ecf_prd_key) || (is_array($bxc_ecf_prd_key) && empty($bxc_ecf_prd_key))) {
            unset($this->bxc_ecf_prd_key);
        } else {
            $this->bxc_ecf_prd_key = $bxc_ecf_prd_key;
        }
        
        return $this;
    }
    /**
     * Get bxc_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_ivd_key(): ?string
    {
        return $this->bxc_ivd_key ?? null;
    }
    /**
     * Set bxc_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_ivd_key(?string $bxc_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_ivd_key) && !is_string($bxc_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_ivd_key, true), gettype($bxc_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bxc_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bxc_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bxc_ivd_key, true)), __LINE__);
        }
        if (is_null($bxc_ivd_key) || (is_array($bxc_ivd_key) && empty($bxc_ivd_key))) {
            unset($this->bxc_ivd_key);
        } else {
            $this->bxc_ivd_key = $bxc_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get bxc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_add_user(): ?string
    {
        return $this->bxc_add_user ?? null;
    }
    /**
     * Set bxc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_add_user(?string $bxc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_add_user) && !is_string($bxc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_add_user, true), gettype($bxc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bxc_add_user) && mb_strlen((string) $bxc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bxc_add_user)), __LINE__);
        }
        if (is_null($bxc_add_user) || (is_array($bxc_add_user) && empty($bxc_add_user))) {
            unset($this->bxc_add_user);
        } else {
            $this->bxc_add_user = $bxc_add_user;
        }
        
        return $this;
    }
    /**
     * Get bxc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_add_date(): ?string
    {
        return $this->bxc_add_date ?? null;
    }
    /**
     * Set bxc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_add_date(?string $bxc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_add_date) && !is_string($bxc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_add_date, true), gettype($bxc_add_date)), __LINE__);
        }
        if (is_null($bxc_add_date) || (is_array($bxc_add_date) && empty($bxc_add_date))) {
            unset($this->bxc_add_date);
        } else {
            $this->bxc_add_date = $bxc_add_date;
        }
        
        return $this;
    }
    /**
     * Get bxc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_change_user(): ?string
    {
        return $this->bxc_change_user ?? null;
    }
    /**
     * Set bxc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_change_user(?string $bxc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_change_user) && !is_string($bxc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_change_user, true), gettype($bxc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bxc_change_user) && mb_strlen((string) $bxc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bxc_change_user)), __LINE__);
        }
        if (is_null($bxc_change_user) || (is_array($bxc_change_user) && empty($bxc_change_user))) {
            unset($this->bxc_change_user);
        } else {
            $this->bxc_change_user = $bxc_change_user;
        }
        
        return $this;
    }
    /**
     * Get bxc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_change_date(): ?string
    {
        return $this->bxc_change_date ?? null;
    }
    /**
     * Set bxc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_change_date(?string $bxc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_change_date) && !is_string($bxc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_change_date, true), gettype($bxc_change_date)), __LINE__);
        }
        if (is_null($bxc_change_date) || (is_array($bxc_change_date) && empty($bxc_change_date))) {
            unset($this->bxc_change_date);
        } else {
            $this->bxc_change_date = $bxc_change_date;
        }
        
        return $this;
    }
    /**
     * Get bxc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_delete_flag(): ?string
    {
        return $this->bxc_delete_flag ?? null;
    }
    /**
     * Set bxc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_delete_flag(?string $bxc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_delete_flag) && !is_string($bxc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_delete_flag, true), gettype($bxc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bxc_delete_flag) && $bxc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bxc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bxc_delete_flag) && $bxc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bxc_delete_flag, true)), __LINE__);
        }
        if (is_null($bxc_delete_flag) || (is_array($bxc_delete_flag) && empty($bxc_delete_flag))) {
            unset($this->bxc_delete_flag);
        } else {
            $this->bxc_delete_flag = $bxc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get bxc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_entity_key(): ?string
    {
        return $this->bxc_entity_key ?? null;
    }
    /**
     * Set bxc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_entity_key(?string $bxc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_entity_key) && !is_string($bxc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_entity_key, true), gettype($bxc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bxc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bxc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bxc_entity_key, true)), __LINE__);
        }
        if (is_null($bxc_entity_key) || (is_array($bxc_entity_key) && empty($bxc_entity_key))) {
            unset($this->bxc_entity_key);
        } else {
            $this->bxc_entity_key = $bxc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get bxc_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_inv_code(): ?string
    {
        return $this->bxc_inv_code ?? null;
    }
    /**
     * Set bxc_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_inv_code(?string $bxc_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_inv_code) && !is_string($bxc_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_inv_code, true), gettype($bxc_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bxc_inv_code) && mb_strlen((string) $bxc_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bxc_inv_code)), __LINE__);
        }
        if (is_null($bxc_inv_code) || (is_array($bxc_inv_code) && empty($bxc_inv_code))) {
            unset($this->bxc_inv_code);
        } else {
            $this->bxc_inv_code = $bxc_inv_code;
        }
        
        return $this;
    }
    /**
     * Get bxc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_key_ext(): ?string
    {
        return $this->bxc_key_ext ?? null;
    }
    /**
     * Set bxc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_key_ext(?string $bxc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_key_ext) && !is_string($bxc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_key_ext, true), gettype($bxc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bxc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bxc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bxc_key_ext, true)), __LINE__);
        }
        if (is_null($bxc_key_ext) || (is_array($bxc_key_ext) && empty($bxc_key_ext))) {
            unset($this->bxc_key_ext);
        } else {
            $this->bxc_key_ext = $bxc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get bxc_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_cancel_date(): ?string
    {
        return $this->bxc_cancel_date ?? null;
    }
    /**
     * Set bxc_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_cancel_date(?string $bxc_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_cancel_date) && !is_string($bxc_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_cancel_date, true), gettype($bxc_cancel_date)), __LINE__);
        }
        if (is_null($bxc_cancel_date) || (is_array($bxc_cancel_date) && empty($bxc_cancel_date))) {
            unset($this->bxc_cancel_date);
        } else {
            $this->bxc_cancel_date = $bxc_cancel_date;
        }
        
        return $this;
    }
    /**
     * Get bxc_exb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_exb_key(): ?string
    {
        return $this->bxc_exb_key ?? null;
    }
    /**
     * Set bxc_exb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_exb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_exb_key(?string $bxc_exb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_exb_key) && !is_string($bxc_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_exb_key, true), gettype($bxc_exb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bxc_exb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bxc_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bxc_exb_key, true)), __LINE__);
        }
        if (is_null($bxc_exb_key) || (is_array($bxc_exb_key) && empty($bxc_exb_key))) {
            unset($this->bxc_exb_key);
        } else {
            $this->bxc_exb_key = $bxc_exb_key;
        }
        
        return $this;
    }
    /**
     * Get bxc_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBxc_odd_key(): ?string
    {
        return $this->bxc_odd_key ?? null;
    }
    /**
     * Set bxc_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bxc_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
     */
    public function setBxc_odd_key(?string $bxc_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bxc_odd_key) && !is_string($bxc_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bxc_odd_key, true), gettype($bxc_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bxc_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bxc_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bxc_odd_key, true)), __LINE__);
        }
        if (is_null($bxc_odd_key) || (is_array($bxc_odd_key) && empty($bxc_odd_key))) {
            unset($this->bxc_odd_key);
        } else {
            $this->bxc_odd_key = $bxc_odd_key;
        }
        
        return $this;
    }
}
