<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_priority_points_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_priority_points_DataObjectType extends AbstractStructBase
{
    /**
     * The ppd_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ppd_key = null;
    /**
     * The ppd_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ppd_add_user = null;
    /**
     * The ppd_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ppd_add_date = null;
    /**
     * The ppd_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ppd_change_user = null;
    /**
     * The ppd_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ppd_change_date = null;
    /**
     * The ppd_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ppd_delete_flag = null;
    /**
     * The ppd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ppd_key_ext = null;
    /**
     * The ppd_ppt_key
     * Meta information extracted from the WSDL
     * - documentation: purpose. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ppd_ppt_key = null;
    /**
     * The ppd_cst_key
     * Meta information extracted from the WSDL
     * - documentation: customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ppd_cst_key = null;
    /**
     * The ppd_priority_points
     * Meta information extracted from the WSDL
     * - documentation: priority points. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ppd_priority_points = null;
    /**
     * The ppd_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ppd_entity_key = null;
    /**
     * The ppd_exh_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ppd_exh_key = null;
    /**
     * The ppd_hxb_key
     * Meta information extracted from the WSDL
     * - documentation: Booth. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ppd_hxb_key = null;
    /**
     * Constructor method for ExhibitorNew_priority_points_DataObjectType
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_key()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_add_user()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_add_date()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_change_user()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_change_date()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_delete_flag()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_key_ext()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_ppt_key()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_cst_key()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_priority_points()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_entity_key()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_exh_key()
     * @uses ExhibitorNew_priority_points_DataObjectType::setPpd_hxb_key()
     * @param string $ppd_key
     * @param string $ppd_add_user
     * @param string $ppd_add_date
     * @param string $ppd_change_user
     * @param string $ppd_change_date
     * @param string $ppd_delete_flag
     * @param string $ppd_key_ext
     * @param string $ppd_ppt_key
     * @param string $ppd_cst_key
     * @param float $ppd_priority_points
     * @param string $ppd_entity_key
     * @param string $ppd_exh_key
     * @param string $ppd_hxb_key
     */
    public function __construct(?string $ppd_key = null, ?string $ppd_add_user = null, ?string $ppd_add_date = null, ?string $ppd_change_user = null, ?string $ppd_change_date = null, ?string $ppd_delete_flag = null, ?string $ppd_key_ext = null, ?string $ppd_ppt_key = null, ?string $ppd_cst_key = null, ?float $ppd_priority_points = null, ?string $ppd_entity_key = null, ?string $ppd_exh_key = null, ?string $ppd_hxb_key = null)
    {
        $this
            ->setPpd_key($ppd_key)
            ->setPpd_add_user($ppd_add_user)
            ->setPpd_add_date($ppd_add_date)
            ->setPpd_change_user($ppd_change_user)
            ->setPpd_change_date($ppd_change_date)
            ->setPpd_delete_flag($ppd_delete_flag)
            ->setPpd_key_ext($ppd_key_ext)
            ->setPpd_ppt_key($ppd_ppt_key)
            ->setPpd_cst_key($ppd_cst_key)
            ->setPpd_priority_points($ppd_priority_points)
            ->setPpd_entity_key($ppd_entity_key)
            ->setPpd_exh_key($ppd_exh_key)
            ->setPpd_hxb_key($ppd_hxb_key);
    }
    /**
     * Get ppd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_key(): ?string
    {
        return $this->ppd_key ?? null;
    }
    /**
     * Set ppd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_key(?string $ppd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_key) && !is_string($ppd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_key, true), gettype($ppd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ppd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ppd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ppd_key, true)), __LINE__);
        }
        if (is_null($ppd_key) || (is_array($ppd_key) && empty($ppd_key))) {
            unset($this->ppd_key);
        } else {
            $this->ppd_key = $ppd_key;
        }
        
        return $this;
    }
    /**
     * Get ppd_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_add_user(): ?string
    {
        return $this->ppd_add_user ?? null;
    }
    /**
     * Set ppd_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_add_user(?string $ppd_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_add_user) && !is_string($ppd_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_add_user, true), gettype($ppd_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ppd_add_user) && mb_strlen((string) $ppd_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ppd_add_user)), __LINE__);
        }
        if (is_null($ppd_add_user) || (is_array($ppd_add_user) && empty($ppd_add_user))) {
            unset($this->ppd_add_user);
        } else {
            $this->ppd_add_user = $ppd_add_user;
        }
        
        return $this;
    }
    /**
     * Get ppd_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_add_date(): ?string
    {
        return $this->ppd_add_date ?? null;
    }
    /**
     * Set ppd_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_add_date(?string $ppd_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_add_date) && !is_string($ppd_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_add_date, true), gettype($ppd_add_date)), __LINE__);
        }
        if (is_null($ppd_add_date) || (is_array($ppd_add_date) && empty($ppd_add_date))) {
            unset($this->ppd_add_date);
        } else {
            $this->ppd_add_date = $ppd_add_date;
        }
        
        return $this;
    }
    /**
     * Get ppd_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_change_user(): ?string
    {
        return $this->ppd_change_user ?? null;
    }
    /**
     * Set ppd_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_change_user(?string $ppd_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_change_user) && !is_string($ppd_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_change_user, true), gettype($ppd_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ppd_change_user) && mb_strlen((string) $ppd_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ppd_change_user)), __LINE__);
        }
        if (is_null($ppd_change_user) || (is_array($ppd_change_user) && empty($ppd_change_user))) {
            unset($this->ppd_change_user);
        } else {
            $this->ppd_change_user = $ppd_change_user;
        }
        
        return $this;
    }
    /**
     * Get ppd_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_change_date(): ?string
    {
        return $this->ppd_change_date ?? null;
    }
    /**
     * Set ppd_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_change_date(?string $ppd_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_change_date) && !is_string($ppd_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_change_date, true), gettype($ppd_change_date)), __LINE__);
        }
        if (is_null($ppd_change_date) || (is_array($ppd_change_date) && empty($ppd_change_date))) {
            unset($this->ppd_change_date);
        } else {
            $this->ppd_change_date = $ppd_change_date;
        }
        
        return $this;
    }
    /**
     * Get ppd_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_delete_flag(): ?string
    {
        return $this->ppd_delete_flag ?? null;
    }
    /**
     * Set ppd_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_delete_flag(?string $ppd_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_delete_flag) && !is_string($ppd_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_delete_flag, true), gettype($ppd_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ppd_delete_flag) && $ppd_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ppd_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ppd_delete_flag) && $ppd_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ppd_delete_flag, true)), __LINE__);
        }
        if (is_null($ppd_delete_flag) || (is_array($ppd_delete_flag) && empty($ppd_delete_flag))) {
            unset($this->ppd_delete_flag);
        } else {
            $this->ppd_delete_flag = $ppd_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ppd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_key_ext(): ?string
    {
        return $this->ppd_key_ext ?? null;
    }
    /**
     * Set ppd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_key_ext(?string $ppd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_key_ext) && !is_string($ppd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_key_ext, true), gettype($ppd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ppd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ppd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ppd_key_ext, true)), __LINE__);
        }
        if (is_null($ppd_key_ext) || (is_array($ppd_key_ext) && empty($ppd_key_ext))) {
            unset($this->ppd_key_ext);
        } else {
            $this->ppd_key_ext = $ppd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ppd_ppt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_ppt_key(): ?string
    {
        return $this->ppd_ppt_key ?? null;
    }
    /**
     * Set ppd_ppt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_ppt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_ppt_key(?string $ppd_ppt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_ppt_key) && !is_string($ppd_ppt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_ppt_key, true), gettype($ppd_ppt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ppd_ppt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ppd_ppt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ppd_ppt_key, true)), __LINE__);
        }
        if (is_null($ppd_ppt_key) || (is_array($ppd_ppt_key) && empty($ppd_ppt_key))) {
            unset($this->ppd_ppt_key);
        } else {
            $this->ppd_ppt_key = $ppd_ppt_key;
        }
        
        return $this;
    }
    /**
     * Get ppd_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_cst_key(): ?string
    {
        return $this->ppd_cst_key ?? null;
    }
    /**
     * Set ppd_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_cst_key(?string $ppd_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_cst_key) && !is_string($ppd_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_cst_key, true), gettype($ppd_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ppd_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ppd_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ppd_cst_key, true)), __LINE__);
        }
        if (is_null($ppd_cst_key) || (is_array($ppd_cst_key) && empty($ppd_cst_key))) {
            unset($this->ppd_cst_key);
        } else {
            $this->ppd_cst_key = $ppd_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ppd_priority_points value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPpd_priority_points(): ?float
    {
        return $this->ppd_priority_points ?? null;
    }
    /**
     * Set ppd_priority_points value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ppd_priority_points
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_priority_points(?float $ppd_priority_points = null): self
    {
        // validation for constraint: float
        if (!is_null($ppd_priority_points) && !(is_float($ppd_priority_points) || is_numeric($ppd_priority_points))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ppd_priority_points, true), gettype($ppd_priority_points)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($ppd_priority_points) && mb_strlen(mb_substr((string) $ppd_priority_points, false !== mb_strpos((string) $ppd_priority_points, '.') ? mb_strpos((string) $ppd_priority_points, '.') + 1 : mb_strlen((string) $ppd_priority_points))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($ppd_priority_points, true), mb_strlen(mb_substr((string) $ppd_priority_points, mb_strpos((string) $ppd_priority_points, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ppd_priority_points) && mb_strlen(preg_replace('/(\D)/', '', (string) $ppd_priority_points)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ppd_priority_points, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ppd_priority_points))), __LINE__);
        }
        if (is_null($ppd_priority_points) || (is_array($ppd_priority_points) && empty($ppd_priority_points))) {
            unset($this->ppd_priority_points);
        } else {
            $this->ppd_priority_points = $ppd_priority_points;
        }
        
        return $this;
    }
    /**
     * Get ppd_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_entity_key(): ?string
    {
        return $this->ppd_entity_key ?? null;
    }
    /**
     * Set ppd_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_entity_key(?string $ppd_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_entity_key) && !is_string($ppd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_entity_key, true), gettype($ppd_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ppd_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ppd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ppd_entity_key, true)), __LINE__);
        }
        if (is_null($ppd_entity_key) || (is_array($ppd_entity_key) && empty($ppd_entity_key))) {
            unset($this->ppd_entity_key);
        } else {
            $this->ppd_entity_key = $ppd_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ppd_exh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_exh_key(): ?string
    {
        return $this->ppd_exh_key ?? null;
    }
    /**
     * Set ppd_exh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_exh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_exh_key(?string $ppd_exh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_exh_key) && !is_string($ppd_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_exh_key, true), gettype($ppd_exh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ppd_exh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ppd_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ppd_exh_key, true)), __LINE__);
        }
        if (is_null($ppd_exh_key) || (is_array($ppd_exh_key) && empty($ppd_exh_key))) {
            unset($this->ppd_exh_key);
        } else {
            $this->ppd_exh_key = $ppd_exh_key;
        }
        
        return $this;
    }
    /**
     * Get ppd_hxb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPpd_hxb_key(): ?string
    {
        return $this->ppd_hxb_key ?? null;
    }
    /**
     * Set ppd_hxb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ppd_hxb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
     */
    public function setPpd_hxb_key(?string $ppd_hxb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ppd_hxb_key) && !is_string($ppd_hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppd_hxb_key, true), gettype($ppd_hxb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ppd_hxb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ppd_hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ppd_hxb_key, true)), __LINE__);
        }
        if (is_null($ppd_hxb_key) || (is_array($ppd_hxb_key) && empty($ppd_hxb_key))) {
            unset($this->ppd_hxb_key);
        } else {
            $this->ppd_hxb_key = $ppd_hxb_key;
        }
        
        return $this;
    }
}
