<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fee StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Fee extends AbstractStructBase
{
    /**
     * The prc_key
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $prc_key;
    /**
     * The ivd_key
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $ivd_key;
    /**
     * The qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    protected int $qty;
    /**
     * The overrideamount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    protected float $overrideamount;
    /**
     * The action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    protected string $action;
    /**
     * Constructor method for Fee
     * @uses Fee::setPrc_key()
     * @uses Fee::setIvd_key()
     * @uses Fee::setQty()
     * @uses Fee::setOverrideamount()
     * @uses Fee::setAction()
     * @param string $prc_key
     * @param string $ivd_key
     * @param int $qty
     * @param float $overrideamount
     * @param string $action
     */
    public function __construct(string $prc_key, string $ivd_key, int $qty, float $overrideamount, string $action)
    {
        $this
            ->setPrc_key($prc_key)
            ->setIvd_key($ivd_key)
            ->setQty($qty)
            ->setOverrideamount($overrideamount)
            ->setAction($action);
    }
    /**
     * Get prc_key value
     * @return string
     */
    public function getPrc_key(): string
    {
        return $this->prc_key;
    }
    /**
     * Set prc_key value
     * @param string $prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Fee
     */
    public function setPrc_key(string $prc_key): self
    {
        // validation for constraint: string
        if (!is_null($prc_key) && !is_string($prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_key, true), gettype($prc_key)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($prc_key) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($prc_key, true)), __LINE__);
        }
        $this->prc_key = $prc_key;
        
        return $this;
    }
    /**
     * Get ivd_key value
     * @return string
     */
    public function getIvd_key(): string
    {
        return $this->ivd_key;
    }
    /**
     * Set ivd_key value
     * @param string $ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Fee
     */
    public function setIvd_key(string $ivd_key): self
    {
        // validation for constraint: string
        if (!is_null($ivd_key) && !is_string($ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_key, true), gettype($ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($ivd_key) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($ivd_key, true)), __LINE__);
        }
        $this->ivd_key = $ivd_key;
        
        return $this;
    }
    /**
     * Get qty value
     * @return int
     */
    public function getQty(): int
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param int $qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Fee
     */
    public function setQty(int $qty): self
    {
        // validation for constraint: int
        if (!is_null($qty) && !(is_int($qty) || ctype_digit($qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->qty = $qty;
        
        return $this;
    }
    /**
     * Get overrideamount value
     * @return float
     */
    public function getOverrideamount(): float
    {
        return $this->overrideamount;
    }
    /**
     * Set overrideamount value
     * @param float $overrideamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\Fee
     */
    public function setOverrideamount(float $overrideamount): self
    {
        // validation for constraint: float
        if (!is_null($overrideamount) && !(is_float($overrideamount) || is_numeric($overrideamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overrideamount, true), gettype($overrideamount)), __LINE__);
        }
        $this->overrideamount = $overrideamount;
        
        return $this;
    }
    /**
     * Get action value
     * @return string
     */
    public function getAction(): string
    {
        return $this->action;
    }
    /**
     * Set action value
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\FeeAction::valueIsValid()
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\FeeAction::getValidValues()
     * @throws InvalidArgumentException
     * @param string $action
     * @return \Drupal\netforum\xWeb\Generated\StructType\Fee
     */
    public function setAction(string $action): self
    {
        // validation for constraint: enumeration
        if (!\Drupal\netforum\xWeb\Generated\EnumType\FeeAction::valueIsValid($action)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Drupal\netforum\xWeb\Generated\EnumType\FeeAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \Drupal\netforum\xWeb\Generated\EnumType\FeeAction::getValidValues())), __LINE__);
        }
        $this->action = $action;
        
        return $this;
    }
}
