<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fees StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Fees extends AbstractStructBase
{
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Drupal\netforum\xWeb\Generated\StructType\Fee[]|null
     */
    protected ?array $Fee = null;
    /**
     * Constructor method for Fees
     * @uses Fees::setFee()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Fee[] $fee
     */
    public function __construct(?array $fee = null)
    {
        $this
            ->setFee($fee);
    }
    /**
     * Get Fee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Drupal\netforum\xWeb\Generated\StructType\Fee[]|null
     */
    public function getFee(): ?array
    {
        return $this->Fee ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFee method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeForArrayConstraintFromSetFee(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $feesFeeItem) {
            // validation for constraint: itemType
            if (!$feesFeeItem instanceof \Drupal\netforum\xWeb\Generated\StructType\Fee) {
                $invalidValues[] = is_object($feesFeeItem) ? get_class($feesFeeItem) : sprintf('%s(%s)', gettype($feesFeeItem), var_export($feesFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fee property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Fee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set Fee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Fee[] $fee
     * @return \Drupal\netforum\xWeb\Generated\StructType\Fees
     */
    public function setFee(?array $fee = null): self
    {
        // validation for constraint: array
        if ('' !== ($feeArrayErrorMessage = self::validateFeeForArrayConstraintFromSetFee($fee))) {
            throw new InvalidArgumentException($feeArrayErrorMessage, __LINE__);
        }
        if (is_null($fee) || (is_array($fee) && empty($fee))) {
            unset($this->Fee);
        } else {
            $this->Fee = $fee;
        }
        
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Fee $item
     * @return \Drupal\netforum\xWeb\Generated\StructType\Fees
     */
    public function addToFee(\Drupal\netforum\xWeb\Generated\StructType\Fee $item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\Fee) {
            throw new InvalidArgumentException(sprintf('The Fee property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Fee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fee[] = $item;
        
        return $this;
    }
}
