<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Constituent_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Constituent_DataObjectType extends AbstractStructBase
{
    /**
     * The dnr_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_cst_key = null;
    /**
     * The dnr_alt_id
     * Meta information extracted from the WSDL
     * - documentation: Constituent Alt ID. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_alt_id = null;
    /**
     * The dnr_matchcode
     * Meta information extracted from the WSDL
     * - documentation: Constituent Matchcode. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_matchcode = null;
    /**
     * The dnr_salutation1
     * Meta information extracted from the WSDL
     * - documentation: Constituent Salutation 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_salutation1 = null;
    /**
     * The dnr_salutation2
     * Meta information extracted from the WSDL
     * - documentation: Constituent Salutation 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_salutation2 = null;
    /**
     * The dnr_salutation3
     * Meta information extracted from the WSDL
     * - documentation: Constituent Salutation 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_salutation3 = null;
    /**
     * The dnr_dcg_key
     * Meta information extracted from the WSDL
     * - documentation: Donor Category Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_dcg_key = null;
    /**
     * The dnr_rfm_join_date
     * Meta information extracted from the WSDL
     * - documentation: Join Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_rfm_join_date = null;
    /**
     * The dnr_rfm_join_source
     * Meta information extracted from the WSDL
     * - documentation: Join Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rfm_join_source = null;
    /**
     * The dnr_rfm_ytd_amt
     * Meta information extracted from the WSDL
     * - documentation: Year To Date Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $dnr_rfm_ytd_amt = null;
    /**
     * The dnr_rfm_ytd_count
     * Meta information extracted from the WSDL
     * - documentation: Year-To-Date Count. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $dnr_rfm_ytd_count = null;
    /**
     * The dnr_rfm_ly_amt
     * Meta information extracted from the WSDL
     * - documentation: Last Year Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $dnr_rfm_ly_amt = null;
    /**
     * The dnr_rfm_ly_count
     * Meta information extracted from the WSDL
     * - documentation: Last-Year Count. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $dnr_rfm_ly_count = null;
    /**
     * The dnr_rfm_ttd_amt
     * Meta information extracted from the WSDL
     * - documentation: Total To Date Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $dnr_rfm_ttd_amt = null;
    /**
     * The dnr_rfm_ttd_count
     * Meta information extracted from the WSDL
     * - documentation: Total-To-Date Count. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $dnr_rfm_ttd_count = null;
    /**
     * The dnr_rfm_highest_amt
     * Meta information extracted from the WSDL
     * - documentation: Highest Gift Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $dnr_rfm_highest_amt = null;
    /**
     * The dnr_rfm_highest_date
     * Meta information extracted from the WSDL
     * - documentation: Highest-Gift Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_rfm_highest_date = null;
    /**
     * The dnr_rfm_highest_source
     * Meta information extracted from the WSDL
     * - documentation: Highest-Gift Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rfm_highest_source = null;
    /**
     * The dnr_rfm_latest_amt
     * Meta information extracted from the WSDL
     * - documentation: Latest Gift Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $dnr_rfm_latest_amt = null;
    /**
     * The dnr_rfm_latest_date
     * Meta information extracted from the WSDL
     * - documentation: Latest-Gift Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_rfm_latest_date = null;
    /**
     * The dnr_rfm_latest_source
     * Meta information extracted from the WSDL
     * - documentation: Latest-Gift Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rfm_latest_source = null;
    /**
     * The dnr_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_add_user = null;
    /**
     * The dnr_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_add_date = null;
    /**
     * The dnr_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_change_user = null;
    /**
     * The dnr_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_change_date = null;
    /**
     * The dnr_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_delete_flag = null;
    /**
     * The dnr_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_entity_key = null;
    /**
     * The dnr_cst_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_cst_key_ext = null;
    /**
     * The dnr_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_ind_cst_key = null;
    /**
     * The dnr_rfm_first_gift_amt
     * Meta information extracted from the WSDL
     * - documentation: First Gift Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $dnr_rfm_first_gift_amt = null;
    /**
     * The dnr_vip_flag
     * Meta information extracted from the WSDL
     * - documentation: VIP Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_vip_flag = null;
    /**
     * The dnr_notes
     * Meta information extracted from the WSDL
     * - documentation: Constituent Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_notes = null;
    /**
     * The dnr_rcl_key
     * Meta information extracted from the WSDL
     * - documentation: Recognition Level. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rcl_key = null;
    /**
     * The dnr_recognition_level_override_flag
     * Meta information extracted from the WSDL
     * - documentation: Manual Override. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_recognition_level_override_flag = null;
    /**
     * The dnr_salutation4
     * Meta information extracted from the WSDL
     * - documentation: Constituent Salutation 4. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_salutation4 = null;
    /**
     * The dnr_usr_key
     * Meta information extracted from the WSDL
     * - documentation: Manager. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_usr_key = null;
    /**
     * The dnr_solicitor_cst_key
     * Meta information extracted from the WSDL
     * - documentation: solicitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_solicitor_cst_key = null;
    /**
     * The dnr_vpt_key
     * Meta information extracted from the WSDL
     * - documentation: VIP Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_vpt_key = null;
    /**
     * The dnr_gives_anonymous
     * Meta information extracted from the WSDL
     * - documentation: Give Anonymous Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_gives_anonymous = null;
    /**
     * The dnr_do_not_solicit_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Solicit. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_do_not_solicit_flag = null;
    /**
     * The dnr_rfm_first_source_code_key
     * Meta information extracted from the WSDL
     * - documentation: First Gift Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rfm_first_source_code_key = null;
    /**
     * The dnr_rfm_highest_ly_amt
     * Meta information extracted from the WSDL
     * - documentation: Highest Gift Amount Last Year. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $dnr_rfm_highest_ly_amt = null;
    /**
     * The dnr_rfm_first_appeal_key
     * Meta information extracted from the WSDL
     * - documentation: First Gift Appeal. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rfm_first_appeal_key = null;
    /**
     * The dnr_rfm_highest_ytd_date
     * Meta information extracted from the WSDL
     * - documentation: Highest current year gift date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_rfm_highest_ytd_date = null;
    /**
     * The dnr_rfm_highest_ly_date
     * Meta information extracted from the WSDL
     * - documentation: Highest last year gift date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_rfm_highest_ly_date = null;
    /**
     * The dnr_rfm_latest_source_code_key
     * Meta information extracted from the WSDL
     * - documentation: Latest Gift Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rfm_latest_source_code_key = null;
    /**
     * The dnr_rfm_highest_ytd_amt
     * Meta information extracted from the WSDL
     * - documentation: Highest Gift Amount This Year. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $dnr_rfm_highest_ytd_amt = null;
    /**
     * The dnr_rfm_latest_appeal_key
     * Meta information extracted from the WSDL
     * - documentation: Latest Gift Appeal. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rfm_latest_appeal_key = null;
    /**
     * The dnr_rfm_highest_source_code_key
     * Meta information extracted from the WSDL
     * - documentation: Highest Gift Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rfm_highest_source_code_key = null;
    /**
     * The dnr_rfm_highest_appeal_key
     * Meta information extracted from the WSDL
     * - documentation: Highest Gift Appeal. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $dnr_rfm_highest_appeal_key = null;
    /**
     * The dnr_rfm_average_amt
     * Meta information extracted from the WSDL
     * - documentation: Average Gift Amount. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $dnr_rfm_average_amt = null;
    /**
     * The dnr_cst_sort_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Constituent. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data
     * Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_cst_sort_name_dn = null;
    /**
     * The dnr_ask_amount1
     * Meta information extracted from the WSDL
     * - documentation: AskAmount1.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_ask_amount1 = null;
    /**
     * The dnr_ask_amount2
     * Meta information extracted from the WSDL
     * - documentation: AskAmount2.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_ask_amount2 = null;
    /**
     * The dnr_ask_amount3
     * Meta information extracted from the WSDL
     * - documentation: AskAmount3.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_ask_amount3 = null;
    /**
     * The dnr_ask_amount4
     * Meta information extracted from the WSDL
     * - documentation: AskAmount4.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_ask_amount4 = null;
    /**
     * The dnr_ask_amount5
     * Meta information extracted from the WSDL
     * - documentation: AskAmount5.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_ask_amount5 = null;
    /**
     * The dnr_npa_key
     * Meta information extracted from the WSDL
     * - documentation: AskLadder. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $dnr_npa_key = null;
    /**
     * The dnr_donor_year
     * Meta information extracted from the WSDL
     * - documentation: DonorYears. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $dnr_donor_year = null;
    /**
     * The dnr_membership_year
     * Meta information extracted from the WSDL
     * - documentation: MembershipYears. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $dnr_membership_year = null;
    /**
     * Constructor method for FundraisingGift_Constituent_DataObjectType
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_cst_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_alt_id()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_matchcode()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_salutation1()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_salutation2()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_salutation3()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_dcg_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_join_date()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_join_source()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_ytd_amt()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_ytd_count()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_ly_amt()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_ly_count()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_ttd_amt()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_ttd_count()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_highest_amt()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_highest_date()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_highest_source()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_latest_amt()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_latest_date()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_latest_source()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_add_user()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_add_date()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_change_user()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_change_date()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_delete_flag()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_entity_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_cst_key_ext()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_ind_cst_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_first_gift_amt()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_vip_flag()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_notes()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rcl_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_recognition_level_override_flag()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_salutation4()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_usr_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_solicitor_cst_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_vpt_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_gives_anonymous()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_do_not_solicit_flag()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_first_source_code_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_highest_ly_amt()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_first_appeal_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_highest_ytd_date()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_highest_ly_date()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_latest_source_code_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_highest_ytd_amt()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_latest_appeal_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_highest_source_code_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_highest_appeal_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_rfm_average_amt()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_cst_sort_name_dn()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_ask_amount1()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_ask_amount2()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_ask_amount3()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_ask_amount4()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_ask_amount5()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_npa_key()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_donor_year()
     * @uses FundraisingGift_Constituent_DataObjectType::setDnr_membership_year()
     * @param string $dnr_cst_key
     * @param string $dnr_alt_id
     * @param string $dnr_matchcode
     * @param string $dnr_salutation1
     * @param string $dnr_salutation2
     * @param string $dnr_salutation3
     * @param string $dnr_dcg_key
     * @param string $dnr_rfm_join_date
     * @param string $dnr_rfm_join_source
     * @param float $dnr_rfm_ytd_amt
     * @param int $dnr_rfm_ytd_count
     * @param float $dnr_rfm_ly_amt
     * @param int $dnr_rfm_ly_count
     * @param float $dnr_rfm_ttd_amt
     * @param int $dnr_rfm_ttd_count
     * @param float $dnr_rfm_highest_amt
     * @param string $dnr_rfm_highest_date
     * @param string $dnr_rfm_highest_source
     * @param float $dnr_rfm_latest_amt
     * @param string $dnr_rfm_latest_date
     * @param string $dnr_rfm_latest_source
     * @param string $dnr_add_user
     * @param string $dnr_add_date
     * @param string $dnr_change_user
     * @param string $dnr_change_date
     * @param string $dnr_delete_flag
     * @param string $dnr_entity_key
     * @param string $dnr_cst_key_ext
     * @param string $dnr_ind_cst_key
     * @param float $dnr_rfm_first_gift_amt
     * @param string $dnr_vip_flag
     * @param string $dnr_notes
     * @param string $dnr_rcl_key
     * @param string $dnr_recognition_level_override_flag
     * @param string $dnr_salutation4
     * @param string $dnr_usr_key
     * @param string $dnr_solicitor_cst_key
     * @param string $dnr_vpt_key
     * @param string $dnr_gives_anonymous
     * @param string $dnr_do_not_solicit_flag
     * @param string $dnr_rfm_first_source_code_key
     * @param float $dnr_rfm_highest_ly_amt
     * @param string $dnr_rfm_first_appeal_key
     * @param string $dnr_rfm_highest_ytd_date
     * @param string $dnr_rfm_highest_ly_date
     * @param string $dnr_rfm_latest_source_code_key
     * @param float $dnr_rfm_highest_ytd_amt
     * @param string $dnr_rfm_latest_appeal_key
     * @param string $dnr_rfm_highest_source_code_key
     * @param string $dnr_rfm_highest_appeal_key
     * @param float $dnr_rfm_average_amt
     * @param string $dnr_cst_sort_name_dn
     * @param string $dnr_ask_amount1
     * @param string $dnr_ask_amount2
     * @param string $dnr_ask_amount3
     * @param string $dnr_ask_amount4
     * @param string $dnr_ask_amount5
     * @param string $dnr_npa_key
     * @param int $dnr_donor_year
     * @param int $dnr_membership_year
     */
    public function __construct(?string $dnr_cst_key = null, ?string $dnr_alt_id = null, ?string $dnr_matchcode = null, ?string $dnr_salutation1 = null, ?string $dnr_salutation2 = null, ?string $dnr_salutation3 = null, ?string $dnr_dcg_key = null, ?string $dnr_rfm_join_date = null, ?string $dnr_rfm_join_source = null, ?float $dnr_rfm_ytd_amt = null, ?int $dnr_rfm_ytd_count = null, ?float $dnr_rfm_ly_amt = null, ?int $dnr_rfm_ly_count = null, ?float $dnr_rfm_ttd_amt = null, ?int $dnr_rfm_ttd_count = null, ?float $dnr_rfm_highest_amt = null, ?string $dnr_rfm_highest_date = null, ?string $dnr_rfm_highest_source = null, ?float $dnr_rfm_latest_amt = null, ?string $dnr_rfm_latest_date = null, ?string $dnr_rfm_latest_source = null, ?string $dnr_add_user = null, ?string $dnr_add_date = null, ?string $dnr_change_user = null, ?string $dnr_change_date = null, ?string $dnr_delete_flag = null, ?string $dnr_entity_key = null, ?string $dnr_cst_key_ext = null, ?string $dnr_ind_cst_key = null, ?float $dnr_rfm_first_gift_amt = null, ?string $dnr_vip_flag = null, ?string $dnr_notes = null, ?string $dnr_rcl_key = null, ?string $dnr_recognition_level_override_flag = null, ?string $dnr_salutation4 = null, ?string $dnr_usr_key = null, ?string $dnr_solicitor_cst_key = null, ?string $dnr_vpt_key = null, ?string $dnr_gives_anonymous = null, ?string $dnr_do_not_solicit_flag = null, ?string $dnr_rfm_first_source_code_key = null, ?float $dnr_rfm_highest_ly_amt = null, ?string $dnr_rfm_first_appeal_key = null, ?string $dnr_rfm_highest_ytd_date = null, ?string $dnr_rfm_highest_ly_date = null, ?string $dnr_rfm_latest_source_code_key = null, ?float $dnr_rfm_highest_ytd_amt = null, ?string $dnr_rfm_latest_appeal_key = null, ?string $dnr_rfm_highest_source_code_key = null, ?string $dnr_rfm_highest_appeal_key = null, ?float $dnr_rfm_average_amt = null, ?string $dnr_cst_sort_name_dn = null, ?string $dnr_ask_amount1 = null, ?string $dnr_ask_amount2 = null, ?string $dnr_ask_amount3 = null, ?string $dnr_ask_amount4 = null, ?string $dnr_ask_amount5 = null, ?string $dnr_npa_key = null, ?int $dnr_donor_year = null, ?int $dnr_membership_year = null)
    {
        $this
            ->setDnr_cst_key($dnr_cst_key)
            ->setDnr_alt_id($dnr_alt_id)
            ->setDnr_matchcode($dnr_matchcode)
            ->setDnr_salutation1($dnr_salutation1)
            ->setDnr_salutation2($dnr_salutation2)
            ->setDnr_salutation3($dnr_salutation3)
            ->setDnr_dcg_key($dnr_dcg_key)
            ->setDnr_rfm_join_date($dnr_rfm_join_date)
            ->setDnr_rfm_join_source($dnr_rfm_join_source)
            ->setDnr_rfm_ytd_amt($dnr_rfm_ytd_amt)
            ->setDnr_rfm_ytd_count($dnr_rfm_ytd_count)
            ->setDnr_rfm_ly_amt($dnr_rfm_ly_amt)
            ->setDnr_rfm_ly_count($dnr_rfm_ly_count)
            ->setDnr_rfm_ttd_amt($dnr_rfm_ttd_amt)
            ->setDnr_rfm_ttd_count($dnr_rfm_ttd_count)
            ->setDnr_rfm_highest_amt($dnr_rfm_highest_amt)
            ->setDnr_rfm_highest_date($dnr_rfm_highest_date)
            ->setDnr_rfm_highest_source($dnr_rfm_highest_source)
            ->setDnr_rfm_latest_amt($dnr_rfm_latest_amt)
            ->setDnr_rfm_latest_date($dnr_rfm_latest_date)
            ->setDnr_rfm_latest_source($dnr_rfm_latest_source)
            ->setDnr_add_user($dnr_add_user)
            ->setDnr_add_date($dnr_add_date)
            ->setDnr_change_user($dnr_change_user)
            ->setDnr_change_date($dnr_change_date)
            ->setDnr_delete_flag($dnr_delete_flag)
            ->setDnr_entity_key($dnr_entity_key)
            ->setDnr_cst_key_ext($dnr_cst_key_ext)
            ->setDnr_ind_cst_key($dnr_ind_cst_key)
            ->setDnr_rfm_first_gift_amt($dnr_rfm_first_gift_amt)
            ->setDnr_vip_flag($dnr_vip_flag)
            ->setDnr_notes($dnr_notes)
            ->setDnr_rcl_key($dnr_rcl_key)
            ->setDnr_recognition_level_override_flag($dnr_recognition_level_override_flag)
            ->setDnr_salutation4($dnr_salutation4)
            ->setDnr_usr_key($dnr_usr_key)
            ->setDnr_solicitor_cst_key($dnr_solicitor_cst_key)
            ->setDnr_vpt_key($dnr_vpt_key)
            ->setDnr_gives_anonymous($dnr_gives_anonymous)
            ->setDnr_do_not_solicit_flag($dnr_do_not_solicit_flag)
            ->setDnr_rfm_first_source_code_key($dnr_rfm_first_source_code_key)
            ->setDnr_rfm_highest_ly_amt($dnr_rfm_highest_ly_amt)
            ->setDnr_rfm_first_appeal_key($dnr_rfm_first_appeal_key)
            ->setDnr_rfm_highest_ytd_date($dnr_rfm_highest_ytd_date)
            ->setDnr_rfm_highest_ly_date($dnr_rfm_highest_ly_date)
            ->setDnr_rfm_latest_source_code_key($dnr_rfm_latest_source_code_key)
            ->setDnr_rfm_highest_ytd_amt($dnr_rfm_highest_ytd_amt)
            ->setDnr_rfm_latest_appeal_key($dnr_rfm_latest_appeal_key)
            ->setDnr_rfm_highest_source_code_key($dnr_rfm_highest_source_code_key)
            ->setDnr_rfm_highest_appeal_key($dnr_rfm_highest_appeal_key)
            ->setDnr_rfm_average_amt($dnr_rfm_average_amt)
            ->setDnr_cst_sort_name_dn($dnr_cst_sort_name_dn)
            ->setDnr_ask_amount1($dnr_ask_amount1)
            ->setDnr_ask_amount2($dnr_ask_amount2)
            ->setDnr_ask_amount3($dnr_ask_amount3)
            ->setDnr_ask_amount4($dnr_ask_amount4)
            ->setDnr_ask_amount5($dnr_ask_amount5)
            ->setDnr_npa_key($dnr_npa_key)
            ->setDnr_donor_year($dnr_donor_year)
            ->setDnr_membership_year($dnr_membership_year);
    }
    /**
     * Get dnr_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_cst_key(): ?string
    {
        return $this->dnr_cst_key ?? null;
    }
    /**
     * Set dnr_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_cst_key(?string $dnr_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_cst_key) && !is_string($dnr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_cst_key, true), gettype($dnr_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_cst_key, true)), __LINE__);
        }
        if (is_null($dnr_cst_key) || (is_array($dnr_cst_key) && empty($dnr_cst_key))) {
            unset($this->dnr_cst_key);
        } else {
            $this->dnr_cst_key = $dnr_cst_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_alt_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_alt_id(): ?string
    {
        return $this->dnr_alt_id ?? null;
    }
    /**
     * Set dnr_alt_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_alt_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_alt_id(?string $dnr_alt_id = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_alt_id) && !is_string($dnr_alt_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_alt_id, true), gettype($dnr_alt_id)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($dnr_alt_id) && mb_strlen((string) $dnr_alt_id) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $dnr_alt_id)), __LINE__);
        }
        if (is_null($dnr_alt_id) || (is_array($dnr_alt_id) && empty($dnr_alt_id))) {
            unset($this->dnr_alt_id);
        } else {
            $this->dnr_alt_id = $dnr_alt_id;
        }
        
        return $this;
    }
    /**
     * Get dnr_matchcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_matchcode(): ?string
    {
        return $this->dnr_matchcode ?? null;
    }
    /**
     * Set dnr_matchcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_matchcode
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_matchcode(?string $dnr_matchcode = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_matchcode) && !is_string($dnr_matchcode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_matchcode, true), gettype($dnr_matchcode)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($dnr_matchcode) && mb_strlen((string) $dnr_matchcode) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $dnr_matchcode)), __LINE__);
        }
        if (is_null($dnr_matchcode) || (is_array($dnr_matchcode) && empty($dnr_matchcode))) {
            unset($this->dnr_matchcode);
        } else {
            $this->dnr_matchcode = $dnr_matchcode;
        }
        
        return $this;
    }
    /**
     * Get dnr_salutation1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_salutation1(): ?string
    {
        return $this->dnr_salutation1 ?? null;
    }
    /**
     * Set dnr_salutation1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_salutation1
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_salutation1(?string $dnr_salutation1 = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_salutation1) && !is_string($dnr_salutation1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_salutation1, true), gettype($dnr_salutation1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($dnr_salutation1) && mb_strlen((string) $dnr_salutation1) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $dnr_salutation1)), __LINE__);
        }
        if (is_null($dnr_salutation1) || (is_array($dnr_salutation1) && empty($dnr_salutation1))) {
            unset($this->dnr_salutation1);
        } else {
            $this->dnr_salutation1 = $dnr_salutation1;
        }
        
        return $this;
    }
    /**
     * Get dnr_salutation2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_salutation2(): ?string
    {
        return $this->dnr_salutation2 ?? null;
    }
    /**
     * Set dnr_salutation2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_salutation2
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_salutation2(?string $dnr_salutation2 = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_salutation2) && !is_string($dnr_salutation2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_salutation2, true), gettype($dnr_salutation2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($dnr_salutation2) && mb_strlen((string) $dnr_salutation2) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $dnr_salutation2)), __LINE__);
        }
        if (is_null($dnr_salutation2) || (is_array($dnr_salutation2) && empty($dnr_salutation2))) {
            unset($this->dnr_salutation2);
        } else {
            $this->dnr_salutation2 = $dnr_salutation2;
        }
        
        return $this;
    }
    /**
     * Get dnr_salutation3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_salutation3(): ?string
    {
        return $this->dnr_salutation3 ?? null;
    }
    /**
     * Set dnr_salutation3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_salutation3
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_salutation3(?string $dnr_salutation3 = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_salutation3) && !is_string($dnr_salutation3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_salutation3, true), gettype($dnr_salutation3)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($dnr_salutation3) && mb_strlen((string) $dnr_salutation3) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $dnr_salutation3)), __LINE__);
        }
        if (is_null($dnr_salutation3) || (is_array($dnr_salutation3) && empty($dnr_salutation3))) {
            unset($this->dnr_salutation3);
        } else {
            $this->dnr_salutation3 = $dnr_salutation3;
        }
        
        return $this;
    }
    /**
     * Get dnr_dcg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_dcg_key(): ?string
    {
        return $this->dnr_dcg_key ?? null;
    }
    /**
     * Set dnr_dcg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_dcg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_dcg_key(?string $dnr_dcg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_dcg_key) && !is_string($dnr_dcg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_dcg_key, true), gettype($dnr_dcg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_dcg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_dcg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_dcg_key, true)), __LINE__);
        }
        if (is_null($dnr_dcg_key) || (is_array($dnr_dcg_key) && empty($dnr_dcg_key))) {
            unset($this->dnr_dcg_key);
        } else {
            $this->dnr_dcg_key = $dnr_dcg_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_join_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_join_date(): ?string
    {
        return $this->dnr_rfm_join_date ?? null;
    }
    /**
     * Set dnr_rfm_join_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_join_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_join_date(?string $dnr_rfm_join_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_join_date) && !is_string($dnr_rfm_join_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_join_date, true), gettype($dnr_rfm_join_date)), __LINE__);
        }
        if (is_null($dnr_rfm_join_date) || (is_array($dnr_rfm_join_date) && empty($dnr_rfm_join_date))) {
            unset($this->dnr_rfm_join_date);
        } else {
            $this->dnr_rfm_join_date = $dnr_rfm_join_date;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_join_source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_join_source(): ?string
    {
        return $this->dnr_rfm_join_source ?? null;
    }
    /**
     * Set dnr_rfm_join_source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_join_source
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_join_source(?string $dnr_rfm_join_source = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_join_source) && !is_string($dnr_rfm_join_source)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_join_source, true), gettype($dnr_rfm_join_source)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rfm_join_source) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rfm_join_source)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rfm_join_source, true)), __LINE__);
        }
        if (is_null($dnr_rfm_join_source) || (is_array($dnr_rfm_join_source) && empty($dnr_rfm_join_source))) {
            unset($this->dnr_rfm_join_source);
        } else {
            $this->dnr_rfm_join_source = $dnr_rfm_join_source;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_ytd_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDnr_rfm_ytd_amt(): ?float
    {
        return $this->dnr_rfm_ytd_amt ?? null;
    }
    /**
     * Set dnr_rfm_ytd_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dnr_rfm_ytd_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_ytd_amt(?float $dnr_rfm_ytd_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($dnr_rfm_ytd_amt) && !(is_float($dnr_rfm_ytd_amt) || is_numeric($dnr_rfm_ytd_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dnr_rfm_ytd_amt, true), gettype($dnr_rfm_ytd_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($dnr_rfm_ytd_amt) && mb_strlen(mb_substr((string) $dnr_rfm_ytd_amt, false !== mb_strpos((string) $dnr_rfm_ytd_amt, '.') ? mb_strpos((string) $dnr_rfm_ytd_amt, '.') + 1 : mb_strlen((string) $dnr_rfm_ytd_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($dnr_rfm_ytd_amt, true), mb_strlen(mb_substr((string) $dnr_rfm_ytd_amt, mb_strpos((string) $dnr_rfm_ytd_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($dnr_rfm_ytd_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_ytd_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($dnr_rfm_ytd_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_ytd_amt))), __LINE__);
        }
        if (is_null($dnr_rfm_ytd_amt) || (is_array($dnr_rfm_ytd_amt) && empty($dnr_rfm_ytd_amt))) {
            unset($this->dnr_rfm_ytd_amt);
        } else {
            $this->dnr_rfm_ytd_amt = $dnr_rfm_ytd_amt;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_ytd_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDnr_rfm_ytd_count(): ?int
    {
        return $this->dnr_rfm_ytd_count ?? null;
    }
    /**
     * Set dnr_rfm_ytd_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dnr_rfm_ytd_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_ytd_count(?int $dnr_rfm_ytd_count = null): self
    {
        // validation for constraint: int
        if (!is_null($dnr_rfm_ytd_count) && !(is_int($dnr_rfm_ytd_count) || ctype_digit($dnr_rfm_ytd_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dnr_rfm_ytd_count, true), gettype($dnr_rfm_ytd_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($dnr_rfm_ytd_count) && $dnr_rfm_ytd_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($dnr_rfm_ytd_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($dnr_rfm_ytd_count) && $dnr_rfm_ytd_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($dnr_rfm_ytd_count, true)), __LINE__);
        }
        if (is_null($dnr_rfm_ytd_count) || (is_array($dnr_rfm_ytd_count) && empty($dnr_rfm_ytd_count))) {
            unset($this->dnr_rfm_ytd_count);
        } else {
            $this->dnr_rfm_ytd_count = $dnr_rfm_ytd_count;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_ly_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDnr_rfm_ly_amt(): ?float
    {
        return $this->dnr_rfm_ly_amt ?? null;
    }
    /**
     * Set dnr_rfm_ly_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dnr_rfm_ly_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_ly_amt(?float $dnr_rfm_ly_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($dnr_rfm_ly_amt) && !(is_float($dnr_rfm_ly_amt) || is_numeric($dnr_rfm_ly_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dnr_rfm_ly_amt, true), gettype($dnr_rfm_ly_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($dnr_rfm_ly_amt) && mb_strlen(mb_substr((string) $dnr_rfm_ly_amt, false !== mb_strpos((string) $dnr_rfm_ly_amt, '.') ? mb_strpos((string) $dnr_rfm_ly_amt, '.') + 1 : mb_strlen((string) $dnr_rfm_ly_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($dnr_rfm_ly_amt, true), mb_strlen(mb_substr((string) $dnr_rfm_ly_amt, mb_strpos((string) $dnr_rfm_ly_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($dnr_rfm_ly_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_ly_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($dnr_rfm_ly_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_ly_amt))), __LINE__);
        }
        if (is_null($dnr_rfm_ly_amt) || (is_array($dnr_rfm_ly_amt) && empty($dnr_rfm_ly_amt))) {
            unset($this->dnr_rfm_ly_amt);
        } else {
            $this->dnr_rfm_ly_amt = $dnr_rfm_ly_amt;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_ly_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDnr_rfm_ly_count(): ?int
    {
        return $this->dnr_rfm_ly_count ?? null;
    }
    /**
     * Set dnr_rfm_ly_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dnr_rfm_ly_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_ly_count(?int $dnr_rfm_ly_count = null): self
    {
        // validation for constraint: int
        if (!is_null($dnr_rfm_ly_count) && !(is_int($dnr_rfm_ly_count) || ctype_digit($dnr_rfm_ly_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dnr_rfm_ly_count, true), gettype($dnr_rfm_ly_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($dnr_rfm_ly_count) && $dnr_rfm_ly_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($dnr_rfm_ly_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($dnr_rfm_ly_count) && $dnr_rfm_ly_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($dnr_rfm_ly_count, true)), __LINE__);
        }
        if (is_null($dnr_rfm_ly_count) || (is_array($dnr_rfm_ly_count) && empty($dnr_rfm_ly_count))) {
            unset($this->dnr_rfm_ly_count);
        } else {
            $this->dnr_rfm_ly_count = $dnr_rfm_ly_count;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_ttd_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDnr_rfm_ttd_amt(): ?float
    {
        return $this->dnr_rfm_ttd_amt ?? null;
    }
    /**
     * Set dnr_rfm_ttd_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dnr_rfm_ttd_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_ttd_amt(?float $dnr_rfm_ttd_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($dnr_rfm_ttd_amt) && !(is_float($dnr_rfm_ttd_amt) || is_numeric($dnr_rfm_ttd_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dnr_rfm_ttd_amt, true), gettype($dnr_rfm_ttd_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($dnr_rfm_ttd_amt) && mb_strlen(mb_substr((string) $dnr_rfm_ttd_amt, false !== mb_strpos((string) $dnr_rfm_ttd_amt, '.') ? mb_strpos((string) $dnr_rfm_ttd_amt, '.') + 1 : mb_strlen((string) $dnr_rfm_ttd_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($dnr_rfm_ttd_amt, true), mb_strlen(mb_substr((string) $dnr_rfm_ttd_amt, mb_strpos((string) $dnr_rfm_ttd_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($dnr_rfm_ttd_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_ttd_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($dnr_rfm_ttd_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_ttd_amt))), __LINE__);
        }
        if (is_null($dnr_rfm_ttd_amt) || (is_array($dnr_rfm_ttd_amt) && empty($dnr_rfm_ttd_amt))) {
            unset($this->dnr_rfm_ttd_amt);
        } else {
            $this->dnr_rfm_ttd_amt = $dnr_rfm_ttd_amt;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_ttd_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDnr_rfm_ttd_count(): ?int
    {
        return $this->dnr_rfm_ttd_count ?? null;
    }
    /**
     * Set dnr_rfm_ttd_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dnr_rfm_ttd_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_ttd_count(?int $dnr_rfm_ttd_count = null): self
    {
        // validation for constraint: int
        if (!is_null($dnr_rfm_ttd_count) && !(is_int($dnr_rfm_ttd_count) || ctype_digit($dnr_rfm_ttd_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dnr_rfm_ttd_count, true), gettype($dnr_rfm_ttd_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($dnr_rfm_ttd_count) && $dnr_rfm_ttd_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($dnr_rfm_ttd_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($dnr_rfm_ttd_count) && $dnr_rfm_ttd_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($dnr_rfm_ttd_count, true)), __LINE__);
        }
        if (is_null($dnr_rfm_ttd_count) || (is_array($dnr_rfm_ttd_count) && empty($dnr_rfm_ttd_count))) {
            unset($this->dnr_rfm_ttd_count);
        } else {
            $this->dnr_rfm_ttd_count = $dnr_rfm_ttd_count;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_highest_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDnr_rfm_highest_amt(): ?float
    {
        return $this->dnr_rfm_highest_amt ?? null;
    }
    /**
     * Set dnr_rfm_highest_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dnr_rfm_highest_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_highest_amt(?float $dnr_rfm_highest_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($dnr_rfm_highest_amt) && !(is_float($dnr_rfm_highest_amt) || is_numeric($dnr_rfm_highest_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dnr_rfm_highest_amt, true), gettype($dnr_rfm_highest_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($dnr_rfm_highest_amt) && mb_strlen(mb_substr((string) $dnr_rfm_highest_amt, false !== mb_strpos((string) $dnr_rfm_highest_amt, '.') ? mb_strpos((string) $dnr_rfm_highest_amt, '.') + 1 : mb_strlen((string) $dnr_rfm_highest_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($dnr_rfm_highest_amt, true), mb_strlen(mb_substr((string) $dnr_rfm_highest_amt, mb_strpos((string) $dnr_rfm_highest_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($dnr_rfm_highest_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_highest_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($dnr_rfm_highest_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_highest_amt))), __LINE__);
        }
        if (is_null($dnr_rfm_highest_amt) || (is_array($dnr_rfm_highest_amt) && empty($dnr_rfm_highest_amt))) {
            unset($this->dnr_rfm_highest_amt);
        } else {
            $this->dnr_rfm_highest_amt = $dnr_rfm_highest_amt;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_highest_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_highest_date(): ?string
    {
        return $this->dnr_rfm_highest_date ?? null;
    }
    /**
     * Set dnr_rfm_highest_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_highest_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_highest_date(?string $dnr_rfm_highest_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_highest_date) && !is_string($dnr_rfm_highest_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_highest_date, true), gettype($dnr_rfm_highest_date)), __LINE__);
        }
        if (is_null($dnr_rfm_highest_date) || (is_array($dnr_rfm_highest_date) && empty($dnr_rfm_highest_date))) {
            unset($this->dnr_rfm_highest_date);
        } else {
            $this->dnr_rfm_highest_date = $dnr_rfm_highest_date;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_highest_source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_highest_source(): ?string
    {
        return $this->dnr_rfm_highest_source ?? null;
    }
    /**
     * Set dnr_rfm_highest_source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_highest_source
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_highest_source(?string $dnr_rfm_highest_source = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_highest_source) && !is_string($dnr_rfm_highest_source)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_highest_source, true), gettype($dnr_rfm_highest_source)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rfm_highest_source) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rfm_highest_source)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rfm_highest_source, true)), __LINE__);
        }
        if (is_null($dnr_rfm_highest_source) || (is_array($dnr_rfm_highest_source) && empty($dnr_rfm_highest_source))) {
            unset($this->dnr_rfm_highest_source);
        } else {
            $this->dnr_rfm_highest_source = $dnr_rfm_highest_source;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_latest_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDnr_rfm_latest_amt(): ?float
    {
        return $this->dnr_rfm_latest_amt ?? null;
    }
    /**
     * Set dnr_rfm_latest_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dnr_rfm_latest_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_latest_amt(?float $dnr_rfm_latest_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($dnr_rfm_latest_amt) && !(is_float($dnr_rfm_latest_amt) || is_numeric($dnr_rfm_latest_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dnr_rfm_latest_amt, true), gettype($dnr_rfm_latest_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($dnr_rfm_latest_amt) && mb_strlen(mb_substr((string) $dnr_rfm_latest_amt, false !== mb_strpos((string) $dnr_rfm_latest_amt, '.') ? mb_strpos((string) $dnr_rfm_latest_amt, '.') + 1 : mb_strlen((string) $dnr_rfm_latest_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($dnr_rfm_latest_amt, true), mb_strlen(mb_substr((string) $dnr_rfm_latest_amt, mb_strpos((string) $dnr_rfm_latest_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($dnr_rfm_latest_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_latest_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($dnr_rfm_latest_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_latest_amt))), __LINE__);
        }
        if (is_null($dnr_rfm_latest_amt) || (is_array($dnr_rfm_latest_amt) && empty($dnr_rfm_latest_amt))) {
            unset($this->dnr_rfm_latest_amt);
        } else {
            $this->dnr_rfm_latest_amt = $dnr_rfm_latest_amt;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_latest_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_latest_date(): ?string
    {
        return $this->dnr_rfm_latest_date ?? null;
    }
    /**
     * Set dnr_rfm_latest_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_latest_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_latest_date(?string $dnr_rfm_latest_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_latest_date) && !is_string($dnr_rfm_latest_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_latest_date, true), gettype($dnr_rfm_latest_date)), __LINE__);
        }
        if (is_null($dnr_rfm_latest_date) || (is_array($dnr_rfm_latest_date) && empty($dnr_rfm_latest_date))) {
            unset($this->dnr_rfm_latest_date);
        } else {
            $this->dnr_rfm_latest_date = $dnr_rfm_latest_date;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_latest_source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_latest_source(): ?string
    {
        return $this->dnr_rfm_latest_source ?? null;
    }
    /**
     * Set dnr_rfm_latest_source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_latest_source
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_latest_source(?string $dnr_rfm_latest_source = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_latest_source) && !is_string($dnr_rfm_latest_source)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_latest_source, true), gettype($dnr_rfm_latest_source)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rfm_latest_source) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rfm_latest_source)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rfm_latest_source, true)), __LINE__);
        }
        if (is_null($dnr_rfm_latest_source) || (is_array($dnr_rfm_latest_source) && empty($dnr_rfm_latest_source))) {
            unset($this->dnr_rfm_latest_source);
        } else {
            $this->dnr_rfm_latest_source = $dnr_rfm_latest_source;
        }
        
        return $this;
    }
    /**
     * Get dnr_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_add_user(): ?string
    {
        return $this->dnr_add_user ?? null;
    }
    /**
     * Set dnr_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_add_user(?string $dnr_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_add_user) && !is_string($dnr_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_add_user, true), gettype($dnr_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($dnr_add_user) && mb_strlen((string) $dnr_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $dnr_add_user)), __LINE__);
        }
        if (is_null($dnr_add_user) || (is_array($dnr_add_user) && empty($dnr_add_user))) {
            unset($this->dnr_add_user);
        } else {
            $this->dnr_add_user = $dnr_add_user;
        }
        
        return $this;
    }
    /**
     * Get dnr_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_add_date(): ?string
    {
        return $this->dnr_add_date ?? null;
    }
    /**
     * Set dnr_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_add_date(?string $dnr_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_add_date) && !is_string($dnr_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_add_date, true), gettype($dnr_add_date)), __LINE__);
        }
        if (is_null($dnr_add_date) || (is_array($dnr_add_date) && empty($dnr_add_date))) {
            unset($this->dnr_add_date);
        } else {
            $this->dnr_add_date = $dnr_add_date;
        }
        
        return $this;
    }
    /**
     * Get dnr_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_change_user(): ?string
    {
        return $this->dnr_change_user ?? null;
    }
    /**
     * Set dnr_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_change_user(?string $dnr_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_change_user) && !is_string($dnr_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_change_user, true), gettype($dnr_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($dnr_change_user) && mb_strlen((string) $dnr_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $dnr_change_user)), __LINE__);
        }
        if (is_null($dnr_change_user) || (is_array($dnr_change_user) && empty($dnr_change_user))) {
            unset($this->dnr_change_user);
        } else {
            $this->dnr_change_user = $dnr_change_user;
        }
        
        return $this;
    }
    /**
     * Get dnr_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_change_date(): ?string
    {
        return $this->dnr_change_date ?? null;
    }
    /**
     * Set dnr_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_change_date(?string $dnr_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_change_date) && !is_string($dnr_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_change_date, true), gettype($dnr_change_date)), __LINE__);
        }
        if (is_null($dnr_change_date) || (is_array($dnr_change_date) && empty($dnr_change_date))) {
            unset($this->dnr_change_date);
        } else {
            $this->dnr_change_date = $dnr_change_date;
        }
        
        return $this;
    }
    /**
     * Get dnr_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_delete_flag(): ?string
    {
        return $this->dnr_delete_flag ?? null;
    }
    /**
     * Set dnr_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_delete_flag(?string $dnr_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_delete_flag) && !is_string($dnr_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_delete_flag, true), gettype($dnr_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($dnr_delete_flag) && $dnr_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($dnr_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($dnr_delete_flag) && $dnr_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($dnr_delete_flag, true)), __LINE__);
        }
        if (is_null($dnr_delete_flag) || (is_array($dnr_delete_flag) && empty($dnr_delete_flag))) {
            unset($this->dnr_delete_flag);
        } else {
            $this->dnr_delete_flag = $dnr_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get dnr_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_entity_key(): ?string
    {
        return $this->dnr_entity_key ?? null;
    }
    /**
     * Set dnr_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_entity_key(?string $dnr_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_entity_key) && !is_string($dnr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_entity_key, true), gettype($dnr_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_entity_key, true)), __LINE__);
        }
        if (is_null($dnr_entity_key) || (is_array($dnr_entity_key) && empty($dnr_entity_key))) {
            unset($this->dnr_entity_key);
        } else {
            $this->dnr_entity_key = $dnr_entity_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_cst_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_cst_key_ext(): ?string
    {
        return $this->dnr_cst_key_ext ?? null;
    }
    /**
     * Set dnr_cst_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_cst_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_cst_key_ext(?string $dnr_cst_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_cst_key_ext) && !is_string($dnr_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_cst_key_ext, true), gettype($dnr_cst_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_cst_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_cst_key_ext, true)), __LINE__);
        }
        if (is_null($dnr_cst_key_ext) || (is_array($dnr_cst_key_ext) && empty($dnr_cst_key_ext))) {
            unset($this->dnr_cst_key_ext);
        } else {
            $this->dnr_cst_key_ext = $dnr_cst_key_ext;
        }
        
        return $this;
    }
    /**
     * Get dnr_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_ind_cst_key(): ?string
    {
        return $this->dnr_ind_cst_key ?? null;
    }
    /**
     * Set dnr_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_ind_cst_key(?string $dnr_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_ind_cst_key) && !is_string($dnr_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_ind_cst_key, true), gettype($dnr_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_ind_cst_key, true)), __LINE__);
        }
        if (is_null($dnr_ind_cst_key) || (is_array($dnr_ind_cst_key) && empty($dnr_ind_cst_key))) {
            unset($this->dnr_ind_cst_key);
        } else {
            $this->dnr_ind_cst_key = $dnr_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_first_gift_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDnr_rfm_first_gift_amt(): ?float
    {
        return $this->dnr_rfm_first_gift_amt ?? null;
    }
    /**
     * Set dnr_rfm_first_gift_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dnr_rfm_first_gift_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_first_gift_amt(?float $dnr_rfm_first_gift_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($dnr_rfm_first_gift_amt) && !(is_float($dnr_rfm_first_gift_amt) || is_numeric($dnr_rfm_first_gift_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dnr_rfm_first_gift_amt, true), gettype($dnr_rfm_first_gift_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($dnr_rfm_first_gift_amt) && mb_strlen(mb_substr((string) $dnr_rfm_first_gift_amt, false !== mb_strpos((string) $dnr_rfm_first_gift_amt, '.') ? mb_strpos((string) $dnr_rfm_first_gift_amt, '.') + 1 : mb_strlen((string) $dnr_rfm_first_gift_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($dnr_rfm_first_gift_amt, true), mb_strlen(mb_substr((string) $dnr_rfm_first_gift_amt, mb_strpos((string) $dnr_rfm_first_gift_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($dnr_rfm_first_gift_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_first_gift_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($dnr_rfm_first_gift_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_first_gift_amt))), __LINE__);
        }
        if (is_null($dnr_rfm_first_gift_amt) || (is_array($dnr_rfm_first_gift_amt) && empty($dnr_rfm_first_gift_amt))) {
            unset($this->dnr_rfm_first_gift_amt);
        } else {
            $this->dnr_rfm_first_gift_amt = $dnr_rfm_first_gift_amt;
        }
        
        return $this;
    }
    /**
     * Get dnr_vip_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_vip_flag(): ?string
    {
        return $this->dnr_vip_flag ?? null;
    }
    /**
     * Set dnr_vip_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_vip_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_vip_flag(?string $dnr_vip_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_vip_flag) && !is_string($dnr_vip_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_vip_flag, true), gettype($dnr_vip_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($dnr_vip_flag) && $dnr_vip_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($dnr_vip_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($dnr_vip_flag) && $dnr_vip_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($dnr_vip_flag, true)), __LINE__);
        }
        if (is_null($dnr_vip_flag) || (is_array($dnr_vip_flag) && empty($dnr_vip_flag))) {
            unset($this->dnr_vip_flag);
        } else {
            $this->dnr_vip_flag = $dnr_vip_flag;
        }
        
        return $this;
    }
    /**
     * Get dnr_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_notes(): ?string
    {
        return $this->dnr_notes ?? null;
    }
    /**
     * Set dnr_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_notes(?string $dnr_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_notes) && !is_string($dnr_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_notes, true), gettype($dnr_notes)), __LINE__);
        }
        if (is_null($dnr_notes) || (is_array($dnr_notes) && empty($dnr_notes))) {
            unset($this->dnr_notes);
        } else {
            $this->dnr_notes = $dnr_notes;
        }
        
        return $this;
    }
    /**
     * Get dnr_rcl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rcl_key(): ?string
    {
        return $this->dnr_rcl_key ?? null;
    }
    /**
     * Set dnr_rcl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rcl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rcl_key(?string $dnr_rcl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rcl_key) && !is_string($dnr_rcl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rcl_key, true), gettype($dnr_rcl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rcl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rcl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rcl_key, true)), __LINE__);
        }
        if (is_null($dnr_rcl_key) || (is_array($dnr_rcl_key) && empty($dnr_rcl_key))) {
            unset($this->dnr_rcl_key);
        } else {
            $this->dnr_rcl_key = $dnr_rcl_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_recognition_level_override_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_recognition_level_override_flag(): ?string
    {
        return $this->dnr_recognition_level_override_flag ?? null;
    }
    /**
     * Set dnr_recognition_level_override_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_recognition_level_override_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_recognition_level_override_flag(?string $dnr_recognition_level_override_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_recognition_level_override_flag) && !is_string($dnr_recognition_level_override_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_recognition_level_override_flag, true), gettype($dnr_recognition_level_override_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($dnr_recognition_level_override_flag) && $dnr_recognition_level_override_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($dnr_recognition_level_override_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($dnr_recognition_level_override_flag) && $dnr_recognition_level_override_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($dnr_recognition_level_override_flag, true)), __LINE__);
        }
        if (is_null($dnr_recognition_level_override_flag) || (is_array($dnr_recognition_level_override_flag) && empty($dnr_recognition_level_override_flag))) {
            unset($this->dnr_recognition_level_override_flag);
        } else {
            $this->dnr_recognition_level_override_flag = $dnr_recognition_level_override_flag;
        }
        
        return $this;
    }
    /**
     * Get dnr_salutation4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_salutation4(): ?string
    {
        return $this->dnr_salutation4 ?? null;
    }
    /**
     * Set dnr_salutation4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_salutation4
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_salutation4(?string $dnr_salutation4 = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_salutation4) && !is_string($dnr_salutation4)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_salutation4, true), gettype($dnr_salutation4)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($dnr_salutation4) && mb_strlen((string) $dnr_salutation4) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $dnr_salutation4)), __LINE__);
        }
        if (is_null($dnr_salutation4) || (is_array($dnr_salutation4) && empty($dnr_salutation4))) {
            unset($this->dnr_salutation4);
        } else {
            $this->dnr_salutation4 = $dnr_salutation4;
        }
        
        return $this;
    }
    /**
     * Get dnr_usr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_usr_key(): ?string
    {
        return $this->dnr_usr_key ?? null;
    }
    /**
     * Set dnr_usr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_usr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_usr_key(?string $dnr_usr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_usr_key) && !is_string($dnr_usr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_usr_key, true), gettype($dnr_usr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_usr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_usr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_usr_key, true)), __LINE__);
        }
        if (is_null($dnr_usr_key) || (is_array($dnr_usr_key) && empty($dnr_usr_key))) {
            unset($this->dnr_usr_key);
        } else {
            $this->dnr_usr_key = $dnr_usr_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_solicitor_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_solicitor_cst_key(): ?string
    {
        return $this->dnr_solicitor_cst_key ?? null;
    }
    /**
     * Set dnr_solicitor_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_solicitor_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_solicitor_cst_key(?string $dnr_solicitor_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_solicitor_cst_key) && !is_string($dnr_solicitor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_solicitor_cst_key, true), gettype($dnr_solicitor_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_solicitor_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_solicitor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_solicitor_cst_key, true)), __LINE__);
        }
        if (is_null($dnr_solicitor_cst_key) || (is_array($dnr_solicitor_cst_key) && empty($dnr_solicitor_cst_key))) {
            unset($this->dnr_solicitor_cst_key);
        } else {
            $this->dnr_solicitor_cst_key = $dnr_solicitor_cst_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_vpt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_vpt_key(): ?string
    {
        return $this->dnr_vpt_key ?? null;
    }
    /**
     * Set dnr_vpt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_vpt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_vpt_key(?string $dnr_vpt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_vpt_key) && !is_string($dnr_vpt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_vpt_key, true), gettype($dnr_vpt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_vpt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_vpt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_vpt_key, true)), __LINE__);
        }
        if (is_null($dnr_vpt_key) || (is_array($dnr_vpt_key) && empty($dnr_vpt_key))) {
            unset($this->dnr_vpt_key);
        } else {
            $this->dnr_vpt_key = $dnr_vpt_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_gives_anonymous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_gives_anonymous(): ?string
    {
        return $this->dnr_gives_anonymous ?? null;
    }
    /**
     * Set dnr_gives_anonymous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_gives_anonymous
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_gives_anonymous(?string $dnr_gives_anonymous = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_gives_anonymous) && !is_string($dnr_gives_anonymous)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_gives_anonymous, true), gettype($dnr_gives_anonymous)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($dnr_gives_anonymous) && $dnr_gives_anonymous > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($dnr_gives_anonymous, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($dnr_gives_anonymous) && $dnr_gives_anonymous < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($dnr_gives_anonymous, true)), __LINE__);
        }
        if (is_null($dnr_gives_anonymous) || (is_array($dnr_gives_anonymous) && empty($dnr_gives_anonymous))) {
            unset($this->dnr_gives_anonymous);
        } else {
            $this->dnr_gives_anonymous = $dnr_gives_anonymous;
        }
        
        return $this;
    }
    /**
     * Get dnr_do_not_solicit_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_do_not_solicit_flag(): ?string
    {
        return $this->dnr_do_not_solicit_flag ?? null;
    }
    /**
     * Set dnr_do_not_solicit_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_do_not_solicit_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_do_not_solicit_flag(?string $dnr_do_not_solicit_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_do_not_solicit_flag) && !is_string($dnr_do_not_solicit_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_do_not_solicit_flag, true), gettype($dnr_do_not_solicit_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($dnr_do_not_solicit_flag) && $dnr_do_not_solicit_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($dnr_do_not_solicit_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($dnr_do_not_solicit_flag) && $dnr_do_not_solicit_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($dnr_do_not_solicit_flag, true)), __LINE__);
        }
        if (is_null($dnr_do_not_solicit_flag) || (is_array($dnr_do_not_solicit_flag) && empty($dnr_do_not_solicit_flag))) {
            unset($this->dnr_do_not_solicit_flag);
        } else {
            $this->dnr_do_not_solicit_flag = $dnr_do_not_solicit_flag;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_first_source_code_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_first_source_code_key(): ?string
    {
        return $this->dnr_rfm_first_source_code_key ?? null;
    }
    /**
     * Set dnr_rfm_first_source_code_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_first_source_code_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_first_source_code_key(?string $dnr_rfm_first_source_code_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_first_source_code_key) && !is_string($dnr_rfm_first_source_code_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_first_source_code_key, true), gettype($dnr_rfm_first_source_code_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rfm_first_source_code_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rfm_first_source_code_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rfm_first_source_code_key, true)), __LINE__);
        }
        if (is_null($dnr_rfm_first_source_code_key) || (is_array($dnr_rfm_first_source_code_key) && empty($dnr_rfm_first_source_code_key))) {
            unset($this->dnr_rfm_first_source_code_key);
        } else {
            $this->dnr_rfm_first_source_code_key = $dnr_rfm_first_source_code_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_highest_ly_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDnr_rfm_highest_ly_amt(): ?float
    {
        return $this->dnr_rfm_highest_ly_amt ?? null;
    }
    /**
     * Set dnr_rfm_highest_ly_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dnr_rfm_highest_ly_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_highest_ly_amt(?float $dnr_rfm_highest_ly_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($dnr_rfm_highest_ly_amt) && !(is_float($dnr_rfm_highest_ly_amt) || is_numeric($dnr_rfm_highest_ly_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dnr_rfm_highest_ly_amt, true), gettype($dnr_rfm_highest_ly_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($dnr_rfm_highest_ly_amt) && mb_strlen(mb_substr((string) $dnr_rfm_highest_ly_amt, false !== mb_strpos((string) $dnr_rfm_highest_ly_amt, '.') ? mb_strpos((string) $dnr_rfm_highest_ly_amt, '.') + 1 : mb_strlen((string) $dnr_rfm_highest_ly_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($dnr_rfm_highest_ly_amt, true), mb_strlen(mb_substr((string) $dnr_rfm_highest_ly_amt, mb_strpos((string) $dnr_rfm_highest_ly_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($dnr_rfm_highest_ly_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_highest_ly_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($dnr_rfm_highest_ly_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_highest_ly_amt))), __LINE__);
        }
        if (is_null($dnr_rfm_highest_ly_amt) || (is_array($dnr_rfm_highest_ly_amt) && empty($dnr_rfm_highest_ly_amt))) {
            unset($this->dnr_rfm_highest_ly_amt);
        } else {
            $this->dnr_rfm_highest_ly_amt = $dnr_rfm_highest_ly_amt;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_first_appeal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_first_appeal_key(): ?string
    {
        return $this->dnr_rfm_first_appeal_key ?? null;
    }
    /**
     * Set dnr_rfm_first_appeal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_first_appeal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_first_appeal_key(?string $dnr_rfm_first_appeal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_first_appeal_key) && !is_string($dnr_rfm_first_appeal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_first_appeal_key, true), gettype($dnr_rfm_first_appeal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rfm_first_appeal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rfm_first_appeal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rfm_first_appeal_key, true)), __LINE__);
        }
        if (is_null($dnr_rfm_first_appeal_key) || (is_array($dnr_rfm_first_appeal_key) && empty($dnr_rfm_first_appeal_key))) {
            unset($this->dnr_rfm_first_appeal_key);
        } else {
            $this->dnr_rfm_first_appeal_key = $dnr_rfm_first_appeal_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_highest_ytd_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_highest_ytd_date(): ?string
    {
        return $this->dnr_rfm_highest_ytd_date ?? null;
    }
    /**
     * Set dnr_rfm_highest_ytd_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_highest_ytd_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_highest_ytd_date(?string $dnr_rfm_highest_ytd_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_highest_ytd_date) && !is_string($dnr_rfm_highest_ytd_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_highest_ytd_date, true), gettype($dnr_rfm_highest_ytd_date)), __LINE__);
        }
        if (is_null($dnr_rfm_highest_ytd_date) || (is_array($dnr_rfm_highest_ytd_date) && empty($dnr_rfm_highest_ytd_date))) {
            unset($this->dnr_rfm_highest_ytd_date);
        } else {
            $this->dnr_rfm_highest_ytd_date = $dnr_rfm_highest_ytd_date;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_highest_ly_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_highest_ly_date(): ?string
    {
        return $this->dnr_rfm_highest_ly_date ?? null;
    }
    /**
     * Set dnr_rfm_highest_ly_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_highest_ly_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_highest_ly_date(?string $dnr_rfm_highest_ly_date = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_highest_ly_date) && !is_string($dnr_rfm_highest_ly_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_highest_ly_date, true), gettype($dnr_rfm_highest_ly_date)), __LINE__);
        }
        if (is_null($dnr_rfm_highest_ly_date) || (is_array($dnr_rfm_highest_ly_date) && empty($dnr_rfm_highest_ly_date))) {
            unset($this->dnr_rfm_highest_ly_date);
        } else {
            $this->dnr_rfm_highest_ly_date = $dnr_rfm_highest_ly_date;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_latest_source_code_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_latest_source_code_key(): ?string
    {
        return $this->dnr_rfm_latest_source_code_key ?? null;
    }
    /**
     * Set dnr_rfm_latest_source_code_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_latest_source_code_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_latest_source_code_key(?string $dnr_rfm_latest_source_code_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_latest_source_code_key) && !is_string($dnr_rfm_latest_source_code_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_latest_source_code_key, true), gettype($dnr_rfm_latest_source_code_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rfm_latest_source_code_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rfm_latest_source_code_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rfm_latest_source_code_key, true)), __LINE__);
        }
        if (is_null($dnr_rfm_latest_source_code_key) || (is_array($dnr_rfm_latest_source_code_key) && empty($dnr_rfm_latest_source_code_key))) {
            unset($this->dnr_rfm_latest_source_code_key);
        } else {
            $this->dnr_rfm_latest_source_code_key = $dnr_rfm_latest_source_code_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_highest_ytd_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDnr_rfm_highest_ytd_amt(): ?float
    {
        return $this->dnr_rfm_highest_ytd_amt ?? null;
    }
    /**
     * Set dnr_rfm_highest_ytd_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dnr_rfm_highest_ytd_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_highest_ytd_amt(?float $dnr_rfm_highest_ytd_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($dnr_rfm_highest_ytd_amt) && !(is_float($dnr_rfm_highest_ytd_amt) || is_numeric($dnr_rfm_highest_ytd_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dnr_rfm_highest_ytd_amt, true), gettype($dnr_rfm_highest_ytd_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($dnr_rfm_highest_ytd_amt) && mb_strlen(mb_substr((string) $dnr_rfm_highest_ytd_amt, false !== mb_strpos((string) $dnr_rfm_highest_ytd_amt, '.') ? mb_strpos((string) $dnr_rfm_highest_ytd_amt, '.') + 1 : mb_strlen((string) $dnr_rfm_highest_ytd_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($dnr_rfm_highest_ytd_amt, true), mb_strlen(mb_substr((string) $dnr_rfm_highest_ytd_amt, mb_strpos((string) $dnr_rfm_highest_ytd_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($dnr_rfm_highest_ytd_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_highest_ytd_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($dnr_rfm_highest_ytd_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_highest_ytd_amt))), __LINE__);
        }
        if (is_null($dnr_rfm_highest_ytd_amt) || (is_array($dnr_rfm_highest_ytd_amt) && empty($dnr_rfm_highest_ytd_amt))) {
            unset($this->dnr_rfm_highest_ytd_amt);
        } else {
            $this->dnr_rfm_highest_ytd_amt = $dnr_rfm_highest_ytd_amt;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_latest_appeal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_latest_appeal_key(): ?string
    {
        return $this->dnr_rfm_latest_appeal_key ?? null;
    }
    /**
     * Set dnr_rfm_latest_appeal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_latest_appeal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_latest_appeal_key(?string $dnr_rfm_latest_appeal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_latest_appeal_key) && !is_string($dnr_rfm_latest_appeal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_latest_appeal_key, true), gettype($dnr_rfm_latest_appeal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rfm_latest_appeal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rfm_latest_appeal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rfm_latest_appeal_key, true)), __LINE__);
        }
        if (is_null($dnr_rfm_latest_appeal_key) || (is_array($dnr_rfm_latest_appeal_key) && empty($dnr_rfm_latest_appeal_key))) {
            unset($this->dnr_rfm_latest_appeal_key);
        } else {
            $this->dnr_rfm_latest_appeal_key = $dnr_rfm_latest_appeal_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_highest_source_code_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_highest_source_code_key(): ?string
    {
        return $this->dnr_rfm_highest_source_code_key ?? null;
    }
    /**
     * Set dnr_rfm_highest_source_code_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_highest_source_code_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_highest_source_code_key(?string $dnr_rfm_highest_source_code_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_highest_source_code_key) && !is_string($dnr_rfm_highest_source_code_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_highest_source_code_key, true), gettype($dnr_rfm_highest_source_code_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rfm_highest_source_code_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rfm_highest_source_code_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rfm_highest_source_code_key, true)), __LINE__);
        }
        if (is_null($dnr_rfm_highest_source_code_key) || (is_array($dnr_rfm_highest_source_code_key) && empty($dnr_rfm_highest_source_code_key))) {
            unset($this->dnr_rfm_highest_source_code_key);
        } else {
            $this->dnr_rfm_highest_source_code_key = $dnr_rfm_highest_source_code_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_highest_appeal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_rfm_highest_appeal_key(): ?string
    {
        return $this->dnr_rfm_highest_appeal_key ?? null;
    }
    /**
     * Set dnr_rfm_highest_appeal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_rfm_highest_appeal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_highest_appeal_key(?string $dnr_rfm_highest_appeal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_rfm_highest_appeal_key) && !is_string($dnr_rfm_highest_appeal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_rfm_highest_appeal_key, true), gettype($dnr_rfm_highest_appeal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($dnr_rfm_highest_appeal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $dnr_rfm_highest_appeal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($dnr_rfm_highest_appeal_key, true)), __LINE__);
        }
        if (is_null($dnr_rfm_highest_appeal_key) || (is_array($dnr_rfm_highest_appeal_key) && empty($dnr_rfm_highest_appeal_key))) {
            unset($this->dnr_rfm_highest_appeal_key);
        } else {
            $this->dnr_rfm_highest_appeal_key = $dnr_rfm_highest_appeal_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_rfm_average_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDnr_rfm_average_amt(): ?float
    {
        return $this->dnr_rfm_average_amt ?? null;
    }
    /**
     * Set dnr_rfm_average_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dnr_rfm_average_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_rfm_average_amt(?float $dnr_rfm_average_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($dnr_rfm_average_amt) && !(is_float($dnr_rfm_average_amt) || is_numeric($dnr_rfm_average_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dnr_rfm_average_amt, true), gettype($dnr_rfm_average_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($dnr_rfm_average_amt) && mb_strlen(mb_substr((string) $dnr_rfm_average_amt, false !== mb_strpos((string) $dnr_rfm_average_amt, '.') ? mb_strpos((string) $dnr_rfm_average_amt, '.') + 1 : mb_strlen((string) $dnr_rfm_average_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($dnr_rfm_average_amt, true), mb_strlen(mb_substr((string) $dnr_rfm_average_amt, mb_strpos((string) $dnr_rfm_average_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($dnr_rfm_average_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_average_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($dnr_rfm_average_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $dnr_rfm_average_amt))), __LINE__);
        }
        if (is_null($dnr_rfm_average_amt) || (is_array($dnr_rfm_average_amt) && empty($dnr_rfm_average_amt))) {
            unset($this->dnr_rfm_average_amt);
        } else {
            $this->dnr_rfm_average_amt = $dnr_rfm_average_amt;
        }
        
        return $this;
    }
    /**
     * Get dnr_cst_sort_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_cst_sort_name_dn(): ?string
    {
        return $this->dnr_cst_sort_name_dn ?? null;
    }
    /**
     * Set dnr_cst_sort_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_cst_sort_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_cst_sort_name_dn(?string $dnr_cst_sort_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_cst_sort_name_dn) && !is_string($dnr_cst_sort_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_cst_sort_name_dn, true), gettype($dnr_cst_sort_name_dn)), __LINE__);
        }
        if (is_null($dnr_cst_sort_name_dn) || (is_array($dnr_cst_sort_name_dn) && empty($dnr_cst_sort_name_dn))) {
            unset($this->dnr_cst_sort_name_dn);
        } else {
            $this->dnr_cst_sort_name_dn = $dnr_cst_sort_name_dn;
        }
        
        return $this;
    }
    /**
     * Get dnr_ask_amount1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_ask_amount1(): ?string
    {
        return $this->dnr_ask_amount1 ?? null;
    }
    /**
     * Set dnr_ask_amount1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_ask_amount1
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_ask_amount1(?string $dnr_ask_amount1 = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_ask_amount1) && !is_string($dnr_ask_amount1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_ask_amount1, true), gettype($dnr_ask_amount1)), __LINE__);
        }
        if (is_null($dnr_ask_amount1) || (is_array($dnr_ask_amount1) && empty($dnr_ask_amount1))) {
            unset($this->dnr_ask_amount1);
        } else {
            $this->dnr_ask_amount1 = $dnr_ask_amount1;
        }
        
        return $this;
    }
    /**
     * Get dnr_ask_amount2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_ask_amount2(): ?string
    {
        return $this->dnr_ask_amount2 ?? null;
    }
    /**
     * Set dnr_ask_amount2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_ask_amount2
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_ask_amount2(?string $dnr_ask_amount2 = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_ask_amount2) && !is_string($dnr_ask_amount2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_ask_amount2, true), gettype($dnr_ask_amount2)), __LINE__);
        }
        if (is_null($dnr_ask_amount2) || (is_array($dnr_ask_amount2) && empty($dnr_ask_amount2))) {
            unset($this->dnr_ask_amount2);
        } else {
            $this->dnr_ask_amount2 = $dnr_ask_amount2;
        }
        
        return $this;
    }
    /**
     * Get dnr_ask_amount3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_ask_amount3(): ?string
    {
        return $this->dnr_ask_amount3 ?? null;
    }
    /**
     * Set dnr_ask_amount3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_ask_amount3
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_ask_amount3(?string $dnr_ask_amount3 = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_ask_amount3) && !is_string($dnr_ask_amount3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_ask_amount3, true), gettype($dnr_ask_amount3)), __LINE__);
        }
        if (is_null($dnr_ask_amount3) || (is_array($dnr_ask_amount3) && empty($dnr_ask_amount3))) {
            unset($this->dnr_ask_amount3);
        } else {
            $this->dnr_ask_amount3 = $dnr_ask_amount3;
        }
        
        return $this;
    }
    /**
     * Get dnr_ask_amount4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_ask_amount4(): ?string
    {
        return $this->dnr_ask_amount4 ?? null;
    }
    /**
     * Set dnr_ask_amount4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_ask_amount4
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_ask_amount4(?string $dnr_ask_amount4 = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_ask_amount4) && !is_string($dnr_ask_amount4)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_ask_amount4, true), gettype($dnr_ask_amount4)), __LINE__);
        }
        if (is_null($dnr_ask_amount4) || (is_array($dnr_ask_amount4) && empty($dnr_ask_amount4))) {
            unset($this->dnr_ask_amount4);
        } else {
            $this->dnr_ask_amount4 = $dnr_ask_amount4;
        }
        
        return $this;
    }
    /**
     * Get dnr_ask_amount5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_ask_amount5(): ?string
    {
        return $this->dnr_ask_amount5 ?? null;
    }
    /**
     * Set dnr_ask_amount5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_ask_amount5
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_ask_amount5(?string $dnr_ask_amount5 = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_ask_amount5) && !is_string($dnr_ask_amount5)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_ask_amount5, true), gettype($dnr_ask_amount5)), __LINE__);
        }
        if (is_null($dnr_ask_amount5) || (is_array($dnr_ask_amount5) && empty($dnr_ask_amount5))) {
            unset($this->dnr_ask_amount5);
        } else {
            $this->dnr_ask_amount5 = $dnr_ask_amount5;
        }
        
        return $this;
    }
    /**
     * Get dnr_npa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDnr_npa_key(): ?string
    {
        return $this->dnr_npa_key ?? null;
    }
    /**
     * Set dnr_npa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dnr_npa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_npa_key(?string $dnr_npa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($dnr_npa_key) && !is_string($dnr_npa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnr_npa_key, true), gettype($dnr_npa_key)), __LINE__);
        }
        if (is_null($dnr_npa_key) || (is_array($dnr_npa_key) && empty($dnr_npa_key))) {
            unset($this->dnr_npa_key);
        } else {
            $this->dnr_npa_key = $dnr_npa_key;
        }
        
        return $this;
    }
    /**
     * Get dnr_donor_year value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDnr_donor_year(): ?int
    {
        return $this->dnr_donor_year ?? null;
    }
    /**
     * Set dnr_donor_year value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dnr_donor_year
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_donor_year(?int $dnr_donor_year = null): self
    {
        // validation for constraint: int
        if (!is_null($dnr_donor_year) && !(is_int($dnr_donor_year) || ctype_digit($dnr_donor_year))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dnr_donor_year, true), gettype($dnr_donor_year)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($dnr_donor_year) && $dnr_donor_year > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($dnr_donor_year, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($dnr_donor_year) && $dnr_donor_year < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($dnr_donor_year, true)), __LINE__);
        }
        if (is_null($dnr_donor_year) || (is_array($dnr_donor_year) && empty($dnr_donor_year))) {
            unset($this->dnr_donor_year);
        } else {
            $this->dnr_donor_year = $dnr_donor_year;
        }
        
        return $this;
    }
    /**
     * Get dnr_membership_year value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDnr_membership_year(): ?int
    {
        return $this->dnr_membership_year ?? null;
    }
    /**
     * Set dnr_membership_year value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dnr_membership_year
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Constituent_DataObjectType
     */
    public function setDnr_membership_year(?int $dnr_membership_year = null): self
    {
        // validation for constraint: int
        if (!is_null($dnr_membership_year) && !(is_int($dnr_membership_year) || ctype_digit($dnr_membership_year))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dnr_membership_year, true), gettype($dnr_membership_year)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($dnr_membership_year) && $dnr_membership_year > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($dnr_membership_year, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($dnr_membership_year) && $dnr_membership_year < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($dnr_membership_year, true)), __LINE__);
        }
        if (is_null($dnr_membership_year) || (is_array($dnr_membership_year) && empty($dnr_membership_year))) {
            unset($this->dnr_membership_year);
        } else {
            $this->dnr_membership_year = $dnr_membership_year;
        }
        
        return $this;
    }
}
