<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Contributor_Gift_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Contributor_Gift_DataObjectType extends AbstractStructBase
{
    /**
     * The gf2__gft_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_key = null;
    /**
     * The gf2__gft_apl_key
     * Meta information extracted from the WSDL
     * - documentation: Appeal Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_apl_key = null;
    /**
     * The gf2__gft_fun_key
     * Meta information extracted from the WSDL
     * - documentation: Purpose. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_fun_key = null;
    /**
     * The gf2__gft_cmp_key
     * Meta information extracted from the WSDL
     * - documentation: Campaign Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_cmp_key = null;
    /**
     * The gf2__gft_gty_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_gty_key = null;
    /**
     * The gf2__gft_date
     * Meta information extracted from the WSDL
     * - documentation: Gift Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_date = null;
    /**
     * The gf2__gft_deductable_amt
     * Meta information extracted from the WSDL
     * - documentation: Tax Deductable Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gf2__gft_deductable_amt = null;
    /**
     * The gf2__gft_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_add_user = null;
    /**
     * The gf2__gft_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_add_date = null;
    /**
     * The gf2__gft_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_change_user = null;
    /**
     * The gf2__gft_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_change_date = null;
    /**
     * The gf2__gft_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_delete_flag = null;
    /**
     * The gf2__gft_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_entity_key = null;
    /**
     * The gf2__gft_frt_key
     * Meta information extracted from the WSDL
     * - documentation: Recognition Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_frt_key = null;
    /**
     * The gf2__gft_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_cst_key = null;
    /**
     * The gf2__gft_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_key_ext = null;
    /**
     * The gf2__gft_fpc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Fund. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_fpc_prd_key = null;
    /**
     * The gf2__gft_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_ivd_key = null;
    /**
     * The gf2__gft_stock_name
     * Meta information extracted from the WSDL
     * - documentation: Stock Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_stock_name = null;
    /**
     * The gf2__gft_acknowledgment_note1
     * Meta information extracted from the WSDL
     * - documentation: acknowledgment note 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_acknowledgment_note1 = null;
    /**
     * The gf2__gft_acknowledgment_note2
     * Meta information extracted from the WSDL
     * - documentation: acknowledgment note 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_acknowledgment_note2 = null;
    /**
     * The gf2__gft_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_cct_key = null;
    /**
     * The gf2__gft_notes
     * Meta information extracted from the WSDL
     * - documentation: notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_notes = null;
    /**
     * The gf2__gft_number_of_shares
     * Meta information extracted from the WSDL
     * - documentation: Number of Shares. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $gf2__gft_number_of_shares = null;
    /**
     * The gf2__gft_pck_key
     * Meta information extracted from the WSDL
     * - documentation: Package Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_pck_key = null;
    /**
     * The gf2__gft_gft_key
     * Meta information extracted from the WSDL
     * - documentation: Parent Gift Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_gft_key = null;
    /**
     * The gf2__gft_prm_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Premium Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_prm_prc_key = null;
    /**
     * The gf2__gft_share_price
     * Meta information extracted from the WSDL
     * - documentation: Share Price. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gf2__gft_share_price = null;
    /**
     * The gf2__gft_anonymous_flag
     * Meta information extracted from the WSDL
     * - documentation: Anonymous. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_anonymous_flag = null;
    /**
     * The gf2__gft_inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_inv_code = null;
    /**
     * The gf2__gft_recognition_customer_adr_line1
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr line1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_recognition_customer_adr_line1 = null;
    /**
     * The gf2__gft_recognition_customer_adr_line2
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr line2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_recognition_customer_adr_line2 = null;
    /**
     * The gf2__gft_soft_money
     * Meta information extracted from the WSDL
     * - documentation: Soft Money. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gf2__gft_soft_money = null;
    /**
     * The gf2__gft_recognition_customer
     * Meta information extracted from the WSDL
     * - documentation: Recognition Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_recognition_customer = null;
    /**
     * The gf2__gft_recognition_customer_adr_line3
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr line3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_recognition_customer_adr_line3 = null;
    /**
     * The gf2__gft_recognition_customer_adr_city
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr city. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_recognition_customer_adr_city = null;
    /**
     * The gf2__gft_recognition_customer_adr_state
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr state. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_recognition_customer_adr_state = null;
    /**
     * The gf2__gft_recognition_customer_adr_post_code
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr post code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_recognition_customer_adr_post_code = null;
    /**
     * The gf2__gft_recognition_customer_adr_country
     * Meta information extracted from the WSDL
     * - documentation: recognition customer adr country.This element has a default value of 'UNITED STATES'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_recognition_customer_adr_country = null;
    /**
     * The gf2__gft_plg_key
     * Meta information extracted from the WSDL
     * - documentation: Pledge Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_plg_key = null;
    /**
     * The gf2__gft_transfer_from_gft_key
     * Meta information extracted from the WSDL
     * - documentation: Transferred from. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_transfer_from_gft_key = null;
    /**
     * The gf2__gft_sct_key
     * Meta information extracted from the WSDL
     * - documentation: soft credit type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_sct_key = null;
    /**
     * The gf2__gft_liquidation_amount
     * Meta information extracted from the WSDL
     * - documentation: liquidation amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gf2__gft_liquidation_amount = null;
    /**
     * The gf2__gft_clg_key
     * Meta information extracted from the WSDL
     * - documentation: match program. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_clg_key = null;
    /**
     * The gf2__gft_other_match_program
     * Meta information extracted from the WSDL
     * - documentation: other. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_other_match_program = null;
    /**
     * The gf2__gft_form_complete_flag
     * Meta information extracted from the WSDL
     * - documentation: form complete. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_form_complete_flag = null;
    /**
     * The gf2__gft_date_sent
     * Meta information extracted from the WSDL
     * - documentation: date sent. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_date_sent = null;
    /**
     * The gf2__gft_date_received
     * Meta information extracted from the WSDL
     * - documentation: date received. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_date_received = null;
    /**
     * The gf2__gft_solicitor_cst_key
     * Meta information extracted from the WSDL
     * - documentation: solicitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_solicitor_cst_key = null;
    /**
     * The gf2__gft_ticker
     * Meta information extracted from the WSDL
     * - documentation: ticker. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_ticker = null;
    /**
     * The gf2__gft_acknowledgment_date
     * Meta information extracted from the WSDL
     * - documentation: Acknowledgment Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_acknowledgment_date = null;
    /**
     * The gf2__gft_batch_code
     * Meta information extracted from the WSDL
     * - documentation: Gift Batch. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_batch_code = null;
    /**
     * The gf2__gft_mail_flag
     * Meta information extracted from the WSDL
     * - documentation: Mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_mail_flag = null;
    /**
     * The gf2__gft_recognize_as
     * Meta information extracted from the WSDL
     * - documentation: recognize as. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_recognize_as = null;
    /**
     * The gf2__gft_liquidation_date
     * Meta information extracted from the WSDL
     * - documentation: liquidation date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_liquidation_date = null;
    /**
     * The gf2__gft_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source Code Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_src_key = null;
    /**
     * The gf2__gft_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Registrant Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_reg_key = null;
    /**
     * The gf2__gft_tax_receipt_sent_date
     * Meta information extracted from the WSDL
     * - documentation: Tax Receipt Sent Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_tax_receipt_sent_date = null;
    /**
     * The gf2__gft_tbt_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Tribute. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_tbt_key = null;
    /**
     * The gf2__gft_personal_message
     * Meta information extracted from the WSDL
     * - documentation: Message. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_personal_message = null;
    /**
     * The gf2__gft_dnr_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Donor Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_dnr_cst_key = null;
    /**
     * The gf2__gft_property_name
     * Meta information extracted from the WSDL
     * - documentation: property name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_property_name = null;
    /**
     * The gf2__gft_related_gift_key
     * Meta information extracted from the WSDL
     * - documentation: Related gift key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gf2__gft_related_gift_key = null;
    /**
     * The gf2__gft_update_funds_raised_pending_flag
     * Meta information extracted from the WSDL
     * - documentation: gf2__gft_update_funds_raised_pending_flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_update_funds_raised_pending_flag = null;
    /**
     * The gf2__gft_receipt_status
     * Meta information extracted from the WSDL
     * - documentation: Receipt Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gf2__gft_receipt_status = null;
    /**
     * The gf2__gft_stock_high
     * Meta information extracted from the WSDL
     * - documentation: stock price high.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gf2__gft_stock_high = null;
    /**
     * The gf2__gft_stock_low
     * Meta information extracted from the WSDL
     * - documentation: stock price low.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $gf2__gft_stock_low = null;
    /**
     * Constructor method for FundraisingGift_Contributor_Gift_DataObjectType
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_apl_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_fun_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_cmp_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_gty_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_date()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_deductable_amt()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_add_user()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_add_date()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_change_user()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_change_date()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_delete_flag()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_entity_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_frt_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_cst_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_key_ext()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_fpc_prd_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_ivd_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_stock_name()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_acknowledgment_note1()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_acknowledgment_note2()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_cct_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_notes()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_number_of_shares()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_pck_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_gft_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_prm_prc_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_share_price()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_anonymous_flag()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_inv_code()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_recognition_customer_adr_line1()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_recognition_customer_adr_line2()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_soft_money()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_recognition_customer()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_recognition_customer_adr_line3()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_recognition_customer_adr_city()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_recognition_customer_adr_state()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_recognition_customer_adr_post_code()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_recognition_customer_adr_country()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_plg_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_transfer_from_gft_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_sct_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_liquidation_amount()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_clg_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_other_match_program()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_form_complete_flag()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_date_sent()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_date_received()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_solicitor_cst_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_ticker()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_acknowledgment_date()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_batch_code()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_mail_flag()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_recognize_as()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_liquidation_date()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_src_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_reg_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_tax_receipt_sent_date()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_tbt_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_personal_message()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_dnr_cst_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_property_name()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_related_gift_key()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_update_funds_raised_pending_flag()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_receipt_status()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_stock_high()
     * @uses FundraisingGift_Contributor_Gift_DataObjectType::setGf2__gft_stock_low()
     * @param string $gf2__gft_key
     * @param string $gf2__gft_apl_key
     * @param string $gf2__gft_fun_key
     * @param string $gf2__gft_cmp_key
     * @param string $gf2__gft_gty_key
     * @param string $gf2__gft_date
     * @param float $gf2__gft_deductable_amt
     * @param string $gf2__gft_add_user
     * @param string $gf2__gft_add_date
     * @param string $gf2__gft_change_user
     * @param string $gf2__gft_change_date
     * @param string $gf2__gft_delete_flag
     * @param string $gf2__gft_entity_key
     * @param string $gf2__gft_frt_key
     * @param string $gf2__gft_cst_key
     * @param string $gf2__gft_key_ext
     * @param string $gf2__gft_fpc_prd_key
     * @param string $gf2__gft_ivd_key
     * @param string $gf2__gft_stock_name
     * @param string $gf2__gft_acknowledgment_note1
     * @param string $gf2__gft_acknowledgment_note2
     * @param string $gf2__gft_cct_key
     * @param string $gf2__gft_notes
     * @param float $gf2__gft_number_of_shares
     * @param string $gf2__gft_pck_key
     * @param string $gf2__gft_gft_key
     * @param string $gf2__gft_prm_prc_key
     * @param float $gf2__gft_share_price
     * @param string $gf2__gft_anonymous_flag
     * @param string $gf2__gft_inv_code
     * @param string $gf2__gft_recognition_customer_adr_line1
     * @param string $gf2__gft_recognition_customer_adr_line2
     * @param float $gf2__gft_soft_money
     * @param string $gf2__gft_recognition_customer
     * @param string $gf2__gft_recognition_customer_adr_line3
     * @param string $gf2__gft_recognition_customer_adr_city
     * @param string $gf2__gft_recognition_customer_adr_state
     * @param string $gf2__gft_recognition_customer_adr_post_code
     * @param string $gf2__gft_recognition_customer_adr_country
     * @param string $gf2__gft_plg_key
     * @param string $gf2__gft_transfer_from_gft_key
     * @param string $gf2__gft_sct_key
     * @param float $gf2__gft_liquidation_amount
     * @param string $gf2__gft_clg_key
     * @param string $gf2__gft_other_match_program
     * @param string $gf2__gft_form_complete_flag
     * @param string $gf2__gft_date_sent
     * @param string $gf2__gft_date_received
     * @param string $gf2__gft_solicitor_cst_key
     * @param string $gf2__gft_ticker
     * @param string $gf2__gft_acknowledgment_date
     * @param string $gf2__gft_batch_code
     * @param string $gf2__gft_mail_flag
     * @param string $gf2__gft_recognize_as
     * @param string $gf2__gft_liquidation_date
     * @param string $gf2__gft_src_key
     * @param string $gf2__gft_reg_key
     * @param string $gf2__gft_tax_receipt_sent_date
     * @param string $gf2__gft_tbt_key
     * @param string $gf2__gft_personal_message
     * @param string $gf2__gft_dnr_cst_key
     * @param string $gf2__gft_property_name
     * @param string $gf2__gft_related_gift_key
     * @param string $gf2__gft_update_funds_raised_pending_flag
     * @param string $gf2__gft_receipt_status
     * @param float $gf2__gft_stock_high
     * @param float $gf2__gft_stock_low
     */
    public function __construct(?string $gf2__gft_key = null, ?string $gf2__gft_apl_key = null, ?string $gf2__gft_fun_key = null, ?string $gf2__gft_cmp_key = null, ?string $gf2__gft_gty_key = null, ?string $gf2__gft_date = null, ?float $gf2__gft_deductable_amt = null, ?string $gf2__gft_add_user = null, ?string $gf2__gft_add_date = null, ?string $gf2__gft_change_user = null, ?string $gf2__gft_change_date = null, ?string $gf2__gft_delete_flag = null, ?string $gf2__gft_entity_key = null, ?string $gf2__gft_frt_key = null, ?string $gf2__gft_cst_key = null, ?string $gf2__gft_key_ext = null, ?string $gf2__gft_fpc_prd_key = null, ?string $gf2__gft_ivd_key = null, ?string $gf2__gft_stock_name = null, ?string $gf2__gft_acknowledgment_note1 = null, ?string $gf2__gft_acknowledgment_note2 = null, ?string $gf2__gft_cct_key = null, ?string $gf2__gft_notes = null, ?float $gf2__gft_number_of_shares = null, ?string $gf2__gft_pck_key = null, ?string $gf2__gft_gft_key = null, ?string $gf2__gft_prm_prc_key = null, ?float $gf2__gft_share_price = null, ?string $gf2__gft_anonymous_flag = null, ?string $gf2__gft_inv_code = null, ?string $gf2__gft_recognition_customer_adr_line1 = null, ?string $gf2__gft_recognition_customer_adr_line2 = null, ?float $gf2__gft_soft_money = null, ?string $gf2__gft_recognition_customer = null, ?string $gf2__gft_recognition_customer_adr_line3 = null, ?string $gf2__gft_recognition_customer_adr_city = null, ?string $gf2__gft_recognition_customer_adr_state = null, ?string $gf2__gft_recognition_customer_adr_post_code = null, ?string $gf2__gft_recognition_customer_adr_country = null, ?string $gf2__gft_plg_key = null, ?string $gf2__gft_transfer_from_gft_key = null, ?string $gf2__gft_sct_key = null, ?float $gf2__gft_liquidation_amount = null, ?string $gf2__gft_clg_key = null, ?string $gf2__gft_other_match_program = null, ?string $gf2__gft_form_complete_flag = null, ?string $gf2__gft_date_sent = null, ?string $gf2__gft_date_received = null, ?string $gf2__gft_solicitor_cst_key = null, ?string $gf2__gft_ticker = null, ?string $gf2__gft_acknowledgment_date = null, ?string $gf2__gft_batch_code = null, ?string $gf2__gft_mail_flag = null, ?string $gf2__gft_recognize_as = null, ?string $gf2__gft_liquidation_date = null, ?string $gf2__gft_src_key = null, ?string $gf2__gft_reg_key = null, ?string $gf2__gft_tax_receipt_sent_date = null, ?string $gf2__gft_tbt_key = null, ?string $gf2__gft_personal_message = null, ?string $gf2__gft_dnr_cst_key = null, ?string $gf2__gft_property_name = null, ?string $gf2__gft_related_gift_key = null, ?string $gf2__gft_update_funds_raised_pending_flag = null, ?string $gf2__gft_receipt_status = null, ?float $gf2__gft_stock_high = null, ?float $gf2__gft_stock_low = null)
    {
        $this
            ->setGf2__gft_key($gf2__gft_key)
            ->setGf2__gft_apl_key($gf2__gft_apl_key)
            ->setGf2__gft_fun_key($gf2__gft_fun_key)
            ->setGf2__gft_cmp_key($gf2__gft_cmp_key)
            ->setGf2__gft_gty_key($gf2__gft_gty_key)
            ->setGf2__gft_date($gf2__gft_date)
            ->setGf2__gft_deductable_amt($gf2__gft_deductable_amt)
            ->setGf2__gft_add_user($gf2__gft_add_user)
            ->setGf2__gft_add_date($gf2__gft_add_date)
            ->setGf2__gft_change_user($gf2__gft_change_user)
            ->setGf2__gft_change_date($gf2__gft_change_date)
            ->setGf2__gft_delete_flag($gf2__gft_delete_flag)
            ->setGf2__gft_entity_key($gf2__gft_entity_key)
            ->setGf2__gft_frt_key($gf2__gft_frt_key)
            ->setGf2__gft_cst_key($gf2__gft_cst_key)
            ->setGf2__gft_key_ext($gf2__gft_key_ext)
            ->setGf2__gft_fpc_prd_key($gf2__gft_fpc_prd_key)
            ->setGf2__gft_ivd_key($gf2__gft_ivd_key)
            ->setGf2__gft_stock_name($gf2__gft_stock_name)
            ->setGf2__gft_acknowledgment_note1($gf2__gft_acknowledgment_note1)
            ->setGf2__gft_acknowledgment_note2($gf2__gft_acknowledgment_note2)
            ->setGf2__gft_cct_key($gf2__gft_cct_key)
            ->setGf2__gft_notes($gf2__gft_notes)
            ->setGf2__gft_number_of_shares($gf2__gft_number_of_shares)
            ->setGf2__gft_pck_key($gf2__gft_pck_key)
            ->setGf2__gft_gft_key($gf2__gft_gft_key)
            ->setGf2__gft_prm_prc_key($gf2__gft_prm_prc_key)
            ->setGf2__gft_share_price($gf2__gft_share_price)
            ->setGf2__gft_anonymous_flag($gf2__gft_anonymous_flag)
            ->setGf2__gft_inv_code($gf2__gft_inv_code)
            ->setGf2__gft_recognition_customer_adr_line1($gf2__gft_recognition_customer_adr_line1)
            ->setGf2__gft_recognition_customer_adr_line2($gf2__gft_recognition_customer_adr_line2)
            ->setGf2__gft_soft_money($gf2__gft_soft_money)
            ->setGf2__gft_recognition_customer($gf2__gft_recognition_customer)
            ->setGf2__gft_recognition_customer_adr_line3($gf2__gft_recognition_customer_adr_line3)
            ->setGf2__gft_recognition_customer_adr_city($gf2__gft_recognition_customer_adr_city)
            ->setGf2__gft_recognition_customer_adr_state($gf2__gft_recognition_customer_adr_state)
            ->setGf2__gft_recognition_customer_adr_post_code($gf2__gft_recognition_customer_adr_post_code)
            ->setGf2__gft_recognition_customer_adr_country($gf2__gft_recognition_customer_adr_country)
            ->setGf2__gft_plg_key($gf2__gft_plg_key)
            ->setGf2__gft_transfer_from_gft_key($gf2__gft_transfer_from_gft_key)
            ->setGf2__gft_sct_key($gf2__gft_sct_key)
            ->setGf2__gft_liquidation_amount($gf2__gft_liquidation_amount)
            ->setGf2__gft_clg_key($gf2__gft_clg_key)
            ->setGf2__gft_other_match_program($gf2__gft_other_match_program)
            ->setGf2__gft_form_complete_flag($gf2__gft_form_complete_flag)
            ->setGf2__gft_date_sent($gf2__gft_date_sent)
            ->setGf2__gft_date_received($gf2__gft_date_received)
            ->setGf2__gft_solicitor_cst_key($gf2__gft_solicitor_cst_key)
            ->setGf2__gft_ticker($gf2__gft_ticker)
            ->setGf2__gft_acknowledgment_date($gf2__gft_acknowledgment_date)
            ->setGf2__gft_batch_code($gf2__gft_batch_code)
            ->setGf2__gft_mail_flag($gf2__gft_mail_flag)
            ->setGf2__gft_recognize_as($gf2__gft_recognize_as)
            ->setGf2__gft_liquidation_date($gf2__gft_liquidation_date)
            ->setGf2__gft_src_key($gf2__gft_src_key)
            ->setGf2__gft_reg_key($gf2__gft_reg_key)
            ->setGf2__gft_tax_receipt_sent_date($gf2__gft_tax_receipt_sent_date)
            ->setGf2__gft_tbt_key($gf2__gft_tbt_key)
            ->setGf2__gft_personal_message($gf2__gft_personal_message)
            ->setGf2__gft_dnr_cst_key($gf2__gft_dnr_cst_key)
            ->setGf2__gft_property_name($gf2__gft_property_name)
            ->setGf2__gft_related_gift_key($gf2__gft_related_gift_key)
            ->setGf2__gft_update_funds_raised_pending_flag($gf2__gft_update_funds_raised_pending_flag)
            ->setGf2__gft_receipt_status($gf2__gft_receipt_status)
            ->setGf2__gft_stock_high($gf2__gft_stock_high)
            ->setGf2__gft_stock_low($gf2__gft_stock_low);
    }
    /**
     * Get gf2__gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_key(): ?string
    {
        return $this->gf2__gft_key ?? null;
    }
    /**
     * Set gf2__gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_key(?string $gf2__gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_key) && !is_string($gf2__gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_key, true), gettype($gf2__gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_key) || (is_array($gf2__gft_key) && empty($gf2__gft_key))) {
            unset($this->gf2__gft_key);
        } else {
            $this->gf2__gft_key = $gf2__gft_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_apl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_apl_key(): ?string
    {
        return $this->gf2__gft_apl_key ?? null;
    }
    /**
     * Set gf2__gft_apl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_apl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_apl_key(?string $gf2__gft_apl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_apl_key) && !is_string($gf2__gft_apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_apl_key, true), gettype($gf2__gft_apl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_apl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_apl_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_apl_key) || (is_array($gf2__gft_apl_key) && empty($gf2__gft_apl_key))) {
            unset($this->gf2__gft_apl_key);
        } else {
            $this->gf2__gft_apl_key = $gf2__gft_apl_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_fun_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_fun_key(): ?string
    {
        return $this->gf2__gft_fun_key ?? null;
    }
    /**
     * Set gf2__gft_fun_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_fun_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_fun_key(?string $gf2__gft_fun_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_fun_key) && !is_string($gf2__gft_fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_fun_key, true), gettype($gf2__gft_fun_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_fun_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_fun_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_fun_key) || (is_array($gf2__gft_fun_key) && empty($gf2__gft_fun_key))) {
            unset($this->gf2__gft_fun_key);
        } else {
            $this->gf2__gft_fun_key = $gf2__gft_fun_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_cmp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_cmp_key(): ?string
    {
        return $this->gf2__gft_cmp_key ?? null;
    }
    /**
     * Set gf2__gft_cmp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_cmp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_cmp_key(?string $gf2__gft_cmp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_cmp_key) && !is_string($gf2__gft_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_cmp_key, true), gettype($gf2__gft_cmp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_cmp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_cmp_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_cmp_key) || (is_array($gf2__gft_cmp_key) && empty($gf2__gft_cmp_key))) {
            unset($this->gf2__gft_cmp_key);
        } else {
            $this->gf2__gft_cmp_key = $gf2__gft_cmp_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_gty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_gty_key(): ?string
    {
        return $this->gf2__gft_gty_key ?? null;
    }
    /**
     * Set gf2__gft_gty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_gty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_gty_key(?string $gf2__gft_gty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_gty_key) && !is_string($gf2__gft_gty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_gty_key, true), gettype($gf2__gft_gty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_gty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_gty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_gty_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_gty_key) || (is_array($gf2__gft_gty_key) && empty($gf2__gft_gty_key))) {
            unset($this->gf2__gft_gty_key);
        } else {
            $this->gf2__gft_gty_key = $gf2__gft_gty_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_date(): ?string
    {
        return $this->gf2__gft_date ?? null;
    }
    /**
     * Set gf2__gft_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_date(?string $gf2__gft_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_date) && !is_string($gf2__gft_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_date, true), gettype($gf2__gft_date)), __LINE__);
        }
        if (is_null($gf2__gft_date) || (is_array($gf2__gft_date) && empty($gf2__gft_date))) {
            unset($this->gf2__gft_date);
        } else {
            $this->gf2__gft_date = $gf2__gft_date;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_deductable_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGf2__gft_deductable_amt(): ?float
    {
        return $this->gf2__gft_deductable_amt ?? null;
    }
    /**
     * Set gf2__gft_deductable_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gf2__gft_deductable_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_deductable_amt(?float $gf2__gft_deductable_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($gf2__gft_deductable_amt) && !(is_float($gf2__gft_deductable_amt) || is_numeric($gf2__gft_deductable_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gf2__gft_deductable_amt, true), gettype($gf2__gft_deductable_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gf2__gft_deductable_amt) && mb_strlen(mb_substr((string) $gf2__gft_deductable_amt, false !== mb_strpos((string) $gf2__gft_deductable_amt, '.') ? mb_strpos((string) $gf2__gft_deductable_amt, '.') + 1 : mb_strlen((string) $gf2__gft_deductable_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gf2__gft_deductable_amt, true), mb_strlen(mb_substr((string) $gf2__gft_deductable_amt, mb_strpos((string) $gf2__gft_deductable_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gf2__gft_deductable_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_deductable_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gf2__gft_deductable_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_deductable_amt))), __LINE__);
        }
        if (is_null($gf2__gft_deductable_amt) || (is_array($gf2__gft_deductable_amt) && empty($gf2__gft_deductable_amt))) {
            unset($this->gf2__gft_deductable_amt);
        } else {
            $this->gf2__gft_deductable_amt = $gf2__gft_deductable_amt;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_add_user(): ?string
    {
        return $this->gf2__gft_add_user ?? null;
    }
    /**
     * Set gf2__gft_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_add_user(?string $gf2__gft_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_add_user) && !is_string($gf2__gft_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_add_user, true), gettype($gf2__gft_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($gf2__gft_add_user) && mb_strlen((string) $gf2__gft_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $gf2__gft_add_user)), __LINE__);
        }
        if (is_null($gf2__gft_add_user) || (is_array($gf2__gft_add_user) && empty($gf2__gft_add_user))) {
            unset($this->gf2__gft_add_user);
        } else {
            $this->gf2__gft_add_user = $gf2__gft_add_user;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_add_date(): ?string
    {
        return $this->gf2__gft_add_date ?? null;
    }
    /**
     * Set gf2__gft_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_add_date(?string $gf2__gft_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_add_date) && !is_string($gf2__gft_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_add_date, true), gettype($gf2__gft_add_date)), __LINE__);
        }
        if (is_null($gf2__gft_add_date) || (is_array($gf2__gft_add_date) && empty($gf2__gft_add_date))) {
            unset($this->gf2__gft_add_date);
        } else {
            $this->gf2__gft_add_date = $gf2__gft_add_date;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_change_user(): ?string
    {
        return $this->gf2__gft_change_user ?? null;
    }
    /**
     * Set gf2__gft_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_change_user(?string $gf2__gft_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_change_user) && !is_string($gf2__gft_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_change_user, true), gettype($gf2__gft_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($gf2__gft_change_user) && mb_strlen((string) $gf2__gft_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $gf2__gft_change_user)), __LINE__);
        }
        if (is_null($gf2__gft_change_user) || (is_array($gf2__gft_change_user) && empty($gf2__gft_change_user))) {
            unset($this->gf2__gft_change_user);
        } else {
            $this->gf2__gft_change_user = $gf2__gft_change_user;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_change_date(): ?string
    {
        return $this->gf2__gft_change_date ?? null;
    }
    /**
     * Set gf2__gft_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_change_date(?string $gf2__gft_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_change_date) && !is_string($gf2__gft_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_change_date, true), gettype($gf2__gft_change_date)), __LINE__);
        }
        if (is_null($gf2__gft_change_date) || (is_array($gf2__gft_change_date) && empty($gf2__gft_change_date))) {
            unset($this->gf2__gft_change_date);
        } else {
            $this->gf2__gft_change_date = $gf2__gft_change_date;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_delete_flag(): ?string
    {
        return $this->gf2__gft_delete_flag ?? null;
    }
    /**
     * Set gf2__gft_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_delete_flag(?string $gf2__gft_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_delete_flag) && !is_string($gf2__gft_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_delete_flag, true), gettype($gf2__gft_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gf2__gft_delete_flag) && $gf2__gft_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gf2__gft_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gf2__gft_delete_flag) && $gf2__gft_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gf2__gft_delete_flag, true)), __LINE__);
        }
        if (is_null($gf2__gft_delete_flag) || (is_array($gf2__gft_delete_flag) && empty($gf2__gft_delete_flag))) {
            unset($this->gf2__gft_delete_flag);
        } else {
            $this->gf2__gft_delete_flag = $gf2__gft_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_entity_key(): ?string
    {
        return $this->gf2__gft_entity_key ?? null;
    }
    /**
     * Set gf2__gft_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_entity_key(?string $gf2__gft_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_entity_key) && !is_string($gf2__gft_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_entity_key, true), gettype($gf2__gft_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_entity_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_entity_key) || (is_array($gf2__gft_entity_key) && empty($gf2__gft_entity_key))) {
            unset($this->gf2__gft_entity_key);
        } else {
            $this->gf2__gft_entity_key = $gf2__gft_entity_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_frt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_frt_key(): ?string
    {
        return $this->gf2__gft_frt_key ?? null;
    }
    /**
     * Set gf2__gft_frt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_frt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_frt_key(?string $gf2__gft_frt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_frt_key) && !is_string($gf2__gft_frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_frt_key, true), gettype($gf2__gft_frt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_frt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_frt_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_frt_key) || (is_array($gf2__gft_frt_key) && empty($gf2__gft_frt_key))) {
            unset($this->gf2__gft_frt_key);
        } else {
            $this->gf2__gft_frt_key = $gf2__gft_frt_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_cst_key(): ?string
    {
        return $this->gf2__gft_cst_key ?? null;
    }
    /**
     * Set gf2__gft_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_cst_key(?string $gf2__gft_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_cst_key) && !is_string($gf2__gft_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_cst_key, true), gettype($gf2__gft_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_cst_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_cst_key) || (is_array($gf2__gft_cst_key) && empty($gf2__gft_cst_key))) {
            unset($this->gf2__gft_cst_key);
        } else {
            $this->gf2__gft_cst_key = $gf2__gft_cst_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_key_ext(): ?string
    {
        return $this->gf2__gft_key_ext ?? null;
    }
    /**
     * Set gf2__gft_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_key_ext(?string $gf2__gft_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_key_ext) && !is_string($gf2__gft_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_key_ext, true), gettype($gf2__gft_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_key_ext, true)), __LINE__);
        }
        if (is_null($gf2__gft_key_ext) || (is_array($gf2__gft_key_ext) && empty($gf2__gft_key_ext))) {
            unset($this->gf2__gft_key_ext);
        } else {
            $this->gf2__gft_key_ext = $gf2__gft_key_ext;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_fpc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_fpc_prd_key(): ?string
    {
        return $this->gf2__gft_fpc_prd_key ?? null;
    }
    /**
     * Set gf2__gft_fpc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_fpc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_fpc_prd_key(?string $gf2__gft_fpc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_fpc_prd_key) && !is_string($gf2__gft_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_fpc_prd_key, true), gettype($gf2__gft_fpc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_fpc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_fpc_prd_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_fpc_prd_key) || (is_array($gf2__gft_fpc_prd_key) && empty($gf2__gft_fpc_prd_key))) {
            unset($this->gf2__gft_fpc_prd_key);
        } else {
            $this->gf2__gft_fpc_prd_key = $gf2__gft_fpc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_ivd_key(): ?string
    {
        return $this->gf2__gft_ivd_key ?? null;
    }
    /**
     * Set gf2__gft_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_ivd_key(?string $gf2__gft_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_ivd_key) && !is_string($gf2__gft_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_ivd_key, true), gettype($gf2__gft_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_ivd_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_ivd_key) || (is_array($gf2__gft_ivd_key) && empty($gf2__gft_ivd_key))) {
            unset($this->gf2__gft_ivd_key);
        } else {
            $this->gf2__gft_ivd_key = $gf2__gft_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_stock_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_stock_name(): ?string
    {
        return $this->gf2__gft_stock_name ?? null;
    }
    /**
     * Set gf2__gft_stock_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_stock_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_stock_name(?string $gf2__gft_stock_name = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_stock_name) && !is_string($gf2__gft_stock_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_stock_name, true), gettype($gf2__gft_stock_name)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($gf2__gft_stock_name) && mb_strlen((string) $gf2__gft_stock_name) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $gf2__gft_stock_name)), __LINE__);
        }
        if (is_null($gf2__gft_stock_name) || (is_array($gf2__gft_stock_name) && empty($gf2__gft_stock_name))) {
            unset($this->gf2__gft_stock_name);
        } else {
            $this->gf2__gft_stock_name = $gf2__gft_stock_name;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_acknowledgment_note1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_acknowledgment_note1(): ?string
    {
        return $this->gf2__gft_acknowledgment_note1 ?? null;
    }
    /**
     * Set gf2__gft_acknowledgment_note1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_acknowledgment_note1
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_acknowledgment_note1(?string $gf2__gft_acknowledgment_note1 = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_acknowledgment_note1) && !is_string($gf2__gft_acknowledgment_note1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_acknowledgment_note1, true), gettype($gf2__gft_acknowledgment_note1)), __LINE__);
        }
        if (is_null($gf2__gft_acknowledgment_note1) || (is_array($gf2__gft_acknowledgment_note1) && empty($gf2__gft_acknowledgment_note1))) {
            unset($this->gf2__gft_acknowledgment_note1);
        } else {
            $this->gf2__gft_acknowledgment_note1 = $gf2__gft_acknowledgment_note1;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_acknowledgment_note2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_acknowledgment_note2(): ?string
    {
        return $this->gf2__gft_acknowledgment_note2 ?? null;
    }
    /**
     * Set gf2__gft_acknowledgment_note2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_acknowledgment_note2
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_acknowledgment_note2(?string $gf2__gft_acknowledgment_note2 = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_acknowledgment_note2) && !is_string($gf2__gft_acknowledgment_note2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_acknowledgment_note2, true), gettype($gf2__gft_acknowledgment_note2)), __LINE__);
        }
        if (is_null($gf2__gft_acknowledgment_note2) || (is_array($gf2__gft_acknowledgment_note2) && empty($gf2__gft_acknowledgment_note2))) {
            unset($this->gf2__gft_acknowledgment_note2);
        } else {
            $this->gf2__gft_acknowledgment_note2 = $gf2__gft_acknowledgment_note2;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_cct_key(): ?string
    {
        return $this->gf2__gft_cct_key ?? null;
    }
    /**
     * Set gf2__gft_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_cct_key(?string $gf2__gft_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_cct_key) && !is_string($gf2__gft_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_cct_key, true), gettype($gf2__gft_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_cct_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_cct_key) || (is_array($gf2__gft_cct_key) && empty($gf2__gft_cct_key))) {
            unset($this->gf2__gft_cct_key);
        } else {
            $this->gf2__gft_cct_key = $gf2__gft_cct_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_notes(): ?string
    {
        return $this->gf2__gft_notes ?? null;
    }
    /**
     * Set gf2__gft_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_notes(?string $gf2__gft_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_notes) && !is_string($gf2__gft_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_notes, true), gettype($gf2__gft_notes)), __LINE__);
        }
        if (is_null($gf2__gft_notes) || (is_array($gf2__gft_notes) && empty($gf2__gft_notes))) {
            unset($this->gf2__gft_notes);
        } else {
            $this->gf2__gft_notes = $gf2__gft_notes;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_number_of_shares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGf2__gft_number_of_shares(): ?float
    {
        return $this->gf2__gft_number_of_shares ?? null;
    }
    /**
     * Set gf2__gft_number_of_shares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gf2__gft_number_of_shares
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_number_of_shares(?float $gf2__gft_number_of_shares = null): self
    {
        // validation for constraint: float
        if (!is_null($gf2__gft_number_of_shares) && !(is_float($gf2__gft_number_of_shares) || is_numeric($gf2__gft_number_of_shares))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gf2__gft_number_of_shares, true), gettype($gf2__gft_number_of_shares)), __LINE__);
        }
        if (is_null($gf2__gft_number_of_shares) || (is_array($gf2__gft_number_of_shares) && empty($gf2__gft_number_of_shares))) {
            unset($this->gf2__gft_number_of_shares);
        } else {
            $this->gf2__gft_number_of_shares = $gf2__gft_number_of_shares;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_pck_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_pck_key(): ?string
    {
        return $this->gf2__gft_pck_key ?? null;
    }
    /**
     * Set gf2__gft_pck_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_pck_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_pck_key(?string $gf2__gft_pck_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_pck_key) && !is_string($gf2__gft_pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_pck_key, true), gettype($gf2__gft_pck_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_pck_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_pck_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_pck_key) || (is_array($gf2__gft_pck_key) && empty($gf2__gft_pck_key))) {
            unset($this->gf2__gft_pck_key);
        } else {
            $this->gf2__gft_pck_key = $gf2__gft_pck_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_gft_key(): ?string
    {
        return $this->gf2__gft_gft_key ?? null;
    }
    /**
     * Set gf2__gft_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_gft_key(?string $gf2__gft_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_gft_key) && !is_string($gf2__gft_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_gft_key, true), gettype($gf2__gft_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_gft_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_gft_key) || (is_array($gf2__gft_gft_key) && empty($gf2__gft_gft_key))) {
            unset($this->gf2__gft_gft_key);
        } else {
            $this->gf2__gft_gft_key = $gf2__gft_gft_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_prm_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_prm_prc_key(): ?string
    {
        return $this->gf2__gft_prm_prc_key ?? null;
    }
    /**
     * Set gf2__gft_prm_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_prm_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_prm_prc_key(?string $gf2__gft_prm_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_prm_prc_key) && !is_string($gf2__gft_prm_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_prm_prc_key, true), gettype($gf2__gft_prm_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_prm_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_prm_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_prm_prc_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_prm_prc_key) || (is_array($gf2__gft_prm_prc_key) && empty($gf2__gft_prm_prc_key))) {
            unset($this->gf2__gft_prm_prc_key);
        } else {
            $this->gf2__gft_prm_prc_key = $gf2__gft_prm_prc_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_share_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGf2__gft_share_price(): ?float
    {
        return $this->gf2__gft_share_price ?? null;
    }
    /**
     * Set gf2__gft_share_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gf2__gft_share_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_share_price(?float $gf2__gft_share_price = null): self
    {
        // validation for constraint: float
        if (!is_null($gf2__gft_share_price) && !(is_float($gf2__gft_share_price) || is_numeric($gf2__gft_share_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gf2__gft_share_price, true), gettype($gf2__gft_share_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gf2__gft_share_price) && mb_strlen(mb_substr((string) $gf2__gft_share_price, false !== mb_strpos((string) $gf2__gft_share_price, '.') ? mb_strpos((string) $gf2__gft_share_price, '.') + 1 : mb_strlen((string) $gf2__gft_share_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gf2__gft_share_price, true), mb_strlen(mb_substr((string) $gf2__gft_share_price, mb_strpos((string) $gf2__gft_share_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gf2__gft_share_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_share_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gf2__gft_share_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_share_price))), __LINE__);
        }
        if (is_null($gf2__gft_share_price) || (is_array($gf2__gft_share_price) && empty($gf2__gft_share_price))) {
            unset($this->gf2__gft_share_price);
        } else {
            $this->gf2__gft_share_price = $gf2__gft_share_price;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_anonymous_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_anonymous_flag(): ?string
    {
        return $this->gf2__gft_anonymous_flag ?? null;
    }
    /**
     * Set gf2__gft_anonymous_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_anonymous_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_anonymous_flag(?string $gf2__gft_anonymous_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_anonymous_flag) && !is_string($gf2__gft_anonymous_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_anonymous_flag, true), gettype($gf2__gft_anonymous_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gf2__gft_anonymous_flag) && $gf2__gft_anonymous_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gf2__gft_anonymous_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gf2__gft_anonymous_flag) && $gf2__gft_anonymous_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gf2__gft_anonymous_flag, true)), __LINE__);
        }
        if (is_null($gf2__gft_anonymous_flag) || (is_array($gf2__gft_anonymous_flag) && empty($gf2__gft_anonymous_flag))) {
            unset($this->gf2__gft_anonymous_flag);
        } else {
            $this->gf2__gft_anonymous_flag = $gf2__gft_anonymous_flag;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_inv_code(): ?string
    {
        return $this->gf2__gft_inv_code ?? null;
    }
    /**
     * Set gf2__gft_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_inv_code(?string $gf2__gft_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_inv_code) && !is_string($gf2__gft_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_inv_code, true), gettype($gf2__gft_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($gf2__gft_inv_code) && mb_strlen((string) $gf2__gft_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $gf2__gft_inv_code)), __LINE__);
        }
        if (is_null($gf2__gft_inv_code) || (is_array($gf2__gft_inv_code) && empty($gf2__gft_inv_code))) {
            unset($this->gf2__gft_inv_code);
        } else {
            $this->gf2__gft_inv_code = $gf2__gft_inv_code;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_recognition_customer_adr_line1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_recognition_customer_adr_line1(): ?string
    {
        return $this->gf2__gft_recognition_customer_adr_line1 ?? null;
    }
    /**
     * Set gf2__gft_recognition_customer_adr_line1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_recognition_customer_adr_line1
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_recognition_customer_adr_line1(?string $gf2__gft_recognition_customer_adr_line1 = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_recognition_customer_adr_line1) && !is_string($gf2__gft_recognition_customer_adr_line1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_recognition_customer_adr_line1, true), gettype($gf2__gft_recognition_customer_adr_line1)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($gf2__gft_recognition_customer_adr_line1) && mb_strlen((string) $gf2__gft_recognition_customer_adr_line1) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $gf2__gft_recognition_customer_adr_line1)), __LINE__);
        }
        if (is_null($gf2__gft_recognition_customer_adr_line1) || (is_array($gf2__gft_recognition_customer_adr_line1) && empty($gf2__gft_recognition_customer_adr_line1))) {
            unset($this->gf2__gft_recognition_customer_adr_line1);
        } else {
            $this->gf2__gft_recognition_customer_adr_line1 = $gf2__gft_recognition_customer_adr_line1;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_recognition_customer_adr_line2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_recognition_customer_adr_line2(): ?string
    {
        return $this->gf2__gft_recognition_customer_adr_line2 ?? null;
    }
    /**
     * Set gf2__gft_recognition_customer_adr_line2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_recognition_customer_adr_line2
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_recognition_customer_adr_line2(?string $gf2__gft_recognition_customer_adr_line2 = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_recognition_customer_adr_line2) && !is_string($gf2__gft_recognition_customer_adr_line2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_recognition_customer_adr_line2, true), gettype($gf2__gft_recognition_customer_adr_line2)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($gf2__gft_recognition_customer_adr_line2) && mb_strlen((string) $gf2__gft_recognition_customer_adr_line2) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $gf2__gft_recognition_customer_adr_line2)), __LINE__);
        }
        if (is_null($gf2__gft_recognition_customer_adr_line2) || (is_array($gf2__gft_recognition_customer_adr_line2) && empty($gf2__gft_recognition_customer_adr_line2))) {
            unset($this->gf2__gft_recognition_customer_adr_line2);
        } else {
            $this->gf2__gft_recognition_customer_adr_line2 = $gf2__gft_recognition_customer_adr_line2;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_soft_money value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGf2__gft_soft_money(): ?float
    {
        return $this->gf2__gft_soft_money ?? null;
    }
    /**
     * Set gf2__gft_soft_money value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gf2__gft_soft_money
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_soft_money(?float $gf2__gft_soft_money = null): self
    {
        // validation for constraint: float
        if (!is_null($gf2__gft_soft_money) && !(is_float($gf2__gft_soft_money) || is_numeric($gf2__gft_soft_money))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gf2__gft_soft_money, true), gettype($gf2__gft_soft_money)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gf2__gft_soft_money) && mb_strlen(mb_substr((string) $gf2__gft_soft_money, false !== mb_strpos((string) $gf2__gft_soft_money, '.') ? mb_strpos((string) $gf2__gft_soft_money, '.') + 1 : mb_strlen((string) $gf2__gft_soft_money))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gf2__gft_soft_money, true), mb_strlen(mb_substr((string) $gf2__gft_soft_money, mb_strpos((string) $gf2__gft_soft_money, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gf2__gft_soft_money) && mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_soft_money)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gf2__gft_soft_money, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_soft_money))), __LINE__);
        }
        if (is_null($gf2__gft_soft_money) || (is_array($gf2__gft_soft_money) && empty($gf2__gft_soft_money))) {
            unset($this->gf2__gft_soft_money);
        } else {
            $this->gf2__gft_soft_money = $gf2__gft_soft_money;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_recognition_customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_recognition_customer(): ?string
    {
        return $this->gf2__gft_recognition_customer ?? null;
    }
    /**
     * Set gf2__gft_recognition_customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_recognition_customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_recognition_customer(?string $gf2__gft_recognition_customer = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_recognition_customer) && !is_string($gf2__gft_recognition_customer)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_recognition_customer, true), gettype($gf2__gft_recognition_customer)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($gf2__gft_recognition_customer) && mb_strlen((string) $gf2__gft_recognition_customer) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $gf2__gft_recognition_customer)), __LINE__);
        }
        if (is_null($gf2__gft_recognition_customer) || (is_array($gf2__gft_recognition_customer) && empty($gf2__gft_recognition_customer))) {
            unset($this->gf2__gft_recognition_customer);
        } else {
            $this->gf2__gft_recognition_customer = $gf2__gft_recognition_customer;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_recognition_customer_adr_line3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_recognition_customer_adr_line3(): ?string
    {
        return $this->gf2__gft_recognition_customer_adr_line3 ?? null;
    }
    /**
     * Set gf2__gft_recognition_customer_adr_line3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_recognition_customer_adr_line3
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_recognition_customer_adr_line3(?string $gf2__gft_recognition_customer_adr_line3 = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_recognition_customer_adr_line3) && !is_string($gf2__gft_recognition_customer_adr_line3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_recognition_customer_adr_line3, true), gettype($gf2__gft_recognition_customer_adr_line3)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($gf2__gft_recognition_customer_adr_line3) && mb_strlen((string) $gf2__gft_recognition_customer_adr_line3) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $gf2__gft_recognition_customer_adr_line3)), __LINE__);
        }
        if (is_null($gf2__gft_recognition_customer_adr_line3) || (is_array($gf2__gft_recognition_customer_adr_line3) && empty($gf2__gft_recognition_customer_adr_line3))) {
            unset($this->gf2__gft_recognition_customer_adr_line3);
        } else {
            $this->gf2__gft_recognition_customer_adr_line3 = $gf2__gft_recognition_customer_adr_line3;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_recognition_customer_adr_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_recognition_customer_adr_city(): ?string
    {
        return $this->gf2__gft_recognition_customer_adr_city ?? null;
    }
    /**
     * Set gf2__gft_recognition_customer_adr_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_recognition_customer_adr_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_recognition_customer_adr_city(?string $gf2__gft_recognition_customer_adr_city = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_recognition_customer_adr_city) && !is_string($gf2__gft_recognition_customer_adr_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_recognition_customer_adr_city, true), gettype($gf2__gft_recognition_customer_adr_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($gf2__gft_recognition_customer_adr_city) && mb_strlen((string) $gf2__gft_recognition_customer_adr_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $gf2__gft_recognition_customer_adr_city)), __LINE__);
        }
        if (is_null($gf2__gft_recognition_customer_adr_city) || (is_array($gf2__gft_recognition_customer_adr_city) && empty($gf2__gft_recognition_customer_adr_city))) {
            unset($this->gf2__gft_recognition_customer_adr_city);
        } else {
            $this->gf2__gft_recognition_customer_adr_city = $gf2__gft_recognition_customer_adr_city;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_recognition_customer_adr_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_recognition_customer_adr_state(): ?string
    {
        return $this->gf2__gft_recognition_customer_adr_state ?? null;
    }
    /**
     * Set gf2__gft_recognition_customer_adr_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_recognition_customer_adr_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_recognition_customer_adr_state(?string $gf2__gft_recognition_customer_adr_state = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_recognition_customer_adr_state) && !is_string($gf2__gft_recognition_customer_adr_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_recognition_customer_adr_state, true), gettype($gf2__gft_recognition_customer_adr_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($gf2__gft_recognition_customer_adr_state) && mb_strlen((string) $gf2__gft_recognition_customer_adr_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $gf2__gft_recognition_customer_adr_state)), __LINE__);
        }
        if (is_null($gf2__gft_recognition_customer_adr_state) || (is_array($gf2__gft_recognition_customer_adr_state) && empty($gf2__gft_recognition_customer_adr_state))) {
            unset($this->gf2__gft_recognition_customer_adr_state);
        } else {
            $this->gf2__gft_recognition_customer_adr_state = $gf2__gft_recognition_customer_adr_state;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_recognition_customer_adr_post_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_recognition_customer_adr_post_code(): ?string
    {
        return $this->gf2__gft_recognition_customer_adr_post_code ?? null;
    }
    /**
     * Set gf2__gft_recognition_customer_adr_post_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_recognition_customer_adr_post_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_recognition_customer_adr_post_code(?string $gf2__gft_recognition_customer_adr_post_code = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_recognition_customer_adr_post_code) && !is_string($gf2__gft_recognition_customer_adr_post_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_recognition_customer_adr_post_code, true), gettype($gf2__gft_recognition_customer_adr_post_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($gf2__gft_recognition_customer_adr_post_code) && mb_strlen((string) $gf2__gft_recognition_customer_adr_post_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $gf2__gft_recognition_customer_adr_post_code)), __LINE__);
        }
        if (is_null($gf2__gft_recognition_customer_adr_post_code) || (is_array($gf2__gft_recognition_customer_adr_post_code) && empty($gf2__gft_recognition_customer_adr_post_code))) {
            unset($this->gf2__gft_recognition_customer_adr_post_code);
        } else {
            $this->gf2__gft_recognition_customer_adr_post_code = $gf2__gft_recognition_customer_adr_post_code;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_recognition_customer_adr_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_recognition_customer_adr_country(): ?string
    {
        return $this->gf2__gft_recognition_customer_adr_country ?? null;
    }
    /**
     * Set gf2__gft_recognition_customer_adr_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_recognition_customer_adr_country
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_recognition_customer_adr_country(?string $gf2__gft_recognition_customer_adr_country = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_recognition_customer_adr_country) && !is_string($gf2__gft_recognition_customer_adr_country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_recognition_customer_adr_country, true), gettype($gf2__gft_recognition_customer_adr_country)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($gf2__gft_recognition_customer_adr_country) && mb_strlen((string) $gf2__gft_recognition_customer_adr_country) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $gf2__gft_recognition_customer_adr_country)), __LINE__);
        }
        if (is_null($gf2__gft_recognition_customer_adr_country) || (is_array($gf2__gft_recognition_customer_adr_country) && empty($gf2__gft_recognition_customer_adr_country))) {
            unset($this->gf2__gft_recognition_customer_adr_country);
        } else {
            $this->gf2__gft_recognition_customer_adr_country = $gf2__gft_recognition_customer_adr_country;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_plg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_plg_key(): ?string
    {
        return $this->gf2__gft_plg_key ?? null;
    }
    /**
     * Set gf2__gft_plg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_plg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_plg_key(?string $gf2__gft_plg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_plg_key) && !is_string($gf2__gft_plg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_plg_key, true), gettype($gf2__gft_plg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_plg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_plg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_plg_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_plg_key) || (is_array($gf2__gft_plg_key) && empty($gf2__gft_plg_key))) {
            unset($this->gf2__gft_plg_key);
        } else {
            $this->gf2__gft_plg_key = $gf2__gft_plg_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_transfer_from_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_transfer_from_gft_key(): ?string
    {
        return $this->gf2__gft_transfer_from_gft_key ?? null;
    }
    /**
     * Set gf2__gft_transfer_from_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_transfer_from_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_transfer_from_gft_key(?string $gf2__gft_transfer_from_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_transfer_from_gft_key) && !is_string($gf2__gft_transfer_from_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_transfer_from_gft_key, true), gettype($gf2__gft_transfer_from_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_transfer_from_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_transfer_from_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_transfer_from_gft_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_transfer_from_gft_key) || (is_array($gf2__gft_transfer_from_gft_key) && empty($gf2__gft_transfer_from_gft_key))) {
            unset($this->gf2__gft_transfer_from_gft_key);
        } else {
            $this->gf2__gft_transfer_from_gft_key = $gf2__gft_transfer_from_gft_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_sct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_sct_key(): ?string
    {
        return $this->gf2__gft_sct_key ?? null;
    }
    /**
     * Set gf2__gft_sct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_sct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_sct_key(?string $gf2__gft_sct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_sct_key) && !is_string($gf2__gft_sct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_sct_key, true), gettype($gf2__gft_sct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_sct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_sct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_sct_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_sct_key) || (is_array($gf2__gft_sct_key) && empty($gf2__gft_sct_key))) {
            unset($this->gf2__gft_sct_key);
        } else {
            $this->gf2__gft_sct_key = $gf2__gft_sct_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_liquidation_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGf2__gft_liquidation_amount(): ?float
    {
        return $this->gf2__gft_liquidation_amount ?? null;
    }
    /**
     * Set gf2__gft_liquidation_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gf2__gft_liquidation_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_liquidation_amount(?float $gf2__gft_liquidation_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($gf2__gft_liquidation_amount) && !(is_float($gf2__gft_liquidation_amount) || is_numeric($gf2__gft_liquidation_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gf2__gft_liquidation_amount, true), gettype($gf2__gft_liquidation_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gf2__gft_liquidation_amount) && mb_strlen(mb_substr((string) $gf2__gft_liquidation_amount, false !== mb_strpos((string) $gf2__gft_liquidation_amount, '.') ? mb_strpos((string) $gf2__gft_liquidation_amount, '.') + 1 : mb_strlen((string) $gf2__gft_liquidation_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gf2__gft_liquidation_amount, true), mb_strlen(mb_substr((string) $gf2__gft_liquidation_amount, mb_strpos((string) $gf2__gft_liquidation_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gf2__gft_liquidation_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_liquidation_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gf2__gft_liquidation_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_liquidation_amount))), __LINE__);
        }
        if (is_null($gf2__gft_liquidation_amount) || (is_array($gf2__gft_liquidation_amount) && empty($gf2__gft_liquidation_amount))) {
            unset($this->gf2__gft_liquidation_amount);
        } else {
            $this->gf2__gft_liquidation_amount = $gf2__gft_liquidation_amount;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_clg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_clg_key(): ?string
    {
        return $this->gf2__gft_clg_key ?? null;
    }
    /**
     * Set gf2__gft_clg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_clg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_clg_key(?string $gf2__gft_clg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_clg_key) && !is_string($gf2__gft_clg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_clg_key, true), gettype($gf2__gft_clg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_clg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_clg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_clg_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_clg_key) || (is_array($gf2__gft_clg_key) && empty($gf2__gft_clg_key))) {
            unset($this->gf2__gft_clg_key);
        } else {
            $this->gf2__gft_clg_key = $gf2__gft_clg_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_other_match_program value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_other_match_program(): ?string
    {
        return $this->gf2__gft_other_match_program ?? null;
    }
    /**
     * Set gf2__gft_other_match_program value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_other_match_program
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_other_match_program(?string $gf2__gft_other_match_program = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_other_match_program) && !is_string($gf2__gft_other_match_program)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_other_match_program, true), gettype($gf2__gft_other_match_program)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($gf2__gft_other_match_program) && mb_strlen((string) $gf2__gft_other_match_program) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $gf2__gft_other_match_program)), __LINE__);
        }
        if (is_null($gf2__gft_other_match_program) || (is_array($gf2__gft_other_match_program) && empty($gf2__gft_other_match_program))) {
            unset($this->gf2__gft_other_match_program);
        } else {
            $this->gf2__gft_other_match_program = $gf2__gft_other_match_program;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_form_complete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_form_complete_flag(): ?string
    {
        return $this->gf2__gft_form_complete_flag ?? null;
    }
    /**
     * Set gf2__gft_form_complete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_form_complete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_form_complete_flag(?string $gf2__gft_form_complete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_form_complete_flag) && !is_string($gf2__gft_form_complete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_form_complete_flag, true), gettype($gf2__gft_form_complete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gf2__gft_form_complete_flag) && $gf2__gft_form_complete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gf2__gft_form_complete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gf2__gft_form_complete_flag) && $gf2__gft_form_complete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gf2__gft_form_complete_flag, true)), __LINE__);
        }
        if (is_null($gf2__gft_form_complete_flag) || (is_array($gf2__gft_form_complete_flag) && empty($gf2__gft_form_complete_flag))) {
            unset($this->gf2__gft_form_complete_flag);
        } else {
            $this->gf2__gft_form_complete_flag = $gf2__gft_form_complete_flag;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_date_sent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_date_sent(): ?string
    {
        return $this->gf2__gft_date_sent ?? null;
    }
    /**
     * Set gf2__gft_date_sent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_date_sent
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_date_sent(?string $gf2__gft_date_sent = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_date_sent) && !is_string($gf2__gft_date_sent)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_date_sent, true), gettype($gf2__gft_date_sent)), __LINE__);
        }
        if (is_null($gf2__gft_date_sent) || (is_array($gf2__gft_date_sent) && empty($gf2__gft_date_sent))) {
            unset($this->gf2__gft_date_sent);
        } else {
            $this->gf2__gft_date_sent = $gf2__gft_date_sent;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_date_received value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_date_received(): ?string
    {
        return $this->gf2__gft_date_received ?? null;
    }
    /**
     * Set gf2__gft_date_received value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_date_received
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_date_received(?string $gf2__gft_date_received = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_date_received) && !is_string($gf2__gft_date_received)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_date_received, true), gettype($gf2__gft_date_received)), __LINE__);
        }
        if (is_null($gf2__gft_date_received) || (is_array($gf2__gft_date_received) && empty($gf2__gft_date_received))) {
            unset($this->gf2__gft_date_received);
        } else {
            $this->gf2__gft_date_received = $gf2__gft_date_received;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_solicitor_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_solicitor_cst_key(): ?string
    {
        return $this->gf2__gft_solicitor_cst_key ?? null;
    }
    /**
     * Set gf2__gft_solicitor_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_solicitor_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_solicitor_cst_key(?string $gf2__gft_solicitor_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_solicitor_cst_key) && !is_string($gf2__gft_solicitor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_solicitor_cst_key, true), gettype($gf2__gft_solicitor_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_solicitor_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_solicitor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_solicitor_cst_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_solicitor_cst_key) || (is_array($gf2__gft_solicitor_cst_key) && empty($gf2__gft_solicitor_cst_key))) {
            unset($this->gf2__gft_solicitor_cst_key);
        } else {
            $this->gf2__gft_solicitor_cst_key = $gf2__gft_solicitor_cst_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_ticker value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_ticker(): ?string
    {
        return $this->gf2__gft_ticker ?? null;
    }
    /**
     * Set gf2__gft_ticker value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_ticker
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_ticker(?string $gf2__gft_ticker = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_ticker) && !is_string($gf2__gft_ticker)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_ticker, true), gettype($gf2__gft_ticker)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($gf2__gft_ticker) && mb_strlen((string) $gf2__gft_ticker) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $gf2__gft_ticker)), __LINE__);
        }
        if (is_null($gf2__gft_ticker) || (is_array($gf2__gft_ticker) && empty($gf2__gft_ticker))) {
            unset($this->gf2__gft_ticker);
        } else {
            $this->gf2__gft_ticker = $gf2__gft_ticker;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_acknowledgment_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_acknowledgment_date(): ?string
    {
        return $this->gf2__gft_acknowledgment_date ?? null;
    }
    /**
     * Set gf2__gft_acknowledgment_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_acknowledgment_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_acknowledgment_date(?string $gf2__gft_acknowledgment_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_acknowledgment_date) && !is_string($gf2__gft_acknowledgment_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_acknowledgment_date, true), gettype($gf2__gft_acknowledgment_date)), __LINE__);
        }
        if (is_null($gf2__gft_acknowledgment_date) || (is_array($gf2__gft_acknowledgment_date) && empty($gf2__gft_acknowledgment_date))) {
            unset($this->gf2__gft_acknowledgment_date);
        } else {
            $this->gf2__gft_acknowledgment_date = $gf2__gft_acknowledgment_date;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_batch_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_batch_code(): ?string
    {
        return $this->gf2__gft_batch_code ?? null;
    }
    /**
     * Set gf2__gft_batch_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_batch_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_batch_code(?string $gf2__gft_batch_code = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_batch_code) && !is_string($gf2__gft_batch_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_batch_code, true), gettype($gf2__gft_batch_code)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($gf2__gft_batch_code) && mb_strlen((string) $gf2__gft_batch_code) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $gf2__gft_batch_code)), __LINE__);
        }
        if (is_null($gf2__gft_batch_code) || (is_array($gf2__gft_batch_code) && empty($gf2__gft_batch_code))) {
            unset($this->gf2__gft_batch_code);
        } else {
            $this->gf2__gft_batch_code = $gf2__gft_batch_code;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_mail_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_mail_flag(): ?string
    {
        return $this->gf2__gft_mail_flag ?? null;
    }
    /**
     * Set gf2__gft_mail_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_mail_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_mail_flag(?string $gf2__gft_mail_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_mail_flag) && !is_string($gf2__gft_mail_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_mail_flag, true), gettype($gf2__gft_mail_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gf2__gft_mail_flag) && $gf2__gft_mail_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gf2__gft_mail_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gf2__gft_mail_flag) && $gf2__gft_mail_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gf2__gft_mail_flag, true)), __LINE__);
        }
        if (is_null($gf2__gft_mail_flag) || (is_array($gf2__gft_mail_flag) && empty($gf2__gft_mail_flag))) {
            unset($this->gf2__gft_mail_flag);
        } else {
            $this->gf2__gft_mail_flag = $gf2__gft_mail_flag;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_recognize_as value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_recognize_as(): ?string
    {
        return $this->gf2__gft_recognize_as ?? null;
    }
    /**
     * Set gf2__gft_recognize_as value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_recognize_as
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_recognize_as(?string $gf2__gft_recognize_as = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_recognize_as) && !is_string($gf2__gft_recognize_as)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_recognize_as, true), gettype($gf2__gft_recognize_as)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($gf2__gft_recognize_as) && mb_strlen((string) $gf2__gft_recognize_as) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $gf2__gft_recognize_as)), __LINE__);
        }
        if (is_null($gf2__gft_recognize_as) || (is_array($gf2__gft_recognize_as) && empty($gf2__gft_recognize_as))) {
            unset($this->gf2__gft_recognize_as);
        } else {
            $this->gf2__gft_recognize_as = $gf2__gft_recognize_as;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_liquidation_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_liquidation_date(): ?string
    {
        return $this->gf2__gft_liquidation_date ?? null;
    }
    /**
     * Set gf2__gft_liquidation_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_liquidation_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_liquidation_date(?string $gf2__gft_liquidation_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_liquidation_date) && !is_string($gf2__gft_liquidation_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_liquidation_date, true), gettype($gf2__gft_liquidation_date)), __LINE__);
        }
        if (is_null($gf2__gft_liquidation_date) || (is_array($gf2__gft_liquidation_date) && empty($gf2__gft_liquidation_date))) {
            unset($this->gf2__gft_liquidation_date);
        } else {
            $this->gf2__gft_liquidation_date = $gf2__gft_liquidation_date;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_src_key(): ?string
    {
        return $this->gf2__gft_src_key ?? null;
    }
    /**
     * Set gf2__gft_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_src_key(?string $gf2__gft_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_src_key) && !is_string($gf2__gft_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_src_key, true), gettype($gf2__gft_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_src_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_src_key) || (is_array($gf2__gft_src_key) && empty($gf2__gft_src_key))) {
            unset($this->gf2__gft_src_key);
        } else {
            $this->gf2__gft_src_key = $gf2__gft_src_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_reg_key(): ?string
    {
        return $this->gf2__gft_reg_key ?? null;
    }
    /**
     * Set gf2__gft_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_reg_key(?string $gf2__gft_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_reg_key) && !is_string($gf2__gft_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_reg_key, true), gettype($gf2__gft_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_reg_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_reg_key) || (is_array($gf2__gft_reg_key) && empty($gf2__gft_reg_key))) {
            unset($this->gf2__gft_reg_key);
        } else {
            $this->gf2__gft_reg_key = $gf2__gft_reg_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_tax_receipt_sent_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_tax_receipt_sent_date(): ?string
    {
        return $this->gf2__gft_tax_receipt_sent_date ?? null;
    }
    /**
     * Set gf2__gft_tax_receipt_sent_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_tax_receipt_sent_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_tax_receipt_sent_date(?string $gf2__gft_tax_receipt_sent_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_tax_receipt_sent_date) && !is_string($gf2__gft_tax_receipt_sent_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_tax_receipt_sent_date, true), gettype($gf2__gft_tax_receipt_sent_date)), __LINE__);
        }
        if (is_null($gf2__gft_tax_receipt_sent_date) || (is_array($gf2__gft_tax_receipt_sent_date) && empty($gf2__gft_tax_receipt_sent_date))) {
            unset($this->gf2__gft_tax_receipt_sent_date);
        } else {
            $this->gf2__gft_tax_receipt_sent_date = $gf2__gft_tax_receipt_sent_date;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_tbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_tbt_key(): ?string
    {
        return $this->gf2__gft_tbt_key ?? null;
    }
    /**
     * Set gf2__gft_tbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_tbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_tbt_key(?string $gf2__gft_tbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_tbt_key) && !is_string($gf2__gft_tbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_tbt_key, true), gettype($gf2__gft_tbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_tbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_tbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_tbt_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_tbt_key) || (is_array($gf2__gft_tbt_key) && empty($gf2__gft_tbt_key))) {
            unset($this->gf2__gft_tbt_key);
        } else {
            $this->gf2__gft_tbt_key = $gf2__gft_tbt_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_personal_message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_personal_message(): ?string
    {
        return $this->gf2__gft_personal_message ?? null;
    }
    /**
     * Set gf2__gft_personal_message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_personal_message
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_personal_message(?string $gf2__gft_personal_message = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_personal_message) && !is_string($gf2__gft_personal_message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_personal_message, true), gettype($gf2__gft_personal_message)), __LINE__);
        }
        if (is_null($gf2__gft_personal_message) || (is_array($gf2__gft_personal_message) && empty($gf2__gft_personal_message))) {
            unset($this->gf2__gft_personal_message);
        } else {
            $this->gf2__gft_personal_message = $gf2__gft_personal_message;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_dnr_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_dnr_cst_key(): ?string
    {
        return $this->gf2__gft_dnr_cst_key ?? null;
    }
    /**
     * Set gf2__gft_dnr_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_dnr_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_dnr_cst_key(?string $gf2__gft_dnr_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_dnr_cst_key) && !is_string($gf2__gft_dnr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_dnr_cst_key, true), gettype($gf2__gft_dnr_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_dnr_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_dnr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_dnr_cst_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_dnr_cst_key) || (is_array($gf2__gft_dnr_cst_key) && empty($gf2__gft_dnr_cst_key))) {
            unset($this->gf2__gft_dnr_cst_key);
        } else {
            $this->gf2__gft_dnr_cst_key = $gf2__gft_dnr_cst_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_property_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_property_name(): ?string
    {
        return $this->gf2__gft_property_name ?? null;
    }
    /**
     * Set gf2__gft_property_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_property_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_property_name(?string $gf2__gft_property_name = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_property_name) && !is_string($gf2__gft_property_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_property_name, true), gettype($gf2__gft_property_name)), __LINE__);
        }
        if (is_null($gf2__gft_property_name) || (is_array($gf2__gft_property_name) && empty($gf2__gft_property_name))) {
            unset($this->gf2__gft_property_name);
        } else {
            $this->gf2__gft_property_name = $gf2__gft_property_name;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_related_gift_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_related_gift_key(): ?string
    {
        return $this->gf2__gft_related_gift_key ?? null;
    }
    /**
     * Set gf2__gft_related_gift_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_related_gift_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_related_gift_key(?string $gf2__gft_related_gift_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_related_gift_key) && !is_string($gf2__gft_related_gift_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_related_gift_key, true), gettype($gf2__gft_related_gift_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gf2__gft_related_gift_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gf2__gft_related_gift_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gf2__gft_related_gift_key, true)), __LINE__);
        }
        if (is_null($gf2__gft_related_gift_key) || (is_array($gf2__gft_related_gift_key) && empty($gf2__gft_related_gift_key))) {
            unset($this->gf2__gft_related_gift_key);
        } else {
            $this->gf2__gft_related_gift_key = $gf2__gft_related_gift_key;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_update_funds_raised_pending_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_update_funds_raised_pending_flag(): ?string
    {
        return $this->gf2__gft_update_funds_raised_pending_flag ?? null;
    }
    /**
     * Set gf2__gft_update_funds_raised_pending_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_update_funds_raised_pending_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_update_funds_raised_pending_flag(?string $gf2__gft_update_funds_raised_pending_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_update_funds_raised_pending_flag) && !is_string($gf2__gft_update_funds_raised_pending_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_update_funds_raised_pending_flag, true), gettype($gf2__gft_update_funds_raised_pending_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gf2__gft_update_funds_raised_pending_flag) && $gf2__gft_update_funds_raised_pending_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gf2__gft_update_funds_raised_pending_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gf2__gft_update_funds_raised_pending_flag) && $gf2__gft_update_funds_raised_pending_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gf2__gft_update_funds_raised_pending_flag, true)), __LINE__);
        }
        if (is_null($gf2__gft_update_funds_raised_pending_flag) || (is_array($gf2__gft_update_funds_raised_pending_flag) && empty($gf2__gft_update_funds_raised_pending_flag))) {
            unset($this->gf2__gft_update_funds_raised_pending_flag);
        } else {
            $this->gf2__gft_update_funds_raised_pending_flag = $gf2__gft_update_funds_raised_pending_flag;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_receipt_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGf2__gft_receipt_status(): ?string
    {
        return $this->gf2__gft_receipt_status ?? null;
    }
    /**
     * Set gf2__gft_receipt_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gf2__gft_receipt_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_receipt_status(?string $gf2__gft_receipt_status = null): self
    {
        // validation for constraint: string
        if (!is_null($gf2__gft_receipt_status) && !is_string($gf2__gft_receipt_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gf2__gft_receipt_status, true), gettype($gf2__gft_receipt_status)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($gf2__gft_receipt_status) && mb_strlen((string) $gf2__gft_receipt_status) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $gf2__gft_receipt_status)), __LINE__);
        }
        if (is_null($gf2__gft_receipt_status) || (is_array($gf2__gft_receipt_status) && empty($gf2__gft_receipt_status))) {
            unset($this->gf2__gft_receipt_status);
        } else {
            $this->gf2__gft_receipt_status = $gf2__gft_receipt_status;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_stock_high value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGf2__gft_stock_high(): ?float
    {
        return $this->gf2__gft_stock_high ?? null;
    }
    /**
     * Set gf2__gft_stock_high value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gf2__gft_stock_high
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_stock_high(?float $gf2__gft_stock_high = null): self
    {
        // validation for constraint: float
        if (!is_null($gf2__gft_stock_high) && !(is_float($gf2__gft_stock_high) || is_numeric($gf2__gft_stock_high))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gf2__gft_stock_high, true), gettype($gf2__gft_stock_high)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gf2__gft_stock_high) && mb_strlen(mb_substr((string) $gf2__gft_stock_high, false !== mb_strpos((string) $gf2__gft_stock_high, '.') ? mb_strpos((string) $gf2__gft_stock_high, '.') + 1 : mb_strlen((string) $gf2__gft_stock_high))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gf2__gft_stock_high, true), mb_strlen(mb_substr((string) $gf2__gft_stock_high, mb_strpos((string) $gf2__gft_stock_high, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gf2__gft_stock_high) && mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_stock_high)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gf2__gft_stock_high, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_stock_high))), __LINE__);
        }
        if (is_null($gf2__gft_stock_high) || (is_array($gf2__gft_stock_high) && empty($gf2__gft_stock_high))) {
            unset($this->gf2__gft_stock_high);
        } else {
            $this->gf2__gft_stock_high = $gf2__gft_stock_high;
        }
        
        return $this;
    }
    /**
     * Get gf2__gft_stock_low value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGf2__gft_stock_low(): ?float
    {
        return $this->gf2__gft_stock_low ?? null;
    }
    /**
     * Set gf2__gft_stock_low value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gf2__gft_stock_low
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Contributor_Gift_DataObjectType
     */
    public function setGf2__gft_stock_low(?float $gf2__gft_stock_low = null): self
    {
        // validation for constraint: float
        if (!is_null($gf2__gft_stock_low) && !(is_float($gf2__gft_stock_low) || is_numeric($gf2__gft_stock_low))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gf2__gft_stock_low, true), gettype($gf2__gft_stock_low)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($gf2__gft_stock_low) && mb_strlen(mb_substr((string) $gf2__gft_stock_low, false !== mb_strpos((string) $gf2__gft_stock_low, '.') ? mb_strpos((string) $gf2__gft_stock_low, '.') + 1 : mb_strlen((string) $gf2__gft_stock_low))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($gf2__gft_stock_low, true), mb_strlen(mb_substr((string) $gf2__gft_stock_low, mb_strpos((string) $gf2__gft_stock_low, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($gf2__gft_stock_low) && mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_stock_low)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($gf2__gft_stock_low, true), mb_strlen(preg_replace('/(\D)/', '', (string) $gf2__gft_stock_low))), __LINE__);
        }
        if (is_null($gf2__gft_stock_low) || (is_array($gf2__gft_stock_low) && empty($gf2__gft_stock_low))) {
            unset($this->gf2__gft_stock_low);
        } else {
            $this->gf2__gft_stock_low = $gf2__gft_stock_low;
        }
        
        return $this;
    }
}
