<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Fund_Code_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Fund_Code_DataObjectType extends AbstractStructBase
{
    /**
     * The fun_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fun_key = null;
    /**
     * The fun_code
     * Meta information extracted from the WSDL
     * - documentation: Purpose Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_code = null;
    /**
     * The fun_description
     * Meta information extracted from the WSDL
     * - documentation: Purpose Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_description = null;
    /**
     * The fun_start_date
     * Meta information extracted from the WSDL
     * - documentation: Purpose Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_start_date = null;
    /**
     * The fun_end_date
     * Meta information extracted from the WSDL
     * - documentation: Purpose End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_end_date = null;
    /**
     * The fun_goal
     * Meta information extracted from the WSDL
     * - documentation: Purpose Goal. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $fun_goal = null;
    /**
     * The fun_notes
     * Meta information extracted from the WSDL
     * - documentation: Purpose Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_notes = null;
    /**
     * The fun_active_flag
     * Meta information extracted from the WSDL
     * - documentation: Purpose Active Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_active_flag = null;
    /**
     * The fun_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_add_user = null;
    /**
     * The fun_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_add_date = null;
    /**
     * The fun_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_change_user = null;
    /**
     * The fun_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_change_date = null;
    /**
     * The fun_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fun_delete_flag = null;
    /**
     * The fun_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fun_entity_key = null;
    /**
     * The fun_raised
     * Meta information extracted from the WSDL
     * - documentation: Amount Raised. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $fun_raised = null;
    /**
     * The fun_pledged
     * Meta information extracted from the WSDL
     * - documentation: Amount Pledged. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $fun_pledged = null;
    /**
     * The fun_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fun_key_ext = null;
    /**
     * Constructor method for FundraisingGift_Fund_Code_DataObjectType
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_key()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_code()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_description()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_start_date()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_end_date()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_goal()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_notes()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_active_flag()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_add_user()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_add_date()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_change_user()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_change_date()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_delete_flag()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_entity_key()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_raised()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_pledged()
     * @uses FundraisingGift_Fund_Code_DataObjectType::setFun_key_ext()
     * @param string $fun_key
     * @param string $fun_code
     * @param string $fun_description
     * @param string $fun_start_date
     * @param string $fun_end_date
     * @param float $fun_goal
     * @param string $fun_notes
     * @param string $fun_active_flag
     * @param string $fun_add_user
     * @param string $fun_add_date
     * @param string $fun_change_user
     * @param string $fun_change_date
     * @param string $fun_delete_flag
     * @param string $fun_entity_key
     * @param float $fun_raised
     * @param float $fun_pledged
     * @param string $fun_key_ext
     */
    public function __construct(?string $fun_key = null, ?string $fun_code = null, ?string $fun_description = null, ?string $fun_start_date = null, ?string $fun_end_date = null, ?float $fun_goal = null, ?string $fun_notes = null, ?string $fun_active_flag = null, ?string $fun_add_user = null, ?string $fun_add_date = null, ?string $fun_change_user = null, ?string $fun_change_date = null, ?string $fun_delete_flag = null, ?string $fun_entity_key = null, ?float $fun_raised = null, ?float $fun_pledged = null, ?string $fun_key_ext = null)
    {
        $this
            ->setFun_key($fun_key)
            ->setFun_code($fun_code)
            ->setFun_description($fun_description)
            ->setFun_start_date($fun_start_date)
            ->setFun_end_date($fun_end_date)
            ->setFun_goal($fun_goal)
            ->setFun_notes($fun_notes)
            ->setFun_active_flag($fun_active_flag)
            ->setFun_add_user($fun_add_user)
            ->setFun_add_date($fun_add_date)
            ->setFun_change_user($fun_change_user)
            ->setFun_change_date($fun_change_date)
            ->setFun_delete_flag($fun_delete_flag)
            ->setFun_entity_key($fun_entity_key)
            ->setFun_raised($fun_raised)
            ->setFun_pledged($fun_pledged)
            ->setFun_key_ext($fun_key_ext);
    }
    /**
     * Get fun_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_key(): ?string
    {
        return $this->fun_key ?? null;
    }
    /**
     * Set fun_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_key(?string $fun_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_key) && !is_string($fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_key, true), gettype($fun_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fun_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fun_key, true)), __LINE__);
        }
        if (is_null($fun_key) || (is_array($fun_key) && empty($fun_key))) {
            unset($this->fun_key);
        } else {
            $this->fun_key = $fun_key;
        }
        
        return $this;
    }
    /**
     * Get fun_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_code(): ?string
    {
        return $this->fun_code ?? null;
    }
    /**
     * Set fun_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_code(?string $fun_code = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_code) && !is_string($fun_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_code, true), gettype($fun_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($fun_code) && mb_strlen((string) $fun_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $fun_code)), __LINE__);
        }
        if (is_null($fun_code) || (is_array($fun_code) && empty($fun_code))) {
            unset($this->fun_code);
        } else {
            $this->fun_code = $fun_code;
        }
        
        return $this;
    }
    /**
     * Get fun_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_description(): ?string
    {
        return $this->fun_description ?? null;
    }
    /**
     * Set fun_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_description(?string $fun_description = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_description) && !is_string($fun_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_description, true), gettype($fun_description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($fun_description) && mb_strlen((string) $fun_description) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $fun_description)), __LINE__);
        }
        if (is_null($fun_description) || (is_array($fun_description) && empty($fun_description))) {
            unset($this->fun_description);
        } else {
            $this->fun_description = $fun_description;
        }
        
        return $this;
    }
    /**
     * Get fun_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_start_date(): ?string
    {
        return $this->fun_start_date ?? null;
    }
    /**
     * Set fun_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_start_date(?string $fun_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_start_date) && !is_string($fun_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_start_date, true), gettype($fun_start_date)), __LINE__);
        }
        if (is_null($fun_start_date) || (is_array($fun_start_date) && empty($fun_start_date))) {
            unset($this->fun_start_date);
        } else {
            $this->fun_start_date = $fun_start_date;
        }
        
        return $this;
    }
    /**
     * Get fun_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_end_date(): ?string
    {
        return $this->fun_end_date ?? null;
    }
    /**
     * Set fun_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_end_date(?string $fun_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_end_date) && !is_string($fun_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_end_date, true), gettype($fun_end_date)), __LINE__);
        }
        if (is_null($fun_end_date) || (is_array($fun_end_date) && empty($fun_end_date))) {
            unset($this->fun_end_date);
        } else {
            $this->fun_end_date = $fun_end_date;
        }
        
        return $this;
    }
    /**
     * Get fun_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFun_goal(): ?float
    {
        return $this->fun_goal ?? null;
    }
    /**
     * Set fun_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fun_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_goal(?float $fun_goal = null): self
    {
        // validation for constraint: float
        if (!is_null($fun_goal) && !(is_float($fun_goal) || is_numeric($fun_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fun_goal, true), gettype($fun_goal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($fun_goal) && mb_strlen(mb_substr((string) $fun_goal, false !== mb_strpos((string) $fun_goal, '.') ? mb_strpos((string) $fun_goal, '.') + 1 : mb_strlen((string) $fun_goal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($fun_goal, true), mb_strlen(mb_substr((string) $fun_goal, mb_strpos((string) $fun_goal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($fun_goal) && mb_strlen(preg_replace('/(\D)/', '', (string) $fun_goal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($fun_goal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $fun_goal))), __LINE__);
        }
        if (is_null($fun_goal) || (is_array($fun_goal) && empty($fun_goal))) {
            unset($this->fun_goal);
        } else {
            $this->fun_goal = $fun_goal;
        }
        
        return $this;
    }
    /**
     * Get fun_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_notes(): ?string
    {
        return $this->fun_notes ?? null;
    }
    /**
     * Set fun_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_notes(?string $fun_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_notes) && !is_string($fun_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_notes, true), gettype($fun_notes)), __LINE__);
        }
        if (is_null($fun_notes) || (is_array($fun_notes) && empty($fun_notes))) {
            unset($this->fun_notes);
        } else {
            $this->fun_notes = $fun_notes;
        }
        
        return $this;
    }
    /**
     * Get fun_active_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_active_flag(): ?string
    {
        return $this->fun_active_flag ?? null;
    }
    /**
     * Set fun_active_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_active_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_active_flag(?string $fun_active_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_active_flag) && !is_string($fun_active_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_active_flag, true), gettype($fun_active_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($fun_active_flag) && $fun_active_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($fun_active_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fun_active_flag) && $fun_active_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fun_active_flag, true)), __LINE__);
        }
        if (is_null($fun_active_flag) || (is_array($fun_active_flag) && empty($fun_active_flag))) {
            unset($this->fun_active_flag);
        } else {
            $this->fun_active_flag = $fun_active_flag;
        }
        
        return $this;
    }
    /**
     * Get fun_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_add_user(): ?string
    {
        return $this->fun_add_user ?? null;
    }
    /**
     * Set fun_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_add_user(?string $fun_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_add_user) && !is_string($fun_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_add_user, true), gettype($fun_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fun_add_user) && mb_strlen((string) $fun_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $fun_add_user)), __LINE__);
        }
        if (is_null($fun_add_user) || (is_array($fun_add_user) && empty($fun_add_user))) {
            unset($this->fun_add_user);
        } else {
            $this->fun_add_user = $fun_add_user;
        }
        
        return $this;
    }
    /**
     * Get fun_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_add_date(): ?string
    {
        return $this->fun_add_date ?? null;
    }
    /**
     * Set fun_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_add_date(?string $fun_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_add_date) && !is_string($fun_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_add_date, true), gettype($fun_add_date)), __LINE__);
        }
        if (is_null($fun_add_date) || (is_array($fun_add_date) && empty($fun_add_date))) {
            unset($this->fun_add_date);
        } else {
            $this->fun_add_date = $fun_add_date;
        }
        
        return $this;
    }
    /**
     * Get fun_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_change_user(): ?string
    {
        return $this->fun_change_user ?? null;
    }
    /**
     * Set fun_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_change_user(?string $fun_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_change_user) && !is_string($fun_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_change_user, true), gettype($fun_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fun_change_user) && mb_strlen((string) $fun_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $fun_change_user)), __LINE__);
        }
        if (is_null($fun_change_user) || (is_array($fun_change_user) && empty($fun_change_user))) {
            unset($this->fun_change_user);
        } else {
            $this->fun_change_user = $fun_change_user;
        }
        
        return $this;
    }
    /**
     * Get fun_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_change_date(): ?string
    {
        return $this->fun_change_date ?? null;
    }
    /**
     * Set fun_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_change_date(?string $fun_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_change_date) && !is_string($fun_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_change_date, true), gettype($fun_change_date)), __LINE__);
        }
        if (is_null($fun_change_date) || (is_array($fun_change_date) && empty($fun_change_date))) {
            unset($this->fun_change_date);
        } else {
            $this->fun_change_date = $fun_change_date;
        }
        
        return $this;
    }
    /**
     * Get fun_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_delete_flag(): ?string
    {
        return $this->fun_delete_flag ?? null;
    }
    /**
     * Set fun_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_delete_flag(?string $fun_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_delete_flag) && !is_string($fun_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_delete_flag, true), gettype($fun_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($fun_delete_flag) && $fun_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($fun_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fun_delete_flag) && $fun_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fun_delete_flag, true)), __LINE__);
        }
        if (is_null($fun_delete_flag) || (is_array($fun_delete_flag) && empty($fun_delete_flag))) {
            unset($this->fun_delete_flag);
        } else {
            $this->fun_delete_flag = $fun_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get fun_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_entity_key(): ?string
    {
        return $this->fun_entity_key ?? null;
    }
    /**
     * Set fun_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_entity_key(?string $fun_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_entity_key) && !is_string($fun_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_entity_key, true), gettype($fun_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fun_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fun_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fun_entity_key, true)), __LINE__);
        }
        if (is_null($fun_entity_key) || (is_array($fun_entity_key) && empty($fun_entity_key))) {
            unset($this->fun_entity_key);
        } else {
            $this->fun_entity_key = $fun_entity_key;
        }
        
        return $this;
    }
    /**
     * Get fun_raised value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFun_raised(): ?float
    {
        return $this->fun_raised ?? null;
    }
    /**
     * Set fun_raised value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fun_raised
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_raised(?float $fun_raised = null): self
    {
        // validation for constraint: float
        if (!is_null($fun_raised) && !(is_float($fun_raised) || is_numeric($fun_raised))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fun_raised, true), gettype($fun_raised)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($fun_raised) && mb_strlen(mb_substr((string) $fun_raised, false !== mb_strpos((string) $fun_raised, '.') ? mb_strpos((string) $fun_raised, '.') + 1 : mb_strlen((string) $fun_raised))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($fun_raised, true), mb_strlen(mb_substr((string) $fun_raised, mb_strpos((string) $fun_raised, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($fun_raised) && mb_strlen(preg_replace('/(\D)/', '', (string) $fun_raised)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($fun_raised, true), mb_strlen(preg_replace('/(\D)/', '', (string) $fun_raised))), __LINE__);
        }
        if (is_null($fun_raised) || (is_array($fun_raised) && empty($fun_raised))) {
            unset($this->fun_raised);
        } else {
            $this->fun_raised = $fun_raised;
        }
        
        return $this;
    }
    /**
     * Get fun_pledged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFun_pledged(): ?float
    {
        return $this->fun_pledged ?? null;
    }
    /**
     * Set fun_pledged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fun_pledged
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_pledged(?float $fun_pledged = null): self
    {
        // validation for constraint: float
        if (!is_null($fun_pledged) && !(is_float($fun_pledged) || is_numeric($fun_pledged))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fun_pledged, true), gettype($fun_pledged)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($fun_pledged) && mb_strlen(mb_substr((string) $fun_pledged, false !== mb_strpos((string) $fun_pledged, '.') ? mb_strpos((string) $fun_pledged, '.') + 1 : mb_strlen((string) $fun_pledged))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($fun_pledged, true), mb_strlen(mb_substr((string) $fun_pledged, mb_strpos((string) $fun_pledged, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($fun_pledged) && mb_strlen(preg_replace('/(\D)/', '', (string) $fun_pledged)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($fun_pledged, true), mb_strlen(preg_replace('/(\D)/', '', (string) $fun_pledged))), __LINE__);
        }
        if (is_null($fun_pledged) || (is_array($fun_pledged) && empty($fun_pledged))) {
            unset($this->fun_pledged);
        } else {
            $this->fun_pledged = $fun_pledged;
        }
        
        return $this;
    }
    /**
     * Get fun_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFun_key_ext(): ?string
    {
        return $this->fun_key_ext ?? null;
    }
    /**
     * Set fun_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fun_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Fund_Code_DataObjectType
     */
    public function setFun_key_ext(?string $fun_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($fun_key_ext) && !is_string($fun_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fun_key_ext, true), gettype($fun_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fun_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fun_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fun_key_ext, true)), __LINE__);
        }
        if (is_null($fun_key_ext) || (is_array($fun_key_ext) && empty($fun_key_ext))) {
            unset($this->fun_key_ext);
        } else {
            $this->fun_key_ext = $fun_key_ext;
        }
        
        return $this;
    }
}
