<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Ind_Business_Phone_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Ind_Business_Phone_DataObjectType extends AbstractStructBase
{
    /**
     * The phn_key
     * Meta information extracted from the WSDL
     * - documentation: Phone Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $phn_key = null;
    /**
     * The phn_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Phone Owner. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $phn_cst_key_owner = null;
    /**
     * The phn_number
     * Meta information extracted from the WSDL
     * - documentation: Phone Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $phn_number = null;
    /**
     * The phn_number_display
     * Meta information extracted from the WSDL
     * - documentation: Formatted Phone Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $phn_number_display = null;
    /**
     * The phn_cty_key
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'bc4b70f8-280e-4bb0-b935-9f728c50e183'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $phn_cty_key = null;
    /**
     * The phn_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $phn_add_user = null;
    /**
     * The phn_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $phn_add_date = null;
    /**
     * The phn_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $phn_change_user = null;
    /**
     * The phn_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $phn_change_date = null;
    /**
     * The phn_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $phn_delete_flag = null;
    /**
     * The phn_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $phn_entity_key = null;
    /**
     * The phn_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $phn_key_ext = null;
    /**
     * Constructor method for FundraisingGift_Ind_Business_Phone_DataObjectType
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_key()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_cst_key_owner()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_number()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_number_display()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_cty_key()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_add_user()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_add_date()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_change_user()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_change_date()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_delete_flag()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_entity_key()
     * @uses FundraisingGift_Ind_Business_Phone_DataObjectType::setPhn_key_ext()
     * @param string $phn_key
     * @param string $phn_cst_key_owner
     * @param string $phn_number
     * @param string $phn_number_display
     * @param string $phn_cty_key
     * @param string $phn_add_user
     * @param string $phn_add_date
     * @param string $phn_change_user
     * @param string $phn_change_date
     * @param string $phn_delete_flag
     * @param string $phn_entity_key
     * @param string $phn_key_ext
     */
    public function __construct(?string $phn_key = null, ?string $phn_cst_key_owner = null, ?string $phn_number = null, ?string $phn_number_display = null, ?string $phn_cty_key = null, ?string $phn_add_user = null, ?string $phn_add_date = null, ?string $phn_change_user = null, ?string $phn_change_date = null, ?string $phn_delete_flag = null, ?string $phn_entity_key = null, ?string $phn_key_ext = null)
    {
        $this
            ->setPhn_key($phn_key)
            ->setPhn_cst_key_owner($phn_cst_key_owner)
            ->setPhn_number($phn_number)
            ->setPhn_number_display($phn_number_display)
            ->setPhn_cty_key($phn_cty_key)
            ->setPhn_add_user($phn_add_user)
            ->setPhn_add_date($phn_add_date)
            ->setPhn_change_user($phn_change_user)
            ->setPhn_change_date($phn_change_date)
            ->setPhn_delete_flag($phn_delete_flag)
            ->setPhn_entity_key($phn_entity_key)
            ->setPhn_key_ext($phn_key_ext);
    }
    /**
     * Get phn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_key(): ?string
    {
        return $this->phn_key ?? null;
    }
    /**
     * Set phn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_key(?string $phn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_key) && !is_string($phn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_key, true), gettype($phn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($phn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $phn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($phn_key, true)), __LINE__);
        }
        if (is_null($phn_key) || (is_array($phn_key) && empty($phn_key))) {
            unset($this->phn_key);
        } else {
            $this->phn_key = $phn_key;
        }
        
        return $this;
    }
    /**
     * Get phn_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_cst_key_owner(): ?string
    {
        return $this->phn_cst_key_owner ?? null;
    }
    /**
     * Set phn_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_cst_key_owner(?string $phn_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_cst_key_owner) && !is_string($phn_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_cst_key_owner, true), gettype($phn_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($phn_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $phn_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($phn_cst_key_owner, true)), __LINE__);
        }
        if (is_null($phn_cst_key_owner) || (is_array($phn_cst_key_owner) && empty($phn_cst_key_owner))) {
            unset($this->phn_cst_key_owner);
        } else {
            $this->phn_cst_key_owner = $phn_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get phn_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_number(): ?string
    {
        return $this->phn_number ?? null;
    }
    /**
     * Set phn_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_number(?string $phn_number = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_number) && !is_string($phn_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_number, true), gettype($phn_number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phn_number) && mb_strlen((string) $phn_number) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $phn_number)), __LINE__);
        }
        if (is_null($phn_number) || (is_array($phn_number) && empty($phn_number))) {
            unset($this->phn_number);
        } else {
            $this->phn_number = $phn_number;
        }
        
        return $this;
    }
    /**
     * Get phn_number_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_number_display(): ?string
    {
        return $this->phn_number_display ?? null;
    }
    /**
     * Set phn_number_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_number_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_number_display(?string $phn_number_display = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_number_display) && !is_string($phn_number_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_number_display, true), gettype($phn_number_display)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($phn_number_display) && mb_strlen((string) $phn_number_display) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $phn_number_display)), __LINE__);
        }
        if (is_null($phn_number_display) || (is_array($phn_number_display) && empty($phn_number_display))) {
            unset($this->phn_number_display);
        } else {
            $this->phn_number_display = $phn_number_display;
        }
        
        return $this;
    }
    /**
     * Get phn_cty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_cty_key(): ?string
    {
        return $this->phn_cty_key ?? null;
    }
    /**
     * Set phn_cty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_cty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_cty_key(?string $phn_cty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_cty_key) && !is_string($phn_cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_cty_key, true), gettype($phn_cty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($phn_cty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $phn_cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($phn_cty_key, true)), __LINE__);
        }
        if (is_null($phn_cty_key) || (is_array($phn_cty_key) && empty($phn_cty_key))) {
            unset($this->phn_cty_key);
        } else {
            $this->phn_cty_key = $phn_cty_key;
        }
        
        return $this;
    }
    /**
     * Get phn_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_add_user(): ?string
    {
        return $this->phn_add_user ?? null;
    }
    /**
     * Set phn_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_add_user(?string $phn_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_add_user) && !is_string($phn_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_add_user, true), gettype($phn_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($phn_add_user) && mb_strlen((string) $phn_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $phn_add_user)), __LINE__);
        }
        if (is_null($phn_add_user) || (is_array($phn_add_user) && empty($phn_add_user))) {
            unset($this->phn_add_user);
        } else {
            $this->phn_add_user = $phn_add_user;
        }
        
        return $this;
    }
    /**
     * Get phn_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_add_date(): ?string
    {
        return $this->phn_add_date ?? null;
    }
    /**
     * Set phn_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_add_date(?string $phn_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_add_date) && !is_string($phn_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_add_date, true), gettype($phn_add_date)), __LINE__);
        }
        if (is_null($phn_add_date) || (is_array($phn_add_date) && empty($phn_add_date))) {
            unset($this->phn_add_date);
        } else {
            $this->phn_add_date = $phn_add_date;
        }
        
        return $this;
    }
    /**
     * Get phn_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_change_user(): ?string
    {
        return $this->phn_change_user ?? null;
    }
    /**
     * Set phn_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_change_user(?string $phn_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_change_user) && !is_string($phn_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_change_user, true), gettype($phn_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($phn_change_user) && mb_strlen((string) $phn_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $phn_change_user)), __LINE__);
        }
        if (is_null($phn_change_user) || (is_array($phn_change_user) && empty($phn_change_user))) {
            unset($this->phn_change_user);
        } else {
            $this->phn_change_user = $phn_change_user;
        }
        
        return $this;
    }
    /**
     * Get phn_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_change_date(): ?string
    {
        return $this->phn_change_date ?? null;
    }
    /**
     * Set phn_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_change_date(?string $phn_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_change_date) && !is_string($phn_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_change_date, true), gettype($phn_change_date)), __LINE__);
        }
        if (is_null($phn_change_date) || (is_array($phn_change_date) && empty($phn_change_date))) {
            unset($this->phn_change_date);
        } else {
            $this->phn_change_date = $phn_change_date;
        }
        
        return $this;
    }
    /**
     * Get phn_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_delete_flag(): ?string
    {
        return $this->phn_delete_flag ?? null;
    }
    /**
     * Set phn_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_delete_flag(?string $phn_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_delete_flag) && !is_string($phn_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_delete_flag, true), gettype($phn_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($phn_delete_flag) && $phn_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($phn_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($phn_delete_flag) && $phn_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($phn_delete_flag, true)), __LINE__);
        }
        if (is_null($phn_delete_flag) || (is_array($phn_delete_flag) && empty($phn_delete_flag))) {
            unset($this->phn_delete_flag);
        } else {
            $this->phn_delete_flag = $phn_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get phn_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_entity_key(): ?string
    {
        return $this->phn_entity_key ?? null;
    }
    /**
     * Set phn_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_entity_key(?string $phn_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_entity_key) && !is_string($phn_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_entity_key, true), gettype($phn_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($phn_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $phn_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($phn_entity_key, true)), __LINE__);
        }
        if (is_null($phn_entity_key) || (is_array($phn_entity_key) && empty($phn_entity_key))) {
            unset($this->phn_entity_key);
        } else {
            $this->phn_entity_key = $phn_entity_key;
        }
        
        return $this;
    }
    /**
     * Get phn_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhn_key_ext(): ?string
    {
        return $this->phn_key_ext ?? null;
    }
    /**
     * Set phn_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phn_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_Business_Phone_DataObjectType
     */
    public function setPhn_key_ext(?string $phn_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($phn_key_ext) && !is_string($phn_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phn_key_ext, true), gettype($phn_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($phn_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $phn_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($phn_key_ext, true)), __LINE__);
        }
        if (is_null($phn_key_ext) || (is_array($phn_key_ext) && empty($phn_key_ext))) {
            unset($this->phn_key_ext);
        } else {
            $this->phn_key_ext = $phn_key_ext;
        }
        
        return $this;
    }
}
