<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Ind_eMail_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Ind_eMail_DataObjectType extends AbstractStructBase
{
    /**
     * The eml_key
     * Meta information extracted from the WSDL
     * - documentation: Email Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $eml_key = null;
    /**
     * The eml_address
     * Meta information extracted from the WSDL
     * - documentation: E-Mail Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_address = null;
    /**
     * The eml_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $eml_cst_key = null;
    /**
     * The eml_type
     * Meta information extracted from the WSDL
     * - documentation: e-mail type.This element has a default value of 'business'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_type = null;
    /**
     * The eml_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_add_user = null;
    /**
     * The eml_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_add_date = null;
    /**
     * The eml_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_change_user = null;
    /**
     * The eml_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_change_date = null;
    /**
     * The eml_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_delete_flag = null;
    /**
     * The eml_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $eml_key_ext = null;
    /**
     * The eml_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $eml_entity_key = null;
    /**
     * The eml_invalid_flag
     * Meta information extracted from the WSDL
     * - documentation: Invalid E-mail Address. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_invalid_flag = null;
    /**
     * The eml_invalid_reason
     * Meta information extracted from the WSDL
     * - documentation: Invalid E-mail Address Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_invalid_reason = null;
    /**
     * The eml_unlisted_flag
     * Meta information extracted from the WSDL
     * - documentation: do not list my email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_unlisted_flag = null;
    /**
     * The eml_primary
     * Meta information extracted from the WSDL
     * - documentation: Primary.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $eml_primary = null;
    /**
     * Constructor method for FundraisingGift_Ind_eMail_DataObjectType
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_key()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_address()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_cst_key()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_type()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_add_user()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_add_date()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_change_user()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_change_date()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_delete_flag()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_key_ext()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_entity_key()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_invalid_flag()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_invalid_reason()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_unlisted_flag()
     * @uses FundraisingGift_Ind_eMail_DataObjectType::setEml_primary()
     * @param string $eml_key
     * @param string $eml_address
     * @param string $eml_cst_key
     * @param string $eml_type
     * @param string $eml_add_user
     * @param string $eml_add_date
     * @param string $eml_change_user
     * @param string $eml_change_date
     * @param string $eml_delete_flag
     * @param string $eml_key_ext
     * @param string $eml_entity_key
     * @param string $eml_invalid_flag
     * @param string $eml_invalid_reason
     * @param string $eml_unlisted_flag
     * @param string $eml_primary
     */
    public function __construct(?string $eml_key = null, ?string $eml_address = null, ?string $eml_cst_key = null, ?string $eml_type = null, ?string $eml_add_user = null, ?string $eml_add_date = null, ?string $eml_change_user = null, ?string $eml_change_date = null, ?string $eml_delete_flag = null, ?string $eml_key_ext = null, ?string $eml_entity_key = null, ?string $eml_invalid_flag = null, ?string $eml_invalid_reason = null, ?string $eml_unlisted_flag = null, ?string $eml_primary = null)
    {
        $this
            ->setEml_key($eml_key)
            ->setEml_address($eml_address)
            ->setEml_cst_key($eml_cst_key)
            ->setEml_type($eml_type)
            ->setEml_add_user($eml_add_user)
            ->setEml_add_date($eml_add_date)
            ->setEml_change_user($eml_change_user)
            ->setEml_change_date($eml_change_date)
            ->setEml_delete_flag($eml_delete_flag)
            ->setEml_key_ext($eml_key_ext)
            ->setEml_entity_key($eml_entity_key)
            ->setEml_invalid_flag($eml_invalid_flag)
            ->setEml_invalid_reason($eml_invalid_reason)
            ->setEml_unlisted_flag($eml_unlisted_flag)
            ->setEml_primary($eml_primary);
    }
    /**
     * Get eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_key(): ?string
    {
        return $this->eml_key ?? null;
    }
    /**
     * Set eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_key(?string $eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_key) && !is_string($eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_key, true), gettype($eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($eml_key, true)), __LINE__);
        }
        if (is_null($eml_key) || (is_array($eml_key) && empty($eml_key))) {
            unset($this->eml_key);
        } else {
            $this->eml_key = $eml_key;
        }
        
        return $this;
    }
    /**
     * Get eml_address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_address(): ?string
    {
        return $this->eml_address ?? null;
    }
    /**
     * Set eml_address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_address
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_address(?string $eml_address = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_address) && !is_string($eml_address)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_address, true), gettype($eml_address)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($eml_address) && mb_strlen((string) $eml_address) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $eml_address)), __LINE__);
        }
        if (is_null($eml_address) || (is_array($eml_address) && empty($eml_address))) {
            unset($this->eml_address);
        } else {
            $this->eml_address = $eml_address;
        }
        
        return $this;
    }
    /**
     * Get eml_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_cst_key(): ?string
    {
        return $this->eml_cst_key ?? null;
    }
    /**
     * Set eml_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_cst_key(?string $eml_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_cst_key) && !is_string($eml_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_cst_key, true), gettype($eml_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($eml_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $eml_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($eml_cst_key, true)), __LINE__);
        }
        if (is_null($eml_cst_key) || (is_array($eml_cst_key) && empty($eml_cst_key))) {
            unset($this->eml_cst_key);
        } else {
            $this->eml_cst_key = $eml_cst_key;
        }
        
        return $this;
    }
    /**
     * Get eml_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_type(): ?string
    {
        return $this->eml_type ?? null;
    }
    /**
     * Set eml_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_type(?string $eml_type = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_type) && !is_string($eml_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_type, true), gettype($eml_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($eml_type) && mb_strlen((string) $eml_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $eml_type)), __LINE__);
        }
        if (is_null($eml_type) || (is_array($eml_type) && empty($eml_type))) {
            unset($this->eml_type);
        } else {
            $this->eml_type = $eml_type;
        }
        
        return $this;
    }
    /**
     * Get eml_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_add_user(): ?string
    {
        return $this->eml_add_user ?? null;
    }
    /**
     * Set eml_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_add_user(?string $eml_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_add_user) && !is_string($eml_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_add_user, true), gettype($eml_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($eml_add_user) && mb_strlen((string) $eml_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $eml_add_user)), __LINE__);
        }
        if (is_null($eml_add_user) || (is_array($eml_add_user) && empty($eml_add_user))) {
            unset($this->eml_add_user);
        } else {
            $this->eml_add_user = $eml_add_user;
        }
        
        return $this;
    }
    /**
     * Get eml_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_add_date(): ?string
    {
        return $this->eml_add_date ?? null;
    }
    /**
     * Set eml_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_add_date(?string $eml_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_add_date) && !is_string($eml_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_add_date, true), gettype($eml_add_date)), __LINE__);
        }
        if (is_null($eml_add_date) || (is_array($eml_add_date) && empty($eml_add_date))) {
            unset($this->eml_add_date);
        } else {
            $this->eml_add_date = $eml_add_date;
        }
        
        return $this;
    }
    /**
     * Get eml_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_change_user(): ?string
    {
        return $this->eml_change_user ?? null;
    }
    /**
     * Set eml_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_change_user(?string $eml_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_change_user) && !is_string($eml_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_change_user, true), gettype($eml_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($eml_change_user) && mb_strlen((string) $eml_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $eml_change_user)), __LINE__);
        }
        if (is_null($eml_change_user) || (is_array($eml_change_user) && empty($eml_change_user))) {
            unset($this->eml_change_user);
        } else {
            $this->eml_change_user = $eml_change_user;
        }
        
        return $this;
    }
    /**
     * Get eml_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_change_date(): ?string
    {
        return $this->eml_change_date ?? null;
    }
    /**
     * Set eml_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_change_date(?string $eml_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_change_date) && !is_string($eml_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_change_date, true), gettype($eml_change_date)), __LINE__);
        }
        if (is_null($eml_change_date) || (is_array($eml_change_date) && empty($eml_change_date))) {
            unset($this->eml_change_date);
        } else {
            $this->eml_change_date = $eml_change_date;
        }
        
        return $this;
    }
    /**
     * Get eml_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_delete_flag(): ?string
    {
        return $this->eml_delete_flag ?? null;
    }
    /**
     * Set eml_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_delete_flag(?string $eml_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_delete_flag) && !is_string($eml_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_delete_flag, true), gettype($eml_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($eml_delete_flag) && $eml_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($eml_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($eml_delete_flag) && $eml_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($eml_delete_flag, true)), __LINE__);
        }
        if (is_null($eml_delete_flag) || (is_array($eml_delete_flag) && empty($eml_delete_flag))) {
            unset($this->eml_delete_flag);
        } else {
            $this->eml_delete_flag = $eml_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get eml_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_key_ext(): ?string
    {
        return $this->eml_key_ext ?? null;
    }
    /**
     * Set eml_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_key_ext(?string $eml_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_key_ext) && !is_string($eml_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_key_ext, true), gettype($eml_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($eml_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $eml_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($eml_key_ext, true)), __LINE__);
        }
        if (is_null($eml_key_ext) || (is_array($eml_key_ext) && empty($eml_key_ext))) {
            unset($this->eml_key_ext);
        } else {
            $this->eml_key_ext = $eml_key_ext;
        }
        
        return $this;
    }
    /**
     * Get eml_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_entity_key(): ?string
    {
        return $this->eml_entity_key ?? null;
    }
    /**
     * Set eml_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_entity_key(?string $eml_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_entity_key) && !is_string($eml_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_entity_key, true), gettype($eml_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($eml_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $eml_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($eml_entity_key, true)), __LINE__);
        }
        if (is_null($eml_entity_key) || (is_array($eml_entity_key) && empty($eml_entity_key))) {
            unset($this->eml_entity_key);
        } else {
            $this->eml_entity_key = $eml_entity_key;
        }
        
        return $this;
    }
    /**
     * Get eml_invalid_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_invalid_flag(): ?string
    {
        return $this->eml_invalid_flag ?? null;
    }
    /**
     * Set eml_invalid_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_invalid_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_invalid_flag(?string $eml_invalid_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_invalid_flag) && !is_string($eml_invalid_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_invalid_flag, true), gettype($eml_invalid_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($eml_invalid_flag) && $eml_invalid_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($eml_invalid_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($eml_invalid_flag) && $eml_invalid_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($eml_invalid_flag, true)), __LINE__);
        }
        if (is_null($eml_invalid_flag) || (is_array($eml_invalid_flag) && empty($eml_invalid_flag))) {
            unset($this->eml_invalid_flag);
        } else {
            $this->eml_invalid_flag = $eml_invalid_flag;
        }
        
        return $this;
    }
    /**
     * Get eml_invalid_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_invalid_reason(): ?string
    {
        return $this->eml_invalid_reason ?? null;
    }
    /**
     * Set eml_invalid_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_invalid_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_invalid_reason(?string $eml_invalid_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_invalid_reason) && !is_string($eml_invalid_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_invalid_reason, true), gettype($eml_invalid_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($eml_invalid_reason) && mb_strlen((string) $eml_invalid_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $eml_invalid_reason)), __LINE__);
        }
        if (is_null($eml_invalid_reason) || (is_array($eml_invalid_reason) && empty($eml_invalid_reason))) {
            unset($this->eml_invalid_reason);
        } else {
            $this->eml_invalid_reason = $eml_invalid_reason;
        }
        
        return $this;
    }
    /**
     * Get eml_unlisted_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_unlisted_flag(): ?string
    {
        return $this->eml_unlisted_flag ?? null;
    }
    /**
     * Set eml_unlisted_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_unlisted_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_unlisted_flag(?string $eml_unlisted_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_unlisted_flag) && !is_string($eml_unlisted_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_unlisted_flag, true), gettype($eml_unlisted_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($eml_unlisted_flag) && $eml_unlisted_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($eml_unlisted_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($eml_unlisted_flag) && $eml_unlisted_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($eml_unlisted_flag, true)), __LINE__);
        }
        if (is_null($eml_unlisted_flag) || (is_array($eml_unlisted_flag) && empty($eml_unlisted_flag))) {
            unset($this->eml_unlisted_flag);
        } else {
            $this->eml_unlisted_flag = $eml_unlisted_flag;
        }
        
        return $this;
    }
    /**
     * Get eml_primary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEml_primary(): ?string
    {
        return $this->eml_primary ?? null;
    }
    /**
     * Set eml_primary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eml_primary
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Ind_eMail_DataObjectType
     */
    public function setEml_primary(?string $eml_primary = null): self
    {
        // validation for constraint: string
        if (!is_null($eml_primary) && !is_string($eml_primary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml_primary, true), gettype($eml_primary)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($eml_primary) && $eml_primary > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($eml_primary, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($eml_primary) && $eml_primary < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($eml_primary, true)), __LINE__);
        }
        if (is_null($eml_primary) || (is_array($eml_primary) && empty($eml_primary))) {
            unset($this->eml_primary);
        } else {
            $this->eml_primary = $eml_primary;
        }
        
        return $this;
    }
}
