<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Net_Amount_Information_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Net_Amount_Information_DataObjectType extends AbstractStructBase
{
    /**
     * The vid_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $vid_ivd_key = null;
    /**
     * The vid_net_total
     * Meta information extracted from the WSDL
     * - documentation: Net Total. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $vid_net_total = null;
    /**
     * The vid_inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $vid_inv_key = null;
    /**
     * The vid_ivd_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $vid_ivd_entity_key = null;
    /**
     * Constructor method for FundraisingGift_Net_Amount_Information_DataObjectType
     * @uses FundraisingGift_Net_Amount_Information_DataObjectType::setVid_ivd_key()
     * @uses FundraisingGift_Net_Amount_Information_DataObjectType::setVid_net_total()
     * @uses FundraisingGift_Net_Amount_Information_DataObjectType::setVid_inv_key()
     * @uses FundraisingGift_Net_Amount_Information_DataObjectType::setVid_ivd_entity_key()
     * @param string $vid_ivd_key
     * @param float $vid_net_total
     * @param string $vid_inv_key
     * @param string $vid_ivd_entity_key
     */
    public function __construct(?string $vid_ivd_key = null, ?float $vid_net_total = null, ?string $vid_inv_key = null, ?string $vid_ivd_entity_key = null)
    {
        $this
            ->setVid_ivd_key($vid_ivd_key)
            ->setVid_net_total($vid_net_total)
            ->setVid_inv_key($vid_inv_key)
            ->setVid_ivd_entity_key($vid_ivd_entity_key);
    }
    /**
     * Get vid_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVid_ivd_key(): ?string
    {
        return $this->vid_ivd_key ?? null;
    }
    /**
     * Set vid_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vid_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Net_Amount_Information_DataObjectType
     */
    public function setVid_ivd_key(?string $vid_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($vid_ivd_key) && !is_string($vid_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vid_ivd_key, true), gettype($vid_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($vid_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $vid_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($vid_ivd_key, true)), __LINE__);
        }
        if (is_null($vid_ivd_key) || (is_array($vid_ivd_key) && empty($vid_ivd_key))) {
            unset($this->vid_ivd_key);
        } else {
            $this->vid_ivd_key = $vid_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get vid_net_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVid_net_total(): ?float
    {
        return $this->vid_net_total ?? null;
    }
    /**
     * Set vid_net_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $vid_net_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Net_Amount_Information_DataObjectType
     */
    public function setVid_net_total(?float $vid_net_total = null): self
    {
        // validation for constraint: float
        if (!is_null($vid_net_total) && !(is_float($vid_net_total) || is_numeric($vid_net_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vid_net_total, true), gettype($vid_net_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($vid_net_total) && mb_strlen(mb_substr((string) $vid_net_total, false !== mb_strpos((string) $vid_net_total, '.') ? mb_strpos((string) $vid_net_total, '.') + 1 : mb_strlen((string) $vid_net_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($vid_net_total, true), mb_strlen(mb_substr((string) $vid_net_total, mb_strpos((string) $vid_net_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($vid_net_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $vid_net_total)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($vid_net_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $vid_net_total))), __LINE__);
        }
        if (is_null($vid_net_total) || (is_array($vid_net_total) && empty($vid_net_total))) {
            unset($this->vid_net_total);
        } else {
            $this->vid_net_total = $vid_net_total;
        }
        
        return $this;
    }
    /**
     * Get vid_inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVid_inv_key(): ?string
    {
        return $this->vid_inv_key ?? null;
    }
    /**
     * Set vid_inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vid_inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Net_Amount_Information_DataObjectType
     */
    public function setVid_inv_key(?string $vid_inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($vid_inv_key) && !is_string($vid_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vid_inv_key, true), gettype($vid_inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($vid_inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $vid_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($vid_inv_key, true)), __LINE__);
        }
        if (is_null($vid_inv_key) || (is_array($vid_inv_key) && empty($vid_inv_key))) {
            unset($this->vid_inv_key);
        } else {
            $this->vid_inv_key = $vid_inv_key;
        }
        
        return $this;
    }
    /**
     * Get vid_ivd_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVid_ivd_entity_key(): ?string
    {
        return $this->vid_ivd_entity_key ?? null;
    }
    /**
     * Set vid_ivd_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vid_ivd_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Net_Amount_Information_DataObjectType
     */
    public function setVid_ivd_entity_key(?string $vid_ivd_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($vid_ivd_entity_key) && !is_string($vid_ivd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vid_ivd_entity_key, true), gettype($vid_ivd_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($vid_ivd_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $vid_ivd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($vid_ivd_entity_key, true)), __LINE__);
        }
        if (is_null($vid_ivd_entity_key) || (is_array($vid_ivd_entity_key) && empty($vid_ivd_entity_key))) {
            unset($this->vid_ivd_entity_key);
        } else {
            $this->vid_ivd_entity_key = $vid_ivd_entity_key;
        }
        
        return $this;
    }
}
