<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Org_Business_Phone_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Org_Business_Phone_DataObjectType extends AbstractStructBase
{
    /**
     * The ph6__phn_key
     * Meta information extracted from the WSDL
     * - documentation: Phone Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ph6__phn_key = null;
    /**
     * The ph6__phn_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Phone Owner. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ph6__phn_cst_key_owner = null;
    /**
     * The ph6__phn_number
     * Meta information extracted from the WSDL
     * - documentation: Phone Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ph6__phn_number = null;
    /**
     * The ph6__phn_number_display
     * Meta information extracted from the WSDL
     * - documentation: Formatted Phone Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ph6__phn_number_display = null;
    /**
     * The ph6__phn_cty_key
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'bc4b70f8-280e-4bb0-b935-9f728c50e183'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ph6__phn_cty_key = null;
    /**
     * The ph6__phn_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ph6__phn_add_user = null;
    /**
     * The ph6__phn_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ph6__phn_add_date = null;
    /**
     * The ph6__phn_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ph6__phn_change_user = null;
    /**
     * The ph6__phn_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ph6__phn_change_date = null;
    /**
     * The ph6__phn_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ph6__phn_delete_flag = null;
    /**
     * The ph6__phn_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ph6__phn_entity_key = null;
    /**
     * The ph6__phn_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ph6__phn_key_ext = null;
    /**
     * Constructor method for FundraisingGift_Org_Business_Phone_DataObjectType
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_key()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_cst_key_owner()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_number()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_number_display()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_cty_key()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_add_user()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_add_date()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_change_user()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_change_date()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_delete_flag()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_entity_key()
     * @uses FundraisingGift_Org_Business_Phone_DataObjectType::setPh6__phn_key_ext()
     * @param string $ph6__phn_key
     * @param string $ph6__phn_cst_key_owner
     * @param string $ph6__phn_number
     * @param string $ph6__phn_number_display
     * @param string $ph6__phn_cty_key
     * @param string $ph6__phn_add_user
     * @param string $ph6__phn_add_date
     * @param string $ph6__phn_change_user
     * @param string $ph6__phn_change_date
     * @param string $ph6__phn_delete_flag
     * @param string $ph6__phn_entity_key
     * @param string $ph6__phn_key_ext
     */
    public function __construct(?string $ph6__phn_key = null, ?string $ph6__phn_cst_key_owner = null, ?string $ph6__phn_number = null, ?string $ph6__phn_number_display = null, ?string $ph6__phn_cty_key = null, ?string $ph6__phn_add_user = null, ?string $ph6__phn_add_date = null, ?string $ph6__phn_change_user = null, ?string $ph6__phn_change_date = null, ?string $ph6__phn_delete_flag = null, ?string $ph6__phn_entity_key = null, ?string $ph6__phn_key_ext = null)
    {
        $this
            ->setPh6__phn_key($ph6__phn_key)
            ->setPh6__phn_cst_key_owner($ph6__phn_cst_key_owner)
            ->setPh6__phn_number($ph6__phn_number)
            ->setPh6__phn_number_display($ph6__phn_number_display)
            ->setPh6__phn_cty_key($ph6__phn_cty_key)
            ->setPh6__phn_add_user($ph6__phn_add_user)
            ->setPh6__phn_add_date($ph6__phn_add_date)
            ->setPh6__phn_change_user($ph6__phn_change_user)
            ->setPh6__phn_change_date($ph6__phn_change_date)
            ->setPh6__phn_delete_flag($ph6__phn_delete_flag)
            ->setPh6__phn_entity_key($ph6__phn_entity_key)
            ->setPh6__phn_key_ext($ph6__phn_key_ext);
    }
    /**
     * Get ph6__phn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_key(): ?string
    {
        return $this->ph6__phn_key ?? null;
    }
    /**
     * Set ph6__phn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_key(?string $ph6__phn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_key) && !is_string($ph6__phn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_key, true), gettype($ph6__phn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ph6__phn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ph6__phn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ph6__phn_key, true)), __LINE__);
        }
        if (is_null($ph6__phn_key) || (is_array($ph6__phn_key) && empty($ph6__phn_key))) {
            unset($this->ph6__phn_key);
        } else {
            $this->ph6__phn_key = $ph6__phn_key;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_cst_key_owner(): ?string
    {
        return $this->ph6__phn_cst_key_owner ?? null;
    }
    /**
     * Set ph6__phn_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_cst_key_owner(?string $ph6__phn_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_cst_key_owner) && !is_string($ph6__phn_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_cst_key_owner, true), gettype($ph6__phn_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ph6__phn_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ph6__phn_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ph6__phn_cst_key_owner, true)), __LINE__);
        }
        if (is_null($ph6__phn_cst_key_owner) || (is_array($ph6__phn_cst_key_owner) && empty($ph6__phn_cst_key_owner))) {
            unset($this->ph6__phn_cst_key_owner);
        } else {
            $this->ph6__phn_cst_key_owner = $ph6__phn_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_number(): ?string
    {
        return $this->ph6__phn_number ?? null;
    }
    /**
     * Set ph6__phn_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_number(?string $ph6__phn_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_number) && !is_string($ph6__phn_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_number, true), gettype($ph6__phn_number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ph6__phn_number) && mb_strlen((string) $ph6__phn_number) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ph6__phn_number)), __LINE__);
        }
        if (is_null($ph6__phn_number) || (is_array($ph6__phn_number) && empty($ph6__phn_number))) {
            unset($this->ph6__phn_number);
        } else {
            $this->ph6__phn_number = $ph6__phn_number;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_number_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_number_display(): ?string
    {
        return $this->ph6__phn_number_display ?? null;
    }
    /**
     * Set ph6__phn_number_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_number_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_number_display(?string $ph6__phn_number_display = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_number_display) && !is_string($ph6__phn_number_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_number_display, true), gettype($ph6__phn_number_display)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ph6__phn_number_display) && mb_strlen((string) $ph6__phn_number_display) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $ph6__phn_number_display)), __LINE__);
        }
        if (is_null($ph6__phn_number_display) || (is_array($ph6__phn_number_display) && empty($ph6__phn_number_display))) {
            unset($this->ph6__phn_number_display);
        } else {
            $this->ph6__phn_number_display = $ph6__phn_number_display;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_cty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_cty_key(): ?string
    {
        return $this->ph6__phn_cty_key ?? null;
    }
    /**
     * Set ph6__phn_cty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_cty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_cty_key(?string $ph6__phn_cty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_cty_key) && !is_string($ph6__phn_cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_cty_key, true), gettype($ph6__phn_cty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ph6__phn_cty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ph6__phn_cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ph6__phn_cty_key, true)), __LINE__);
        }
        if (is_null($ph6__phn_cty_key) || (is_array($ph6__phn_cty_key) && empty($ph6__phn_cty_key))) {
            unset($this->ph6__phn_cty_key);
        } else {
            $this->ph6__phn_cty_key = $ph6__phn_cty_key;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_add_user(): ?string
    {
        return $this->ph6__phn_add_user ?? null;
    }
    /**
     * Set ph6__phn_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_add_user(?string $ph6__phn_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_add_user) && !is_string($ph6__phn_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_add_user, true), gettype($ph6__phn_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ph6__phn_add_user) && mb_strlen((string) $ph6__phn_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ph6__phn_add_user)), __LINE__);
        }
        if (is_null($ph6__phn_add_user) || (is_array($ph6__phn_add_user) && empty($ph6__phn_add_user))) {
            unset($this->ph6__phn_add_user);
        } else {
            $this->ph6__phn_add_user = $ph6__phn_add_user;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_add_date(): ?string
    {
        return $this->ph6__phn_add_date ?? null;
    }
    /**
     * Set ph6__phn_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_add_date(?string $ph6__phn_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_add_date) && !is_string($ph6__phn_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_add_date, true), gettype($ph6__phn_add_date)), __LINE__);
        }
        if (is_null($ph6__phn_add_date) || (is_array($ph6__phn_add_date) && empty($ph6__phn_add_date))) {
            unset($this->ph6__phn_add_date);
        } else {
            $this->ph6__phn_add_date = $ph6__phn_add_date;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_change_user(): ?string
    {
        return $this->ph6__phn_change_user ?? null;
    }
    /**
     * Set ph6__phn_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_change_user(?string $ph6__phn_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_change_user) && !is_string($ph6__phn_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_change_user, true), gettype($ph6__phn_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ph6__phn_change_user) && mb_strlen((string) $ph6__phn_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ph6__phn_change_user)), __LINE__);
        }
        if (is_null($ph6__phn_change_user) || (is_array($ph6__phn_change_user) && empty($ph6__phn_change_user))) {
            unset($this->ph6__phn_change_user);
        } else {
            $this->ph6__phn_change_user = $ph6__phn_change_user;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_change_date(): ?string
    {
        return $this->ph6__phn_change_date ?? null;
    }
    /**
     * Set ph6__phn_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_change_date(?string $ph6__phn_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_change_date) && !is_string($ph6__phn_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_change_date, true), gettype($ph6__phn_change_date)), __LINE__);
        }
        if (is_null($ph6__phn_change_date) || (is_array($ph6__phn_change_date) && empty($ph6__phn_change_date))) {
            unset($this->ph6__phn_change_date);
        } else {
            $this->ph6__phn_change_date = $ph6__phn_change_date;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_delete_flag(): ?string
    {
        return $this->ph6__phn_delete_flag ?? null;
    }
    /**
     * Set ph6__phn_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_delete_flag(?string $ph6__phn_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_delete_flag) && !is_string($ph6__phn_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_delete_flag, true), gettype($ph6__phn_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ph6__phn_delete_flag) && $ph6__phn_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ph6__phn_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ph6__phn_delete_flag) && $ph6__phn_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ph6__phn_delete_flag, true)), __LINE__);
        }
        if (is_null($ph6__phn_delete_flag) || (is_array($ph6__phn_delete_flag) && empty($ph6__phn_delete_flag))) {
            unset($this->ph6__phn_delete_flag);
        } else {
            $this->ph6__phn_delete_flag = $ph6__phn_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_entity_key(): ?string
    {
        return $this->ph6__phn_entity_key ?? null;
    }
    /**
     * Set ph6__phn_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_entity_key(?string $ph6__phn_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_entity_key) && !is_string($ph6__phn_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_entity_key, true), gettype($ph6__phn_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ph6__phn_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ph6__phn_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ph6__phn_entity_key, true)), __LINE__);
        }
        if (is_null($ph6__phn_entity_key) || (is_array($ph6__phn_entity_key) && empty($ph6__phn_entity_key))) {
            unset($this->ph6__phn_entity_key);
        } else {
            $this->ph6__phn_entity_key = $ph6__phn_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ph6__phn_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPh6__phn_key_ext(): ?string
    {
        return $this->ph6__phn_key_ext ?? null;
    }
    /**
     * Set ph6__phn_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ph6__phn_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Phone_DataObjectType
     */
    public function setPh6__phn_key_ext(?string $ph6__phn_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ph6__phn_key_ext) && !is_string($ph6__phn_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ph6__phn_key_ext, true), gettype($ph6__phn_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ph6__phn_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ph6__phn_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ph6__phn_key_ext, true)), __LINE__);
        }
        if (is_null($ph6__phn_key_ext) || (is_array($ph6__phn_key_ext) && empty($ph6__phn_key_ext))) {
            unset($this->ph6__phn_key_ext);
        } else {
            $this->ph6__phn_key_ext = $ph6__phn_key_ext;
        }
        
        return $this;
    }
}
