<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Package_Code_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Package_Code_DataObjectType extends AbstractStructBase
{
    /**
     * The pck_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pck_key = null;
    /**
     * The pck_code
     * Meta information extracted from the WSDL
     * - documentation: Package Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_code = null;
    /**
     * The pck_description
     * Meta information extracted from the WSDL
     * - documentation: Package Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_description = null;
    /**
     * The pck_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_start_date = null;
    /**
     * The pck_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_end_date = null;
    /**
     * The pck_goal
     * Meta information extracted from the WSDL
     * - documentation: Package Goal. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $pck_goal = null;
    /**
     * The pck_notes
     * Meta information extracted from the WSDL
     * - documentation: Package Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_notes = null;
    /**
     * The pck_active_flag
     * Meta information extracted from the WSDL
     * - documentation: Package Active Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_active_flag = null;
    /**
     * The pck_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_add_user = null;
    /**
     * The pck_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_add_date = null;
    /**
     * The pck_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_change_user = null;
    /**
     * The pck_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_change_date = null;
    /**
     * The pck_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pck_delete_flag = null;
    /**
     * The pck_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pck_entity_key = null;
    /**
     * The pck_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pck_key_ext = null;
    /**
     * The pck_oes_key
     * Meta information extracted from the WSDL
     * - documentation: Cost Setup. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pck_oes_key = null;
    /**
     * Constructor method for FundraisingGift_Package_Code_DataObjectType
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_key()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_code()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_description()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_start_date()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_end_date()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_goal()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_notes()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_active_flag()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_add_user()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_add_date()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_change_user()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_change_date()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_delete_flag()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_entity_key()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_key_ext()
     * @uses FundraisingGift_Package_Code_DataObjectType::setPck_oes_key()
     * @param string $pck_key
     * @param string $pck_code
     * @param string $pck_description
     * @param string $pck_start_date
     * @param string $pck_end_date
     * @param float $pck_goal
     * @param string $pck_notes
     * @param string $pck_active_flag
     * @param string $pck_add_user
     * @param string $pck_add_date
     * @param string $pck_change_user
     * @param string $pck_change_date
     * @param string $pck_delete_flag
     * @param string $pck_entity_key
     * @param string $pck_key_ext
     * @param string $pck_oes_key
     */
    public function __construct(?string $pck_key = null, ?string $pck_code = null, ?string $pck_description = null, ?string $pck_start_date = null, ?string $pck_end_date = null, ?float $pck_goal = null, ?string $pck_notes = null, ?string $pck_active_flag = null, ?string $pck_add_user = null, ?string $pck_add_date = null, ?string $pck_change_user = null, ?string $pck_change_date = null, ?string $pck_delete_flag = null, ?string $pck_entity_key = null, ?string $pck_key_ext = null, ?string $pck_oes_key = null)
    {
        $this
            ->setPck_key($pck_key)
            ->setPck_code($pck_code)
            ->setPck_description($pck_description)
            ->setPck_start_date($pck_start_date)
            ->setPck_end_date($pck_end_date)
            ->setPck_goal($pck_goal)
            ->setPck_notes($pck_notes)
            ->setPck_active_flag($pck_active_flag)
            ->setPck_add_user($pck_add_user)
            ->setPck_add_date($pck_add_date)
            ->setPck_change_user($pck_change_user)
            ->setPck_change_date($pck_change_date)
            ->setPck_delete_flag($pck_delete_flag)
            ->setPck_entity_key($pck_entity_key)
            ->setPck_key_ext($pck_key_ext)
            ->setPck_oes_key($pck_oes_key);
    }
    /**
     * Get pck_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_key(): ?string
    {
        return $this->pck_key ?? null;
    }
    /**
     * Set pck_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_key(?string $pck_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_key) && !is_string($pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_key, true), gettype($pck_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pck_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pck_key, true)), __LINE__);
        }
        if (is_null($pck_key) || (is_array($pck_key) && empty($pck_key))) {
            unset($this->pck_key);
        } else {
            $this->pck_key = $pck_key;
        }
        
        return $this;
    }
    /**
     * Get pck_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_code(): ?string
    {
        return $this->pck_code ?? null;
    }
    /**
     * Set pck_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_code(?string $pck_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_code) && !is_string($pck_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_code, true), gettype($pck_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($pck_code) && mb_strlen((string) $pck_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $pck_code)), __LINE__);
        }
        if (is_null($pck_code) || (is_array($pck_code) && empty($pck_code))) {
            unset($this->pck_code);
        } else {
            $this->pck_code = $pck_code;
        }
        
        return $this;
    }
    /**
     * Get pck_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_description(): ?string
    {
        return $this->pck_description ?? null;
    }
    /**
     * Set pck_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_description(?string $pck_description = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_description) && !is_string($pck_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_description, true), gettype($pck_description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($pck_description) && mb_strlen((string) $pck_description) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $pck_description)), __LINE__);
        }
        if (is_null($pck_description) || (is_array($pck_description) && empty($pck_description))) {
            unset($this->pck_description);
        } else {
            $this->pck_description = $pck_description;
        }
        
        return $this;
    }
    /**
     * Get pck_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_start_date(): ?string
    {
        return $this->pck_start_date ?? null;
    }
    /**
     * Set pck_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_start_date(?string $pck_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_start_date) && !is_string($pck_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_start_date, true), gettype($pck_start_date)), __LINE__);
        }
        if (is_null($pck_start_date) || (is_array($pck_start_date) && empty($pck_start_date))) {
            unset($this->pck_start_date);
        } else {
            $this->pck_start_date = $pck_start_date;
        }
        
        return $this;
    }
    /**
     * Get pck_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_end_date(): ?string
    {
        return $this->pck_end_date ?? null;
    }
    /**
     * Set pck_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_end_date(?string $pck_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_end_date) && !is_string($pck_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_end_date, true), gettype($pck_end_date)), __LINE__);
        }
        if (is_null($pck_end_date) || (is_array($pck_end_date) && empty($pck_end_date))) {
            unset($this->pck_end_date);
        } else {
            $this->pck_end_date = $pck_end_date;
        }
        
        return $this;
    }
    /**
     * Get pck_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPck_goal(): ?float
    {
        return $this->pck_goal ?? null;
    }
    /**
     * Set pck_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pck_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_goal(?float $pck_goal = null): self
    {
        // validation for constraint: float
        if (!is_null($pck_goal) && !(is_float($pck_goal) || is_numeric($pck_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pck_goal, true), gettype($pck_goal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pck_goal) && mb_strlen(mb_substr((string) $pck_goal, false !== mb_strpos((string) $pck_goal, '.') ? mb_strpos((string) $pck_goal, '.') + 1 : mb_strlen((string) $pck_goal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pck_goal, true), mb_strlen(mb_substr((string) $pck_goal, mb_strpos((string) $pck_goal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($pck_goal) && mb_strlen(preg_replace('/(\D)/', '', (string) $pck_goal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($pck_goal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pck_goal))), __LINE__);
        }
        if (is_null($pck_goal) || (is_array($pck_goal) && empty($pck_goal))) {
            unset($this->pck_goal);
        } else {
            $this->pck_goal = $pck_goal;
        }
        
        return $this;
    }
    /**
     * Get pck_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_notes(): ?string
    {
        return $this->pck_notes ?? null;
    }
    /**
     * Set pck_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_notes(?string $pck_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_notes) && !is_string($pck_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_notes, true), gettype($pck_notes)), __LINE__);
        }
        if (is_null($pck_notes) || (is_array($pck_notes) && empty($pck_notes))) {
            unset($this->pck_notes);
        } else {
            $this->pck_notes = $pck_notes;
        }
        
        return $this;
    }
    /**
     * Get pck_active_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_active_flag(): ?string
    {
        return $this->pck_active_flag ?? null;
    }
    /**
     * Set pck_active_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_active_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_active_flag(?string $pck_active_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_active_flag) && !is_string($pck_active_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_active_flag, true), gettype($pck_active_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pck_active_flag) && $pck_active_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pck_active_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pck_active_flag) && $pck_active_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pck_active_flag, true)), __LINE__);
        }
        if (is_null($pck_active_flag) || (is_array($pck_active_flag) && empty($pck_active_flag))) {
            unset($this->pck_active_flag);
        } else {
            $this->pck_active_flag = $pck_active_flag;
        }
        
        return $this;
    }
    /**
     * Get pck_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_add_user(): ?string
    {
        return $this->pck_add_user ?? null;
    }
    /**
     * Set pck_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_add_user(?string $pck_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_add_user) && !is_string($pck_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_add_user, true), gettype($pck_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pck_add_user) && mb_strlen((string) $pck_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pck_add_user)), __LINE__);
        }
        if (is_null($pck_add_user) || (is_array($pck_add_user) && empty($pck_add_user))) {
            unset($this->pck_add_user);
        } else {
            $this->pck_add_user = $pck_add_user;
        }
        
        return $this;
    }
    /**
     * Get pck_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_add_date(): ?string
    {
        return $this->pck_add_date ?? null;
    }
    /**
     * Set pck_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_add_date(?string $pck_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_add_date) && !is_string($pck_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_add_date, true), gettype($pck_add_date)), __LINE__);
        }
        if (is_null($pck_add_date) || (is_array($pck_add_date) && empty($pck_add_date))) {
            unset($this->pck_add_date);
        } else {
            $this->pck_add_date = $pck_add_date;
        }
        
        return $this;
    }
    /**
     * Get pck_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_change_user(): ?string
    {
        return $this->pck_change_user ?? null;
    }
    /**
     * Set pck_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_change_user(?string $pck_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_change_user) && !is_string($pck_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_change_user, true), gettype($pck_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pck_change_user) && mb_strlen((string) $pck_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pck_change_user)), __LINE__);
        }
        if (is_null($pck_change_user) || (is_array($pck_change_user) && empty($pck_change_user))) {
            unset($this->pck_change_user);
        } else {
            $this->pck_change_user = $pck_change_user;
        }
        
        return $this;
    }
    /**
     * Get pck_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_change_date(): ?string
    {
        return $this->pck_change_date ?? null;
    }
    /**
     * Set pck_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_change_date(?string $pck_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_change_date) && !is_string($pck_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_change_date, true), gettype($pck_change_date)), __LINE__);
        }
        if (is_null($pck_change_date) || (is_array($pck_change_date) && empty($pck_change_date))) {
            unset($this->pck_change_date);
        } else {
            $this->pck_change_date = $pck_change_date;
        }
        
        return $this;
    }
    /**
     * Get pck_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_delete_flag(): ?string
    {
        return $this->pck_delete_flag ?? null;
    }
    /**
     * Set pck_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_delete_flag(?string $pck_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_delete_flag) && !is_string($pck_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_delete_flag, true), gettype($pck_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pck_delete_flag) && $pck_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pck_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pck_delete_flag) && $pck_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pck_delete_flag, true)), __LINE__);
        }
        if (is_null($pck_delete_flag) || (is_array($pck_delete_flag) && empty($pck_delete_flag))) {
            unset($this->pck_delete_flag);
        } else {
            $this->pck_delete_flag = $pck_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get pck_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_entity_key(): ?string
    {
        return $this->pck_entity_key ?? null;
    }
    /**
     * Set pck_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_entity_key(?string $pck_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_entity_key) && !is_string($pck_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_entity_key, true), gettype($pck_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pck_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pck_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pck_entity_key, true)), __LINE__);
        }
        if (is_null($pck_entity_key) || (is_array($pck_entity_key) && empty($pck_entity_key))) {
            unset($this->pck_entity_key);
        } else {
            $this->pck_entity_key = $pck_entity_key;
        }
        
        return $this;
    }
    /**
     * Get pck_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_key_ext(): ?string
    {
        return $this->pck_key_ext ?? null;
    }
    /**
     * Set pck_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_key_ext(?string $pck_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_key_ext) && !is_string($pck_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_key_ext, true), gettype($pck_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pck_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pck_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pck_key_ext, true)), __LINE__);
        }
        if (is_null($pck_key_ext) || (is_array($pck_key_ext) && empty($pck_key_ext))) {
            unset($this->pck_key_ext);
        } else {
            $this->pck_key_ext = $pck_key_ext;
        }
        
        return $this;
    }
    /**
     * Get pck_oes_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPck_oes_key(): ?string
    {
        return $this->pck_oes_key ?? null;
    }
    /**
     * Set pck_oes_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pck_oes_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Package_Code_DataObjectType
     */
    public function setPck_oes_key(?string $pck_oes_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pck_oes_key) && !is_string($pck_oes_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pck_oes_key, true), gettype($pck_oes_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pck_oes_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pck_oes_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pck_oes_key, true)), __LINE__);
        }
        if (is_null($pck_oes_key) || (is_array($pck_oes_key) && empty($pck_oes_key))) {
            unset($this->pck_oes_key);
        } else {
            $this->pck_oes_key = $pck_oes_key;
        }
        
        return $this;
    }
}
