<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Pledge_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Pledge_DataObjectType extends AbstractStructBase
{
    /**
     * The plg_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_key = null;
    /**
     * The plg_fun_key
     * Meta information extracted from the WSDL
     * - documentation: Purpose Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_fun_key = null;
    /**
     * The plg_cmp_key
     * Meta information extracted from the WSDL
     * - documentation: Campaign Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_cmp_key = null;
    /**
     * The plg_apl_key
     * Meta information extracted from the WSDL
     * - documentation: Appeal Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_apl_key = null;
    /**
     * The plg_date
     * Meta information extracted from the WSDL
     * - documentation: Pledge Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_date = null;
    /**
     * The plg_start_date
     * Meta information extracted from the WSDL
     * - documentation: Pledge Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_start_date = null;
    /**
     * The plg_end_date
     * Meta information extracted from the WSDL
     * - documentation: Pledge End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_end_date = null;
    /**
     * The plg_notes
     * Meta information extracted from the WSDL
     * - documentation: Pledge Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_notes = null;
    /**
     * The plg_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_add_user = null;
    /**
     * The plg_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_add_date = null;
    /**
     * The plg_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_change_user = null;
    /**
     * The plg_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_change_date = null;
    /**
     * The plg_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_delete_flag = null;
    /**
     * The plg_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_entity_key = null;
    /**
     * The plg_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_key_ext = null;
    /**
     * The plg_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_cct_key = null;
    /**
     * The plg_fpc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_fpc_prd_key = null;
    /**
     * The plg_frt_key
     * Meta information extracted from the WSDL
     * - documentation: Recognition Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_frt_key = null;
    /**
     * The plg_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_odd_key = null;
    /**
     * The plg_recognition_customer_adr_line1
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer Adr Line1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_recognition_customer_adr_line1 = null;
    /**
     * The plg_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_cst_key = null;
    /**
     * The plg_ord_key
     * Meta information extracted from the WSDL
     * - documentation: Order Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_ord_key = null;
    /**
     * The plg_recognition_customer_adr_line2
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer Adr Line2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_recognition_customer_adr_line2 = null;
    /**
     * The plg_anonymous_flag
     * Meta information extracted from the WSDL
     * - documentation: Anonymous Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_anonymous_flag = null;
    /**
     * The plg_ord_code
     * Meta information extracted from the WSDL
     * - documentation: Order Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_ord_code = null;
    /**
     * The plg_recognition_customer_adr_line3
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer Adr Line3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_recognition_customer_adr_line3 = null;
    /**
     * The plg_pck_key
     * Meta information extracted from the WSDL
     * - documentation: Package Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_pck_key = null;
    /**
     * The plg_recognition_customer
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_recognition_customer = null;
    /**
     * The plg_recognition_customer_adr_city
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer Adr City. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_recognition_customer_adr_city = null;
    /**
     * The plg_recognition_customer_adr_state
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer Adr State. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_recognition_customer_adr_state = null;
    /**
     * The plg_recognition_customer_adr_post_code
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer Adr Post Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_recognition_customer_adr_post_code = null;
    /**
     * The plg_recognition_customer_adr_country
     * Meta information extracted from the WSDL
     * - documentation: Recognition Customer Adr Country. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_recognition_customer_adr_country = null;
    /**
     * The plg_stock_name
     * Meta information extracted from the WSDL
     * - documentation: Stock Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_stock_name = null;
    /**
     * The plg_number_of_shares
     * Meta information extracted from the WSDL
     * - documentation: Number Of Shares. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $plg_number_of_shares = null;
    /**
     * The plg_share_price
     * Meta information extracted from the WSDL
     * - documentation: Share Price. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $plg_share_price = null;
    /**
     * The plg_auto_renew_flag
     * Meta information extracted from the WSDL
     * - documentation: auto renew. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_auto_renew_flag = null;
    /**
     * The plg_renewed_to_plg_key
     * Meta information extracted from the WSDL
     * - documentation: renewed to. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_renewed_to_plg_key = null;
    /**
     * The plg_solicitor_cst_key
     * Meta information extracted from the WSDL
     * - documentation: solicitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_solicitor_cst_key = null;
    /**
     * The plg_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_src_key = null;
    /**
     * The plg_tbt_key
     * Meta information extracted from the WSDL
     * - documentation: Donation Tribute Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_tbt_key = null;
    /**
     * The plg_personal_message
     * Meta information extracted from the WSDL
     * - documentation: Personal Message. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_personal_message = null;
    /**
     * The plg_dnr_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Donor Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $plg_dnr_cst_key = null;
    /**
     * The plg_recognize_as
     * Meta information extracted from the WSDL
     * - documentation: recognize as. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_recognize_as = null;
    /**
     * The plg_receipt_status
     * Meta information extracted from the WSDL
     * - documentation: Receipt Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $plg_receipt_status = null;
    /**
     * Constructor method for FundraisingGift_Pledge_DataObjectType
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_fun_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_cmp_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_apl_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_date()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_start_date()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_end_date()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_notes()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_add_user()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_add_date()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_change_user()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_change_date()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_delete_flag()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_entity_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_key_ext()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_cct_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_fpc_prd_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_frt_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_odd_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_recognition_customer_adr_line1()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_cst_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_ord_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_recognition_customer_adr_line2()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_anonymous_flag()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_ord_code()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_recognition_customer_adr_line3()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_pck_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_recognition_customer()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_recognition_customer_adr_city()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_recognition_customer_adr_state()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_recognition_customer_adr_post_code()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_recognition_customer_adr_country()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_stock_name()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_number_of_shares()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_share_price()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_auto_renew_flag()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_renewed_to_plg_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_solicitor_cst_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_src_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_tbt_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_personal_message()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_dnr_cst_key()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_recognize_as()
     * @uses FundraisingGift_Pledge_DataObjectType::setPlg_receipt_status()
     * @param string $plg_key
     * @param string $plg_fun_key
     * @param string $plg_cmp_key
     * @param string $plg_apl_key
     * @param string $plg_date
     * @param string $plg_start_date
     * @param string $plg_end_date
     * @param string $plg_notes
     * @param string $plg_add_user
     * @param string $plg_add_date
     * @param string $plg_change_user
     * @param string $plg_change_date
     * @param string $plg_delete_flag
     * @param string $plg_entity_key
     * @param string $plg_key_ext
     * @param string $plg_cct_key
     * @param string $plg_fpc_prd_key
     * @param string $plg_frt_key
     * @param string $plg_odd_key
     * @param string $plg_recognition_customer_adr_line1
     * @param string $plg_cst_key
     * @param string $plg_ord_key
     * @param string $plg_recognition_customer_adr_line2
     * @param string $plg_anonymous_flag
     * @param string $plg_ord_code
     * @param string $plg_recognition_customer_adr_line3
     * @param string $plg_pck_key
     * @param string $plg_recognition_customer
     * @param string $plg_recognition_customer_adr_city
     * @param string $plg_recognition_customer_adr_state
     * @param string $plg_recognition_customer_adr_post_code
     * @param string $plg_recognition_customer_adr_country
     * @param string $plg_stock_name
     * @param float $plg_number_of_shares
     * @param float $plg_share_price
     * @param string $plg_auto_renew_flag
     * @param string $plg_renewed_to_plg_key
     * @param string $plg_solicitor_cst_key
     * @param string $plg_src_key
     * @param string $plg_tbt_key
     * @param string $plg_personal_message
     * @param string $plg_dnr_cst_key
     * @param string $plg_recognize_as
     * @param string $plg_receipt_status
     */
    public function __construct(?string $plg_key = null, ?string $plg_fun_key = null, ?string $plg_cmp_key = null, ?string $plg_apl_key = null, ?string $plg_date = null, ?string $plg_start_date = null, ?string $plg_end_date = null, ?string $plg_notes = null, ?string $plg_add_user = null, ?string $plg_add_date = null, ?string $plg_change_user = null, ?string $plg_change_date = null, ?string $plg_delete_flag = null, ?string $plg_entity_key = null, ?string $plg_key_ext = null, ?string $plg_cct_key = null, ?string $plg_fpc_prd_key = null, ?string $plg_frt_key = null, ?string $plg_odd_key = null, ?string $plg_recognition_customer_adr_line1 = null, ?string $plg_cst_key = null, ?string $plg_ord_key = null, ?string $plg_recognition_customer_adr_line2 = null, ?string $plg_anonymous_flag = null, ?string $plg_ord_code = null, ?string $plg_recognition_customer_adr_line3 = null, ?string $plg_pck_key = null, ?string $plg_recognition_customer = null, ?string $plg_recognition_customer_adr_city = null, ?string $plg_recognition_customer_adr_state = null, ?string $plg_recognition_customer_adr_post_code = null, ?string $plg_recognition_customer_adr_country = null, ?string $plg_stock_name = null, ?float $plg_number_of_shares = null, ?float $plg_share_price = null, ?string $plg_auto_renew_flag = null, ?string $plg_renewed_to_plg_key = null, ?string $plg_solicitor_cst_key = null, ?string $plg_src_key = null, ?string $plg_tbt_key = null, ?string $plg_personal_message = null, ?string $plg_dnr_cst_key = null, ?string $plg_recognize_as = null, ?string $plg_receipt_status = null)
    {
        $this
            ->setPlg_key($plg_key)
            ->setPlg_fun_key($plg_fun_key)
            ->setPlg_cmp_key($plg_cmp_key)
            ->setPlg_apl_key($plg_apl_key)
            ->setPlg_date($plg_date)
            ->setPlg_start_date($plg_start_date)
            ->setPlg_end_date($plg_end_date)
            ->setPlg_notes($plg_notes)
            ->setPlg_add_user($plg_add_user)
            ->setPlg_add_date($plg_add_date)
            ->setPlg_change_user($plg_change_user)
            ->setPlg_change_date($plg_change_date)
            ->setPlg_delete_flag($plg_delete_flag)
            ->setPlg_entity_key($plg_entity_key)
            ->setPlg_key_ext($plg_key_ext)
            ->setPlg_cct_key($plg_cct_key)
            ->setPlg_fpc_prd_key($plg_fpc_prd_key)
            ->setPlg_frt_key($plg_frt_key)
            ->setPlg_odd_key($plg_odd_key)
            ->setPlg_recognition_customer_adr_line1($plg_recognition_customer_adr_line1)
            ->setPlg_cst_key($plg_cst_key)
            ->setPlg_ord_key($plg_ord_key)
            ->setPlg_recognition_customer_adr_line2($plg_recognition_customer_adr_line2)
            ->setPlg_anonymous_flag($plg_anonymous_flag)
            ->setPlg_ord_code($plg_ord_code)
            ->setPlg_recognition_customer_adr_line3($plg_recognition_customer_adr_line3)
            ->setPlg_pck_key($plg_pck_key)
            ->setPlg_recognition_customer($plg_recognition_customer)
            ->setPlg_recognition_customer_adr_city($plg_recognition_customer_adr_city)
            ->setPlg_recognition_customer_adr_state($plg_recognition_customer_adr_state)
            ->setPlg_recognition_customer_adr_post_code($plg_recognition_customer_adr_post_code)
            ->setPlg_recognition_customer_adr_country($plg_recognition_customer_adr_country)
            ->setPlg_stock_name($plg_stock_name)
            ->setPlg_number_of_shares($plg_number_of_shares)
            ->setPlg_share_price($plg_share_price)
            ->setPlg_auto_renew_flag($plg_auto_renew_flag)
            ->setPlg_renewed_to_plg_key($plg_renewed_to_plg_key)
            ->setPlg_solicitor_cst_key($plg_solicitor_cst_key)
            ->setPlg_src_key($plg_src_key)
            ->setPlg_tbt_key($plg_tbt_key)
            ->setPlg_personal_message($plg_personal_message)
            ->setPlg_dnr_cst_key($plg_dnr_cst_key)
            ->setPlg_recognize_as($plg_recognize_as)
            ->setPlg_receipt_status($plg_receipt_status);
    }
    /**
     * Get plg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_key(): ?string
    {
        return $this->plg_key ?? null;
    }
    /**
     * Set plg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_key(?string $plg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_key) && !is_string($plg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_key, true), gettype($plg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_key, true)), __LINE__);
        }
        if (is_null($plg_key) || (is_array($plg_key) && empty($plg_key))) {
            unset($this->plg_key);
        } else {
            $this->plg_key = $plg_key;
        }
        
        return $this;
    }
    /**
     * Get plg_fun_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_fun_key(): ?string
    {
        return $this->plg_fun_key ?? null;
    }
    /**
     * Set plg_fun_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_fun_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_fun_key(?string $plg_fun_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_fun_key) && !is_string($plg_fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_fun_key, true), gettype($plg_fun_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_fun_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_fun_key, true)), __LINE__);
        }
        if (is_null($plg_fun_key) || (is_array($plg_fun_key) && empty($plg_fun_key))) {
            unset($this->plg_fun_key);
        } else {
            $this->plg_fun_key = $plg_fun_key;
        }
        
        return $this;
    }
    /**
     * Get plg_cmp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_cmp_key(): ?string
    {
        return $this->plg_cmp_key ?? null;
    }
    /**
     * Set plg_cmp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_cmp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_cmp_key(?string $plg_cmp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_cmp_key) && !is_string($plg_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_cmp_key, true), gettype($plg_cmp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_cmp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_cmp_key, true)), __LINE__);
        }
        if (is_null($plg_cmp_key) || (is_array($plg_cmp_key) && empty($plg_cmp_key))) {
            unset($this->plg_cmp_key);
        } else {
            $this->plg_cmp_key = $plg_cmp_key;
        }
        
        return $this;
    }
    /**
     * Get plg_apl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_apl_key(): ?string
    {
        return $this->plg_apl_key ?? null;
    }
    /**
     * Set plg_apl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_apl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_apl_key(?string $plg_apl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_apl_key) && !is_string($plg_apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_apl_key, true), gettype($plg_apl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_apl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_apl_key, true)), __LINE__);
        }
        if (is_null($plg_apl_key) || (is_array($plg_apl_key) && empty($plg_apl_key))) {
            unset($this->plg_apl_key);
        } else {
            $this->plg_apl_key = $plg_apl_key;
        }
        
        return $this;
    }
    /**
     * Get plg_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_date(): ?string
    {
        return $this->plg_date ?? null;
    }
    /**
     * Set plg_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_date(?string $plg_date = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_date) && !is_string($plg_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_date, true), gettype($plg_date)), __LINE__);
        }
        if (is_null($plg_date) || (is_array($plg_date) && empty($plg_date))) {
            unset($this->plg_date);
        } else {
            $this->plg_date = $plg_date;
        }
        
        return $this;
    }
    /**
     * Get plg_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_start_date(): ?string
    {
        return $this->plg_start_date ?? null;
    }
    /**
     * Set plg_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_start_date(?string $plg_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_start_date) && !is_string($plg_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_start_date, true), gettype($plg_start_date)), __LINE__);
        }
        if (is_null($plg_start_date) || (is_array($plg_start_date) && empty($plg_start_date))) {
            unset($this->plg_start_date);
        } else {
            $this->plg_start_date = $plg_start_date;
        }
        
        return $this;
    }
    /**
     * Get plg_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_end_date(): ?string
    {
        return $this->plg_end_date ?? null;
    }
    /**
     * Set plg_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_end_date(?string $plg_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_end_date) && !is_string($plg_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_end_date, true), gettype($plg_end_date)), __LINE__);
        }
        if (is_null($plg_end_date) || (is_array($plg_end_date) && empty($plg_end_date))) {
            unset($this->plg_end_date);
        } else {
            $this->plg_end_date = $plg_end_date;
        }
        
        return $this;
    }
    /**
     * Get plg_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_notes(): ?string
    {
        return $this->plg_notes ?? null;
    }
    /**
     * Set plg_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_notes(?string $plg_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_notes) && !is_string($plg_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_notes, true), gettype($plg_notes)), __LINE__);
        }
        if (is_null($plg_notes) || (is_array($plg_notes) && empty($plg_notes))) {
            unset($this->plg_notes);
        } else {
            $this->plg_notes = $plg_notes;
        }
        
        return $this;
    }
    /**
     * Get plg_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_add_user(): ?string
    {
        return $this->plg_add_user ?? null;
    }
    /**
     * Set plg_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_add_user(?string $plg_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_add_user) && !is_string($plg_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_add_user, true), gettype($plg_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($plg_add_user) && mb_strlen((string) $plg_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $plg_add_user)), __LINE__);
        }
        if (is_null($plg_add_user) || (is_array($plg_add_user) && empty($plg_add_user))) {
            unset($this->plg_add_user);
        } else {
            $this->plg_add_user = $plg_add_user;
        }
        
        return $this;
    }
    /**
     * Get plg_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_add_date(): ?string
    {
        return $this->plg_add_date ?? null;
    }
    /**
     * Set plg_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_add_date(?string $plg_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_add_date) && !is_string($plg_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_add_date, true), gettype($plg_add_date)), __LINE__);
        }
        if (is_null($plg_add_date) || (is_array($plg_add_date) && empty($plg_add_date))) {
            unset($this->plg_add_date);
        } else {
            $this->plg_add_date = $plg_add_date;
        }
        
        return $this;
    }
    /**
     * Get plg_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_change_user(): ?string
    {
        return $this->plg_change_user ?? null;
    }
    /**
     * Set plg_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_change_user(?string $plg_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_change_user) && !is_string($plg_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_change_user, true), gettype($plg_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($plg_change_user) && mb_strlen((string) $plg_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $plg_change_user)), __LINE__);
        }
        if (is_null($plg_change_user) || (is_array($plg_change_user) && empty($plg_change_user))) {
            unset($this->plg_change_user);
        } else {
            $this->plg_change_user = $plg_change_user;
        }
        
        return $this;
    }
    /**
     * Get plg_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_change_date(): ?string
    {
        return $this->plg_change_date ?? null;
    }
    /**
     * Set plg_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_change_date(?string $plg_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_change_date) && !is_string($plg_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_change_date, true), gettype($plg_change_date)), __LINE__);
        }
        if (is_null($plg_change_date) || (is_array($plg_change_date) && empty($plg_change_date))) {
            unset($this->plg_change_date);
        } else {
            $this->plg_change_date = $plg_change_date;
        }
        
        return $this;
    }
    /**
     * Get plg_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_delete_flag(): ?string
    {
        return $this->plg_delete_flag ?? null;
    }
    /**
     * Set plg_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_delete_flag(?string $plg_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_delete_flag) && !is_string($plg_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_delete_flag, true), gettype($plg_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($plg_delete_flag) && $plg_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($plg_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($plg_delete_flag) && $plg_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($plg_delete_flag, true)), __LINE__);
        }
        if (is_null($plg_delete_flag) || (is_array($plg_delete_flag) && empty($plg_delete_flag))) {
            unset($this->plg_delete_flag);
        } else {
            $this->plg_delete_flag = $plg_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get plg_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_entity_key(): ?string
    {
        return $this->plg_entity_key ?? null;
    }
    /**
     * Set plg_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_entity_key(?string $plg_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_entity_key) && !is_string($plg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_entity_key, true), gettype($plg_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_entity_key, true)), __LINE__);
        }
        if (is_null($plg_entity_key) || (is_array($plg_entity_key) && empty($plg_entity_key))) {
            unset($this->plg_entity_key);
        } else {
            $this->plg_entity_key = $plg_entity_key;
        }
        
        return $this;
    }
    /**
     * Get plg_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_key_ext(): ?string
    {
        return $this->plg_key_ext ?? null;
    }
    /**
     * Set plg_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_key_ext(?string $plg_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_key_ext) && !is_string($plg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_key_ext, true), gettype($plg_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_key_ext, true)), __LINE__);
        }
        if (is_null($plg_key_ext) || (is_array($plg_key_ext) && empty($plg_key_ext))) {
            unset($this->plg_key_ext);
        } else {
            $this->plg_key_ext = $plg_key_ext;
        }
        
        return $this;
    }
    /**
     * Get plg_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_cct_key(): ?string
    {
        return $this->plg_cct_key ?? null;
    }
    /**
     * Set plg_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_cct_key(?string $plg_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_cct_key) && !is_string($plg_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_cct_key, true), gettype($plg_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_cct_key, true)), __LINE__);
        }
        if (is_null($plg_cct_key) || (is_array($plg_cct_key) && empty($plg_cct_key))) {
            unset($this->plg_cct_key);
        } else {
            $this->plg_cct_key = $plg_cct_key;
        }
        
        return $this;
    }
    /**
     * Get plg_fpc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_fpc_prd_key(): ?string
    {
        return $this->plg_fpc_prd_key ?? null;
    }
    /**
     * Set plg_fpc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_fpc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_fpc_prd_key(?string $plg_fpc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_fpc_prd_key) && !is_string($plg_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_fpc_prd_key, true), gettype($plg_fpc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_fpc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_fpc_prd_key, true)), __LINE__);
        }
        if (is_null($plg_fpc_prd_key) || (is_array($plg_fpc_prd_key) && empty($plg_fpc_prd_key))) {
            unset($this->plg_fpc_prd_key);
        } else {
            $this->plg_fpc_prd_key = $plg_fpc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get plg_frt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_frt_key(): ?string
    {
        return $this->plg_frt_key ?? null;
    }
    /**
     * Set plg_frt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_frt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_frt_key(?string $plg_frt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_frt_key) && !is_string($plg_frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_frt_key, true), gettype($plg_frt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_frt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_frt_key, true)), __LINE__);
        }
        if (is_null($plg_frt_key) || (is_array($plg_frt_key) && empty($plg_frt_key))) {
            unset($this->plg_frt_key);
        } else {
            $this->plg_frt_key = $plg_frt_key;
        }
        
        return $this;
    }
    /**
     * Get plg_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_odd_key(): ?string
    {
        return $this->plg_odd_key ?? null;
    }
    /**
     * Set plg_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_odd_key(?string $plg_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_odd_key) && !is_string($plg_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_odd_key, true), gettype($plg_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_odd_key, true)), __LINE__);
        }
        if (is_null($plg_odd_key) || (is_array($plg_odd_key) && empty($plg_odd_key))) {
            unset($this->plg_odd_key);
        } else {
            $this->plg_odd_key = $plg_odd_key;
        }
        
        return $this;
    }
    /**
     * Get plg_recognition_customer_adr_line1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_recognition_customer_adr_line1(): ?string
    {
        return $this->plg_recognition_customer_adr_line1 ?? null;
    }
    /**
     * Set plg_recognition_customer_adr_line1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_recognition_customer_adr_line1
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_recognition_customer_adr_line1(?string $plg_recognition_customer_adr_line1 = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_recognition_customer_adr_line1) && !is_string($plg_recognition_customer_adr_line1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_recognition_customer_adr_line1, true), gettype($plg_recognition_customer_adr_line1)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($plg_recognition_customer_adr_line1) && mb_strlen((string) $plg_recognition_customer_adr_line1) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $plg_recognition_customer_adr_line1)), __LINE__);
        }
        if (is_null($plg_recognition_customer_adr_line1) || (is_array($plg_recognition_customer_adr_line1) && empty($plg_recognition_customer_adr_line1))) {
            unset($this->plg_recognition_customer_adr_line1);
        } else {
            $this->plg_recognition_customer_adr_line1 = $plg_recognition_customer_adr_line1;
        }
        
        return $this;
    }
    /**
     * Get plg_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_cst_key(): ?string
    {
        return $this->plg_cst_key ?? null;
    }
    /**
     * Set plg_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_cst_key(?string $plg_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_cst_key) && !is_string($plg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_cst_key, true), gettype($plg_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_cst_key, true)), __LINE__);
        }
        if (is_null($plg_cst_key) || (is_array($plg_cst_key) && empty($plg_cst_key))) {
            unset($this->plg_cst_key);
        } else {
            $this->plg_cst_key = $plg_cst_key;
        }
        
        return $this;
    }
    /**
     * Get plg_ord_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_ord_key(): ?string
    {
        return $this->plg_ord_key ?? null;
    }
    /**
     * Set plg_ord_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_ord_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_ord_key(?string $plg_ord_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_ord_key) && !is_string($plg_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_ord_key, true), gettype($plg_ord_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_ord_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_ord_key, true)), __LINE__);
        }
        if (is_null($plg_ord_key) || (is_array($plg_ord_key) && empty($plg_ord_key))) {
            unset($this->plg_ord_key);
        } else {
            $this->plg_ord_key = $plg_ord_key;
        }
        
        return $this;
    }
    /**
     * Get plg_recognition_customer_adr_line2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_recognition_customer_adr_line2(): ?string
    {
        return $this->plg_recognition_customer_adr_line2 ?? null;
    }
    /**
     * Set plg_recognition_customer_adr_line2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_recognition_customer_adr_line2
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_recognition_customer_adr_line2(?string $plg_recognition_customer_adr_line2 = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_recognition_customer_adr_line2) && !is_string($plg_recognition_customer_adr_line2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_recognition_customer_adr_line2, true), gettype($plg_recognition_customer_adr_line2)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($plg_recognition_customer_adr_line2) && mb_strlen((string) $plg_recognition_customer_adr_line2) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $plg_recognition_customer_adr_line2)), __LINE__);
        }
        if (is_null($plg_recognition_customer_adr_line2) || (is_array($plg_recognition_customer_adr_line2) && empty($plg_recognition_customer_adr_line2))) {
            unset($this->plg_recognition_customer_adr_line2);
        } else {
            $this->plg_recognition_customer_adr_line2 = $plg_recognition_customer_adr_line2;
        }
        
        return $this;
    }
    /**
     * Get plg_anonymous_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_anonymous_flag(): ?string
    {
        return $this->plg_anonymous_flag ?? null;
    }
    /**
     * Set plg_anonymous_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_anonymous_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_anonymous_flag(?string $plg_anonymous_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_anonymous_flag) && !is_string($plg_anonymous_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_anonymous_flag, true), gettype($plg_anonymous_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($plg_anonymous_flag) && $plg_anonymous_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($plg_anonymous_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($plg_anonymous_flag) && $plg_anonymous_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($plg_anonymous_flag, true)), __LINE__);
        }
        if (is_null($plg_anonymous_flag) || (is_array($plg_anonymous_flag) && empty($plg_anonymous_flag))) {
            unset($this->plg_anonymous_flag);
        } else {
            $this->plg_anonymous_flag = $plg_anonymous_flag;
        }
        
        return $this;
    }
    /**
     * Get plg_ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_ord_code(): ?string
    {
        return $this->plg_ord_code ?? null;
    }
    /**
     * Set plg_ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_ord_code(?string $plg_ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_ord_code) && !is_string($plg_ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_ord_code, true), gettype($plg_ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($plg_ord_code) && mb_strlen((string) $plg_ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $plg_ord_code)), __LINE__);
        }
        if (is_null($plg_ord_code) || (is_array($plg_ord_code) && empty($plg_ord_code))) {
            unset($this->plg_ord_code);
        } else {
            $this->plg_ord_code = $plg_ord_code;
        }
        
        return $this;
    }
    /**
     * Get plg_recognition_customer_adr_line3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_recognition_customer_adr_line3(): ?string
    {
        return $this->plg_recognition_customer_adr_line3 ?? null;
    }
    /**
     * Set plg_recognition_customer_adr_line3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_recognition_customer_adr_line3
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_recognition_customer_adr_line3(?string $plg_recognition_customer_adr_line3 = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_recognition_customer_adr_line3) && !is_string($plg_recognition_customer_adr_line3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_recognition_customer_adr_line3, true), gettype($plg_recognition_customer_adr_line3)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($plg_recognition_customer_adr_line3) && mb_strlen((string) $plg_recognition_customer_adr_line3) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $plg_recognition_customer_adr_line3)), __LINE__);
        }
        if (is_null($plg_recognition_customer_adr_line3) || (is_array($plg_recognition_customer_adr_line3) && empty($plg_recognition_customer_adr_line3))) {
            unset($this->plg_recognition_customer_adr_line3);
        } else {
            $this->plg_recognition_customer_adr_line3 = $plg_recognition_customer_adr_line3;
        }
        
        return $this;
    }
    /**
     * Get plg_pck_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_pck_key(): ?string
    {
        return $this->plg_pck_key ?? null;
    }
    /**
     * Set plg_pck_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_pck_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_pck_key(?string $plg_pck_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_pck_key) && !is_string($plg_pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_pck_key, true), gettype($plg_pck_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_pck_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_pck_key, true)), __LINE__);
        }
        if (is_null($plg_pck_key) || (is_array($plg_pck_key) && empty($plg_pck_key))) {
            unset($this->plg_pck_key);
        } else {
            $this->plg_pck_key = $plg_pck_key;
        }
        
        return $this;
    }
    /**
     * Get plg_recognition_customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_recognition_customer(): ?string
    {
        return $this->plg_recognition_customer ?? null;
    }
    /**
     * Set plg_recognition_customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_recognition_customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_recognition_customer(?string $plg_recognition_customer = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_recognition_customer) && !is_string($plg_recognition_customer)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_recognition_customer, true), gettype($plg_recognition_customer)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($plg_recognition_customer) && mb_strlen((string) $plg_recognition_customer) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $plg_recognition_customer)), __LINE__);
        }
        if (is_null($plg_recognition_customer) || (is_array($plg_recognition_customer) && empty($plg_recognition_customer))) {
            unset($this->plg_recognition_customer);
        } else {
            $this->plg_recognition_customer = $plg_recognition_customer;
        }
        
        return $this;
    }
    /**
     * Get plg_recognition_customer_adr_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_recognition_customer_adr_city(): ?string
    {
        return $this->plg_recognition_customer_adr_city ?? null;
    }
    /**
     * Set plg_recognition_customer_adr_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_recognition_customer_adr_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_recognition_customer_adr_city(?string $plg_recognition_customer_adr_city = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_recognition_customer_adr_city) && !is_string($plg_recognition_customer_adr_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_recognition_customer_adr_city, true), gettype($plg_recognition_customer_adr_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($plg_recognition_customer_adr_city) && mb_strlen((string) $plg_recognition_customer_adr_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $plg_recognition_customer_adr_city)), __LINE__);
        }
        if (is_null($plg_recognition_customer_adr_city) || (is_array($plg_recognition_customer_adr_city) && empty($plg_recognition_customer_adr_city))) {
            unset($this->plg_recognition_customer_adr_city);
        } else {
            $this->plg_recognition_customer_adr_city = $plg_recognition_customer_adr_city;
        }
        
        return $this;
    }
    /**
     * Get plg_recognition_customer_adr_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_recognition_customer_adr_state(): ?string
    {
        return $this->plg_recognition_customer_adr_state ?? null;
    }
    /**
     * Set plg_recognition_customer_adr_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_recognition_customer_adr_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_recognition_customer_adr_state(?string $plg_recognition_customer_adr_state = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_recognition_customer_adr_state) && !is_string($plg_recognition_customer_adr_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_recognition_customer_adr_state, true), gettype($plg_recognition_customer_adr_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($plg_recognition_customer_adr_state) && mb_strlen((string) $plg_recognition_customer_adr_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $plg_recognition_customer_adr_state)), __LINE__);
        }
        if (is_null($plg_recognition_customer_adr_state) || (is_array($plg_recognition_customer_adr_state) && empty($plg_recognition_customer_adr_state))) {
            unset($this->plg_recognition_customer_adr_state);
        } else {
            $this->plg_recognition_customer_adr_state = $plg_recognition_customer_adr_state;
        }
        
        return $this;
    }
    /**
     * Get plg_recognition_customer_adr_post_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_recognition_customer_adr_post_code(): ?string
    {
        return $this->plg_recognition_customer_adr_post_code ?? null;
    }
    /**
     * Set plg_recognition_customer_adr_post_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_recognition_customer_adr_post_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_recognition_customer_adr_post_code(?string $plg_recognition_customer_adr_post_code = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_recognition_customer_adr_post_code) && !is_string($plg_recognition_customer_adr_post_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_recognition_customer_adr_post_code, true), gettype($plg_recognition_customer_adr_post_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($plg_recognition_customer_adr_post_code) && mb_strlen((string) $plg_recognition_customer_adr_post_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $plg_recognition_customer_adr_post_code)), __LINE__);
        }
        if (is_null($plg_recognition_customer_adr_post_code) || (is_array($plg_recognition_customer_adr_post_code) && empty($plg_recognition_customer_adr_post_code))) {
            unset($this->plg_recognition_customer_adr_post_code);
        } else {
            $this->plg_recognition_customer_adr_post_code = $plg_recognition_customer_adr_post_code;
        }
        
        return $this;
    }
    /**
     * Get plg_recognition_customer_adr_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_recognition_customer_adr_country(): ?string
    {
        return $this->plg_recognition_customer_adr_country ?? null;
    }
    /**
     * Set plg_recognition_customer_adr_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_recognition_customer_adr_country
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_recognition_customer_adr_country(?string $plg_recognition_customer_adr_country = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_recognition_customer_adr_country) && !is_string($plg_recognition_customer_adr_country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_recognition_customer_adr_country, true), gettype($plg_recognition_customer_adr_country)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($plg_recognition_customer_adr_country) && mb_strlen((string) $plg_recognition_customer_adr_country) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $plg_recognition_customer_adr_country)), __LINE__);
        }
        if (is_null($plg_recognition_customer_adr_country) || (is_array($plg_recognition_customer_adr_country) && empty($plg_recognition_customer_adr_country))) {
            unset($this->plg_recognition_customer_adr_country);
        } else {
            $this->plg_recognition_customer_adr_country = $plg_recognition_customer_adr_country;
        }
        
        return $this;
    }
    /**
     * Get plg_stock_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_stock_name(): ?string
    {
        return $this->plg_stock_name ?? null;
    }
    /**
     * Set plg_stock_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_stock_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_stock_name(?string $plg_stock_name = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_stock_name) && !is_string($plg_stock_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_stock_name, true), gettype($plg_stock_name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($plg_stock_name) && mb_strlen((string) $plg_stock_name) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $plg_stock_name)), __LINE__);
        }
        if (is_null($plg_stock_name) || (is_array($plg_stock_name) && empty($plg_stock_name))) {
            unset($this->plg_stock_name);
        } else {
            $this->plg_stock_name = $plg_stock_name;
        }
        
        return $this;
    }
    /**
     * Get plg_number_of_shares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPlg_number_of_shares(): ?float
    {
        return $this->plg_number_of_shares ?? null;
    }
    /**
     * Set plg_number_of_shares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $plg_number_of_shares
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_number_of_shares(?float $plg_number_of_shares = null): self
    {
        // validation for constraint: float
        if (!is_null($plg_number_of_shares) && !(is_float($plg_number_of_shares) || is_numeric($plg_number_of_shares))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($plg_number_of_shares, true), gettype($plg_number_of_shares)), __LINE__);
        }
        if (is_null($plg_number_of_shares) || (is_array($plg_number_of_shares) && empty($plg_number_of_shares))) {
            unset($this->plg_number_of_shares);
        } else {
            $this->plg_number_of_shares = $plg_number_of_shares;
        }
        
        return $this;
    }
    /**
     * Get plg_share_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPlg_share_price(): ?float
    {
        return $this->plg_share_price ?? null;
    }
    /**
     * Set plg_share_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $plg_share_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_share_price(?float $plg_share_price = null): self
    {
        // validation for constraint: float
        if (!is_null($plg_share_price) && !(is_float($plg_share_price) || is_numeric($plg_share_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($plg_share_price, true), gettype($plg_share_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($plg_share_price) && mb_strlen(mb_substr((string) $plg_share_price, false !== mb_strpos((string) $plg_share_price, '.') ? mb_strpos((string) $plg_share_price, '.') + 1 : mb_strlen((string) $plg_share_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($plg_share_price, true), mb_strlen(mb_substr((string) $plg_share_price, mb_strpos((string) $plg_share_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($plg_share_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $plg_share_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($plg_share_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $plg_share_price))), __LINE__);
        }
        if (is_null($plg_share_price) || (is_array($plg_share_price) && empty($plg_share_price))) {
            unset($this->plg_share_price);
        } else {
            $this->plg_share_price = $plg_share_price;
        }
        
        return $this;
    }
    /**
     * Get plg_auto_renew_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_auto_renew_flag(): ?string
    {
        return $this->plg_auto_renew_flag ?? null;
    }
    /**
     * Set plg_auto_renew_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_auto_renew_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_auto_renew_flag(?string $plg_auto_renew_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_auto_renew_flag) && !is_string($plg_auto_renew_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_auto_renew_flag, true), gettype($plg_auto_renew_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($plg_auto_renew_flag) && $plg_auto_renew_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($plg_auto_renew_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($plg_auto_renew_flag) && $plg_auto_renew_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($plg_auto_renew_flag, true)), __LINE__);
        }
        if (is_null($plg_auto_renew_flag) || (is_array($plg_auto_renew_flag) && empty($plg_auto_renew_flag))) {
            unset($this->plg_auto_renew_flag);
        } else {
            $this->plg_auto_renew_flag = $plg_auto_renew_flag;
        }
        
        return $this;
    }
    /**
     * Get plg_renewed_to_plg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_renewed_to_plg_key(): ?string
    {
        return $this->plg_renewed_to_plg_key ?? null;
    }
    /**
     * Set plg_renewed_to_plg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_renewed_to_plg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_renewed_to_plg_key(?string $plg_renewed_to_plg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_renewed_to_plg_key) && !is_string($plg_renewed_to_plg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_renewed_to_plg_key, true), gettype($plg_renewed_to_plg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_renewed_to_plg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_renewed_to_plg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_renewed_to_plg_key, true)), __LINE__);
        }
        if (is_null($plg_renewed_to_plg_key) || (is_array($plg_renewed_to_plg_key) && empty($plg_renewed_to_plg_key))) {
            unset($this->plg_renewed_to_plg_key);
        } else {
            $this->plg_renewed_to_plg_key = $plg_renewed_to_plg_key;
        }
        
        return $this;
    }
    /**
     * Get plg_solicitor_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_solicitor_cst_key(): ?string
    {
        return $this->plg_solicitor_cst_key ?? null;
    }
    /**
     * Set plg_solicitor_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_solicitor_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_solicitor_cst_key(?string $plg_solicitor_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_solicitor_cst_key) && !is_string($plg_solicitor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_solicitor_cst_key, true), gettype($plg_solicitor_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_solicitor_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_solicitor_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_solicitor_cst_key, true)), __LINE__);
        }
        if (is_null($plg_solicitor_cst_key) || (is_array($plg_solicitor_cst_key) && empty($plg_solicitor_cst_key))) {
            unset($this->plg_solicitor_cst_key);
        } else {
            $this->plg_solicitor_cst_key = $plg_solicitor_cst_key;
        }
        
        return $this;
    }
    /**
     * Get plg_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_src_key(): ?string
    {
        return $this->plg_src_key ?? null;
    }
    /**
     * Set plg_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_src_key(?string $plg_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_src_key) && !is_string($plg_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_src_key, true), gettype($plg_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_src_key, true)), __LINE__);
        }
        if (is_null($plg_src_key) || (is_array($plg_src_key) && empty($plg_src_key))) {
            unset($this->plg_src_key);
        } else {
            $this->plg_src_key = $plg_src_key;
        }
        
        return $this;
    }
    /**
     * Get plg_tbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_tbt_key(): ?string
    {
        return $this->plg_tbt_key ?? null;
    }
    /**
     * Set plg_tbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_tbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_tbt_key(?string $plg_tbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_tbt_key) && !is_string($plg_tbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_tbt_key, true), gettype($plg_tbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_tbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_tbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_tbt_key, true)), __LINE__);
        }
        if (is_null($plg_tbt_key) || (is_array($plg_tbt_key) && empty($plg_tbt_key))) {
            unset($this->plg_tbt_key);
        } else {
            $this->plg_tbt_key = $plg_tbt_key;
        }
        
        return $this;
    }
    /**
     * Get plg_personal_message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_personal_message(): ?string
    {
        return $this->plg_personal_message ?? null;
    }
    /**
     * Set plg_personal_message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_personal_message
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_personal_message(?string $plg_personal_message = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_personal_message) && !is_string($plg_personal_message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_personal_message, true), gettype($plg_personal_message)), __LINE__);
        }
        if (is_null($plg_personal_message) || (is_array($plg_personal_message) && empty($plg_personal_message))) {
            unset($this->plg_personal_message);
        } else {
            $this->plg_personal_message = $plg_personal_message;
        }
        
        return $this;
    }
    /**
     * Get plg_dnr_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_dnr_cst_key(): ?string
    {
        return $this->plg_dnr_cst_key ?? null;
    }
    /**
     * Set plg_dnr_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_dnr_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_dnr_cst_key(?string $plg_dnr_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_dnr_cst_key) && !is_string($plg_dnr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_dnr_cst_key, true), gettype($plg_dnr_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($plg_dnr_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $plg_dnr_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($plg_dnr_cst_key, true)), __LINE__);
        }
        if (is_null($plg_dnr_cst_key) || (is_array($plg_dnr_cst_key) && empty($plg_dnr_cst_key))) {
            unset($this->plg_dnr_cst_key);
        } else {
            $this->plg_dnr_cst_key = $plg_dnr_cst_key;
        }
        
        return $this;
    }
    /**
     * Get plg_recognize_as value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_recognize_as(): ?string
    {
        return $this->plg_recognize_as ?? null;
    }
    /**
     * Set plg_recognize_as value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_recognize_as
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_recognize_as(?string $plg_recognize_as = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_recognize_as) && !is_string($plg_recognize_as)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_recognize_as, true), gettype($plg_recognize_as)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($plg_recognize_as) && mb_strlen((string) $plg_recognize_as) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $plg_recognize_as)), __LINE__);
        }
        if (is_null($plg_recognize_as) || (is_array($plg_recognize_as) && empty($plg_recognize_as))) {
            unset($this->plg_recognize_as);
        } else {
            $this->plg_recognize_as = $plg_recognize_as;
        }
        
        return $this;
    }
    /**
     * Get plg_receipt_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlg_receipt_status(): ?string
    {
        return $this->plg_receipt_status ?? null;
    }
    /**
     * Set plg_receipt_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plg_receipt_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Pledge_DataObjectType
     */
    public function setPlg_receipt_status(?string $plg_receipt_status = null): self
    {
        // validation for constraint: string
        if (!is_null($plg_receipt_status) && !is_string($plg_receipt_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plg_receipt_status, true), gettype($plg_receipt_status)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($plg_receipt_status) && mb_strlen((string) $plg_receipt_status) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $plg_receipt_status)), __LINE__);
        }
        if (is_null($plg_receipt_status) || (is_array($plg_receipt_status) && empty($plg_receipt_status))) {
            unset($this->plg_receipt_status);
        } else {
            $this->plg_receipt_status = $plg_receipt_status;
        }
        
        return $this;
    }
}
