<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Premium_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Premium_DataObjectType extends AbstractStructBase
{
    /**
     * The prm_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prm_add_user = null;
    /**
     * The prm_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prm_add_date = null;
    /**
     * The prm_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prm_change_user = null;
    /**
     * The prm_taxable_amt
     * Meta information extracted from the WSDL
     * - documentation: Taxable Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $prm_taxable_amt = null;
    /**
     * The prm_prc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prm_prc_key_ext = null;
    /**
     * The prm_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prm_change_date = null;
    /**
     * The prm_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Product Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prm_prc_key = null;
    /**
     * The prm_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prm_delete_flag = null;
    /**
     * The prm_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prm_entity_key = null;
    /**
     * Constructor method for FundraisingGift_Premium_DataObjectType
     * @uses FundraisingGift_Premium_DataObjectType::setPrm_add_user()
     * @uses FundraisingGift_Premium_DataObjectType::setPrm_add_date()
     * @uses FundraisingGift_Premium_DataObjectType::setPrm_change_user()
     * @uses FundraisingGift_Premium_DataObjectType::setPrm_taxable_amt()
     * @uses FundraisingGift_Premium_DataObjectType::setPrm_prc_key_ext()
     * @uses FundraisingGift_Premium_DataObjectType::setPrm_change_date()
     * @uses FundraisingGift_Premium_DataObjectType::setPrm_prc_key()
     * @uses FundraisingGift_Premium_DataObjectType::setPrm_delete_flag()
     * @uses FundraisingGift_Premium_DataObjectType::setPrm_entity_key()
     * @param string $prm_add_user
     * @param string $prm_add_date
     * @param string $prm_change_user
     * @param float $prm_taxable_amt
     * @param string $prm_prc_key_ext
     * @param string $prm_change_date
     * @param string $prm_prc_key
     * @param string $prm_delete_flag
     * @param string $prm_entity_key
     */
    public function __construct(?string $prm_add_user = null, ?string $prm_add_date = null, ?string $prm_change_user = null, ?float $prm_taxable_amt = null, ?string $prm_prc_key_ext = null, ?string $prm_change_date = null, ?string $prm_prc_key = null, ?string $prm_delete_flag = null, ?string $prm_entity_key = null)
    {
        $this
            ->setPrm_add_user($prm_add_user)
            ->setPrm_add_date($prm_add_date)
            ->setPrm_change_user($prm_change_user)
            ->setPrm_taxable_amt($prm_taxable_amt)
            ->setPrm_prc_key_ext($prm_prc_key_ext)
            ->setPrm_change_date($prm_change_date)
            ->setPrm_prc_key($prm_prc_key)
            ->setPrm_delete_flag($prm_delete_flag)
            ->setPrm_entity_key($prm_entity_key);
    }
    /**
     * Get prm_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrm_add_user(): ?string
    {
        return $this->prm_add_user ?? null;
    }
    /**
     * Set prm_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prm_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_DataObjectType
     */
    public function setPrm_add_user(?string $prm_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($prm_add_user) && !is_string($prm_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prm_add_user, true), gettype($prm_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($prm_add_user) && mb_strlen((string) $prm_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $prm_add_user)), __LINE__);
        }
        if (is_null($prm_add_user) || (is_array($prm_add_user) && empty($prm_add_user))) {
            unset($this->prm_add_user);
        } else {
            $this->prm_add_user = $prm_add_user;
        }
        
        return $this;
    }
    /**
     * Get prm_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrm_add_date(): ?string
    {
        return $this->prm_add_date ?? null;
    }
    /**
     * Set prm_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prm_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_DataObjectType
     */
    public function setPrm_add_date(?string $prm_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prm_add_date) && !is_string($prm_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prm_add_date, true), gettype($prm_add_date)), __LINE__);
        }
        if (is_null($prm_add_date) || (is_array($prm_add_date) && empty($prm_add_date))) {
            unset($this->prm_add_date);
        } else {
            $this->prm_add_date = $prm_add_date;
        }
        
        return $this;
    }
    /**
     * Get prm_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrm_change_user(): ?string
    {
        return $this->prm_change_user ?? null;
    }
    /**
     * Set prm_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prm_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_DataObjectType
     */
    public function setPrm_change_user(?string $prm_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($prm_change_user) && !is_string($prm_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prm_change_user, true), gettype($prm_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($prm_change_user) && mb_strlen((string) $prm_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $prm_change_user)), __LINE__);
        }
        if (is_null($prm_change_user) || (is_array($prm_change_user) && empty($prm_change_user))) {
            unset($this->prm_change_user);
        } else {
            $this->prm_change_user = $prm_change_user;
        }
        
        return $this;
    }
    /**
     * Get prm_taxable_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrm_taxable_amt(): ?float
    {
        return $this->prm_taxable_amt ?? null;
    }
    /**
     * Set prm_taxable_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prm_taxable_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_DataObjectType
     */
    public function setPrm_taxable_amt(?float $prm_taxable_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($prm_taxable_amt) && !(is_float($prm_taxable_amt) || is_numeric($prm_taxable_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prm_taxable_amt, true), gettype($prm_taxable_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prm_taxable_amt) && mb_strlen(mb_substr((string) $prm_taxable_amt, false !== mb_strpos((string) $prm_taxable_amt, '.') ? mb_strpos((string) $prm_taxable_amt, '.') + 1 : mb_strlen((string) $prm_taxable_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prm_taxable_amt, true), mb_strlen(mb_substr((string) $prm_taxable_amt, mb_strpos((string) $prm_taxable_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($prm_taxable_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $prm_taxable_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($prm_taxable_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prm_taxable_amt))), __LINE__);
        }
        if (is_null($prm_taxable_amt) || (is_array($prm_taxable_amt) && empty($prm_taxable_amt))) {
            unset($this->prm_taxable_amt);
        } else {
            $this->prm_taxable_amt = $prm_taxable_amt;
        }
        
        return $this;
    }
    /**
     * Get prm_prc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrm_prc_key_ext(): ?string
    {
        return $this->prm_prc_key_ext ?? null;
    }
    /**
     * Set prm_prc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prm_prc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_DataObjectType
     */
    public function setPrm_prc_key_ext(?string $prm_prc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($prm_prc_key_ext) && !is_string($prm_prc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prm_prc_key_ext, true), gettype($prm_prc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prm_prc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prm_prc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prm_prc_key_ext, true)), __LINE__);
        }
        if (is_null($prm_prc_key_ext) || (is_array($prm_prc_key_ext) && empty($prm_prc_key_ext))) {
            unset($this->prm_prc_key_ext);
        } else {
            $this->prm_prc_key_ext = $prm_prc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get prm_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrm_change_date(): ?string
    {
        return $this->prm_change_date ?? null;
    }
    /**
     * Set prm_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prm_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_DataObjectType
     */
    public function setPrm_change_date(?string $prm_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prm_change_date) && !is_string($prm_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prm_change_date, true), gettype($prm_change_date)), __LINE__);
        }
        if (is_null($prm_change_date) || (is_array($prm_change_date) && empty($prm_change_date))) {
            unset($this->prm_change_date);
        } else {
            $this->prm_change_date = $prm_change_date;
        }
        
        return $this;
    }
    /**
     * Get prm_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrm_prc_key(): ?string
    {
        return $this->prm_prc_key ?? null;
    }
    /**
     * Set prm_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prm_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_DataObjectType
     */
    public function setPrm_prc_key(?string $prm_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prm_prc_key) && !is_string($prm_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prm_prc_key, true), gettype($prm_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prm_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prm_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prm_prc_key, true)), __LINE__);
        }
        if (is_null($prm_prc_key) || (is_array($prm_prc_key) && empty($prm_prc_key))) {
            unset($this->prm_prc_key);
        } else {
            $this->prm_prc_key = $prm_prc_key;
        }
        
        return $this;
    }
    /**
     * Get prm_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrm_delete_flag(): ?string
    {
        return $this->prm_delete_flag ?? null;
    }
    /**
     * Set prm_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prm_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_DataObjectType
     */
    public function setPrm_delete_flag(?string $prm_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prm_delete_flag) && !is_string($prm_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prm_delete_flag, true), gettype($prm_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prm_delete_flag) && $prm_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prm_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prm_delete_flag) && $prm_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prm_delete_flag, true)), __LINE__);
        }
        if (is_null($prm_delete_flag) || (is_array($prm_delete_flag) && empty($prm_delete_flag))) {
            unset($this->prm_delete_flag);
        } else {
            $this->prm_delete_flag = $prm_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get prm_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrm_entity_key(): ?string
    {
        return $this->prm_entity_key ?? null;
    }
    /**
     * Set prm_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prm_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_DataObjectType
     */
    public function setPrm_entity_key(?string $prm_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prm_entity_key) && !is_string($prm_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prm_entity_key, true), gettype($prm_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prm_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prm_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prm_entity_key, true)), __LINE__);
        }
        if (is_null($prm_entity_key) || (is_array($prm_entity_key) && empty($prm_entity_key))) {
            unset($this->prm_entity_key);
        } else {
            $this->prm_entity_key = $prm_entity_key;
        }
        
        return $this;
    }
}
