<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Product_Code_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Product_Code_DataObjectType extends AbstractStructBase
{
    /**
     * The fpc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_add_user = null;
    /**
     * The fpc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_add_date = null;
    /**
     * The fpc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_change_user = null;
    /**
     * The fpc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_change_date = null;
    /**
     * The fpc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_delete_flag = null;
    /**
     * The fpc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fpc_entity_key = null;
    /**
     * The fpc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fpc_prd_key = null;
    /**
     * The fpc_fun_key
     * Meta information extracted from the WSDL
     * - documentation: Fund Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fpc_fun_key = null;
    /**
     * The fpc_cmp_key
     * Meta information extracted from the WSDL
     * - documentation: Campaign Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fpc_cmp_key = null;
    /**
     * The fpc_apl_key
     * Meta information extracted from the WSDL
     * - documentation: Appeal Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fpc_apl_key = null;
    /**
     * The fpc_pck_key
     * Meta information extracted from the WSDL
     * - documentation: Package Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fpc_pck_key = null;
    /**
     * The fpc_track_recognition_level_flag
     * Meta information extracted from the WSDL
     * - documentation: Track General Recognition Level. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_track_recognition_level_flag = null;
    /**
     * The fpc_event_flag
     * Meta information extracted from the WSDL
     * - documentation: use in events. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_event_flag = null;
    /**
     * The fpc_prd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fpc_prd_key_ext = null;
    /**
     * The fpc_funds_raised
     * Meta information extracted from the WSDL
     * - documentation: Funds Raised. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $fpc_funds_raised = null;
    /**
     * The fpc_funds_goal
     * Meta information extracted from the WSDL
     * - documentation: fund goal. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $fpc_funds_goal = null;
    /**
     * The fpc_start_date
     * Meta information extracted from the WSDL
     * - documentation: Fund Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_start_date = null;
    /**
     * The fpc_end_date
     * Meta information extracted from the WSDL
     * - documentation: Fund End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_end_date = null;
    /**
     * The fpc_notes
     * Meta information extracted from the WSDL
     * - documentation: Fund Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_notes = null;
    /**
     * The fpc_active_flag
     * Meta information extracted from the WSDL
     * - documentation: Fund Active Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fpc_active_flag = null;
    /**
     * Constructor method for FundraisingGift_Product_Code_DataObjectType
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_add_user()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_add_date()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_change_user()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_change_date()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_delete_flag()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_entity_key()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_prd_key()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_fun_key()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_cmp_key()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_apl_key()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_pck_key()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_track_recognition_level_flag()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_event_flag()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_prd_key_ext()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_funds_raised()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_funds_goal()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_start_date()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_end_date()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_notes()
     * @uses FundraisingGift_Product_Code_DataObjectType::setFpc_active_flag()
     * @param string $fpc_add_user
     * @param string $fpc_add_date
     * @param string $fpc_change_user
     * @param string $fpc_change_date
     * @param string $fpc_delete_flag
     * @param string $fpc_entity_key
     * @param string $fpc_prd_key
     * @param string $fpc_fun_key
     * @param string $fpc_cmp_key
     * @param string $fpc_apl_key
     * @param string $fpc_pck_key
     * @param string $fpc_track_recognition_level_flag
     * @param string $fpc_event_flag
     * @param string $fpc_prd_key_ext
     * @param float $fpc_funds_raised
     * @param float $fpc_funds_goal
     * @param string $fpc_start_date
     * @param string $fpc_end_date
     * @param string $fpc_notes
     * @param string $fpc_active_flag
     */
    public function __construct(?string $fpc_add_user = null, ?string $fpc_add_date = null, ?string $fpc_change_user = null, ?string $fpc_change_date = null, ?string $fpc_delete_flag = null, ?string $fpc_entity_key = null, ?string $fpc_prd_key = null, ?string $fpc_fun_key = null, ?string $fpc_cmp_key = null, ?string $fpc_apl_key = null, ?string $fpc_pck_key = null, ?string $fpc_track_recognition_level_flag = null, ?string $fpc_event_flag = null, ?string $fpc_prd_key_ext = null, ?float $fpc_funds_raised = null, ?float $fpc_funds_goal = null, ?string $fpc_start_date = null, ?string $fpc_end_date = null, ?string $fpc_notes = null, ?string $fpc_active_flag = null)
    {
        $this
            ->setFpc_add_user($fpc_add_user)
            ->setFpc_add_date($fpc_add_date)
            ->setFpc_change_user($fpc_change_user)
            ->setFpc_change_date($fpc_change_date)
            ->setFpc_delete_flag($fpc_delete_flag)
            ->setFpc_entity_key($fpc_entity_key)
            ->setFpc_prd_key($fpc_prd_key)
            ->setFpc_fun_key($fpc_fun_key)
            ->setFpc_cmp_key($fpc_cmp_key)
            ->setFpc_apl_key($fpc_apl_key)
            ->setFpc_pck_key($fpc_pck_key)
            ->setFpc_track_recognition_level_flag($fpc_track_recognition_level_flag)
            ->setFpc_event_flag($fpc_event_flag)
            ->setFpc_prd_key_ext($fpc_prd_key_ext)
            ->setFpc_funds_raised($fpc_funds_raised)
            ->setFpc_funds_goal($fpc_funds_goal)
            ->setFpc_start_date($fpc_start_date)
            ->setFpc_end_date($fpc_end_date)
            ->setFpc_notes($fpc_notes)
            ->setFpc_active_flag($fpc_active_flag);
    }
    /**
     * Get fpc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_add_user(): ?string
    {
        return $this->fpc_add_user ?? null;
    }
    /**
     * Set fpc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_add_user(?string $fpc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_add_user) && !is_string($fpc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_add_user, true), gettype($fpc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fpc_add_user) && mb_strlen((string) $fpc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $fpc_add_user)), __LINE__);
        }
        if (is_null($fpc_add_user) || (is_array($fpc_add_user) && empty($fpc_add_user))) {
            unset($this->fpc_add_user);
        } else {
            $this->fpc_add_user = $fpc_add_user;
        }
        
        return $this;
    }
    /**
     * Get fpc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_add_date(): ?string
    {
        return $this->fpc_add_date ?? null;
    }
    /**
     * Set fpc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_add_date(?string $fpc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_add_date) && !is_string($fpc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_add_date, true), gettype($fpc_add_date)), __LINE__);
        }
        if (is_null($fpc_add_date) || (is_array($fpc_add_date) && empty($fpc_add_date))) {
            unset($this->fpc_add_date);
        } else {
            $this->fpc_add_date = $fpc_add_date;
        }
        
        return $this;
    }
    /**
     * Get fpc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_change_user(): ?string
    {
        return $this->fpc_change_user ?? null;
    }
    /**
     * Set fpc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_change_user(?string $fpc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_change_user) && !is_string($fpc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_change_user, true), gettype($fpc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fpc_change_user) && mb_strlen((string) $fpc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $fpc_change_user)), __LINE__);
        }
        if (is_null($fpc_change_user) || (is_array($fpc_change_user) && empty($fpc_change_user))) {
            unset($this->fpc_change_user);
        } else {
            $this->fpc_change_user = $fpc_change_user;
        }
        
        return $this;
    }
    /**
     * Get fpc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_change_date(): ?string
    {
        return $this->fpc_change_date ?? null;
    }
    /**
     * Set fpc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_change_date(?string $fpc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_change_date) && !is_string($fpc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_change_date, true), gettype($fpc_change_date)), __LINE__);
        }
        if (is_null($fpc_change_date) || (is_array($fpc_change_date) && empty($fpc_change_date))) {
            unset($this->fpc_change_date);
        } else {
            $this->fpc_change_date = $fpc_change_date;
        }
        
        return $this;
    }
    /**
     * Get fpc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_delete_flag(): ?string
    {
        return $this->fpc_delete_flag ?? null;
    }
    /**
     * Set fpc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_delete_flag(?string $fpc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_delete_flag) && !is_string($fpc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_delete_flag, true), gettype($fpc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($fpc_delete_flag) && $fpc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($fpc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fpc_delete_flag) && $fpc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fpc_delete_flag, true)), __LINE__);
        }
        if (is_null($fpc_delete_flag) || (is_array($fpc_delete_flag) && empty($fpc_delete_flag))) {
            unset($this->fpc_delete_flag);
        } else {
            $this->fpc_delete_flag = $fpc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get fpc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_entity_key(): ?string
    {
        return $this->fpc_entity_key ?? null;
    }
    /**
     * Set fpc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_entity_key(?string $fpc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_entity_key) && !is_string($fpc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_entity_key, true), gettype($fpc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fpc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fpc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fpc_entity_key, true)), __LINE__);
        }
        if (is_null($fpc_entity_key) || (is_array($fpc_entity_key) && empty($fpc_entity_key))) {
            unset($this->fpc_entity_key);
        } else {
            $this->fpc_entity_key = $fpc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get fpc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_prd_key(): ?string
    {
        return $this->fpc_prd_key ?? null;
    }
    /**
     * Set fpc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_prd_key(?string $fpc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_prd_key) && !is_string($fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_prd_key, true), gettype($fpc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fpc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fpc_prd_key, true)), __LINE__);
        }
        if (is_null($fpc_prd_key) || (is_array($fpc_prd_key) && empty($fpc_prd_key))) {
            unset($this->fpc_prd_key);
        } else {
            $this->fpc_prd_key = $fpc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get fpc_fun_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_fun_key(): ?string
    {
        return $this->fpc_fun_key ?? null;
    }
    /**
     * Set fpc_fun_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_fun_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_fun_key(?string $fpc_fun_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_fun_key) && !is_string($fpc_fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_fun_key, true), gettype($fpc_fun_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fpc_fun_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fpc_fun_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fpc_fun_key, true)), __LINE__);
        }
        if (is_null($fpc_fun_key) || (is_array($fpc_fun_key) && empty($fpc_fun_key))) {
            unset($this->fpc_fun_key);
        } else {
            $this->fpc_fun_key = $fpc_fun_key;
        }
        
        return $this;
    }
    /**
     * Get fpc_cmp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_cmp_key(): ?string
    {
        return $this->fpc_cmp_key ?? null;
    }
    /**
     * Set fpc_cmp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_cmp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_cmp_key(?string $fpc_cmp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_cmp_key) && !is_string($fpc_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_cmp_key, true), gettype($fpc_cmp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fpc_cmp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fpc_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fpc_cmp_key, true)), __LINE__);
        }
        if (is_null($fpc_cmp_key) || (is_array($fpc_cmp_key) && empty($fpc_cmp_key))) {
            unset($this->fpc_cmp_key);
        } else {
            $this->fpc_cmp_key = $fpc_cmp_key;
        }
        
        return $this;
    }
    /**
     * Get fpc_apl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_apl_key(): ?string
    {
        return $this->fpc_apl_key ?? null;
    }
    /**
     * Set fpc_apl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_apl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_apl_key(?string $fpc_apl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_apl_key) && !is_string($fpc_apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_apl_key, true), gettype($fpc_apl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fpc_apl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fpc_apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fpc_apl_key, true)), __LINE__);
        }
        if (is_null($fpc_apl_key) || (is_array($fpc_apl_key) && empty($fpc_apl_key))) {
            unset($this->fpc_apl_key);
        } else {
            $this->fpc_apl_key = $fpc_apl_key;
        }
        
        return $this;
    }
    /**
     * Get fpc_pck_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_pck_key(): ?string
    {
        return $this->fpc_pck_key ?? null;
    }
    /**
     * Set fpc_pck_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_pck_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_pck_key(?string $fpc_pck_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_pck_key) && !is_string($fpc_pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_pck_key, true), gettype($fpc_pck_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fpc_pck_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fpc_pck_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fpc_pck_key, true)), __LINE__);
        }
        if (is_null($fpc_pck_key) || (is_array($fpc_pck_key) && empty($fpc_pck_key))) {
            unset($this->fpc_pck_key);
        } else {
            $this->fpc_pck_key = $fpc_pck_key;
        }
        
        return $this;
    }
    /**
     * Get fpc_track_recognition_level_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_track_recognition_level_flag(): ?string
    {
        return $this->fpc_track_recognition_level_flag ?? null;
    }
    /**
     * Set fpc_track_recognition_level_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_track_recognition_level_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_track_recognition_level_flag(?string $fpc_track_recognition_level_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_track_recognition_level_flag) && !is_string($fpc_track_recognition_level_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_track_recognition_level_flag, true), gettype($fpc_track_recognition_level_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($fpc_track_recognition_level_flag) && $fpc_track_recognition_level_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($fpc_track_recognition_level_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fpc_track_recognition_level_flag) && $fpc_track_recognition_level_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fpc_track_recognition_level_flag, true)), __LINE__);
        }
        if (is_null($fpc_track_recognition_level_flag) || (is_array($fpc_track_recognition_level_flag) && empty($fpc_track_recognition_level_flag))) {
            unset($this->fpc_track_recognition_level_flag);
        } else {
            $this->fpc_track_recognition_level_flag = $fpc_track_recognition_level_flag;
        }
        
        return $this;
    }
    /**
     * Get fpc_event_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_event_flag(): ?string
    {
        return $this->fpc_event_flag ?? null;
    }
    /**
     * Set fpc_event_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_event_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_event_flag(?string $fpc_event_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_event_flag) && !is_string($fpc_event_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_event_flag, true), gettype($fpc_event_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($fpc_event_flag) && $fpc_event_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($fpc_event_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fpc_event_flag) && $fpc_event_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fpc_event_flag, true)), __LINE__);
        }
        if (is_null($fpc_event_flag) || (is_array($fpc_event_flag) && empty($fpc_event_flag))) {
            unset($this->fpc_event_flag);
        } else {
            $this->fpc_event_flag = $fpc_event_flag;
        }
        
        return $this;
    }
    /**
     * Get fpc_prd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_prd_key_ext(): ?string
    {
        return $this->fpc_prd_key_ext ?? null;
    }
    /**
     * Set fpc_prd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_prd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_prd_key_ext(?string $fpc_prd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_prd_key_ext) && !is_string($fpc_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_prd_key_ext, true), gettype($fpc_prd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fpc_prd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fpc_prd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fpc_prd_key_ext, true)), __LINE__);
        }
        if (is_null($fpc_prd_key_ext) || (is_array($fpc_prd_key_ext) && empty($fpc_prd_key_ext))) {
            unset($this->fpc_prd_key_ext);
        } else {
            $this->fpc_prd_key_ext = $fpc_prd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get fpc_funds_raised value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFpc_funds_raised(): ?float
    {
        return $this->fpc_funds_raised ?? null;
    }
    /**
     * Set fpc_funds_raised value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fpc_funds_raised
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_funds_raised(?float $fpc_funds_raised = null): self
    {
        // validation for constraint: float
        if (!is_null($fpc_funds_raised) && !(is_float($fpc_funds_raised) || is_numeric($fpc_funds_raised))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fpc_funds_raised, true), gettype($fpc_funds_raised)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($fpc_funds_raised) && mb_strlen(mb_substr((string) $fpc_funds_raised, false !== mb_strpos((string) $fpc_funds_raised, '.') ? mb_strpos((string) $fpc_funds_raised, '.') + 1 : mb_strlen((string) $fpc_funds_raised))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($fpc_funds_raised, true), mb_strlen(mb_substr((string) $fpc_funds_raised, mb_strpos((string) $fpc_funds_raised, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($fpc_funds_raised) && mb_strlen(preg_replace('/(\D)/', '', (string) $fpc_funds_raised)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($fpc_funds_raised, true), mb_strlen(preg_replace('/(\D)/', '', (string) $fpc_funds_raised))), __LINE__);
        }
        if (is_null($fpc_funds_raised) || (is_array($fpc_funds_raised) && empty($fpc_funds_raised))) {
            unset($this->fpc_funds_raised);
        } else {
            $this->fpc_funds_raised = $fpc_funds_raised;
        }
        
        return $this;
    }
    /**
     * Get fpc_funds_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFpc_funds_goal(): ?float
    {
        return $this->fpc_funds_goal ?? null;
    }
    /**
     * Set fpc_funds_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fpc_funds_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_funds_goal(?float $fpc_funds_goal = null): self
    {
        // validation for constraint: float
        if (!is_null($fpc_funds_goal) && !(is_float($fpc_funds_goal) || is_numeric($fpc_funds_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fpc_funds_goal, true), gettype($fpc_funds_goal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($fpc_funds_goal) && mb_strlen(mb_substr((string) $fpc_funds_goal, false !== mb_strpos((string) $fpc_funds_goal, '.') ? mb_strpos((string) $fpc_funds_goal, '.') + 1 : mb_strlen((string) $fpc_funds_goal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($fpc_funds_goal, true), mb_strlen(mb_substr((string) $fpc_funds_goal, mb_strpos((string) $fpc_funds_goal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($fpc_funds_goal) && mb_strlen(preg_replace('/(\D)/', '', (string) $fpc_funds_goal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($fpc_funds_goal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $fpc_funds_goal))), __LINE__);
        }
        if (is_null($fpc_funds_goal) || (is_array($fpc_funds_goal) && empty($fpc_funds_goal))) {
            unset($this->fpc_funds_goal);
        } else {
            $this->fpc_funds_goal = $fpc_funds_goal;
        }
        
        return $this;
    }
    /**
     * Get fpc_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_start_date(): ?string
    {
        return $this->fpc_start_date ?? null;
    }
    /**
     * Set fpc_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_start_date(?string $fpc_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_start_date) && !is_string($fpc_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_start_date, true), gettype($fpc_start_date)), __LINE__);
        }
        if (is_null($fpc_start_date) || (is_array($fpc_start_date) && empty($fpc_start_date))) {
            unset($this->fpc_start_date);
        } else {
            $this->fpc_start_date = $fpc_start_date;
        }
        
        return $this;
    }
    /**
     * Get fpc_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_end_date(): ?string
    {
        return $this->fpc_end_date ?? null;
    }
    /**
     * Set fpc_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_end_date(?string $fpc_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_end_date) && !is_string($fpc_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_end_date, true), gettype($fpc_end_date)), __LINE__);
        }
        if (is_null($fpc_end_date) || (is_array($fpc_end_date) && empty($fpc_end_date))) {
            unset($this->fpc_end_date);
        } else {
            $this->fpc_end_date = $fpc_end_date;
        }
        
        return $this;
    }
    /**
     * Get fpc_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_notes(): ?string
    {
        return $this->fpc_notes ?? null;
    }
    /**
     * Set fpc_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_notes(?string $fpc_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_notes) && !is_string($fpc_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_notes, true), gettype($fpc_notes)), __LINE__);
        }
        if (is_null($fpc_notes) || (is_array($fpc_notes) && empty($fpc_notes))) {
            unset($this->fpc_notes);
        } else {
            $this->fpc_notes = $fpc_notes;
        }
        
        return $this;
    }
    /**
     * Get fpc_active_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFpc_active_flag(): ?string
    {
        return $this->fpc_active_flag ?? null;
    }
    /**
     * Set fpc_active_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fpc_active_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Product_Code_DataObjectType
     */
    public function setFpc_active_flag(?string $fpc_active_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($fpc_active_flag) && !is_string($fpc_active_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fpc_active_flag, true), gettype($fpc_active_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($fpc_active_flag) && $fpc_active_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($fpc_active_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fpc_active_flag) && $fpc_active_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fpc_active_flag, true)), __LINE__);
        }
        if (is_null($fpc_active_flag) || (is_array($fpc_active_flag) && empty($fpc_active_flag))) {
            unset($this->fpc_active_flag);
        } else {
            $this->fpc_active_flag = $fpc_active_flag;
        }
        
        return $this;
    }
}
