<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Recogntion_Type_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Recogntion_Type_DataObjectType extends AbstractStructBase
{
    /**
     * The frt_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $frt_key = null;
    /**
     * The frt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $frt_add_user = null;
    /**
     * The frt_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $frt_add_date = null;
    /**
     * The frt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $frt_change_user = null;
    /**
     * The frt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $frt_change_date = null;
    /**
     * The frt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $frt_delete_flag = null;
    /**
     * The frt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $frt_entity_key = null;
    /**
     * The frt_code
     * Meta information extracted from the WSDL
     * - documentation: Recognition Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $frt_code = null;
    /**
     * The frt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $frt_key_ext = null;
    /**
     * Constructor method for FundraisingGift_Recogntion_Type_DataObjectType
     * @uses FundraisingGift_Recogntion_Type_DataObjectType::setFrt_key()
     * @uses FundraisingGift_Recogntion_Type_DataObjectType::setFrt_add_user()
     * @uses FundraisingGift_Recogntion_Type_DataObjectType::setFrt_add_date()
     * @uses FundraisingGift_Recogntion_Type_DataObjectType::setFrt_change_user()
     * @uses FundraisingGift_Recogntion_Type_DataObjectType::setFrt_change_date()
     * @uses FundraisingGift_Recogntion_Type_DataObjectType::setFrt_delete_flag()
     * @uses FundraisingGift_Recogntion_Type_DataObjectType::setFrt_entity_key()
     * @uses FundraisingGift_Recogntion_Type_DataObjectType::setFrt_code()
     * @uses FundraisingGift_Recogntion_Type_DataObjectType::setFrt_key_ext()
     * @param string $frt_key
     * @param string $frt_add_user
     * @param string $frt_add_date
     * @param string $frt_change_user
     * @param string $frt_change_date
     * @param string $frt_delete_flag
     * @param string $frt_entity_key
     * @param string $frt_code
     * @param string $frt_key_ext
     */
    public function __construct(?string $frt_key = null, ?string $frt_add_user = null, ?string $frt_add_date = null, ?string $frt_change_user = null, ?string $frt_change_date = null, ?string $frt_delete_flag = null, ?string $frt_entity_key = null, ?string $frt_code = null, ?string $frt_key_ext = null)
    {
        $this
            ->setFrt_key($frt_key)
            ->setFrt_add_user($frt_add_user)
            ->setFrt_add_date($frt_add_date)
            ->setFrt_change_user($frt_change_user)
            ->setFrt_change_date($frt_change_date)
            ->setFrt_delete_flag($frt_delete_flag)
            ->setFrt_entity_key($frt_entity_key)
            ->setFrt_code($frt_code)
            ->setFrt_key_ext($frt_key_ext);
    }
    /**
     * Get frt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrt_key(): ?string
    {
        return $this->frt_key ?? null;
    }
    /**
     * Set frt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Recogntion_Type_DataObjectType
     */
    public function setFrt_key(?string $frt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($frt_key) && !is_string($frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frt_key, true), gettype($frt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($frt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($frt_key, true)), __LINE__);
        }
        if (is_null($frt_key) || (is_array($frt_key) && empty($frt_key))) {
            unset($this->frt_key);
        } else {
            $this->frt_key = $frt_key;
        }
        
        return $this;
    }
    /**
     * Get frt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrt_add_user(): ?string
    {
        return $this->frt_add_user ?? null;
    }
    /**
     * Set frt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Recogntion_Type_DataObjectType
     */
    public function setFrt_add_user(?string $frt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($frt_add_user) && !is_string($frt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frt_add_user, true), gettype($frt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($frt_add_user) && mb_strlen((string) $frt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $frt_add_user)), __LINE__);
        }
        if (is_null($frt_add_user) || (is_array($frt_add_user) && empty($frt_add_user))) {
            unset($this->frt_add_user);
        } else {
            $this->frt_add_user = $frt_add_user;
        }
        
        return $this;
    }
    /**
     * Get frt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrt_add_date(): ?string
    {
        return $this->frt_add_date ?? null;
    }
    /**
     * Set frt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Recogntion_Type_DataObjectType
     */
    public function setFrt_add_date(?string $frt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($frt_add_date) && !is_string($frt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frt_add_date, true), gettype($frt_add_date)), __LINE__);
        }
        if (is_null($frt_add_date) || (is_array($frt_add_date) && empty($frt_add_date))) {
            unset($this->frt_add_date);
        } else {
            $this->frt_add_date = $frt_add_date;
        }
        
        return $this;
    }
    /**
     * Get frt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrt_change_user(): ?string
    {
        return $this->frt_change_user ?? null;
    }
    /**
     * Set frt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Recogntion_Type_DataObjectType
     */
    public function setFrt_change_user(?string $frt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($frt_change_user) && !is_string($frt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frt_change_user, true), gettype($frt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($frt_change_user) && mb_strlen((string) $frt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $frt_change_user)), __LINE__);
        }
        if (is_null($frt_change_user) || (is_array($frt_change_user) && empty($frt_change_user))) {
            unset($this->frt_change_user);
        } else {
            $this->frt_change_user = $frt_change_user;
        }
        
        return $this;
    }
    /**
     * Get frt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrt_change_date(): ?string
    {
        return $this->frt_change_date ?? null;
    }
    /**
     * Set frt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Recogntion_Type_DataObjectType
     */
    public function setFrt_change_date(?string $frt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($frt_change_date) && !is_string($frt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frt_change_date, true), gettype($frt_change_date)), __LINE__);
        }
        if (is_null($frt_change_date) || (is_array($frt_change_date) && empty($frt_change_date))) {
            unset($this->frt_change_date);
        } else {
            $this->frt_change_date = $frt_change_date;
        }
        
        return $this;
    }
    /**
     * Get frt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrt_delete_flag(): ?string
    {
        return $this->frt_delete_flag ?? null;
    }
    /**
     * Set frt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Recogntion_Type_DataObjectType
     */
    public function setFrt_delete_flag(?string $frt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($frt_delete_flag) && !is_string($frt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frt_delete_flag, true), gettype($frt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($frt_delete_flag) && $frt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($frt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($frt_delete_flag) && $frt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($frt_delete_flag, true)), __LINE__);
        }
        if (is_null($frt_delete_flag) || (is_array($frt_delete_flag) && empty($frt_delete_flag))) {
            unset($this->frt_delete_flag);
        } else {
            $this->frt_delete_flag = $frt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get frt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrt_entity_key(): ?string
    {
        return $this->frt_entity_key ?? null;
    }
    /**
     * Set frt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Recogntion_Type_DataObjectType
     */
    public function setFrt_entity_key(?string $frt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($frt_entity_key) && !is_string($frt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frt_entity_key, true), gettype($frt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($frt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $frt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($frt_entity_key, true)), __LINE__);
        }
        if (is_null($frt_entity_key) || (is_array($frt_entity_key) && empty($frt_entity_key))) {
            unset($this->frt_entity_key);
        } else {
            $this->frt_entity_key = $frt_entity_key;
        }
        
        return $this;
    }
    /**
     * Get frt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrt_code(): ?string
    {
        return $this->frt_code ?? null;
    }
    /**
     * Set frt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Recogntion_Type_DataObjectType
     */
    public function setFrt_code(?string $frt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($frt_code) && !is_string($frt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frt_code, true), gettype($frt_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($frt_code) && mb_strlen((string) $frt_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $frt_code)), __LINE__);
        }
        if (is_null($frt_code) || (is_array($frt_code) && empty($frt_code))) {
            unset($this->frt_code);
        } else {
            $this->frt_code = $frt_code;
        }
        
        return $this;
    }
    /**
     * Get frt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrt_key_ext(): ?string
    {
        return $this->frt_key_ext ?? null;
    }
    /**
     * Set frt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Recogntion_Type_DataObjectType
     */
    public function setFrt_key_ext(?string $frt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($frt_key_ext) && !is_string($frt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frt_key_ext, true), gettype($frt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($frt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $frt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($frt_key_ext, true)), __LINE__);
        }
        if (is_null($frt_key_ext) || (is_array($frt_key_ext) && empty($frt_key_ext))) {
            unset($this->frt_key_ext);
        } else {
            $this->frt_key_ext = $frt_key_ext;
        }
        
        return $this;
    }
}
