<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Tribute_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Tribute_DataObjectType extends AbstractStructBase
{
    /**
     * The tbt_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $tbt_key = null;
    /**
     * The tbt_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Honoree. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $tbt_cst_key = null;
    /**
     * The tbt_description
     * Meta information extracted from the WSDL
     * - documentation: Detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $tbt_description = null;
    /**
     * The tbt_frt_key
     * Meta information extracted from the WSDL
     * - documentation: Recognition Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $tbt_frt_key = null;
    /**
     * The tbt_fpc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Fund. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $tbt_fpc_prd_key = null;
    /**
     * The tbt_tbc_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $tbt_tbc_key = null;
    /**
     * The tbt_note
     * Meta information extracted from the WSDL
     * - documentation: Internal Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $tbt_note = null;
    /**
     * The tbt_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $tbt_cct_key = null;
    /**
     * The tbt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $tbt_add_user = null;
    /**
     * The tbt_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $tbt_add_date = null;
    /**
     * The tbt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $tbt_change_user = null;
    /**
     * The tbt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $tbt_change_date = null;
    /**
     * The tbt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $tbt_delete_flag = null;
    /**
     * The tbt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $tbt_entity_key = null;
    /**
     * The tbt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $tbt_key_ext = null;
    /**
     * Constructor method for FundraisingGift_Tribute_DataObjectType
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_key()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_cst_key()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_description()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_frt_key()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_fpc_prd_key()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_tbc_key()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_note()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_cct_key()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_add_user()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_add_date()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_change_user()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_change_date()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_delete_flag()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_entity_key()
     * @uses FundraisingGift_Tribute_DataObjectType::setTbt_key_ext()
     * @param string $tbt_key
     * @param string $tbt_cst_key
     * @param string $tbt_description
     * @param string $tbt_frt_key
     * @param string $tbt_fpc_prd_key
     * @param string $tbt_tbc_key
     * @param string $tbt_note
     * @param string $tbt_cct_key
     * @param string $tbt_add_user
     * @param string $tbt_add_date
     * @param string $tbt_change_user
     * @param string $tbt_change_date
     * @param string $tbt_delete_flag
     * @param string $tbt_entity_key
     * @param string $tbt_key_ext
     */
    public function __construct(?string $tbt_key = null, ?string $tbt_cst_key = null, ?string $tbt_description = null, ?string $tbt_frt_key = null, ?string $tbt_fpc_prd_key = null, ?string $tbt_tbc_key = null, ?string $tbt_note = null, ?string $tbt_cct_key = null, ?string $tbt_add_user = null, ?string $tbt_add_date = null, ?string $tbt_change_user = null, ?string $tbt_change_date = null, ?string $tbt_delete_flag = null, ?string $tbt_entity_key = null, ?string $tbt_key_ext = null)
    {
        $this
            ->setTbt_key($tbt_key)
            ->setTbt_cst_key($tbt_cst_key)
            ->setTbt_description($tbt_description)
            ->setTbt_frt_key($tbt_frt_key)
            ->setTbt_fpc_prd_key($tbt_fpc_prd_key)
            ->setTbt_tbc_key($tbt_tbc_key)
            ->setTbt_note($tbt_note)
            ->setTbt_cct_key($tbt_cct_key)
            ->setTbt_add_user($tbt_add_user)
            ->setTbt_add_date($tbt_add_date)
            ->setTbt_change_user($tbt_change_user)
            ->setTbt_change_date($tbt_change_date)
            ->setTbt_delete_flag($tbt_delete_flag)
            ->setTbt_entity_key($tbt_entity_key)
            ->setTbt_key_ext($tbt_key_ext);
    }
    /**
     * Get tbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_key(): ?string
    {
        return $this->tbt_key ?? null;
    }
    /**
     * Set tbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_key(?string $tbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_key) && !is_string($tbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_key, true), gettype($tbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($tbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $tbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($tbt_key, true)), __LINE__);
        }
        if (is_null($tbt_key) || (is_array($tbt_key) && empty($tbt_key))) {
            unset($this->tbt_key);
        } else {
            $this->tbt_key = $tbt_key;
        }
        
        return $this;
    }
    /**
     * Get tbt_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_cst_key(): ?string
    {
        return $this->tbt_cst_key ?? null;
    }
    /**
     * Set tbt_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_cst_key(?string $tbt_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_cst_key) && !is_string($tbt_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_cst_key, true), gettype($tbt_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($tbt_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $tbt_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($tbt_cst_key, true)), __LINE__);
        }
        if (is_null($tbt_cst_key) || (is_array($tbt_cst_key) && empty($tbt_cst_key))) {
            unset($this->tbt_cst_key);
        } else {
            $this->tbt_cst_key = $tbt_cst_key;
        }
        
        return $this;
    }
    /**
     * Get tbt_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_description(): ?string
    {
        return $this->tbt_description ?? null;
    }
    /**
     * Set tbt_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_description(?string $tbt_description = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_description) && !is_string($tbt_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_description, true), gettype($tbt_description)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($tbt_description) && mb_strlen((string) $tbt_description) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $tbt_description)), __LINE__);
        }
        if (is_null($tbt_description) || (is_array($tbt_description) && empty($tbt_description))) {
            unset($this->tbt_description);
        } else {
            $this->tbt_description = $tbt_description;
        }
        
        return $this;
    }
    /**
     * Get tbt_frt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_frt_key(): ?string
    {
        return $this->tbt_frt_key ?? null;
    }
    /**
     * Set tbt_frt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_frt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_frt_key(?string $tbt_frt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_frt_key) && !is_string($tbt_frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_frt_key, true), gettype($tbt_frt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($tbt_frt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $tbt_frt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($tbt_frt_key, true)), __LINE__);
        }
        if (is_null($tbt_frt_key) || (is_array($tbt_frt_key) && empty($tbt_frt_key))) {
            unset($this->tbt_frt_key);
        } else {
            $this->tbt_frt_key = $tbt_frt_key;
        }
        
        return $this;
    }
    /**
     * Get tbt_fpc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_fpc_prd_key(): ?string
    {
        return $this->tbt_fpc_prd_key ?? null;
    }
    /**
     * Set tbt_fpc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_fpc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_fpc_prd_key(?string $tbt_fpc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_fpc_prd_key) && !is_string($tbt_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_fpc_prd_key, true), gettype($tbt_fpc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($tbt_fpc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $tbt_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($tbt_fpc_prd_key, true)), __LINE__);
        }
        if (is_null($tbt_fpc_prd_key) || (is_array($tbt_fpc_prd_key) && empty($tbt_fpc_prd_key))) {
            unset($this->tbt_fpc_prd_key);
        } else {
            $this->tbt_fpc_prd_key = $tbt_fpc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get tbt_tbc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_tbc_key(): ?string
    {
        return $this->tbt_tbc_key ?? null;
    }
    /**
     * Set tbt_tbc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_tbc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_tbc_key(?string $tbt_tbc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_tbc_key) && !is_string($tbt_tbc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_tbc_key, true), gettype($tbt_tbc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($tbt_tbc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $tbt_tbc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($tbt_tbc_key, true)), __LINE__);
        }
        if (is_null($tbt_tbc_key) || (is_array($tbt_tbc_key) && empty($tbt_tbc_key))) {
            unset($this->tbt_tbc_key);
        } else {
            $this->tbt_tbc_key = $tbt_tbc_key;
        }
        
        return $this;
    }
    /**
     * Get tbt_note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_note(): ?string
    {
        return $this->tbt_note ?? null;
    }
    /**
     * Set tbt_note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_note
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_note(?string $tbt_note = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_note) && !is_string($tbt_note)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_note, true), gettype($tbt_note)), __LINE__);
        }
        if (is_null($tbt_note) || (is_array($tbt_note) && empty($tbt_note))) {
            unset($this->tbt_note);
        } else {
            $this->tbt_note = $tbt_note;
        }
        
        return $this;
    }
    /**
     * Get tbt_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_cct_key(): ?string
    {
        return $this->tbt_cct_key ?? null;
    }
    /**
     * Set tbt_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_cct_key(?string $tbt_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_cct_key) && !is_string($tbt_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_cct_key, true), gettype($tbt_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($tbt_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $tbt_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($tbt_cct_key, true)), __LINE__);
        }
        if (is_null($tbt_cct_key) || (is_array($tbt_cct_key) && empty($tbt_cct_key))) {
            unset($this->tbt_cct_key);
        } else {
            $this->tbt_cct_key = $tbt_cct_key;
        }
        
        return $this;
    }
    /**
     * Get tbt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_add_user(): ?string
    {
        return $this->tbt_add_user ?? null;
    }
    /**
     * Set tbt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_add_user(?string $tbt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_add_user) && !is_string($tbt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_add_user, true), gettype($tbt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($tbt_add_user) && mb_strlen((string) $tbt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $tbt_add_user)), __LINE__);
        }
        if (is_null($tbt_add_user) || (is_array($tbt_add_user) && empty($tbt_add_user))) {
            unset($this->tbt_add_user);
        } else {
            $this->tbt_add_user = $tbt_add_user;
        }
        
        return $this;
    }
    /**
     * Get tbt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_add_date(): ?string
    {
        return $this->tbt_add_date ?? null;
    }
    /**
     * Set tbt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_add_date(?string $tbt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_add_date) && !is_string($tbt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_add_date, true), gettype($tbt_add_date)), __LINE__);
        }
        if (is_null($tbt_add_date) || (is_array($tbt_add_date) && empty($tbt_add_date))) {
            unset($this->tbt_add_date);
        } else {
            $this->tbt_add_date = $tbt_add_date;
        }
        
        return $this;
    }
    /**
     * Get tbt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_change_user(): ?string
    {
        return $this->tbt_change_user ?? null;
    }
    /**
     * Set tbt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_change_user(?string $tbt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_change_user) && !is_string($tbt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_change_user, true), gettype($tbt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($tbt_change_user) && mb_strlen((string) $tbt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $tbt_change_user)), __LINE__);
        }
        if (is_null($tbt_change_user) || (is_array($tbt_change_user) && empty($tbt_change_user))) {
            unset($this->tbt_change_user);
        } else {
            $this->tbt_change_user = $tbt_change_user;
        }
        
        return $this;
    }
    /**
     * Get tbt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_change_date(): ?string
    {
        return $this->tbt_change_date ?? null;
    }
    /**
     * Set tbt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_change_date(?string $tbt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_change_date) && !is_string($tbt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_change_date, true), gettype($tbt_change_date)), __LINE__);
        }
        if (is_null($tbt_change_date) || (is_array($tbt_change_date) && empty($tbt_change_date))) {
            unset($this->tbt_change_date);
        } else {
            $this->tbt_change_date = $tbt_change_date;
        }
        
        return $this;
    }
    /**
     * Get tbt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_delete_flag(): ?string
    {
        return $this->tbt_delete_flag ?? null;
    }
    /**
     * Set tbt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_delete_flag(?string $tbt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_delete_flag) && !is_string($tbt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_delete_flag, true), gettype($tbt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($tbt_delete_flag) && $tbt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($tbt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($tbt_delete_flag) && $tbt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($tbt_delete_flag, true)), __LINE__);
        }
        if (is_null($tbt_delete_flag) || (is_array($tbt_delete_flag) && empty($tbt_delete_flag))) {
            unset($this->tbt_delete_flag);
        } else {
            $this->tbt_delete_flag = $tbt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get tbt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_entity_key(): ?string
    {
        return $this->tbt_entity_key ?? null;
    }
    /**
     * Set tbt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_entity_key(?string $tbt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_entity_key) && !is_string($tbt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_entity_key, true), gettype($tbt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($tbt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $tbt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($tbt_entity_key, true)), __LINE__);
        }
        if (is_null($tbt_entity_key) || (is_array($tbt_entity_key) && empty($tbt_entity_key))) {
            unset($this->tbt_entity_key);
        } else {
            $this->tbt_entity_key = $tbt_entity_key;
        }
        
        return $this;
    }
    /**
     * Get tbt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTbt_key_ext(): ?string
    {
        return $this->tbt_key_ext ?? null;
    }
    /**
     * Set tbt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tbt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Tribute_DataObjectType
     */
    public function setTbt_key_ext(?string $tbt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($tbt_key_ext) && !is_string($tbt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbt_key_ext, true), gettype($tbt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($tbt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $tbt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($tbt_key_ext, true)), __LINE__);
        }
        if (is_null($tbt_key_ext) || (is_array($tbt_key_ext) && empty($tbt_key_ext))) {
            unset($this->tbt_key_ext);
        } else {
            $this->tbt_key_ext = $tbt_key_ext;
        }
        
        return $this;
    }
}
